/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot;

import java.io.Serializable;
import java.util.ArrayList;
import megamek.client.bot.AttackOption;
import megamek.client.bot.CEntity;
import megamek.client.bot.TestBot;
import megamek.client.bot.ga.Chromosome;
import megamek.client.bot.ga.GA;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Mech;

public class GAAttack
extends GA {
    protected ArrayList attack;
    protected CEntity attacker;
    protected IGame game;
    protected CEntity.Table targets;
    protected ArrayList target_array = null;
    protected ArrayList valid_target_indexes = null;
    protected boolean overheat_eligible = false;
    protected int firing_arc = 0;
    double[] damages = null;

    public GAAttack(TestBot testBot, CEntity cEntity, ArrayList arrayList, int n, int n2, boolean bl) {
        super(arrayList.size() + 1, n, 0.7, 0.05, n2, 0.4);
        this.attack = arrayList;
        this.attacker = cEntity;
        this.game = testBot.game;
        this.target_array = new ArrayList(this.game.getEntitiesVector());
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < this.target_array.size(); ++i) {
            Entity entity = (Entity)this.target_array.get(i);
            if (!entity.isEnemyOf(cEntity.entity) || !entity.isDeployed()) continue;
            arrayList2.add(new Integer(i));
        }
        this.targets = new CEntity.Table(testBot);
        this.valid_target_indexes = arrayList2;
        if (cEntity.tsm_offset) {
            this.overheat_eligible = true;
        }
        if (bl || cEntity.last != null && (!cEntity.last.inDanger || cEntity.last.doomed)) {
            this.overheat_eligible = true;
        }
    }

    public int[] getResultChromosome() {
        return this.chromosomes[this.populationDim - 1].genes;
    }

    public double getDamageUtility(CEntity cEntity) {
        if (this.damages == null) {
            this.damages = this.getDamageUtilities();
        }
        for (int i = 0; i < this.target_array.size(); ++i) {
            Entity entity = (Entity)this.target_array.get(i);
            if (entity.getId() != cEntity.entity.getId()) continue;
            return this.damages[i];
        }
        return 0.0;
    }

    public double[] getDamageUtilities() {
        Serializable serializable;
        int n;
        int n2 = this.populationDim - 1;
        this.targets.clear();
        double[] dArray = new double[this.target_array.size()];
        Chromosome chromosome = this.chromosomes[n2];
        int n3 = 0;
        if (chromosome.genes[this.chromosomeDim - 1] >= this.target_array.size()) {
            chromosome.genes[this.chromosomeDim - 1] = (Integer)this.valid_target_indexes.get(0);
        }
        Entity entity = (Entity)this.target_array.get(chromosome.genes[this.chromosomeDim - 1]);
        for (n = 0; n < this.chromosomeDim - 1; ++n) {
            serializable = (AttackOption)((ArrayList)this.attack.get(n)).get(chromosome.genes[n]);
            if (((AttackOption)serializable).target == null) continue;
            this.targets.put(((AttackOption)serializable).target);
            double d = 1.0;
            if (((AttackOption)serializable).target.entity.getId() == entity.getId()) {
                int n4 = ((AttackOption)serializable).toHit.getSideTable();
                ((AttackOption)serializable).target.possible_damage[n4] = ((AttackOption)serializable).target.possible_damage[n4] + d * ((AttackOption)serializable).primary_expected;
            } else {
                int n5 = ((AttackOption)serializable).toHit.getSideTable();
                ((AttackOption)serializable).target.possible_damage[n5] = ((AttackOption)serializable).target.possible_damage[n5] + d * ((AttackOption)serializable).expected;
            }
            n3 += ((AttackOption)serializable).heat;
        }
        for (n = 0; n < this.target_array.size(); ++n) {
            serializable = (Entity)this.target_array.get(n);
            CEntity cEntity = null;
            dArray[n] = 0.0;
            cEntity = (CEntity)this.targets.get(new Integer(((Entity)serializable).getId()));
            if (cEntity == null) continue;
            dArray[n] = this.getThreadUtility(cEntity);
            cEntity.resetPossibleDamage();
        }
        return dArray;
    }

    private double getThreadUtility(CEntity cEntity) {
        if (cEntity.possible_damage[0] > 0.0) {
            return cEntity.getThreatUtility(cEntity.possible_damage[0], 0);
        }
        if (cEntity.possible_damage[1] > 0.0) {
            return cEntity.getThreatUtility(cEntity.possible_damage[1], 1);
        }
        if (cEntity.possible_damage[2] > 0.0) {
            return cEntity.getThreatUtility(cEntity.possible_damage[2], 2);
        }
        if (cEntity.possible_damage[3] > 0.0) {
            return cEntity.getThreatUtility(cEntity.possible_damage[3], 3);
        }
        return 0.0;
    }

    protected double getFitness(int n) {
        return this.getFitness(this.chromosomes[n]);
    }

    protected double getFitness(Chromosome chromosome) {
        Object object;
        this.targets.clear();
        int n = 0;
        Entity entity = null;
        try {
            entity = (Entity)this.target_array.get(chromosome.genes[this.chromosomeDim - 1]);
        }
        catch (Exception exception) {
            System.out.println(this.chromosomeDim + " " + chromosome.genes.length);
            System.out.println(this.target_array.size());
            entity = (Entity)this.target_array.get((Integer)this.valid_target_indexes.get(0));
        }
        for (int i = 0; i < this.chromosomeDim - 1; ++i) {
            int[] nArray = chromosome.genes;
            object = (AttackOption)((ArrayList)this.attack.get(i)).get(nArray[i]);
            if (((AttackOption)object).target == null) continue;
            this.targets.put(((AttackOption)object).target);
            double d = 1.0;
            if (((AttackOption)object).primary_odds <= 0.0) {
                d = 0.0;
            } else if (((AttackOption)object).ammoLeft != -1) {
                if (this.attacker.overall_armor_percent < 0.5) {
                    d = 1.5;
                } else if (((AttackOption)object).ammoLeft < 12 && this.attacker.overall_armor_percent > 0.75) {
                    d = ((AttackOption)object).primary_odds < 0.1 ? 0.0 : (((AttackOption)object).ammoLeft < 6 && ((AttackOption)object).primary_odds < 0.25 ? 0.0 : ((AttackOption)object).primary_odds);
                }
            }
            if (((AttackOption)object).target.entity.getId() == entity.getId()) {
                int n2 = ((AttackOption)object).toHit.getSideTable();
                ((AttackOption)object).target.possible_damage[n2] = ((AttackOption)object).target.possible_damage[n2] + d * ((AttackOption)object).primary_expected;
            } else {
                int n3 = ((AttackOption)object).toHit.getSideTable();
                ((AttackOption)object).target.possible_damage[n3] = ((AttackOption)object).target.possible_damage[n3] + d * ((AttackOption)object).expected;
            }
            n += ((AttackOption)object).heat;
        }
        double d = 0.0;
        object = this.targets.values().iterator();
        while (object.hasNext()) {
            CEntity cEntity = (CEntity)object.next();
            d += this.getThreadUtility(cEntity);
            cEntity.resetPossibleDamage();
        }
        int n4 = this.attacker.entity.getHeatCapacityWithWater();
        int n5 = this.attacker.entity.heatBuildup + this.attacker.entity.heat;
        int n6 = n5 + n - n4;
        if (this.attacker.entity instanceof Mech && ((Mech)this.attacker.entity).isStealthActive()) {
            n6 += 10;
        }
        if (this.attacker.entity.infernos.isStillBurning()) {
            n6 += 6;
        }
        if (this.game.getBoard().getHex(this.attacker.entity.getPosition()) != null && this.game.getBoard().getHex(this.attacker.entity.getPosition()).terrainLevel(7) == 2) {
            n6 += 5;
        }
        if (this.attacker.entity instanceof Mech) {
            n6 += this.attacker.entity.getEngineCritHeat();
        }
        if (this.attacker.entity.heat > 0 && (n6 += this.game.getTemperatureDifference()) < 0) {
            d -= (double)(this.attacker.bv / 1000 * n6);
            if (this.attacker.entity.heat > 4) {
                d *= 1.2;
            }
            if (this.attacker.entity.heat > 7) {
                d += (double)(this.attacker.bv / 50);
            }
            if (this.attacker.tsm_offset) {
                if (this.attacker.entity.heat == 9) {
                    d -= (double)(this.attacker.bv / 10);
                }
                if (this.attacker.entity.heat < 12 && this.attacker.entity.heat > 9) {
                    d -= (double)(this.attacker.bv / 20);
                }
            }
            if (this.attacker.entity.heat > 12) {
                d += (double)(this.attacker.bv / 20);
            }
            if (this.attacker.entity.heat > 16) {
                d += (double)(this.attacker.bv / 10);
            }
        } else if (n6 > 0) {
            if (n6 > 4 && !this.attacker.tsm_offset) {
                d *= this.overheat_eligible && this.attacker.jumpMP > 2 ? 0.9 : 0.85;
            }
            if (n6 > 7 && !this.attacker.tsm_offset) {
                double d2;
                double d3 = this.overheat_eligible ? (double)(this.attacker.jumpMP > 2 ? 0 : 10) : (d2 = 40.0);
                d = this.attacker.overheat > 1 ? (d -= (double)this.attacker.bv / d2) : (d -= (double)this.attacker.bv / (d2 + 10.0));
            }
            if (this.attacker.tsm_offset) {
                if (n6 == 9) {
                    d += (double)(this.attacker.bv / 10);
                }
                if (this.attacker.entity.heat < 12 && this.attacker.entity.heat > 9) {
                    d += (double)(this.attacker.bv / 20);
                }
            }
            if (n6 > 12) {
                d -= (double)(this.attacker.bv / (this.overheat_eligible ? 45 : 30));
            }
            if (n6 > 16) {
                d -= (double)(this.attacker.bv / 5);
            }
            d -= (double)(n6 / 100);
        }
        return d;
    }

    protected void doRandomMutation(int n) {
        int n2;
        Chromosome chromosome = this.chromosomes[n];
        if (chromosome.genes.length < 1) {
            return;
        }
        int n3 = chromosome.genes.length > 2 ? Compute.randomInt(chromosome.genes.length - 1) : 0;
        CEntity cEntity = null;
        boolean bl = false;
        if (n3 % 2 == 1) {
            int n4 = n3;
            chromosome.genes[n4] = chromosome.genes[n4] - 1;
            chromosome.genes[n3] = chromosome.genes[n3] < 0 && this.attack.size() > n3 ? ((ArrayList)this.attack.get(n3)).size() - 1 : 0;
            return;
        }
        for (n2 = 0; n2 < chromosome.genes.length - 1 && !bl; ++n2) {
            int n5 = (n2 + n3) % (chromosome.genes.length - 1);
            AttackOption attackOption = (AttackOption)((ArrayList)this.attack.get(n5)).get(chromosome.genes[n5]);
            if (attackOption.target == null) continue;
            cEntity = attackOption.target;
            bl = true;
        }
        if (cEntity == null) {
            chromosome.genes[n3] = this.attack.size() > n3 && n3 > 1 ? Compute.randomInt(((ArrayList)this.attack.get(n3)).size() - 1) : Compute.randomInt(((ArrayList)this.attack.get(0)).size() - 1);
            AttackOption attackOption = (AttackOption)((ArrayList)this.attack.get(n3)).get(chromosome.genes[n3]);
            if (attackOption.target != null) {
                chromosome.genes[chromosome.genes.length - 1] = attackOption.target.enemy_num;
            }
        } else {
            for (n2 = 0; n2 < chromosome.genes.length - 1 && n2 < this.attack.size(); ++n2) {
                Object[] objectArray = ((ArrayList)this.attack.get(n2)).toArray();
                if (chromosome.genes[n2] == objectArray.length - 1) continue;
                bl = false;
                for (int i = 0; i < objectArray.length - 1 && !bl; ++i) {
                    AttackOption attackOption = (AttackOption)objectArray[i];
                    if (attackOption.target.enemy_num != cEntity.enemy_num) continue;
                    chromosome.genes[n2] = i;
                    bl = true;
                }
            }
            this.chromosomes[0].genes[this.chromosomeDim - 1] = cEntity.enemy_num;
        }
    }

    protected void initPopulation() {
        for (int i = 0; i < this.chromosomeDim - 1; ++i) {
            this.chromosomes[0].genes[i] = 0;
        }
        AttackOption attackOption = (AttackOption)((ArrayList)this.attack.get(0)).get(0);
        this.chromosomes[0].genes[this.chromosomeDim - 1] = attackOption.target.enemy_num;
        for (int i = 1; i < this.populationDim; ++i) {
            Chromosome chromosome = this.chromosomes[i];
            for (int j = 0; j < this.chromosomeDim - 1; ++j) {
                chromosome.genes[j] = Compute.randomInt(((ArrayList)this.attack.get(j)).size());
                if (i > this.attack.size()) continue;
                chromosome.genes[j] = j + 1 == i ? 0 : ((ArrayList)this.attack.get(j)).size() - 1;
            }
            chromosome.genes[this.chromosomeDim - 1] = (Integer)this.valid_target_indexes.get(Compute.randomInt(this.valid_target_indexes.size()));
            this.chromosomes[i].fitness = this.getFitness(i);
        }
    }

    public int getFiringArc() {
        return this.firing_arc;
    }

    public void setFiringArc(int n) {
        this.firing_arc = n;
    }

    public ArrayList getAttack() {
        return this.attack;
    }
}

