/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot;

import com.rc.retroweaver.runtime.Arrays;
import com.rc.retroweaver.runtime.Autobox;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import megamek.client.bot.AttackOption;
import megamek.client.bot.BotClient;
import megamek.client.bot.CEntity;
import megamek.client.bot.ChatProcessor;
import megamek.client.bot.GAAttack;
import megamek.client.bot.GALance;
import megamek.client.bot.MoveOption;
import megamek.client.bot.PhysicalCalculator;
import megamek.client.bot.PhysicalOption;
import megamek.client.bot.Strategy;
import megamek.client.bot.ga.GA;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Minefield;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.Protomech;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.ChargeAttackAction;
import megamek.common.actions.DfaAttackAction;
import megamek.common.actions.TorsoTwistAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.event.GamePlayerChatEvent;
import megamek.debug.Assert;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestBot
extends BotClient {
    public LinkedList unit_values = new LinkedList();
    public LinkedList enemy_values = new LinkedList();
    public CEntity.Table centities = new CEntity.Table(this);
    protected ChatProcessor chatp = new ChatProcessor();
    public int ignore = this.config.getIgnoreLevel();
    boolean debug = this.config.isDebug();
    int enemies_moved = 0;
    GALance old_moves = null;
    int my_mechs_moved = 0;

    public TestBot(String string, String string2, int n) {
        super(string, string2, n);
    }

    @Override
    public void initialize() {
    }

    @Override
    public PhysicalOption calculatePhysicalTurn() {
        return PhysicalCalculator.calculatePhysicalTurn(this);
    }

    @Override
    public MovePath calculateMoveTurn() {
        Object object2;
        int n;
        Object object3;
        Object object4;
        int n2;
        long l = System.currentTimeMillis();
        int n3 = 0;
        MoveOption moveOption = null;
        System.out.println("beginning movement calculations...");
        Object[] objectArray = this.getEnemyEntities().toArray();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (((Entity)objectArray[n2]).isSelectableThisTurn()) continue;
            ++n3;
        }
        if (n3 == this.enemies_moved && this.old_moves != null) {
            moveOption = this.old_moves.getResult();
            if (moveOption == null || !moveOption.isMoveLegal() || moveOption.isPhysical && this.centities.get((int)moveOption.getPhysicalTargetId()).isPhysicalTarget) {
                this.old_moves = null;
                System.out.println("recalculating moves since the old move was invalid");
                return this.calculateMoveTurn();
            }
        } else {
            this.enemies_moved = n3;
            ArrayList<MoveOption[]> arrayList = new ArrayList<MoveOption[]>();
            object4 = this.game.getEntities();
            while (object4.hasMoreElements()) {
                object3 = (Entity)object4.nextElement();
                if (((Entity)object3).getPosition() == null || ((Entity)object3).isOffBoard()) continue;
                CEntity cEntity = this.centities.get((Entity)object3);
                cEntity.refresh();
                this.firstPass(cEntity);
            }
            object3 = this.getEntitiesOwned().iterator();
            n = 0;
            while (object3.hasNext() && n == 0) {
                object2 = (Entity)object3.next();
                if (((Entity)object2).getPosition() == null || !this.game.getTurn().isValidEntity((Entity)object2, this.game)) continue;
                CEntity cEntity = this.centities.get((Entity)object2);
                System.out.println(new StringBuffer().append("Contemplating movement of ").append(((Entity)object2).getShortName()).append(" ").append(((Entity)object2).getId()).toString());
                MoveOption[] object6 = this.calculateMove((Entity)object2);
                if (this.game.getOptions().booleanOption("skip_ineligable_movement") && cEntity.getEntity().isImmobile()) {
                    cEntity.moved = true;
                    continue;
                }
                if (cEntity.moved) continue;
                if (object6.length < 6) {
                    moveOption = object6.length > 0 ? object6[0] : null;
                    n = 1;
                }
                arrayList.add(object6);
            }
            if (n == 0) {
                if (this.getEntitiesOwned().size() > 1) {
                    object2 = new GALance(this, arrayList, 50, 80);
                    ((GA)object2).evolve();
                    moveOption = ((GALance)object2).getResult();
                    this.old_moves = object2;
                } else if ((MoveOption[])arrayList.get(0) != null && ((MoveOption[])arrayList.get(0)).length > 0) {
                    moveOption = ((MoveOption[])arrayList.get(0))[0];
                }
            }
        }
        if (moveOption == null) {
            moveOption = new MoveOption(this.game, this.centities.get(this.getFirstEntityNum()));
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            object4 = (Entity)objectArray[n2];
            if (((Entity)object4).getPosition() == null) continue;
            object3 = this.centities.get((Entity)object4);
            n = CEntity.getThreatHitArc(((CEntity)object3).current.getFinalCoords(), ((CEntity)object3).current.getFinalFacing(), moveOption.getFinalCoords());
            object2 = (MoveOption.DamageInfo)moveOption.damageInfos.get(object3);
            if (object2 != null) {
                int n4 = n;
                ((CEntity)object3).expected_damage[n4] = ((CEntity)object3).expected_damage[n4] + ((MoveOption.DamageInfo)object2).min_damage;
            }
            if (!(((CEntity)object3).expected_damage[n] > 0.0)) continue;
            ((CEntity)object3).hasTakenDamage = true;
        }
        if (moveOption.isPhysical) {
            this.centities.get((int)moveOption.getPhysicalTargetId()).isPhysicalTarget = true;
        }
        System.out.println(moveOption);
        moveOption.getCEntity().current = moveOption;
        moveOption.getCEntity().last = moveOption;
        ++this.my_mechs_moved;
        moveOption.getCEntity().moved = true;
        long l2 = System.currentTimeMillis();
        System.out.println(new StringBuffer().append("move turn took ").append(l2 - l).append(" ms").toString());
        if (moveOption != null && moveOption.getLastStep() != null && moveOption.getCEntity().entity.canUnjamRAC() && (moveOption.getLastStep().getMovementType() == 1 || moveOption.getLastStep().getMovementType() == 4 || moveOption.getLastStep().getMovementType() == 0)) {
            Object object;
            int n5 = 0;
            n = 0;
            int n6 = 0;
            for (Mounted mounted : moveOption.getCEntity().entity.getWeaponList()) {
                object = new WeaponType();
                object = (WeaponType)mounted.getType();
                if (((WeaponType)object).getAmmoType() == 23 && mounted.isJammed()) {
                    n5 += 4 * ((WeaponType)object).getDamage();
                    continue;
                }
                if (!mounted.canFire()) continue;
                n += ((WeaponType)object).getDamage();
                if (((WeaponType)object).getMediumRange() <= n6) continue;
                n6 = ((WeaponType)object).getMediumRange();
            }
            int n7 = 100;
            Enumeration enumeration = this.game.getEntities();
            while (enumeration.hasMoreElements()) {
                object = (Entity)enumeration.nextElement();
                if (moveOption.getCEntity().entity.getPosition() == null || ((Entity)object).getPosition() == null || !((Entity)object).isEnemyOf(moveOption.getCEntity().entity) || !((Entity)object).isVisibleToEnemy() || moveOption.getCEntity().entity.getPosition().distance(((Entity)object).getPosition()) >= n7) continue;
                n7 = moveOption.getCEntity().entity.getPosition().distance(((Entity)object).getPosition());
            }
            if (n5 >= n || n7 < n6) {
                moveOption.addStep(15);
            }
        }
        return moveOption;
    }

    public MoveOption[] calculateMove(Entity entity) {
        ArrayList arrayList = new ArrayList(this.game.getValidTargets(entity));
        ArrayList<Entity> arrayList2 = new ArrayList<Entity>(this.game.getEntitiesVector());
        CEntity cEntity = this.centities.get(entity);
        int n = arrayList2.size() - arrayList.size();
        Object[] objectArray = this.secondPass(cEntity, n, arrayList, arrayList2);
        this.filterMoves(objectArray, cEntity.pass, new MoveOption.WeightedComparator(1.0, 1.0), 50);
        this.filterMoves(objectArray, cEntity.pass, new MoveOption.WeightedComparator(0.5, 1.0), 50);
        objectArray = this.thirdPass(cEntity, arrayList);
        this.filterMoves(objectArray, cEntity.pass, new MoveOption.WeightedComparator(1.0, 1.0), 30);
        this.filterMoves(objectArray, cEntity.pass, new MoveOption.WeightedComparator(0.5, 1.0), 30);
        for (MoveOption moveOption : cEntity.pass.values()) {
            moveOption.setState();
            moveOption.self_damage *= 0.5;
            moveOption.self_threat *= 0.5;
            double d = 2.0 * (double)Compute.getTargetTerrainModifier(this.game, moveOption.getEntity()).getValue();
            if (this.debug) {
                moveOption.tv.add(new StringBuffer().append(d).append(" Terrain Adjusment ").append("\n").toString());
            }
            moveOption.self_threat -= d;
        }
        objectArray = this.fourthPass(cEntity, arrayList);
        this.filterMoves(objectArray, cEntity.pass, new MoveOption.WeightedComparator(1.0, 1.0), 20);
        this.filterMoves(objectArray, cEntity.pass, new MoveOption.WeightedComparator(0.5, 1.0), 20);
        for (MoveOption moveOption : cEntity.pass.values()) {
            moveOption.self_threat *= 0.5;
            moveOption.self_damage *= 0.5;
        }
        objectArray = this.fifthPass(cEntity, arrayList);
        MoveOption[] moveOptionArray = new MoveOption[Math.min(objectArray.length, 20)];
        int n2 = 0;
        for (int i = 0; i < Math.min(objectArray.length, 20); ++i) {
            Object object = objectArray[i];
            if (((MoveOption)object).isPhysical && cEntity.range_damages[0] > 5.0 && ((MoveOption)object).doomed && n2 + 20 < objectArray.length) {
                object = objectArray[n2 + 20];
                ++n2;
            }
            moveOptionArray[i] = object;
        }
        return moveOptionArray;
    }

    public void firstPass(CEntity cEntity) {
        ArrayList arrayList = this.getEnemyEntities();
        Object[] objectArray = cEntity.getEntity().isSelectableThisTurn() && !cEntity.moved ? cEntity.getAllMoves().values().toArray(new MoveOption[0]) : new MoveOption[]{cEntity.current};
        System.out.println(new StringBuffer().append(cEntity.getEntity().getShortName()).append(" has ").append(objectArray.length).append(" moves").toString());
        for (int i = 0; i < objectArray.length; ++i) {
            MoveOption moveOption = objectArray[i];
            moveOption.setState();
            for (int j = 0; j < arrayList.size(); ++j) {
                CEntity cEntity2;
                int[] nArray;
                Entity entity = (Entity)arrayList.get(j);
                if (entity.getPosition() == null || (nArray = moveOption.getModifiers((cEntity2 = this.centities.get(entity)).getEntity()))[1] == Integer.MAX_VALUE && nArray[0] == Integer.MAX_VALUE) continue;
                int n = CEntity.getThreatHitArc(cEntity2.current.getFinalCoords(), cEntity2.current.getFinalFacing(), moveOption.getFinalCoords());
                int n2 = CEntity.getThreatHitArc(moveOption.getFinalCoords(), moveOption.getFinalFacing(), cEntity2.current.getFinalCoords());
                if (!cEntity2.getEntity().isImmobile() && nArray[1] != Integer.MAX_VALUE) {
                    cEntity.engaged = true;
                    int n3 = nArray[1];
                    double d = moveOption.getMaxModifiedDamage(cEntity2.current, n3, nArray[3]);
                    if (entity.isSelectableThisTurn()) {
                        cEntity2.current.addStep(4);
                        d = Math.max(moveOption.getMaxModifiedDamage(cEntity2.current, n3 + 1, nArray[3]), d);
                        cEntity2.current.removeLastStep();
                        cEntity2.current.addStep(3);
                        d = Math.max(moveOption.getMaxModifiedDamage(cEntity2.current, n3 + 1, nArray[3]), d);
                        cEntity2.current.removeLastStep();
                    }
                    d = cEntity.getThreatUtility(d, n2);
                    if (cEntity2.getEntity().isProne()) {
                        d *= cEntity2.base_psr_odds;
                    }
                    MoveOption.DamageInfo damageInfo = moveOption.getDamageInfo(cEntity2, true);
                    damageInfo.threat = d;
                    damageInfo.max_threat = d;
                    moveOption.threat += d;
                    if (this.debug) {
                        moveOption.tv.add(new StringBuffer().append(d).append(" Threat ").append(j).append("\n").toString());
                    }
                }
                if (!moveOption.isPhysical) {
                    if (nArray[0] == Integer.MAX_VALUE) continue;
                    cEntity.engaged = true;
                    double d = cEntity2.current.getMaxModifiedDamage(moveOption, nArray[0], nArray[2]);
                    d = cEntity2.getThreatUtility(d, n);
                    MoveOption.DamageInfo damageInfo = moveOption.getDamageInfo(cEntity2, true);
                    damageInfo.damage = d;
                    damageInfo.min_damage = d;
                    if (this.debug) {
                        moveOption.tv.add(new StringBuffer().append(d).append(" Damage ").append(j).append("\n").toString());
                    }
                    moveOption.damage = Math.max(d, moveOption.damage);
                    continue;
                }
                CEntity cEntity3 = this.centities.get(moveOption.getPhysicalTargetId());
                try {
                    if (cEntity3.getEntity().getId() != cEntity2.getEntity().getId()) continue;
                    if (!cEntity3.isPhysicalTarget) {
                        ToHitData toHitData = null;
                        double d = 0.0;
                        double d2 = 0.0;
                        if (moveOption.isJumping()) {
                            cEntity.current.setState();
                            toHitData = DfaAttackAction.toHit(this.game, moveOption.getEntity().getId(), (Targetable)cEntity3.getEntity(), moveOption);
                            d2 = 2 * DfaAttackAction.getDamageFor(moveOption.getEntity());
                            d = moveOption.getCEntity().getThreatUtility(DfaAttackAction.getDamageTakenBy(moveOption.getEntity()), 1) * Compute.oddsAbove(toHitData.getValue()) / 100.0;
                            d += moveOption.getCEntity().getThreatUtility(0.1 * (double)cEntity.getEntity().getWeight(), 1);
                            d *= (double)(100.0f / moveOption.getCEntity().getEntity().getWeight());
                        } else {
                            cEntity.current.setState();
                            toHitData = new ChargeAttackAction(moveOption.getEntity(), cEntity3.getEntity()).toHit(this.game, moveOption);
                            d2 = ChargeAttackAction.getDamageFor(moveOption.getEntity(), moveOption.getHexesMoved());
                            d = moveOption.getCEntity().getThreatUtility(ChargeAttackAction.getDamageTakenBy(moveOption.getEntity(), cEntity3.getEntity()), 0) * (Compute.oddsAbove(toHitData.getValue()) / 100.0);
                            moveOption.setState();
                        }
                        d2 = cEntity3.getThreatUtility(d2, toHitData.getSideTable()) * Compute.oddsAbove(toHitData.getValue()) / 100.0;
                        if (!moveOption.isJumping()) {
                            d2 *= Math.sqrt((double)cEntity2.bv / (double)cEntity.bv);
                        }
                        if (toHitData.getValue() > 10) {
                            d2 = 0.0;
                        }
                        if (toHitData.getValue() < 8) {
                            d2 *= 1.5;
                        }
                        if (cEntity.range_damages[0] < 5.0) {
                            d2 *= 2.0;
                        }
                        MoveOption.DamageInfo damageInfo = moveOption.getDamageInfo(cEntity2, true);
                        damageInfo.damage = d2;
                        damageInfo.min_damage = d2;
                        moveOption.damage = d2;
                        moveOption.movement_threat += d;
                        continue;
                    }
                    moveOption.threat += 2.147483647E9;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    moveOption.threat += 2.147483647E9;
                }
            }
            cEntity.current.setState();
        }
        this.filterMoves(objectArray, cEntity.pass, new MoveOption.WeightedComparator(1.0, 1.0), 100);
        this.filterMoves(objectArray, cEntity.pass, new MoveOption.WeightedComparator(0.5, 1.0), 100);
    }

    private MoveOption[] secondPass(CEntity cEntity, int n, ArrayList arrayList, ArrayList<Entity> arrayList2) {
        MoveOption[] moveOptionArray = cEntity.pass.values().toArray(new MoveOption[0]);
        cEntity.pass.clear();
        for (int i = 0; i < moveOptionArray.length && n > 2; ++i) {
            MoveOption moveOption = moveOptionArray[i];
            for (int j = 0; j < arrayList.size(); ++j) {
                Entity entity = (Entity)arrayList.get(j);
                CEntity cEntity2 = this.centities.get(entity);
                for (Entity entity2 : arrayList2) {
                    if (entity2.isEnemyOf(cEntity.entity)) continue;
                    MoveOption moveOption2 = this.centities.get((Entity)entity2).current;
                    double d = 1.0;
                    MoveOption.DamageInfo damageInfo = moveOption.getDamageInfo(cEntity2, true);
                    if (moveOption2.getDamageInfo(cEntity2, false) != null) {
                        moveOption.damage = moveOption.damage + (cEntity2.canMove() ? 0.1 : 0.2) * damageInfo.damage;
                        d += moveOption2.getCEntity().canMove() ? 0.4 : 0.6;
                    }
                    moveOption.threat -= damageInfo.threat;
                    damageInfo.threat /= d;
                    moveOption.threat += damageInfo.threat;
                }
            }
        }
        return moveOptionArray;
    }

    private MoveOption[] thirdPass(CEntity cEntity, ArrayList arrayList) {
        MoveOption[] moveOptionArray = cEntity.pass.values().toArray(new MoveOption[0]);
        cEntity.pass.clear();
        for (int i = 0; i < moveOptionArray.length; ++i) {
            int n;
            Object object;
            MoveOption moveOption = moveOptionArray[i];
            moveOption.setState();
            double d = 0.0;
            double d2 = 0.0;
            for (int j = 0; j < arrayList.size(); ++j) {
                int n2;
                Entity entity = (Entity)arrayList.get(j);
                object = this.centities.get(entity);
                int n3 = cEntity.current.getFinalCoords().distance(((CEntity)object).current.getFinalCoords());
                n = moveOption.getFinalCoords().distance(((CEntity)object).current.getFinalCoords());
                if (n > cEntity.long_range) {
                    d2 += (n >= ((CEntity)object).long_range ? 0.5 : 1.0) * (1.0 + cEntity.range_damages[cEntity.range]) * Math.max((double)(n - cEntity.long_range) - 0.5 * Math.max((double)cEntity.jumpMP, 0.8 * (double)cEntity.runMP), 0.0);
                }
                if (cEntity.range == 0 && (n3 > 5 || n > 9) || cEntity.range_damages[0] < 4.0 && n3 > 10) {
                    d2 += (((CEntity)object).range > 0 ? 0.5 : 1.0) * Math.max(1.0 + cEntity.range_damages[0], 5.0) * Math.max((double)n - 0.5 * Math.max((double)cEntity.jumpMP, 0.8 * (double)cEntity.runMP), 0.0);
                } else if (cEntity.range == 1) {
                    d2 += (n3 < 6 || n3 > 12 ? 1.0 : 0.25) * (((CEntity)object).range > 0 ? 0.5 : 1.0) * (1.0 + cEntity.range_damages[1]) * Math.abs((double)n - 0.5 * Math.max((double)cEntity.jumpMP, 0.8 * (double)cEntity.runMP));
                } else if (moveOption.damage < 0.25 * cEntity.range_damages[2]) {
                    d2 += (n < 10 ? 0.25 : 1.0) * Math.max(1.0 + cEntity.range_damages[2], 3.0) * (1.0 / (1.0 + moveOption.threat));
                }
                d += Math.sqrt(d2 * (double)((CEntity)object).bv / (double)cEntity.bv);
                if (((CEntity)object).getEntity().isProne() || ((CEntity)object).getEntity().isImmobile() || CEntity.getThreatHitArc(moveOption.getFinalCoords(), moveOption.getFinalFacing(), ((CEntity)object).getEntity().getPosition()) == 0 || (n2 = CEntity.getFiringAngle(moveOption.getFinalCoords(), moveOption.getFinalFacing(), ((CEntity)object).getEntity().getPosition())) <= 90 || n2 >= 270) continue;
                int n4 = moveOption.getFinalCoords().distance(((CEntity)object).current.getFinalCoords());
                double d3 = 1.0;
                if (n2 > 130 && n2 < 240) {
                    d3 = 2.0;
                }
                moveOption.self_threat += (d3 *= (double)(Math.max((double)cEntity.jumpMP, 0.8 * (double)cEntity.runMP) < 5.0 ? 2 : 1) * ((double)cEntity.bv / 50.0) * Math.sqrt((double)cEntity.bv / (double)((CEntity)object).bv) / ((double)n4 / 6.0 + 1.0));
                if (!this.debug) continue;
                moveOption.tv.add(new StringBuffer().append(d3).append(" ").append(n2).append(" Back to enemy\n").toString());
            }
            d *= cEntity.overall_armor_percent * cEntity.strategy.attack / (double)arrayList.size();
            IHex iHex = this.game.getBoard().getHex(moveOption.getFinalCoords());
            if (iHex.containsTerrain(4) && iHex.surface() > cEntity.getEntity().getElevation() + (moveOption.getFinalProne() ? 0 : 1)) {
                double d4 = cEntity.getEntity().heat + moveOption.getMovementheatBuildup() <= 7 ? 100.0 : 30.0;
                d += (double)cEntity.bv / d4;
            }
            if (cEntity.range > 0) {
                int n5 = this.game.getBoard().getHex(moveOption.getFinalCoords()).getElevation() - this.game.getBoard().getHex(cEntity.current.getFinalCoords()).getElevation();
                d -= (double)(Math.max(n5, 0) + 1) * ((double)Compute.getTargetTerrainModifier(this.game, moveOption.getEntity()).getValue() + 1.0);
            }
            if (moveOption.damage < 0.25 * cEntity.range_damages[cEntity.range] && d < cEntity.range_damages[cEntity.range]) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    object = (Entity)arrayList.get(j);
                    CEntity cEntity2 = this.centities.get((Entity)object);
                    n = moveOption.getFinalCoords().distance(cEntity2.current.getFinalCoords());
                    if (n <= 5) continue;
                    d += Math.pow(cEntity.overall_armor_percent, 2.0) * Math.sqrt((double)(n - 4) * (double)cEntity2.bv / (double)cEntity.bv) / (double)arrayList.size();
                }
            }
            if (moveOption.damage < 0.25 * (1.0 + cEntity.range_damages[cEntity.range])) {
                moveOption.self_threat += 2.0 * d;
            } else if (moveOption.damage < 0.5 * (1.0 + cEntity.range_damages[cEntity.range])) {
                moveOption.self_threat += d;
            }
            if (!this.debug) continue;
            moveOption.tv.add(new StringBuffer().append(moveOption.self_threat).append(" Initial Damage Adjustment ").append("\n").toString());
        }
        return moveOptionArray;
    }

    private MoveOption[] fourthPass(CEntity cEntity, ArrayList arrayList) {
        MoveOption[] moveOptionArray = cEntity.pass.values().toArray(new MoveOption[0]);
        cEntity.pass.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            Entity entity = (Entity)arrayList.get(i);
            CEntity cEntity2 = this.centities.get(entity);
            if (cEntity2.canMove()) {
                Object[] objectArray = cEntity2.pass.values().toArray();
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                for (int j = 0; j < moveOptionArray.length; ++j) {
                    MoveOption moveOption = null;
                    arrayList2.clear();
                    moveOption = moveOptionArray[j];
                    moveOption.setState();
                    ArrayList<Coords> arrayList3 = new ArrayList<Coords>();
                    Coords coords = moveOption.getFinalCoords().translated((moveOption.getFinalFacing() + 3) % 6);
                    arrayList3.add(coords);
                    arrayList3.add(coords.translated((moveOption.getFinalFacing() + 2) % 6));
                    arrayList3.add(coords.translated((moveOption.getFinalFacing() + 4) % 6));
                    arrayList3.add(moveOption.getFinalCoords().translated(moveOption.getFinalFacing()));
                    arrayList3.add(moveOption.getFinalCoords().translated((moveOption.getFinalFacing() + 1) % 6));
                    arrayList3.add(moveOption.getFinalCoords().translated((moveOption.getFinalFacing() + 2) % 6));
                    arrayList3.add(moveOption.getFinalCoords().translated((moveOption.getFinalFacing() + 4) % 6));
                    arrayList3.add(moveOption.getFinalCoords().translated((moveOption.getFinalFacing() + 5) % 6));
                    for (Coords coords2 : arrayList3) {
                        ArrayList arrayList4 = cEntity2.findMoves(coords2);
                        if (arrayList4.size() == 0) continue;
                        arrayList2.addAll(arrayList4);
                    }
                    int n = moveOption.getFinalCoords().distance(cEntity2.current.getFinalCoords());
                    int n2 = 0;
                    if (cEntity2.long_range > n - Math.max(cEntity2.jumpMP, cEntity2.runMP)) {
                        n2 = 30;
                    } else if (cEntity2.long_range > n) {
                        n2 = 10;
                    }
                    double d = this.enemies_moved / this.getEnemyEntities().size();
                    n2 = (int)((double)n2 * (1.0 + d));
                    for (int k = 0; k <= n2 && k < objectArray.length; ++k) {
                        if (objectArray.length < n2) {
                            arrayList2.add(objectArray[k]);
                            continue;
                        }
                        int n3 = Compute.randomInt(objectArray.length);
                        if (n3 % 2 == 1) {
                            arrayList2.add(objectArray[n3]);
                            continue;
                        }
                        arrayList2.add(objectArray[k]);
                    }
                    for (MoveOption moveOption2 : arrayList2) {
                        int[] nArray;
                        double d2 = 0.0;
                        double d3 = 0.0;
                        moveOption2.setState();
                        int n4 = CEntity.getThreatHitArc(moveOption2.getFinalCoords(), moveOption2.getFinalFacing(), moveOption.getFinalCoords());
                        int n5 = CEntity.getThreatHitArc(moveOption2.getFinalCoords(), moveOption2.getFinalFacing(), moveOption.getFinalCoords());
                        if (moveOption2.isJumping()) {
                            n4 = 1;
                        }
                        if ((nArray = moveOption.getModifiers(moveOption2.getEntity()))[1] != Integer.MAX_VALUE) {
                            cEntity.engaged = true;
                            d2 = !moveOption2.isJumping() ? moveOption.getMaxModifiedDamage(moveOption2, nArray[1], nArray[3]) : 0.8 * cEntity2.getModifiedDamage(nArray[3] == 1 ? 4 : 0, moveOption2.getFinalCoords().distance(moveOption.getFinalCoords()), nArray[1]);
                            d2 = cEntity.getThreatUtility(d2, n5);
                        }
                        if (nArray[0] != Integer.MAX_VALUE) {
                            cEntity.engaged = true;
                            d3 = moveOption2.getMaxModifiedDamage(moveOption, nArray[0], nArray[2]);
                            d3 = cEntity2.getThreatUtility(d3, n4);
                            if (moveOption.isPhysical) {
                                d3 = this.centities.get(moveOption.getPhysicalTargetId()).getEntity().getId() == cEntity2.getEntity().getId() ? moveOption.getDamage(cEntity2) : 0.0;
                            }
                        }
                        MoveOption.DamageInfo damageInfo = moveOption.getDamageInfo(cEntity2, true);
                        damageInfo.max_threat = Math.max(d2, damageInfo.max_threat);
                        damageInfo.min_damage = Math.min(damageInfo.min_damage, d3);
                        if (!(d2 - d3 > damageInfo.threat - damageInfo.damage)) continue;
                        damageInfo.threat = d2;
                        damageInfo.damage = d3;
                        if (!this.debug) continue;
                        moveOption.tv.add(new StringBuffer().append(d2).append(" Spec Threat ").append(i).append("\n").toString());
                        moveOption.tv.add(new StringBuffer().append(d3).append(" Spec Damage ").append(i).append("\n").toString());
                    }
                    moveOption.damage = 0.0;
                    moveOption.threat = 0.0;
                    for (CEntity cEntity3 : moveOption.damageInfos.keySet()) {
                        MoveOption.DamageInfo damageInfo = moveOption.getDamageInfo(cEntity3, true);
                        damageInfo.min_damage /= cEntity3.strategy.target;
                        damageInfo.damage /= cEntity3.strategy.target;
                        moveOption.damage += (damageInfo.min_damage + damageInfo.damage) / 2.0;
                        moveOption.threat = Math.max(moveOption.threat, damageInfo.max_threat + damageInfo.threat) / 2.0;
                        damageInfo.threat = (damageInfo.max_threat + 2.0 * damageInfo.threat) / 3.0;
                    }
                }
                cEntity2.current.setState();
            }
            cEntity.current.setState();
        }
        return moveOptionArray;
    }

    private MoveOption[] fifthPass(CEntity cEntity, ArrayList arrayList) {
        Object[] objectArray = cEntity.pass.values().toArray(new MoveOption[0]);
        cEntity.pass.clear();
        if (cEntity.engaged) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                ((MoveOption)object).setState();
                GAAttack gAAttack = this.bestAttack((MoveOption)object);
                ((MoveOption)object).damage = gAAttack != null ? (((MoveOption)object).damage + gAAttack.getFittestChromosomesFitness()) / 2.0 : (((MoveOption)object).damage /= 2.0);
                for (int j = 0; j < arrayList.size(); ++j) {
                    Entity entity = (Entity)arrayList.get(j);
                    CEntity cEntity2 = this.centities.get(entity);
                    if (!cEntity2.canMove()) {
                        ((MoveOption)object).setThreat(cEntity2, (((MoveOption)object).getThreat(cEntity2) + this.attackUtility(cEntity2.current, cEntity)) / 2.0);
                        if (this.debug) {
                            ((MoveOption)object).tv.add(new StringBuffer().append(((MoveOption)object).getThreat(cEntity2)).append(" Revised Threat ").append(j).append(" \n").toString());
                        }
                        if (((MoveOption)object).isPhysical) continue;
                        if (gAAttack != null) {
                            ((MoveOption)object).setDamage(cEntity2, (((MoveOption)object).getDamage(cEntity2) + gAAttack.getDamageUtility(cEntity2)) / 2.0);
                        } else {
                            ((MoveOption)object).setDamage(cEntity2, ((MoveOption)object).getMinDamage(cEntity2));
                        }
                        if (this.debug) {
                            ((MoveOption)object).tv.add(new StringBuffer().append(((MoveOption)object).getDamage(cEntity2)).append(" Revised Damage ").append(j).append(" \n").toString());
                        }
                        if (((MovePath)object).getFinalCoords().distance(cEntity2.current.getFinalCoords()) != 1) continue;
                        PhysicalOption physicalOption = PhysicalCalculator.getBestPhysicalAttack(((MovePath)object).getEntity(), cEntity2.getEntity(), this.game);
                        if (physicalOption != null) {
                            ((MoveOption)object).setDamage(cEntity2, ((MoveOption)object).getDamage(cEntity2) + physicalOption.expectedDmg);
                            if (this.debug) {
                                ((MoveOption)object).tv.add(new StringBuffer().append(physicalOption.expectedDmg).append(" Physical Damage ").append(j).append(" \n").toString());
                            }
                        }
                        if ((physicalOption = PhysicalCalculator.getBestPhysicalAttack(cEntity2.getEntity(), ((MovePath)object).getEntity(), this.game)) == null) continue;
                        ((MoveOption)object).setThreat(cEntity2, ((MoveOption)object).getThreat(cEntity2) + 0.5 * physicalOption.expectedDmg);
                        if (!this.debug) continue;
                        ((MoveOption)object).tv.add(new StringBuffer().append(0.5 * physicalOption.expectedDmg).append(" Physical Threat ").append(j).append(" \n").toString());
                        continue;
                    }
                    if (!((MoveOption)object).isPhysical) {
                        if (gAAttack != null) {
                            ((MoveOption)object).setDamage(cEntity2, (2.0 * ((MoveOption)object).getDamage(cEntity2) + gAAttack.getDamageUtility(cEntity2)) / 3.0);
                            continue;
                        }
                        ((MoveOption)object).setDamage(cEntity2, ((MoveOption)object).getMinDamage(cEntity2));
                        continue;
                    }
                    ((MoveOption)object).setDamage(cEntity2, ((MoveOption)object).getDamage(cEntity2) / Math.sqrt((double)cEntity2.bv / (double)cEntity.bv));
                    ((MoveOption)object).damage = ((MoveOption)object).getDamage(cEntity2);
                }
                ((MoveOption)object).threat = 0.0;
                Iterator iterator = ((MoveOption)object).damageInfos.values().iterator();
                while (iterator.hasNext()) {
                    ((MoveOption)object).threat += ((MoveOption.DamageInfo)iterator.next()).threat;
                }
                if (!this.debug) continue;
                ((MoveOption)object).tv.add(new StringBuffer().append(((MoveOption)object).threat).append(" Revised Threat Utility\n").toString());
                ((MoveOption)object).tv.add(new StringBuffer().append(((MoveOption)object).damage).append(" Revised Damage Utility\n").toString());
            }
        }
        Arrays.sort((Object[])objectArray, (Comparator)new MoveOption.WeightedComparator(1.0, 1.0));
        cEntity.current.setState();
        return objectArray;
    }

    private void filterMoves(Object[] objectArray, MoveOption.Table table, MoveOption.WeightedComparator weightedComparator, int n) {
        Arrays.sort((Object[])objectArray, (Comparator)weightedComparator);
        for (int i = 0; i < n && i < objectArray.length; ++i) {
            table.put((MoveOption)objectArray[i]);
        }
    }

    @Override
    protected void initFiring() {
        CEntity cEntity;
        ArrayList arrayList = new ArrayList(this.game.getEntitiesVector());
        int n = 0;
        while (n < arrayList.size()) {
            Entity entity = (Entity)arrayList.get(n);
            cEntity = this.centities.get(entity);
            cEntity.reset();
            cEntity.enemy_num = n++;
        }
        for (Entity entity : this.getEnemyEntities()) {
            cEntity = this.centities.get(entity);
            if (!entity.isMakingDfa() && !entity.isCharging()) continue;
            cEntity.strategy.target = 2.5;
        }
    }

    protected ArrayList calculateWeaponAttacks(Entity entity, Mounted mounted, boolean bl) {
        int n = entity.getId();
        int n2 = entity.getEquipmentNum(mounted);
        int n3 = 0;
        ArrayList<AttackOption> arrayList = new ArrayList<AttackOption>();
        Enumeration enumeration = this.game.getValidTargets(entity).elements();
        AttackOption attackOption = null;
        AttackOption attackOption2 = new AttackOption(null, null, 0.0, null, 1);
        while (enumeration.hasMoreElements()) {
            Entity entity2 = (Entity)enumeration.nextElement();
            CEntity cEntity = this.centities.get(entity2);
            ToHitData toHitData = WeaponAttackAction.toHit(this.game, n, entity2, n2);
            if (toHitData.getValue() == Integer.MAX_VALUE || toHitData.getValue() >= 13) continue;
            WeaponAttackAction weaponAttackAction = new WeaponAttackAction(n, entity2.getId(), n2);
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34 || weaponType.getAmmoType() == 23) {
                n3 = Compute.spinUpCannon(this.game, weaponAttackAction);
                super.sendModeChange(n, n2, n3);
            }
            double d = Compute.getAmmoAdjDamage(this.game, weaponAttackAction);
            int n4 = 1;
            if (entity.getFacing() != -1) {
                if (entity.canChangeSecondaryFacing()) {
                    if (!Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), entity2.getPosition(), 1)) {
                        n4 = 2;
                    }
                } else if (!Compute.isInArc(entity.getPosition(), entity.getFacing(), entity2.getPosition(), 1)) {
                    n4 = 2;
                }
            }
            if (entity instanceof Mech && entity.getTargSysType() == 6 | entity.getTargSysType() == 7) {
                n4 = 0;
            }
            if (entity instanceof Infantry) {
                n4 = 13;
            }
            attackOption = new AttackOption(cEntity, mounted, d, toHitData, n4);
            if (attackOption.value > attackOption2.value) {
                if (bl) {
                    attackOption2 = attackOption;
                    continue;
                }
                arrayList.add(0, attackOption);
                continue;
            }
            arrayList.add(attackOption);
        }
        if (bl && attackOption2.target != null) {
            arrayList.add(attackOption2);
        }
        if (arrayList.size() > 0) {
            arrayList.add(new AttackOption(null, mounted, 0.0, null, 1));
        }
        return arrayList;
    }

    public GAAttack bestAttack(MoveOption moveOption) {
        return this.bestAttack(moveOption, null, 2);
    }

    public GAAttack bestAttack(MoveOption moveOption, CEntity cEntity, int n) {
        Entity entity = moveOption.getEntity();
        int[] nArray = new int[4];
        ArrayList arrayList = new ArrayList();
        ArrayList<ArrayList> arrayList2 = new ArrayList<ArrayList>();
        ArrayList<ArrayList> arrayList3 = new ArrayList<ArrayList>();
        ArrayList<ArrayList> arrayList4 = new ArrayList<ArrayList>();
        ArrayList<ArrayList> arrayList5 = new ArrayList<ArrayList>();
        GAAttack gAAttack = null;
        int n2 = entity.getFacing();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        PhysicalOption physicalOption = new PhysicalOption(entity);
        PhysicalOption physicalOption2 = new PhysicalOption(entity);
        PhysicalOption physicalOption3 = new PhysicalOption(entity);
        for (Mounted mounted : entity.getWeaponList()) {
            arrayList = this.calculateWeaponAttacks(entity, mounted, true);
            physicalOption = PhysicalCalculator.getBestPhysical(entity, this.game);
            if (physicalOption != null && entity instanceof Mech) {
                if ((physicalOption.type == 10 || physicalOption.type == 12) && mounted.getLocation() == 5 || (physicalOption.type == 11 || physicalOption.type == 12) && mounted.getLocation() == 4) continue;
                if ((physicalOption.type == 1 || physicalOption.type == 3) && mounted.getLocation() == 5 && arrayList.size() > 0) {
                    d += ((AttackOption)arrayList.get((int)(arrayList.size() - 2))).value;
                }
                if ((physicalOption.type == 2 || physicalOption.type == 3) && mounted.getLocation() == 4 && arrayList.size() > 0) {
                    d2 += ((AttackOption)arrayList.get((int)(arrayList.size() - 2))).value;
                }
                if (physicalOption.type == 8 && (mounted.getLocation() == 5 || mounted.getLocation() == 4)) continue;
            }
            if (arrayList.size() > 0) {
                arrayList2.add(arrayList);
                nArray[0] = Math.max(nArray[0], arrayList.size());
            }
            if (!moveOption.getFinalProne() && entity.canChangeSecondaryFacing()) {
                entity.setSecondaryFacing((n2 + 5) % 6);
                arrayList = this.calculateWeaponAttacks(entity, mounted, true);
                if (arrayList.size() > 0) {
                    physicalOption2 = PhysicalCalculator.getBestPhysical(entity, this.game);
                    if (physicalOption2 != null && entity instanceof Mech) {
                        if ((physicalOption2.type == 1 || physicalOption2.type == 3) && mounted.getLocation() == 5) {
                            d3 += ((AttackOption)arrayList.get((int)(arrayList.size() - 2))).value;
                        }
                        if ((physicalOption2.type == 2 || physicalOption2.type == 3) && mounted.getLocation() == 4) {
                            d4 += ((AttackOption)arrayList.get((int)(arrayList.size() - 2))).value;
                        }
                    }
                    arrayList3.add(arrayList);
                    nArray[1] = Math.max(nArray[1], arrayList.size());
                }
                entity.setSecondaryFacing((n2 + 1) % 6);
                arrayList = this.calculateWeaponAttacks(entity, mounted, true);
                if (arrayList.size() > 0) {
                    physicalOption3 = PhysicalCalculator.getBestPhysical(entity, this.game);
                    if (physicalOption3 != null && entity instanceof Mech) {
                        if ((physicalOption3.type == 1 || physicalOption3.type == 3) && mounted.getLocation() == 5) {
                            d5 += ((AttackOption)arrayList.get((int)(arrayList.size() - 2))).value;
                        }
                        if ((physicalOption3.type == 2 || physicalOption3.type == 3) && mounted.getLocation() == 4) {
                            d6 += ((AttackOption)arrayList.get((int)(arrayList.size() - 2))).value;
                        }
                    }
                    arrayList4.add(arrayList);
                    nArray[2] = Math.max(nArray[2], arrayList.size());
                }
                entity.setSecondaryFacing((n2 + 3) % 6);
                arrayList = this.calculateWeaponAttacks(entity, mounted, true);
                if (arrayList.size() > 0) {
                    arrayList5.add(arrayList);
                    nArray[3] = Math.max(nArray[3], arrayList.size());
                }
            } else {
                nArray[1] = 0;
                nArray[2] = 0;
            }
            entity.setSecondaryFacing(n2);
        }
        this.fireOrPhysicalCheck(physicalOption, entity, arrayList2, d, d2);
        ArrayList arrayList6 = new ArrayList();
        arrayList6.add(arrayList2);
        if (!moveOption.getFinalProne() && entity.canChangeSecondaryFacing()) {
            this.fireOrPhysicalCheck(physicalOption2, entity, arrayList3, d3, d4);
            arrayList6.add(arrayList3);
            this.fireOrPhysicalCheck(physicalOption3, entity, arrayList4, d5, d6);
            arrayList6.add(arrayList4);
            if (!(entity instanceof Mech) && !(entity instanceof Protomech)) {
                arrayList6.add(arrayList5);
            }
        }
        for (int i = 0; i < arrayList6.size(); ++i) {
            ArrayList arrayList7 = (ArrayList)arrayList6.get(i);
            if (arrayList7.size() <= 0) continue;
            GAAttack gAAttack2 = new GAAttack(this, this.centities.get(entity), arrayList7, Math.max((arrayList7.size() + nArray[i]) * n, 20 * n), 30 * n, entity.isEnemyOf((Entity)this.getEntitiesOwned().get(0)));
            gAAttack2.setFiringArc(i);
            gAAttack2.evolve();
            if (cEntity != null) {
                if (gAAttack != null && !(gAAttack2.getDamageUtility(cEntity) > gAAttack.getDamageUtility(cEntity))) continue;
                gAAttack = gAAttack2;
                continue;
            }
            if (gAAttack != null && !(gAAttack2.getFittestChromosomesFitness() > gAAttack.getFittestChromosomesFitness())) continue;
            gAAttack = gAAttack2;
        }
        return gAAttack;
    }

    private void fireOrPhysicalCheck(PhysicalOption physicalOption, Entity entity, ArrayList arrayList, double d, double d2) {
        if (physicalOption != null && entity instanceof Mech) {
            int n;
            ArrayList arrayList2;
            int n2;
            if (physicalOption.type == 1 && d < physicalOption.expectedDmg && arrayList.size() > 0) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    arrayList2 = (ArrayList)arrayList.get(n2);
                    for (n = 0; n < arrayList2.size(); ++n) {
                        if (((AttackOption)arrayList2.get((int)n)).weapon.getLocation() != 5) continue;
                        ((AttackOption)arrayList2.get((int)n)).expected = 0.0;
                        ((AttackOption)arrayList2.get((int)n)).primary_expected = 0.0;
                    }
                }
            }
            if (physicalOption.type == 2 && d2 < physicalOption.expectedDmg && arrayList.size() > 0) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    arrayList2 = (ArrayList)arrayList.get(n2);
                    for (n = 0; n < arrayList2.size(); ++n) {
                        if (((AttackOption)arrayList2.get((int)n)).weapon.getLocation() != 4) continue;
                        ((AttackOption)arrayList2.get((int)n)).expected = 0.0;
                        ((AttackOption)arrayList2.get((int)n)).primary_expected = 0.0;
                    }
                }
            }
            if (physicalOption.type == 3 && d + d2 < physicalOption.expectedDmg && arrayList.size() > 0) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    arrayList2 = (ArrayList)arrayList.get(n2);
                    for (n = 0; n < arrayList2.size(); ++n) {
                        if (((AttackOption)arrayList2.get((int)n)).weapon.getLocation() == 5) {
                            ((AttackOption)arrayList2.get((int)n)).expected = 0.0;
                            ((AttackOption)arrayList2.get((int)n)).primary_expected = 0.0;
                        }
                        if (((AttackOption)arrayList2.get((int)n)).weapon.getLocation() != 4) continue;
                        ((AttackOption)arrayList2.get((int)n)).expected = 0.0;
                        ((AttackOption)arrayList2.get((int)n)).primary_expected = 0.0;
                    }
                }
            }
        }
    }

    public double attackUtility(MoveOption moveOption, CEntity cEntity) {
        GAAttack gAAttack = this.bestAttack(moveOption, cEntity, 1);
        if (gAAttack == null) {
            return 0.0;
        }
        return gAAttack.getFittestChromosomesFitness();
    }

    @Override
    public void calculateFiringTurn() {
        Object object;
        Object object2;
        Serializable serializable;
        int n;
        int n2 = n = this.game.getFirstEntityNum();
        int n3 = n;
        int n4 = 0;
        double d = Double.MIN_VALUE;
        int[] nArray = null;
        ArrayList arrayList = null;
        int n5 = 0;
        if (n2 == -1) {
            return;
        }
        do {
            serializable = this.game.getEntity(n2);
            object2 = this.centities.get((Entity)serializable);
            object = this.bestAttack(((CEntity)object2).current, null, 3);
            if (object == null || !(((GA)object).getFittestChromosomesFitness() > d)) continue;
            d = ((GA)object).getFittestChromosomesFitness();
            nArray = ((GAAttack)object).getResultChromosome();
            n5 = ((GAAttack)object).getFiringArc();
            n3 = n2;
            arrayList = ((GAAttack)object).getAttack();
        } while ((n2 = this.game.getNextEntityNum(n2)) != n && n2 != -1);
        serializable = new Vector();
        object2 = this.game.getEntity(n3);
        if (nArray != null) {
            object = (Entity)this.game.getEntitiesVector().get(nArray[nArray.length - 1]);
            TreeMap<AttackOption, AttackOption> treeMap = new TreeMap<AttackOption, AttackOption>(new AttackOption.Sorter(this.centities.get((Entity)object)));
            for (int i = 0; i < nArray.length - 1; ++i) {
                AttackOption attackOption = (AttackOption)((ArrayList)arrayList.get(i)).get(nArray[i]);
                if (attackOption.target == null) continue;
                int n6 = attackOption.toHit.getSideTable();
                attackOption.target.expected_damage[n6] = attackOption.target.expected_damage[n6] + attackOption.value;
                attackOption.target.hasTakenDamage = true;
                treeMap.put(attackOption, attackOption);
            }
            for (AttackOption attackOption : treeMap.values()) {
                WeaponAttackAction weaponAttackAction = new WeaponAttackAction(((Entity)object2).getId(), attackOption.target.getEntity().getId(), ((Entity)object2).getEquipmentNum(attackOption.weapon));
                if (((Entity)object2).getEquipment(weaponAttackAction.getWeaponId()).getLinked() != null) {
                    WeaponType weaponType = (WeaponType)attackOption.weapon.getType();
                    if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34 || weaponType.getAmmoType() == 23) {
                        n4 = Compute.spinUpCannon(this.game, weaponAttackAction);
                        super.sendModeChange(((Entity)object2).getId(), ((Entity)object2).getEquipmentNum(attackOption.weapon), n4);
                    }
                    Mounted mounted = ((Entity)object2).getEquipment(weaponAttackAction.getWeaponId()).getLinked();
                    weaponAttackAction.setAmmoId(((Entity)object2).getEquipmentNum(mounted));
                    Compute.getAmmoAdjDamage(this.game, weaponAttackAction);
                }
                ((Vector)serializable).add(weaponAttackAction);
            }
            if (((Vector)serializable).size() > 0) {
                this.getAimPoint(treeMap, (Vector)serializable);
            }
        }
        switch (n5) {
            case 1: {
                ((Vector)serializable).add(0, new TorsoTwistAction(((Entity)object2).getId(), (((Entity)object2).getFacing() + 5) % 6));
                break;
            }
            case 2: {
                ((Vector)serializable).add(0, new TorsoTwistAction(((Entity)object2).getId(), (((Entity)object2).getFacing() + 1) % 6));
                break;
            }
            case 3: {
                ((Vector)serializable).add(0, new TorsoTwistAction(((Entity)object2).getId(), (((Entity)object2).getFacing() + 3) % 6));
            }
        }
        this.sendAttackData(n3, (Vector)serializable);
    }

    @Override
    protected void initMovement() {
        double d;
        Object object;
        this.my_mechs_moved = 0;
        this.old_moves = null;
        this.enemies_moved = 0;
        double d2 = 1.4;
        ArrayList arrayList = new ArrayList(this.game.getEntitiesVector());
        double d3 = Math.sqrt(arrayList.size()) / 100.0;
        ArrayList<CEntity> arrayList2 = new ArrayList<CEntity>();
        ArrayList<CEntity> arrayList3 = new ArrayList<CEntity>();
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        CEntity cEntity = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (Entity)arrayList.get(i);
            CEntity cEntity2 = this.centities.get((Entity)object);
            cEntity2.enemy_num = i;
            d = (double)cEntity2.bv * (cEntity2.overall_armor_percent + 1.0);
            cEntity2.reset();
            double d7 = (double)cEntity2.bv * (cEntity2.overall_armor_percent + 1.0);
            double d8 = 1.0 + (d7 - d) / d;
            if (((Entity)object).getOwner().equals(this.getLocalPlayer())) {
                arrayList2.add(cEntity2);
                d4 += d7;
                if (d8 < 0.85) {
                    cEntity2.strategy.attack = 0.85;
                    continue;
                }
                if (d8 < 0.95) {
                    cEntity2.strategy.attack = 1.0;
                    continue;
                }
                if (!(d8 <= 1.0) || !(cEntity2.strategy.attack < d2)) continue;
                if (d8 == 1.0) {
                    if (cEntity2.strategy.attack < 1.0) {
                        cEntity2.strategy.attack = Math.min(1.4 * cEntity2.strategy.attack, 1.0);
                        continue;
                    }
                    cEntity2.strategy.attack *= 1.0 + d3;
                    continue;
                }
                cEntity2.strategy.attack *= 1.0 + 2.0 * d3;
                continue;
            }
            if (!((Entity)object).getOwner().isEnemyOf(this.getLocalPlayer())) {
                d4 += d7;
                continue;
            }
            arrayList3.add(cEntity2);
            d5 += d7;
            if (d7 > d6) {
                d6 = d7;
                cEntity = cEntity2;
            }
            if (this.getEntitiesOwned().size() <= 2) continue;
            if (cEntity2.strategy.target > 2.0) {
                cEntity2.strategy.target = 1.0 + 0.5 * (cEntity2.strategy.target - 2.0);
            }
            if (d8 < 0.85 && cEntity2.strategy.target < d2) {
                cEntity2.strategy.target *= 1.0 + 6.0 * d3;
            } else if (d8 < 0.95 && cEntity2.strategy.target < d2) {
                cEntity2.strategy.target *= 1.0 + 4.0 * d3;
            } else if (d8 <= 1.0) {
                cEntity2.strategy.target = d8 == 1.0 ? (cEntity2.strategy.target /= 1.0 + 2.0 * d3) : (cEntity2.strategy.target /= 1.0 + d3);
            }
            if (!(cEntity2.strategy.target < 1.0)) continue;
            cEntity2.strategy.target = 1.0;
        }
        System.out.println(new StringBuffer().append("Us ").append(d4).append(" Them ").append(d5).toString());
        if (this.unit_values.size() == 0) {
            this.unit_values.add(new Double(d4));
            this.enemy_values.add(new Double(d5));
            return;
        }
        Iterator iterator = arrayList3.iterator();
        if (arrayList2.size() > 1) {
            if (Strategy.MainTarget == null || null == this.game.getEntity(Strategy.MainTarget.getEntity().getId())) {
                Strategy.MainTarget = cEntity;
            }
            if (null == Strategy.MainTarget) {
                System.err.println("TestBot#initMovement() - no main target for bot");
            } else if (null == Strategy.MainTarget.strategy) {
                System.err.println("TestBot#initMovement() - no strategy for main target");
            } else {
                Strategy.MainTarget.strategy.target += 0.2;
                while (iterator.hasNext()) {
                    object = (CEntity)iterator.next();
                    if (d4 - d5 >= 0.9 * ((Double)this.unit_values.getLast() - (Double)this.enemy_values.getLast())) {
                        if (Compute.randomInt(2) == 1) {
                            ((CEntity)object).strategy.target += 0.3;
                        }
                    } else if (d4 > 0.9 * d5) {
                        ((CEntity)object).strategy.target += 0.15;
                    } else if (((CEntity)object).strategy.target < 2.0) {
                        ((CEntity)object).strategy.target += 0.3;
                    }
                    System.out.println(new StringBuffer().append(((CEntity)object).getEntity().getShortName()).append(" ").append(((CEntity)object).strategy.target).toString());
                }
            }
        }
        double d9 = d4 / d5;
        d = 1.0;
        if (d9 < 0.9) {
            d = 0.95;
        } else if (!(d9 < 1.0)) {
            d = 1.0 + d3;
        }
        for (CEntity cEntity3 : arrayList2) {
            if (d < 1.0 && cEntity3.strategy.attack < 0.6 || d > 1.0 && cEntity3.strategy.attack >= d2) continue;
            cEntity3.strategy.attack *= d;
        }
        System.gc();
    }

    @Override
    protected void processChat(GamePlayerChatEvent gamePlayerChatEvent) {
        this.chatp.processChat(gamePlayerChatEvent, this);
    }

    @Override
    protected void calculateDeployment() {
        EquipmentType equipmentType;
        Mounted mounted2;
        Coords coords = new Coords();
        int n = this.game.getFirstDeployableEntityNum();
        Coords[] coordsArray = this.getStartingCoordsArray();
        Coords coords2 = this.getCoordsAround(this.getEntity(n), coordsArray);
        double d = 0.0;
        int n2 = 0;
        for (Mounted mounted2 : this.getEntity(n).getWeaponList()) {
            equipmentType = (WeaponType)mounted2.getType();
            if (equipmentType.getName() == "ATM 3" || equipmentType.getName() == "ATM 6" || equipmentType.getName() == "ATM 9" || equipmentType.getName() == "ATM 12") continue;
            d = this.getEntity(n).getC3Master() != null ? (d += (double)((WeaponType)equipmentType).getLongRange() * 1.25) : (d += (double)((WeaponType)equipmentType).getLongRange());
            ++n2;
        }
        Iterator<Mounted> iterator = this.getEntity(n).getAmmo().iterator();
        while (iterator.hasNext()) {
            mounted2 = iterator.next();
            equipmentType = (AmmoType)mounted2.getType();
            if (((AmmoType)equipmentType).getAmmoType() != 29) continue;
            ++n2;
            d += 15.0;
            if (((AmmoType)equipmentType).getAmmoType() == 29 && ((AmmoType)equipmentType).getMunitionType() == 64L) {
                d -= 6.0;
            }
            if (((AmmoType)equipmentType).getAmmoType() != 29 || ((AmmoType)equipmentType).getMunitionType() != 32L) continue;
            d += 12.0;
        }
        d /= (double)n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.isDeployed() || !entity.isVisibleToEnemy() || coords2.distance(entity.getPosition()) > (int)d) continue;
            ++n3;
            n4 += entity.getPosition().x;
            n5 += entity.getPosition().y;
        }
        coords = n3 != 0 ? new Coords(n4 / n3, n5 / n3) : new Coords(this.game.getBoard().getWidth() / 2, this.game.getBoard().getHeight() / 2);
        int n6 = coords2.direction(coords);
        if (this.getEntity(n) instanceof Mech && this.getEntity(n).getArmorType() == 8) {
            iterator = this.getEntity(n).getMisc().iterator();
            while (iterator.hasNext()) {
                mounted2 = iterator.next();
                equipmentType = (MiscType)mounted2.getType();
                if (!"Stealth".equals(equipmentType.getInternalName()) || mounted2.curMode().getName() == "On") continue;
                mounted2.setMode("On");
                super.sendModeChange(n, this.getEntity(n).getEquipmentNum(mounted2), 1);
            }
        }
        Assert.assertTrue(!((Entity)((Object)(iterator = this.game.getEntity(n)))).isHexProhibited(this.game.getBoard().getHex(coords2)));
        this.deploy(n, coords2, n6);
    }

    @Override
    protected MovePath continueMovementFor(Entity entity) {
        int n;
        System.out.println(new StringBuffer().append("Contemplating movement of ").append(entity.getShortName()).append(" ").append(entity.getId()).toString());
        CEntity cEntity = this.centities.get(entity);
        cEntity.refresh();
        this.firstPass(cEntity);
        Object[] objectArray = this.getEnemyEntities().toArray();
        MoveOption[] moveOptionArray = this.calculateMove(entity);
        MoveOption moveOption = null;
        ArrayList<MoveOption[]> arrayList = new ArrayList<MoveOption[]>();
        boolean bl = false;
        if (moveOptionArray.length < 6) {
            moveOption = moveOptionArray.length > 0 ? moveOptionArray[0] : null;
            bl = true;
        }
        arrayList.add(moveOptionArray);
        if (!bl) {
            if (this.getEntitiesOwned().size() > 1) {
                GALance gALance = new GALance(this, arrayList, 50, 80);
                gALance.evolve();
                moveOption = gALance.getResult();
                this.old_moves = gALance;
            } else if (arrayList.get(0) != null && ((MoveOption[])arrayList.get(0)).length > 0) {
                moveOption = ((MoveOption[])arrayList.get(0))[0];
            }
        }
        if (moveOption == null) {
            moveOption = new MoveOption(this.game, this.centities.get(this.getFirstEntityNum()));
        }
        for (n = 0; n < objectArray.length; ++n) {
            Entity entity2 = (Entity)objectArray[n];
            if (entity2.getPosition() == null) continue;
            CEntity cEntity2 = this.centities.get(entity2);
            int n2 = CEntity.getThreatHitArc(cEntity2.current.getFinalCoords(), cEntity2.current.getFinalFacing(), moveOption.getFinalCoords());
            MoveOption.DamageInfo object3 = (MoveOption.DamageInfo)moveOption.damageInfos.get(cEntity2);
            if (object3 != null) {
                int n3 = n2;
                cEntity2.expected_damage[n3] = cEntity2.expected_damage[n3] + object3.min_damage;
            }
            if (!(cEntity2.expected_damage[n2] > 0.0)) continue;
            cEntity2.hasTakenDamage = true;
        }
        if (moveOption.isPhysical) {
            this.centities.get((int)moveOption.getPhysicalTargetId()).isPhysicalTarget = true;
        }
        System.out.println(moveOption);
        moveOption.getCEntity().current = moveOption;
        moveOption.getCEntity().last = moveOption;
        ++this.my_mechs_moved;
        moveOption.getCEntity().moved = true;
        if (moveOption != null && moveOption.getLastStep() != null && moveOption.getCEntity().entity.canUnjamRAC() && (moveOption.getLastStep().getMovementType() == 1 || moveOption.getLastStep().getMovementType() == 4 || moveOption.getLastStep().getMovementType() == 0)) {
            Object object;
            n = 0;
            int n4 = 0;
            int n5 = 0;
            for (Mounted mounted : moveOption.getCEntity().entity.getWeaponList()) {
                object = new WeaponType();
                object = (WeaponType)mounted.getType();
                if (((WeaponType)object).getAmmoType() == 23 && mounted.isJammed()) {
                    n += 4 * ((WeaponType)object).getDamage();
                    continue;
                }
                if (!mounted.canFire()) continue;
                n4 += ((WeaponType)object).getDamage();
                if (((WeaponType)object).getMediumRange() <= n5) continue;
                n5 = ((WeaponType)object).getMediumRange();
            }
            int n6 = 100;
            Enumeration enumeration = this.game.getEntities();
            while (enumeration.hasMoreElements()) {
                object = (Entity)enumeration.nextElement();
                if (moveOption.getCEntity().entity.getPosition() == null || ((Entity)object).getPosition() == null || !((Entity)object).isEnemyOf(moveOption.getCEntity().entity) || !((Entity)object).isVisibleToEnemy() || moveOption.getCEntity().entity.getPosition().distance(((Entity)object).getPosition()) >= n6) continue;
                n6 = moveOption.getCEntity().entity.getPosition().distance(((Entity)object).getPosition());
            }
            if (n >= n4 || n6 < n5) {
                moveOption.addStep(15);
            }
        }
        return moveOption;
    }

    @Override
    protected Vector calculateMinefieldDeployment() {
        Vector vector = new Vector();
        this.deployMinefields(vector, this.getLocalPlayer().getNbrMFConventional(), 0);
        this.deployMinefields(vector, this.getLocalPlayer().getNbrMFCommand(), 1);
        this.deployMinefields(vector, this.getLocalPlayer().getNbrMFVibra(), 2);
        return vector;
    }

    @Override
    protected Vector calculateArtyAutoHitHexes() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(this.getLocalPlayer().getId()));
        return vector;
    }

    protected void deployMinefields(Vector vector, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            Minefield minefield;
            Coords coords = new Coords(Compute.randomInt(this.game.getBoard().getWidth()), Compute.randomInt(this.game.getBoard().getHeight()));
            if (this.game.containsMinefield(coords)) {
                minefield = (Minefield)this.game.getMinefields(coords).get(0);
                if (minefield.getPlayerId() != this.getLocalPlayer().getId()) continue;
                --i;
                continue;
            }
            minefield = null;
            if (n2 == 0) {
                minefield = Minefield.createConventionalMF(coords, this.getLocalPlayer().getId());
            } else if (n2 == 1) {
                minefield = Minefield.createCommandDetonatedMF(coords, this.getLocalPlayer().getId());
            } else if (n2 == 2) {
                minefield = Minefield.createVibrabombMF(coords, this.getLocalPlayer().getId(), 20);
            }
            vector.add(minefield);
        }
    }

    private void getAimPoint(TreeMap treeMap, Vector vector) {
        int n;
        if (treeMap == null || vector == null) {
            return;
        }
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] dArray3 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        int n2 = 0;
        int n3 = ((WeaponAttackAction)vector.get(0)).getEntityId();
        boolean bl = this.game.getEntity(n3).hasTargComp();
        Vector<Integer> vector2 = new Vector<Integer>();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            n = ((WeaponAttackAction)iterator.next()).getTargetId();
            if (!(this.game.getEntity(n) instanceof Mech) || !(bl | this.game.getEntity(n).isImmobile()) || vector2.contains(Autobox.valueOf((int)n))) continue;
            vector2.add(Autobox.valueOf((int)n));
        }
        boolean bl2 = true;
        iterator = vector2.iterator();
        while (iterator.hasNext()) {
            int n4;
            int n5;
            int n6;
            n = (Integer)iterator.next();
            boolean bl3 = this.game.getEntity(n).isImmobile();
            boolean bl4 = false;
            for (AttackOption attackOption : treeMap.values()) {
                if (attackOption.target.getEntity().getId() != n) continue;
                int n7 = attackOption.toHit.getSideTable();
                bl4 = n7 == 1;
                break;
            }
            dArray[0] = this.game.getEntity(n).getArmor(0);
            dArray[1] = this.game.getEntity(n).getArmor(1, bl4);
            dArray[2] = this.game.getEntity(n).getArmor(3, bl4);
            dArray[3] = this.game.getEntity(n).getArmor(2, bl4);
            dArray[4] = this.game.getEntity(n).getArmor(5);
            dArray[5] = this.game.getEntity(n).getArmor(4);
            dArray[6] = this.game.getEntity(n).getArmor(7);
            dArray[7] = this.game.getEntity(n).getArmor(6);
            dArray2[0] = this.game.getEntity(n).getInternal(0);
            dArray2[1] = this.game.getEntity(n).getInternal(1);
            dArray2[2] = this.game.getEntity(n).getInternal(3);
            dArray2[3] = this.game.getEntity(n).getInternal(2);
            dArray2[4] = this.game.getEntity(n).getInternal(5);
            dArray2[5] = this.game.getEntity(n).getInternal(4);
            dArray2[6] = this.game.getEntity(n).getInternal(7);
            dArray2[7] = this.game.getEntity(n).getInternal(6);
            for (n6 = 0; n6 < 8; ++n6) {
                dArray3[n6] = 0.0;
            }
            for (n6 = 0; n6 < 8; ++n6) {
                nArray[n6] = 0;
            }
            n2 = 0;
            double d = 0.0;
            double d2 = 0.0;
            int n8 = 1;
            int n9 = 1;
            for (AttackOption attackOption : treeMap.values()) {
                if (n == attackOption.target.getEntity().getId()) {
                    Mounted mounted = attackOption.weapon;
                    n5 = 1;
                    if (!((WeaponType)mounted.getType()).hasFlag(1L)) {
                        n5 = 0;
                    }
                    if ((((WeaponType)mounted.getType()).getAmmoType() == 19 || ((WeaponType)mounted.getType()).getAmmoType() == 19) && (long)((AmmoType)mounted.getLinked().getType()).getAmmoType() == 1L) {
                        n5 = 0;
                    }
                    if (n5 == 1) {
                        double d3 = bl2 ? attackOption.primary_expected : attackOption.expected;
                        int n10 = bl2 ? attackOption.toHit.getValue() : attackOption.toHit.getValue() + 1;
                        double d4 = bl2 ? attackOption.primary_odds : attackOption.odds;
                        d3 = d4 == 0.0 ? 0.0 : d3 / d4;
                        if (!bl3 & bl) {
                            d2 = 0.0;
                            if (n10 + 4 <= 12) {
                                d = d3 * (Compute.oddsAbove(n10 + 4) / 100.0);
                                ((WeaponAttackAction)vector.get(n2)).setAimingMode(2);
                                if (0.2 * d3 * (Compute.oddsAbove(n10) / 100.0) > d) {
                                    d = 0.2 * d3 * (Compute.oddsAbove(n10) / 100.0);
                                    ((WeaponAttackAction)vector.get(n2)).setAimingMode(0);
                                }
                            } else {
                                d = 0.0;
                                ((WeaponAttackAction)vector.get(n2)).setAimingMode(0);
                            }
                        }
                        if (bl3) {
                            if (bl) {
                                d = d3 * (Compute.oddsAbove(n10 + 4) / 100.0);
                                d2 = 0.0;
                                ((WeaponAttackAction)vector.get(n2)).setAimingMode(2);
                                if (0.5 * d3 * (Compute.oddsAbove(n10) / 100.0) > d) {
                                    d = 0.5 * d3 * (Compute.oddsAbove(n10) / 100.0);
                                    d2 = 0.5 * d3 * (Compute.oddsAbove(n10 + 7) / 100.0);
                                    ((WeaponAttackAction)vector.get(n2)).setAimingMode(1);
                                }
                            } else {
                                d = 0.5 * d3 * (Compute.oddsAbove(n10) / 100.0);
                                d2 = 0.5 * d3 * (Compute.oddsAbove(n10 + 7) / 100.0);
                                ((WeaponAttackAction)vector.get(n2)).setAimingMode(1);
                            }
                        }
                        for (n4 = 0; n4 < 8; ++n4) {
                            if (n4 == 0) {
                                int n11 = n4;
                                dArray[n11] = dArray[n11] - d2;
                            } else {
                                int n12 = n4;
                                dArray[n12] = dArray[n12] - d;
                            }
                            if (!(dArray[n4] < 0.0 & dArray2[n4] > 0.0)) continue;
                            int n13 = n4;
                            dArray2[n13] = dArray2[n13] + dArray[n4];
                            dArray[n4] = 0.0;
                            int n14 = n4;
                            nArray[n14] = nArray[n14] + 1;
                        }
                    }
                }
                ++n2;
            }
            block44: for (n5 = 0; n5 < 8; ++n5) {
                double d5 = 0.0;
                if (dArray[n5] <= 0.0 & dArray2[n5] > 0.0) {
                    switch (n5) {
                        case 0: {
                            dArray3[n5] = 4.0 * (double)nArray[n5];
                            int n15 = n5;
                            dArray3[n15] = dArray3[n15] + this.getAimModifier(n, 0);
                            break;
                        }
                        case 1: {
                            dArray3[n5] = 3.0 * (double)nArray[n5];
                            int n16 = n5;
                            dArray3[n16] = dArray3[n16] + this.getAimModifier(n, 1);
                            break;
                        }
                        case 2: {
                            d5 = this.getAimModifier(n, 3);
                            dArray3[n5] = 2.0 * (double)nArray[n5];
                            int n17 = n5;
                            dArray3[n17] = dArray3[n17] + d5;
                            break;
                        }
                        case 3: {
                            d5 = this.getAimModifier(n, 2);
                            dArray3[n5] = 2.0 * (double)nArray[n5];
                            int n18 = n5;
                            dArray3[n18] = dArray3[n18] + d5;
                            break;
                        }
                        case 6: {
                            d5 = this.getAimModifier(n, 7);
                            dArray3[n5] = 2.0 * (double)nArray[n5];
                            int n19 = n5;
                            dArray3[n19] = dArray3[n19] + d5;
                            break;
                        }
                        case 7: {
                            d5 = this.getAimModifier(n, 6);
                            dArray3[n5] = 2.0 * (double)nArray[n5];
                            int n20 = n5;
                            dArray3[n20] = dArray3[n20] + d5;
                            break;
                        }
                        case 4: {
                            d5 = this.getAimModifier(n, 5);
                            dArray3[n5] = nArray[n5];
                            int n21 = n5;
                            dArray3[n21] = dArray3[n21] + d5;
                            break;
                        }
                        case 5: {
                            d5 = this.getAimModifier(n, 4);
                            dArray3[n5] = nArray[n5];
                            int n22 = n5;
                            dArray3[n22] = dArray3[n22] + d5;
                        }
                    }
                }
                if (!(dArray2[n5] <= 0.0 & nArray[n5] > 0)) continue;
                switch (n5) {
                    case 0: {
                        int n23 = n5;
                        dArray3[n23] = dArray3[n23] + 3.0 * this.getAimModifier(n, 0);
                        continue block44;
                    }
                    case 1: {
                        int n24 = n5;
                        dArray3[n24] = dArray3[n24] + 2.0 * this.getAimModifier(n, 1);
                        continue block44;
                    }
                    case 2: {
                        int n25 = n5;
                        dArray3[n25] = dArray3[n25] + 1.5 * this.getAimModifier(n, 3);
                        continue block44;
                    }
                    case 3: {
                        int n26 = n5;
                        dArray3[n26] = dArray3[n26] + 1.5 * this.getAimModifier(n, 2);
                        continue block44;
                    }
                    case 6: {
                        int n27 = n5;
                        dArray3[n27] = dArray3[n27] + 1.5 * this.getAimModifier(n, 7);
                        continue block44;
                    }
                    case 7: {
                        int n28 = n5;
                        dArray3[n28] = dArray3[n28] + 1.5 * this.getAimModifier(n, 6);
                        continue block44;
                    }
                    case 4: {
                        int n29 = n5;
                        dArray3[n29] = dArray3[n29] + this.getAimModifier(n, 5);
                        continue block44;
                    }
                    case 5: {
                        int n30 = n5;
                        dArray3[n30] = dArray3[n30] + this.getAimModifier(n, 4);
                    }
                }
            }
            d = dArray3[1];
            block45: for (n5 = 0; n5 < 8; ++n5) {
                if (!(dArray3[n5] > d)) continue;
                d = dArray3[n5];
                switch (n5) {
                    case 0: {
                        n9 = 0;
                        continue block45;
                    }
                    case 2: {
                        n9 = 3;
                    }
                    case 3: {
                        n9 = 2;
                        continue block45;
                    }
                    case 4: {
                        n9 = 5;
                        continue block45;
                    }
                    case 5: {
                        n9 = 4;
                        continue block45;
                    }
                    case 6: {
                        n9 = 7;
                        continue block45;
                    }
                    case 7: {
                        n9 = 6;
                        continue block45;
                    }
                    default: {
                        n9 = 1;
                    }
                }
            }
            n5 = 1;
            d = dArray3[1];
            block46: for (n4 = 2; n4 < 8; ++n4) {
                if (!(dArray3[n4] > d)) continue;
                d = dArray3[n4];
                n5 = n4;
                switch (n4) {
                    case 2: {
                        n8 = 3;
                    }
                    case 3: {
                        n8 = 2;
                        continue block46;
                    }
                    case 4: {
                        n8 = 5;
                        continue block46;
                    }
                    case 5: {
                        n8 = 4;
                        continue block46;
                    }
                    case 6: {
                        n8 = 7;
                        continue block46;
                    }
                    case 7: {
                        n8 = 6;
                        continue block46;
                    }
                    default: {
                        n8 = 1;
                    }
                }
            }
            for (WeaponAttackAction weaponAttackAction : vector) {
                if (weaponAttackAction.getTargetId() != n) continue;
                if (weaponAttackAction.getAimingMode() == 2) {
                    if (dArray[n5] <= (double)Compute.randomInt(5)) {
                        weaponAttackAction.setAimedLocation(n8);
                    } else {
                        weaponAttackAction.setAimingMode(0);
                        weaponAttackAction.setAimedLocation(-1);
                    }
                }
                if (weaponAttackAction.getAimingMode() != 1) continue;
                weaponAttackAction.setAimedLocation(n9);
            }
            bl2 = false;
        }
    }

    private double getAimModifier(int n, int n2) {
        double d = 0.1 * (double)this.game.getEntity(n).getHittableCriticals(n2);
        return d;
    }
}

