/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.ui.AWT.AlertDialog;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.util.ImageFileFactory;
import megamek.client.ui.AWT.util.PlayerColors;
import megamek.client.ui.AWT.widget.AdvancedLabel;
import megamek.client.ui.AWT.widget.ImageButton;
import megamek.common.Player;
import megamek.common.util.DirectoryItems;

public class CamoChoiceDialog
extends Dialog
implements ActionListener,
ItemListener,
ItemSelectable {
    private Frame frame;
    private DirectoryItems camos;
    private Choice categories;
    private List items;
    private ImageButton keep;
    private ImageButton select;
    private String prevCat;
    private String prevItem;
    private Vector listeners = new Vector();

    void close() {
        this.setCategory(this.prevCat);
        this.setItemName(this.prevItem);
        this.setVisible(false);
    }

    void fillList(String string) {
        this.items.removeAll();
        if ("-- No Camo --".equals(string)) {
            for (int i = 0; i < Player.colorNames.length; ++i) {
                this.items.add(Player.colorNames[i]);
            }
        } else {
            Enumeration enumeration = "-- General --".equals(string) ? this.camos.getItemNames("") : this.camos.getItemNames(string);
            while (enumeration.hasMoreElements()) {
                this.items.add((String)enumeration.nextElement());
            }
        }
        if (this.prevCat.equals(string)) {
            this.setItemName(this.prevItem);
        } else {
            this.setItemName(this.items.getItem(0));
        }
    }

    void setPrevSelection(String string, String string2) {
        if ("-- No Camo --".equals(string)) {
            this.keep.setImage(null);
            for (int i = 0; i < Player.colorNames.length; ++i) {
                if (!Player.colorNames[i].equals(string2)) continue;
                this.keep.setBackground(PlayerColors.getColor(i));
                this.prevCat = string;
                this.prevItem = string2;
                break;
            }
        } else {
            try {
                String string3 = string;
                if ("-- General --".equals(string3)) {
                    string3 = "";
                }
                Image image = (Image)this.camos.getItem(string3, string2);
                this.keep.setBackground(this.categories.getBackground());
                this.keep.setImage(image);
                this.prevCat = string;
                this.prevItem = string2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                AlertDialog alertDialog = new AlertDialog(this.frame, Messages.getString("CamoChoiceDialog.error_getting_camo"), exception.getMessage());
                alertDialog.setVisible(true);
                alertDialog.dispose();
            }
        }
    }

    public CamoChoiceDialog(Frame frame) {
        super(frame, Messages.getString("CamoChoiceDialog.select_camo_pattern"), true);
        this.frame = frame;
        try {
            this.camos = new DirectoryItems(new File("data/images/camo"), "", ImageFileFactory.getInstance());
        }
        catch (Exception exception) {
            this.camos = null;
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CamoChoiceDialog.this.close();
            }
        });
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        this.add((Component)panel, "North");
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        this.categories = new Choice();
        panel.add((Component)this.categories, gridBagConstraints);
        this.categories.addItem("-- No Camo --");
        if (this.camos != null) {
            if (this.camos.getItemNames("").hasMoreElements()) {
                this.categories.addItem("-- General --");
            }
            Enumeration enumeration = this.camos.getCategoryNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equals("")) continue;
                this.categories.addItem(string);
            }
        }
        this.categories.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CamoChoiceDialog.this.fillList((String)itemEvent.getItem());
                CamoChoiceDialog.this.itemStateChanged(new ItemEvent(CamoChoiceDialog.this.items, itemEvent.getID(), CamoChoiceDialog.this.items.getSelectedItem(), 1));
            }
        });
        this.items = new List(15);
        this.add((Component)this.items, "Center");
        this.items.addItemListener(this);
        panel = new Panel();
        panel.setLayout(new GridBagLayout());
        this.add((Component)panel, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weighty = 1.0;
        panel.add((Component)new Label(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        panel.add((Component)new AdvancedLabel(Messages.getString("CamoChoiceDialog.keep_old_camo")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.keep = new ImageButton();
        this.keep.setLabel(Messages.getString("CamoChoiceDialog.no_camo"));
        this.keep.setPreferredSize(84, 72);
        this.keep.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CamoChoiceDialog.this.close();
            }
        });
        this.keep.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode()) {
                    CamoChoiceDialog.this.close();
                }
            }
        });
        panel.add((Component)this.keep, gridBagConstraints);
        ++gridBagConstraints.gridy;
        panel.add((Component)new AdvancedLabel(Messages.getString("CamoChoiceDialog.select_new_camo")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.select = new ImageButton();
        this.select.setLabel(Messages.getString("CamoChoiceDialog.no_camo"));
        this.select.setPreferredSize(84, 72);
        this.select.addActionListener(this);
        panel.add((Component)this.select, gridBagConstraints);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode()) {
                    CamoChoiceDialog.this.actionPerformed(new ActionEvent(CamoChoiceDialog.this.select, keyEvent.getID(), CamoChoiceDialog.this.select.getActionCommand()));
                }
            }
        };
        this.items.addKeyListener(keyAdapter);
        this.select.addKeyListener(keyAdapter);
        this.setPrevSelection("-- No Camo --", Player.colorNames[0]);
        this.fillList("-- No Camo --");
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.categories.getSelectedItem();
        String string2 = this.items.getSelectedItem();
        if (!string.equals(this.prevCat) || !string2.equals(this.prevItem)) {
            this.setPrevSelection(string, string2);
            if (!this.listeners.isEmpty()) {
                Image image = null;
                Image[] imageArray = (Image[])this.getSelectedObjects();
                if (null != imageArray) {
                    image = imageArray[0];
                }
                ItemEvent itemEvent = new ItemEvent(this, actionEvent.getID(), image, 701);
                Enumeration enumeration = this.listeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((ItemListener)enumeration.nextElement()).itemStateChanged(itemEvent);
                }
            }
        }
        this.close();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this.categories.getSelectedItem();
        if ("-- No Camo --".equals(string)) {
            this.select.setImage(null);
            this.select.setBackground(PlayerColors.getColor(this.items.getSelectedIndex()));
            return;
        }
        if ("-- General --".equals(string)) {
            string = "";
        }
        try {
            this.select.setBackground(this.categories.getBackground());
            this.select.setImage((Image)this.camos.getItem(string, this.items.getSelectedItem()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            AlertDialog alertDialog = new AlertDialog(this.frame, Messages.getString("CamoChoiceDialog.error_getting_camo"), exception.getMessage());
            alertDialog.setVisible(true);
            alertDialog.dispose();
        }
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray;
        this.setPrevSelection(this.categories.getSelectedItem(), this.items.getSelectedItem());
        if ("-- No Camo --".equals(this.prevCat)) {
            return null;
        }
        Image image = null;
        try {
            objectArray = this.prevCat;
            if ("-- General --".equals(objectArray)) {
                objectArray = "";
            }
            image = (Image)this.camos.getItem((String)objectArray, this.prevItem);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            AlertDialog alertDialog = new AlertDialog(this.frame, Messages.getString("CamoChoiceDialog.error_getting_camo"), exception.getMessage());
            alertDialog.setVisible(true);
            alertDialog.dispose();
        }
        if (null == image) {
            return null;
        }
        objectArray = new Image[]{image};
        return objectArray;
    }

    public void addItemListener(ItemListener itemListener) {
        if (!this.listeners.contains(itemListener)) {
            this.listeners.addElement(itemListener);
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listeners.removeElement(itemListener);
    }

    public String getCategory() {
        return this.prevCat;
    }

    public String getItemName() {
        return this.prevItem;
    }

    public void setCategory(String string) {
        String string2 = this.categories.getSelectedItem();
        if (!string2.equals(string)) {
            for (int i = 0; i < this.categories.getItemCount(); ++i) {
                if (!this.categories.getItem(i).equals(string)) continue;
                this.categories.select(i);
                this.fillList(string);
                break;
            }
        }
    }

    public void setItemName(String string) {
        String string2;
        if (null != string && !string.equals(string2 = this.items.getSelectedItem())) {
            String[] stringArray = this.items.getItems();
            for (int i = 0; i < this.items.getItemCount(); ++i) {
                if (!stringArray[i].equals(string)) continue;
                this.items.select(i);
                break;
            }
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setPrevSelection(this.categories.getSelectedItem(), this.items.getSelectedItem());
            this.itemStateChanged(new ItemEvent(this.items, 0, this.items.getSelectedItem(), 1));
        }
        super.setVisible(bl);
    }
}

