/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import megamek.client.Client;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.PlayerListDialog;
import megamek.common.event.GameEntityNewEvent;
import megamek.common.event.GameEntityRemoveEvent;
import megamek.common.event.GameListenerAdapter;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GamePlayerChangeEvent;
import megamek.common.event.GamePlayerChatEvent;
import megamek.common.event.GameTurnChangeEvent;

public class ChatterBox
implements KeyListener {
    public Client client;
    public String[] chatBuffer;
    public Panel chatPanel;
    private TextArea chatArea;
    private List playerList;
    private TextField inputField;
    private Button butDone;

    public ChatterBox(ClientGUI clientGUI) {
        this.client = clientGUI.getClient();
        this.client.game.addGameListener(new GameListenerAdapter(){

            public void gamePlayerChat(GamePlayerChatEvent gamePlayerChatEvent) {
                ChatterBox.this.chatArea.append("\n" + gamePlayerChatEvent.getMessage());
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }

            public void gamePlayerChange(GamePlayerChangeEvent gamePlayerChangeEvent) {
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }

            public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }

            public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }

            public void gameEntityNew(GameEntityNewEvent gameEntityNewEvent) {
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }

            public void gameEntityRemove(GameEntityRemoveEvent gameEntityRemoveEvent) {
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }
        });
        this.chatArea = new TextArea(" \n", GUIPreferences.getInstance().getInt("AdvancedChatboxSize"), 40, 1);
        this.chatArea.setEditable(false);
        this.playerList = new List(GUIPreferences.getInstance().getInt("AdvancedChatboxSize"));
        this.inputField = new TextField();
        this.inputField.addKeyListener(this);
        this.butDone = new Button(Messages.getString("ChatterBox.ImDone"));
        this.butDone.setEnabled(false);
        this.chatPanel = new Panel(new BorderLayout());
        Panel panel = new Panel(new BorderLayout());
        panel.add((Component)this.chatArea, "Center");
        panel.add((Component)this.playerList, "West");
        panel.add((Component)this.inputField, "South");
        this.chatPanel.add((Component)panel, "Center");
        this.chatPanel.add((Component)this.butDone, "East");
    }

    public void moveToEnd() {
        if (this.chatArea.isShowing()) {
            int n = this.chatArea.getText().length() - 1;
            this.chatArea.select(n, n);
            this.chatArea.setCaretPosition(n);
        }
    }

    public Component getComponent() {
        return this.chatPanel;
    }

    public void systemMessage(String string) {
        this.chatArea.append("\nMegaMek: " + string);
    }

    public void setDoneButton(Button button) {
        this.chatPanel.remove(this.butDone);
        this.butDone = button;
        this.chatPanel.add((Component)this.butDone, "East");
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.client.sendChat(this.inputField.getText());
            this.inputField.setText("");
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

