/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.ui.AWT.AlertDialog;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.UnitLoadingDialog;
import megamek.common.BattleArmor;
import megamek.common.EquipmentType;
import megamek.common.LocationFullException;
import megamek.common.MechSummary;

public class CustomBattleArmorDialog
extends Dialog
implements ActionListener,
ItemListener,
KeyListener,
Runnable,
TextListener,
WindowListener {
    private static final int KEY_TIMEOUT = 1000;
    private String[] m_saSorts = new String[]{Messages.getString("MechSelectorDialog.0"), Messages.getString("MechSelectorDialog.1"), Messages.getString("MechSelectorDialog.2"), Messages.getString("MechSelectorDialog.3"), Messages.getString("MechSelectorDialog.4"), Messages.getString("MechSelectorDialog.5")};
    private MechSummary[] m_mechsCurrent;
    private Client m_client;
    private ClientGUI m_clientgui;
    private UnitLoadingDialog unitLoadingDialog;
    private Panel m_pLeft = new Panel();
    private Panel m_pParams = new Panel();
    private Label m_labelBAName = new Label(Messages.getString("CustomBattleArmorDialog.m_labelBAName"), 2);
    private TextField m_tfBAName = new TextField();
    private Label m_labelMenPerSquad = new Label(Messages.getString("CustomBattleArmorDialog.m_labelMenPerSquad"), 2);
    private Choice m_chMenPerSquad = new Choice();
    private Label m_labelTechBase = new Label(Messages.getString("CustomBattleArmorDialog.m_labelTechBase"), 2);
    private Choice m_chTechBase = new Choice();
    private Label m_labelChassisType = new Label(Messages.getString("CustomBattleArmorDialog.m_labelChassisType"), 2);
    private Choice m_chChassisType = new Choice();
    private Label m_labelWeightClass = new Label(Messages.getString("CustomBattleArmorDialog.m_labelWeightClass"), 2);
    private Choice m_chWeightClass = new Choice();
    private Label m_labelGroundMP = new Label(Messages.getString("CustomBattleArmorDialog.m_labelGroundMP"), 2);
    private Choice m_chGroundMP = new Choice();
    private CheckboxGroup m_cbgJumpType = new CheckboxGroup();
    private Label m_labelJumpQuery = new Label(Messages.getString("CustomBattleArmorDialog.m_jumpQuery"), 2);
    private Checkbox m_cbJumpQuery = new Checkbox(Messages.getString("CustomBattleArmorDialog.m_jumpQuery"), this.m_cbgJumpType, true);
    private Label m_labelVTOLQuery = new Label(Messages.getString("CustomBattleArmorDialog.m_VTOLQuery"), 2);
    private Checkbox m_cbVTOLQuery = new Checkbox(Messages.getString("CustomBattleArmorDialog.m_VTOLQuery"), this.m_cbgJumpType, false);
    private Label m_labelUMUQuery = new Label(Messages.getString("CustomBattleArmorDialog.m_UMUQuery"), 2);
    private Checkbox m_cbUMUQuery = new Checkbox(Messages.getString("CustomBattleArmorDialog.m_UMUQuery"), this.m_cbgJumpType, false);
    private Label m_labelJumpValue = new Label(Messages.getString("CustomBattleArmorDialog.m_labelJumpValue"), 2);
    private Choice m_chJumpValue = new Choice();
    private Label m_labelArmorType = new Label(Messages.getString("CustomBattleArmorDialog.m_labelArmorType"), 2);
    private Choice m_chArmorType = new Choice();
    private Label m_labelArmorValue = new Label(Messages.getString("CustomBattleArmorDialog.m_labelArmorValue"), 2);
    private Choice m_chArmorValue = new Choice();
    private Label m_labelLeftManipulator = new Label(Messages.getString("CustomBattleArmorDialog.m_labelLeftManipulator"), 2);
    private Choice m_chLeftManipulator = new Choice();
    private Label m_labelRightManipulator = new Label(Messages.getString("CustomBattleArmorDialog.m_labelRightManipulator"), 2);
    private Choice m_chRightManipulator = new Choice();
    private Label m_labelTorsoEquipment = new Label(Messages.getString("CustomBattleArmorDialog.m_labelTorsoEquipment"), 2);
    private Choice m_chTorsoEquipment = new Choice();
    private Button m_buttonAddTorso = new Button(Messages.getString("CustomBattleArmorDialog.m_buttonAdd"));
    private Label m_labelRightArmEquipment = new Label(Messages.getString("CustomBattleArmorDialog.m_labelRightArmEquipment"), 2);
    private Choice m_chRightArmEquipment = new Choice();
    private Button m_buttonAddRightArm = new Button(Messages.getString("CustomBattleArmorDialog.m_buttonAdd"));
    private Label m_labelLeftArmEquipment = new Label(Messages.getString("CustomBattleArmorDialog.m_labelLeftArmEquipment"), 2);
    private Choice m_chLeftArmEquipment = new Choice();
    private Button m_buttonAddLeftArm = new Button(Messages.getString("CustomBattleArmorDialog.m_buttonAdd"));
    private Label m_labelTorsoCurrentEquipment = new Label(Messages.getString("CustomBattleArmorDialog.m_labelCurrentTorsoEquipment"), 2);
    private Choice m_chTorsoCurrentEquipment = new Choice();
    private Button m_buttonRemoveTorso = new Button(Messages.getString("CustomBattleArmorDialog.m_buttonRemove"));
    private Label m_labelRightArmCurrentEquipment = new Label(Messages.getString("CustomBattleArmorDialog.m_labelCurrentRightArmEquipment"), 2);
    private Choice m_chRightArmCurrentEquipment = new Choice();
    private Button m_buttonRemoveRightArm = new Button(Messages.getString("CustomBattleArmorDialog.m_buttonRemove"));
    private Label m_labelLeftArmCurrentEquipment = new Label(Messages.getString("CustomBattleArmorDialog.m_labelCurrentLeftArmEquipment"), 2);
    private Choice m_chLeftArmCurrentEquipment = new Choice();
    private Button m_buttonRemoveLeftArm = new Button(Messages.getString("CustomBattleArmorDialog.m_buttonRemove"));
    private Panel m_pButtons = new Panel();
    private Button m_bPick = new Button(Messages.getString("CustomBattleArmorDialog.m_bPick"));
    private Button m_bPickClose = new Button(Messages.getString("CustomBattleArmorDialog.m_bPickClose"));
    private Button m_bCancel = new Button(Messages.getString("CustomBattleArmorDialog.m_bClose"));
    private Button m_buttonReset = new Button(Messages.getString("CustomBattleArmorDialog.m_buttonReset"));
    private Label m_labelPlayer = new Label(Messages.getString("CustomBattleArmorDialog.m_labelPlayer"), 2);
    private Choice m_chPlayer = new Choice();
    private TextArea m_BAView = new TextArea("", 18, 25, 0);
    private String invalidReason = null;
    private int stateMenPerSquad = 1;
    private int stateTechBase = 0;
    private int stateChassisType = 0;
    private int stateWeightClass = 0;
    private int stateArmorType = 0;
    private int stateArmorValue = 0;
    private int stateJumpType = 0;
    private int stateJumpMP = 0;
    private int stateGroundMP = 1;
    private int stateCurrentWeight = 0;
    private int stateMinWeight = 0;
    private int stateMaxWeight = 400;
    private int stateManipulatorTypeLeft = 0;
    private int stateManipulatorTypeRight = 0;
    private int stateConflictFlags = 0;
    private Vector leftArmEquipment = null;
    private Vector rightArmEquipment = null;
    private Vector torsoEquipment = null;
    private static ArrayList equipmentTypes = null;
    private static ArrayList equipmentNames = null;
    private static final int TECH_BASE_IS = 0;
    private static final int TECH_BASE_CLAN = 1;
    private static final int TECH_BASE_BOTH = 2;
    private static final int CHASSIS_TYPE_BIPED = 0;
    private static final int CHASSIS_TYPE_QUAD = 1;
    private static final int WEIGHT_CLASS_PAL = 0;
    private static final int WEIGHT_CLASS_LIGHT = 1;
    private static final int WEIGHT_CLASS_MEDIUM = 2;
    private static final int WEIGHT_CLASS_HEAVY = 3;
    private static final int WEIGHT_CLASS_ASSAULT = 4;
    private static final int JUMP_TYPE_JUMP = 0;
    private static final int JUMP_TYPE_VTOL = 1;
    private static final int JUMP_TYPE_UMU = 2;
    public static int EQUIPMENT_TYPE_WEAPON = 0;
    public static int EQUIPMENT_TYPE_WEAPON_AP = 1;
    public static int EQUIPMENT_TYPE_PREPROCESS = 2;
    public static int EQUIPMENT_TYPE_AMMO = 3;
    public static int EQUIPMENT_TYPE_OTHER = 4;
    private static final int[][] ARMOR_TYPE_WEIGHT = new int[][]{{50, 40, 100, 55, 100, 60, 60, 0, 50}, {25, 0, 0, 30, 0, 35, 35, 30, 0}};
    private static final int[] ARMOR_TYPE_SLOTS = new int[]{0, 5, 4, 3, 4, 4, 5, 5, 5};
    private static final int[] ARMOR_TYPE_COSTS = new int[]{10000, 12500, 10000, 12000, 50000, 15000, 20000, 10000, 15000};
    private static final String[] ARMOR_TYPE_STRINGS = new String[]{"Standard", "Advanced", "Prototype", "Basic Stealth", "Prototype Stealth", "Standard Stealth", "Improved Stealth", "Fire Resistant", "Mimetic"};
    private static final int[] GROUND_MP_WEIGHT = new int[]{25, 30, 40, 80, 160};
    private static final int[][] JUMP_MP_LIMITS = new int[][]{{3, 3, 3, 2, 2}, {7, 6, 5, 0, 0}, {5, 5, 4, 3, 2}};
    private static final int[][] JUMP_MP_WEIGHT = new int[][]{{25, 25, 50, 125, 250}, {30, 40, 60, 0, 0}, {45, 45, 85, 160, 250}};
    private static final int[][] JUMP_MP_COST = new int[][]{{50000, 50000, 75000, 150000, 300000}, {50000, 50000, 100000, 0, 0}, {50000, 50000, 75000, 100000, 150000}};
    private static final int[] MANIPULATOR_TYPE_WEIGHT = new int[]{0, 0, 0, 15, 15, 35, 50, 20, 60, 30, 30, 30};
    private static final int[] MANIPULATOR_TYPE_COSTS = new int[]{0, 2500, 5000, 7500, 10000, 12500, 15000, 25000, 30000, 500, 2500};
    public static final int[] ARM_MAX_SLOTS = new int[]{2, 2, 3, 3, 4};
    public static final int[] TORSO_MAX_SLOTS = new int[]{2, 4, 4, 6, 8};
    public static final int[] QUAD_MAX_SLOTS = new int[]{0, 5, 7, 9, 11};
    public static final int LOCATION_ALLOWED_ANY = 0;
    public static final int LOCATION_ALLOWED_TORSO = 1;
    public static final int LOCATION_ALLOWED_ARM = 2;
    private static final int F_CONFLICT_JUMP_GEAR = 1;
    private static final String SPACES = "                        ";

    public CustomBattleArmorDialog(ClientGUI clientGUI, UnitLoadingDialog unitLoadingDialog) {
        super(clientGUI.frame, Messages.getString("CustomBattleArmorDialog.title"), true);
        this.m_client = clientGUI.getClient();
        this.m_clientgui = clientGUI;
        this.unitLoadingDialog = unitLoadingDialog;
        this.updatePlayerChoice();
        GridLayout gridLayout = new GridLayout();
        gridLayout.setColumns(1);
        gridLayout.setRows(0);
        this.m_pParams.setLayout(gridLayout);
        GridLayout gridLayout2 = new GridLayout(1, 2);
        Panel panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelBAName);
        this.m_tfBAName.addTextListener(this);
        panel.add(this.m_tfBAName);
        this.m_pParams.add(panel);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelMenPerSquad);
        this.m_chMenPerSquad.addItemListener(this);
        panel.add(this.m_chMenPerSquad);
        this.m_pParams.add(panel);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelTechBase);
        this.m_chTechBase.addItemListener(this);
        panel.add(this.m_chTechBase);
        this.m_pParams.add(panel);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelChassisType);
        this.m_chChassisType.addItemListener(this);
        panel.add(this.m_chChassisType);
        this.m_pParams.add(panel);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelWeightClass);
        this.m_chWeightClass.addItemListener(this);
        panel.add(this.m_chWeightClass);
        this.m_pParams.add(panel);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelGroundMP);
        this.m_chGroundMP.addItemListener(this);
        panel.add(this.m_chGroundMP);
        this.m_pParams.add(panel);
        gridLayout2 = new GridLayout(1, 3);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        this.m_cbJumpQuery.addItemListener(this);
        panel.add(this.m_cbJumpQuery);
        this.m_cbVTOLQuery.addItemListener(this);
        panel.add(this.m_cbVTOLQuery);
        this.m_cbUMUQuery.addItemListener(this);
        panel.add(this.m_cbUMUQuery);
        this.m_pParams.add(panel);
        gridLayout2 = new GridLayout(1, 2);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelJumpValue);
        this.m_chJumpValue.addItemListener(this);
        panel.add(this.m_chJumpValue);
        this.m_pParams.add(panel);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelArmorType);
        this.m_chArmorType.addItemListener(this);
        panel.add(this.m_chArmorType);
        this.m_pParams.add(panel);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelArmorValue);
        this.m_chArmorValue.addItemListener(this);
        panel.add(this.m_chArmorValue);
        this.m_pParams.add(panel);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelLeftManipulator);
        this.m_chLeftManipulator.addItemListener(this);
        panel.add(this.m_chLeftManipulator);
        this.m_pParams.add(panel);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelRightManipulator);
        this.m_chRightManipulator.addItemListener(this);
        panel.add(this.m_chRightManipulator);
        this.m_pParams.add(panel);
        gridLayout2 = new GridLayout(1, 3);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelTorsoEquipment);
        panel.add(this.m_chTorsoEquipment);
        this.m_buttonAddTorso.addActionListener(this);
        panel.add(this.m_buttonAddTorso);
        this.m_pParams.add(panel);
        gridLayout2 = new GridLayout(1, 3);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelRightArmEquipment);
        panel.add(this.m_chRightArmEquipment);
        this.m_buttonAddRightArm.addActionListener(this);
        panel.add(this.m_buttonAddRightArm);
        this.m_pParams.add(panel);
        gridLayout2 = new GridLayout(1, 3);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelLeftArmEquipment);
        panel.add(this.m_chLeftArmEquipment);
        this.m_buttonAddLeftArm.addActionListener(this);
        panel.add(this.m_buttonAddLeftArm);
        this.m_pParams.add(panel);
        gridLayout2 = new GridLayout(1, 3);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelTorsoCurrentEquipment);
        panel.add(this.m_chTorsoCurrentEquipment);
        this.m_buttonRemoveTorso.addActionListener(this);
        panel.add(this.m_buttonRemoveTorso);
        this.m_pParams.add(panel);
        gridLayout2 = new GridLayout(1, 3);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelRightArmCurrentEquipment);
        panel.add(this.m_chRightArmCurrentEquipment);
        this.m_buttonRemoveRightArm.addActionListener(this);
        panel.add(this.m_buttonRemoveRightArm);
        this.m_pParams.add(panel);
        gridLayout2 = new GridLayout(1, 3);
        panel = new Panel();
        panel.setLayout(gridLayout2);
        panel.add(this.m_labelLeftArmCurrentEquipment);
        panel.add(this.m_chLeftArmCurrentEquipment);
        this.m_buttonRemoveLeftArm.addActionListener(this);
        panel.add(this.m_buttonRemoveLeftArm);
        this.m_pParams.add(panel);
        this.m_pButtons.setLayout(new FlowLayout(1));
        this.m_pButtons.add(this.m_bPick);
        this.m_pButtons.add(this.m_bPickClose);
        this.m_pButtons.add(this.m_buttonReset);
        this.m_pButtons.add(this.m_bCancel);
        this.m_pButtons.add(this.m_labelPlayer);
        this.m_pButtons.add(this.m_chPlayer);
        this.m_pLeft.setLayout(new BorderLayout());
        this.m_pLeft.add((Component)this.m_pParams, "Center");
        this.m_pLeft.add((Component)this.m_pButtons, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_pLeft, "West");
        this.m_BAView.setFont(new Font("Monospaced", 0, 12));
        this.add((Component)this.m_BAView, "Center");
        this.setSize(800, 450);
        this.setLocation(this.computeDesiredLocation());
        new BattleArmorEquipment().initialize();
        this.populateChoices();
        this.m_bPick.addActionListener(this);
        this.m_bPickClose.addActionListener(this);
        this.m_buttonReset.addActionListener(this);
        this.m_bCancel.addActionListener(this);
        this.addWindowListener(this);
        this.updateWidgetEnablements();
        this.previewBA();
    }

    private void resetState() {
        this.restoreDefaultStates();
        this.populateChoices();
        this.previewBA();
    }

    private void restoreDefaultStates() {
        this.m_tfBAName.setText("");
        this.invalidReason = null;
        this.stateMenPerSquad = 1;
        this.stateTechBase = 0;
        this.stateChassisType = 0;
        this.stateWeightClass = 0;
        this.stateArmorType = 0;
        this.stateArmorValue = 0;
        this.stateJumpType = 0;
        this.stateJumpMP = 0;
        this.stateGroundMP = 1;
        this.stateCurrentWeight = 0;
        this.stateMinWeight = 0;
        this.stateMaxWeight = 400;
        this.stateManipulatorTypeLeft = 0;
        this.stateManipulatorTypeRight = 0;
        this.stateConflictFlags = 0;
        this.leftArmEquipment = null;
        this.rightArmEquipment = null;
        this.torsoEquipment = null;
    }

    private void updatePlayerChoice() {
        String string = this.m_chPlayer.getSelectedItem();
        this.m_chPlayer.removeAll();
        this.m_chPlayer.setEnabled(true);
        this.m_chPlayer.addItem(this.m_clientgui.getClient().getName());
        Iterator iterator = this.m_clientgui.getBots().values().iterator();
        while (iterator.hasNext()) {
            this.m_chPlayer.addItem(((Client)iterator.next()).getName());
        }
        if (this.m_chPlayer.getItemCount() == 1) {
            this.m_chPlayer.setEnabled(false);
        } else {
            this.m_chPlayer.select(string);
        }
    }

    public void run() {
    }

    private void populateChoices() {
        this.m_chTechBase.add("Inner Sphere");
        this.m_chTechBase.add("Clan");
        this.m_chTechBase.select(0);
        this.m_chMenPerSquad.add("1");
        this.m_chMenPerSquad.add("2");
        this.m_chMenPerSquad.add("3");
        this.m_chMenPerSquad.add("4");
        this.m_chMenPerSquad.add("5");
        this.m_chMenPerSquad.select(0);
        this.m_chChassisType.add("Biped");
        this.m_chChassisType.add("Quad");
        this.m_chChassisType.select(0);
        this.m_chWeightClass.add("PA(L)");
        this.m_chWeightClass.add("Light");
        this.m_chWeightClass.add("Medium");
        this.m_chWeightClass.add("Heavy");
        this.m_chWeightClass.add("Assault");
        this.m_chWeightClass.select(0);
        this.m_chGroundMP.add("1");
        this.m_chGroundMP.add("2");
        this.m_chGroundMP.add("3");
        this.m_chGroundMP.select(0);
        this.m_chJumpValue.add("0");
        this.m_chJumpValue.add("1");
        this.m_chJumpValue.add("2");
        this.m_chJumpValue.add("3");
        this.m_chJumpValue.select(0);
        this.m_chArmorType.add("Standard");
        this.m_chArmorType.add("Advanced");
        this.m_chArmorType.add("Prototype");
        this.m_chArmorType.add("Basic Stealth");
        this.m_chArmorType.add("Prototype Stealth");
        this.m_chArmorType.add("Standard Stealth");
        this.m_chArmorType.add("Improved Stealth");
        this.m_chArmorType.add("Fire Resistant");
        this.m_chArmorType.add("Mimetic");
        this.m_chArmorType.select(0);
        for (int i = 0; i < BattleArmor.MANIPULATOR_TYPE_STRINGS.length; ++i) {
            this.m_chLeftManipulator.add(BattleArmor.MANIPULATOR_TYPE_STRINGS[i]);
            this.m_chRightManipulator.add(BattleArmor.MANIPULATOR_TYPE_STRINGS[i]);
        }
        this.m_chLeftManipulator.select(0);
        this.m_chRightManipulator.select(0);
        this.m_chArmorValue.add("0");
        this.m_chArmorValue.add("1");
        this.m_chArmorValue.add("2");
        this.m_chArmorValue.select(0);
        this.updateEquipmentChoices();
    }

    private void updateEquipmentChoices() {
        BattleArmorEquipment battleArmorEquipment;
        int n;
        String string = this.m_chTorsoEquipment.getSelectedItem();
        this.m_chTorsoEquipment.removeAll();
        Object[] objectArray = equipmentTypes.toArray();
        for (n = 0; n < objectArray.length; ++n) {
            battleArmorEquipment = (BattleArmorEquipment)objectArray[n];
            if (battleArmorEquipment.techBase != 2 && battleArmorEquipment.techBase != this.stateTechBase || this.hasConflictFlag(battleArmorEquipment.conflictFlag) || battleArmorEquipment.allowedLocation != 0 && battleArmorEquipment.allowedLocation != 1) continue;
            this.m_chTorsoEquipment.add(battleArmorEquipment.name);
        }
        this.m_chTorsoEquipment.select(string);
        string = this.m_chRightArmEquipment.getSelectedItem();
        this.m_chRightArmEquipment.removeAll();
        if (this.stateChassisType != 1) {
            objectArray = equipmentTypes.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                battleArmorEquipment = (BattleArmorEquipment)objectArray[n];
                if (battleArmorEquipment.techBase != 2 && battleArmorEquipment.techBase != this.stateTechBase || this.hasConflictFlag(battleArmorEquipment.conflictFlag) || battleArmorEquipment.allowedLocation != 0 && battleArmorEquipment.allowedLocation != 2) continue;
                this.m_chRightArmEquipment.add(battleArmorEquipment.name);
            }
        }
        this.m_chRightArmEquipment.select(string);
        string = this.m_chLeftArmEquipment.getSelectedItem();
        this.m_chLeftArmEquipment.removeAll();
        if (this.stateChassisType != 1) {
            objectArray = equipmentTypes.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                battleArmorEquipment = (BattleArmorEquipment)objectArray[n];
                if (battleArmorEquipment.techBase != 2 && battleArmorEquipment.techBase != this.stateTechBase || this.hasConflictFlag(battleArmorEquipment.conflictFlag) || battleArmorEquipment.allowedLocation != 0 && battleArmorEquipment.allowedLocation != 2) continue;
                this.m_chLeftArmEquipment.add(battleArmorEquipment.name);
            }
        }
        this.m_chLeftArmEquipment.select(string);
        this.m_chLeftArmCurrentEquipment.removeAll();
        if (this.leftArmEquipment != null) {
            Enumeration enumeration = this.leftArmEquipment.elements();
            while (enumeration.hasMoreElements()) {
                battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                this.m_chLeftArmCurrentEquipment.add(battleArmorEquipment.name);
            }
        }
        this.m_chRightArmCurrentEquipment.removeAll();
        if (this.rightArmEquipment != null) {
            Enumeration enumeration = this.rightArmEquipment.elements();
            while (enumeration.hasMoreElements()) {
                battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                this.m_chRightArmCurrentEquipment.add(battleArmorEquipment.name);
            }
        }
        this.m_chTorsoCurrentEquipment.removeAll();
        if (this.torsoEquipment != null) {
            Enumeration enumeration = this.torsoEquipment.elements();
            while (enumeration.hasMoreElements()) {
                battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                this.m_chTorsoCurrentEquipment.add(battleArmorEquipment.name);
            }
        }
    }

    private boolean hasConflictFlag(int n) {
        return (this.stateConflictFlags & n) > 0;
    }

    private void updateGroundMPChoices() {
        int n = this.m_chGroundMP.getSelectedIndex();
        this.m_chGroundMP.removeAll();
        if (this.stateChassisType == 0) {
            this.m_chGroundMP.add("1");
            this.m_chGroundMP.add("2");
            if (this.stateWeightClass == 0 || this.stateWeightClass == 1 || this.stateWeightClass == 2) {
                this.m_chGroundMP.add("3");
            }
        } else {
            this.m_chGroundMP.add("2");
            this.m_chGroundMP.add("3");
            this.m_chGroundMP.add("4");
            if (this.stateWeightClass == 1 || this.stateWeightClass == 2) {
                this.m_chGroundMP.add("5");
            }
        }
        this.m_chGroundMP.select(0);
        this.stateGroundMP = Integer.parseInt(this.m_chGroundMP.getSelectedItem());
    }

    private void updateJumpMPChoices() {
        int n = this.m_chJumpValue.getSelectedIndex();
        this.m_chJumpValue.removeAll();
        for (int i = 0; i <= JUMP_MP_LIMITS[this.stateJumpType][this.stateWeightClass]; ++i) {
            this.m_chJumpValue.add(Integer.toString(i));
        }
        if (n >= this.m_chJumpValue.getItemCount()) {
            this.m_chJumpValue.select(this.m_chJumpValue.getItemCount() - 1);
            this.stateJumpMP = this.m_chJumpValue.getSelectedIndex();
        } else {
            this.m_chJumpValue.select(n);
        }
    }

    private void updateArmorValueChoices() {
        int n = this.m_chArmorValue.getSelectedIndex();
        this.m_chArmorValue.removeAll();
        this.m_chArmorValue.add("0");
        this.m_chArmorValue.add("1");
        this.m_chArmorValue.add("2");
        if (this.stateWeightClass > 0) {
            this.m_chArmorValue.add("3");
            this.m_chArmorValue.add("4");
            this.m_chArmorValue.add("5");
            this.m_chArmorValue.add("6");
            if (this.stateWeightClass > 1) {
                this.m_chArmorValue.add("7");
                this.m_chArmorValue.add("8");
                this.m_chArmorValue.add("9");
                this.m_chArmorValue.add("10");
                if (this.stateWeightClass > 2) {
                    this.m_chArmorValue.add("11");
                    this.m_chArmorValue.add("12");
                    this.m_chArmorValue.add("13");
                    this.m_chArmorValue.add("14");
                    if (this.stateWeightClass > 3) {
                        this.m_chArmorValue.add("15");
                        this.m_chArmorValue.add("16");
                        this.m_chArmorValue.add("17");
                        this.m_chArmorValue.add("18");
                    }
                }
            }
        }
        if (n >= this.m_chArmorValue.getItemCount()) {
            this.m_chArmorValue.select(this.m_chArmorValue.getItemCount() - 1);
            this.stateArmorValue = this.m_chArmorValue.getSelectedIndex();
        } else {
            this.m_chArmorValue.select(n);
        }
    }

    private Point computeDesiredLocation() {
        int n;
        int n2 = this.m_clientgui.frame.getLocation().x + this.m_clientgui.frame.getSize().width / 2 - this.getSize().width / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = this.m_clientgui.frame.getLocation().y + this.m_clientgui.frame.getSize().height / 2 - this.getSize().height / 2) < 0) {
            n = 0;
        }
        return new Point(n2, n);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.updatePlayerChoice();
            this.setLocation(this.computeDesiredLocation());
            this.m_BAView.setCaretPosition(0);
        }
        super.setVisible(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_buttonReset) {
            this.resetState();
            return;
        }
        if (actionEvent.getSource() == this.m_buttonAddTorso) {
            BattleArmorEquipment battleArmorEquipment = (BattleArmorEquipment)equipmentTypes.get(equipmentNames.indexOf(this.m_chTorsoEquipment.getSelectedItem()));
            if (this.torsoEquipment == null) {
                this.torsoEquipment = new Vector();
            }
            this.torsoEquipment.add(battleArmorEquipment);
            this.stateConflictFlags |= battleArmorEquipment.conflictFlag;
            this.previewBA();
            this.updateEquipmentChoices();
            return;
        }
        if (actionEvent.getSource() == this.m_buttonAddRightArm) {
            BattleArmorEquipment battleArmorEquipment = (BattleArmorEquipment)equipmentTypes.get(equipmentNames.indexOf(this.m_chRightArmEquipment.getSelectedItem()));
            if (this.rightArmEquipment == null) {
                this.rightArmEquipment = new Vector();
            }
            this.rightArmEquipment.add(battleArmorEquipment);
            this.stateConflictFlags |= battleArmorEquipment.conflictFlag;
            this.previewBA();
            this.updateEquipmentChoices();
            return;
        }
        if (actionEvent.getSource() == this.m_buttonAddLeftArm) {
            BattleArmorEquipment battleArmorEquipment = (BattleArmorEquipment)equipmentTypes.get(equipmentNames.indexOf(this.m_chLeftArmEquipment.getSelectedItem()));
            if (this.leftArmEquipment == null) {
                this.leftArmEquipment = new Vector();
            }
            this.leftArmEquipment.add(battleArmorEquipment);
            this.stateConflictFlags |= battleArmorEquipment.conflictFlag;
            this.previewBA();
            this.updateEquipmentChoices();
            return;
        }
        if (actionEvent.getSource() == this.m_buttonRemoveTorso) {
            if (this.torsoEquipment != null) {
                String string = this.m_chTorsoCurrentEquipment.getSelectedItem();
                Enumeration enumeration = this.torsoEquipment.elements();
                while (enumeration.hasMoreElements()) {
                    BattleArmorEquipment battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                    if (!battleArmorEquipment.name.equals(string)) continue;
                    this.torsoEquipment.remove(battleArmorEquipment);
                    break;
                }
                if (this.torsoEquipment.size() <= 0) {
                    this.torsoEquipment = null;
                }
                this.previewBA();
                this.updateEquipmentChoices();
            }
            return;
        }
        if (actionEvent.getSource() == this.m_buttonRemoveRightArm) {
            if (this.rightArmEquipment != null) {
                String string = this.m_chRightArmCurrentEquipment.getSelectedItem();
                Enumeration enumeration = this.rightArmEquipment.elements();
                while (enumeration.hasMoreElements()) {
                    BattleArmorEquipment battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                    if (!battleArmorEquipment.name.equals(string)) continue;
                    this.rightArmEquipment.remove(battleArmorEquipment);
                    break;
                }
                if (this.rightArmEquipment.size() <= 0) {
                    this.rightArmEquipment = null;
                }
                this.previewBA();
                this.updateEquipmentChoices();
            }
            return;
        }
        if (actionEvent.getSource() == this.m_buttonRemoveLeftArm) {
            if (this.leftArmEquipment != null) {
                String string = this.m_chLeftArmCurrentEquipment.getSelectedItem();
                Enumeration enumeration = this.leftArmEquipment.elements();
                while (enumeration.hasMoreElements()) {
                    BattleArmorEquipment battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                    if (!battleArmorEquipment.name.equals(string)) continue;
                    this.leftArmEquipment.remove(battleArmorEquipment);
                    break;
                }
                if (this.leftArmEquipment.size() <= 0) {
                    this.leftArmEquipment = null;
                }
                this.previewBA();
                this.updateEquipmentChoices();
            }
            return;
        }
        if (actionEvent.getSource() == this.m_bPick || actionEvent.getSource() == this.m_bPickClose) {
            if (!this.isValid()) {
                new AlertDialog(this.m_clientgui.frame, "Can't do that!", "You can't add an invalid unit.").setVisible(true);
                return;
            }
            try {
                BattleArmor battleArmor = this.getEntity();
                Client client = null;
                if (this.m_chPlayer.getSelectedIndex() > 0) {
                    String string = this.m_chPlayer.getSelectedItem();
                    client = (Client)this.m_clientgui.getBots().get(string);
                }
                if (client == null) {
                    client = this.m_client;
                }
                battleArmor.setOwner(client.getLocalPlayer());
                client.sendAddEntity(battleArmor);
            }
            catch (Exception exception) {
                System.err.println("Error while loading custom BattleArmor!");
                exception.printStackTrace();
                return;
            }
        }
        if (actionEvent.getSource() == this.m_bCancel || actionEvent.getSource() == this.m_bPickClose) {
            this.setVisible(false);
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        this.previewBA();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.m_cbJumpQuery) {
            if (this.m_cbJumpQuery.getState()) {
                this.stateJumpType = 0;
                this.updateJumpMPChoices();
                this.m_labelJumpValue.setText(Messages.getString("CustomBattleArmorDialog.m_labelJumpValue"));
            }
        } else if (itemEvent.getSource() == this.m_cbVTOLQuery) {
            if (this.m_cbVTOLQuery.getState()) {
                this.stateJumpType = 1;
                this.updateJumpMPChoices();
                this.m_labelJumpValue.setText(Messages.getString("CustomBattleArmorDialog.m_labelVTOLValue"));
            }
        } else if (itemEvent.getSource() == this.m_cbUMUQuery) {
            if (this.m_cbUMUQuery.getState()) {
                this.stateJumpType = 2;
                this.updateJumpMPChoices();
                this.m_labelJumpValue.setText(Messages.getString("CustomBattleArmorDialog.m_labelUMUValue"));
            }
        } else if (itemEvent.getSource() == this.m_chMenPerSquad) {
            if (this.stateMenPerSquad != Integer.parseInt(this.m_chMenPerSquad.getSelectedItem())) {
                this.stateMenPerSquad = Integer.parseInt(this.m_chMenPerSquad.getSelectedItem());
            }
        } else if (itemEvent.getSource() == this.m_chTechBase) {
            if (this.stateTechBase != this.m_chTechBase.getSelectedIndex()) {
                this.stateTechBase = this.m_chTechBase.getSelectedIndex();
                this.updateEquipmentChoices();
            }
        } else if (itemEvent.getSource() == this.m_chChassisType) {
            if (this.stateChassisType != this.m_chChassisType.getSelectedIndex()) {
                this.stateChassisType = this.m_chChassisType.getSelectedIndex();
                if (this.stateChassisType == 1) {
                    this.leftArmEquipment = null;
                    this.rightArmEquipment = null;
                }
                this.updateGroundMPChoices();
                this.updateJumpMPChoices();
                this.updateEquipmentChoices();
            }
        } else if (itemEvent.getSource() == this.m_chWeightClass) {
            if (this.stateWeightClass != this.m_chWeightClass.getSelectedIndex()) {
                this.stateWeightClass = this.m_chWeightClass.getSelectedIndex();
                switch (this.stateWeightClass) {
                    case 0: {
                        this.stateMinWeight = 0;
                        this.stateMaxWeight = 400;
                        break;
                    }
                    case 1: {
                        this.stateMinWeight = 401;
                        this.stateMaxWeight = 750;
                        break;
                    }
                    case 2: {
                        this.stateMinWeight = 751;
                        this.stateMaxWeight = 1000;
                        break;
                    }
                    case 3: {
                        this.stateMinWeight = 1001;
                        this.stateMaxWeight = 1500;
                        break;
                    }
                    case 4: {
                        this.stateMinWeight = 1501;
                        this.stateMaxWeight = 2000;
                    }
                }
                this.updateGroundMPChoices();
                this.updateJumpMPChoices();
                this.updateArmorValueChoices();
            }
        } else if (itemEvent.getSource() == this.m_chGroundMP) {
            if (this.stateGroundMP != Integer.parseInt(this.m_chGroundMP.getSelectedItem())) {
                this.stateGroundMP = Integer.parseInt(this.m_chGroundMP.getSelectedItem());
            }
        } else if (itemEvent.getSource() == this.m_chJumpValue) {
            if (this.stateJumpMP != this.m_chJumpValue.getSelectedIndex()) {
                this.stateJumpMP = this.m_chJumpValue.getSelectedIndex();
            }
        } else if (itemEvent.getSource() == this.m_chLeftManipulator) {
            if (this.stateManipulatorTypeLeft != this.m_chLeftManipulator.getSelectedIndex()) {
                this.stateManipulatorTypeLeft = this.m_chLeftManipulator.getSelectedIndex();
            }
        } else if (itemEvent.getSource() == this.m_chRightManipulator) {
            if (this.stateManipulatorTypeRight != this.m_chRightManipulator.getSelectedIndex()) {
                this.stateManipulatorTypeRight = this.m_chRightManipulator.getSelectedIndex();
            }
        } else if (itemEvent.getSource() == this.m_chArmorType) {
            if (this.stateArmorType != this.m_chArmorType.getSelectedIndex()) {
                this.stateArmorType = this.m_chArmorType.getSelectedIndex();
            }
        } else if (itemEvent.getSource() == this.m_chArmorValue && this.stateArmorValue != this.m_chArmorValue.getSelectedIndex()) {
            this.stateArmorValue = this.m_chArmorValue.getSelectedIndex();
        }
        this.previewBA();
    }

    void clearBAPreview() {
        this.m_BAView.setEditable(false);
        this.m_BAView.setText("");
    }

    void previewBA() {
        String string = this.generateBattleArmorPreview();
        this.m_BAView.setEditable(false);
        this.m_BAView.setText(string);
    }

    private String makeLength(String string, int n) {
        if (string.length() == n) {
            return string;
        }
        if (string.length() > n) {
            return string.substring(0, n - 2) + "..";
        }
        return string + SPACES.substring(0, n - string.length());
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            ActionEvent actionEvent = new ActionEvent(this.m_bPick, 1001, "");
            this.actionPerformed(actionEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private void updateWidgetEnablements() {
        this.m_bPick.setEnabled(true);
        this.m_bPickClose.setEnabled(true);
    }

    public String generateBattleArmorPreview() {
        BattleArmorEquipment battleArmorEquipment;
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.isValid()) {
            stringBuffer.append(">>>");
            stringBuffer.append(Messages.getString("CustomBattleArmorDialog.valid"));
            stringBuffer.append("<<<");
        } else {
            stringBuffer.append(">>>");
            stringBuffer.append(Messages.getString("CustomBattleArmorDialog.invalid"));
            stringBuffer.append("<<<\n");
            if (this.invalidReason != null) {
                stringBuffer.append(this.invalidReason);
            }
        }
        stringBuffer.append("\n\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.m_labelBAName"));
        if (this.m_tfBAName.getText().trim().length() < 1) {
            stringBuffer.append("<NONE>");
        } else {
            stringBuffer.append(this.m_tfBAName.getText());
        }
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.m_labelMenPerSquad"));
        stringBuffer.append(this.stateMenPerSquad);
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.m_labelTechBase"));
        if (this.stateTechBase == 0) {
            stringBuffer.append(Messages.getString("CustomBattleArmorDialog.tech_base_inner_sphere"));
        } else {
            stringBuffer.append(Messages.getString("CustomBattleArmorDialog.tech_base_clan"));
        }
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.m_labelChassisType"));
        if (this.stateChassisType == 0) {
            stringBuffer.append(Messages.getString("CustomBattleArmorDialog.chassis_type_biped"));
        } else {
            stringBuffer.append(Messages.getString("CustomBattleArmorDialog.chassis_type_quad"));
        }
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.m_labelWeightClass"));
        switch (this.stateWeightClass) {
            case 0: {
                stringBuffer.append(Messages.getString("CustomBattleArmorDialog.weight_class_pal"));
                break;
            }
            case 1: {
                stringBuffer.append(Messages.getString("CustomBattleArmorDialog.weight_class_light"));
                break;
            }
            case 2: {
                stringBuffer.append(Messages.getString("CustomBattleArmorDialog.weight_class_medium"));
                break;
            }
            case 3: {
                stringBuffer.append(Messages.getString("CustomBattleArmorDialog.weight_class_heavy"));
                break;
            }
            case 4: {
                stringBuffer.append(Messages.getString("CustomBattleArmorDialog.weight_class_assault"));
            }
        }
        stringBuffer.append(" (");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.weight"));
        stringBuffer.append(this.getChassisWeight());
        stringBuffer.append(")");
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.min_weight"));
        stringBuffer.append(this.stateMinWeight);
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.max_weight"));
        stringBuffer.append(this.stateMaxWeight);
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.current_weight"));
        stringBuffer.append(this.stateCurrentWeight);
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.m_labelGroundMP"));
        stringBuffer.append(this.stateGroundMP);
        stringBuffer.append(" (");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.weight"));
        stringBuffer.append(this.getGroundMPWeight());
        stringBuffer.append(")");
        stringBuffer.append("\n");
        if (this.stateJumpType == 0) {
            stringBuffer.append(Messages.getString("CustomBattleArmorDialog.m_labelJumpValue"));
        } else if (this.stateJumpType == 1) {
            stringBuffer.append(Messages.getString("CustomBattleArmorDialog.m_labelVTOLValue"));
        } else if (this.stateJumpType == 2) {
            stringBuffer.append(Messages.getString("CustomBattleArmorDialog.m_labelUMUValue"));
        }
        stringBuffer.append(this.getTotalJumpMP());
        stringBuffer.append(" (");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.weight"));
        stringBuffer.append(this.getJumpMPWeight());
        stringBuffer.append(")");
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.m_labelArmorType"));
        stringBuffer.append(ARMOR_TYPE_STRINGS[this.stateArmorType]);
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.m_labelArmorValue"));
        stringBuffer.append(this.stateArmorValue);
        stringBuffer.append(" (");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.weight"));
        stringBuffer.append(this.getArmorWeight());
        stringBuffer.append(")");
        stringBuffer.append("\n\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.equipment"));
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.m_labelLeftManipulator"));
        stringBuffer.append(BattleArmor.MANIPULATOR_TYPE_STRINGS[this.stateManipulatorTypeLeft]);
        stringBuffer.append(" (");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.weight"));
        stringBuffer.append(MANIPULATOR_TYPE_WEIGHT[this.stateManipulatorTypeLeft]);
        stringBuffer.append(")");
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.m_labelRightManipulator"));
        stringBuffer.append(BattleArmor.MANIPULATOR_TYPE_STRINGS[this.stateManipulatorTypeRight]);
        stringBuffer.append(" (");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.weight"));
        stringBuffer.append(MANIPULATOR_TYPE_WEIGHT[this.stateManipulatorTypeRight]);
        stringBuffer.append(")");
        stringBuffer.append("\n\n");
        if (this.torsoEquipment != null) {
            enumeration = this.torsoEquipment.elements();
            while (enumeration.hasMoreElements()) {
                battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                stringBuffer.append(battleArmorEquipment.getDescription());
                stringBuffer.append("\n");
            }
        }
        if (this.rightArmEquipment != null) {
            enumeration = this.rightArmEquipment.elements();
            while (enumeration.hasMoreElements()) {
                battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                stringBuffer.append(battleArmorEquipment.getDescription());
                stringBuffer.append("\n");
            }
        }
        if (this.leftArmEquipment != null) {
            enumeration = this.leftArmEquipment.elements();
            while (enumeration.hasMoreElements()) {
                battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                stringBuffer.append(battleArmorEquipment.getDescription());
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.bvEach"));
        stringBuffer.append(this.calcSuitBV());
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.bvSquad"));
        stringBuffer.append(this.calcSquadBV());
        stringBuffer.append("\n\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.costEach"));
        stringBuffer.append(this.calcSuitCost());
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("CustomBattleArmorDialog.costSquad"));
        stringBuffer.append(this.calcSquadCost());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void calcCurrentWeight() {
        BattleArmorEquipment battleArmorEquipment;
        Enumeration enumeration;
        this.stateCurrentWeight = 0;
        this.stateCurrentWeight += this.getChassisWeight();
        this.stateCurrentWeight += this.getArmorWeight();
        this.stateCurrentWeight += this.getGroundMPWeight();
        this.stateCurrentWeight += this.getJumpMPWeight();
        this.stateCurrentWeight += this.getManipulatorWeight();
        if (this.leftArmEquipment != null) {
            enumeration = this.leftArmEquipment.elements();
            while (enumeration.hasMoreElements()) {
                battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                this.stateCurrentWeight += battleArmorEquipment.weight;
            }
        }
        if (this.rightArmEquipment != null) {
            enumeration = this.rightArmEquipment.elements();
            while (enumeration.hasMoreElements()) {
                battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                this.stateCurrentWeight += battleArmorEquipment.weight;
            }
        }
        if (this.torsoEquipment != null) {
            enumeration = this.torsoEquipment.elements();
            while (enumeration.hasMoreElements()) {
                battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                this.stateCurrentWeight += battleArmorEquipment.weight;
            }
        }
    }

    public boolean isValid() {
        BattleArmorEquipment battleArmorEquipment;
        Enumeration enumeration;
        Enumeration enumeration2;
        int n;
        this.calcCurrentWeight();
        if (this.m_tfBAName.getText() == null || this.m_tfBAName.getText().trim().length() < 1) {
            this.invalidReason = "Squads must be named.";
            return false;
        }
        if (this.stateChassisType == 1 && this.stateWeightClass == 0) {
            this.invalidReason = "PA(L) suits cannot have a quad chassis.";
            return false;
        }
        if (this.stateCurrentWeight > this.stateMaxWeight) {
            this.invalidReason = "Suit overweight.";
            return false;
        }
        if (ARMOR_TYPE_WEIGHT[this.stateTechBase][this.stateArmorType] == 0) {
            this.invalidReason = ARMOR_TYPE_STRINGS[this.stateArmorType] + " Armor not legal for chosen tech base.";
            return false;
        }
        if (this.stateManipulatorTypeLeft == 10 && this.stateManipulatorTypeRight != 10 || this.stateManipulatorTypeRight == 10 && this.stateManipulatorTypeLeft != 10) {
            this.invalidReason = "Cargo lifter manipulators must be mounted in pairs.";
            return false;
        }
        if (this.stateManipulatorTypeLeft == 5 && this.stateManipulatorTypeRight != 5 || this.stateManipulatorTypeRight == 5 && this.stateManipulatorTypeLeft != 5) {
            this.invalidReason = "Magnetic manipulators must be mounted in pairs.";
            return false;
        }
        if (this.stateManipulatorTypeLeft == 3 && this.stateManipulatorTypeRight != 3 || this.stateManipulatorTypeRight == 3 && this.stateManipulatorTypeLeft != 3) {
            this.invalidReason = "Mine clearance manipulators must be mounted in pairs.";
            return false;
        }
        if (this.stateChassisType == 1) {
            if (this.torsoEquipment != null) {
                n = 0;
                enumeration2 = this.torsoEquipment.elements();
                while (enumeration2.hasMoreElements()) {
                    enumeration = (BattleArmorEquipment)enumeration2.nextElement();
                    n += ((BattleArmorEquipment)((Object)enumeration)).slots;
                }
                if (n > QUAD_MAX_SLOTS[this.stateWeightClass] - ARMOR_TYPE_SLOTS[this.stateArmorType]) {
                    this.invalidReason = "Unit is using more slots than are available.";
                    return false;
                }
            }
        } else {
            int n2;
            n = 2 * ARM_MAX_SLOTS[this.stateWeightClass] + TORSO_MAX_SLOTS[this.stateWeightClass];
            if (this.leftArmEquipment != null) {
                n2 = 0;
                enumeration = this.leftArmEquipment.elements();
                while (enumeration.hasMoreElements()) {
                    battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                    n2 += battleArmorEquipment.slots;
                }
                if (n2 > ARM_MAX_SLOTS[this.stateWeightClass]) {
                    this.invalidReason = "Left Arm is using more slots than are available.";
                    return false;
                }
                n -= n2;
            }
            if (this.rightArmEquipment != null) {
                n2 = 0;
                enumeration = this.rightArmEquipment.elements();
                while (enumeration.hasMoreElements()) {
                    battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                    n2 += battleArmorEquipment.slots;
                }
                if (n2 > ARM_MAX_SLOTS[this.stateWeightClass]) {
                    this.invalidReason = "Right Arm is using more slots than are available.";
                    return false;
                }
                n -= n2;
            }
            if (this.torsoEquipment != null) {
                n2 = 0;
                enumeration = this.torsoEquipment.elements();
                while (enumeration.hasMoreElements()) {
                    battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                    n2 += battleArmorEquipment.slots;
                }
                if (n2 > TORSO_MAX_SLOTS[this.stateWeightClass]) {
                    this.invalidReason = "Torso is using more slots than are available.";
                    return false;
                }
                n -= n2;
            }
            if (n < ARMOR_TYPE_SLOTS[this.stateArmorType]) {
                this.invalidReason = "Unit is using more total slots than are available.";
                return false;
            }
        }
        if (this.stateChassisType == 1) {
            if (this.torsoEquipment != null) {
                n = 0;
                enumeration2 = this.torsoEquipment.elements();
                while (enumeration2.hasMoreElements()) {
                    enumeration = (BattleArmorEquipment)enumeration2.nextElement();
                    if (((BattleArmorEquipment)((Object)enumeration)).internalType != EQUIPMENT_TYPE_WEAPON && ((BattleArmorEquipment)((Object)enumeration)).internalType != EQUIPMENT_TYPE_WEAPON_AP) continue;
                    ++n;
                }
                if (n > 4) {
                    this.invalidReason = "Unit has more weapons than it is allowed (limit of 4).";
                    return false;
                }
            }
        } else {
            if (this.torsoEquipment != null) {
                n = 0;
                int n3 = 0;
                enumeration = this.torsoEquipment.elements();
                while (enumeration.hasMoreElements()) {
                    battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                    if (battleArmorEquipment.internalType == EQUIPMENT_TYPE_WEAPON) {
                        ++n3;
                        continue;
                    }
                    if (battleArmorEquipment.internalType != EQUIPMENT_TYPE_WEAPON_AP) continue;
                    ++n;
                }
                if (n3 > 2) {
                    this.invalidReason = "Unit has more anti-'Mech weapons than it is allowed in its torso (limit of 2).";
                    return false;
                }
                if (n > 2) {
                    this.invalidReason = "Unit has more anti-personnel weapons than it is allowed in its torso (limit of 2).";
                    return false;
                }
            }
            if (this.rightArmEquipment != null) {
                n = 0;
                int n4 = 0;
                enumeration = this.rightArmEquipment.elements();
                while (enumeration.hasMoreElements()) {
                    battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                    if (battleArmorEquipment.internalType == EQUIPMENT_TYPE_WEAPON) {
                        ++n;
                        ++n4;
                        continue;
                    }
                    if (battleArmorEquipment.internalType != EQUIPMENT_TYPE_WEAPON_AP) continue;
                    ++n;
                }
                if (n4 > 1) {
                    this.invalidReason = "Unit has more anti-'Mech weapons than it is allowed in its right arm (limit of 1).";
                    return false;
                }
                if (n > 2) {
                    this.invalidReason = "Unit has more weapons than it is allowed in its right arm (limit of 2).";
                    return false;
                }
            }
            if (this.leftArmEquipment != null) {
                n = 0;
                int n5 = 0;
                enumeration = this.leftArmEquipment.elements();
                while (enumeration.hasMoreElements()) {
                    battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                    if (battleArmorEquipment.internalType == EQUIPMENT_TYPE_WEAPON) {
                        ++n;
                        ++n5;
                        continue;
                    }
                    if (battleArmorEquipment.internalType != EQUIPMENT_TYPE_WEAPON_AP) continue;
                    ++n;
                }
                if (n5 > 1) {
                    this.invalidReason = "Unit has more anti-'Mech weapons than it is allowed in its left arm (limit of 1).";
                    return false;
                }
                if (n > 2) {
                    this.invalidReason = "Unit has more weapons than it is allowed in its left arm (limit of 2).";
                    return false;
                }
            }
        }
        return true;
    }

    public int getChassisWeight() {
        return CustomBattleArmorDialog.getChassisWeight(this.stateWeightClass, this.stateTechBase);
    }

    public static int getChassisWeight(int n, int n2) {
        if (n2 == 0) {
            switch (n) {
                case 0: {
                    return 80;
                }
                case 1: {
                    return 100;
                }
                case 2: {
                    return 175;
                }
                case 3: {
                    return 300;
                }
                case 4: {
                    return 550;
                }
            }
        } else {
            switch (n) {
                case 0: {
                    return 130;
                }
                case 1: {
                    return 150;
                }
                case 2: {
                    return 250;
                }
                case 3: {
                    return 400;
                }
                case 4: {
                    return 700;
                }
            }
        }
        return 0;
    }

    public int getArmorWeight() {
        return CustomBattleArmorDialog.getArmorWeight(this.stateTechBase, this.stateArmorType, this.stateArmorValue);
    }

    public static int getArmorWeight(int n, int n2, int n3) {
        return n3 * ARMOR_TYPE_WEIGHT[n][n2];
    }

    public int getGroundMPWeight() {
        return CustomBattleArmorDialog.getGroundMPWeight(this.stateChassisType, this.stateWeightClass, this.stateGroundMP);
    }

    public static int getGroundMPWeight(int n, int n2, int n3) {
        return (n3 - (n == 0 ? 1 : 2)) * GROUND_MP_WEIGHT[n2];
    }

    public int getJumpMPWeight() {
        return CustomBattleArmorDialog.getJumpMPWeight(this.stateJumpType, this.stateWeightClass, this.stateJumpMP);
    }

    public static int getJumpMPWeight(int n, int n2, int n3) {
        return n3 * JUMP_MP_WEIGHT[n][n2];
    }

    public int getManipulatorWeight() {
        return MANIPULATOR_TYPE_WEIGHT[this.stateManipulatorTypeLeft] + MANIPULATOR_TYPE_WEIGHT[this.stateManipulatorTypeRight];
    }

    public int calcSuitBV() {
        float f = 1.5f;
        f += (float)(this.stateArmorValue * (this.stateArmorType == 7 ? 3 : 2));
        int n = 0;
        if (this.stateGroundMP >= 5) {
            n = 2;
        } else if (this.stateGroundMP >= 3) {
            n = 1;
        }
        int n2 = 0;
        if (this.getTotalJumpMP() >= 7) {
            n2 = 3;
        } else if (this.getTotalJumpMP() >= 5) {
            n2 = 2;
        } else if (this.getTotalJumpMP() >= 3) {
            n2 = 1;
        }
        if (this.stateJumpType != 2) {
            ++n2;
        }
        float f2 = n > n2 ? n : n2;
        if (this.stateArmorType == 8 || this.stateArmorType == 6) {
            f2 += 3.0f;
        } else if (this.stateArmorType == 5 || this.stateArmorType == 4 || this.stateArmorType == 3) {
            f2 += 2.0f;
        }
        f2 /= 10.0f;
        f *= (f2 += 1.0f);
        float f3 = 0.0f;
        if (this.canDoAntiMech()) {
            // empty if block
        }
        int n3 = Math.max(this.stateGroundMP, this.getTotalJumpMP());
        float f4 = 0.0f;
        switch (n3) {
            case 1: {
                f4 = 0.54f;
                break;
            }
            case 2: {
                f4 = 0.65f;
                break;
            }
            case 3: {
                f4 = 0.77f;
                break;
            }
            case 4: {
                f4 = 0.88f;
                break;
            }
            case 5: {
                f4 = 1.0f;
                break;
            }
            case 6: {
                f4 = 1.12f;
                break;
            }
            case 7: {
                f4 = 1.24f;
                break;
            }
            case 8: {
                f4 = 1.37f;
                break;
            }
            case 9: {
                f4 = 1.5f;
                break;
            }
            case 10: {
                f4 = 1.63f;
                break;
            }
            case 11: {
                f4 = 1.76f;
                break;
            }
            case 12: {
                f4 = 1.89f;
            }
        }
        int n4 = Math.round(f + (f3 *= f4));
        return n4;
    }

    public int calcSquadBV() {
        return this.calcSuitBV() * this.stateMenPerSquad;
    }

    public int calcSuitCost() {
        float f = 0.0f;
        switch (this.stateWeightClass) {
            case 0: 
            case 1: {
                f += 50000.0f;
                break;
            }
            case 2: {
                f += 100000.0f;
                break;
            }
            case 3: {
                f += 200000.0f;
                break;
            }
            case 4: {
                f += 400000.0f;
            }
        }
        f += (float)((this.stateGroundMP - (this.stateChassisType == 0 ? 1 : 2)) * 25000);
        f += (float)(this.stateJumpMP * JUMP_MP_COST[this.stateJumpType][this.stateWeightClass]);
        f += (float)(ARMOR_TYPE_COSTS[this.stateArmorType] * this.stateArmorValue);
        f += (float)MANIPULATOR_TYPE_COSTS[this.stateManipulatorTypeLeft];
        f += (float)MANIPULATOR_TYPE_COSTS[this.stateManipulatorTypeRight];
        if (this.stateTechBase == 1) {
            f = (float)((double)f * 1.1);
        }
        f = this.stateTechBase == 0 ? (f += 150000.0f) : (f += 200000.0f);
        return Math.round(f);
    }

    public int calcSquadCost() {
        return this.calcSuitCost() * this.stateMenPerSquad;
    }

    public BattleArmor getEntity() {
        BattleArmor battleArmor;
        block24: {
            battleArmor = new BattleArmor();
            battleArmor.setChassis(this.m_tfBAName.getText().trim());
            battleArmor.setModel("");
            battleArmor.setWeightClass(this.stateWeightClass);
            battleArmor.setChassisType(this.stateChassisType);
            battleArmor.setWeight(this.stateMenPerSquad);
            battleArmor.refreshLocations();
            battleArmor.autoSetInternal();
            battleArmor.setArmorType(this.stateArmorType);
            for (int i = 1; i < battleArmor.locations(); ++i) {
                battleArmor.initializeArmor(this.stateArmorValue, i);
            }
            if (this.stateTechBase == 0) {
                battleArmor.setTechLevel(1);
            } else {
                battleArmor.setTechLevel(2);
            }
            battleArmor.setOriginalWalkMP(this.stateGroundMP);
            battleArmor.setOriginalJumpMP(this.getTotalJumpMP());
            if (this.stateJumpType == 1) {
                battleArmor.setMovementMode(6);
            } else if (this.stateJumpType == 2) {
                battleArmor.setMovementMode(9);
            } else {
                battleArmor.setMovementMode(10);
            }
            battleArmor.setBattleValue(this.calcSquadBV());
            battleArmor.setCost(this.calcSquadCost());
            try {
                BattleArmorEquipment battleArmorEquipment;
                if (this.stateArmorType == 7) {
                    battleArmor.addEquipment(EquipmentType.get("BA-Fire Resistant Armor"), 0);
                }
                if (this.canDoAntiMech()) {
                    battleArmor.addEquipment(EquipmentType.get("LegAttack"), 0);
                    battleArmor.addEquipment(EquipmentType.get("SwarmMek"), 0);
                    battleArmor.addEquipment(EquipmentType.get("StopSwarm"), 0);
                    if (this.stateManipulatorTypeLeft == 5) {
                        battleArmor.addEquipment(EquipmentType.get("BA-Assault Claws"), 0);
                    }
                }
                if (!(this.stateManipulatorTypeLeft != 6 && this.stateManipulatorTypeLeft != 8 || this.stateManipulatorTypeRight != 6 && this.stateManipulatorTypeRight != 8)) {
                    battleArmor.addEquipment(EquipmentType.get("BA-Vibro Claws (2)"), 0);
                } else if (this.stateManipulatorTypeLeft == 6 || this.stateManipulatorTypeLeft == 8 || this.stateManipulatorTypeRight == 6 || this.stateManipulatorTypeRight == 8) {
                    battleArmor.addEquipment(EquipmentType.get("BA-Vibro Claws (1)"), 0);
                }
                if (this.canMountMech()) {
                    battleArmor.addEquipment(EquipmentType.get("BA-Boarding Claw"), 0);
                }
                if (this.leftArmEquipment != null) {
                    Enumeration enumeration = this.leftArmEquipment.elements();
                    while (enumeration.hasMoreElements()) {
                        battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                        if (battleArmorEquipment.internalType == EQUIPMENT_TYPE_WEAPON || battleArmorEquipment.internalType == EQUIPMENT_TYPE_AMMO) {
                            battleArmor.addEquipment(EquipmentType.get(battleArmorEquipment.weaponTypeName), 0);
                            continue;
                        }
                        if (battleArmorEquipment.internalType != EQUIPMENT_TYPE_OTHER) continue;
                    }
                }
                if (this.rightArmEquipment != null) {
                    Enumeration enumeration = this.rightArmEquipment.elements();
                    while (enumeration.hasMoreElements()) {
                        battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                        if (battleArmorEquipment.internalType == EQUIPMENT_TYPE_WEAPON || battleArmorEquipment.internalType == EQUIPMENT_TYPE_AMMO) {
                            battleArmor.addEquipment(EquipmentType.get(battleArmorEquipment.weaponTypeName), 0);
                            continue;
                        }
                        if (battleArmorEquipment.internalType != EQUIPMENT_TYPE_OTHER) continue;
                    }
                }
                if (this.torsoEquipment == null) break block24;
                Enumeration enumeration = this.torsoEquipment.elements();
                while (enumeration.hasMoreElements()) {
                    battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                    if (battleArmorEquipment.internalType == EQUIPMENT_TYPE_WEAPON || battleArmorEquipment.internalType == EQUIPMENT_TYPE_AMMO) {
                        battleArmor.addEquipment(EquipmentType.get(battleArmorEquipment.weaponTypeName), 0);
                        continue;
                    }
                    if (battleArmorEquipment.internalType != EQUIPMENT_TYPE_OTHER) continue;
                }
            }
            catch (LocationFullException locationFullException) {
                System.err.println(locationFullException);
                locationFullException.printStackTrace();
            }
        }
        return battleArmor;
    }

    public int getTotalJumpMP() {
        int n = this.stateJumpMP;
        if (this.torsoEquipment != null) {
            Enumeration enumeration = this.torsoEquipment.elements();
            while (enumeration.hasMoreElements()) {
                BattleArmorEquipment battleArmorEquipment = (BattleArmorEquipment)enumeration.nextElement();
                if (!battleArmorEquipment.hasConflictFlag(1)) continue;
                ++n;
            }
        }
        return n;
    }

    public boolean canDoAntiMech() {
        if (this.stateChassisType == 1) {
            return false;
        }
        if (this.stateWeightClass >= 3) {
            return false;
        }
        if (this.stateJumpType == 2 && this.stateJumpMP > 0) {
            return false;
        }
        if (this.stateManipulatorTypeLeft >= 4 && this.stateManipulatorTypeLeft <= 8 || this.stateManipulatorTypeRight >= 4 && this.stateManipulatorTypeRight <= 8) {
            return true;
        }
        if (this.stateManipulatorTypeLeft >= 2 && this.stateManipulatorTypeLeft <= 3 && this.stateManipulatorTypeRight >= 2 && this.stateManipulatorTypeRight <= 3) {
            return true;
        }
        return this.stateWeightClass <= 1 && this.stateManipulatorTypeLeft == 1 && this.stateManipulatorTypeRight == 1;
    }

    public boolean canMountMech() {
        if (this.canDoAntiMech()) {
            return true;
        }
        if (this.stateWeightClass == 3) {
            if (this.stateManipulatorTypeLeft >= 2 && this.stateManipulatorTypeLeft <= 3 && this.stateManipulatorTypeRight >= 2 && this.stateManipulatorTypeRight <= 3) {
                return true;
            }
            if (this.stateWeightClass <= 1 && this.stateManipulatorTypeLeft == 1 && this.stateManipulatorTypeRight == 1) {
                return true;
            }
        }
        return false;
    }

    protected class BattleArmorEquipment
    implements Comparable {
        String name;
        String weaponTypeName;
        int weight = 0;
        int cost = 0;
        double bv = 0.0;
        int internalType = -1;
        int slots = 0;
        int techBase = -1;
        int conflictFlag = 0;
        int allowedLocation = 0;

        BattleArmorEquipment() {
        }

        BattleArmorEquipment(String string, String string2, int n, int n2, double d, int n3, int n4, int n5, int n6) {
            this(string, string2, n, n2, d, n3, n4, n5, n6, 0);
        }

        BattleArmorEquipment(String string, String string2, int n, int n2, double d, int n3, int n4, int n5, int n6, int n7) {
            this.name = string;
            this.weaponTypeName = string2;
            this.weight = n;
            this.cost = n2;
            this.bv = d;
            this.internalType = n3;
            this.slots = n4;
            this.techBase = n5;
            this.allowedLocation = n6;
            this.conflictFlag = n7;
            equipmentTypes.add(this);
            equipmentNames.add(this.name);
        }

        void initialize() {
            equipmentTypes = new ArrayList();
            equipmentNames = new ArrayList();
            new BattleArmorEquipment("Support Machine Gun", "BA-Machine Gun", 100, 5000, 5.0, EQUIPMENT_TYPE_WEAPON, 1, 2, 0);
            new BattleArmorEquipment("Light Recoilless Rifle", "BA-Light Recoilless Rifle", 175, 1000, 12.0, EQUIPMENT_TYPE_WEAPON, 2, 2, 0);
            new BattleArmorEquipment("Medium Recoilless Rifle", "BA-Medium Recoilless Rifle", 250, 3000, 19.0, EQUIPMENT_TYPE_WEAPON, 2, 2, 0);
            new BattleArmorEquipment("Heavy Recoilless Rifle", "BA-Heavy Recoilless Rifle", 325, 5000, 22.0, EQUIPMENT_TYPE_WEAPON, 3, 2, 0);
            new BattleArmorEquipment("Heavy Flamer", "BA-Flamer", 150, 7500, 6.0, EQUIPMENT_TYPE_WEAPON, 1, 2, 0);
            new BattleArmorEquipment("Semi-Portable Support Pulse Laser", "BA-Clan Micro Pulse Laser", 160, 12500, 12.0, EQUIPMENT_TYPE_WEAPON, 1, 1, 0);
            new BattleArmorEquipment("Support Laser", "BA-Small Laser", 200, 11250, 9.0, EQUIPMENT_TYPE_WEAPON, 1, 2, 0);
            new BattleArmorEquipment("ER Support Laser", "BA-Clan ER Small Laser", 250, 11250, 31.0, EQUIPMENT_TYPE_WEAPON, 2, 1, 0);
            new BattleArmorEquipment("Bearhunter Superheavy AC", "BA-Bearhunter Superheavy AC", 150, 11250, 4.0, EQUIPMENT_TYPE_WEAPON, 2, 1, 0);
            new BattleArmorEquipment("David Light Gauss Rifle", "BA-ISDavidLightGauss", 100, 22500, 7.0, EQUIPMENT_TYPE_WEAPON, 1, 0, 0);
            new BattleArmorEquipment("King David Light Gauss Rifle", "BA-King David Light Gauss Rifle", 275, 30000, 7.0, EQUIPMENT_TYPE_WEAPON, 2, 0, 0);
            new BattleArmorEquipment("Firedrake Support Needler", "BA-Firedrake Incendiary Needler", 50, 1500, 2.0, EQUIPMENT_TYPE_WEAPON, 1, 0, 0);
            new BattleArmorEquipment("Man-Portable Plasma Rifle", "BA-Plasma Rifle", 300, 28000, 12.0, EQUIPMENT_TYPE_WEAPON, 2, 0, 0);
            new BattleArmorEquipment("Magshot Gauss Rifle", "BAMagshotGR", 175, 8500, 15.0, EQUIPMENT_TYPE_WEAPON, 3, 0, 0);
            new BattleArmorEquipment("Grand Mauler Gauss Cannonr", "BA-ISGrandMauler", 125, 5500, 6.0, EQUIPMENT_TYPE_WEAPON, 2, 0, 0);
            new BattleArmorEquipment("Tsunami Heavy Gauss Rifle", "BA-ISTsunamiHeavyGaussRifle", 125, 5000, 6.0, EQUIPMENT_TYPE_WEAPON, 2, 0, 0);
            new BattleArmorEquipment("Semi-Portable Autocannon", "BA-HeavyMG", 150, 7500, 6.0, EQUIPMENT_TYPE_WEAPON, 1, 1, 0);
            new BattleArmorEquipment("Semi-Portable Machine Gun", "BA-LightMG", 75, 5000, 5.0, EQUIPMENT_TYPE_WEAPON, 1, 1, 0);
            new BattleArmorEquipment("Advanced SRM 1 Launcher", "Clan Advanced SRM-1", 60, 15000, 15.0, EQUIPMENT_TYPE_WEAPON, 2, 1, 0);
            new BattleArmorEquipment("Advanced SRM 2 Launcher", "Clan Advanced SRM-2", 90, 30000, 30.0, EQUIPMENT_TYPE_WEAPON, 2, 1, 0);
            new BattleArmorEquipment("Advanced SRM 3 Launcher", "Clan Advanced SRM-3", 120, 45000, 45.0, EQUIPMENT_TYPE_WEAPON, 3, 1, 0);
            new BattleArmorEquipment("Advanced SRM 4 Launcher", "Clan Advanced SRM-4", 150, 60000, 60.0, EQUIPMENT_TYPE_WEAPON, 3, 1, 0);
            new BattleArmorEquipment("Advanced SRM 5 Launcher", "Clan Advanced SRM-5", 180, 75000, 75.0, EQUIPMENT_TYPE_WEAPON, 4, 1, 0);
            new BattleArmorEquipment("Advanced SRM 6 Launcher", "Clan Advanced SRM-6", 210, 90000, 90.0, EQUIPMENT_TYPE_WEAPON, 4, 1, 0);
            new BattleArmorEquipment("Advanced SRM 1 Ammo", "BAAdvancedSRM1 Ammo", 10, 500, 0.02, EQUIPMENT_TYPE_AMMO, 1, 1, 0);
            new BattleArmorEquipment("Advanced SRM 2 Ammo", "BAAdvancedSRM2 Ammo", 20, 1000, 0.08, EQUIPMENT_TYPE_AMMO, 1, 1, 0);
            new BattleArmorEquipment("Advanced SRM 3 Ammo", "BAAdvancedSRM3 Ammo", 30, 1500, 0.18, EQUIPMENT_TYPE_AMMO, 1, 1, 0);
            new BattleArmorEquipment("Advanced SRM 4 Ammo", "BAAdvancedSRM4 Ammo", 40, 2000, 0.32, EQUIPMENT_TYPE_AMMO, 1, 1, 0);
            new BattleArmorEquipment("Advanced SRM 5 Ammo", "BAAdvancedSRM5 Ammo", 50, 2500, 0.5, EQUIPMENT_TYPE_AMMO, 1, 1, 0);
            new BattleArmorEquipment("Advanced SRM 6 Ammo", "BAAdvancedSRM6 Ammo", 60, 3000, 0.72, EQUIPMENT_TYPE_AMMO, 1, 1, 0);
            new BattleArmorEquipment("Jump Booster", null, 125, 75000, 0.0, EQUIPMENT_TYPE_PREPROCESS, 2, 2, 1, 1);
            new BattleArmorEquipment("Partial Wing", null, 200, 50000, 0.0, EQUIPMENT_TYPE_PREPROCESS, 1, 0, 1, 1);
        }

        public String getDescription() {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(this.name);
            stringBuffer.append(" (");
            stringBuffer.append(this.weight);
            stringBuffer.append(" kg, ");
            stringBuffer.append(this.slots);
            stringBuffer.append(" slots)");
            return stringBuffer.toString();
        }

        public int compareTo(Object object) {
            return this.name.compareTo(((BattleArmorEquipment)object).name);
        }

        public boolean hasConflictFlag(int n) {
            return (this.conflictFlag & n) > 0;
        }
    }
}

