/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.ui.AWT.AlertDialog;
import megamek.client.ui.AWT.ClientDialog;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.DialogOptionComponent;
import megamek.client.ui.AWT.DialogOptionListener;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.Slider;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.EquipmentType;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.TechConstants;
import megamek.common.WeaponType;
import megamek.common.options.IOption;
import megamek.common.options.IOptionGroup;
import megamek.common.options.PilotOptions;
import megamek.common.preference.PreferenceManager;

public class CustomMechDialog
extends ClientDialog
implements ActionListener,
DialogOptionListener {
    private Label labName = new Label(Messages.getString("CustomMechDialog.labName"), 2);
    private TextField fldName = new TextField(20);
    private Label labGunnery = new Label(Messages.getString("CustomMechDialog.labGunnery"), 2);
    private TextField fldGunnery = new TextField(3);
    private Label labPiloting = new Label(Messages.getString("CustomMechDialog.labPiloting"), 2);
    private TextField fldPiloting = new TextField(3);
    private Label labC3 = new Label(Messages.getString("CustomMechDialog.labC3"), 2);
    private Choice choC3 = new Choice();
    private int[] entityCorrespondance;
    private Label labCallsign = new Label(Messages.getString("CustomMechDialog.labCallsign"), 1);
    private Label labUnitNum = new Label(Messages.getString("CustomMechDialog.labUnitNum"), 1);
    private Choice choUnitNum = new Choice();
    private Vector entityUnitNum = new Vector();
    private Label labDeployment = new Label(Messages.getString("CustomMechDialog.labDeployment"), 2);
    private Choice choDeployment = new Choice();
    private Label labAutoEject = new Label(Messages.getString("CustomMechDialog.labAutoEject"), 2);
    private Checkbox chAutoEject = new Checkbox();
    private Label labSearchlight = new Label(Messages.getString("CustomMechDialog.labSearchlight"), 2);
    private Checkbox chSearchlight = new Checkbox();
    private Label labOffBoard = new Label(Messages.getString("CustomMechDialog.labOffBoard"), 2);
    private Checkbox chOffBoard = new Checkbox();
    private Label labOffBoardDirection = new Label(Messages.getString("CustomMechDialog.labOffBoardDirection"), 2);
    private Choice choOffBoardDirection = new Choice();
    private Label labOffBoardDistance = new Label(Messages.getString("CustomMechDialog.labOffBoardDistance"), 2);
    private TextField fldOffBoardDistance = new TextField(4);
    private Button butOffBoardDistance = new Button("0");
    private Label labTargSys = new Label(Messages.getString("CustomMechDialog.labTargSys"), 2);
    private Choice choTargSys = new Choice();
    private Panel panButtons = new Panel();
    private Button butOkay = new Button(Messages.getString("Okay"));
    private Button butCancel = new Button(Messages.getString("Cancel"));
    private Button butNext = new Button(Messages.getString("Next"));
    private Button butPrev = new Button(Messages.getString("Previous"));
    private Vector m_vMunitions = new Vector();
    private Panel panMunitions = new Panel();
    private Vector m_vMGs = new Vector();
    private Panel panRapidfireMGs = new Panel();
    private Vector m_vMines = new Vector();
    private Panel panMines = new Panel();
    private Entity entity;
    private boolean okay = false;
    private ClientGUI clientgui;
    private Client client;
    private PilotOptions options;
    private Vector optionComps = new Vector();
    private Panel panOptions = new Panel();
    private ScrollPane scrOptions = new ScrollPane();
    private ScrollPane scrAll = new ScrollPane();
    private TextArea texDesc = new TextArea(Messages.getString("CustomMechDialog.texDesc"), 3, 35, 1);
    private boolean editable;
    private int direction = -1;
    private int distance = 17;

    public CustomMechDialog(ClientGUI clientGUI, Client client, Entity entity, boolean bl) {
        super(clientGUI.frame, Messages.getString("CustomMechDialog.title"), true);
        Object object;
        Mech mech;
        Panel panel = new Panel();
        this.entity = entity;
        this.clientgui = clientGUI;
        this.client = client;
        this.options = entity.getCrew().getOptions();
        this.editable = bl;
        this.texDesc.setEditable(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labName, gridBagConstraints);
        panel.add(this.labName);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fldName, gridBagConstraints);
        panel.add(this.fldName);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labGunnery, gridBagConstraints);
        panel.add(this.labGunnery);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fldGunnery, gridBagConstraints);
        panel.add(this.fldGunnery);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labPiloting, gridBagConstraints);
        panel.add(this.labPiloting);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fldPiloting, gridBagConstraints);
        panel.add(this.fldPiloting);
        if (entity instanceof Mech && (mech = (Mech)entity).getCockpitType() != 1) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labAutoEject, gridBagConstraints);
            panel.add(this.labAutoEject);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.chAutoEject, gridBagConstraints);
            panel.add(this.chAutoEject);
            this.chAutoEject.setState(!mech.isAutoEject());
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labDeployment, gridBagConstraints);
        panel.add(this.labDeployment);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.choDeployment, gridBagConstraints);
        panel.add(this.choDeployment);
        this.refreshDeployment();
        if (clientGUI.getClient().game.getOptions().booleanOption("pilot_advantages")) {
            this.scrOptions.add(this.panOptions);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.scrOptions, gridBagConstraints);
            panel.add(this.scrOptions);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.texDesc, gridBagConstraints);
            panel.add(this.texDesc);
        }
        if (entity.hasC3() || entity.hasC3i()) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labC3, gridBagConstraints);
            panel.add(this.labC3);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.choC3, gridBagConstraints);
            panel.add(this.choC3);
            this.refreshC3();
        }
        boolean bl2 = false;
        Object object2 = entity.getWeaponList().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            WeaponType weaponType = (WeaponType)((Mounted)object).getType();
            if (!weaponType.hasFlag(65536L)) continue;
            bl2 = true;
        }
        if (bl2) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labOffBoard, gridBagConstraints);
            panel.add(this.labOffBoard);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.chOffBoard, gridBagConstraints);
            panel.add(this.chOffBoard);
            this.chOffBoard.setState(entity.isOffBoard());
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labOffBoardDirection, gridBagConstraints);
            panel.add(this.labOffBoardDirection);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.choOffBoardDirection, gridBagConstraints);
            this.choOffBoardDirection.add(Messages.getString("CustomMechDialog.North"));
            this.choOffBoardDirection.add(Messages.getString("CustomMechDialog.South"));
            this.choOffBoardDirection.add(Messages.getString("CustomMechDialog.East"));
            this.choOffBoardDirection.add(Messages.getString("CustomMechDialog.West"));
            this.direction = entity.getOffBoardDirection();
            if (-1 == this.direction) {
                this.direction = 0;
            }
            this.choOffBoardDirection.select(this.direction);
            panel.add(this.choOffBoardDirection);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labOffBoardDistance, gridBagConstraints);
            panel.add(this.labOffBoardDistance);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            this.butOffBoardDistance.addActionListener(this);
            gridBagLayout.setConstraints(this.butOffBoardDistance, gridBagConstraints);
            this.butOffBoardDistance.setLabel(Integer.toString(this.distance));
            panel.add(this.butOffBoardDistance);
        }
        if (!entity.hasTargComp() && clientGUI.getClient().game.getOptions().booleanOption("allow_level_3_targsys") && entity instanceof Mech) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labTargSys, gridBagConstraints);
            panel.add(this.labTargSys);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            this.choTargSys.add(MiscType.getTargetSysName(0));
            this.choTargSys.add(MiscType.getTargetSysName(2));
            this.choTargSys.add(MiscType.getTargetSysName(3));
            this.choTargSys.add(MiscType.getTargetSysName(5));
            gridBagLayout.setConstraints(this.choTargSys, gridBagConstraints);
            panel.add(this.choTargSys);
            this.choTargSys.select(MiscType.getTargetSysName(entity.getTargSysType()));
        }
        if (entity instanceof Protomech) {
            object2 = new StringBuffer(Messages.getString("CustomMechDialog.Callsign"));
            ((StringBuffer)object2).append(": ");
            ((StringBuffer)object2).append((char)(this.entity.getUnitNumber() + PreferenceManager.getClientPreferences().getUnitStartChar())).append('-').append(this.entity.getId());
            this.labCallsign.setText(((StringBuffer)object2).toString());
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.labCallsign, gridBagConstraints);
            panel.add(this.labCallsign);
            object = client.game.getSelectedEntities(new EntitySelector(){
                private final int ownerId;
                private final char unitNumber;
                {
                    this.ownerId = CustomMechDialog.this.entity.getOwnerId();
                    this.unitNumber = CustomMechDialog.this.entity.getUnitNumber();
                }

                public boolean accept(Entity entity) {
                    return entity instanceof Protomech && this.ownerId == entity.getOwnerId() && this.unitNumber != entity.getUnitNumber();
                }
            });
            if (object.hasMoreElements()) {
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 13;
                gridBagLayout.setConstraints(this.labUnitNum, gridBagConstraints);
                panel.add(this.labUnitNum);
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(this.choUnitNum, gridBagConstraints);
                panel.add(this.choUnitNum);
                this.refreshUnitNum((Enumeration)object);
            }
        }
        if (!(entity instanceof Infantry)) {
            this.setupMunitions();
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.panMunitions, gridBagConstraints);
            panel.add(this.panMunitions);
        }
        if (clientGUI.getClient().game.getOptions().booleanOption("maxtech_burst")) {
            gridBagConstraints.gridwidth = 1;
            this.setupRapidfireMGs();
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.panRapidfireMGs, gridBagConstraints);
            panel.add(this.panRapidfireMGs);
        }
        if (clientGUI.getClient().game.getOptions().booleanOption("night_battle")) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labSearchlight, gridBagConstraints);
            panel.add(this.labSearchlight);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.chSearchlight, gridBagConstraints);
            panel.add(this.chSearchlight);
            this.chSearchlight.setState(entity.hasSpotlight());
        }
        this.setupMines();
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.panMines, gridBagConstraints);
        panel.add(this.panMines);
        this.setupButtons();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.panButtons, gridBagConstraints);
        panel.add(this.panButtons);
        this.fldName.setText(entity.getCrew().getName());
        this.fldName.addActionListener(this);
        this.fldGunnery.setText(new Integer(entity.getCrew().getGunnery()).toString());
        this.fldGunnery.addActionListener(this);
        this.fldPiloting.setText(new Integer(entity.getCrew().getPiloting()).toString());
        this.fldPiloting.addActionListener(this);
        if (!bl) {
            this.fldName.setEnabled(false);
            this.fldGunnery.setEnabled(false);
            this.fldPiloting.setEnabled(false);
            this.choC3.setEnabled(false);
            this.choDeployment.setEnabled(false);
            this.chAutoEject.setEnabled(false);
            this.chSearchlight.setEnabled(false);
            this.choTargSys.setEnabled(false);
            this.disableMunitionEditing();
            this.disableMGSetting();
            this.disableMineSetting();
            this.chOffBoard.setEnabled(false);
            this.choOffBoardDirection.setEnabled(false);
            this.fldOffBoardDistance.setEnabled(false);
        }
        this.scrAll.add(panel);
        this.add(this.scrAll);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CustomMechDialog.this.setVisible(false);
            }
        });
        this.pack();
        int n = panel.getPreferredSize().width + this.scrAll.getInsets().right;
        int n2 = panel.getPreferredSize().height + this.panButtons.getPreferredSize().height + this.scrAll.getInsets().bottom;
        this.setLocationAndSize(n, n2);
    }

    private void setupButtons() {
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        this.butNext.addActionListener(this);
        this.butPrev.addActionListener(this);
        this.panButtons.setLayout(new GridLayout(1, 4, 10, 0));
        this.panButtons.add(this.butPrev);
        this.panButtons.add(this.butOkay);
        this.panButtons.add(this.butCancel);
        this.panButtons.add(this.butNext);
        this.butNext.setEnabled(this.getNextEntity(true) != null);
        this.butPrev.setEnabled(this.getNextEntity(false) != null);
    }

    private void setupRapidfireMGs() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panRapidfireMGs.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        Iterator<Mounted> iterator = this.entity.getWeaponList().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (!weaponType.hasFlag(512L)) continue;
            gridBagConstraints.gridy = n++;
            RapidfireMGPanel rapidfireMGPanel = new RapidfireMGPanel(mounted);
            gridBagLayout.setConstraints(rapidfireMGPanel, gridBagConstraints);
            this.panRapidfireMGs.add(rapidfireMGPanel);
            this.m_vMGs.addElement(rapidfireMGPanel);
        }
    }

    private void setupMines() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panMines.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        Iterator<Mounted> iterator = this.entity.getMisc().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            if (!mounted.getType().hasFlag(524288L)) continue;
            gridBagConstraints.gridy = n++;
            MineChoicePanel mineChoicePanel = new MineChoicePanel(mounted);
            gridBagLayout.setConstraints(mineChoicePanel, gridBagConstraints);
            this.panMines.add(mineChoicePanel);
            this.m_vMines.addElement(mineChoicePanel);
        }
    }

    private void setupMunitions() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panMunitions.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        Iterator<Mounted> iterator = this.entity.getAmmo().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            AmmoType ammoType = (AmmoType)mounted.getType();
            Vector<AmmoType> vector = new Vector<AmmoType>();
            Vector vector2 = AmmoType.getMunitionsFor(ammoType.getAmmoType());
            if (vector2 == null) continue;
            int n2 = vector2.size();
            for (int i = 0; i < n2; ++i) {
                AmmoType ammoType2 = (AmmoType)vector2.elementAt(i);
                boolean bl = TechConstants.isLegal(this.entity.getTechLevel(), ammoType2.getTechLevel());
                if (!bl && this.entity.getTechLevel() == 1 && ammoType2.getTechLevel() == 0) {
                    bl = true;
                }
                if (!this.clientgui.getClient().game.getOptions().booleanOption("is_eq_limits") && this.entity.getTechLevel() == 0 && ammoType2.getTechLevel() == 1) {
                    bl = true;
                }
                if (this.clientgui.getClient().game.getOptions().booleanOption("allow_level_3_ammo")) {
                    if (!this.clientgui.getClient().game.getOptions().booleanOption("is_eq_limits")) {
                        if (this.entity.getTechLevel() == 2 && ammoType2.getTechLevel() == 6) {
                            bl = true;
                        }
                        if ((this.entity.getTechLevel() == 0 || this.entity.getTechLevel() == 1) && ammoType2.getTechLevel() == 5) {
                            bl = true;
                        }
                    }
                } else if (ammoType2.getTechLevel() == 5 || ammoType2.getTechLevel() == 6) {
                    bl = false;
                }
                if (this.entity.isMixedTech()) {
                    bl = true;
                }
                long l = ammoType2.getMunitionType();
                if (!this.clientgui.getClient().game.getOptions().booleanOption("clan_ignore_eq_limits") && this.entity.isClan() && ((l &= 0xFFFFFFFFFFFFEFFFL) == 16384L || l == 65536L || l == 8192L || l == 128L || l == 262144L || l == 524288L || l == 0x100000L || l == 0x200000L || l == 0x80000000L || l == 0x100000000L || l == 256L || l == 512L)) {
                    bl = false;
                }
                if (!this.clientgui.getClient().game.getOptions().booleanOption("minefields") && AmmoType.canDeliverMinefield(ammoType2) || ammoType2.hasFlag(4L) && !(this.entity instanceof Protomech) || this.entity instanceof Protomech && ammoType2.hasFlag(1L) && !ammoType2.hasFlag(4L) || !bl || ammoType2.getRackSize() != ammoType.getRackSize() || ammoType2.hasFlag(2L) || ammoType2.getTonnage(this.entity) != ammoType.getTonnage(this.entity)) continue;
                vector.addElement(ammoType2);
            }
            if (vector.size() < 2 && !this.client.game.getOptions().booleanOption("lobby_ammo_dump")) continue;
            gridBagConstraints.gridy = n++;
            MunitionChoicePanel munitionChoicePanel = null;
            munitionChoicePanel = this.entity instanceof Protomech ? new ProtomechMunitionChoicePanel(mounted, vector) : new MunitionChoicePanel(mounted, vector);
            gridBagLayout.setConstraints(munitionChoicePanel, gridBagConstraints);
            this.panMunitions.add(munitionChoicePanel);
            this.m_vMunitions.addElement(munitionChoicePanel);
        }
    }

    public void disableMunitionEditing() {
        for (int i = 0; i < this.m_vMunitions.size(); ++i) {
            ((MunitionChoicePanel)this.m_vMunitions.elementAt(i)).setEnabled(false);
        }
    }

    public void disableMGSetting() {
        for (int i = 0; i < this.m_vMGs.size(); ++i) {
            ((RapidfireMGPanel)this.m_vMGs.elementAt(i)).setEnabled(false);
        }
    }

    public void disableMineSetting() {
        for (int i = 0; i < this.m_vMines.size(); ++i) {
            ((MineChoicePanel)this.m_vMines.elementAt(i)).setEnabled(false);
        }
    }

    public void setOptions() {
        Enumeration enumeration = this.optionComps.elements();
        while (enumeration.hasMoreElements()) {
            DialogOptionComponent dialogOptionComponent = (DialogOptionComponent)enumeration.nextElement();
            IOption iOption = dialogOptionComponent.getOption();
            if (dialogOptionComponent.getValue() == Messages.getString("CustomMechDialog.None")) {
                this.entity.getCrew().getOptions().getOption(iOption.getName()).setValue("None");
                continue;
            }
            this.entity.getCrew().getOptions().getOption(iOption.getName()).setValue(dialogOptionComponent.getValue());
        }
    }

    public void resetOptions() {
        Enumeration enumeration = this.optionComps.elements();
        while (enumeration.hasMoreElements()) {
            DialogOptionComponent dialogOptionComponent = (DialogOptionComponent)enumeration.nextElement();
            IOption iOption = dialogOptionComponent.getOption();
            iOption.setValue(false);
            this.entity.getCrew().getOptions().getOption(iOption.getName()).setValue(dialogOptionComponent.getValue());
        }
    }

    public void refreshOptions() {
        this.panOptions.removeAll();
        this.optionComps = new Vector();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panOptions.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        Enumeration enumeration = this.options.getGroups();
        while (enumeration.hasMoreElements()) {
            IOptionGroup iOptionGroup = (IOptionGroup)enumeration.nextElement();
            this.addGroup(iOptionGroup, gridBagLayout, gridBagConstraints);
            Enumeration enumeration2 = iOptionGroup.getOptions();
            while (enumeration2.hasMoreElements()) {
                IOption iOption = (IOption)enumeration2.nextElement();
                this.addOption(iOption, gridBagLayout, gridBagConstraints, this.editable);
            }
        }
        this.validate();
    }

    private void addGroup(IOptionGroup iOptionGroup, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        Label label = new Label(iOptionGroup.getDisplayableName());
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.panOptions.add(label);
    }

    private void addOption(IOption iOption, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, boolean bl) {
        DialogOptionComponent dialogOptionComponent = new DialogOptionComponent(this, iOption, bl);
        if (iOption.getName().equals("weapon_specialist")) {
            dialogOptionComponent.addValue(Messages.getString("CustomMechDialog.None"));
            Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
            for (int i = 0; i < this.entity.getWeaponList().size(); ++i) {
                Mounted mounted = this.entity.getWeaponList().get(i);
                hashtable.put(mounted.getName(), new Boolean(true));
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent.addValue((String)enumeration.nextElement());
            }
            dialogOptionComponent.setSelected(iOption.stringValue());
        }
        gridBagLayout.setConstraints(dialogOptionComponent, gridBagConstraints);
        this.panOptions.add(dialogOptionComponent);
        this.optionComps.addElement(dialogOptionComponent);
    }

    public void showDescFor(IOption iOption) {
        this.texDesc.setText(iOption.getDescription());
    }

    public void optionClicked(DialogOptionComponent dialogOptionComponent, IOption iOption, boolean bl) {
    }

    public boolean isOkay() {
        return this.okay;
    }

    private void refreshDeployment() {
        this.choDeployment.removeAll();
        this.choDeployment.add(Messages.getString("CustomMechDialog.StartOfGame"));
        if (this.entity.getDeployRound() < 1) {
            this.choDeployment.select(0);
        }
        for (int i = 1; i <= 15; ++i) {
            this.choDeployment.add(Messages.getString("CustomMechDialog.AfterRound") + i);
            if (this.entity.getDeployRound() != i) continue;
            this.choDeployment.select(i);
        }
    }

    private void refreshC3() {
        int n;
        this.choC3.removeAll();
        int n2 = 0;
        this.entityCorrespondance = new int[this.client.game.getNoOfEntities() + 2];
        if (this.entity.hasC3i()) {
            this.choC3.add(Messages.getString("CustomMechDialog.CreateNewNetwork"));
            if (this.entity.getC3Master() == null) {
                this.choC3.select(n2);
            }
            this.entityCorrespondance[n2++] = this.entity.getId();
        } else if (this.entity.hasC3MM()) {
            n = this.entity.calculateFreeC3MNodes();
            int n3 = this.entity.calculateFreeC3Nodes();
            this.choC3.add(Messages.getString("CustomMechDialog.setCompanyMaster", new Object[]{new Integer(n), new Integer(n3)}));
            if (this.entity.C3MasterIs(this.entity)) {
                this.choC3.select(n2);
            }
            this.entityCorrespondance[n2++] = this.entity.getId();
            this.choC3.add(Messages.getString("CustomMechDialog.setIndependentMaster", new Object[]{new Integer(n3)}));
            if (this.entity.getC3Master() == null) {
                this.choC3.select(n2);
            }
            this.entityCorrespondance[n2++] = -1;
        } else if (this.entity.hasC3M()) {
            n = this.entity.calculateFreeC3Nodes();
            this.choC3.add(Messages.getString("CustomMechDialog.setCompanyMaster1", new Object[]{new Integer(n)}));
            if (this.entity.C3MasterIs(this.entity)) {
                this.choC3.select(n2);
            }
            this.entityCorrespondance[n2++] = this.entity.getId();
            this.choC3.add(Messages.getString("CustomMechDialog.setIndependentMaster", new Object[]{new Integer(n)}));
            if (this.entity.getC3Master() == null) {
                this.choC3.select(n2);
            }
            this.entityCorrespondance[n2++] = -1;
        }
        Enumeration enumeration = this.client.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity;
            Entity entity2 = (Entity)enumeration.nextElement();
            if (this.entity.isEnemyOf(entity2) || this.entity.equals(entity2) || this.entity.hasC3i() != entity2.hasC3i() || (entity = entity2.getC3Master()) != null && entity.getC3Master() != entity) continue;
            int n4 = entity2.calculateFreeC3Nodes();
            if (entity2.hasC3MM() && this.entity.hasC3M() && entity2.C3MasterIs(entity2)) {
                n4 = entity2.calculateFreeC3MNodes();
            }
            if (this.entity.C3MasterIs(entity2) && !this.entity.equals(entity2)) {
                ++n4;
            }
            if (this.entity.hasC3i() && (this.entity.onSameC3NetworkAs(entity2) || this.entity.equals(entity2))) {
                ++n4;
            }
            if (n4 == 0) continue;
            if (entity2.hasC3i()) {
                if (this.entity.onSameC3NetworkAs(entity2)) {
                    this.choC3.add(Messages.getString("CustomMechDialog.join1", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4 - 1)}));
                    this.choC3.select(n2);
                } else {
                    this.choC3.add(Messages.getString("CustomMechDialog.join2", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4)}));
                }
                this.entityCorrespondance[n2++] = entity2.getId();
                continue;
            }
            if (entity2.C3MasterIs(entity2) && entity2.hasC3MM()) {
                this.choC3.add(Messages.getString("CustomMechDialog.connect2", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4)}));
                this.entityCorrespondance[n2] = entity2.getId();
                if (this.entity.C3MasterIs(entity2)) {
                    this.choC3.select(n2);
                }
                ++n2;
                continue;
            }
            if (entity2.C3MasterIs(entity2) && !this.entity.hasC3M()) continue;
            if (this.entity.C3MasterIs(entity2)) {
                this.choC3.add(Messages.getString("CustomMechDialog.connect1", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4 - 1)}));
                this.choC3.select(n2);
                this.entityCorrespondance[n2++] = entity2.getId();
                continue;
            }
            this.choC3.add(Messages.getString("CustomMechDialog.connect2", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4)}));
            this.entityCorrespondance[n2++] = entity2.getId();
        }
    }

    private void refreshUnitNum(Enumeration enumeration) {
        this.choUnitNum.removeAll();
        this.entityUnitNum.removeAllElements();
        this.choUnitNum.add(Messages.getString("CustomMechDialog.doNotSwapUnits"));
        this.entityUnitNum.addElement(this.entity);
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            this.entityUnitNum.addElement(entity);
            StringBuffer stringBuffer = new StringBuffer(entity.getDisplayName());
            stringBuffer.append(" (").append((char)(entity.getUnitNumber() + PreferenceManager.getClientPreferences().getUnitStartChar())).append('-').append(entity.getId()).append(')');
            this.choUnitNum.add(stringBuffer.toString());
        }
        this.choUnitNum.select(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (actionEvent.getSource() == this.butOffBoardDistance) {
            int n = 323;
            Object object2 = this.entity.getWeaponList().iterator();
            while (object2.hasNext()) {
                int n2;
                Mounted mounted = object2.next();
                EquipmentType equipmentType = mounted.getType();
                WeaponType weaponType = (WeaponType)equipmentType;
                if (!weaponType.hasFlag(65536L) || (n2 = (weaponType.getLongRange() - 1) * 17) >= n) continue;
                n = n2;
            }
            object2 = new Slider(this.clientgui.frame, Messages.getString("CustomMechDialog.offboardDistanceTitle"), Messages.getString("CustomMechDialog.offboardDistanceQuestion"), this.entity.getOffBoardDistance(), 17, n);
            if (!((Slider)object2).showDialog()) {
                return;
            }
            this.distance = ((Slider)object2).getValue();
            this.butOffBoardDistance.setLabel(Integer.toString(this.distance));
            return;
        }
        if (actionEvent.getSource() != this.butCancel) {
            int n;
            Entity entity;
            int n3;
            int n4;
            object = this.fldName.getText();
            boolean bl = this.chAutoEject.getState();
            try {
                n4 = Integer.parseInt(this.fldGunnery.getText());
                n3 = Integer.parseInt(this.fldPiloting.getText());
            }
            catch (NumberFormatException numberFormatException) {
                new AlertDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.NumberFormatError"), Messages.getString("CustomMechDialog.EnterValidSkills")).setVisible(true);
                return;
            }
            if (n4 < 0 || n4 > 7 || n3 < 0 || n3 > 7) {
                new AlertDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.NumberFormatError"), Messages.getString("CustomMechDialog.EnterSkillsBetween0_7")).setVisible(true);
                return;
            }
            if (this.chOffBoard.getState()) {
                int n5;
                try {
                    n5 = this.distance;
                }
                catch (NumberFormatException numberFormatException) {
                    new AlertDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.NumberFormatError"), Messages.getString("CustomMechDialog.EnterValidSkills")).setVisible(true);
                    return;
                }
                if (n5 < 17) {
                    new AlertDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.NumberFormatError"), Messages.getString("CustomMechDialog.OffboardDistance")).setVisible(true);
                    return;
                }
                this.entity.setOffBoard(n5, this.choOffBoardDirection.getSelectedIndex());
            } else {
                this.entity.setOffBoard(0, -1);
            }
            this.entity.setCrew(new Pilot((String)object, n4, n3));
            if (this.entity instanceof Mech) {
                entity = (Mech)this.entity;
                ((Mech)entity).setAutoEject(!bl);
            }
            if (this.entity.hasC3() && this.choC3.getSelectedIndex() > -1) {
                int n6;
                entity = this.client.getEntity(this.entityCorrespondance[this.choC3.getSelectedIndex()]);
                n = this.client.game.getC3SubNetworkMembers(this.entity).size();
                if (n + (n6 = this.client.game.getC3NetworkMembers(entity).size()) <= 12) {
                    this.entity.setC3Master(entity);
                } else {
                    String string = Messages.getString("CustomMechDialog.NetworkTooBig.message", new Object[]{this.entity.getShortName(), entity.getShortName(), new Integer(n), new Integer(n6), new Integer(12)});
                    this.clientgui.doAlertDialog(Messages.getString("CustomMechDialog.NetworkTooBig.title"), string);
                    this.refreshC3();
                }
            } else if (this.entity.hasC3i() && this.choC3.getSelectedIndex() > -1) {
                this.entity.setC3NetId(this.client.getEntity(this.entityCorrespondance[this.choC3.getSelectedIndex()]));
            }
            if (!this.entity.hasTargComp() && this.clientgui.getClient().game.getOptions().booleanOption("allow_level_3_targsys")) {
                int n7 = 0;
                if (this.choTargSys.getSelectedItem() != null) {
                    n7 = MiscType.getTargetSysType(this.choTargSys.getSelectedItem());
                }
                if (n7 >= 0) {
                    this.entity.setTargSysType(n7);
                } else {
                    System.err.println("Illegal targeting system index: " + n7);
                    this.entity.setTargSysType(0);
                }
            }
            if (!this.entityUnitNum.isEmpty() && this.choUnitNum.getSelectedIndex() > 0) {
                Entity entity2 = (Entity)this.entityUnitNum.elementAt(this.choUnitNum.getSelectedIndex());
                n = this.entity.getUnitNumber();
                this.entity.setUnitNumber(entity2.getUnitNumber());
                entity2.setUnitNumber((char)n);
                this.client.sendUpdateEntity(entity2);
            }
            this.entity.setDeployRound(this.choDeployment.getSelectedIndex());
            Enumeration enumeration = this.m_vMunitions.elements();
            while (enumeration.hasMoreElements()) {
                ((MunitionChoicePanel)enumeration.nextElement()).applyChoice();
            }
            enumeration = this.m_vMGs.elements();
            while (enumeration.hasMoreElements()) {
                ((RapidfireMGPanel)enumeration.nextElement()).applyChoice();
            }
            enumeration = this.m_vMines.elements();
            while (enumeration.hasMoreElements()) {
                ((MineChoicePanel)enumeration.nextElement()).applyChoice();
            }
            this.entity.setSpotlight(this.chSearchlight.getState());
            this.entity.setSpotlightState(this.chSearchlight.getState());
            this.setOptions();
            this.okay = true;
            this.clientgui.chatlounge.refreshEntities();
        }
        this.setVisible(false);
        object = null;
        if (actionEvent.getSource() == this.butPrev) {
            object = this.getNextEntity(false);
        } else if (actionEvent.getSource() == this.butNext) {
            object = this.getNextEntity(true);
        }
        if (object != null) {
            this.clientgui.chatlounge.customizeMech((Entity)object);
        }
    }

    private Entity getNextEntity(boolean bl) {
        IGame iGame = this.client.game;
        boolean bl2 = iGame.getOptions().booleanOption("blind_drop");
        boolean bl3 = iGame.getOptions().booleanOption("real_blind_drop");
        Player player = this.client.getLocalPlayer();
        Entity entity = null;
        entity = bl ? iGame.getNextEntityFromList(this.entity) : iGame.getPreviousEntityFromList(this.entity);
        while (entity != this.entity && entity != null) {
            if (entity.getOwner().equals(player) || !bl2 && !bl3) {
                return entity;
            }
            if (bl) {
                entity = iGame.getNextEntityFromList(entity);
                continue;
            }
            entity = iGame.getPreviousEntityFromList(entity);
        }
        return null;
    }

    class RapidfireMGPanel
    extends Panel {
        private Mounted m_mounted;
        protected Checkbox chRapid = new Checkbox();

        public RapidfireMGPanel(Mounted mounted) {
            this.m_mounted = mounted;
            int n = mounted.getLocation();
            String string = Messages.getString("CustomMechDialog.switchToRapidFire", new Object[]{CustomMechDialog.this.entity.getLocationAbbr(n)});
            Label label = new Label(string);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.add(label);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.chRapid, gridBagConstraints);
            this.chRapid.setState(mounted.isRapidfire());
            this.add(this.chRapid);
        }

        public void applyChoice() {
            boolean bl = this.chRapid.getState();
            this.m_mounted.setRapidfire(bl);
        }

        public void setEnabled(boolean bl) {
            this.chRapid.setEnabled(bl);
        }
    }

    class ProtomechMunitionChoicePanel
    extends MunitionChoicePanel {
        private final float m_origShotsLeft;
        private final AmmoType m_origAmmo;

        public ProtomechMunitionChoicePanel(Mounted mounted, Vector vector) {
            super(mounted, vector);
            this.m_origAmmo = (AmmoType)mounted.getType();
            this.m_origShotsLeft = mounted.getShotsLeft();
        }

        public void applyChoice() {
            super.applyChoice();
            this.setShotsLeft(Math.round((float)this.getShotsLeft() * this.m_origShotsLeft / (float)this.m_origAmmo.getShots()));
            if (this.chDump.getState()) {
                this.setShotsLeft(0);
            }
        }
    }

    class MunitionChoicePanel
    extends Panel {
        private Vector m_vTypes;
        private Choice m_choice;
        private Mounted m_mounted;
        protected Label labDump = new Label(Messages.getString("CustomMechDialog.labDump"));
        protected Checkbox chDump = new Checkbox();
        protected Label labHotLoad = new Label(Messages.getString("CustomMechDialog.switchToHotLoading"));
        protected Checkbox chHotLoad = new Checkbox();

        public MunitionChoicePanel(Mounted mounted, Vector vector) {
            Object object;
            this.m_vTypes = vector;
            this.m_mounted = mounted;
            AmmoType ammoType = (AmmoType)mounted.getType();
            this.m_choice = new Choice();
            Enumeration enumeration = this.m_vTypes.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                object = (AmmoType)enumeration.nextElement();
                this.m_choice.add(((EquipmentType)object).getName());
                if (((AmmoType)object).getMunitionType() == ammoType.getMunitionType()) {
                    this.m_choice.select(n);
                }
                ++n;
            }
            if (mounted.getLocation() == -1) {
                object = mounted.getLinkedBy();
                n = ((Mounted)object).getLocation();
            } else {
                n = mounted.getLocation();
            }
            object = "(" + CustomMechDialog.this.entity.getLocationAbbr(n) + ")";
            Label label = new Label((String)object);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.add(label);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.m_choice, gridBagConstraints);
            this.add(this.m_choice);
            if (((CustomMechDialog)CustomMechDialog.this).clientgui.getClient().game.getOptions().booleanOption("lobby_ammo_dump")) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 13;
                gridBagLayout.setConstraints(this.labDump, gridBagConstraints);
                this.add(this.labDump);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(this.chDump, gridBagConstraints);
                this.add(this.chDump);
                if (((CustomMechDialog)CustomMechDialog.this).clientgui.getClient().game.getOptions().booleanOption("maxtech_hotload") && ammoType.hasFlag(8L)) {
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = 2;
                    gridBagConstraints.anchor = 13;
                    gridBagLayout.setConstraints(this.labHotLoad, gridBagConstraints);
                    this.add(this.labHotLoad);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.gridy = 2;
                    gridBagConstraints.anchor = 17;
                    gridBagLayout.setConstraints(this.chHotLoad, gridBagConstraints);
                    this.add(this.chHotLoad);
                }
            } else if (((CustomMechDialog)CustomMechDialog.this).clientgui.getClient().game.getOptions().booleanOption("maxtech_hotload") && ammoType.hasFlag(8L)) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 13;
                gridBagLayout.setConstraints(this.labHotLoad, gridBagConstraints);
                this.add(this.labHotLoad);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(this.chHotLoad, gridBagConstraints);
                this.add(this.chHotLoad);
            }
        }

        public void applyChoice() {
            int n = this.m_choice.getSelectedIndex();
            AmmoType ammoType = (AmmoType)this.m_vTypes.elementAt(n);
            this.m_mounted.changeAmmoType(ammoType);
            if (this.chDump.getState()) {
                this.m_mounted.setShotsLeft(0);
            }
            if (((CustomMechDialog)CustomMechDialog.this).clientgui.getClient().game.getOptions().booleanOption("maxtech_hotload") && this.chHotLoad.getState() != this.m_mounted.isHotLoaded()) {
                this.m_mounted.setHotLoad(this.chHotLoad.getState());
            }
        }

        public void setEnabled(boolean bl) {
            this.m_choice.setEnabled(bl);
        }

        int getShotsLeft() {
            return this.m_mounted.getShotsLeft();
        }

        void setShotsLeft(int n) {
            this.m_mounted.setShotsLeft(n);
        }
    }

    class MineChoicePanel
    extends Panel {
        private Choice m_choice;
        private Mounted m_mounted;

        public MineChoicePanel(Mounted mounted) {
            this.m_mounted = mounted;
            this.m_choice = new Choice();
            this.m_choice.add(Messages.getString("CustomMechDialog.Conventional"));
            this.m_choice.add(Messages.getString("CustomMechDialog.Vibrabomb"));
            int n = mounted.getLocation();
            String string = "(" + CustomMechDialog.this.entity.getLocationAbbr(n) + ")";
            Label label = new Label(string);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.add(label);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.m_choice, gridBagConstraints);
            this.m_choice.select(mounted.getMineType());
            this.add(this.m_choice);
        }

        public void applyChoice() {
            this.m_mounted.setMineType(this.m_choice.getSelectedIndex());
        }

        public void setEnabled(boolean bl) {
            this.m_choice.setEnabled(bl);
        }
    }
}

