/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListener;
import megamek.client.event.BoardViewListenerAdapter;
import megamek.client.ui.AWT.BoardView1;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.util.PlayerColors;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.GameTurn;
import megamek.common.GunEmplacement;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Mech;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.Targetable;
import megamek.common.Terrains;
import megamek.common.VTOL;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.AttackAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.event.BoardEvent;
import megamek.common.event.BoardListener;
import megamek.common.event.BoardListenerAdapter;
import megamek.common.event.GameBoardChangeEvent;
import megamek.common.event.GameBoardNewEvent;
import megamek.common.event.GameListener;
import megamek.common.event.GameListenerAdapter;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GameTurnChangeEvent;

public class MiniMap
extends Canvas {
    private static final Color[] m_terrainColors = new Color[Terrains.SIZE];
    private static Color HEAVY_WOODS;
    private static Color BACKGROUND;
    private static Color SINKHOLE;
    private static Color SMOKE_AND_FIRE;
    private static final int SHOW_NO_HEIGHT = 0;
    private static final int SHOW_GROUND_HEIGHT = 1;
    private static final int SHOW_BUILDING_HEIGHT = 2;
    private static final int SHOW_TOTAL_HEIGHT = 3;
    private static final int NBR_MODES = 3;
    private Image m_mapImage;
    private BoardView1 m_bview;
    private IGame m_game;
    private Dialog m_dialog;
    private static final int margin = 6;
    private int topMargin;
    private int leftMargin;
    private static final int buttonHeight = 14;
    private boolean minimized = false;
    private int heightBufer;
    private int unitSize = 6;
    private Vector roadHexIndexes = new Vector();
    private int zoom = GUIPreferences.getInstance().getMinimapZoom();
    private int[] hexSide = new int[]{3, 5, 6, 8, 10, 12};
    private int[] hexSideByCos30 = new int[]{3, 4, 5, 7, 9, 10};
    private int[] hexSideBySin30 = new int[]{2, 2, 3, 4, 5, 6};
    private int[] halfRoadWidthByCos30 = new int[]{0, 0, 1, 2, 2, 3};
    private int[] halfRoadWidthBySin30 = new int[]{0, 0, 1, 1, 1, 2};
    private int[] halfRoadWidth = new int[]{0, 0, 1, 2, 3, 3};
    private int heightDisplayMode = 0;
    Coords firstLOS;
    Coords secondLOS;
    private Client m_client;
    private ClientGUI clientgui;
    protected BoardListener boardListener = new BoardListenerAdapter(){

        public void boardNewBoard(BoardEvent boardEvent) {
            MiniMap.this.initializeMap();
        }
    };
    protected GameListener gameListener = new GameListenerAdapter(){

        public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
            MiniMap.this.drawMap();
        }

        public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
            MiniMap.this.drawMap();
        }

        public void gameBoardNew(GameBoardNewEvent gameBoardNewEvent) {
            IBoard iBoard = gameBoardNewEvent.getOldBoard();
            if (iBoard != null) {
                iBoard.removeBoardListener(MiniMap.this.boardListener);
            }
            if ((iBoard = gameBoardNewEvent.getNewBoard()) != null) {
                iBoard.addBoardListener(MiniMap.this.boardListener);
            }
            MiniMap.this.initializeMap();
        }

        public void gameBoardChanged(GameBoardChangeEvent gameBoardChangeEvent) {
            MiniMap.this.drawMap();
        }
    };
    BoardViewListener boardViewListener = new BoardViewListenerAdapter(){

        public void hexCursor(BoardViewEvent boardViewEvent) {
            this.update();
        }

        public void boardHexHighlighted(BoardViewEvent boardViewEvent) {
            this.update();
        }

        public void hexSelected(BoardViewEvent boardViewEvent) {
            this.update();
        }

        public void firstLOSHex(BoardViewEvent boardViewEvent) {
            MiniMap.this.secondLOS = null;
            MiniMap.this.firstLOS = boardViewEvent.getCoords();
            MiniMap.this.drawMap();
        }

        public void secondLOSHex(BoardViewEvent boardViewEvent, Coords coords) {
            MiniMap.this.firstLOS = coords;
            MiniMap.this.secondLOS = boardViewEvent.getCoords();
            MiniMap.this.drawMap();
        }

        private void update() {
            MiniMap.this.firstLOS = null;
            MiniMap.this.secondLOS = null;
            MiniMap.this.drawMap();
        }
    };
    MouseListener mouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            MiniMap.this.processMouseClick(mouseEvent.getX(), mouseEvent.getY(), mouseEvent);
        }
    };
    ComponentListener componentListener = new ComponentAdapter(){

        public void componentShown(ComponentEvent componentEvent) {
            MiniMap.this.drawMap();
        }

        public void componentResized(ComponentEvent componentEvent) {
        }
    };

    public MiniMap(Dialog dialog, IGame iGame, BoardView1 boardView1) throws IOException {
        this.m_game = iGame;
        this.m_bview = boardView1;
        this.m_dialog = dialog;
        this.initializeColors();
        this.m_bview.addBoardViewListener(this.boardViewListener);
        this.m_game.addGameListener(this.gameListener);
        this.m_game.getBoard().addBoardListener(this.boardListener);
        this.addMouseListener(this.mouseListener);
        this.addComponentListener(this.componentListener);
        this.m_dialog.addComponentListener(this.componentListener);
        this.m_dialog.setResizable(false);
        Dimension dimension = this.getSize();
        boolean bl = false;
        if (dimension.width < GUIPreferences.getInstance().getMinimumSizeWidth()) {
            dimension.width = GUIPreferences.getInstance().getMinimumSizeWidth();
            bl = true;
        }
        if (dimension.height < GUIPreferences.getInstance().getMinimumSizeHeight()) {
            dimension.height = GUIPreferences.getInstance().getMinimumSizeHeight();
            bl = true;
        }
        if (bl) {
            this.setSize(dimension);
        }
        this.setLocation(GUIPreferences.getInstance().getMinimapPosX(), GUIPreferences.getInstance().getMinimapPosY());
    }

    public MiniMap(Dialog dialog, ClientGUI clientGUI, BoardView1 boardView1) throws IOException {
        this(dialog, clientGUI.getClient().game, boardView1);
        this.clientgui = clientGUI;
        clientGUI.minimapW.addKeyListener(clientGUI.menuBar);
        this.addKeyListener(clientGUI.menuBar);
        this.m_client = clientGUI.getClient();
    }

    public synchronized void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.m_mapImage != null) {
            graphics.drawImage(this.m_mapImage, 0, 0, this);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initializeColors() throws IOException {
        MiniMap.BACKGROUND = Color.black;
        MiniMap.m_terrainColors[0] = new Color(218, 215, 170);
        MiniMap.SINKHOLE = new Color(218, 215, 170);
        MiniMap.m_terrainColors[1] = new Color(180, 230, 130);
        MiniMap.HEAVY_WOODS = new Color(160, 200, 100);
        MiniMap.m_terrainColors[2] = new Color(215, 181, 0);
        MiniMap.m_terrainColors[3] = new Color(200, 200, 200);
        MiniMap.m_terrainColors[4] = new Color(200, 247, 253);
        MiniMap.m_terrainColors[5] = new Color(204, 204, 204);
        MiniMap.m_terrainColors[6] = new Color(71, 79, 107);
        MiniMap.m_terrainColors[7] = Color.red;
        MiniMap.m_terrainColors[8] = new Color(204, 204, 204);
        MiniMap.SMOKE_AND_FIRE = new Color(153, 0, 0);
        MiniMap.m_terrainColors[9] = new Color(49, 136, 74);
        MiniMap.m_terrainColors[10] = new Color(204, 204, 204);
        MiniMap.m_terrainColors[14] = new Color(109, 55, 25);
        MiniMap.m_terrainColors[20] = new Color(204, 204, 255);
        MiniMap.m_terrainColors[24] = new Color(200, 0, 0);
        MiniMap.m_terrainColors[25] = new Color(218, 160, 100);
        MiniMap.m_terrainColors[23] = new Color(180, 230, 130);
        var4_1 = new File("data/images/hexes/" + GUIPreferences.getInstance().getMinimapColours());
        if (!var4_1.exists()) {
            return;
        }
        var5_2 = new FileReader(var4_1);
        var6_3 = new StreamTokenizer(var5_2);
        var6_3.lowerCaseMode(true);
        var6_3.quoteChar(34);
        var6_3.commentChar(35);
        block5: while (true) {
            var1_4 = 0;
            var2_5 = 0;
            var3_6 = 0;
            switch (var6_3.nextToken()) {
                case -1: {
                    break block5;
                }
                case 10: {
                    break block5;
                }
                case -3: {
                    var7_7 = var6_3.sval;
                    if (!var7_7.equals("unitsize")) ** GOTO lbl45
                    var6_3.nextToken();
                    this.unitSize = (int)var6_3.nval;
                    ** GOTO lbl103
lbl45:
                    // 1 sources

                    if (!var7_7.equals("background")) ** GOTO lbl57
                    var6_3.nextToken();
                    var1_4 = (int)var6_3.nval;
                    var6_3.nextToken();
                    var2_5 = (int)var6_3.nval;
                    var6_3.nextToken();
                    var3_6 = (int)var6_3.nval;
                    MiniMap.BACKGROUND = new Color(var1_4, var2_5, var3_6);
                    ** GOTO lbl103
lbl57:
                    // 1 sources

                    if (!var7_7.equals("heavywoods")) ** GOTO lbl69
                    var6_3.nextToken();
                    var1_4 = (int)var6_3.nval;
                    var6_3.nextToken();
                    var2_5 = (int)var6_3.nval;
                    var6_3.nextToken();
                    var3_6 = (int)var6_3.nval;
                    MiniMap.HEAVY_WOODS = new Color(var1_4, var2_5, var3_6);
                    ** GOTO lbl103
lbl69:
                    // 1 sources

                    if (!var7_7.equals("sinkhole")) ** GOTO lbl81
                    var6_3.nextToken();
                    var1_4 = (int)var6_3.nval;
                    var6_3.nextToken();
                    var2_5 = (int)var6_3.nval;
                    var6_3.nextToken();
                    var3_6 = (int)var6_3.nval;
                    MiniMap.SINKHOLE = new Color(var1_4, var2_5, var3_6);
                    ** GOTO lbl103
lbl81:
                    // 1 sources

                    if (var7_7.equals("smokeandfire")) {
                        var6_3.nextToken();
                        var1_4 = (int)var6_3.nval;
                        var6_3.nextToken();
                        var2_5 = (int)var6_3.nval;
                        var6_3.nextToken();
                        var3_6 = (int)var6_3.nval;
                        MiniMap.SMOKE_AND_FIRE = new Color(var1_4, var2_5, var3_6);
                    } else {
                        var6_3.nextToken();
                        var1_4 = (int)var6_3.nval;
                        var6_3.nextToken();
                        var2_5 = (int)var6_3.nval;
                        var6_3.nextToken();
                        var3_6 = (int)var6_3.nval;
                        MiniMap.m_terrainColors[Terrains.getType((String)var7_7)] = new Color(var1_4, var2_5, var3_6);
                    }
                }
lbl103:
                // 7 sources

                default: {
                    continue block5;
                }
            }
            break;
        }
        var5_2.close();
    }

    private void initializeMap() {
        int n;
        if (this.zoom < 0) {
            this.zoom = 0;
        } else if (this.zoom > this.hexSide.length - 1) {
            this.zoom = this.hexSide.length - 1;
        }
        int n2 = this.hexSide[this.zoom];
        int n3 = this.hexSideByCos30[this.zoom];
        int n4 = this.hexSideBySin30[this.zoom];
        this.topMargin = 6;
        this.leftMargin = 6;
        int n5 = this.m_game.getBoard().getWidth() * (n2 + n4) + n4 + 12;
        int n6 = (2 * this.m_game.getBoard().getHeight() + 1) * n3 + 12 + 14;
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (n = 0; n < graphicsDeviceArray.length; ++n) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[n];
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
            for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
                rectangle = rectangle.union(graphicsConfigurationArray[i].getBounds());
            }
        }
        while (this.zoom > 0 && (n5 > rectangle.width || n6 > rectangle.height)) {
            --this.zoom;
            n2 = this.hexSide[this.zoom];
            n3 = this.hexSideByCos30[this.zoom];
            n4 = this.hexSideBySin30[this.zoom];
            n5 = this.m_game.getBoard().getWidth() * (n2 + n4) + n4 + 12;
            n6 = (2 * this.m_game.getBoard().getHeight() + 1) * n3 + 12 + 14;
        }
        n = this.getParent().getLocation().x;
        int n7 = this.getParent().getLocation().y;
        if ((double)(n + n5) > rectangle.getMaxX()) {
            n = (int)(rectangle.getMaxX() - (double)n5);
        }
        if ((double)n < rectangle.getMinX()) {
            n = (int)rectangle.getMinX();
        }
        if ((double)(n7 + n6) > rectangle.getMaxY()) {
            n7 = (int)(rectangle.getMaxY() - (double)n6);
        }
        if ((double)n7 < rectangle.getMinY()) {
            n7 = (int)rectangle.getMinY();
        }
        this.getParent().setLocation(n, n7);
        this.setSize(n5, n6);
        this.m_dialog.pack();
        this.m_mapImage = this.createImage(this.getSize().width, this.getSize().height);
        if (this.getSize().width > n5) {
            this.leftMargin = (this.getSize().width - n5) / 2 + 6;
        }
        if (this.getSize().height > n6) {
            this.topMargin = (this.getSize().height - n6) / 2 + 6;
        }
        this.drawMap();
    }

    public synchronized void drawMap() {
        if (this.m_mapImage == null) {
            return;
        }
        if (!this.m_dialog.isVisible()) {
            return;
        }
        Graphics graphics = this.m_mapImage.getGraphics();
        Color color = graphics.getColor();
        graphics.setColor(BACKGROUND);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(color);
        if (!this.minimized) {
            GameTurn gameTurn;
            IHex iHex;
            int n;
            int n2;
            this.roadHexIndexes.removeAllElements();
            for (n2 = 0; n2 < this.m_game.getBoard().getWidth(); ++n2) {
                for (n = 0; n < this.m_game.getBoard().getHeight(); ++n) {
                    iHex = this.m_game.getBoard().getHex(n2, n);
                    graphics.setColor(this.terrainColor(iHex, n2, n));
                    this.paintCoord(graphics, n2, n, true);
                }
            }
            if (this.firstLOS != null) {
                this.paintSingleCoordBorder(graphics, this.firstLOS.x, this.firstLOS.y, Color.red);
            }
            if (this.secondLOS != null) {
                this.paintSingleCoordBorder(graphics, this.secondLOS.x, this.secondLOS.y, Color.red);
            }
            if (!this.roadHexIndexes.isEmpty()) {
                this.paintRoads(graphics);
            }
            if (0 != this.heightDisplayMode) {
                for (n2 = 0; n2 < this.m_game.getBoard().getWidth(); ++n2) {
                    for (n = 0; n < this.m_game.getBoard().getHeight(); ++n) {
                        iHex = this.m_game.getBoard().getHex(n2, n);
                        this.paintHeight(graphics, iHex, n2, n);
                    }
                }
            }
            if (null != this.m_client && null != this.m_game && 4 == this.m_game.getPhase() && (gameTurn = this.m_game.getTurn()) != null && gameTurn.getPlayerNum() == this.m_client.getLocalPlayer().getId()) {
                for (n = 0; n < this.m_game.getBoard().getWidth(); ++n) {
                    for (int i = 0; i < this.m_game.getBoard().getHeight(); ++i) {
                        if (!this.m_game.getBoard().isLegalDeployment(new Coords(n, i), this.m_client.getLocalPlayer())) continue;
                        this.paintSingleCoordBorder(graphics, n, i, Color.yellow);
                    }
                }
            }
            if (12 == this.m_game.getPhase() || 14 == this.m_game.getPhase()) {
                Enumeration enumeration = this.m_game.getActions();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (!(e instanceof AttackAction)) continue;
                    this.paintAttack(graphics, (AttackAction)e);
                }
            }
            Enumeration enumeration = this.m_game.getEntities();
            while (enumeration.hasMoreElements()) {
                Entity entity = (Entity)enumeration.nextElement();
                if (entity.getPosition() == null) continue;
                this.paintUnit(graphics, entity, true);
            }
        }
        this.drawBtn(graphics);
        this.repaint();
    }

    private void drawBtn(Graphics graphics) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        Color color = graphics.getColor();
        if (this.minimized) {
            nArray[0] = Math.round((this.getSize().width - 11) / 2);
            nArray2[0] = this.getSize().height - 10;
            nArray[1] = nArray[0] + 11;
            nArray2[1] = nArray2[0];
            nArray[2] = nArray[0] + 6;
            nArray2[2] = nArray2[0] + 5;
        } else {
            nArray[0] = Math.round((this.getSize().width - 11) / 2);
            nArray2[0] = this.getSize().height - 4;
            nArray[1] = nArray[0] + 11;
            nArray2[1] = nArray2[0];
            nArray[2] = nArray[0] + 5;
            nArray2[2] = nArray2[0] - 5;
        }
        graphics.setColor(Color.green.darker().darker());
        graphics.fillRect(0, this.getSize().height - 14, this.getSize().width, 14);
        graphics.setColor(Color.green.darker());
        graphics.drawLine(0, this.getSize().height - 14, this.getSize().width, this.getSize().height - 14);
        graphics.drawLine(0, this.getSize().height - 14, 0, this.getSize().height);
        graphics.setColor(Color.black);
        graphics.drawLine(0, this.getSize().height - 1, this.getSize().width, this.getSize().height - 1);
        graphics.drawLine(this.getSize().width - 1, this.getSize().height - 14, this.getSize().width - 1, this.getSize().height);
        graphics.setColor(Color.yellow);
        graphics.fillPolygon(nArray, nArray2, 3);
        if (!this.minimized) {
            graphics.setColor(Color.black);
            graphics.drawLine(13, this.getSize().height - 14, 13, this.getSize().height);
            graphics.drawLine(this.getSize().width - 14 - 1, this.getSize().height - 14, this.getSize().width - 14 - 1, this.getSize().height);
            graphics.setColor(Color.green.darker());
            graphics.drawLine(14, this.getSize().height - 14, 14, this.getSize().height);
            graphics.drawLine(this.getSize().width - 14, this.getSize().height - 14, this.getSize().width - 14, this.getSize().height);
            if (this.zoom == 0) {
                graphics.setColor(Color.gray.brighter());
            } else {
                graphics.setColor(Color.yellow);
            }
            graphics.fillRect(3, this.getSize().height - 14 + 6, 8, 2);
            if (this.zoom == this.hexSide.length - 1) {
                graphics.setColor(Color.gray.brighter());
            } else {
                graphics.setColor(Color.yellow);
            }
            graphics.fillRect(this.getSize().width - 14 + 3, this.getSize().height - 14 + 6, 8, 2);
            graphics.fillRect(this.getSize().width - 14 + 6, this.getSize().height - 14 + 3, 2, 8);
            if (this.zoom > 2) {
                String string;
                graphics.setColor(Color.black);
                graphics.drawLine(27, this.getSize().height - 14, 27, this.getSize().height);
                graphics.setColor(Color.green.darker());
                graphics.drawLine(28, this.getSize().height - 14, 28, this.getSize().height);
                graphics.setColor(Color.yellow);
                switch (this.heightDisplayMode) {
                    case 0: {
                        string = Messages.getString("MiniMap.NoHeightLabel");
                        break;
                    }
                    case 1: {
                        string = Messages.getString("MiniMap.GroundHeightLabel");
                        break;
                    }
                    case 2: {
                        string = Messages.getString("MiniMap.BuildingHeightLabel");
                        break;
                    }
                    case 3: {
                        string = Messages.getString("MiniMap.TotalHeightLabel");
                        break;
                    }
                    default: {
                        string = "";
                    }
                }
                graphics.drawString(string, 17, this.getSize().height - 14 + 12);
            }
        }
        graphics.setColor(color);
    }

    private void paintHeight(Graphics graphics, IHex iHex, int n, int n2) {
        if (this.heightDisplayMode == 0) {
            return;
        }
        if (this.zoom > 2) {
            int n3 = n * (this.hexSide[this.zoom] + this.hexSideBySin30[this.zoom]) + this.leftMargin;
            int n4 = (2 * n2 + 1 + n % 2) * this.hexSideByCos30[this.zoom] + this.topMargin;
            graphics.setColor(Color.white);
            int n5 = 0;
            if (iHex.getTerrain(10) != null && this.heightDisplayMode == 2) {
                n5 = iHex.ceiling();
            } else if (this.heightDisplayMode == 1) {
                n5 = iHex.floor();
            } else if (this.heightDisplayMode == 3) {
                int n6 = n5 = iHex.getTerrain(10) != null || iHex.getTerrain(32) != null ? iHex.ceiling() : iHex.floor();
            }
            if (n5 != 0) {
                graphics.drawString(n5 + "", n3 + 5, n4 + 5);
            }
        }
    }

    private void paintSingleCoordBorder(Graphics graphics, int n, int n2, Color color) {
        int n3 = n * (this.hexSide[this.zoom] + this.hexSideBySin30[this.zoom]) + this.leftMargin;
        int n4 = (2 * n2 + 1 + n % 2) * this.hexSideByCos30[this.zoom] + this.topMargin;
        int[] nArray = new int[6];
        int[] nArray2 = new int[6];
        nArray[0] = n3;
        nArray2[0] = n4;
        nArray[1] = n3 + this.hexSideBySin30[this.zoom];
        nArray2[1] = n4 + this.hexSideByCos30[this.zoom];
        nArray[2] = nArray[1] + this.hexSide[this.zoom];
        nArray2[2] = nArray2[1];
        nArray[3] = nArray[2] + this.hexSideBySin30[this.zoom];
        nArray2[3] = n4;
        nArray[4] = nArray[2];
        nArray2[4] = n4 - this.hexSideByCos30[this.zoom];
        nArray[5] = nArray[1];
        nArray2[5] = nArray2[4];
        graphics.setColor(color);
        graphics.drawPolygon(nArray, nArray2, 6);
    }

    private void paintCoord(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = n * (this.hexSide[this.zoom] + this.hexSideBySin30[this.zoom]) + this.leftMargin;
        int n4 = (2 * n2 + 1 + n % 2) * this.hexSideByCos30[this.zoom] + this.topMargin;
        int[] nArray = new int[6];
        int[] nArray2 = new int[6];
        nArray[0] = n3;
        nArray2[0] = n4;
        nArray[1] = n3 + this.hexSideBySin30[this.zoom];
        nArray2[1] = n4 + this.hexSideByCos30[this.zoom];
        nArray[2] = nArray[1] + this.hexSide[this.zoom];
        nArray2[2] = nArray2[1];
        nArray[3] = nArray[2] + this.hexSideBySin30[this.zoom];
        nArray2[3] = n4;
        nArray[4] = nArray[2];
        nArray2[4] = n4 - this.hexSideByCos30[this.zoom];
        nArray[5] = nArray[1];
        nArray2[5] = nArray2[4];
        graphics.fillPolygon(nArray, nArray2, 6);
        if (bl) {
            Color color = graphics.getColor();
            graphics.setColor(color.darker());
            graphics.drawPolygon(nArray, nArray2, 6);
            graphics.setColor(color);
        }
    }

    private void paintAttack(Graphics graphics, AttackAction attackAction) {
        Serializable serializable;
        Entity entity = this.m_game.getEntity(attackAction.getEntityId());
        Targetable targetable = this.m_game.getTarget(attackAction.getTargetType(), attackAction.getTargetId());
        if (null == entity || null == targetable) {
            return;
        }
        if (attackAction.getTargetType() == 11) {
            return;
        }
        if (attackAction instanceof WeaponAttackAction) {
            serializable = (WeaponAttackAction)attackAction;
            if (attackAction.getTargetType() == 7 && ((AbstractAttackAction)serializable).getEntity(this.m_game).getOwner().getId() != this.m_client.getLocalPlayer().getId()) {
                return;
            }
        }
        serializable = graphics.getColor();
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = entity.getPosition().x * (this.hexSide[this.zoom] + this.hexSideBySin30[this.zoom]) + this.leftMargin + 1 * this.hexSide[this.zoom] - 2;
        nArray2[0] = (2 * entity.getPosition().y + 1 + entity.getPosition().x % 2) * this.hexSideByCos30[this.zoom] + this.topMargin;
        nArray[1] = targetable.getPosition().x * (this.hexSide[this.zoom] + this.hexSideBySin30[this.zoom]) + this.leftMargin + 1 * this.hexSide[this.zoom] - 2;
        nArray2[1] = (2 * targetable.getPosition().y + 1 + targetable.getPosition().x % 2) * this.hexSideByCos30[this.zoom] + this.topMargin;
        nArray[2] = nArray[1] + 2;
        nArray[3] = nArray[0] + 2;
        if (entity.getPosition().x > targetable.getPosition().x && entity.getPosition().y < targetable.getPosition().y || entity.getPosition().x < targetable.getPosition().x && entity.getPosition().y > targetable.getPosition().y) {
            nArray2[3] = nArray2[0] + 2;
            nArray2[2] = nArray2[1] + 2;
        } else {
            nArray2[3] = nArray2[0] - 2;
            nArray2[2] = nArray2[1] - 2;
        }
        graphics.setColor(PlayerColors.getColor(entity.getOwner().getColorIndex()));
        graphics.fillPolygon(nArray, nArray2, 4);
        graphics.setColor(Color.black);
        graphics.drawPolygon(nArray, nArray2, 4);
        Enumeration enumeration = this.m_game.getActions();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof AttackAction)) continue;
            AttackAction attackAction2 = (AttackAction)e;
            if (attackAction.getEntityId() != attackAction2.getTargetId() || attackAction2.getEntityId() != attackAction.getTargetId()) continue;
            Entity entity2 = this.m_game.getEntity(attackAction2.getEntityId());
            graphics.setColor(PlayerColors.getColor(entity2.getOwner().getColorIndex()));
            nArray[0] = nArray[3];
            nArray2[0] = nArray2[3];
            nArray[1] = nArray[2];
            nArray2[1] = nArray2[2];
            nArray[2] = nArray[1] + 2;
            nArray[3] = nArray[0] + 2;
            if (entity.getPosition().x > targetable.getPosition().x && entity.getPosition().y < targetable.getPosition().y || entity.getPosition().x < targetable.getPosition().x && entity.getPosition().y > targetable.getPosition().y) {
                nArray2[3] = nArray2[0] + 2;
                nArray2[2] = nArray2[1] + 2;
            } else {
                nArray2[3] = nArray2[0] - 2;
                nArray2[2] = nArray2[1] - 2;
            }
            graphics.fillPolygon(nArray, nArray2, 4);
            graphics.setColor(Color.black);
            graphics.drawPolygon(nArray, nArray2, 4);
            break;
        }
        graphics.setColor((Color)serializable);
    }

    private void paintUnit(Graphics graphics, Entity entity, boolean bl) {
        Color color;
        Entity entity2;
        int[] nArray;
        int[] nArray2;
        int n = entity.getPosition().x * (this.hexSide[this.zoom] + this.hexSideBySin30[this.zoom]) + this.leftMargin + this.hexSide[this.zoom];
        int n2 = (2 * entity.getPosition().y + 1 + entity.getPosition().x % 2) * this.hexSideByCos30[this.zoom] + this.topMargin;
        if (entity instanceof Mech) {
            nArray2 = new int[3];
            nArray = new int[3];
            nArray2[0] = n;
            nArray[0] = n2 - this.unitSize;
            nArray2[1] = n - this.unitSize;
            nArray[1] = n2 + this.unitSize / 2;
            nArray2[2] = n + this.unitSize;
            nArray[2] = n2 + this.unitSize / 2;
        } else if (entity instanceof VTOL) {
            nArray2 = new int[8];
            nArray = new int[8];
            nArray2[0] = n - this.unitSize;
            nArray2[1] = n - this.unitSize / 3;
            nArray2[2] = n;
            nArray2[3] = n + this.unitSize / 3;
            nArray2[4] = n + this.unitSize;
            nArray2[5] = nArray2[3];
            nArray2[6] = nArray2[2];
            nArray2[7] = nArray2[1];
            nArray[0] = n2;
            nArray[1] = n2 - this.unitSize / 3;
            nArray[2] = n2 - this.unitSize;
            nArray[3] = n2 - this.unitSize / 3;
            nArray[4] = n2;
            nArray[5] = n2 + this.unitSize / 3;
            nArray[6] = n2 + this.unitSize;
            nArray[7] = n2 + this.unitSize / 3;
        } else if (entity instanceof Tank) {
            nArray2 = new int[4];
            nArray = new int[4];
            nArray2[0] = n - this.unitSize * 2 / 3;
            nArray[0] = n2 - this.unitSize * 2 / 3;
            nArray2[1] = n - this.unitSize * 2 / 3;
            nArray[1] = n2 + this.unitSize * 2 / 3;
            nArray2[2] = n + this.unitSize * 2 / 3;
            nArray[2] = n2 + this.unitSize * 2 / 3;
            nArray2[3] = n + this.unitSize * 2 / 3;
            nArray[3] = n2 - this.unitSize * 2 / 3;
        } else if (entity instanceof Protomech) {
            nArray2 = new int[3];
            nArray = new int[3];
            nArray2[0] = n;
            nArray[0] = n2 + this.unitSize;
            nArray2[1] = n + this.unitSize;
            nArray[1] = n2 - this.unitSize / 2;
            nArray2[2] = n - this.unitSize;
            nArray[2] = n2 - this.unitSize / 2;
        } else if (entity instanceof GunEmplacement) {
            int n3 = this.unitSize * 2 / 3;
            nArray2 = new int[8];
            nArray = new int[8];
            nArray2[0] = n - n3 / 2;
            nArray[0] = n2 - n3 * 3 / 2;
            nArray2[1] = nArray2[0] - n3;
            nArray[1] = nArray[0] + n3;
            nArray2[2] = nArray2[1];
            nArray[2] = nArray[1] + n3;
            nArray2[3] = nArray2[2] + n3;
            nArray[3] = nArray[2] + n3;
            nArray2[4] = nArray2[3] + n3;
            nArray[4] = nArray[3];
            nArray2[5] = nArray2[4] + n3;
            nArray[5] = nArray[4] - n3;
            nArray2[6] = nArray2[5];
            nArray[6] = nArray[5] - n3;
            nArray2[7] = nArray2[6] - n3;
            nArray[7] = nArray[6] - n3;
        } else {
            nArray2 = new int[4];
            nArray = new int[4];
            nArray2[0] = n;
            nArray[0] = n2 - this.unitSize;
            nArray2[1] = n - this.unitSize;
            nArray[1] = n2;
            nArray2[2] = n;
            nArray[2] = n2 + this.unitSize;
            nArray2[3] = n + this.unitSize;
            nArray[3] = n2;
        }
        graphics.setColor(PlayerColors.getColor(entity.getOwner().getColorIndex()));
        if (!entity.isSelectableThisTurn()) {
            graphics.setColor(graphics.getColor().darker());
        }
        graphics.fillPolygon(nArray2, nArray, nArray2.length);
        Entity entity3 = entity2 = this.clientgui == null ? null : this.m_game.getEntity(this.clientgui.getSelectedEntityNum());
        if (entity == entity2) {
            color = new Color(255, 255, 255);
            Color color2 = new Color(0, 0, 0);
            graphics.setColor(color2);
            graphics.drawRect(n - 1, n2 - 1, 3, 3);
            graphics.setColor(color);
            graphics.drawRect(n, n2, 1, 1);
        }
        if (bl) {
            color = graphics.getColor();
            graphics.setColor(color.darker().darker().darker());
            graphics.drawPolygon(nArray2, nArray, nArray2.length);
            graphics.setColor(color);
        }
    }

    private void paintRoads(Graphics graphics) {
        int n = 0;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        Color color = graphics.getColor();
        graphics.setColor(m_terrainColors[6]);
        Enumeration enumeration = this.roadHexIndexes.elements();
        while (enumeration.hasMoreElements()) {
            int[] nArray3 = (int[])enumeration.nextElement();
            int n2 = nArray3[0];
            int n3 = nArray3[1];
            int n4 = n2 * (this.hexSide[this.zoom] + this.hexSideBySin30[this.zoom]) + this.leftMargin + this.hexSide[this.zoom];
            int n5 = (2 * n3 + 1 + n2 % 2) * this.hexSideByCos30[this.zoom] + this.topMargin;
            n = nArray3[2];
            if (0 != (n & 1)) {
                nArray[0] = n4 - this.halfRoadWidth[this.zoom];
                nArray2[0] = n5;
                nArray[1] = n4 - this.halfRoadWidth[this.zoom];
                nArray2[1] = n5 - this.hexSideByCos30[this.zoom];
                nArray[2] = n4 + this.halfRoadWidth[this.zoom];
                nArray2[2] = n5 - this.hexSideByCos30[this.zoom];
                nArray[3] = n4 + this.halfRoadWidth[this.zoom];
                nArray2[3] = n5;
                graphics.drawPolygon(nArray, nArray2, 4);
                graphics.fillPolygon(nArray, nArray2, 4);
            }
            if (0 != (n & 2)) {
                nArray[0] = n4 - this.halfRoadWidthBySin30[this.zoom];
                nArray2[0] = n5 - this.halfRoadWidthByCos30[this.zoom];
                nArray[1] = Math.round(n4 + 3 * this.hexSide[this.zoom] / 4 - this.halfRoadWidthBySin30[this.zoom]);
                nArray2[1] = Math.round(n5 - this.hexSideByCos30[this.zoom] / 2 - this.halfRoadWidthByCos30[this.zoom]);
                nArray[2] = nArray[1] + 2 * this.halfRoadWidthBySin30[this.zoom];
                nArray2[2] = nArray2[1] + 2 * this.halfRoadWidthByCos30[this.zoom];
                nArray[3] = n4 + this.halfRoadWidthBySin30[this.zoom];
                nArray2[3] = n5 + this.halfRoadWidthByCos30[this.zoom];
                graphics.drawPolygon(nArray, nArray2, 4);
                graphics.fillPolygon(nArray, nArray2, 4);
            }
            if (0 != (n & 4)) {
                nArray[0] = n4 + this.halfRoadWidthBySin30[this.zoom];
                nArray2[0] = n5 - this.halfRoadWidthByCos30[this.zoom];
                nArray[1] = Math.round(n4 + 3 * this.hexSide[this.zoom] / 4 + this.halfRoadWidthBySin30[this.zoom]);
                nArray2[1] = Math.round(n5 + this.hexSideByCos30[this.zoom] / 2 - this.halfRoadWidthByCos30[this.zoom]);
                nArray[2] = nArray[1] - 2 * this.halfRoadWidthBySin30[this.zoom];
                nArray2[2] = nArray2[1] + 2 * this.halfRoadWidthByCos30[this.zoom];
                nArray[3] = n4 - this.halfRoadWidthBySin30[this.zoom];
                nArray2[3] = n5 + this.halfRoadWidthByCos30[this.zoom];
                graphics.drawPolygon(nArray, nArray2, 4);
                graphics.fillPolygon(nArray, nArray2, 4);
            }
            if (0 != (n & 8)) {
                nArray[0] = n4 + this.halfRoadWidth[this.zoom];
                nArray2[0] = n5;
                nArray[1] = n4 + this.halfRoadWidth[this.zoom];
                nArray2[1] = n5 + this.hexSideByCos30[this.zoom];
                nArray[2] = n4 - this.halfRoadWidth[this.zoom];
                nArray2[2] = n5 + this.hexSideByCos30[this.zoom];
                nArray[3] = n4 - this.halfRoadWidth[this.zoom];
                nArray2[3] = n5;
                graphics.drawPolygon(nArray, nArray2, 4);
                graphics.fillPolygon(nArray, nArray2, 4);
            }
            if (0 != (n & 0x10)) {
                nArray[0] = n4 + this.halfRoadWidthBySin30[this.zoom];
                nArray2[0] = n5 + this.halfRoadWidthByCos30[this.zoom];
                nArray[1] = Math.round(n4 - 3 * this.hexSide[this.zoom] / 4 + this.halfRoadWidthBySin30[this.zoom]);
                nArray2[1] = Math.round(n5 + this.hexSideByCos30[this.zoom] / 2 + this.halfRoadWidthByCos30[this.zoom]);
                nArray[2] = nArray[1] - 2 * this.halfRoadWidthBySin30[this.zoom];
                nArray2[2] = nArray2[1] - 2 * this.halfRoadWidthByCos30[this.zoom];
                nArray[3] = n4 - this.halfRoadWidthBySin30[this.zoom];
                nArray2[3] = n5 - this.halfRoadWidthByCos30[this.zoom];
                graphics.drawPolygon(nArray, nArray2, 4);
                graphics.fillPolygon(nArray, nArray2, 4);
            }
            if (0 == (n & 0x20)) continue;
            nArray[0] = n4 - this.halfRoadWidthBySin30[this.zoom];
            nArray2[0] = n5 + this.halfRoadWidthByCos30[this.zoom];
            nArray[1] = Math.round(n4 - 3 * this.hexSide[this.zoom] / 4 - this.halfRoadWidthBySin30[this.zoom]);
            nArray2[1] = Math.round(n5 - this.hexSideByCos30[this.zoom] / 2 + this.halfRoadWidthByCos30[this.zoom]);
            nArray[2] = nArray[1] + 2 * this.halfRoadWidthBySin30[this.zoom];
            nArray2[2] = nArray2[1] - 2 * this.halfRoadWidthByCos30[this.zoom];
            nArray[3] = n4 + this.halfRoadWidthBySin30[this.zoom];
            nArray2[3] = n5 - this.halfRoadWidthByCos30[this.zoom];
            graphics.drawPolygon(nArray, nArray2, 4);
            graphics.fillPolygon(nArray, nArray2, 4);
        }
        graphics.setColor(color);
    }

    private Color terrainColor(IHex iHex, int n, int n2) {
        int n3;
        Color color = m_terrainColors[0];
        if (iHex.getElevation() < 0) {
            color = SINKHOLE;
        }
        int n4 = 0;
        int n5 = 0;
        for (n3 = m_terrainColors.length - 1; n3 >= 0; --n3) {
            if (iHex.getTerrain(n3) == null || m_terrainColors[n3] == null) continue;
            if (n3 == 6 || n3 == 14) {
                int[] nArray = new int[]{n, n2, iHex.getTerrain(n3).getExits()};
                this.roadHexIndexes.addElement(nArray);
                continue;
            }
            color = m_terrainColors[n3];
            n5 = n3;
            if ((n3 == 1 || n3 == 23) && iHex.getTerrain(n3).getLevel() > 1) {
                color = HEAVY_WOODS;
            }
            if (n3 != 8 || iHex.getTerrain(7) == null) break;
            color = SMOKE_AND_FIRE;
            break;
        }
        switch (n5) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 20: 
            case 23: {
                n4 = Math.abs(iHex.floor());
                if (n4 > 10) {
                    n4 = 10;
                }
                n3 = color.getRed() - n4 * 15;
                int n6 = color.getGreen() - n4 * 15;
                int n7 = color.getBlue() - n4 * 15;
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n7 < 0) {
                    n7 = 0;
                }
                return new Color(n3, n6, n7);
            }
            case 10: 
            case 32: {
                n4 = Math.abs(iHex.ceiling());
                if (n4 > 10) {
                    n4 = 10;
                }
                n3 = color.getRed() - n4 * 15;
                int n8 = color.getGreen() - n4 * 15;
                int n9 = color.getBlue() - n4 * 15;
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n8 < 0) {
                    n8 = 0;
                }
                if (n9 < 0) {
                    n9 = 0;
                }
                return new Color(n3, n8, n9);
            }
        }
        return color;
    }

    private Coords translateCoords(int n, int n2) {
        boolean bl;
        int n3 = n / (this.hexSideBySin30[this.zoom] + this.hexSide[this.zoom]);
        int n4 = n % (this.hexSideBySin30[this.zoom] + this.hexSide[this.zoom]);
        int n5 = n2 / (2 * this.hexSideByCos30[this.zoom]);
        int n6 = n2 % (2 * this.hexSideByCos30[this.zoom]);
        boolean bl2 = bl = (n3 & 1) == 0;
        if (n6 < this.hexSideByCos30[this.zoom]) {
            if (bl) {
                if (n4 < (n6 - this.hexSideByCos30[this.zoom]) * this.hexSideBySin30[this.zoom] / this.hexSideByCos30[this.zoom] * -1) {
                    --n3;
                    --n5;
                }
            } else if (n4 < n6 * this.hexSideBySin30[this.zoom] / this.hexSideByCos30[this.zoom]) {
                --n3;
            } else {
                --n5;
            }
        } else if (bl) {
            if (n4 < (n6 - this.hexSideByCos30[this.zoom]) * this.hexSideBySin30[this.zoom] / this.hexSideByCos30[this.zoom]) {
                --n3;
            }
        } else if (n4 < (n6 - 2 * this.hexSideByCos30[this.zoom]) * this.hexSideBySin30[this.zoom] / this.hexSideByCos30[this.zoom] * -1) {
            --n3;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        return new Coords(n3, n5);
    }

    private void processMouseClick(int n, int n2, MouseEvent mouseEvent) {
        if (n2 > this.getSize().height - 14) {
            if (n < 14) {
                if (this.zoom == 0) {
                    return;
                }
                --this.zoom;
                this.initializeMap();
            } else if (n < 28 && this.zoom > 2) {
                this.heightDisplayMode = ++this.heightDisplayMode > 3 ? 0 : this.heightDisplayMode;
                this.initializeMap();
            } else if (n > this.getSize().width - 14) {
                if (this.zoom == this.hexSide.length - 1) {
                    return;
                }
                ++this.zoom;
                this.initializeMap();
            } else {
                if (this.minimized) {
                    this.setSize(this.getSize().width, this.heightBufer);
                    this.m_mapImage = this.createImage(this.getSize().width, this.heightBufer);
                } else {
                    this.heightBufer = this.getSize().height;
                    this.setSize(this.getSize().width, 14);
                    this.m_mapImage = this.createImage(Math.max(1, this.getSize().width), 14);
                }
                this.minimized = !this.minimized;
                this.m_dialog.pack();
                this.drawMap();
            }
        } else {
            if (n < 6 || n > this.getSize().width - this.leftMargin || n2 < this.topMargin || n2 > this.getSize().height - this.topMargin - 14) {
                return;
            }
            if ((mouseEvent.getModifiers() & 2) != 0) {
                this.m_bview.mouseAction(this.translateCoords(n - this.leftMargin, n2 - this.topMargin), 1, mouseEvent.getModifiers());
            } else {
                this.m_bview.centerOnHex(this.translateCoords(n - this.leftMargin, n2 - this.topMargin));
            }
        }
    }

    public int getZoom() {
        return this.zoom;
    }
}

