/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListener;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.DoneButtoned;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.StatusBarPhaseDisplay;
import megamek.common.Coords;
import megamek.common.Player;
import megamek.common.event.GameListener;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GameTurnChangeEvent;
import megamek.common.util.Distractable;
import megamek.common.util.DistractableAdapter;

public class SelectArtyAutoHitHexDisplay
extends StatusBarPhaseDisplay
implements BoardViewListener,
ActionListener,
DoneButtoned,
KeyListener,
GameListener,
Distractable {
    private DistractableAdapter distracted = new DistractableAdapter();
    public ClientGUI clientgui;
    private Client client;
    public static final String SET_HIT_HEX = "setAutoHitHex";
    private Panel panButtons;
    private Button butA;
    private Button butDone;
    private Player p;
    private Vector artyAutoHitHexes = new Vector();

    public SelectArtyAutoHitHexDisplay(ClientGUI clientGUI) {
        this.clientgui = clientGUI;
        this.client = clientGUI.getClient();
        this.client.game.addGameListener(this);
        clientGUI.getBoardView().addBoardViewListener(this);
        this.setupStatusBar(Messages.getString("SelectArtyAutoHitHexDisplay.waitingArtillery"));
        this.p = this.client.getLocalPlayer();
        this.artyAutoHitHexes.insertElementAt(new Integer(this.p.getId()), 0);
        this.butA = new Button(Messages.getString("SelectArtyAutoHitHexDisplay.artilleryAutohithexes"));
        this.butA.addActionListener(this);
        this.butA.setActionCommand(SET_HIT_HEX);
        this.butA.setEnabled(false);
        this.butDone = new Button(Messages.getString("SelectArtyAutoHitHexDisplay.Done"));
        this.butDone.addActionListener(this);
        this.butDone.setEnabled(false);
        this.panButtons = new Panel();
        this.panButtons.setLayout(new GridLayout(0, 2));
        this.panButtons.add(this.butA);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.panStatus, gridBagLayout, gridBagConstraints);
        clientGUI.bv.addKeyListener(this);
        this.addKeyListener(this);
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        component.addKeyListener(this);
    }

    private void beginMyTurn() {
        this.setArtyEnabled(5);
        this.clientgui.bv.markDeploymentHexesFor(this.p);
        this.butDone.setEnabled(true);
    }

    private void endMyTurn() {
        this.disableButtons();
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().highlight(null);
        this.clientgui.getBoardView().cursor(null);
    }

    private void disableButtons() {
        this.setArtyEnabled(0);
        this.butDone.setEnabled(false);
    }

    private void addArtyAutoHitHex(Coords coords) {
        if (!this.client.game.getBoard().contains(coords)) {
            return;
        }
        if (!this.artyAutoHitHexes.contains(coords) && this.artyAutoHitHexes.size() < 6 && this.clientgui.doYesNoDialog(Messages.getString("SelectArtyAutoHitHexDisplay.setArtilleryTargetDialog.title"), Messages.getString("SelectArtyAutoHitHexDisplay.setArtilleryTargetDialog.message", new Object[]{coords.getBoardNum()}))) {
            this.artyAutoHitHexes.addElement(coords);
            this.setArtyEnabled(6 - this.artyAutoHitHexes.size());
            if (this.artyAutoHitHexes.size() == 6) {
                this.setArtyEnabled(0);
            }
        }
    }

    public void hexMoused(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (boardViewEvent.getType() != 2) {
            return;
        }
        if (!this.client.isMyTurn() || (boardViewEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        this.clientgui.getBoardView().select(boardViewEvent.getCoords());
        this.addArtyAutoHitHex(boardViewEvent.getCoords());
    }

    public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        this.endMyTurn();
        if (this.client.isMyTurn()) {
            this.beginMyTurn();
            this.setStatusBarText(Messages.getString("SelectArtyAutoHitHexDisplay.its_your_turn"));
        } else {
            this.setStatusBarText(Messages.getString("SelectArtyAutoHitHexDisplay.its_others_turn", new Object[]{gameTurnChangeEvent.getPlayer().getName()}));
        }
    }

    public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && this.client.game.getPhase() != 22) {
            this.endMyTurn();
        }
        if (this.client.game.getPhase() == 22) {
            this.setStatusBarText(Messages.getString("SelectArtyAutoHitHexDisplay.waitingMinefieldPhase"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.statusBarActionPerformed(actionEvent, this.client)) {
            return;
        }
        if (!this.client.isMyTurn()) {
            return;
        }
        if (actionEvent.getSource().equals(this.butDone)) {
            this.endMyTurn();
            this.client.sendArtyAutoHitHexes(this.artyAutoHitHexes);
            this.client.sendPlayerInfo();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void setArtyEnabled(int n) {
        this.butA.setLabel(Messages.getString("SelectArtyAutoHitHexDisplay.designatedTargets", new Object[]{new Integer(n)}));
        this.butA.setEnabled(n > 0);
    }

    public boolean isIgnoringEvents() {
        return this.distracted.isIgnoringEvents();
    }

    public void setIgnoringEvents(boolean bl) {
        this.distracted.setIgnoringEvents(bl);
    }

    public Button getDoneButton() {
        return this.butDone;
    }

    public void removeAllListeners() {
        this.client.game.removeGameListener(this);
        this.clientgui.getBoardView().removeBoardViewListener(this);
    }
}

