/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.util;

import java.awt.Image;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageCache<K, V> {
    public static int MAX_SIZE = 500;
    private int maxSize;
    private Hashtable<K, V> cache;
    private LinkedList<K> lru = new LinkedList();

    public ImageCache() {
        this.cache = new Hashtable(MAX_SIZE * 5 / 4, 0.75f);
        this.maxSize = MAX_SIZE;
    }

    public ImageCache(int n) {
        this.cache = new Hashtable(n * 5 / 4, 0.75f);
        this.maxSize = n;
    }

    public synchronized V put(K k, V v) {
        if (k == null || v == null) {
            return null;
        }
        if (this.cache.containsKey(k)) {
            this.lru.remove(k);
        } else if (this.cache.size() == this.maxSize) {
            K k2 = this.lru.removeFirst();
            V v2 = this.cache.get(k);
            this.cache.remove(k2);
            if (v2 instanceof Image) {
                ((Image)v2).flush();
            } else if (v2 instanceof List) {
                for (Object e : (List)v2) {
                    if (!(e instanceof Image)) continue;
                    ((Image)e).flush();
                }
            }
        }
        this.lru.addLast(k);
        this.cache.put(k, v);
        return v;
    }

    public synchronized V get(K k) {
        if (!this.cache.containsKey(k)) {
            return null;
        }
        this.lru.remove(k);
        this.lru.addLast(k);
        return this.cache.get(k);
    }

    public void remove(Object object) {
        this.cache.remove(object);
    }
}

