/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.widget;

import java.awt.AWTEventMulticaster;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import megamek.client.ui.AWT.widget.PMHotArea;

public class PMPicArea
implements PMHotArea {
    private int x = 0;
    private int y = 0;
    private Rectangle areaShape;
    private ActionListener actionListener = null;
    private Image idleImage;
    private Image activeImage;
    private boolean highlight = true;
    private boolean selected = false;
    private boolean visible = true;
    private Cursor cursor = new Cursor(12);

    public PMPicArea(Image image, Image image2) {
        this.idleImage = image;
        this.activeImage = image2;
        this.areaShape = new Rectangle(this.x, this.y, image.getWidth(null), image.getHeight(null));
    }

    public PMPicArea(Image image) {
        this(image, null);
        this.highlight = false;
    }

    public void translate(int n, int n2) {
        this.areaShape.translate(n, n2);
        this.x += n;
        this.y += n2;
    }

    public Rectangle getBounds() {
        return this.areaShape.getBounds();
    }

    public void drawInto(Graphics graphics) {
        if (graphics == null || !this.visible) {
            return;
        }
        if (this.selected) {
            graphics.drawImage(this.activeImage, this.x, this.y, null);
        } else {
            graphics.drawImage(this.idleImage, this.x, this.y, null);
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public Shape getAreaShape() {
        return this.areaShape;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public void onMouseClick(MouseEvent mouseEvent) {
    }

    public void onMouseOver(MouseEvent mouseEvent) {
        if (this.highlight) {
            this.selected = true;
        }
    }

    public void onMouseExit(MouseEvent mouseEvent) {
        if (this.highlight) {
            this.selected = false;
        }
    }

    public void onMouseDown(MouseEvent mouseEvent) {
    }

    public void onMouseUp(MouseEvent mouseEvent) {
    }

    private void dispatchEvent(String string) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }
}

