/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.IMapSettingsObserver;
import megamek.client.ui.swing.MapPreview;
import megamek.client.ui.swing.RandomMapDialog;
import megamek.common.Board;
import megamek.common.MapSettings;
import megamek.common.util.BoardUtilities;

public class BoardSelectionDialog
extends JDialog
implements ActionListener,
IMapSettingsObserver,
ListSelectionListener {
    private ClientGUI client;
    private MapSettings mapSettings;
    private RandomMapDialog randomMapDialog;
    private JPanel panMapSize = new JPanel();
    private JLabel labBoardSize = new JLabel(Messages.getString("BoardSelectionDialog.BoardSize"), 4);
    private JLabel labBoardDivider = new JLabel("x", 0);
    private JTextField texBoardWidth = new JTextField(2);
    private JTextField texBoardHeight = new JTextField(2);
    private JLabel labMapSize = new JLabel(Messages.getString("BoardSelectionDialog.MapSize"), 4);
    private JLabel labMapDivider = new JLabel("x", 0);
    private JTextField texMapWidth = new JTextField(2);
    private JTextField texMapHeight = new JTextField(2);
    private JScrollPane scrMapButtons;
    private JPanel panMapButtons = new JPanel();
    private JPanel panBoardsSelected = new JPanel();
    private JLabel labBoardsSelected = new JLabel(Messages.getString("BoardSelectionDialog.MapsSelected"), 0);
    private JList lisBoardsSelected = new JList(new DefaultListModel());
    private JCheckBox chkSelectAll = new JCheckBox(Messages.getString("BoardSelectionDialog.SelectAll"));
    private JButton butChange = new JButton("<<");
    private JPanel panBoardsAvailable = new JPanel();
    private JLabel labBoardsAvailable = new JLabel(Messages.getString("BoardSelectionDialog.mapsAvailable"), 0);
    private JList lisBoardsAvailable = new JList(new DefaultListModel());
    private JCheckBox chkRotateBoard = new JCheckBox(Messages.getString("BoardSelectionDialog.RotateBoard"));
    private JPanel panButtons = new JPanel();
    private JButton butUpdate = new JButton(Messages.getString("BoardSelectionDialog.UpdateSize"));
    private JButton butRandomMap = new JButton(Messages.getString("BoardSelectionDialog.GeneratedMapSettings"));
    private JLabel labButtonSpace = new JLabel("", 0);
    private JButton butOkay = new JButton(Messages.getString("Okay"));
    private JButton butCancel = new JButton(Messages.getString("Cancel"));
    private JButton butPreview = new JButton(Messages.getString("BoardSelectionDialog.Preview"));
    private JDialog mapPreviewW;

    public BoardSelectionDialog(ClientGUI clientGUI) {
        super(clientGUI.frame, Messages.getString("BoardSelectionDialog.EditBoardLaout"), true);
        this.client = clientGUI;
        this.mapSettings = (MapSettings)clientGUI.getClient().getMapSettings().clone();
        this.setResizable(true);
        this.randomMapDialog = new RandomMapDialog(clientGUI.frame, this, this.mapSettings);
        this.setupMapSize();
        this.setupSelected();
        this.setupAvailable();
        this.setupButtons();
        this.butChange.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.panMapSize, gridBagConstraints);
        this.getContentPane().add(this.panMapSize);
        gridBagLayout.setConstraints(this.panBoardsSelected, gridBagConstraints);
        this.getContentPane().add(this.panBoardsSelected);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.butChange, gridBagConstraints);
        this.getContentPane().add(this.butChange);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.panBoardsAvailable, gridBagConstraints);
        this.getContentPane().add(this.panBoardsAvailable);
        gridBagLayout.setConstraints(this.panButtons, gridBagConstraints);
        this.getContentPane().add(this.panButtons);
        this.mapPreviewW = new JDialog(this.client.frame, Messages.getString("BoardSelectionDialog.MapPreview"), false);
        this.mapPreviewW.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BoardSelectionDialog.this.setVisible(false);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BoardSelectionDialog.this.setVisible(false);
                BoardSelectionDialog.this.mapPreviewW.setVisible(false);
            }
        });
        this.pack();
        this.setResizable(false);
        this.setLocation(clientGUI.frame.getLocation().x + clientGUI.frame.getSize().width / 2 - this.getSize().width / 2, clientGUI.frame.getLocation().y + clientGUI.frame.getSize().height / 2 - this.getSize().height / 2);
    }

    private void setupMapSize() {
        this.scrMapButtons = new JScrollPane(this.panMapButtons);
        this.refreshMapSize();
        this.refreshMapButtons();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panMapSize.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.labBoardSize, gridBagConstraints);
        this.panMapSize.add(this.labBoardSize);
        gridBagLayout.setConstraints(this.texBoardWidth, gridBagConstraints);
        this.panMapSize.add(this.texBoardWidth);
        gridBagLayout.setConstraints(this.labBoardDivider, gridBagConstraints);
        this.panMapSize.add(this.labBoardDivider);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.texBoardHeight, gridBagConstraints);
        this.panMapSize.add(this.texBoardHeight);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.labMapSize, gridBagConstraints);
        this.panMapSize.add(this.labMapSize);
        gridBagLayout.setConstraints(this.texMapWidth, gridBagConstraints);
        this.panMapSize.add(this.texMapWidth);
        gridBagLayout.setConstraints(this.labMapDivider, gridBagConstraints);
        this.panMapSize.add(this.labMapDivider);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.texMapHeight, gridBagConstraints);
        this.panMapSize.add(this.texMapHeight);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.scrMapButtons, gridBagConstraints);
        this.panMapSize.add(this.scrMapButtons);
    }

    private void setupSelected() {
        this.refreshBoardsSelected();
        this.lisBoardsSelected.addListSelectionListener(this);
        this.lisBoardsSelected.setSelectionMode(2);
        this.chkSelectAll.addActionListener(this);
        this.panBoardsSelected.setLayout(new BorderLayout());
        this.panBoardsSelected.add((Component)this.labBoardsSelected, "North");
        this.panBoardsSelected.add((Component)new JScrollPane(this.lisBoardsSelected), "Center");
        this.panBoardsSelected.add((Component)this.chkSelectAll, "South");
    }

    private void setupAvailable() {
        this.refreshBoardsAvailable();
        this.lisBoardsAvailable.addListSelectionListener(this);
        this.lisBoardsAvailable.setSelectionMode(2);
        this.panBoardsAvailable.setLayout(new BorderLayout());
        this.panBoardsAvailable.add((Component)this.labBoardsAvailable, "North");
        this.panBoardsAvailable.add((Component)new JScrollPane(this.lisBoardsAvailable), "Center");
        this.panBoardsAvailable.add((Component)this.chkRotateBoard, "South");
    }

    private void setupButtons() {
        this.butUpdate.addActionListener(this);
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        this.butRandomMap.addActionListener(this);
        this.butPreview.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.butUpdate, gridBagConstraints);
        this.panButtons.add(this.butUpdate);
        gridBagLayout.setConstraints(this.butRandomMap, gridBagConstraints);
        this.panButtons.add(this.butRandomMap);
        gridBagLayout.setConstraints(this.butPreview, gridBagConstraints);
        this.panButtons.add(this.butPreview);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.labButtonSpace, gridBagConstraints);
        this.panButtons.add(this.labButtonSpace);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.butOkay, gridBagConstraints);
        this.panButtons.add(this.butOkay);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.butCancel, gridBagConstraints);
        this.panButtons.add(this.butCancel);
    }

    private void refreshMapSize() {
        this.texBoardWidth.setText(Integer.toString(this.mapSettings.getBoardWidth()));
        this.texBoardHeight.setText(Integer.toString(this.mapSettings.getBoardHeight()));
        this.texMapWidth.setText(Integer.toString(this.mapSettings.getMapWidth()));
        this.texMapHeight.setText(Integer.toString(this.mapSettings.getMapHeight()));
    }

    private void refreshMapButtons() {
        this.panMapButtons.removeAll();
        this.panMapButtons.setLayout(new GridLayout(this.mapSettings.getMapHeight(), this.mapSettings.getMapWidth()));
        for (int i = 0; i < this.mapSettings.getMapHeight(); ++i) {
            for (int j = 0; j < this.mapSettings.getMapWidth(); ++j) {
                JButton jButton = new JButton(Integer.toString(i * this.mapSettings.getMapWidth() + j));
                jButton.addActionListener(this);
                this.panMapButtons.add(jButton);
            }
        }
        this.scrMapButtons.validate();
    }

    private void refreshBoardsSelected() {
        ((DefaultListModel)this.lisBoardsSelected.getModel()).removeAllElements();
        int n = 0;
        Enumeration enumeration = this.mapSettings.getBoardsSelected();
        while (enumeration.hasMoreElements()) {
            ((DefaultListModel)this.lisBoardsSelected.getModel()).addElement(n++ + ": " + enumeration.nextElement());
        }
        this.lisBoardsSelected.setSelectedIndex(0);
        this.refreshSelectAllCheck();
    }

    private void refreshSelectAllCheck() {
        boolean bl;
        boolean bl2 = bl = this.lisBoardsSelected.getSelectedIndices().length == this.lisBoardsSelected.getModel().getSize();
        if (this.chkSelectAll.isSelected() != bl) {
            this.chkSelectAll.setSelected(bl);
        }
    }

    private void refreshBoardsAvailable() {
        ((DefaultListModel)this.lisBoardsAvailable.getModel()).removeAllElements();
        Enumeration enumeration = this.mapSettings.getBoardsAvailable();
        while (enumeration.hasMoreElements()) {
            ((DefaultListModel)this.lisBoardsAvailable.getModel()).addElement(enumeration.nextElement());
        }
    }

    private void change(String string) {
        int[] nArray;
        int[] nArray2 = nArray = this.lisBoardsSelected.getSelectedIndices();
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            String string2 = string;
            if (!"[RANDOM]".equals(string2) && !"[SURPRISE]".equals(string2) && this.chkRotateBoard.isSelected()) {
                string2 = "rotate:" + string2;
            }
            ((DefaultListModel)this.lisBoardsSelected.getModel()).setElementAt(n2 + ": " + string2, n2);
            this.mapSettings.getBoardsSelectedVector().setElementAt(string2, n2);
        }
        this.lisBoardsSelected.setSelectedIndices(nArray);
    }

    private void apply() {
        int n;
        int n2;
        int n3;
        int n4;
        try {
            n4 = Integer.parseInt(this.texBoardWidth.getText());
            n3 = Integer.parseInt(this.texBoardHeight.getText());
            n2 = Integer.parseInt(this.texMapWidth.getText());
            n = Integer.parseInt(this.texMapHeight.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.client.frame, Messages.getString("BoardSelectionDialog.InvalidNumberOfmaps"), Messages.getString("BoardSelectionDialog.InvalidMapSize"), 0);
            return;
        }
        if (n3 <= 0 || n3 <= 0 || n2 <= 0 || n <= 0) {
            JOptionPane.showMessageDialog(this.client.frame, Messages.getString("BoardSelectionDialog.MapSizeMustBeGreateter0"), Messages.getString("BoardSelectionDialog.InvalidMapSize"), 0);
            return;
        }
        this.butOkay.setEnabled(false);
        this.mapSettings.setBoardSize(n4, n3);
        this.mapSettings.setMapSize(n2, n);
        this.randomMapDialog.setMapSettings(this.mapSettings);
        this.refreshMapSize();
        this.refreshMapButtons();
        ((DefaultListModel)this.lisBoardsSelected.getModel()).removeAllElements();
        ((DefaultListModel)this.lisBoardsSelected.getModel()).addElement(Messages.getString("BoardSelectionDialog.Updating"));
        ((DefaultListModel)this.lisBoardsAvailable.getModel()).removeAllElements();
        ((DefaultListModel)this.lisBoardsAvailable.getModel()).addElement(Messages.getString("BoardSelectionDialog.Updating"));
        this.client.getClient().sendMapQuery(this.mapSettings);
    }

    public void update(MapSettings mapSettings, boolean bl) {
        this.mapSettings = (MapSettings)mapSettings.clone();
        if (bl) {
            this.refreshMapSize();
            this.refreshMapButtons();
        }
        this.refreshBoardsSelected();
        this.refreshBoardsAvailable();
        this.butOkay.setEnabled(true);
    }

    private void send() {
        if (!(this.texBoardWidth.getText().equals(Integer.toString(this.mapSettings.getBoardWidth())) && this.texBoardHeight.getText().equals(Integer.toString(this.mapSettings.getBoardHeight())) && this.texMapWidth.getText().equals(Integer.toString(this.mapSettings.getMapWidth())) && this.texMapHeight.getText().equals(Integer.toString(this.mapSettings.getMapHeight())))) {
            JOptionPane.showMessageDialog(this.client.frame, Messages.getString("BoardSelectionDialog.UpdateMapSize.message"), Messages.getString("BoardSelectionDialog.UpdateMapSize.title"), 0);
            return;
        }
        if (this.mapSettings.getBoardsAvailableVector().size() <= 0) {
            JOptionPane.showMessageDialog(this.client.frame, Messages.getString("BoardSelectionDialog.NoBoardOfSelectedSize.message"), Messages.getString("BoardSelectionDialog.NoBoardOfSelectedSize.title"), 0);
            return;
        }
        this.client.getClient().sendMapSettings(this.mapSettings);
        this.setVisible(false);
        this.mapPreviewW.setVisible(false);
    }

    public void previewBoard() {
        String string = (String)this.lisBoardsAvailable.getSelectedValue();
        if (this.lisBoardsAvailable.getSelectedIndex() > 2) {
            Board board = new Board(new Integer(this.texBoardWidth.getText()), new Integer(this.texBoardHeight.getText()));
            board.load(string + ".board");
            if (this.chkRotateBoard.isSelected()) {
                BoardUtilities.flip(board, true, true);
            }
            MapPreview mapPreview = null;
            try {
                mapPreview = new MapPreview(this.mapPreviewW, board);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.mapPreviewW.removeAll();
            this.mapPreviewW.add(mapPreview);
            this.mapPreviewW.setVisible(true);
            mapPreview.initializeMap();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.butChange) || actionEvent.getSource().equals(this.lisBoardsAvailable)) {
            if (this.lisBoardsAvailable.getSelectedIndex() != -1) {
                this.change((String)this.lisBoardsAvailable.getSelectedValue());
            }
        } else if (actionEvent.getSource().equals(this.butUpdate)) {
            this.apply();
        } else if (actionEvent.getSource().equals(this.butOkay)) {
            this.send();
        } else if (actionEvent.getSource().equals(this.butCancel)) {
            this.setVisible(false);
        } else if (actionEvent.getSource().equals(this.butRandomMap)) {
            this.randomMapDialog.setVisible(true);
        } else if (actionEvent.getSource().equals(this.butPreview)) {
            this.previewBoard();
        } else if (actionEvent.getSource().equals(this.chkSelectAll)) {
            if (!this.chkSelectAll.isSelected()) {
                this.lisBoardsSelected.setSelectedIndex(0);
                this.refreshSelectAllCheck();
                return;
            }
            int[] nArray = new int[this.lisBoardsSelected.getModel().getSize()];
            for (int i = 0; i < this.lisBoardsSelected.getModel().getSize(); ++i) {
                nArray[i] = i;
            }
            this.lisBoardsSelected.setSelectedIndices(nArray);
        } else {
            try {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                this.lisBoardsSelected.setSelectedIndex(n);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public void updateMapSettings(MapSettings mapSettings) {
        this.mapSettings = mapSettings;
        this.refreshMapSize();
        this.refreshMapButtons();
        ((DefaultListModel)this.lisBoardsSelected.getModel()).removeAllElements();
        ((DefaultListModel)this.lisBoardsSelected.getModel()).addElement(Messages.getString("BoardSelectionDialog.Updating"));
        ((DefaultListModel)this.lisBoardsAvailable.getModel()).removeAllElements();
        ((DefaultListModel)this.lisBoardsAvailable.getModel()).addElement(Messages.getString("BoardSelectionDialog.Updating"));
        this.client.getClient().sendMapQuery(mapSettings);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.lisBoardsSelected)) {
            this.refreshSelectAllCheck();
        }
    }
}

