/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import megamek.client.Client;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListener;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.DoneButtoned;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.SingleChoiceDialog;
import megamek.client.ui.swing.StatusBarPhaseDisplay;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Player;
import megamek.common.event.GameListener;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GameTurnChangeEvent;
import megamek.common.util.Distractable;
import megamek.common.util.DistractableAdapter;

public class DeploymentDisplay
extends StatusBarPhaseDisplay
implements BoardViewListener,
ActionListener,
DoneButtoned,
KeyListener,
GameListener,
Distractable {
    private DistractableAdapter distracted = new DistractableAdapter();
    public static final String DEPLOY_TURN = "deployTurn";
    public static final String DEPLOY_NEXT = "deployNext";
    public static final String DEPLOY_LOAD = "deployLoad";
    public static final String DEPLOY_UNLOAD = "deployUnload";
    public static final String DEPLOY_REMOVE = "deployRemove";
    public static final String DEPLOY_ASSAULTDROP = "assaultDrop";
    public Client client;
    private ClientGUI clientgui;
    private JPanel panButtons;
    private JButton butNext;
    private JButton butTurn;
    private JButton butLoad;
    private JButton butUnload;
    private JButton butRemove;
    private JButton butAssaultDrop;
    private JButton butDone;
    private int cen = -1;
    private boolean turnMode = false;
    private boolean assaultDropPreference = false;

    public DeploymentDisplay(ClientGUI clientGUI) {
        this.clientgui = clientGUI;
        this.client = clientGUI.getClient();
        this.client.game.addGameListener(this);
        clientGUI.getBoardView().addBoardViewListener(this);
        this.setupStatusBar(Messages.getString("DeploymentDisplay.waitingForDeploymentPhase"));
        this.butTurn = new JButton(Messages.getString("DeploymentDisplay.Turn"));
        this.butTurn.addActionListener(this);
        this.butTurn.setActionCommand(DEPLOY_TURN);
        this.butTurn.setEnabled(false);
        this.butLoad = new JButton(Messages.getString("DeploymentDisplay.Load"));
        this.butLoad.addActionListener(this);
        this.butLoad.setActionCommand(DEPLOY_LOAD);
        this.butLoad.setEnabled(false);
        this.butUnload = new JButton(Messages.getString("DeploymentDisplay.Unload"));
        this.butUnload.addActionListener(this);
        this.butUnload.setActionCommand(DEPLOY_UNLOAD);
        this.butUnload.setEnabled(false);
        this.butNext = new JButton(Messages.getString("DeploymentDisplay.NextUnit"));
        this.butNext.addActionListener(this);
        this.butNext.setActionCommand(DEPLOY_NEXT);
        this.butNext.setEnabled(true);
        this.butRemove = new JButton(Messages.getString("DeploymentDisplay.Remove"));
        this.butRemove.addActionListener(this);
        this.butRemove.setActionCommand(DEPLOY_REMOVE);
        this.setRemoveEnabled(true);
        this.butAssaultDrop = new JButton(Messages.getString("DeploymentDisplay.AssaultDropOn"));
        this.butAssaultDrop.addActionListener(this);
        this.butAssaultDrop.setActionCommand(DEPLOY_ASSAULTDROP);
        this.butAssaultDrop.setEnabled(false);
        this.butDone = new JButton(Messages.getString("DeploymentDisplay.Deploy"));
        this.butDone.addActionListener(this);
        this.butDone.setEnabled(false);
        this.panButtons = new JPanel();
        this.panButtons.setLayout(new GridLayout(0, 8));
        this.panButtons.add(this.butNext);
        this.panButtons.add(this.butTurn);
        this.panButtons.add(this.butLoad);
        this.panButtons.add(this.butUnload);
        this.panButtons.add(this.butRemove);
        this.panButtons.add(this.butAssaultDrop);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.panStatus, gridBagLayout, gridBagConstraints);
        clientGUI.bv.addKeyListener(this);
        this.addKeyListener(this);
    }

    private void addBag(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent.addKeyListener(this);
    }

    public void selectEntity(int n) {
        if (this.client.game.getEntity(n) == null) {
            System.err.println("DeploymentDisplay: tried to select non-existant entity: " + n);
            return;
        }
        this.clientgui.bv.clearC3Networks();
        this.cen = n;
        this.clientgui.setSelectedEntityNum(n);
        this.setTurnEnabled(true);
        this.butDone.setEnabled(false);
        this.setLoadEnabled(true);
        this.setUnloadEnabled(true);
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().cursor(null);
        if (null != this.ce()) {
            switch (this.client.getLocalPlayer().getStartingPos()) {
                case 8: {
                    this.ce().setFacing(1);
                    this.ce().setSecondaryFacing(1);
                    break;
                }
                case 7: {
                    this.ce().setFacing(1);
                    this.ce().setSecondaryFacing(1);
                    break;
                }
                case 6: {
                    this.ce().setFacing(0);
                    this.ce().setSecondaryFacing(0);
                    break;
                }
                case 5: {
                    this.ce().setFacing(5);
                    this.ce().setSecondaryFacing(5);
                    break;
                }
                case 4: {
                    this.ce().setFacing(5);
                    this.ce().setSecondaryFacing(5);
                    break;
                }
                case 3: {
                    this.ce().setFacing(4);
                    this.ce().setSecondaryFacing(4);
                    break;
                }
                case 2: {
                    this.ce().setFacing(3);
                    this.ce().setSecondaryFacing(3);
                    break;
                }
                case 1: {
                    this.ce().setFacing(2);
                    this.ce().setSecondaryFacing(2);
                    break;
                }
                case 0: {
                    this.ce().setFacing(0);
                    this.ce().setSecondaryFacing(0);
                }
            }
            this.setAssaultDropEnabled(this.ce().canAssaultDrop() && this.ce().getGame().getOptions().booleanOption("assault_drop"));
            this.clientgui.mechD.displayEntity(this.ce());
            this.clientgui.mechD.showPanel("movement");
            this.clientgui.getMenuBar().setEntity(this.ce());
        }
    }

    private void beginMyTurn() {
        this.clientgui.setDisplayVisible(true);
        this.selectEntity(this.client.getFirstDeployableEntityNum());
        this.setNextEnabled(true);
        Player player = this.client.getLocalPlayer();
        this.clientgui.bv.markDeploymentHexesFor(player);
        this.clientgui.bv.repaint(100L);
    }

    private void endMyTurn() {
        this.disableButtons();
        Entity entity = this.client.game.getNextEntity(this.client.game.getTurnIndex());
        if (4 == this.client.game.getPhase() && null != entity && null != this.ce() && entity.getOwnerId() != this.ce().getOwnerId()) {
            this.clientgui.setDisplayVisible(false);
        }
        this.cen = -1;
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().highlight(null);
        this.clientgui.getBoardView().cursor(null);
        this.clientgui.bv.markDeploymentHexesFor(null);
        this.clientgui.bv.repaint(100L);
    }

    private void disableButtons() {
        this.setTurnEnabled(false);
        this.setNextEnabled(false);
        this.butDone.setEnabled(false);
        this.setLoadEnabled(false);
        this.setUnloadEnabled(false);
    }

    private void deploy() {
        this.disableButtons();
        Entity entity = this.ce();
        this.client.deploy(this.cen, entity.getPosition(), entity.getFacing(), entity.getLoadedUnits(), this.assaultDropPreference);
        entity.setDeployed(true);
    }

    private void remove() {
        this.disableButtons();
        this.client.sendDeleteEntity(this.cen);
        this.beginMyTurn();
    }

    private Entity ce() {
        return this.client.game.getEntity(this.cen);
    }

    public void die() {
        if (this.client.isMyTurn()) {
            this.endMyTurn();
        }
        this.clientgui.bv.markDeploymentHexesFor(null);
        this.client.game.removeGameListener(this);
        this.clientgui.getBoardView().removeBoardViewListener(this);
        this.removeAll();
    }

    public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn()) {
            this.beginMyTurn();
            this.setStatusBarText(Messages.getString("DeploymentDisplay.its_your_turn"));
        } else {
            this.endMyTurn();
            this.setStatusBarText(Messages.getString("DeploymentDisplay.its_others_turn", new Object[]{gameTurnChangeEvent.getPlayer().getName()}));
        }
    }

    public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
        this.clientgui.bv.markDeploymentHexesFor(null);
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.game.getPhase() == 4) {
            this.setStatusBarText(Messages.getString("DeploymentDisplay.waitingForDeploymentPhase"));
        }
    }

    public void hexMoused(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (boardViewEvent.getType() != 2) {
            return;
        }
        if (!this.client.isMyTurn() || this.ce() == null || (boardViewEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if ((boardViewEvent.getModifiers() & 2) != 0 || (boardViewEvent.getModifiers() & 8) != 0) {
            return;
        }
        boolean bl = (boardViewEvent.getModifiers() & 1) != 0;
        Coords coords = boardViewEvent.getCoords();
        if (this.ce().getPosition() != null && (bl || this.turnMode)) {
            this.ce().setFacing(this.ce().getPosition().direction(coords));
            this.ce().setSecondaryFacing(this.ce().getFacing());
            this.clientgui.bv.redrawEntity(this.ce());
            this.turnMode = false;
        } else {
            if (!this.client.game.getBoard().isLegalDeployment(coords, this.ce().getOwner()) && !this.assaultDropPreference || this.ce().isHexProhibited(this.client.game.getBoard().getHex(coords))) {
                JOptionPane.showMessageDialog(this.clientgui.frame, Messages.getString("DeploymentDisplay.cantDeployInto", new Object[]{this.ce().getShortName(), coords.getBoardNum()}), Messages.getString("DeploymentDisplay.alertDialog.title"), 0);
                return;
            }
            if (Compute.stackingViolation(this.client.game, this.ce().getId(), coords) != null) {
                return;
            }
            this.ce().setPosition(coords);
            this.clientgui.bv.redrawEntity(this.ce());
            this.butDone.setEnabled(true);
        }
        this.clientgui.getBoardView().select(coords);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.statusBarActionPerformed(actionEvent, this.client)) {
            return;
        }
        if (!this.client.isMyTurn()) {
            return;
        }
        if (actionEvent.getSource().equals(this.butDone)) {
            this.deploy();
        } else if (actionEvent.getActionCommand().equals(DEPLOY_NEXT)) {
            this.ce().setPosition(null);
            this.clientgui.bv.redrawEntity(this.ce());
            Enumeration enumeration = this.ce().getLoadedUnits().elements();
            while (enumeration.hasMoreElements()) {
                Entity entity = (Entity)enumeration.nextElement();
                this.ce().unload(entity);
                entity.setTransportId(-1);
                entity.newRound(this.client.game.getRoundCount());
            }
            this.selectEntity(this.client.getNextDeployableEntityNum(this.cen));
        } else if (actionEvent.getActionCommand().equals(DEPLOY_TURN)) {
            this.turnMode = true;
        } else if (actionEvent.getActionCommand().equals(DEPLOY_LOAD)) {
            Entity entity;
            Vector<Entity> vector = new Vector<Entity>();
            Enumeration enumeration = this.client.game.getEntities();
            while (enumeration.hasMoreElements()) {
                entity = (Entity)enumeration.nextElement();
                if (!entity.isSelectableThisTurn() || !this.ce().canLoad(entity)) continue;
                vector.addElement(entity);
            }
            if (vector.size() > 0) {
                String[] stringArray = new String[vector.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = ((Entity)vector.elementAt(i)).getShortName();
                }
                SingleChoiceDialog singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, Messages.getString("DeploymentDisplay.loadUnitDialog.title"), Messages.getString("DeploymentDisplay.loadUnitDialog.message", new Object[]{this.ce().getShortName(), this.ce().getUnusedString()}), stringArray);
                singleChoiceDialog.setVisible(true);
                if (singleChoiceDialog.getAnswer()) {
                    entity = (Entity)vector.elementAt(singleChoiceDialog.getChoice());
                    this.ce().load(entity);
                    entity.setTransportId(this.cen);
                    this.clientgui.mechD.displayEntity(this.ce());
                }
            } else {
                JOptionPane.showMessageDialog(this.clientgui.frame, Messages.getString("DeploymentDisplay.allertDialog1.message", new Object[]{this.ce().getShortName()}), Messages.getString("DeploymentDisplay.allertDialog1.title"), 0);
            }
        } else if (actionEvent.getActionCommand().equals(DEPLOY_UNLOAD)) {
            Vector vector = this.ce().getLoadedUnits();
            if (vector.size() > 0) {
                Entity entity = null;
                String[] stringArray = new String[vector.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = ((Entity)vector.elementAt(i)).getShortName();
                }
                SingleChoiceDialog singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, Messages.getString("DeploymentDisplay.unloadUnitDialog.title"), Messages.getString("DeploymentDisplay.unloadUnitDialog.message", new Object[]{this.ce().getShortName(), this.ce().getUnusedString()}), stringArray);
                singleChoiceDialog.setVisible(true);
                if (singleChoiceDialog.getAnswer()) {
                    entity = (Entity)vector.elementAt(singleChoiceDialog.getChoice());
                    if (this.ce().unload(entity)) {
                        entity.setTransportId(-1);
                        entity.newRound(this.client.game.getRoundCount());
                        this.clientgui.mechD.displayEntity(this.ce());
                    } else {
                        System.out.println("Could not unload " + entity.getShortName() + " from " + this.ce().getShortName());
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this.clientgui.frame, Messages.getString("DeploymentDisplay.allertDialog2.message", new Object[]{this.ce().getShortName()}), Messages.getString("DeploymentDisplay.allertDialog2.title"), 0);
            }
        } else if (actionEvent.getActionCommand().equals(DEPLOY_REMOVE)) {
            this.remove();
        } else if (actionEvent.getActionCommand().equals(DEPLOY_ASSAULTDROP)) {
            boolean bl = this.assaultDropPreference = !this.assaultDropPreference;
            if (this.assaultDropPreference) {
                this.butAssaultDrop.setText(Messages.getString("DeploymentDisplay.AssaultDropOff"));
            } else {
                this.butAssaultDrop.setText(Messages.getString("DeploymentDisplay.AssaultDropOn"));
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void finishedMovingUnits(BoardViewEvent boardViewEvent) {
    }

    public void unitSelected(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        Entity entity = this.client.game.getEntity(boardViewEvent.getEntityId());
        if (null == entity) {
            return;
        }
        if (this.client.isMyTurn()) {
            if (this.client.game.getTurn().isValidEntity(entity, this.client.game)) {
                if (this.ce() != null) {
                    this.ce().setPosition(null);
                    this.clientgui.bv.redrawEntity(this.ce());
                    Enumeration enumeration = this.ce().getLoadedUnits().elements();
                    while (enumeration.hasMoreElements()) {
                        Entity entity2 = (Entity)enumeration.nextElement();
                        this.ce().unload(entity2);
                        entity2.setTransportId(-1);
                        entity2.newRound(this.client.game.getRoundCount());
                    }
                }
                this.selectEntity(entity.getId());
                if (null != entity.getPosition()) {
                    this.clientgui.bv.centerOnHex(entity.getPosition());
                }
            }
        } else {
            this.clientgui.setDisplayVisible(true);
            this.clientgui.mechD.displayEntity(entity);
            if (entity.isDeployed()) {
                this.clientgui.bv.centerOnHex(entity.getPosition());
            }
        }
    }

    private void setNextEnabled(boolean bl) {
        this.butNext.setEnabled(bl);
        this.clientgui.getMenuBar().setDeployNextEnabled(bl);
    }

    private void setTurnEnabled(boolean bl) {
        this.butTurn.setEnabled(bl);
        this.clientgui.getMenuBar().setDeployTurnEnabled(bl);
    }

    private void setLoadEnabled(boolean bl) {
        this.butLoad.setEnabled(bl);
        this.clientgui.getMenuBar().setDeployLoadEnabled(bl);
    }

    private void setUnloadEnabled(boolean bl) {
        this.butUnload.setEnabled(bl);
        this.clientgui.getMenuBar().setDeployUnloadEnabled(bl);
    }

    private void setRemoveEnabled(boolean bl) {
        this.butRemove.setEnabled(bl);
        this.clientgui.getMenuBar().setDeployNextEnabled(bl);
    }

    private void setAssaultDropEnabled(boolean bl) {
        this.butAssaultDrop.setEnabled(bl);
        this.clientgui.getMenuBar().setDeployAssaultDropEnabled(bl);
    }

    public boolean isIgnoringEvents() {
        return this.distracted.isIgnoringEvents();
    }

    public void setIgnoringEvents(boolean bl) {
        this.distracted.setIgnoringEvents(bl);
    }

    public JButton getDoneButton() {
        return this.butDone;
    }

    public void removeAllListeners() {
        this.die();
    }
}

