/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Image;
import java.awt.MediaTracker;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.swing.JComponent;
import megamek.client.ui.swing.util.ImageCache;
import megamek.common.Hex;
import megamek.common.IHex;
import megamek.common.ITerrain;
import megamek.common.Terrains;
import megamek.common.util.StringUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HexTileset {
    private ArrayList bases = new ArrayList();
    private ArrayList supers = new ArrayList();
    private ImageCache<IHex, Image> hexToImageCache = new ImageCache();
    private ImageCache<IHex, List<Image>> hexToImageListCache = new ImageCache();

    public synchronized void clearHex(IHex iHex) {
        this.hexToImageCache.remove(iHex);
    }

    public synchronized Object[] assignMatch(IHex iHex, JComponent jComponent) {
        IHex iHex2 = iHex.duplicate();
        List list = this.supersFor(iHex2, jComponent);
        Image image = this.baseFor(iHex2, jComponent);
        Object[] objectArray = new Object[]{image, list};
        this.hexToImageCache.put(iHex, image);
        this.hexToImageListCache.put(iHex, list);
        return objectArray;
    }

    public synchronized Image getBase(IHex iHex, JComponent jComponent) {
        Image image = this.hexToImageCache.get(iHex);
        if (image == null) {
            Object[] objectArray = this.assignMatch(iHex, jComponent);
            return (Image)objectArray[0];
        }
        return image;
    }

    public synchronized List<Image> getSupers(IHex iHex, JComponent jComponent) {
        List<Image> list = this.hexToImageListCache.get(iHex);
        if (list == null) {
            Object[] objectArray = this.assignMatch(iHex, jComponent);
            return (List)objectArray[1];
        }
        return list;
    }

    private List supersFor(IHex iHex, JComponent jComponent) {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        for (HexEntry hexEntry : this.supers) {
            if (!(this.superMatch(iHex, hexEntry.getHex()) >= 1.0)) continue;
            arrayList.add(hexEntry.getImage(jComponent));
            for (int i = 0; i < Terrains.SIZE; ++i) {
                if (!hexEntry.getHex().containsTerrain(i)) continue;
                iHex.removeTerrain(i);
            }
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    private Image baseFor(IHex iHex, JComponent jComponent) {
        HexEntry hexEntry = null;
        double d = -1.0;
        for (HexEntry hexEntry2 : this.bases) {
            double d2 = this.baseMatch(iHex, hexEntry2.getHex());
            if (d2 == 1.0) {
                hexEntry = hexEntry2;
                break;
            }
            if (!(d2 > d)) continue;
            hexEntry = hexEntry2;
            d = d2;
        }
        return hexEntry.getImage(jComponent);
    }

    public void loadFromFile(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(new StringBuffer().append("data/images/hexes/").append(string).toString()));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        streamTokenizer.quoteChar(34);
        streamTokenizer.wordChars(95, 95);
        while (streamTokenizer.nextToken() != -1) {
            int n = 0;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equals("base") && !streamTokenizer.sval.equals("super")) continue;
            boolean bl = streamTokenizer.sval.equals("base");
            n = streamTokenizer.nextToken() == -2 ? (int)streamTokenizer.nval : Integer.MAX_VALUE;
            streamTokenizer.nextToken();
            string2 = streamTokenizer.sval;
            streamTokenizer.nextToken();
            string3 = streamTokenizer.sval;
            streamTokenizer.nextToken();
            string4 = streamTokenizer.sval;
            if (bl) {
                this.bases.add(new HexEntry(new Hex(n, string2, string3), string4));
                continue;
            }
            this.supers.add(new HexEntry(new Hex(n, string2, string3), string4));
        }
        ((Reader)bufferedReader).close();
        System.out.println(new StringBuffer().append("hexTileset: loaded ").append(this.bases.size()).append(" base images").toString());
        System.out.println(new StringBuffer().append("hexTileset: loaded ").append(this.supers.size()).append(" super images").toString());
    }

    public void loadAllImages(JComponent jComponent, MediaTracker mediaTracker) {
        for (HexEntry hexEntry : this.bases) {
            if (hexEntry.getImage() == null) {
                hexEntry.loadImage(jComponent);
            }
            mediaTracker.addImage(hexEntry.getImage(), 1);
        }
        for (HexEntry hexEntry : this.supers) {
            if (hexEntry.getImage() == null) {
                hexEntry.loadImage(jComponent);
            }
            mediaTracker.addImage(hexEntry.getImage(), 1);
        }
    }

    public synchronized void trackHexImages(IHex iHex, MediaTracker mediaTracker) {
        Image image = this.hexToImageCache.get(iHex);
        List<Image> list = this.hexToImageListCache.get(iHex);
        mediaTracker.addImage(image, 1);
        if (list != null) {
            Iterator<Image> iterator = list.iterator();
            while (iterator.hasNext()) {
                mediaTracker.addImage(iterator.next(), 1);
            }
        }
    }

    public void loadHexImage(IHex iHex, JComponent jComponent, MediaTracker mediaTracker) {
    }

    public synchronized void reset() {
        this.hexToImageCache = new ImageCache();
        this.hexToImageListCache = new ImageCache();
    }

    private double superMatch(IHex iHex, IHex iHex2) {
        if (iHex2.getElevation() != Integer.MAX_VALUE && iHex.getElevation() != iHex2.getElevation()) {
            return 0.0;
        }
        for (int i = 0; i < Terrains.SIZE; ++i) {
            ITerrain iTerrain = iHex2.getTerrain(i);
            ITerrain iTerrain2 = iHex.getTerrain(i);
            if (iTerrain == null || iTerrain2 != null && (iTerrain.getLevel() == Integer.MAX_VALUE || iTerrain2.getLevel() == iTerrain.getLevel()) && (!iTerrain.hasExitsSpecified() || iTerrain2.getExits() == iTerrain.getExits())) continue;
            return 0.0;
        }
        if (iHex2.getTheme() != null && !iHex2.getTheme().equalsIgnoreCase(iHex.getTheme())) {
            return 0.0;
        }
        return 1.0;
    }

    private double baseMatch(IHex iHex, IHex iHex2) {
        double d = iHex2.getElevation() == Integer.MAX_VALUE ? 1.0 : 1.01 / ((double)Math.abs(iHex.getElevation() - iHex2.getElevation()) + 1.01);
        double d2 = Math.max(iHex.terrainsPresent(), iHex2.terrainsPresent());
        double d3 = 0.0;
        for (int i = 0; i < Terrains.SIZE; ++i) {
            ITerrain iTerrain = iHex2.getTerrain(i);
            ITerrain iTerrain2 = iHex.getTerrain(i);
            if (iTerrain == null || iTerrain2 == null) continue;
            double d4 = 0.0;
            d4 = iTerrain.getLevel() == Integer.MAX_VALUE ? 1.0 : 1.0 / ((double)Math.abs(iTerrain2.getLevel() - iTerrain.getLevel()) + 1.0);
            if (iTerrain.hasExitsSpecified() && iTerrain2.getExits() != iTerrain.getExits()) {
                d4 *= 0.5;
            }
            d3 += d4;
        }
        double d5 = d2 == 0.0 ? 1.0 : d3 / d2;
        double d6 = iHex2.getTheme() == iHex.getTheme() || iHex2.getTheme() != null && iHex2.getTheme().equalsIgnoreCase(iHex.getTheme()) ? 1.0 : 1.0E-4;
        return d * d5 * d6;
    }

    private class HexEntry {
        private IHex hex;
        private String imageFile;
        private Image image;
        private Vector images;
        private Vector filenames;
        private Random r;

        public HexEntry(IHex iHex, String string) {
            this.hex = iHex;
            this.imageFile = string;
            this.r = new Random();
            this.filenames = StringUtil.splitString(string, ";");
        }

        public IHex getHex() {
            return this.hex;
        }

        public Image getImage() {
            return this.image;
        }

        public String getImageFileName() {
            return "data/images/hexes/" + this.imageFile;
        }

        public Image getImage(JComponent jComponent) {
            if (this.images == null) {
                this.loadImage(jComponent);
            }
            if (this.images.size() > 1) {
                int n = (int)(this.r.nextDouble() * (double)this.images.size());
                return (Image)this.images.elementAt(n);
            }
            return (Image)this.images.firstElement();
        }

        public void loadImage(JComponent jComponent) {
            this.images = new Vector();
            for (int i = 0; i < this.filenames.size(); ++i) {
                String string = (String)this.filenames.elementAt(i);
                this.images.addElement(jComponent.getToolkit().getImage("data/images/hexes/" + string));
            }
        }
    }
}

