/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;
import megamek.common.IBoard;
import megamek.common.IHex;
import megamek.common.Terrains;

public class MapPreview
extends Canvas {
    private static final Color[] m_terrainColors = new Color[Terrains.SIZE];
    private static Color HEAVY_WOODS;
    private static Color BACKGROUND;
    private static Color SINKHOLE;
    private static Color SMOKE_AND_FIRE;
    private static final int SHOW_NO_HEIGHT = 0;
    private static final int SHOW_GROUND_HEIGHT = 1;
    private static final int SHOW_BUILDING_HEIGHT = 2;
    private static final int SHOW_TOTAL_HEIGHT = 3;
    private static final int NBR_MODES = 3;
    private Image m_mapImage;
    private Dialog m_dialog;
    private IBoard m_board;
    private static final int margin = 6;
    private int topMargin;
    private int leftMargin;
    private static final int buttonHeight = 14;
    private boolean minimized = false;
    private int heightBufer;
    private Vector roadHexIndexes = new Vector();
    private int zoom = GUIPreferences.getInstance().getMinimapZoom();
    private int[] hexSide = new int[]{3, 5, 6, 8, 10, 12};
    private int[] hexSideByCos30 = new int[]{3, 4, 5, 7, 9, 10};
    private int[] hexSideBySin30 = new int[]{2, 2, 3, 4, 5, 6};
    private int[] halfRoadWidthByCos30 = new int[]{0, 0, 1, 2, 2, 3};
    private int[] halfRoadWidthBySin30 = new int[]{0, 0, 1, 1, 1, 2};
    private int[] halfRoadWidth = new int[]{0, 0, 1, 2, 3, 3};
    private int heightDisplayMode = 0;
    private ClientGUI clientgui;

    public MapPreview(Dialog dialog, IBoard iBoard) throws IOException {
        this.m_board = iBoard;
        this.m_dialog = dialog;
        this.initializeColors();
        this.m_dialog.setResizable(false);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MapPreview.this.processMouseClick(mouseEvent.getX(), mouseEvent.getY(), mouseEvent);
            }
        });
        Dimension dimension = this.getSize();
        boolean bl = false;
        if (dimension.width < GUIPreferences.getInstance().getMinimumSizeWidth()) {
            dimension.width = GUIPreferences.getInstance().getMinimumSizeWidth();
            bl = true;
        }
        if (dimension.height < GUIPreferences.getInstance().getMinimumSizeHeight()) {
            dimension.height = GUIPreferences.getInstance().getMinimumSizeHeight();
            bl = true;
        }
        if (bl) {
            this.setSize(dimension);
        }
        this.setLocation(GUIPreferences.getInstance().getMinimapPosX(), GUIPreferences.getInstance().getMinimapPosY());
    }

    /*
     * Unable to fully structure code
     */
    private void initializeColors() throws IOException {
        MapPreview.BACKGROUND = Color.black;
        MapPreview.m_terrainColors[0] = new Color(218, 215, 170);
        MapPreview.SINKHOLE = new Color(218, 215, 170);
        MapPreview.m_terrainColors[1] = new Color(180, 230, 130);
        MapPreview.HEAVY_WOODS = new Color(160, 200, 100);
        MapPreview.m_terrainColors[2] = new Color(215, 181, 0);
        MapPreview.m_terrainColors[3] = new Color(200, 200, 200);
        MapPreview.m_terrainColors[4] = new Color(200, 247, 253);
        MapPreview.m_terrainColors[5] = new Color(204, 204, 204);
        MapPreview.m_terrainColors[6] = new Color(71, 79, 107);
        MapPreview.m_terrainColors[7] = Color.red;
        MapPreview.m_terrainColors[8] = new Color(204, 204, 204);
        MapPreview.SMOKE_AND_FIRE = new Color(153, 0, 0);
        MapPreview.m_terrainColors[9] = new Color(49, 136, 74);
        MapPreview.m_terrainColors[10] = new Color(204, 204, 204);
        MapPreview.m_terrainColors[14] = new Color(109, 55, 25);
        MapPreview.m_terrainColors[20] = new Color(204, 204, 255);
        MapPreview.m_terrainColors[24] = new Color(200, 0, 0);
        MapPreview.m_terrainColors[25] = new Color(218, 160, 100);
        MapPreview.m_terrainColors[23] = new Color(180, 230, 130);
        var4_1 = new File("data/images/hexes/" + GUIPreferences.getInstance().getMinimapColours());
        if (!var4_1.exists()) {
            return;
        }
        var5_2 = new FileReader(var4_1);
        var6_3 = new StreamTokenizer(var5_2);
        var6_3.lowerCaseMode(true);
        var6_3.quoteChar(34);
        var6_3.commentChar(35);
        block5: while (true) {
            var1_4 = 0;
            var2_5 = 0;
            var3_6 = 0;
            switch (var6_3.nextToken()) {
                case -1: {
                    break block5;
                }
                case 10: {
                    break block5;
                }
                case -3: {
                    var7_7 = var6_3.sval;
                    if (!var7_7.equals("unitsize")) ** GOTO lbl44
                    var6_3.nextToken();
                    ** GOTO lbl102
lbl44:
                    // 1 sources

                    if (!var7_7.equals("background")) ** GOTO lbl56
                    var6_3.nextToken();
                    var1_4 = (int)var6_3.nval;
                    var6_3.nextToken();
                    var2_5 = (int)var6_3.nval;
                    var6_3.nextToken();
                    var3_6 = (int)var6_3.nval;
                    MapPreview.BACKGROUND = new Color(var1_4, var2_5, var3_6);
                    ** GOTO lbl102
lbl56:
                    // 1 sources

                    if (!var7_7.equals("heavywoods")) ** GOTO lbl68
                    var6_3.nextToken();
                    var1_4 = (int)var6_3.nval;
                    var6_3.nextToken();
                    var2_5 = (int)var6_3.nval;
                    var6_3.nextToken();
                    var3_6 = (int)var6_3.nval;
                    MapPreview.HEAVY_WOODS = new Color(var1_4, var2_5, var3_6);
                    ** GOTO lbl102
lbl68:
                    // 1 sources

                    if (!var7_7.equals("sinkhole")) ** GOTO lbl80
                    var6_3.nextToken();
                    var1_4 = (int)var6_3.nval;
                    var6_3.nextToken();
                    var2_5 = (int)var6_3.nval;
                    var6_3.nextToken();
                    var3_6 = (int)var6_3.nval;
                    MapPreview.SINKHOLE = new Color(var1_4, var2_5, var3_6);
                    ** GOTO lbl102
lbl80:
                    // 1 sources

                    if (var7_7.equals("smokeandfire")) {
                        var6_3.nextToken();
                        var1_4 = (int)var6_3.nval;
                        var6_3.nextToken();
                        var2_5 = (int)var6_3.nval;
                        var6_3.nextToken();
                        var3_6 = (int)var6_3.nval;
                        MapPreview.SMOKE_AND_FIRE = new Color(var1_4, var2_5, var3_6);
                    } else {
                        var6_3.nextToken();
                        var1_4 = (int)var6_3.nval;
                        var6_3.nextToken();
                        var2_5 = (int)var6_3.nval;
                        var6_3.nextToken();
                        var3_6 = (int)var6_3.nval;
                        MapPreview.m_terrainColors[Terrains.getType((String)var7_7)] = new Color(var1_4, var2_5, var3_6);
                    }
                }
lbl102:
                // 7 sources

                default: {
                    continue block5;
                }
            }
            break;
        }
        var5_2.close();
    }

    public void initializeMap() {
        if (this.zoom < 0) {
            this.zoom = 0;
        } else if (this.zoom > this.hexSide.length - 1) {
            this.zoom = this.hexSide.length - 1;
        }
        int n = this.hexSide[this.zoom];
        int n2 = this.hexSideByCos30[this.zoom];
        int n3 = this.hexSideBySin30[this.zoom];
        this.topMargin = 6;
        this.leftMargin = 6;
        int n4 = this.m_board.getWidth() * (n + n3) + n3 + 12;
        int n5 = (2 * this.m_board.getHeight() + 1) * n2 + 12 + 14;
        this.setSize(n4, n5);
        this.m_dialog.pack();
        this.m_mapImage = this.createImage(this.getSize().width, this.getSize().height);
        if (this.getSize().width > n4) {
            this.leftMargin = (this.getSize().width - n4) / 2 + 6;
        }
        if (this.getSize().height > n5) {
            this.topMargin = (this.getSize().height - n5) / 2 + 6;
        }
        this.drawMap();
    }

    public synchronized void drawMap() {
        IHex iHex;
        int n;
        int n2;
        if (this.m_mapImage == null) {
            return;
        }
        if (!this.m_dialog.isVisible()) {
            return;
        }
        Graphics graphics = this.m_mapImage.getGraphics();
        Color color = graphics.getColor();
        graphics.setColor(BACKGROUND);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(color);
        this.roadHexIndexes.removeAllElements();
        for (n2 = 0; n2 < this.m_board.getWidth(); ++n2) {
            for (n = 0; n < this.m_board.getHeight(); ++n) {
                iHex = this.m_board.getHex(n2, n);
                graphics.setColor(this.terrainColor(iHex, n2, n));
                this.paintCoord(graphics, n2, n, true);
            }
        }
        if (!this.roadHexIndexes.isEmpty()) {
            this.paintRoads(graphics);
        }
        if (0 != this.heightDisplayMode) {
            for (n2 = 0; n2 < this.m_board.getWidth(); ++n2) {
                for (n = 0; n < this.m_board.getHeight(); ++n) {
                    iHex = this.m_board.getHex(n2, n);
                    this.paintHeight(graphics, iHex, n2, n);
                }
            }
        }
        this.drawBtn(graphics);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.m_mapImage != null) {
            graphics.drawImage(this.m_mapImage, 0, 0, this);
        }
    }

    private void paintHeight(Graphics graphics, IHex iHex, int n, int n2) {
        if (this.heightDisplayMode == 0) {
            return;
        }
        if (this.zoom > 2) {
            int n3 = n * (this.hexSide[this.zoom] + this.hexSideBySin30[this.zoom]) + this.leftMargin;
            int n4 = (2 * n2 + 1 + n % 2) * this.hexSideByCos30[this.zoom] + this.topMargin;
            graphics.setColor(Color.white);
            int n5 = 0;
            if (iHex.getTerrain(10) != null && this.heightDisplayMode == 2) {
                n5 = iHex.ceiling();
            } else if (this.heightDisplayMode == 1) {
                n5 = iHex.floor();
            } else if (this.heightDisplayMode == 3) {
                int n6 = n5 = iHex.getTerrain(10) != null || iHex.getTerrain(32) != null ? iHex.ceiling() : iHex.floor();
            }
            if (n5 != 0) {
                graphics.drawString(n5 + "", n3 + 5, n4 + 5);
            }
        }
    }

    private void paintCoord(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = n * (this.hexSide[this.zoom] + this.hexSideBySin30[this.zoom]) + this.leftMargin;
        int n4 = (2 * n2 + 1 + n % 2) * this.hexSideByCos30[this.zoom] + this.topMargin;
        int[] nArray = new int[6];
        int[] nArray2 = new int[6];
        nArray[0] = n3;
        nArray2[0] = n4;
        nArray[1] = n3 + this.hexSideBySin30[this.zoom];
        nArray2[1] = n4 + this.hexSideByCos30[this.zoom];
        nArray[2] = nArray[1] + this.hexSide[this.zoom];
        nArray2[2] = nArray2[1];
        nArray[3] = nArray[2] + this.hexSideBySin30[this.zoom];
        nArray2[3] = n4;
        nArray[4] = nArray[2];
        nArray2[4] = n4 - this.hexSideByCos30[this.zoom];
        nArray[5] = nArray[1];
        nArray2[5] = nArray2[4];
        graphics.fillPolygon(nArray, nArray2, 6);
        if (bl) {
            Color color = graphics.getColor();
            graphics.setColor(color.darker());
            graphics.drawPolygon(nArray, nArray2, 6);
            graphics.setColor(color);
        }
    }

    private void paintRoads(Graphics graphics) {
        int n = 0;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        Color color = graphics.getColor();
        graphics.setColor(m_terrainColors[6]);
        Enumeration enumeration = this.roadHexIndexes.elements();
        while (enumeration.hasMoreElements()) {
            int[] nArray3 = (int[])enumeration.nextElement();
            int n2 = nArray3[0];
            int n3 = nArray3[1];
            int n4 = n2 * (this.hexSide[this.zoom] + this.hexSideBySin30[this.zoom]) + this.leftMargin + this.hexSide[this.zoom];
            int n5 = (2 * n3 + 1 + n2 % 2) * this.hexSideByCos30[this.zoom] + this.topMargin;
            n = nArray3[2];
            if (0 != (n & 1)) {
                nArray[0] = n4 - this.halfRoadWidth[this.zoom];
                nArray2[0] = n5;
                nArray[1] = n4 - this.halfRoadWidth[this.zoom];
                nArray2[1] = n5 - this.hexSideByCos30[this.zoom];
                nArray[2] = n4 + this.halfRoadWidth[this.zoom];
                nArray2[2] = n5 - this.hexSideByCos30[this.zoom];
                nArray[3] = n4 + this.halfRoadWidth[this.zoom];
                nArray2[3] = n5;
                graphics.drawPolygon(nArray, nArray2, 4);
                graphics.fillPolygon(nArray, nArray2, 4);
            }
            if (0 != (n & 2)) {
                nArray[0] = n4 - this.halfRoadWidthBySin30[this.zoom];
                nArray2[0] = n5 - this.halfRoadWidthByCos30[this.zoom];
                nArray[1] = Math.round(n4 + 3 * this.hexSide[this.zoom] / 4 - this.halfRoadWidthBySin30[this.zoom]);
                nArray2[1] = Math.round(n5 - this.hexSideByCos30[this.zoom] / 2 - this.halfRoadWidthByCos30[this.zoom]);
                nArray[2] = nArray[1] + 2 * this.halfRoadWidthBySin30[this.zoom];
                nArray2[2] = nArray2[1] + 2 * this.halfRoadWidthByCos30[this.zoom];
                nArray[3] = n4 + this.halfRoadWidthBySin30[this.zoom];
                nArray2[3] = n5 + this.halfRoadWidthByCos30[this.zoom];
                graphics.drawPolygon(nArray, nArray2, 4);
                graphics.fillPolygon(nArray, nArray2, 4);
            }
            if (0 != (n & 4)) {
                nArray[0] = n4 + this.halfRoadWidthBySin30[this.zoom];
                nArray2[0] = n5 - this.halfRoadWidthByCos30[this.zoom];
                nArray[1] = Math.round(n4 + 3 * this.hexSide[this.zoom] / 4 + this.halfRoadWidthBySin30[this.zoom]);
                nArray2[1] = Math.round(n5 + this.hexSideByCos30[this.zoom] / 2 - this.halfRoadWidthByCos30[this.zoom]);
                nArray[2] = nArray[1] - 2 * this.halfRoadWidthBySin30[this.zoom];
                nArray2[2] = nArray2[1] + 2 * this.halfRoadWidthByCos30[this.zoom];
                nArray[3] = n4 - this.halfRoadWidthBySin30[this.zoom];
                nArray2[3] = n5 + this.halfRoadWidthByCos30[this.zoom];
                graphics.drawPolygon(nArray, nArray2, 4);
                graphics.fillPolygon(nArray, nArray2, 4);
            }
            if (0 != (n & 8)) {
                nArray[0] = n4 + this.halfRoadWidth[this.zoom];
                nArray2[0] = n5;
                nArray[1] = n4 + this.halfRoadWidth[this.zoom];
                nArray2[1] = n5 + this.hexSideByCos30[this.zoom];
                nArray[2] = n4 - this.halfRoadWidth[this.zoom];
                nArray2[2] = n5 + this.hexSideByCos30[this.zoom];
                nArray[3] = n4 - this.halfRoadWidth[this.zoom];
                nArray2[3] = n5;
                graphics.drawPolygon(nArray, nArray2, 4);
                graphics.fillPolygon(nArray, nArray2, 4);
            }
            if (0 != (n & 0x10)) {
                nArray[0] = n4 + this.halfRoadWidthBySin30[this.zoom];
                nArray2[0] = n5 + this.halfRoadWidthByCos30[this.zoom];
                nArray[1] = Math.round(n4 - 3 * this.hexSide[this.zoom] / 4 + this.halfRoadWidthBySin30[this.zoom]);
                nArray2[1] = Math.round(n5 + this.hexSideByCos30[this.zoom] / 2 + this.halfRoadWidthByCos30[this.zoom]);
                nArray[2] = nArray[1] - 2 * this.halfRoadWidthBySin30[this.zoom];
                nArray2[2] = nArray2[1] - 2 * this.halfRoadWidthByCos30[this.zoom];
                nArray[3] = n4 - this.halfRoadWidthBySin30[this.zoom];
                nArray2[3] = n5 - this.halfRoadWidthByCos30[this.zoom];
                graphics.drawPolygon(nArray, nArray2, 4);
                graphics.fillPolygon(nArray, nArray2, 4);
            }
            if (0 == (n & 0x20)) continue;
            nArray[0] = n4 - this.halfRoadWidthBySin30[this.zoom];
            nArray2[0] = n5 + this.halfRoadWidthByCos30[this.zoom];
            nArray[1] = Math.round(n4 - 3 * this.hexSide[this.zoom] / 4 - this.halfRoadWidthBySin30[this.zoom]);
            nArray2[1] = Math.round(n5 - this.hexSideByCos30[this.zoom] / 2 + this.halfRoadWidthByCos30[this.zoom]);
            nArray[2] = nArray[1] + 2 * this.halfRoadWidthBySin30[this.zoom];
            nArray2[2] = nArray2[1] - 2 * this.halfRoadWidthByCos30[this.zoom];
            nArray[3] = n4 + this.halfRoadWidthBySin30[this.zoom];
            nArray2[3] = n5 - this.halfRoadWidthByCos30[this.zoom];
            graphics.drawPolygon(nArray, nArray2, 4);
            graphics.fillPolygon(nArray, nArray2, 4);
        }
        graphics.setColor(color);
    }

    private Color terrainColor(IHex iHex, int n, int n2) {
        int n3;
        Color color = m_terrainColors[0];
        if (iHex.getElevation() < 0) {
            color = SINKHOLE;
        }
        int n4 = 0;
        int n5 = 0;
        for (n3 = m_terrainColors.length - 1; n3 >= 0; --n3) {
            if (iHex.getTerrain(n3) == null || m_terrainColors[n3] == null) continue;
            if (n3 == 6 || n3 == 14) {
                int[] nArray = new int[]{n, n2, iHex.getTerrain(n3).getExits()};
                this.roadHexIndexes.addElement(nArray);
                continue;
            }
            color = m_terrainColors[n3];
            n5 = n3;
            if ((n3 == 1 || n3 == 23) && iHex.getTerrain(n3).getLevel() > 1) {
                color = HEAVY_WOODS;
            }
            if (n3 != 8 || iHex.getTerrain(7) == null) break;
            color = SMOKE_AND_FIRE;
            break;
        }
        switch (n5) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 20: 
            case 23: {
                n4 = Math.abs(iHex.floor());
                if (n4 > 10) {
                    n4 = 10;
                }
                n3 = color.getRed() - n4 * 15;
                int n6 = color.getGreen() - n4 * 15;
                int n7 = color.getBlue() - n4 * 15;
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n7 < 0) {
                    n7 = 0;
                }
                return new Color(n3, n6, n7);
            }
            case 10: 
            case 32: {
                n4 = Math.abs(iHex.ceiling());
                if (n4 > 10) {
                    n4 = 10;
                }
                n3 = color.getRed() - n4 * 15;
                int n8 = color.getGreen() - n4 * 15;
                int n9 = color.getBlue() - n4 * 15;
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n8 < 0) {
                    n8 = 0;
                }
                if (n9 < 0) {
                    n9 = 0;
                }
                return new Color(n3, n8, n9);
            }
        }
        return color;
    }

    private void drawBtn(Graphics graphics) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        Color color = graphics.getColor();
        if (this.minimized) {
            nArray[0] = Math.round((this.getSize().width - 11) / 2);
            nArray2[0] = this.getSize().height - 10;
            nArray[1] = nArray[0] + 11;
            nArray2[1] = nArray2[0];
            nArray[2] = nArray[0] + 6;
            nArray2[2] = nArray2[0] + 5;
        } else {
            nArray[0] = Math.round((this.getSize().width - 11) / 2);
            nArray2[0] = this.getSize().height - 4;
            nArray[1] = nArray[0] + 11;
            nArray2[1] = nArray2[0];
            nArray[2] = nArray[0] + 5;
            nArray2[2] = nArray2[0] - 5;
        }
        graphics.setColor(Color.green.darker().darker());
        graphics.fillRect(0, this.getSize().height - 14, this.getSize().width, 14);
        graphics.setColor(Color.green.darker());
        graphics.drawLine(0, this.getSize().height - 14, this.getSize().width, this.getSize().height - 14);
        graphics.drawLine(0, this.getSize().height - 14, 0, this.getSize().height);
        graphics.setColor(Color.black);
        graphics.drawLine(0, this.getSize().height - 1, this.getSize().width, this.getSize().height - 1);
        graphics.drawLine(this.getSize().width - 1, this.getSize().height - 14, this.getSize().width - 1, this.getSize().height);
        graphics.setColor(Color.yellow);
        graphics.fillPolygon(nArray, nArray2, 3);
        if (!this.minimized) {
            graphics.setColor(Color.black);
            graphics.drawLine(13, this.getSize().height - 14, 13, this.getSize().height);
            graphics.drawLine(this.getSize().width - 14 - 1, this.getSize().height - 14, this.getSize().width - 14 - 1, this.getSize().height);
            graphics.setColor(Color.green.darker());
            graphics.drawLine(14, this.getSize().height - 14, 14, this.getSize().height);
            graphics.drawLine(this.getSize().width - 14, this.getSize().height - 14, this.getSize().width - 14, this.getSize().height);
            if (this.zoom == 0) {
                graphics.setColor(Color.gray.brighter());
            } else {
                graphics.setColor(Color.yellow);
            }
            graphics.fillRect(3, this.getSize().height - 14 + 6, 8, 2);
            if (this.zoom == this.hexSide.length - 1) {
                graphics.setColor(Color.gray.brighter());
            } else {
                graphics.setColor(Color.yellow);
            }
            graphics.fillRect(this.getSize().width - 14 + 3, this.getSize().height - 14 + 6, 8, 2);
            graphics.fillRect(this.getSize().width - 14 + 6, this.getSize().height - 14 + 3, 2, 8);
            if (this.zoom > 2) {
                String string;
                graphics.setColor(Color.black);
                graphics.drawLine(27, this.getSize().height - 14, 27, this.getSize().height);
                graphics.setColor(Color.green.darker());
                graphics.drawLine(28, this.getSize().height - 14, 28, this.getSize().height);
                graphics.setColor(Color.yellow);
                switch (this.heightDisplayMode) {
                    case 0: {
                        string = Messages.getString("MiniMap.NoHeightLabel");
                        break;
                    }
                    case 1: {
                        string = Messages.getString("MiniMap.GroundHeightLabel");
                        break;
                    }
                    case 2: {
                        string = Messages.getString("MiniMap.BuildingHeightLabel");
                        break;
                    }
                    case 3: {
                        string = Messages.getString("MiniMap.TotalHeightLabel");
                        break;
                    }
                    default: {
                        string = "";
                    }
                }
                graphics.drawString(string, 17, this.getSize().height - 14 + 12);
            }
        }
        graphics.setColor(color);
    }

    private void processMouseClick(int n, int n2, MouseEvent mouseEvent) {
        if (n2 > this.getSize().height - 14) {
            if (n < 14) {
                if (this.zoom == 0) {
                    return;
                }
                --this.zoom;
                this.initializeMap();
            } else if (n < 28 && this.zoom > 2) {
                this.heightDisplayMode = ++this.heightDisplayMode > 3 ? 0 : this.heightDisplayMode;
                this.initializeMap();
            } else if (n > this.getSize().width - 14) {
                if (this.zoom == this.hexSide.length - 1) {
                    return;
                }
                ++this.zoom;
                this.initializeMap();
            } else {
                if (this.minimized) {
                    this.setSize(this.getSize().width, this.heightBufer);
                    this.m_mapImage = this.createImage(this.getSize().width, this.heightBufer);
                } else {
                    this.heightBufer = this.getSize().height;
                    this.setSize(this.getSize().width, 14);
                    this.m_mapImage = this.createImage(Math.max(1, this.getSize().width), 14);
                }
                this.minimized = !this.minimized;
                this.m_dialog.pack();
                this.drawMap();
            }
        }
    }
}

