/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import megamek.client.Client;
import megamek.client.ui.swing.DoneButtoned;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.StatusBarPhaseDisplay;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.util.Distractable;
import megamek.common.util.DistractableAdapter;

public class ReportDisplay
extends StatusBarPhaseDisplay
implements ActionListener,
KeyListener,
DoneButtoned,
Distractable {
    private DistractableAdapter distracted = new DistractableAdapter();
    public Client client;
    private JTabbedPane tabs;
    private ArrayList<JScrollPane> vTextArea;
    private JButton readyB;
    private JButton rerollInitiativeB;
    private boolean rerolled;

    public ReportDisplay(Client client) {
        this.client = client;
        client.game.addGameListener(this);
        this.tabs = new JTabbedPane();
        Font font = new Font("Helvetica", 1, GUIPreferences.getInstance().getInt("AdvancedChatLoungeTabFontSize"));
        this.tabs.setFont(font);
        this.resetTabs();
        this.setupStatusBar("");
        this.readyB = new JButton(Messages.getString("ReportDisplay.Done"));
        this.readyB.setActionCommand("ready");
        this.readyB.addActionListener(this);
        this.rerollInitiativeB = new JButton(Messages.getString("ReportDisplay.Reroll"));
        this.rerollInitiativeB.setActionCommand("reroll_initiative");
        this.rerollInitiativeB.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.tabs, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 8));
        jPanel.add(this.rerollInitiativeB);
        for (int i = 0; i < 6; ++i) {
            jPanel.add(new JLabel(""));
        }
        this.addBag(jPanel, gridBagLayout, gridBagConstraints);
        this.addKeyListener(this);
    }

    private void addBag(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent.addKeyListener(this);
    }

    public void showRerollButton(boolean bl) {
        this.rerollInitiativeB.setVisible(bl);
    }

    public void ready() {
        this.rerollInitiativeB.setEnabled(false);
        this.readyB.setEnabled(false);
        this.client.sendDone(true);
    }

    public void rerollInitiative() {
        this.rerolled = true;
        this.rerollInitiativeB.setEnabled(false);
        this.readyB.setEnabled(false);
        this.client.sendRerollInitiativeRequest();
    }

    public boolean hasRerolled() {
        return this.rerolled;
    }

    public void resetButtons() {
        this.resetReadyButton();
        if (this.client.game.getPhase() == 6 && this.client.game.hasTacticalGenius(this.client.getLocalPlayer())) {
            this.showRerollButton(true);
        } else {
            this.showRerollButton(false);
        }
        this.rerollInitiativeB.setEnabled(true);
    }

    public void resetReadyButton() {
        this.readyB.setEnabled(true);
    }

    public void resetRerollButton() {
        this.rerollInitiativeB.setEnabled(true);
    }

    public void setReportTab(int n, String string, String string2) {
        if (n == 0) {
            n = 1;
        }
        if (n >= this.vTextArea.size()) {
            JTextArea jTextArea;
            if (n > 1) {
                this.tabs.remove(this.vTextArea.get(this.vTextArea.size() - 1));
                this.vTextArea.remove(this.vTextArea.size() - 1);
            }
            while (n > this.vTextArea.size()) {
                jTextArea = new JTextArea(this.client.receiveReport(this.client.game.getReports(this.vTextArea.size() + 1)), 40, 25);
                jTextArea.setEditable(false);
                this.tabs.add("Round " + (this.vTextArea.size() + 1), jTextArea);
                this.vTextArea.add(new JScrollPane(jTextArea));
            }
            jTextArea = new JTextArea(string2, 40, 25);
            jTextArea.setEditable(false);
            jTextArea.setOpaque(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            this.vTextArea.add(jScrollPane);
            this.tabs.add("Phase", jScrollPane);
            this.tabs.setSelectedComponent(jScrollPane);
        } else {
            ((JTextArea)((JViewport)this.vTextArea.get(n - 1).getComponent(0)).getView()).setText(string);
            ((JTextArea)((JViewport)this.vTextArea.get(n).getComponent(0)).getView()).setText(string2);
        }
    }

    public void appendReportTab(String string) {
        ((JTextArea)this.vTextArea.get(this.vTextArea.size() - 1).getComponent(0)).append(string);
        ((JTextArea)this.vTextArea.get(this.vTextArea.size() - 2).getComponent(0)).append(string);
    }

    public void resetTabs() {
        this.tabs.removeAll();
        this.vTextArea = new ArrayList();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase("ready")) {
            this.ready();
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("reroll_initiative")) {
            this.rerollInitiative();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            // empty if block
        }
        if (keyEvent.getKeyCode() == 10 && keyEvent.isControlDown()) {
            this.ready();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        this.setReportTab(this.client.game.getRoundCount(), this.client.roundReport, this.client.phaseReport);
        this.resetButtons();
        this.rerolled = false;
    }

    public boolean isIgnoringEvents() {
        return this.distracted.isIgnoringEvents();
    }

    public void setIgnoringEvents(boolean bl) {
        this.distracted.setIgnoringEvents(bl);
    }

    public void removeAllListeners() {
        this.client.game.removeGameListener(this);
    }

    public JButton getDoneButton() {
        return this.readyB;
    }

    public JComponent getSecondaryDisplay() {
        return this.panStatus;
    }
}

