/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;
import megamek.common.Entity;
import megamek.common.Mounted;
import megamek.common.actions.TriggerAPPodAction;

public class TriggerAPPodDialog
extends JDialog
implements ActionListener {
    private JButton butOkay = new JButton(Messages.getString("Okay"));
    private JTextArea labMessage;
    private ArrayList<TriggerPodTracker> trackers = new ArrayList();
    private int entityId = -1;

    public TriggerAPPodDialog(JFrame jFrame, Entity entity) {
        super(jFrame, Messages.getString("TriggerAPPodDialog.title"), true);
        Serializable serializable;
        Serializable serializable2;
        this.entityId = entity.getId();
        this.labMessage = new JTextArea(Messages.getString("TriggerAPPodDialog.selectPodsToTrigger", new Object[]{entity.getDisplayName()}));
        this.labMessage.setEditable(false);
        this.labMessage.setOpaque(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        Object object = entity.getMisc().iterator();
        while (object.hasNext()) {
            serializable2 = object.next();
            if (!((Mounted)serializable2).getType().hasFlag(0x2000000L)) continue;
            serializable = new StringBuffer();
            serializable.append(entity.getLocationName(((Mounted)serializable2).getLocation())).append(' ').append(((Mounted)serializable2).getName());
            JCheckBox jCheckBox = new JCheckBox(serializable.toString());
            jPanel.add(jCheckBox);
            if (((Mounted)serializable2).canFire()) {
                TriggerPodTracker triggerPodTracker = new TriggerPodTracker(jCheckBox, entity.getEquipmentNum((Mounted)serializable2));
                this.trackers.add(triggerPodTracker);
                continue;
            }
            jCheckBox.setEnabled(false);
        }
        this.butOkay.addActionListener(this);
        object = new GridBagLayout();
        serializable2 = new GridBagConstraints();
        this.getContentPane().setLayout((LayoutManager)object);
        ((GridBagConstraints)serializable2).fill = 1;
        ((GridBagConstraints)serializable2).insets = new Insets(10, 10, 10, 10);
        ((GridBagConstraints)serializable2).weightx = 1.0;
        ((GridBagConstraints)serializable2).weighty = 0.0;
        ((GridBagConstraints)serializable2).gridwidth = 0;
        ((GridBagLayout)object).setConstraints(this.labMessage, (GridBagConstraints)serializable2);
        this.getContentPane().add(this.labMessage);
        ((GridBagLayout)object).setConstraints(jPanel, (GridBagConstraints)serializable2);
        this.getContentPane().add(jPanel);
        ((GridBagConstraints)serializable2).weightx = 1.0;
        ((GridBagConstraints)serializable2).weighty = 1.0;
        ((GridBagConstraints)serializable2).fill = 3;
        ((GridBagConstraints)serializable2).ipadx = 20;
        ((GridBagConstraints)serializable2).ipady = 5;
        ((GridBagLayout)object).setConstraints(this.butOkay, (GridBagConstraints)serializable2);
        this.getContentPane().add(this.butOkay);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TriggerAPPodDialog.this.setVisible(false);
            }
        });
        this.pack();
        serializable = this.getSize();
        boolean bl = false;
        if (((Dimension)serializable).width < GUIPreferences.getInstance().getMinimumSizeWidth()) {
            ((Dimension)serializable).width = GUIPreferences.getInstance().getMinimumSizeWidth();
        }
        if (((Dimension)serializable).height < GUIPreferences.getInstance().getMinimumSizeHeight()) {
            ((Dimension)serializable).height = GUIPreferences.getInstance().getMinimumSizeHeight();
        }
        if (bl) {
            this.setSize((Dimension)serializable);
            serializable = this.getSize();
        }
        this.setResizable(false);
        this.setLocation(jFrame.getLocation().x + jFrame.getSize().width / 2 - ((Dimension)serializable).width / 2, jFrame.getLocation().y + jFrame.getSize().height / 2 - ((Dimension)serializable).height / 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public Enumeration getActions() {
        Vector<TriggerAPPodAction> vector = new Vector<TriggerAPPodAction>();
        Iterator<TriggerPodTracker> iterator = this.trackers.iterator();
        while (iterator.hasNext()) {
            TriggerPodTracker triggerPodTracker = iterator.next();
            if (!triggerPodTracker.isTriggered()) continue;
            vector.addElement(new TriggerAPPodAction(this.entityId, triggerPodTracker.getNum()));
        }
        return vector.elements();
    }

    private class TriggerPodTracker {
        private int podNum = -1;
        private JCheckBox checkbox;

        public TriggerPodTracker(JCheckBox jCheckBox, int n) {
            this.podNum = n;
            this.checkbox = jCheckBox;
        }

        public boolean isTriggered() {
            return this.checkbox.isSelected();
        }

        public int getNum() {
            return this.podNum;
        }
    }
}

