/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing.widget;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Polygon;
import java.util.Vector;
import javax.swing.JComponent;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.widget.BackGroundDrawer;
import megamek.client.ui.swing.widget.DisplayMapSet;
import megamek.client.ui.swing.widget.PMAreasGroup;
import megamek.client.ui.swing.widget.PMSimpleLabel;
import megamek.client.ui.swing.widget.PMSimplePolygonArea;
import megamek.client.ui.swing.widget.PMUtil;
import megamek.client.ui.swing.widget.PMValueLabel;
import megamek.client.ui.swing.widget.WidgetUtils;
import megamek.common.Entity;
import megamek.common.GunEmplacement;

public class GunEmplacementMapSet
implements DisplayMapSet {
    private JComponent comp;
    private PMSimplePolygonArea[] areas = new PMSimplePolygonArea[5];
    private PMSimpleLabel[] labels = new PMSimpleLabel[5];
    private PMValueLabel[] vLabels = new PMValueLabel[5];
    private Vector bgDrawers = new Vector();
    private PMAreasGroup content = new PMAreasGroup();
    private static final String IMAGE_DIR = "data/images/widgets";
    private static final Polygon BUILDING_CF = new Polygon(new int[]{0, 0, 40, 40}, new int[]{0, 160, 160, 0}, 4);
    private static final Polygon TURRET_ARMOR = new Polygon(new int[]{0, 0, 80, 80, 90, 150, 160, 160, 150, 110, 80, 80}, new int[]{20, 25, 25, 30, 35, 35, 30, 15, 0, 0, 15, 20}, 12);
    private static final Font FONT_LABEL = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorSmallFontSize"));
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorLargeFontSize"));

    public GunEmplacementMapSet(JComponent jComponent) {
        this.comp = jComponent;
        this.setAreas();
        this.setLabels();
        this.setBackGround();
        this.translateAreas();
        this.setContent();
    }

    public void setRest() {
    }

    public PMAreasGroup getContentGroup() {
        return this.content;
    }

    public Vector getBackgroundDrawers() {
        return this.bgDrawers;
    }

    public void setEntity(Entity entity) {
        GunEmplacement gunEmplacement = (GunEmplacement)entity;
        int n = 0;
        this.vLabels[n].setValue(gunEmplacement.getArmorString(n));
        WidgetUtils.setAreaColor(this.areas[n], this.vLabels[n], (double)gunEmplacement.getArmor(n) / (double)gunEmplacement.getOArmor(n));
        n = 4;
        this.vLabels[n].setValue(gunEmplacement.getArmorString(n));
        WidgetUtils.setAreaColor(this.areas[n], this.vLabels[n], gunEmplacement.hasTurret() ? (double)gunEmplacement.getArmor(n) / (double)gunEmplacement.getOArmor(n) : 0.0);
    }

    private void setContent() {
        this.content.addArea(this.areas[0]);
        this.content.addArea(this.labels[0]);
        this.content.addArea(this.vLabels[0]);
        this.content.addArea(this.areas[4]);
        this.content.addArea(this.labels[4]);
        this.content.addArea(this.vLabels[4]);
    }

    private void setAreas() {
        this.areas[0] = new PMSimplePolygonArea(BUILDING_CF);
        this.areas[4] = new PMSimplePolygonArea(TURRET_ARMOR);
    }

    private void setLabels() {
        FontMetrics fontMetrics = this.comp.getFontMetrics(FONT_LABEL);
        this.labels[0] = WidgetUtils.createLabel(Messages.getString("GunEmplacementMapSet.ConstructionFactor"), fontMetrics, Color.white, 90, 200);
        this.labels[4] = WidgetUtils.createLabel(Messages.getString("GunEmplacementMapSet.TurretArmor"), fontMetrics, Color.white, 90, -25);
        fontMetrics = this.comp.getFontMetrics(FONT_VALUE);
        this.vLabels[0] = WidgetUtils.createValueLabel(90, 90, "", fontMetrics);
        this.vLabels[4] = WidgetUtils.createValueLabel(90, 10, "", fontMetrics);
    }

    private void setBackGround() {
        Image image = this.comp.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this.comp);
        int n = 8;
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 20;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 68;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 258;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 273;
        image = this.comp.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 321;
        image = this.comp.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.comp.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.comp.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
    }

    private void translateAreas() {
        this.areas[0].translate(70, 25);
        this.areas[4].translate(-30, -10);
    }
}

