/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.IHex;
import megamek.common.LocationFullException;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.PilotingRollData;
import megamek.common.Report;
import megamek.common.WeaponType;

public class Infantry
extends Entity
implements Serializable {
    private int menStarting = 0;
    private int menShooting = 0;
    private int men = 0;
    private long weapons = 1L;
    private int[] damage = new int[29];
    private static final int[] NUM_OF_SLOTS = new int[]{0};
    private static final String[] LOCATION_ABBRS = new String[]{"Men"};
    private static final String[] LOCATION_NAMES = new String[]{"Men"};
    private boolean antiMek = false;
    protected int runMP = 1;
    public int turnsLayingExplosives = -1;
    public static final int DUG_IN_NONE = 0;
    public static final int DUG_IN_WORKING = 1;
    public static final int DUG_IN_COMPLETE = 2;
    public static final int DUG_IN_FORTIFYING1 = 3;
    public static final int DUG_IN_FORTIFYING2 = 4;
    private int dugIn = 0;
    public static final int INF_PLT_MAX_MEN = 28;
    public static final int INF_PLT_JUMP_MAX_MEN = 21;
    public static final int INF_PLT_CLAN_MAX_MEN = 25;
    public static final int INF_UNKNOWN = -1;
    public static final int INF_RIFLE = 1;
    public static final int INF_MG = 3;
    public static final int INF_FLAMER = 2;
    public static final int INF_LASER = 4;
    public static final int INF_SRM = 9;
    public static final int INF_LRM = 7;
    public static final int LOC_INFANTRY = 0;
    public static final String LEG_ATTACK = "LegAttack";
    public static final String SWARM_MEK = "SwarmMek";
    public static final String STOP_SWARM = "StopSwarm";

    private void setDamage(long l) {
        double d;
        this.damage[0] = 0;
        if (l == 1L || l == 7L) {
            d = 4.0;
        } else if (l == 3L || l == 2L) {
            d = 3.0;
        } else if (l == 4L || l == 9L) {
            d = 2.0;
        } else {
            throw new IllegalArgumentException("Unknown infantry weapon: " + l);
        }
        int n = 1;
        int n2 = 1;
        while (n <= 28) {
            this.damage[n] = (int)Math.ceil((double)n2 / d);
            if (1 == n && (3L == l || 2L == l)) {
                --n2;
            }
            ++n;
            ++n2;
        }
        if (3L == l || 2L == l) {
            this.damage[28] = (int)Math.ceil(28.0 / d);
        }
    }

    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public int locations() {
        return 1;
    }

    public Infantry() {
        this.setMovementMode(10);
        this.setDamage(this.weapons);
        this.setOriginalWalkMP(1);
        this.weapons = -1L;
    }

    public boolean canChangeSecondaryFacing() {
        return this.dugIn == 0;
    }

    public boolean isValidSecondaryFacing(int n) {
        return true;
    }

    public int clipSecondaryFacing(int n) {
        return n;
    }

    public void setCrew(Pilot pilot) {
        super.setCrew(pilot);
        this.getCrew().setPiloting(5);
    }

    public int getRunMP(boolean bl) {
        if (bl) {
            return this.applyGravityEffectsOnMP(this.getOriginalRunMP());
        }
        return this.getOriginalRunMP();
    }

    public int getRunMPwithoutMASC(boolean bl) {
        return this.getRunMP(bl);
    }

    protected int getOriginalRunMP() {
        return this.runMP;
    }

    public boolean isHexProhibited(IHex iHex) {
        if (iHex.containsTerrain(30)) {
            return true;
        }
        if (iHex.containsTerrain(24)) {
            return true;
        }
        return iHex.terrainLevel(4) > 0 && !iHex.containsTerrain(20);
    }

    public String getMovementString(int n) {
        switch (n) {
            case 0: {
                return "None";
            }
            case 1: 
            case 2: {
                switch (this.getMovementMode()) {
                    case 10: {
                        return "Walked";
                    }
                    case 11: {
                        return "Biked";
                    }
                }
                return "Unknown!";
            }
            case 4: 
            case 5: {
                return "Flew";
            }
            case 3: {
                return "Jumped";
            }
        }
        return "Unknown!";
    }

    public String getMovementAbbr(int n) {
        switch (n) {
            case 0: {
                return "N";
            }
            case 1: {
                return "W";
            }
            case 2: {
                switch (this.getMovementMode()) {
                    case 10: {
                        return "R";
                    }
                    case 11: {
                        return "B";
                    }
                }
                return "?";
            }
            case 3: {
                return "J";
            }
        }
        return "?";
    }

    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        return this.rollHitLocation(n, n2);
    }

    public HitData rollHitLocation(int n, int n2) {
        return new HitData(0);
    }

    public HitData getTransferLocation(HitData hitData) {
        return new HitData(-2);
    }

    public int getDependentLocation(int n) {
        return -1;
    }

    public boolean hasRearArmor(int n) {
        return false;
    }

    protected boolean isPlatoon() {
        return true;
    }

    public int getInternal(int n) {
        if (!this.isPlatoon()) {
            return super.getInternal(n);
        }
        return this.men > 0 ? this.men : -3;
    }

    public int getOInternal(int n) {
        if (!this.isPlatoon()) {
            return super.getOInternal(n);
        }
        return this.menStarting;
    }

    public void setInternal(int n, int n2) {
        super.setInternal(n, n2);
        this.men = n;
    }

    public double getInternalRemainingPercent() {
        if (!this.isPlatoon()) {
            return super.getInternalRemainingPercent();
        }
        int n = this.men > 0 ? this.men : 0;
        return (double)n / (double)this.menStarting;
    }

    public void initializeInternal(int n, int n2) {
        this.menStarting = n;
        this.menShooting = n;
        super.initializeInternal(n, n2);
    }

    public void autoSetInternal() {
        if (this.isClan()) {
            this.initializeInternal(25, 0);
            return;
        }
        switch (this.getMovementMode()) {
            case 10: 
            case 11: {
                this.initializeInternal(28, 0);
                break;
            }
            case 12: {
                this.initializeInternal(21, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
            }
        }
        if (this.hasWorkingMisc(0x100000L, 16)) {
            this.initializeArmor(this.getOInternal(0), 0);
        }
    }

    protected void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        EquipmentType equipmentType = mounted.getType();
        if (SWARM_MEK.equals(equipmentType.getInternalName())) {
            this.antiMek = true;
        } else if (!LEG_ATTACK.equals(equipmentType.getInternalName()) && !STOP_SWARM.equals(equipmentType.getInternalName()) && mounted.getType() instanceof WeaponType && equipmentType.hasFlag(2048L)) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (this.weapons != -1L) {
                throw new LocationFullException("Unit is already equiped with an infantry weapon and does not need a " + weaponType.getName());
            }
            long l = weaponType.getAmmoType() != -1 ? (long)weaponType.getAmmoType() : weaponType.getFlags() & 6L;
            this.weapons = l;
            this.setDamage(l);
            if (weaponType.hasFlag(1024L)) {
                for (int i = 1; i < this.damage.length; ++i) {
                    this.damage[i] = (int)Math.floor((double)this.damage[i] / 2.0);
                }
            }
        }
        super.addEquipment(mounted, n, bl);
    }

    public int getWeaponArc(int n) {
        if (this instanceof BattleArmor && this.dugIn == 0) {
            return 0;
        }
        Mounted mounted = this.getEquipment(n);
        WeaponType weaponType = (WeaponType)mounted.getType();
        if ((weaponType.hasFlag(2048L) || weaponType.hasFlag(0x40000000L) || weaponType.getInternalName() == LEG_ATTACK || weaponType.getInternalName() == SWARM_MEK || weaponType.getInternalName() == STOP_SWARM) && this.dugIn == 0) {
            return 0;
        }
        return 1;
    }

    public boolean isSecondaryArcWeapon(int n) {
        if (this instanceof BattleArmor) {
            return false;
        }
        Mounted mounted = this.getEquipment(n);
        WeaponType weaponType = (WeaponType)mounted.getType();
        return !weaponType.hasFlag(2048L);
    }

    public int getHeatCapacity() {
        return 999;
    }

    public int getHeatCapacityWithWater() {
        return this.getHeatCapacity();
    }

    public int getEngineCritHeat() {
        return 0;
    }

    protected int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    public boolean hasHittableCriticals(int n) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int calculateBattleValue() {
        double d = 0.0;
        if (this.antiMek) {
            if (this.weapons == 1L) {
                if (10 == this.getMovementMode()) {
                    d = 32.0;
                } else if (11 == this.getMovementMode()) {
                    d = 42.0;
                } else {
                    if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                    d = 46.0;
                }
            } else if (this.weapons == 3L) {
                if (10 == this.getMovementMode()) {
                    d = 47.0;
                } else if (11 == this.getMovementMode()) {
                    d = 63.0;
                } else {
                    if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                    d = 62.0;
                }
            } else if (this.weapons == 2L) {
                if (10 == this.getMovementMode()) {
                    d = 41.0;
                } else if (11 == this.getMovementMode()) {
                    d = 54.0;
                } else {
                    if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                    d = 51.0;
                }
            } else if (this.weapons == 4L) {
                if (10 == this.getMovementMode()) {
                    d = 60.0;
                } else if (11 == this.getMovementMode()) {
                    d = 70.0;
                } else {
                    if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                    d = 71.0;
                }
            } else if (this.weapons == 9L) {
                if (10 == this.getMovementMode()) {
                    d = 60.0;
                } else if (11 == this.getMovementMode()) {
                    d = 70.0;
                } else {
                    if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                    d = 71.0;
                }
            } else {
                if (this.weapons != 7L) throw new IllegalArgumentException("Unknown infantry weapon: " + this.weapons);
                if (10 == this.getMovementMode()) {
                    d = 56.0;
                } else if (11 == this.getMovementMode()) {
                    d = 75.0;
                } else {
                    if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                    d = 87.0;
                }
            }
        } else if (this.weapons == 1L) {
            if (10 == this.getMovementMode()) {
                d = 23.0;
            } else if (11 == this.getMovementMode()) {
                d = 28.0;
            } else {
                if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                d = 29.0;
            }
        } else if (this.weapons == 3L) {
            if (10 == this.getMovementMode()) {
                d = 31.0;
            } else if (11 == this.getMovementMode()) {
                d = 39.0;
            } else {
                if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                d = 37.0;
            }
        } else if (this.weapons == 2L) {
            if (10 == this.getMovementMode()) {
                d = 28.0;
            } else if (11 == this.getMovementMode()) {
                d = 35.0;
            } else {
                if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                d = 32.0;
            }
        } else if (this.weapons == 4L) {
            if (10 == this.getMovementMode()) {
                d = 37.0;
            } else if (11 == this.getMovementMode()) {
                d = 42.0;
            } else {
                if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                d = 41.0;
            }
        } else if (this.weapons == 9L) {
            if (10 == this.getMovementMode()) {
                d = 60.0;
            } else if (11 == this.getMovementMode()) {
                d = 70.0;
            } else {
                if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                d = 71.0;
            }
        } else {
            if (this.weapons != 7L) throw new IllegalArgumentException("Unknown infantry weapon: " + this.weapons);
            if (10 == this.getMovementMode()) {
                d = 56.0;
            } else if (11 == this.getMovementMode()) {
                d = 75.0;
            } else {
                if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                d = 87.0;
            }
        }
        Iterator<Mounted> iterator = this.getWeaponList().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.hasFlag(2048L)) continue;
            d += weaponType.getBV(this);
        }
        d *= this.getInternalRemainingPercent();
        if (this.getsTagBVPenalty()) {
            d += 200.0;
        }
        if (this.getsHomingBVPenalty()) {
            d += 200.0;
        }
        double d2 = this.crew.getBVSkillMultiplier();
        int n = (int)Math.round(d);
        return (int)Math.round((double)n * d2);
    }

    public Vector victoryReport() {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(7025);
        report.type = 0;
        report.addDesc(this);
        vector.addElement(report);
        report = new Report(7040);
        report.type = 0;
        report.newlines = 0;
        vector.addElement(report);
        vector.addAll(this.crew.getDescVector(true));
        report = new Report(7070, 0);
        report.add(this.getKillNumber());
        vector.addElement(report);
        if (this.isDestroyed()) {
            Entity entity = this.game.getEntity(this.killerId);
            if (entity == null) {
                entity = this.game.getOutOfGameEntity(this.killerId);
            }
            if (entity != null) {
                report = new Report(7072, 0);
                report.addDesc(entity);
            } else {
                report = new Report(7073, 0);
            }
            vector.addElement(report);
        }
        report.newlines = 2;
        return vector;
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        return pilotingRollData;
    }

    public int getMaxElevationChange() {
        return 1;
    }

    public void applyDamage() {
        super.applyDamage();
        this.menShooting = this.men;
    }

    public int getDamage(int n) {
        return this.damage[n];
    }

    public int getShootingStrength() {
        return this.menShooting;
    }

    public boolean canCharge() {
        return false;
    }

    public boolean canDFA() {
        return false;
    }

    public void setOriginalRunMP(int n) {
        this.runMP = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getCost() {
        double d = 0.0;
        double d2 = 0.0;
        d2 = this.antiMek ? 5.0 : 1.0;
        if (this.weapons == 1L) {
            if (10 == this.getMovementMode()) {
                d = 600000.0;
                return d * d2;
            } else if (11 == this.getMovementMode()) {
                d = 960000.0;
                return d * d2;
            } else {
                if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                d = 1200000.0;
            }
            return d * d2;
        } else if (this.weapons == 3L) {
            if (10 == this.getMovementMode()) {
                d = 800000.0;
                return d * d2;
            } else if (11 == this.getMovementMode()) {
                d = 1280000.0;
                return d * d2;
            } else {
                if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                d = 1600000.0;
            }
            return d * d2;
        } else if (this.weapons == 2L) {
            if (10 == this.getMovementMode()) {
                d = 800000.0;
                return d * d2;
            } else if (11 == this.getMovementMode()) {
                d = 1280000.0;
                return d * d2;
            } else {
                if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                d = 1600000.0;
            }
            return d * d2;
        } else if (this.weapons == 4L) {
            if (10 == this.getMovementMode()) {
                d = 1200000.0;
                return d * d2;
            } else if (11 == this.getMovementMode()) {
                d = 1920000.0;
                return d * d2;
            } else {
                if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                d = 2400000.0;
            }
            return d * d2;
        } else if (this.weapons == 9L) {
            if (10 == this.getMovementMode()) {
                d = 1400000.0;
                return d * d2;
            } else if (11 == this.getMovementMode()) {
                d = 2240000.0;
                return d * d2;
            } else {
                if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                d = 2800000.0;
            }
            return d * d2;
        } else {
            if (this.weapons != 7L) throw new IllegalArgumentException("Unknown infantry weapon: " + this.weapons);
            if (10 == this.getMovementMode()) {
                d = 1400000.0;
                return d * d2;
            } else if (11 == this.getMovementMode()) {
                d = 2240000.0;
                return d * d2;
            } else {
                if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                d = 2800000.0;
            }
        }
        return d * d2;
    }

    public boolean doomedInVacuum() {
        return false;
    }

    public boolean canAssaultDrop() {
        return this.game.getOptions().booleanOption("paratroopers");
    }

    public boolean isEligibleFor(int n) {
        if (this.turnsLayingExplosives > 0 && n != 14) {
            return false;
        }
        if (this.dugIn != 2 && this.dugIn != 0) {
            return false;
        }
        return super.isEligibleFor(n);
    }

    public void newRound(int n) {
        if (this.turnsLayingExplosives >= 0) {
            ++this.turnsLayingExplosives;
            if (!Compute.isInBuilding(this.game, this)) {
                this.turnsLayingExplosives = -1;
            }
        }
        if (this.dugIn != 2 && this.dugIn != 0) {
            ++this.dugIn;
            if (this.dugIn > 4) {
                this.dugIn = 0;
            }
        }
        super.newRound(n);
    }

    public boolean loadWeapon(Mounted mounted, Mounted mounted2) {
        if (!(this instanceof BattleArmor || mounted.getLinked() == null && mounted2.getLinkedBy() == null)) {
            return false;
        }
        return super.loadWeapon(mounted, mounted2);
    }

    public boolean loadWeaponWithSameAmmo(Mounted mounted, Mounted mounted2) {
        if (!(this instanceof BattleArmor || mounted.getLinked() == null && mounted2.getLinkedBy() == null)) {
            return false;
        }
        return super.loadWeaponWithSameAmmo(mounted, mounted2);
    }

    public void setDugIn(int n) {
        this.dugIn = n;
    }

    public int getDugIn() {
        return this.dugIn;
    }

    public boolean isNuclearHardened() {
        return false;
    }
}

