/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import com.rc.retroweaver.runtime.Autobox;
import gd.xml.ParseException;
import gd.xml.tiny.ParsedXML;
import gd.xml.tiny.TinyParser;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.Compute;

public class MapSettings
implements Serializable {
    public static final String BOARD_RANDOM = "[RANDOM]";
    public static final String BOARD_SURPRISE = "[SURPRISE]";
    public static final String BOARD_GENERATED = "[GENERATED]";
    public static final int MOUNTAIN_PLAIN = 0;
    public static final int MOUNTAIN_VOLCANO_EXTINCT = 1;
    public static final int MOUNTAIN_VOLCANO_DORMANT = 2;
    public static final int MOUNTAIN_VOLCANO_ACTIVE = 3;
    public static final int MOUNTAIN_SNOWCAPPED = 4;
    public static final int MOUNTAIN_LAKE = 5;
    private int boardWidth = 16;
    private int boardHeight = 17;
    private int mapWidth = 1;
    private int mapHeight = 1;
    private Vector boardsSelected = new Vector();
    private Vector boardsAvailable = new Vector();
    private Vector boardBuildings = new Vector();
    private int hilliness = 40;
    private int cliffs = 0;
    private int range = 5;
    private int probInvert = 5;
    private int minWaterSpots = 1;
    private int maxWaterSpots = 3;
    private int minWaterSize = 5;
    private int maxWaterSize = 10;
    private int probDeep = 33;
    private int minForestSpots = 3;
    private int maxForestSpots = 8;
    private int minForestSize = 4;
    private int maxForestSize = 12;
    private int probHeavy = 30;
    private int minRoughSpots = 2;
    private int maxRoughSpots = 10;
    private int minRoughSize = 1;
    private int maxRoughSize = 2;
    private int minSwampSpots = 2;
    private int maxSwampSpots = 10;
    private int minSwampSize = 1;
    private int maxSwampSize = 2;
    private int minPavementSpots = 0;
    private int maxPavementSpots = 0;
    private int minPavementSize = 1;
    private int maxPavementSize = 6;
    private int minRubbleSpots = 0;
    private int maxRubbleSpots = 0;
    private int minRubbleSize = 1;
    private int maxRubbleSize = 6;
    private int minFortifiedSpots = 0;
    private int maxFortifiedSpots = 0;
    private int minFortifiedSize = 1;
    private int maxFortifiedSize = 2;
    private int minIceSpots = 0;
    private int maxIceSpots = 0;
    private int minIceSize = 1;
    private int maxIceSize = 6;
    private int probRoad = 0;
    private int probRiver = 0;
    private int probCrater = 0;
    private int minRadius = 2;
    private int maxRadius = 7;
    private int maxCraters = 2;
    private int minCraters = 1;
    private int algorithmToUse = 0;
    private String theme = "";
    private int probFlood = 0;
    private int probForestFire = 0;
    private int probFreeze = 0;
    private int probDrought = 0;
    private int fxMod = 0;
    private int cityBlocks = 16;
    private String cityType = "NONE";
    private int cityMinCF = 10;
    private int cityMaxCF = 100;
    private int cityMinFloors = 1;
    private int cityMaxFloors = 6;
    private int cityDensity = 75;
    private int townSize = 60;
    private int invertNegativeTerrain = 0;
    private int mountainPeaks = 0;
    private int mountainWidthMin = 7;
    private int mountainWidthMax = 20;
    private int mountainHeightMin = 5;
    private int mountainHeightMax = 8;
    private int mountainStyle = 0;

    public MapSettings() {
        this(16, 17, 1, 1);
    }

    public MapSettings(int n, int n2, int n3, int n4) {
        this.setBoardSize(n, n2);
        this.setMapSize(n3, n4);
    }

    public MapSettings(MapSettings mapSettings) {
        this.boardWidth = mapSettings.getBoardWidth();
        this.boardHeight = mapSettings.getBoardHeight();
        this.mapWidth = mapSettings.getMapWidth();
        this.mapHeight = mapSettings.getMapHeight();
        this.boardsSelected = (Vector)mapSettings.getBoardsSelectedVector().clone();
        this.boardsAvailable = (Vector)mapSettings.getBoardsAvailableVector().clone();
        this.invertNegativeTerrain = mapSettings.getInvertNegativeTerrain();
        this.mountainHeightMin = mapSettings.getMountainHeightMin();
        this.mountainHeightMax = mapSettings.getMountainHeightMax();
        this.mountainPeaks = mapSettings.getMountainPeaks();
        this.mountainStyle = mapSettings.getMountainStyle();
        this.mountainWidthMin = mapSettings.getMountainWidthMin();
        this.mountainWidthMax = mapSettings.getMountainWidthMax();
        this.hilliness = mapSettings.getHilliness();
        this.cliffs = mapSettings.getCliffs();
        this.range = mapSettings.getRange();
        this.probInvert = mapSettings.getProbInvert();
        this.minWaterSpots = mapSettings.getMinWaterSpots();
        this.maxWaterSpots = mapSettings.getMaxWaterSpots();
        this.minWaterSize = mapSettings.getMinWaterSize();
        this.maxWaterSize = mapSettings.getMaxWaterSize();
        this.probDeep = mapSettings.getProbDeep();
        this.minForestSpots = mapSettings.getMinForestSpots();
        this.maxForestSpots = mapSettings.getMaxForestSpots();
        this.minForestSize = mapSettings.getMinForestSize();
        this.maxForestSize = mapSettings.getMaxForestSize();
        this.probHeavy = mapSettings.getProbHeavy();
        this.minRoughSpots = mapSettings.getMinRoughSpots();
        this.maxRoughSpots = mapSettings.getMaxRoughSpots();
        this.minRoughSize = mapSettings.getMinRoughSize();
        this.maxRoughSize = mapSettings.getMaxRoughSize();
        this.minSwampSpots = mapSettings.getMinSwampSpots();
        this.maxSwampSpots = mapSettings.getMaxSwampSpots();
        this.minSwampSize = mapSettings.getMinSwampSize();
        this.maxSwampSize = mapSettings.getMaxSwampSize();
        this.minPavementSpots = mapSettings.getMinPavementSpots();
        this.maxPavementSpots = mapSettings.getMaxPavementSpots();
        this.minPavementSize = mapSettings.getMinPavementSize();
        this.maxPavementSize = mapSettings.getMaxPavementSize();
        this.minRubbleSpots = mapSettings.getMinRubbleSpots();
        this.maxRubbleSpots = mapSettings.getMaxRubbleSpots();
        this.minRubbleSize = mapSettings.getMinRubbleSize();
        this.maxRubbleSize = mapSettings.getMaxRubbleSize();
        this.minFortifiedSpots = mapSettings.getMinFortifiedSpots();
        this.maxFortifiedSpots = mapSettings.getMaxFortifiedSpots();
        this.minFortifiedSize = mapSettings.getMinFortifiedSize();
        this.maxFortifiedSize = mapSettings.getMaxFortifiedSize();
        this.minIceSpots = mapSettings.getMinIceSpots();
        this.maxIceSpots = mapSettings.getMaxIceSpots();
        this.minIceSize = mapSettings.getMinIceSize();
        this.maxIceSize = mapSettings.getMaxIceSize();
        this.probRoad = mapSettings.getProbRoad();
        this.probRiver = mapSettings.getProbRiver();
        this.probCrater = mapSettings.getProbCrater();
        this.minRadius = mapSettings.getMinRadius();
        this.maxRadius = mapSettings.getMaxRadius();
        this.minCraters = mapSettings.getMinCraters();
        this.maxCraters = mapSettings.getMaxCraters();
        this.algorithmToUse = mapSettings.getAlgorithmToUse();
        this.theme = mapSettings.getTheme();
        this.probFlood = mapSettings.getProbFlood();
        this.probForestFire = mapSettings.getProbForestFire();
        this.probFreeze = mapSettings.getProbFreeze();
        this.probDrought = mapSettings.getProbDrought();
        this.fxMod = mapSettings.getFxMod();
        this.cityBlocks = mapSettings.getCityBlocks();
        this.cityType = mapSettings.getCityType();
        this.cityMinCF = mapSettings.getCityMinCF();
        this.cityMaxCF = mapSettings.getCityMaxCF();
        this.cityMinFloors = mapSettings.getCityMinFloors();
        this.cityMaxFloors = mapSettings.getCityMaxFloors();
        this.cityDensity = mapSettings.getCityDensity();
        this.boardBuildings = mapSettings.getBoardBuildings();
    }

    public int getBoardWidth() {
        return this.boardWidth;
    }

    public int getBoardHeight() {
        return this.boardHeight;
    }

    public void setBoardSize(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Total board area must be positive");
        }
        if (this.boardWidth != n || this.boardHeight != n2) {
            this.boardWidth = n;
            this.boardHeight = n2;
            this.boardsAvailable.removeAllElements();
        }
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String string) {
        this.theme = string;
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    public void setMapSize(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Total map area must be positive");
        }
        this.mapWidth = n;
        this.mapHeight = n2;
        this.boardsSelected.setSize(n * n2);
    }

    public Enumeration getBoardsSelected() {
        return this.boardsSelected.elements();
    }

    public Vector getBoardsSelectedVector() {
        return this.boardsSelected;
    }

    public void setBoardsSelectedVector(Vector vector) {
        this.boardsSelected = vector;
    }

    public void setNullBoards(String string) {
        for (int i = 0; i < this.boardsSelected.size(); ++i) {
            if (this.boardsSelected.elementAt(i) != null) continue;
            this.boardsSelected.setElementAt(string, i);
        }
    }

    public Vector getBoardBuildings() {
        return this.boardBuildings;
    }

    public void setBoardBuildings(Vector vector) {
        this.boardBuildings = vector;
    }

    public void replaceBoardWithRandom(String string) {
        for (int i = 0; i < this.boardsSelected.size(); ++i) {
            if (!this.boardsSelected.elementAt(i).equals(string)) continue;
            int n = Compute.randomInt(this.boardsAvailable.size() - 3) + 3;
            if (0 == Compute.randomInt(2)) {
                this.boardsSelected.setElementAt("rotate:" + this.boardsAvailable.elementAt(n), i);
                continue;
            }
            this.boardsSelected.setElementAt(this.boardsAvailable.elementAt(n), i);
        }
    }

    public void removeUnavailable() {
        for (int i = 0; i < this.boardsSelected.size(); ++i) {
            if (this.boardsSelected.elementAt(i) != null && this.boardsAvailable.size() != 0 && this.boardsAvailable.indexOf(this.boardsSelected.elementAt(i)) != -1) continue;
            this.boardsSelected.setElementAt(null, i);
        }
    }

    public Enumeration getBoardsAvailable() {
        return this.boardsAvailable.elements();
    }

    public Vector getBoardsAvailableVector() {
        return this.boardsAvailable;
    }

    public void setBoardsAvailableVector(Vector vector) {
        this.boardsAvailable = vector;
    }

    public void validateMapGenParameters() {
        if (this.hilliness < 0) {
            this.hilliness = 0;
        }
        if (this.hilliness > 99) {
            this.hilliness = 99;
        }
        if (this.cliffs < 0) {
            this.cliffs = 0;
        }
        if (this.cliffs > 100) {
            this.cliffs = 100;
        }
        if (this.range < 0) {
            this.range = 0;
        }
        if (this.minWaterSpots < 0) {
            this.minWaterSpots = 0;
        }
        if (this.maxWaterSpots < this.minWaterSpots) {
            this.maxWaterSpots = this.minWaterSpots;
        }
        if (this.minWaterSize < 0) {
            this.minWaterSize = 0;
        }
        if (this.maxWaterSize < this.minWaterSize) {
            this.maxWaterSize = this.minWaterSize;
        }
        if (this.probDeep < 0) {
            this.probDeep = 0;
        }
        if (this.probDeep > 100) {
            this.probDeep = 100;
        }
        if (this.minForestSpots < 0) {
            this.minForestSpots = 0;
        }
        if (this.maxForestSpots < this.minForestSpots) {
            this.maxForestSpots = this.minForestSpots;
        }
        if (this.minForestSize < 0) {
            this.minForestSize = 0;
        }
        if (this.maxForestSize < this.minForestSize) {
            this.maxForestSize = this.minForestSize;
        }
        if (this.probHeavy < 0) {
            this.probHeavy = 0;
        }
        if (this.probHeavy > 100) {
            this.probHeavy = 100;
        }
        if (this.minRoughSpots < 0) {
            this.minRoughSpots = 0;
        }
        if (this.maxRoughSpots < this.minRoughSpots) {
            this.maxRoughSpots = this.minRoughSpots;
        }
        if (this.minRoughSize < 0) {
            this.minRoughSize = 0;
        }
        if (this.maxRoughSize < this.minRoughSize) {
            this.maxRoughSize = this.minRoughSize;
        }
        if (this.minSwampSpots < 0) {
            this.minSwampSpots = 0;
        }
        if (this.maxSwampSpots < this.minSwampSpots) {
            this.maxSwampSpots = this.minSwampSpots;
        }
        if (this.minSwampSize < 0) {
            this.minSwampSize = 0;
        }
        if (this.maxSwampSize < this.minSwampSize) {
            this.maxSwampSize = this.minSwampSize;
        }
        if (this.minPavementSpots < 0) {
            this.minPavementSpots = 0;
        }
        if (this.maxPavementSpots < this.minPavementSpots) {
            this.maxPavementSpots = this.minPavementSpots;
        }
        if (this.minPavementSize < 0) {
            this.minPavementSize = 0;
        }
        if (this.maxPavementSize < this.minPavementSize) {
            this.maxPavementSize = this.minPavementSize;
        }
        if (this.minRubbleSpots < 0) {
            this.minRubbleSpots = 0;
        }
        if (this.maxRubbleSpots < this.minRubbleSpots) {
            this.maxRubbleSpots = this.minRubbleSpots;
        }
        if (this.minRubbleSize < 0) {
            this.minRubbleSize = 0;
        }
        if (this.maxRubbleSize < this.minRubbleSize) {
            this.maxRubbleSize = this.minRubbleSize;
        }
        if (this.minFortifiedSpots < 0) {
            this.minFortifiedSpots = 0;
        }
        if (this.maxFortifiedSpots < this.minFortifiedSpots) {
            this.maxFortifiedSpots = this.minFortifiedSpots;
        }
        if (this.minFortifiedSize < 0) {
            this.minFortifiedSize = 0;
        }
        if (this.maxFortifiedSize < this.minFortifiedSize) {
            this.maxFortifiedSize = this.minFortifiedSize;
        }
        if (this.minIceSpots < 0) {
            this.minIceSpots = 0;
        }
        if (this.maxIceSpots < this.minIceSpots) {
            this.maxIceSpots = this.minIceSpots;
        }
        if (this.minIceSize < 0) {
            this.minIceSize = 0;
        }
        if (this.maxIceSize < this.minIceSize) {
            this.maxIceSize = this.minIceSize;
        }
        if (this.probRoad < 0) {
            this.probRoad = 0;
        }
        if (this.probRoad > 100) {
            this.probRoad = 100;
        }
        if (this.probInvert < 0) {
            this.probInvert = 0;
        }
        if (this.probInvert > 100) {
            this.probInvert = 100;
        }
        if (this.probRiver < 0) {
            this.probRiver = 0;
        }
        if (this.probRiver > 100) {
            this.probRiver = 100;
        }
        if (this.probCrater < 0) {
            this.probCrater = 0;
        }
        if (this.probCrater > 100) {
            this.probCrater = 100;
        }
        if (this.minRadius < 0) {
            this.minRadius = 0;
        }
        if (this.maxRadius < this.minRadius) {
            this.maxRadius = this.minRadius;
        }
        if (this.minCraters < 0) {
            this.minCraters = 0;
        }
        if (this.maxCraters < this.minCraters) {
            this.maxCraters = this.minCraters;
        }
        if (this.algorithmToUse < 0) {
            this.algorithmToUse = 0;
        }
        if (this.algorithmToUse > 2) {
            this.algorithmToUse = 2;
        }
    }

    public boolean equalMapGenParameters(MapSettings mapSettings) {
        return this.boardWidth == mapSettings.getBoardWidth() && this.boardHeight == mapSettings.getBoardHeight() && this.mapWidth == mapSettings.getMapWidth() && this.mapHeight == mapSettings.getMapHeight() && this.invertNegativeTerrain == mapSettings.getInvertNegativeTerrain() && this.hilliness == mapSettings.getHilliness() && this.cliffs == mapSettings.getCliffs() && this.range == mapSettings.getRange() && this.minWaterSpots == mapSettings.getMinWaterSpots() && this.maxWaterSpots == mapSettings.getMaxWaterSpots() && this.minWaterSize == mapSettings.getMinWaterSize() && this.maxWaterSize == mapSettings.getMaxWaterSize() && this.probDeep == mapSettings.getProbDeep() && this.minForestSpots == mapSettings.getMinForestSpots() && this.maxForestSpots == mapSettings.getMaxForestSpots() && this.minForestSize == mapSettings.getMinForestSize() && this.maxForestSize == mapSettings.getMaxForestSize() && this.probHeavy == mapSettings.getProbHeavy() && this.minRoughSpots == mapSettings.getMinRoughSpots() && this.maxRoughSpots == mapSettings.getMaxRoughSpots() && this.minRoughSize == mapSettings.getMinRoughSize() && this.maxRoughSize == mapSettings.getMaxRoughSize() && this.minSwampSpots == mapSettings.getMinSwampSpots() && this.maxSwampSpots == mapSettings.getMaxSwampSpots() && this.minSwampSize == mapSettings.getMinSwampSize() && this.maxSwampSize == mapSettings.getMaxSwampSize() && this.minPavementSpots == mapSettings.getMinPavementSpots() && this.maxPavementSpots == mapSettings.getMaxPavementSpots() && this.minPavementSize == mapSettings.getMinPavementSize() && this.maxPavementSize == mapSettings.getMaxPavementSize() && this.minRubbleSpots == mapSettings.getMinRubbleSpots() && this.maxRubbleSpots == mapSettings.getMaxRubbleSpots() && this.minRubbleSize == mapSettings.getMinRubbleSize() && this.maxRubbleSize == mapSettings.getMaxRubbleSize() && this.minFortifiedSpots == mapSettings.getMinFortifiedSpots() && this.maxFortifiedSpots == mapSettings.getMaxFortifiedSpots() && this.minFortifiedSize == mapSettings.getMinFortifiedSize() && this.maxFortifiedSize == mapSettings.getMaxFortifiedSize() && this.minIceSpots == mapSettings.getMinIceSpots() && this.maxIceSpots == mapSettings.getMaxIceSpots() && this.minIceSize == mapSettings.getMinIceSize() && this.maxIceSize == mapSettings.getMaxIceSize() && this.probRoad == mapSettings.getProbRoad() && this.probInvert == mapSettings.getProbInvert() && this.probRiver == mapSettings.getProbRiver() && this.probCrater == mapSettings.getProbCrater() && this.minRadius == mapSettings.getMinRadius() && this.maxRadius == mapSettings.getMaxRadius() && this.minCraters == mapSettings.getMinCraters() && this.maxCraters == mapSettings.getMaxCraters() && this.theme.equals(mapSettings.getTheme()) && this.fxMod == mapSettings.getFxMod() && this.cityBlocks == mapSettings.getCityBlocks() && this.cityType == mapSettings.getCityType() && this.cityMinCF == mapSettings.getCityMinCF() && this.cityMaxCF == mapSettings.getCityMaxCF() && this.cityMinFloors == mapSettings.getCityMinFloors() && this.cityMaxFloors == mapSettings.getCityMaxFloors() && this.cityDensity == mapSettings.getCityDensity() && this.probFlood == mapSettings.getProbFlood() && this.probForestFire == mapSettings.getProbForestFire() && this.probFreeze == mapSettings.getProbFreeze() && this.probDrought == mapSettings.getProbDrought() && this.algorithmToUse == mapSettings.getAlgorithmToUse() && this.mountainHeightMin == mapSettings.getMountainHeightMin() && this.mountainHeightMax == mapSettings.getMountainHeightMax() && this.mountainPeaks == mapSettings.getMountainPeaks() && this.mountainStyle == mapSettings.getMountainStyle() && this.mountainWidthMin == mapSettings.getMountainWidthMin() && this.mountainWidthMax == mapSettings.getMountainWidthMax() && this.boardBuildings == mapSettings.getBoardBuildings();
    }

    public Object clone() {
        return new MapSettings(this);
    }

    public int getInvertNegativeTerrain() {
        return this.invertNegativeTerrain;
    }

    public int getHilliness() {
        return this.hilliness;
    }

    public int getCliffs() {
        return this.cliffs;
    }

    public int getRange() {
        return this.range;
    }

    public int getProbInvert() {
        return this.probInvert;
    }

    public int getMinWaterSpots() {
        return this.minWaterSpots;
    }

    public int getMaxWaterSpots() {
        return this.maxWaterSpots;
    }

    public int getMinWaterSize() {
        return this.minWaterSize;
    }

    public int getMaxWaterSize() {
        return this.maxWaterSize;
    }

    public int getProbDeep() {
        return this.probDeep;
    }

    public int getMinForestSpots() {
        return this.minForestSpots;
    }

    public int getMaxForestSpots() {
        return this.maxForestSpots;
    }

    public int getMinForestSize() {
        return this.minForestSize;
    }

    public int getMaxForestSize() {
        return this.maxForestSize;
    }

    public int getProbHeavy() {
        return this.probHeavy;
    }

    public int getMinRoughSpots() {
        return this.minRoughSpots;
    }

    public int getMaxRoughSpots() {
        return this.maxRoughSpots;
    }

    public int getMinRoughSize() {
        return this.minRoughSize;
    }

    public int getMaxRoughSize() {
        return this.maxRoughSize;
    }

    public int getMinSwampSpots() {
        return this.minSwampSpots;
    }

    public int getMaxSwampSpots() {
        return this.maxSwampSpots;
    }

    public int getMinSwampSize() {
        return this.minSwampSize;
    }

    public int getMaxSwampSize() {
        return this.maxSwampSize;
    }

    public int getMinPavementSpots() {
        return this.minPavementSpots;
    }

    public int getMaxPavementSpots() {
        return this.maxPavementSpots;
    }

    public int getMinPavementSize() {
        return this.minPavementSize;
    }

    public int getMaxPavementSize() {
        return this.maxPavementSize;
    }

    public int getMinRubbleSpots() {
        return this.minRubbleSpots;
    }

    public int getMaxRubbleSpots() {
        return this.maxRubbleSpots;
    }

    public int getMinRubbleSize() {
        return this.minRubbleSize;
    }

    public int getMaxRubbleSize() {
        return this.maxRubbleSize;
    }

    public int getMinFortifiedSpots() {
        return this.minFortifiedSpots;
    }

    public int getMaxFortifiedSpots() {
        return this.maxFortifiedSpots;
    }

    public int getMinFortifiedSize() {
        return this.minFortifiedSize;
    }

    public int getMaxFortifiedSize() {
        return this.maxFortifiedSize;
    }

    public int getMinIceSpots() {
        return this.minIceSpots;
    }

    public int getMaxIceSpots() {
        return this.maxIceSpots;
    }

    public int getMinIceSize() {
        return this.minIceSize;
    }

    public int getMaxIceSize() {
        return this.maxIceSize;
    }

    public int getProbRoad() {
        return this.probRoad;
    }

    public int getProbRiver() {
        return this.probRiver;
    }

    public int getProbCrater() {
        return this.probCrater;
    }

    public int getMinRadius() {
        return this.minRadius;
    }

    public int getMaxRadius() {
        return this.maxRadius;
    }

    public int getMinCraters() {
        return this.minCraters;
    }

    public int getMaxCraters() {
        return this.maxCraters;
    }

    public int getAlgorithmToUse() {
        return this.algorithmToUse;
    }

    public int getProbFlood() {
        return this.probFlood;
    }

    public int getProbForestFire() {
        return this.probForestFire;
    }

    public int getProbFreeze() {
        return this.probFreeze;
    }

    public int getProbDrought() {
        return this.probDrought;
    }

    public int getFxMod() {
        return this.fxMod;
    }

    public int getCityBlocks() {
        return this.cityBlocks;
    }

    public String getCityType() {
        return this.cityType;
    }

    public int getCityMinCF() {
        return this.cityMinCF;
    }

    public int getCityMaxCF() {
        return this.cityMaxCF;
    }

    public int getCityMinFloors() {
        return this.cityMinFloors;
    }

    public int getCityMaxFloors() {
        return this.cityMaxFloors;
    }

    public int getCityDensity() {
        return this.cityDensity;
    }

    public int getTownSize() {
        return this.townSize;
    }

    public int getMountainHeightMin() {
        return this.mountainHeightMin;
    }

    public int getMountainHeightMax() {
        return this.mountainHeightMax;
    }

    public int getMountainPeaks() {
        return this.mountainPeaks;
    }

    public int getMountainStyle() {
        return this.mountainStyle;
    }

    public int getMountainWidthMin() {
        return this.mountainWidthMin;
    }

    public int getMountainWidthMax() {
        return this.mountainWidthMax;
    }

    public void setElevationParams(int n, int n2, int n3) {
        this.hilliness = n;
        this.range = n2;
        this.probInvert = n3;
    }

    public void setWaterParams(int n, int n2, int n3, int n4, int n5) {
        this.minWaterSpots = n;
        this.maxWaterSpots = n2;
        this.minWaterSize = n3;
        this.maxWaterSize = n4;
        this.probDeep = n5;
    }

    public void setForestParams(int n, int n2, int n3, int n4, int n5) {
        this.minForestSpots = n;
        this.maxForestSpots = n2;
        this.minForestSize = n3;
        this.maxForestSize = n4;
        this.probHeavy = n5;
    }

    public void setRoughParams(int n, int n2, int n3, int n4) {
        this.minRoughSpots = n;
        this.maxRoughSpots = n2;
        this.minRoughSize = n3;
        this.maxRoughSize = n4;
    }

    public void setSwampParams(int n, int n2, int n3, int n4) {
        this.minSwampSpots = n;
        this.maxSwampSpots = n2;
        this.minSwampSize = n3;
        this.maxSwampSize = n4;
    }

    public void setPavementParams(int n, int n2, int n3, int n4) {
        this.minPavementSpots = n;
        this.maxPavementSpots = n2;
        this.minPavementSize = n3;
        this.maxPavementSize = n4;
    }

    public void setRubbleParams(int n, int n2, int n3, int n4) {
        this.minRubbleSpots = n;
        this.maxRubbleSpots = n2;
        this.minRubbleSize = n3;
        this.maxRubbleSize = n4;
    }

    public void setFortifiedParams(int n, int n2, int n3, int n4) {
        this.minFortifiedSpots = n;
        this.maxFortifiedSpots = n2;
        this.minFortifiedSize = n3;
        this.maxFortifiedSize = n4;
    }

    public void setIceParams(int n, int n2, int n3, int n4) {
        this.minIceSpots = n;
        this.maxIceSpots = n2;
        this.minIceSize = n3;
        this.maxIceSize = n4;
    }

    public void setRiverParam(int n) {
        this.probRiver = n;
    }

    public void setRoadParam(int n) {
        this.probRoad = n;
    }

    public void setCliffParam(int n) {
        this.cliffs = n;
    }

    public void setCraterParam(int n, int n2, int n3, int n4, int n5) {
        this.probCrater = n;
        this.maxCraters = n3;
        this.minCraters = n2;
        this.minRadius = n4;
        this.maxRadius = n5;
    }

    public void setInvertNegativeTerrain(int n) {
        this.invertNegativeTerrain = n;
    }

    public void setSpecialFX(int n, int n2, int n3, int n4, int n5) {
        this.fxMod = n;
        this.probForestFire = n2;
        this.probFreeze = n3;
        this.probFlood = n4;
        this.probDrought = n5;
    }

    public void setAlgorithmToUse(int n) {
        this.algorithmToUse = n;
    }

    public void setCityParams(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.cityBlocks = n;
        this.cityType = string;
        this.cityMinCF = n2;
        this.cityMaxCF = n3;
        this.cityMinFloors = n4;
        this.cityMaxFloors = n5;
        this.cityDensity = n6;
        this.townSize = n7;
    }

    public void setMountainParams(int n, int n2, int n3, int n4, int n5, int n6) {
        this.mountainHeightMax = n5;
        this.mountainHeightMin = n4;
        this.mountainWidthMin = n2;
        this.mountainWidthMax = n3;
        this.mountainPeaks = n;
        this.mountainStyle = n6;
    }

    public void save(OutputStream outputStream) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            bufferedWriter.write("<?xml version=\"1.0\"?>");
            bufferedWriter.write("\r\n");
            bufferedWriter.write("<ENVIRONMENT>");
            bufferedWriter.write("\r\n");
            this.saveParameter(bufferedWriter, "THEME", this.theme);
            this.saveParameter(bufferedWriter, "INVERTNEGATIVETERRAIN", Autobox.valueOf((int)this.invertNegativeTerrain));
            this.saveParameter(bufferedWriter, "HILLYNESS", Autobox.valueOf((int)this.hilliness));
            this.saveParameter(bufferedWriter, "HILLELEVATIONRANGE", Autobox.valueOf((int)this.range));
            this.saveParameter(bufferedWriter, "HILLINVERTPROB", Autobox.valueOf((int)this.probInvert));
            this.saveParameter(bufferedWriter, "ALGORITHM", Autobox.valueOf((int)this.algorithmToUse));
            this.saveParameter(bufferedWriter, "CLIFFS", Autobox.valueOf((int)this.cliffs));
            this.saveParameter(bufferedWriter, "FORESTMINSPOTS", Autobox.valueOf((int)this.minForestSpots));
            this.saveParameter(bufferedWriter, "FORESTMAXSPOTS", Autobox.valueOf((int)this.maxForestSpots));
            this.saveParameter(bufferedWriter, "FORESTMINHEXES", Autobox.valueOf((int)this.minForestSize));
            this.saveParameter(bufferedWriter, "FORESTMAXHEXES", Autobox.valueOf((int)this.maxForestSize));
            this.saveParameter(bufferedWriter, "FORESTHEAVYPROB", Autobox.valueOf((int)this.probHeavy));
            this.saveParameter(bufferedWriter, "ROUGHMINSPOTS", Autobox.valueOf((int)this.minRoughSpots));
            this.saveParameter(bufferedWriter, "ROUGHMAXSPOTS", Autobox.valueOf((int)this.maxRoughSpots));
            this.saveParameter(bufferedWriter, "ROUGHMINHEXES", Autobox.valueOf((int)this.minRoughSize));
            this.saveParameter(bufferedWriter, "ROUGHMAXHEXES", Autobox.valueOf((int)this.maxRoughSize));
            this.saveParameter(bufferedWriter, "SWAMPMINSPOTS", Autobox.valueOf((int)this.minSwampSpots));
            this.saveParameter(bufferedWriter, "SWAMPMAXSPOTS", Autobox.valueOf((int)this.maxSwampSpots));
            this.saveParameter(bufferedWriter, "SWAMPMINHEXES", Autobox.valueOf((int)this.minSwampSize));
            this.saveParameter(bufferedWriter, "SWAMPMAXHEXES", Autobox.valueOf((int)this.maxSwampSize));
            this.saveParameter(bufferedWriter, "ROADPROB", Autobox.valueOf((int)this.probRoad));
            this.saveParameter(bufferedWriter, "WATERMINSPOTS", Autobox.valueOf((int)this.minWaterSpots));
            this.saveParameter(bufferedWriter, "WATERMAXSPOTS", Autobox.valueOf((int)this.maxWaterSpots));
            this.saveParameter(bufferedWriter, "WATERMINHEXES", Autobox.valueOf((int)this.minWaterSize));
            this.saveParameter(bufferedWriter, "WATERMAXHEXES", Autobox.valueOf((int)this.maxWaterSize));
            this.saveParameter(bufferedWriter, "WATERDEEPPROB", Autobox.valueOf((int)this.probDeep));
            this.saveParameter(bufferedWriter, "RIVERPROB", Autobox.valueOf((int)this.probRiver));
            this.saveParameter(bufferedWriter, "CRATERMINNUM", Autobox.valueOf((int)this.minCraters));
            this.saveParameter(bufferedWriter, "CRATERMAXNUM", Autobox.valueOf((int)this.maxCraters));
            this.saveParameter(bufferedWriter, "CRATERMINRADIUS", Autobox.valueOf((int)this.minRadius));
            this.saveParameter(bufferedWriter, "CRATERMAXRADIUS", Autobox.valueOf((int)this.maxRadius));
            this.saveParameter(bufferedWriter, "CRATEPROB", Autobox.valueOf((int)this.probCrater));
            this.saveParameter(bufferedWriter, "PAVEMENTMINSPOTS", Autobox.valueOf((int)this.minPavementSpots));
            this.saveParameter(bufferedWriter, "PAVEMENTMAXSPOTS", Autobox.valueOf((int)this.maxPavementSpots));
            this.saveParameter(bufferedWriter, "PAVEMENTMINHEXES", Autobox.valueOf((int)this.minPavementSize));
            this.saveParameter(bufferedWriter, "PAVEMENTMAXHEXES", Autobox.valueOf((int)this.maxPavementSize));
            this.saveParameter(bufferedWriter, "RUBBLEMINSPOTS", Autobox.valueOf((int)this.minRubbleSpots));
            this.saveParameter(bufferedWriter, "RUBBLEMAXSPOTS", Autobox.valueOf((int)this.maxRubbleSpots));
            this.saveParameter(bufferedWriter, "RUBBLEMINHEXES", Autobox.valueOf((int)this.minRubbleSize));
            this.saveParameter(bufferedWriter, "RUBBLEMAXHEXES", Autobox.valueOf((int)this.maxRubbleSize));
            this.saveParameter(bufferedWriter, "FORTIFIEDMINSPOTS", Autobox.valueOf((int)this.minFortifiedSpots));
            this.saveParameter(bufferedWriter, "FORTIFIEDMAXSPOTS", Autobox.valueOf((int)this.maxFortifiedSpots));
            this.saveParameter(bufferedWriter, "FORTIFIEDMINHEXES", Autobox.valueOf((int)this.minFortifiedSize));
            this.saveParameter(bufferedWriter, "FORTIFIEDMAXHEXES", Autobox.valueOf((int)this.maxFortifiedSize));
            this.saveParameter(bufferedWriter, "ICEMINSPOTS", Autobox.valueOf((int)this.minIceSpots));
            this.saveParameter(bufferedWriter, "ICEMAXSPOTS", Autobox.valueOf((int)this.maxIceSpots));
            this.saveParameter(bufferedWriter, "ICEMINHEXES", Autobox.valueOf((int)this.minIceSize));
            this.saveParameter(bufferedWriter, "ICEMAXHEXES", Autobox.valueOf((int)this.maxIceSize));
            this.saveParameter(bufferedWriter, "FXMOD", Autobox.valueOf((int)this.fxMod));
            this.saveParameter(bufferedWriter, "PROBFREEZE", Autobox.valueOf((int)this.probFreeze));
            this.saveParameter(bufferedWriter, "PROBFLOOD", Autobox.valueOf((int)this.probFlood));
            this.saveParameter(bufferedWriter, "PROBFORESTFIRE", Autobox.valueOf((int)this.probForestFire));
            this.saveParameter(bufferedWriter, "PROBDROUGHT", Autobox.valueOf((int)this.probDrought));
            this.saveParameter(bufferedWriter, "CITYTYPE", this.cityType);
            this.saveParameter(bufferedWriter, "CITYBLOCKS", Autobox.valueOf((int)this.cityBlocks));
            this.saveParameter(bufferedWriter, "CITYDENSITY", Autobox.valueOf((int)this.cityDensity));
            this.saveParameter(bufferedWriter, "MINCF", Autobox.valueOf((int)this.cityMinCF));
            this.saveParameter(bufferedWriter, "MAXCF", Autobox.valueOf((int)this.cityMaxCF));
            this.saveParameter(bufferedWriter, "MINFLOORS", Autobox.valueOf((int)this.cityMinFloors));
            this.saveParameter(bufferedWriter, "MAXFLOORS", Autobox.valueOf((int)this.cityMaxFloors));
            this.saveParameter(bufferedWriter, "TOWNSIZE", Autobox.valueOf((int)this.townSize));
            this.saveParameter(bufferedWriter, "MOUNTPEAKS", Autobox.valueOf((int)this.mountainPeaks));
            this.saveParameter(bufferedWriter, "MOUNTWIDTHMIN", Autobox.valueOf((int)this.mountainWidthMin));
            this.saveParameter(bufferedWriter, "MOUNTWIDTHMAX", Autobox.valueOf((int)this.mountainWidthMax));
            this.saveParameter(bufferedWriter, "MOUNTHEIGHTMIN", Autobox.valueOf((int)this.mountainHeightMin));
            this.saveParameter(bufferedWriter, "MOUNTHEIGHTMAX", Autobox.valueOf((int)this.mountainHeightMax));
            this.saveParameter(bufferedWriter, "MOUNTSTYLE", Autobox.valueOf((int)this.mountainStyle));
            bufferedWriter.write("</ENVIRONMENT>");
            bufferedWriter.write("\r\n");
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveParameter(Writer writer, String string, Object object) throws IOException {
        writer.write("    <");
        writer.write(string);
        writer.write(">");
        writer.write(object.toString());
        writer.write("</");
        writer.write(string);
        writer.write(">");
        writer.write("\r\n");
    }

    public void load(InputStream inputStream) {
        ParsedXML parsedXML = null;
        try {
            parsedXML = TinyParser.parseXML((InputStream)inputStream);
        }
        catch (ParseException parseException) {
            System.err.println("Error parsing map settings xml file.");
            parseException.printStackTrace();
            return;
        }
        Enumeration enumeration = parsedXML.elements();
        ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
        if (parsedXML2.getName().equals("ENVIRONMENT")) {
            Enumeration enumeration2 = parsedXML2.elements();
            while (enumeration2.hasMoreElements()) {
                try {
                    this.parseEnvironmentNode((ParsedXML)enumeration2.nextElement());
                }
                catch (Exception exception) {
                    System.err.println("error in map settings file:");
                    exception.printStackTrace();
                }
            }
        } else {
            System.out.println("Root node of map settings file is incorrectly named. Name should be 'ENVIRONMENT' but name is '" + parsedXML2.getName() + "'");
        }
    }

    private void parseEnvironmentNode(ParsedXML parsedXML) {
        Enumeration enumeration = parsedXML.elements();
        if (!enumeration.hasMoreElements()) {
            return;
        }
        ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
        String string = parsedXML2.getContent();
        if (null == string) {
            return;
        }
        String string2 = parsedXML.getName();
        if (string2.equals("THEME")) {
            this.theme = string;
        } else if (string2.equals("INVERTNEGATIVETERRAIN")) {
            this.invertNegativeTerrain = Integer.valueOf(string);
        } else if (string2.equals("HILLYNESS")) {
            this.hilliness = Integer.valueOf(string);
        } else if (string2.equals("HILLELEVATIONRANGE")) {
            this.range = Integer.valueOf(string);
        } else if (string2.equals("HILLINVERTPROB")) {
            this.probInvert = Integer.valueOf(string);
        } else if (string2.equals("ALGORITHM")) {
            this.algorithmToUse = Integer.valueOf(string);
        } else if (string2.equals("CLIFFS")) {
            this.cliffs = Integer.valueOf(string);
        } else if (string2.equals("FORESTMINSPOTS")) {
            this.minForestSpots = Integer.valueOf(string);
        } else if (string2.equals("FORESTMAXSPOTS")) {
            this.maxForestSpots = Integer.valueOf(string);
        } else if (string2.equals("FORESTMINHEXES")) {
            this.minForestSize = Integer.valueOf(string);
        } else if (string2.equals("FORESTMAXHEXES")) {
            this.maxForestSize = Integer.valueOf(string);
        } else if (string2.equals("FORESTHEAVYPROB")) {
            this.probHeavy = Integer.valueOf(string);
        } else if (string2.equals("ROUGHMINSPOTS")) {
            this.minRoughSpots = Integer.valueOf(string);
        } else if (string2.equals("ROUGHMAXSPOTS")) {
            this.maxRoughSpots = Integer.valueOf(string);
        } else if (string2.equals("ROUGHMINHEXES")) {
            this.minRoughSize = Integer.valueOf(string);
        } else if (string2.equals("ROUGHMAXHEXES")) {
            this.maxRoughSize = Integer.valueOf(string);
        } else if (string2.equals("SWAMPMINSPOTS")) {
            this.minSwampSpots = Integer.valueOf(string);
        } else if (string2.equals("SWAMPMAXSPOTS")) {
            this.maxSwampSpots = Integer.valueOf(string);
        } else if (string2.equals("SWAMPMINHEXES")) {
            this.minSwampSize = Integer.valueOf(string);
        } else if (string2.equals("SWAMPMAXHEXES")) {
            this.maxSwampSize = Integer.valueOf(string);
        } else if (string2.equals("ROADPROB")) {
            this.probRoad = Integer.valueOf(string);
        } else if (string2.equals("WATERMINSPOTS")) {
            this.minWaterSpots = Integer.valueOf(string);
        } else if (string2.equals("WATERMAXSPOTS")) {
            this.maxWaterSpots = Integer.valueOf(string);
        } else if (string2.equals("WATERMINHEXES")) {
            this.minWaterSize = Integer.valueOf(string);
        } else if (string2.equals("WATERMAXHEXES")) {
            this.maxWaterSize = Integer.valueOf(string);
        } else if (string2.equals("WATERDEEPPROB")) {
            this.probDeep = Integer.valueOf(string);
        } else if (string2.equals("RIVERPROB")) {
            this.probRiver = Integer.valueOf(string);
        } else if (string2.equals("CRATERMINNUM")) {
            this.minCraters = Integer.valueOf(string);
        } else if (string2.equals("CRATERMAXNUM")) {
            this.maxCraters = Integer.valueOf(string);
        } else if (string2.equals("CRATERMINRADIUS")) {
            this.minRadius = Integer.valueOf(string);
        } else if (string2.equals("CRATERMAXRADIUS")) {
            this.maxRadius = Integer.valueOf(string);
        } else if (string2.equals("CRATEPROB")) {
            this.probCrater = Integer.valueOf(string);
        } else if (string2.equals("PAVEMENTMINSPOTS")) {
            this.minPavementSpots = Integer.valueOf(string);
        } else if (string2.equals("PAVEMENTMAXSPOTS")) {
            this.maxPavementSpots = Integer.valueOf(string);
        } else if (string2.equals("PAVEMENTMINHEXES")) {
            this.minPavementSize = Integer.valueOf(string);
        } else if (string2.equals("PAVEMENTMAXHEXES")) {
            this.maxPavementSize = Integer.valueOf(string);
        } else if (string2.equals("RUBBLEMINSPOTS")) {
            this.minRubbleSpots = Integer.valueOf(string);
        } else if (string2.equals("RUBBLEMAXSPOTS")) {
            this.maxRubbleSpots = Integer.valueOf(string);
        } else if (string2.equals("RUBBLEMINHEXES")) {
            this.minRubbleSize = Integer.valueOf(string);
        } else if (string2.equals("RUBBLEMAXHEXES")) {
            this.maxRubbleSize = Integer.valueOf(string);
        } else if (string2.equals("FORTIFIEDMINSPOTS")) {
            this.minFortifiedSpots = Integer.valueOf(string);
        } else if (string2.equals("FORTIFIEDMAXSPOTS")) {
            this.maxFortifiedSpots = Integer.valueOf(string);
        } else if (string2.equals("FORTIFIEDMINHEXES")) {
            this.minFortifiedSize = Integer.valueOf(string);
        } else if (string2.equals("FORTIFIEDMAXHEXES")) {
            this.maxFortifiedSize = Integer.valueOf(string);
        } else if (string2.equals("ICEMINSPOTS")) {
            this.minIceSpots = Integer.valueOf(string);
        } else if (string2.equals("ICEMAXSPOTS")) {
            this.maxIceSpots = Integer.valueOf(string);
        } else if (string2.equals("ICEMINHEXES")) {
            this.minIceSize = Integer.valueOf(string);
        } else if (string2.equals("ICEMAXHEXES")) {
            this.maxIceSize = Integer.valueOf(string);
        } else if (string2.equals("FXMOD")) {
            this.fxMod = Integer.valueOf(string);
        } else if (string2.equals("PROBFREEZE")) {
            this.probFreeze = Integer.valueOf(string);
        } else if (string2.equals("PROBFLOOD")) {
            this.probFlood = Integer.valueOf(string);
        } else if (string2.equals("PROBFORESTFIRE")) {
            this.probForestFire = Integer.valueOf(string);
        } else if (string2.equals("PROBDROUGHT")) {
            this.probDrought = Integer.valueOf(string);
        } else if (string2.equals("CITYTYPE")) {
            this.cityType = string;
        } else if (string2.equals("CITYBLOCKS")) {
            this.cityBlocks = Integer.valueOf(string);
        } else if (string2.equals("CITYDENSITY")) {
            this.cityDensity = Integer.valueOf(string);
        } else if (string2.equals("MINCF")) {
            this.cityMinCF = Integer.valueOf(string);
        } else if (string2.equals("MAXCF")) {
            this.cityMaxCF = Integer.valueOf(string);
        } else if (string2.equals("MINFLOORS")) {
            this.cityMinFloors = Integer.valueOf(string);
        } else if (string2.equals("MAXFLOORS")) {
            this.cityMaxFloors = Integer.valueOf(string);
        } else if (string2.equals("TOWNSIZE")) {
            this.townSize = Integer.valueOf(string);
        } else if (string2.equals("MOUNTPEAKS")) {
            this.mountainPeaks = Integer.valueOf(string);
        } else if (string2.equals("MOUNTWIDTHMIN")) {
            this.mountainWidthMin = Integer.valueOf(string);
        } else if (string2.equals("MOUNTWIDTHMAX")) {
            this.mountainWidthMax = Integer.valueOf(string);
        } else if (string2.equals("MOUNTHEIGHTMIN")) {
            this.mountainHeightMin = Integer.valueOf(string);
        } else if (string2.equals("MOUNTHEIGHTMAX")) {
            this.mountainHeightMax = Integer.valueOf(string);
        } else if (string2.equals("MOUNTSTYLE")) {
            this.mountainStyle = Integer.valueOf(string);
        }
    }

    void loadStringParameter(ParsedXML parsedXML, String string, String string2) {
        if (parsedXML.getName().equals(string)) {
            string2 = parsedXML.getContent();
        }
    }

    void loadIntParameter(ParsedXML parsedXML, String string, Integer n) {
        if (parsedXML.getName().equals(string)) {
            n = Integer.valueOf(parsedXML.getContent());
        }
    }
}

