/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.PrintWriter;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmorHandles;
import megamek.common.BipedMech;
import megamek.common.Compute;
import megamek.common.CriticalSlot;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentMessages;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.IHex;
import megamek.common.LocationFullException;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.PilotingRollData;
import megamek.common.QuadMech;
import megamek.common.Report;
import megamek.common.TargetRoll;
import megamek.common.TechConstants;
import megamek.common.WeaponType;
import megamek.common.loaders.MtfFile;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.StringUtil;

public abstract class Mech
extends Entity
implements Serializable {
    public static final int NUM_MECH_LOCATIONS = 8;
    public static final int SYSTEM_LIFE_SUPPORT = 0;
    public static final int SYSTEM_SENSORS = 1;
    public static final int SYSTEM_COCKPIT = 2;
    public static final int SYSTEM_ENGINE = 3;
    public static final int SYSTEM_GYRO = 4;
    public static final int ACTUATOR_SHOULDER = 7;
    public static final int ACTUATOR_UPPER_ARM = 8;
    public static final int ACTUATOR_LOWER_ARM = 9;
    public static final int ACTUATOR_HAND = 10;
    public static final int ACTUATOR_HIP = 11;
    public static final int ACTUATOR_UPPER_LEG = 12;
    public static final int ACTUATOR_LOWER_LEG = 13;
    public static final int ACTUATOR_FOOT = 14;
    public static final String[] systemNames = new String[]{"Life Support", "Sensors", "Cockpit", "Engine", "Gyro", null, null, "Shoulder", "Upper Arm", "Lower Arm", "Hand", "Hip", "Upper Leg", "Lower Leg", "Foot"};
    public static final int LOC_HEAD = 0;
    public static final int LOC_CT = 1;
    public static final int LOC_RT = 2;
    public static final int LOC_LT = 3;
    public static final int LOC_RARM = 4;
    public static final int LOC_LARM = 5;
    public static final int LOC_RLEG = 6;
    public static final int LOC_LLEG = 7;
    public static final int COCKPIT_OFF = 0;
    public static final int COCKPIT_ON = 1;
    public static final int COCKPIT_AIMED_SHOT = 2;
    public static final int GYRO_UNKNOWN = -1;
    public static final int GYRO_STANDARD = 0;
    public static final int GYRO_XL = 1;
    public static final int GYRO_COMPACT = 2;
    public static final int GYRO_HEAVY_DUTY = 3;
    public static final String[] GYRO_STRING = new String[]{"Standard Gyro", "XL Gyro", "Compact Gyro", "Heavy Duty Gyro"};
    public static final String[] GYRO_SHORT_STRING = new String[]{"Standard", "XL", "Compact", "Heavy Duty"};
    public static final int COCKPIT_UNKNOWN = -1;
    public static final int COCKPIT_STANDARD = 0;
    public static final int COCKPIT_TORSO_MOUNTED = 1;
    public static final int COCKPIT_SMALL = 2;
    public static final int COCKPIT_COMMAND_CONSOLE = 3;
    public static final int COCKPIT_DUAL = 4;
    public static final String[] COCKPIT_STRING = new String[]{"Standard Cockpit", "Torso-Mounted Cockpit", "Small Cockpit", "Command Console", "Dual Cockpit"};
    public static final String[] COCKPIT_SHORT_STRING = new String[]{"Standard", "Torso Mounted", "Small", "Command Console", "Dual"};
    public static final String STEALTH = "Stealth";
    public static final String NULLSIG = "Mek Null Signature System";
    public static final int JUMP_UNKNOWN = -1;
    public static final int JUMP_NONE = 0;
    public static final int JUMP_STANDARD = 1;
    public static final int JUMP_IMPROVED = 2;
    public static final int JUMP_BOOSTER = 3;
    public static final int JUMP_DISPOSABLE = 4;
    public static final int HAS_FALSE = -1;
    public static final int HAS_UNKNOWN = 0;
    public static final int HAS_TRUE = 1;
    private int[] rearArmor;
    private int[] orig_rearArmor;
    private static int[] MASC_FAILURE = new int[]{2, 4, 6, 10, 12, 12, 12};
    private int nMASCLevel = 0;
    private boolean bMASCWentUp = false;
    private boolean usedMASC = false;
    private int sinksOn = -1;
    private int sinksOnNextRound = -1;
    private boolean autoEject = true;
    private int cockpitStatus = 1;
    private int cockpitStatusNextRound = 1;
    private int jumpType = -1;
    private int gyroType = 0;
    private int cockpitType = 0;
    private boolean hasCowl = false;
    private int cowlArmor = 0;
    private int hasLaserHeatSinks = 0;
    private int grappled_id = -1;
    private boolean isGrappleAttacker = false;
    private static final NumberFormat commafy = NumberFormat.getInstance();

    public Mech() {
        this(0, 0);
    }

    public Mech(int n, int n2) {
        this.gyroType = n;
        this.cockpitType = n2;
        this.rearArmor = new int[this.locations()];
        this.orig_rearArmor = new int[this.locations()];
        for (int i = 0; i < this.locations(); ++i) {
            if (this.hasRearArmor(i)) continue;
            this.initializeRearArmor(-1, i);
        }
        this.setCritical(6, 0, new CriticalSlot(0, 11));
        this.setCritical(6, 1, new CriticalSlot(0, 12));
        this.setCritical(6, 2, new CriticalSlot(0, 13));
        this.setCritical(6, 3, new CriticalSlot(0, 14));
        this.setCritical(7, 0, new CriticalSlot(0, 11));
        this.setCritical(7, 1, new CriticalSlot(0, 12));
        this.setCritical(7, 2, new CriticalSlot(0, 13));
        this.setCritical(7, 3, new CriticalSlot(0, 14));
        this.autoEject = !PreferenceManager.getClientPreferences().defaultAutoejectDisabled();
    }

    public void setCowl(int n) {
        this.hasCowl = true;
        this.cowlArmor = n;
    }

    public int getCowlArmor() {
        if (this.hasCowl) {
            return this.cowlArmor;
        }
        return 0;
    }

    public boolean hasCowl() {
        return this.hasCowl;
    }

    public int damageCowl(int n) {
        if (this.hasCowl) {
            if (n < this.cowlArmor) {
                this.cowlArmor -= n;
                return 0;
            }
            this.cowlArmor = 0;
            return n -= this.cowlArmor;
        }
        return n;
    }

    public static int getInnerLocation(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return 1;
            }
            case 5: 
            case 7: {
                return 3;
            }
            case 4: 
            case 6: {
                return 2;
            }
        }
        return n;
    }

    public static int mostRestrictiveLoc(int n, int n2) {
        if (n == n2) {
            return n;
        }
        if (Mech.restrictScore(n) >= Mech.restrictScore(n2)) {
            return n;
        }
        return n2;
    }

    public static int leastRestrictiveLoc(int n, int n2) {
        if (n == n2) {
            return n2;
        }
        if (Mech.restrictScore(n) >= Mech.restrictScore(n2)) {
            return n2;
        }
        return n;
    }

    public static int restrictScore(int n) {
        switch (n) {
            case 4: 
            case 5: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 3;
    }

    public int getMASCTurns() {
        return this.nMASCLevel;
    }

    public void setMASCTurns(int n) {
        this.nMASCLevel = n;
    }

    public boolean isMASCUsed() {
        return this.usedMASC;
    }

    public void setMASCUsed(boolean bl) {
        this.usedMASC = bl;
    }

    public int getMASCTarget() {
        return MASC_FAILURE[this.nMASCLevel] + 1;
    }

    public boolean checkForMASCFailure(MovePath movePath, Vector vector, Vector vector2) {
        if (movePath.hasActiveMASC()) {
            boolean bl = false;
            if (!this.usedMASC) {
                Mounted mounted = this.getMASC();
                int n = Compute.d6(2);
                this.usedMASC = true;
                Report report = new Report(2365);
                report.subject = this.getId();
                report.addDesc(this);
                report.add(mounted.getName());
                vector.addElement(report);
                report = new Report(2370);
                report.subject = this.getId();
                report.indent();
                report.add(this.getMASCTarget());
                report.add(n);
                if (n < this.getMASCTarget()) {
                    bl = true;
                    report.choose(false);
                    vector.addElement(report);
                    if (((MiscType)mounted.getType()).hasSubType(1)) {
                        int n2 = 0;
                        int n3 = Compute.d6(2);
                        report = new Report(6310);
                        report.subject = this.getId();
                        report.add(n3);
                        report.newlines = 0;
                        vector.addElement(report);
                        if (n3 <= 7) {
                            report = new Report(6005);
                            report.subject = this.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                        } else if (n3 >= 8 && n3 <= 9) {
                            n2 = 1;
                            report = new Report(6315);
                            report.subject = this.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                        } else if (n3 >= 10 && n3 <= 11) {
                            n2 = 2;
                            report = new Report(6320);
                            report.subject = this.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                        } else if (n3 == 12) {
                            n2 = 3;
                            report = new Report(6325);
                            report.subject = this.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                        }
                        for (int i = 0; i < 12 && n2 > 0; ++i) {
                            CriticalSlot criticalSlot = this.getCritical(1, i);
                            if (criticalSlot.getType() != 0 || criticalSlot.getIndex() != 3) continue;
                            vector2.add(new Integer(1));
                            vector2.add(criticalSlot);
                            --n2;
                        }
                    } else {
                        vector2.add(new Integer(6));
                        vector2.add(this.getCritical(6, 0));
                        vector2.add(new Integer(7));
                        vector2.add(this.getCritical(7, 0));
                        if (this instanceof QuadMech) {
                            vector2.add(new Integer(4));
                            vector2.add(this.getCritical(4, 0));
                            vector2.add(new Integer(5));
                            vector2.add(this.getCritical(5, 0));
                        }
                    }
                    if (mounted.getType().hasFlag(16L)) {
                        mounted.setDestroyed(true);
                        mounted.setMode("Off");
                    }
                } else {
                    report.choose(true);
                    vector.addElement(report);
                }
            }
            return bl;
        }
        return false;
    }

    public void setOmni(boolean bl) {
        super.setOmni(bl);
        if (bl && !this.hasBattleArmorHandles()) {
            this.addTransporter(new BattleArmorHandles());
        }
    }

    public int locations() {
        return 8;
    }

    public void newRound(int n) {
        Iterator<Mounted> iterator = this.getMisc().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            MiscType miscType = (MiscType)mounted.getType();
            if (!STEALTH.equals(miscType.getInternalName()) || !mounted.getLinked().isDestroyed() || !mounted.getLinked().isBreached()) continue;
            mounted.setMode("Off");
        }
        super.newRound(n);
        if (this.usedMASC) {
            ++this.nMASCLevel;
            this.bMASCWentUp = true;
        } else {
            this.nMASCLevel = Math.max(0, this.nMASCLevel - 1);
            if (this.bMASCWentUp) {
                this.nMASCLevel = Math.max(0, this.nMASCLevel - 1);
                this.bMASCWentUp = false;
            }
        }
        this.usedMASC = false;
        this.setSecondaryFacing(this.getFacing());
        this.sinksOn = this.sinksOnNextRound;
        this.cockpitStatus = this.cockpitStatusNextRound;
    }

    public boolean locationIsTorso(int n) {
        return n == 1 || n == 2 || n == 3;
    }

    public boolean locationIsLeg(int n) {
        return n == 7 || n == 6;
    }

    public int countBadLegs() {
        int n = 0;
        for (int i = 0; i < this.locations(); ++i) {
            n += this.locationIsLeg(i) && this.isLocationBad(i) ? 1 : 0;
        }
        return n;
    }

    public boolean hasHipCrit() {
        for (int i = 0; i < 8; ++i) {
            if (!this.legHasHipCrit(i)) continue;
            return true;
        }
        return false;
    }

    public boolean legHasHipCrit(int n) {
        if (this.isLocationBad(n)) {
            return false;
        }
        if (this.locationIsLeg(n)) {
            return this.getGoodCriticals(0, 11, n) == 0;
        }
        return false;
    }

    public int countLegActuatorCrits(int n) {
        if (this.isLocationBad(n)) {
            return 0;
        }
        int n2 = 0;
        if (this.locationIsLeg(n)) {
            if (this.getGoodCriticals(0, 12, n) == 0) {
                ++n2;
            }
            if (this.getGoodCriticals(0, 13, n) == 0) {
                ++n2;
            }
            if (this.getGoodCriticals(0, 14, n) == 0) {
                ++n2;
            }
        }
        return n2;
    }

    public boolean hasCompositeStructure() {
        return this.getStructureType() == 4;
    }

    public boolean hasReinforcedStructure() {
        return this.getStructureType() == 3;
    }

    public boolean hasMASC() {
        Iterator<Mounted> iterator = this.getMisc().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            MiscType miscType = (MiscType)mounted.getType();
            if (!miscType.hasFlag(16L)) continue;
            return true;
        }
        return false;
    }

    public Mounted getMASC() {
        Iterator<Mounted> iterator = this.getMisc().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            MiscType miscType = (MiscType)mounted.getType();
            if (!miscType.hasFlag(16L) || !mounted.isReady()) continue;
            return mounted;
        }
        return null;
    }

    public boolean hasArmedMASC() {
        Iterator<Mounted> iterator = this.getEquipment().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            if (mounted.isDestroyed() || mounted.isBreached() || !(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(16L) || !mounted.curMode().equals("Armed")) continue;
            return true;
        }
        return false;
    }

    public boolean hasTSM() {
        Iterator<Mounted> iterator = this.getEquipment().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(32L)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStealth() {
        Iterator<Mounted> iterator = this.getMisc().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            MiscType miscType = (MiscType)mounted.getType();
            if (!miscType.hasFlag(262144L)) continue;
            return true;
        }
        return false;
    }

    public int getStandingHeat() {
        return this.engine.getStandingHeat();
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
        if (engine.engineValid) {
            this.setOriginalWalkMP(this.calculateWalk());
        }
    }

    protected int calculateWalk() {
        return this.getEngine().getRating() / (int)this.weight;
    }

    public int getWalkHeat() {
        return this.engine.getWalkHeat();
    }

    public int getRunMP(boolean bl) {
        if (this.hasArmedMASC()) {
            return this.getWalkMP(bl) * 2 - (this.getArmorType() == 4 ? 1 : 0);
        }
        return super.getRunMP(bl) - (this.getArmorType() == 4 ? 1 : 0);
    }

    public int getRunMPwithoutMASC(boolean bl) {
        return super.getRunMP(bl) - (this.getArmorType() == 4 ? 1 : 0);
    }

    public int getOriginalRunMPwithoutMASC() {
        return super.getRunMP(false) - (this.getArmorType() == 4 ? 1 : 0);
    }

    public String getRunMPasString() {
        if (this.hasArmedMASC()) {
            return this.getRunMPwithoutMASC() + "(" + this.getRunMP() + ")";
        }
        return Integer.toString(this.getRunMP());
    }

    public int getRunHeat() {
        return this.engine.getRunHeat();
    }

    public int getJumpMP() {
        int n = 0;
        if (this.hasShield() && this.getNumberOfShields(4096) > 0) {
            return 0;
        }
        Iterator<Mounted> iterator = this.getMisc().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            if (mounted.getType().hasFlag(4L) && !mounted.isDestroyed() && !mounted.isBreached()) {
                ++n;
                continue;
            }
            if (!mounted.getType().hasFlag(0x40000000L) || mounted.isDestroyed() || mounted.isBreached()) continue;
            n = this.getOriginalJumpMP();
            break;
        }
        return this.applyGravityEffectsOnMP(n);
    }

    public int getJumpType() {
        if (this.jumpType == -1) {
            this.jumpType = 0;
            Iterator iterator = this.miscList.iterator();
            while (iterator.hasNext()) {
                Mounted mounted = (Mounted)iterator.next();
                Mounted mounted2 = mounted;
                if (mounted2.getType().hasFlag(4L)) {
                    if (mounted2.getType().getTechLevel() == 5 || mounted2.getType().getTechLevel() == 6) {
                        this.jumpType = 2;
                        break;
                    }
                    this.jumpType = 1;
                    break;
                }
                if (!mounted2.getType().hasFlag(0x40000000L)) continue;
                this.jumpType = 3;
                break;
            }
        }
        return this.jumpType;
    }

    public int getJumpHeat(int n) {
        switch (this.getJumpType()) {
            case 2: {
                return this.engine.getJumpHeat(n / 2 + n % 2);
            }
            case 0: 
            case 3: 
            case 4: {
                return 0;
            }
        }
        return this.engine.getJumpHeat(n);
    }

    public int getJumpMPWithTerrain() {
        if (this.getPosition() == null || this.getJumpType() == 3) {
            return this.getJumpMP();
        }
        int n = 0;
        if (!this.isOffBoard()) {
            n = this.game.getBoard().getHex(this.getPosition()).terrainLevel(4);
        }
        if (n <= 0 || this.getElevation() >= 0) {
            return this.getJumpMP();
        }
        if (n > 1) {
            return 0;
        }
        return this.applyGravityEffectsOnMP(this.torsoJumpJets());
    }

    public int torsoJumpJets() {
        int n = 0;
        Iterator<Mounted> iterator = this.getMisc().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            if (!mounted.getType().hasFlag(4L) || mounted.isDestroyed() || mounted.isBreached() || !this.locationIsTorso(mounted.getLocation())) continue;
            ++n;
        }
        return n;
    }

    public int getElevation() {
        int n = super.getElevation();
        if (!this.isMakingDfa()) {
            return n;
        }
        int n2 = this.game.getBoard().getHex(this.displacementAttack.getTargetPos()).floor();
        return Math.max(n, n2) + 1;
    }

    public int height() {
        IHex iHex = this.game.getBoard().getHex(this.getPosition());
        return this.isProne() || iHex != null && iHex.containsTerrain(10) ? 0 : 1;
    }

    public void addEngineSinks(int n, boolean bl) {
        this.addEngineSinks(n, bl, this.isClan());
    }

    public void addEngineSinks(int n, boolean bl, boolean bl2) {
        int n2;
        EquipmentType equipmentType = bl ? EquipmentType.get(bl2 ? "CLDoubleHeatSink" : "ISDoubleHeatSink") : EquipmentType.get("Heat Sink");
        if (equipmentType == null) {
            System.out.println("Mech: can't find heat sink to add to engine");
        }
        if ((n2 = Math.min(n, this.getEngine().integralHeatSinkCapacity())) == 0 && this.getEngine().isFusion()) {
            System.out.println("Mech: not putting any heat sinks in the engine?!?!");
        }
        for (int i = 0; i < n2; ++i) {
            try {
                this.addEquipment(new Mounted(this, equipmentType), -1, false);
                continue;
            }
            catch (LocationFullException locationFullException) {
                // empty catch block
            }
        }
    }

    public int getEngineCritHeat() {
        int n = 0;
        if (!this.isShutDown() && this.getEngine().isFusion()) {
            n += 5 * this.getHitCriticals(0, 3, 1);
            n += 5 * this.getHitCriticals(0, 3, 3);
            n += 5 * this.getHitCriticals(0, 3, 2);
        }
        return n;
    }

    public int heatSinks() {
        int n = 0;
        Iterator<Mounted> iterator = this.getMisc().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            EquipmentType equipmentType = mounted.getType();
            if (!equipmentType.hasFlag(1L) && !equipmentType.hasFlag(2L)) continue;
            ++n;
        }
        return n;
    }

    public int getHeatCapacity() {
        int n = 0;
        int n2 = this.getActiveSinks();
        Iterator<Mounted> iterator = this.getMisc().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            if (n2 <= 0) break;
            if (mounted.isDestroyed() || mounted.isBreached()) continue;
            if (mounted.getType().hasFlag(1L)) {
                ++n;
                --n2;
                continue;
            }
            if (!mounted.getType().hasFlag(2L)) continue;
            --n2;
            n += 2;
        }
        return n;
    }

    public int getHeatCapacityWithWater() {
        if (this.hasLaserHeatSinks()) {
            return this.getHeatCapacity();
        }
        return this.getHeatCapacity() + Math.min(this.sinksUnderwater(), 6);
    }

    private int sinksUnderwater() {
        if (this.getPosition() == null || this.isOffBoard()) {
            return 0;
        }
        IHex iHex = this.game.getBoard().getHex(this.getPosition());
        if (iHex.terrainLevel(4) <= 0 || this.getElevation() >= 0) {
            return 0;
        }
        if (this.isProne() || iHex.terrainLevel(4) >= 2) {
            return this.getHeatCapacity();
        }
        int n = 0;
        Iterator<Mounted> iterator = this.getMisc().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            if (mounted.isDestroyed() || mounted.isBreached() || !this.locationIsLeg(mounted.getLocation())) continue;
            if (mounted.getType().hasFlag(1L)) {
                ++n;
                continue;
            }
            if (!mounted.getType().hasFlag(2L)) continue;
            n += 2;
        }
        return n;
    }

    public String getMovementString(int n) {
        switch (n) {
            case -2: {
                return "Skidded";
            }
            case 0: {
                return "None";
            }
            case 1: {
                return "Walked";
            }
            case 2: {
                return "Ran";
            }
            case 3: {
                return "Jumped";
            }
        }
        return "Unknown!";
    }

    public String getMovementAbbr(int n) {
        switch (n) {
            case -2: {
                return "S";
            }
            case 0: {
                return "N";
            }
            case 1: {
                return "W";
            }
            case 2: {
                return "R";
            }
            case 3: {
                return "J";
            }
        }
        return "?";
    }

    public boolean canChangeSecondaryFacing() {
        return !this.isProne();
    }

    public boolean isValidSecondaryFacing(int n) {
        int n2 = n - this.getFacing();
        if (this.canChangeSecondaryFacing()) {
            return n2 == 0 || n2 == 1 || n2 == -1 || n2 == -5;
        }
        return n2 == 0;
    }

    public int clipSecondaryFacing(int n) {
        if (this.isValidSecondaryFacing(n)) {
            return n;
        }
        if (!this.canChangeSecondaryFacing()) {
            return this.getFacing();
        }
        int n2 = (n + (6 - this.getFacing())) % 6;
        return n2 >= 3 ? (this.getFacing() + 5) % 6 : (this.getFacing() + 1) % 6;
    }

    public boolean hasRearArmor(int n) {
        return n == 1 || n == 2 || n == 3;
    }

    public int getArmor(int n, boolean bl) {
        if (bl && this.hasRearArmor(n)) {
            return this.rearArmor[n];
        }
        return super.getArmor(n, bl);
    }

    public int getOArmor(int n, boolean bl) {
        if (bl && this.hasRearArmor(n)) {
            return this.orig_rearArmor[n];
        }
        return super.getOArmor(n, bl);
    }

    public void setArmor(int n, int n2, boolean bl) {
        if (bl && this.hasRearArmor(n2)) {
            this.rearArmor[n2] = n;
        } else {
            super.setArmor(n, n2, bl);
        }
    }

    public void initializeRearArmor(int n, int n2) {
        this.orig_rearArmor[n2] = n;
        this.setArmor(n, n2, true);
    }

    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        if (mounted.isRearMounted()) {
            return 4;
        }
        switch (mounted.getLocation()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return 1;
            }
            case 4: {
                return this.getArmsFlipped() ? 4 : 3;
            }
            case 5: {
                return this.getArmsFlipped() ? 4 : 2;
            }
        }
        return 0;
    }

    public boolean isSecondaryArcWeapon(int n) {
        return this.getEquipment(n).getLocation() != 6 && this.getEquipment(n).getLocation() != 7;
    }

    public HitData rollHitLocation(int n, int n2) {
        return this.rollHitLocation(n, n2, -1, 0);
    }

    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        Object object;
        int n5 = -1;
        if (n3 != -1 && n4 == 2) {
            return new HitData(n3, n2 == 1, true);
        }
        if (n3 != -1 && n4 == 1 && 5 < (n5 = Compute.d6(2)) && n5 < 9) {
            return new HitData(n3, n2 == 1, true);
        }
        if (n == 0 || n == 6) {
            n5 = Compute.d6(2);
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (n2 == 0) {
                if (this.game.getOptions().booleanOption("quad_hit_location") && this.isProne()) {
                    switch (n5) {
                        case 2: {
                            if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_tac") && !this.game.getOptions().booleanOption("no_tac")) {
                                this.crew.decreaseEdge();
                                object = this.rollHitLocation(n, n2, n3, n4);
                                ((HitData)object).setUndoneLocation(this.tac(n, n2, 1, false));
                                return object;
                            }
                            return this.tac(n, n2, 1, false);
                        }
                        case 3: {
                            return new HitData(6);
                        }
                        case 4: 
                        case 5: {
                            return new HitData(4);
                        }
                        case 6: {
                            return new HitData(2);
                        }
                        case 7: {
                            return new HitData(1);
                        }
                        case 8: {
                            return new HitData(3);
                        }
                        case 9: 
                        case 10: {
                            return new HitData(5);
                        }
                        case 11: {
                            return new HitData(7);
                        }
                        case 12: {
                            if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                                this.crew.decreaseEdge();
                                object = this.rollHitLocation(n, n2, n3, n4);
                                ((HitData)object).setUndoneLocation(new HitData(0));
                                return object;
                            }
                            return new HitData(0);
                        }
                    }
                } else {
                    switch (n5) {
                        case 2: {
                            if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_tac") && !this.game.getOptions().booleanOption("no_tac")) {
                                this.crew.decreaseEdge();
                                object = this.rollHitLocation(n, n2, n3, n4);
                                ((HitData)object).setUndoneLocation(this.tac(n, n2, 1, false));
                                return object;
                            }
                            return this.tac(n, n2, 1, false);
                        }
                        case 3: 
                        case 4: {
                            return new HitData(4);
                        }
                        case 5: {
                            return new HitData(6);
                        }
                        case 6: {
                            return new HitData(2);
                        }
                        case 7: {
                            return new HitData(1);
                        }
                        case 8: {
                            return new HitData(3);
                        }
                        case 9: {
                            return new HitData(7);
                        }
                        case 10: 
                        case 11: {
                            return new HitData(5);
                        }
                        case 12: {
                            if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                                this.crew.decreaseEdge();
                                object = this.rollHitLocation(n, n2, n3, n4);
                                ((HitData)object).setUndoneLocation(new HitData(0));
                                return object;
                            }
                            return new HitData(0);
                        }
                    }
                }
            } else if (n2 == 2) {
                switch (n5) {
                    case 2: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_tac") && !this.game.getOptions().booleanOption("no_tac")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(this.tac(n, n2, 3, false));
                            return object;
                        }
                        return this.tac(n, n2, 3, false);
                    }
                    case 3: {
                        return new HitData(7);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(5);
                    }
                    case 6: {
                        return new HitData(7);
                    }
                    case 7: {
                        return new HitData(3);
                    }
                    case 8: {
                        return new HitData(1);
                    }
                    case 9: {
                        return new HitData(2);
                    }
                    case 10: {
                        return new HitData(4);
                    }
                    case 11: {
                        return new HitData(6);
                    }
                    case 12: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0));
                            return object;
                        }
                        return new HitData(0);
                    }
                }
            } else if (n2 == 3) {
                switch (n5) {
                    case 2: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_tac") && !this.game.getOptions().booleanOption("no_tac")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(this.tac(n, n2, 2, false));
                            return object;
                        }
                        return this.tac(n, n2, 2, false);
                    }
                    case 3: {
                        return new HitData(6);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(4);
                    }
                    case 6: {
                        return new HitData(6);
                    }
                    case 7: {
                        return new HitData(2);
                    }
                    case 8: {
                        return new HitData(1);
                    }
                    case 9: {
                        return new HitData(3);
                    }
                    case 10: {
                        return new HitData(5);
                    }
                    case 11: {
                        return new HitData(7);
                    }
                    case 12: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0));
                            return object;
                        }
                        return new HitData(0);
                    }
                }
            } else if (n2 == 1) {
                if (this.game.getOptions().booleanOption("quad_hit_location") && this.isProne()) {
                    switch (n5) {
                        case 2: {
                            if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_tac") && !this.game.getOptions().booleanOption("no_tac")) {
                                this.crew.decreaseEdge();
                                object = this.rollHitLocation(n, n2, n3, n4);
                                ((HitData)object).setUndoneLocation(this.tac(n, n2, 1, true));
                                return object;
                            }
                            return this.tac(n, n2, 1, true);
                        }
                        case 3: {
                            return new HitData(4, true);
                        }
                        case 4: 
                        case 5: {
                            return new HitData(6, true);
                        }
                        case 6: {
                            return new HitData(2, true);
                        }
                        case 7: {
                            return new HitData(1, true);
                        }
                        case 8: {
                            return new HitData(3, true);
                        }
                        case 9: 
                        case 10: {
                            return new HitData(7, true);
                        }
                        case 11: {
                            return new HitData(5, true);
                        }
                        case 12: {
                            if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                                this.crew.decreaseEdge();
                                object = this.rollHitLocation(n, n2, n3, n4);
                                ((HitData)object).setUndoneLocation(new HitData(0, true));
                                return object;
                            }
                            return new HitData(0, true);
                        }
                    }
                } else {
                    switch (n5) {
                        case 2: {
                            if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_tac") && !this.game.getOptions().booleanOption("no_tac")) {
                                this.crew.decreaseEdge();
                                object = this.rollHitLocation(n, n2, n3, n4);
                                ((HitData)object).setUndoneLocation(this.tac(n, n2, 1, true));
                                return object;
                            }
                            return this.tac(n, n2, 1, true);
                        }
                        case 3: 
                        case 4: {
                            return new HitData(4, true);
                        }
                        case 5: {
                            return new HitData(6, true);
                        }
                        case 6: {
                            return new HitData(2, true);
                        }
                        case 7: {
                            return new HitData(1, true);
                        }
                        case 8: {
                            return new HitData(3, true);
                        }
                        case 9: {
                            return new HitData(7, true);
                        }
                        case 10: 
                        case 11: {
                            return new HitData(5, true);
                        }
                        case 12: {
                            if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                                this.crew.decreaseEdge();
                                object = this.rollHitLocation(n, n2, n3, n4);
                                ((HitData)object).setUndoneLocation(new HitData(0, true));
                                return object;
                            }
                            return new HitData(0, true);
                        }
                    }
                }
            }
        }
        if (n == 1) {
            n5 = Compute.d6(1);
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (n2 == 0) {
                switch (n5) {
                    case 1: {
                        return new HitData(5);
                    }
                    case 2: {
                        return new HitData(3);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: {
                        return new HitData(2);
                    }
                    case 5: {
                        return new HitData(4);
                    }
                    case 6: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0));
                            return object;
                        }
                        return new HitData(0);
                    }
                }
            }
            if (n2 == 2) {
                switch (n5) {
                    case 1: 
                    case 2: {
                        return new HitData(3);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(5);
                    }
                    case 6: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0));
                            return object;
                        }
                        return new HitData(0);
                    }
                }
            }
            if (n2 == 3) {
                switch (n5) {
                    case 1: 
                    case 2: {
                        return new HitData(2);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(4);
                    }
                    case 6: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0));
                            return object;
                        }
                        return new HitData(0);
                    }
                }
            }
            if (n2 == 1) {
                switch (n5) {
                    case 1: {
                        return new HitData(5, true);
                    }
                    case 2: {
                        return new HitData(3, true);
                    }
                    case 3: {
                        return new HitData(1, true);
                    }
                    case 4: {
                        return new HitData(2, true);
                    }
                    case 5: {
                        return new HitData(4, true);
                    }
                    case 6: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0, true));
                            return object;
                        }
                        return new HitData(0, true);
                    }
                }
            }
        }
        if (n == 2) {
            n5 = Compute.d6(1);
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (n2 == 0 || n2 == 1) {
                switch (n5) {
                    case 1: 
                    case 2: 
                    case 3: {
                        return new HitData(6, n2 == 1);
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        return new HitData(7, n2 == 1);
                    }
                }
            }
            if (n2 == 2) {
                return new HitData(7);
            }
            if (n2 == 3) {
                return new HitData(6);
            }
        }
        if (n == 3) {
            n5 = Compute.d6(2);
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            switch (n5) {
                case 2: {
                    if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                        this.crew.decreaseEdge();
                        object = this.rollHitLocation(n, n2, n3, n4);
                        ((HitData)object).setUndoneLocation(new HitData(0, false, 1));
                        return object;
                    }
                    return new HitData(0, false, 1);
                }
                case 3: {
                    return new HitData(1, true, 1);
                }
                case 4: {
                    return new HitData(2, true, 1);
                }
                case 5: {
                    return new HitData(2, false, 1);
                }
                case 6: {
                    return new HitData(4, false, 1);
                }
                case 7: {
                    return new HitData(1, false, 1);
                }
                case 8: {
                    return new HitData(5, false, 1);
                }
                case 9: {
                    return new HitData(3, false, 1);
                }
                case 10: {
                    return new HitData(3, true, 1);
                }
                case 11: {
                    return new HitData(1, true, 1);
                }
                case 12: {
                    if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                        this.crew.decreaseEdge();
                        object = this.rollHitLocation(n, n2, n3, n4);
                        ((HitData)object).setUndoneLocation(new HitData(0, false, 1));
                        return object;
                    }
                    return new HitData(0, false, 1);
                }
            }
        }
        if (n == 4) {
            n5 = Compute.d6(1);
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            switch (n5) {
                case 1: {
                    return new HitData(5, n2 == 1);
                }
                case 2: {
                    return new HitData(3, n2 == 1);
                }
                case 3: {
                    return new HitData(1, n2 == 1);
                }
                case 4: {
                    return new HitData(2, n2 == 1);
                }
                case 5: {
                    return new HitData(4, n2 == 1);
                }
                case 6: {
                    if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                        this.crew.decreaseEdge();
                        object = this.rollHitLocation(n, n2, n3, n4);
                        ((HitData)object).setUndoneLocation(new HitData(0, n2 == 1));
                        return object;
                    }
                    return new HitData(0, n2 == 1);
                }
            }
        }
        if (n == 5) {
            n5 = Compute.d6(1);
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            switch (n5) {
                case 1: {
                    return new HitData(7, n2 == 1);
                }
                case 2: {
                    return new HitData(7, n2 == 1);
                }
                case 3: {
                    return new HitData(3, n2 == 1);
                }
                case 4: {
                    return new HitData(2, n2 == 1);
                }
                case 5: {
                    return new HitData(6, n2 == 1);
                }
                case 6: {
                    return new HitData(6, n2 == 1);
                }
            }
        }
        return null;
    }

    protected HitData tac(int n, int n2, int n3, boolean bl) {
        if (this.game.getOptions().booleanOption("no_tac")) {
            return new HitData(n3, bl);
        }
        if (this.game.getOptions().booleanOption("floating_crits")) {
            HitData hitData = this.rollHitLocation(n, n2);
            return new HitData(hitData.getLocation(), hitData.isRear(), 1);
        }
        return new HitData(n3, bl, 1);
    }

    public HitData getTransferLocation(HitData hitData) {
        switch (hitData.getLocation()) {
            case 2: 
            case 3: {
                return new HitData(1, hitData.isRear());
            }
            case 5: 
            case 7: {
                return new HitData(3, hitData.isRear());
            }
            case 4: 
            case 6: {
                return new HitData(2, hitData.isRear());
            }
            case 0: {
                if (this.getCockpitType() == 1) {
                    return new HitData(-1);
                }
                return new HitData(-2);
            }
        }
        return new HitData(-2);
    }

    public int getDependentLocation(int n) {
        switch (n) {
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
        }
        return -1;
    }

    public abstract void setInternal(int var1, int var2, int var3, int var4, int var5);

    public void autoSetInternal() {
        switch ((int)this.weight) {
            case 10: {
                this.setInternal(3, 4, 3, 1, 2);
                break;
            }
            case 15: {
                this.setInternal(3, 5, 4, 2, 3);
                break;
            }
            case 20: {
                this.setInternal(3, 6, 5, 3, 4);
                break;
            }
            case 25: {
                this.setInternal(3, 8, 6, 4, 6);
                break;
            }
            case 30: {
                this.setInternal(3, 10, 7, 5, 7);
                break;
            }
            case 35: {
                this.setInternal(3, 11, 8, 6, 8);
                break;
            }
            case 40: {
                this.setInternal(3, 12, 10, 6, 10);
                break;
            }
            case 45: {
                this.setInternal(3, 14, 11, 7, 11);
                break;
            }
            case 50: {
                this.setInternal(3, 16, 12, 8, 12);
                break;
            }
            case 55: {
                this.setInternal(3, 18, 13, 9, 13);
                break;
            }
            case 60: {
                this.setInternal(3, 20, 14, 10, 14);
                break;
            }
            case 65: {
                this.setInternal(3, 21, 15, 10, 15);
                break;
            }
            case 70: {
                this.setInternal(3, 22, 15, 11, 15);
                break;
            }
            case 75: {
                this.setInternal(3, 23, 16, 12, 16);
                break;
            }
            case 80: {
                this.setInternal(3, 25, 17, 13, 17);
                break;
            }
            case 85: {
                this.setInternal(3, 27, 18, 14, 18);
                break;
            }
            case 90: {
                this.setInternal(3, 29, 19, 15, 19);
                break;
            }
            case 95: {
                this.setInternal(3, 30, 20, 16, 20);
                break;
            }
            case 100: {
                this.setInternal(3, 31, 21, 17, 21);
                break;
            }
            case 105: {
                this.setInternal(4, 32, 22, 17, 22);
                break;
            }
            case 110: {
                this.setInternal(4, 33, 23, 18, 23);
                break;
            }
            case 115: {
                this.setInternal(4, 35, 24, 19, 24);
                break;
            }
            case 120: {
                this.setInternal(4, 36, 25, 20, 25);
                break;
            }
            case 125: {
                this.setInternal(4, 38, 26, 21, 26);
                break;
            }
            case 130: {
                this.setInternal(4, 39, 27, 21, 27);
                break;
            }
            case 135: {
                this.setInternal(4, 41, 28, 22, 28);
                break;
            }
            case 140: {
                this.setInternal(4, 42, 29, 23, 29);
                break;
            }
            case 145: {
                this.setInternal(4, 44, 31, 24, 31);
                break;
            }
            case 150: {
                this.setInternal(4, 45, 32, 25, 32);
                break;
            }
            case 155: {
                this.setInternal(4, 47, 33, 26, 33);
                break;
            }
            case 160: {
                this.setInternal(4, 48, 34, 26, 34);
                break;
            }
            case 165: {
                this.setInternal(4, 50, 35, 27, 35);
                break;
            }
            case 170: {
                this.setInternal(4, 51, 36, 28, 36);
                break;
            }
            case 175: {
                this.setInternal(4, 53, 37, 29, 37);
                break;
            }
            case 180: {
                this.setInternal(4, 54, 38, 30, 38);
                break;
            }
            case 185: {
                this.setInternal(4, 56, 39, 31, 39);
                break;
            }
            case 190: {
                this.setInternal(4, 57, 40, 31, 40);
                break;
            }
            case 195: {
                this.setInternal(4, 59, 41, 32, 41);
                break;
            }
            case 200: {
                this.setInternal(4, 60, 42, 33, 42);
            }
        }
    }

    public void addClanCase() {
        boolean bl = false;
        EquipmentType equipmentType = EquipmentType.get("CLCASE");
        for (int i = 0; i < this.locations(); ++i) {
            bl = false;
            Iterator<Mounted> iterator = this.getEquipment().iterator();
            while (iterator.hasNext()) {
                Mounted mounted = iterator.next();
                if (!mounted.getType().isExplosive() || mounted.getLocation() != i) continue;
                bl = true;
            }
            if (!bl) continue;
            try {
                this.addEquipment(new Mounted(this, equipmentType), i, false);
                continue;
            }
            catch (LocationFullException locationFullException) {
                // empty catch block
            }
        }
    }

    public void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        if (n == -1) {
            super.addEquipment(mounted, n, bl);
            return;
        }
        int n2 = mounted.getType().getCriticals(this);
        if (mounted.getType().isSpreadable() || mounted.isSplitable()) {
            n2 = 1;
        }
        if (this.getEmptyCriticals(n) < n2) {
            throw new LocationFullException(mounted.getName() + " does not fit in " + this.getLocationAbbr(n) + " on " + this.getDisplayName() + "\n        free criticals in location: " + this.getEmptyCriticals(n) + ", criticals needed: " + n2);
        }
        if (this.getEquipmentNum(mounted) == -1) {
            super.addEquipment(mounted, n, bl);
        }
        int n3 = this.getEquipmentNum(mounted);
        for (int i = 0; i < n2; ++i) {
            this.addCritical(n, new CriticalSlot(1, n3, mounted.getType().isHittable()));
        }
    }

    public int calculateBattleValue() {
        return this.calculateBattleValue(false);
    }

    public int calculateBattleValue(boolean bl) {
        Object object;
        Mounted mounted;
        Object object2;
        int n;
        int n2;
        int n3;
        Object object3;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl2 = this.hasStealth();
        boolean bl3 = this.hasEiCockpit() && this.getCrew().getOptions().booleanOption("ei_implant");
        double d3 = 2.0;
        if (this.getArmorType() == 4) {
            d3 = 4.0;
        }
        d += (double)this.getTotalArmor() * d3;
        double d4 = 1.0;
        if (this.getStructureType() == 3) {
            d4 = 2.0;
        }
        if (this.getStructureType() == 4) {
            d4 = 0.5;
        }
        d += (double)this.getTotalInternal() * d4 * this.getEngine().getBVMultiplier();
        d += (double)this.getWeight();
        if (this.getGyroType() == 3) {
            d += 30.0;
        }
        double d5 = 0.0;
        Iterator<Mounted> iterator = this.getEquipment().iterator();
        while (iterator.hasNext()) {
            Mounted mounted2 = iterator.next();
            object3 = mounted2.getType();
            if (mounted2.isDestroyed() || !(object3 instanceof WeaponType && ((EquipmentType)object3).hasFlag(0x1000000L) || object3 instanceof AmmoType && ((AmmoType)object3).getAmmoType() == 14) && (!(object3 instanceof MiscType) || !((EquipmentType)object3).hasFlag(1024L) && !((EquipmentType)object3).hasFlag(0x2000000L))) continue;
            d5 += ((EquipmentType)object3).getBV(this);
        }
        d += d5;
        if (bl3) {
            d -= 25.0;
        }
        double d6 = 0.0;
        object3 = this.getEquipment().iterator();
        while (object3.hasNext()) {
            Mounted mounted3 = (Mounted)object3.next();
            int n4 = mounted3.getLocation();
            EquipmentType equipmentType = mounted3.getType();
            if (!equipmentType.isExplosive() || n4 == -1 || (this.isClan() ? n4 != 1 && n4 != 6 && n4 != 7 && n4 != 0 && (n4 != 2 && n4 != 3 || this.getEngine().getSideTorsoCriticalSlots().length <= 2) : this.getEngine().getSideTorsoCriticalSlots().length <= 2 && ((n4 == 2 || n4 == 3) && this.locationHasCase(n4) || n4 == 5 && (this.locationHasCase(n4) || this.locationHasCase(3)) || n4 == 4 && (this.locationHasCase(n4) || this.locationHasCase(2))))) continue;
            float f = equipmentType.getTonnage(this);
            if (equipmentType instanceof WeaponType && equipmentType.getName().indexOf("Gauss") != -1) {
                f = 1.0f;
            }
            if (equipmentType instanceof WeaponType && ((WeaponType)equipmentType).getAmmoType() == 23) {
                f = 0.0f;
            }
            if (equipmentType instanceof WeaponType && (((WeaponType)equipmentType).getAmmoType() == 1 || ((WeaponType)equipmentType).getAmmoType() == 35)) {
                f = 0.0f;
            }
            d6 += 20.0 * (double)f;
        }
        d = Math.max(1.0, d - d6);
        double d7 = 0.0;
        double d8 = 0.0;
        Iterator<Mounted> iterator2 = this.getWeaponList().iterator();
        while (iterator2.hasNext()) {
            Mounted mounted4 = iterator2.next();
            WeaponType weaponType = (WeaponType)mounted4.getType();
            double d9 = weaponType.getHeat();
            if (mounted4.isMissing() || mounted4.isHit() || mounted4.isDestroyed() || mounted4.isBreached() || weaponType.getAmmoType() == 30) continue;
            if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34) {
                d9 *= 2.0;
            }
            if (weaponType.getAmmoType() == 23) {
                d9 *= 6.0;
            }
            if (weaponType.getAmmoType() == 11 || weaponType.getAmmoType() == 47 || weaponType.getAmmoType() == 32) {
                d9 *= 0.5;
            }
            if (mounted4.isRearMounted()) {
                d8 += d9;
                continue;
            }
            d7 += d9;
        }
        double d10 = Math.max(d7, d8);
        d10 = this.getJumpMP() > 0 ? (d10 += (double)Math.max(3, this.getJumpMP())) : (d10 += 2.0);
        if (bl2) {
            d10 += 10.0;
        }
        if (d10 > (double)this.getHeatCapacity()) {
            double d11 = (d10 - (double)this.getHeatCapacity()) * 5.0;
            d = Math.max(1.0, d - d11);
        }
        int n5 = this.getOriginalRunMPwithoutMASC();
        if (this.hasMASC()) {
            n5 = this.getWalkMP() * 2;
        }
        if (this.hasTSM()) {
            n5 = (int)Math.ceil((double)(this.getWalkMP() + 1) * 1.5);
        }
        if ((n3 = Math.max(n2 = Compute.getTargetMovementModifier(n5, false, false, false).getValue(), n = Compute.getTargetMovementModifier(this.getOriginalJumpMP(), true, false, false).getValue())) > 5) {
            n3 = 5;
        }
        double[] dArray = new double[]{1.0, 1.1, 1.2, 1.3, 1.4, 1.5};
        double d12 = dArray[n3];
        if (bl2) {
            d12 += 0.2;
        }
        d *= d12;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        boolean bl4 = this.hasTargComp();
        Iterator<Mounted> iterator3 = this.getWeaponList().iterator();
        while (iterator3.hasNext()) {
            Mounted mounted5 = iterator3.next();
            object2 = (WeaponType)mounted5.getType();
            double d16 = ((EquipmentType)object2).getBV(this);
            if (mounted5.isDestroyed() || ((EquipmentType)object2).hasFlag(0x1000000L)) continue;
            if (mounted5.getLinkedBy() != null && (mounted = mounted5.getLinkedBy()).getType() instanceof MiscType && mounted.getType().hasFlag(512L)) {
                d16 *= 1.2;
            }
            if (((EquipmentType)object2).hasFlag(1L)) {
                if (bl3 && bl4) {
                    d16 *= 1.25;
                } else if (bl4) {
                    d16 *= 1.2;
                } else if (bl3) {
                    d16 *= 1.05;
                }
            }
            if (mounted5.isRearMounted()) {
                d15 += d16;
                continue;
            }
            d14 += d16;
        }
        if (d14 > d15) {
            d13 += d14;
            d13 += d15 * 0.5;
        } else {
            d13 += d15;
            d13 += d14 * 0.5;
        }
        double d17 = 0.0;
        object2 = this.getMisc().iterator();
        while (object2.hasNext()) {
            Mounted mounted6 = (Mounted)object2.next();
            object = (MiscType)mounted6.getType();
            if (mounted6.isDestroyed() || ((EquipmentType)object).hasFlag(1024L) || ((EquipmentType)object).hasFlag(0x2000000L) || ((EquipmentType)object).hasFlag(2048L)) continue;
            d17 += ((MiscType)object).getBV(this);
            if (!((EquipmentType)object).hasFlag(0x80000000L)) continue;
            if (this.getArmor(mounted6.getLocation(), false) != -3) {
                d17 += (double)this.getArmor(mounted6.getLocation());
            }
            if (!this.hasRearArmor(mounted6.getLocation()) || this.getArmor(mounted6.getLocation(), true) == -3) continue;
            d17 += (double)this.getArmor(mounted6.getLocation(), true);
        }
        d13 += d17;
        double d18 = 0.0;
        object = this.getAmmo().iterator();
        while (object.hasNext()) {
            mounted = (Mounted)object.next();
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || ammoType.getAmmoType() == 14 || mounted.getLocation() == -1) continue;
            d18 += ammoType.getBV(this);
        }
        d13 += d18;
        if (d10 > (double)this.getHeatCapacity()) {
            double d19 = (double)this.getHeatCapacity() * d13 / d10;
            double d20 = (d13 - d19) / 2.0;
            d13 = d19 + d20;
        }
        double d21 = this.getOriginalRunMPwithoutMASC() + this.getOriginalJumpMP() - 5;
        if (this.hasMASC() || this.hasTSM()) {
            d21 += 1.0;
        }
        d21 /= 10.0;
        d21 += 1.0;
        d21 = Math.pow(d21, 1.2);
        d21 = (double)Math.round(d21 * 100.0) / 100.0;
        d2 = d13 * d21;
        double d22 = 0.0;
        if (this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.C3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5 || bl) {
            d22 = Math.round(0.35 * d14 + 0.5 * d15);
        }
        if (this.getsTagBVPenalty()) {
            d += 200.0;
        }
        if (this.getsHomingBVPenalty()) {
            d += 200.0;
        }
        double d23 = this.crew.getBVSkillMultiplier();
        if (bl3) {
            d23 += 0.05;
        }
        if (this.getCockpitType() == 2) {
            d23 -= 0.05;
        }
        int n6 = (int)Math.round(d + d2 + d22);
        int n7 = (int)Math.round((double)n6 * d23);
        return n7;
    }

    public double getCost() {
        return this.getCost(null);
    }

    public double getCost(StringBuffer stringBuffer) {
        double[] dArray = new double[14];
        int n = 0;
        double d = 0.0;
        d = this.getCockpitType() == 1 ? 750000.0 : (this.getCockpitType() == 4 ? 0.0 : (this.getCockpitType() == 3 ? 700000.0 : (this.getCockpitType() == 2 ? 175000.0 : 200000.0)));
        if (this.hasEiCockpit() && this.getCrew().getOptions().booleanOption("ei_implant")) {
            d = 400000.0;
        }
        dArray[n++] = d;
        dArray[n++] = 50000.0;
        dArray[n++] = this.weight * 2000.0f;
        int n2 = this.hasTSM() ? 16000 : 2000;
        dArray[n++] = (float)n2 * this.weight;
        dArray[n++] = EquipmentType.getStructureCost(this.structureType) * (double)this.weight;
        dArray[n++] = this.getActuatorCost();
        Engine engine = this.getEngine();
        dArray[n++] = (double)((float)(engine.getBaseCost() * engine.getRating()) * this.weight) / 75.0;
        dArray[n++] = this.getGyroType() == 1 ? (double)(750000 * (int)Math.ceil((float)this.getOriginalWalkMP() * this.weight / 100.0f)) * 0.5 : (this.getGyroType() == 2 ? (double)(400000 * (int)Math.ceil((float)this.getOriginalWalkMP() * this.weight / 100.0f)) * 1.5 : (this.getGyroType() == 3 ? (double)(500000 * (int)Math.ceil((float)this.getOriginalWalkMP() * this.weight / 100.0f) * 2) : (double)(300000 * (int)Math.ceil((float)this.getOriginalWalkMP() * this.weight / 100.0f))));
        double d2 = 200.0;
        if (this.hasUMU()) {
            dArray[n++] = Math.pow(this.getAllUMUCount(), 2.0) * (double)this.weight * d2;
        } else {
            if (this.getJumpType() == 3) {
                d2 = 150.0;
            } else if (this.getJumpType() == 2) {
                d2 = 500.0;
            }
            dArray[n++] = Math.pow(this.getOriginalJumpMP(), 2.0) * (double)this.weight * d2;
        }
        int n3 = this.hasDoubleHeatSinks() ? 0 : 10;
        int n4 = this.hasDoubleHeatSinks() ? 6000 : 2000;
        dArray[n++] = n4 * (this.heatSinks() - n3);
        dArray[n++] = this.getArmorWeight() * EquipmentType.getArmorCost(this.armorType);
        dArray[n++] = this.getWeaponsAndEquipmentCost();
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d3 += dArray[i];
        }
        double d4 = 0.0;
        if (this.isOmni()) {
            d4 = 1.25;
            d3 *= d4;
        }
        dArray[n++] = -d4;
        double d5 = 1.0f + this.weight / 100.0f;
        dArray[n++] = -d5;
        d3 = Math.round(d3 * d5);
        if (stringBuffer != null) {
            this.addCostDetails(d3, stringBuffer, dArray);
        }
        return d3;
    }

    private void addCostDetails(double d, StringBuffer stringBuffer, double[] dArray) {
        int n;
        String[] stringArray = new String[]{"Cockpit", "Life Support", "Sensors", "Myomer", "Structure", "Actuators", "Engine", "Gyro", "Jump Jets", "Heatsinks", "Armor", "Equipment", "Omni Multiplier", "Weight Multiplier"};
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            n2 = Math.max(n2, stringArray[n].length());
            n3 = Math.max(n3, commafy.format(dArray[n]).length());
        }
        n2 += 5;
        n3 = Math.max(n3, commafy.format(d).length());
        for (n = 0; n < stringArray.length; ++n) {
            String string = dArray[n] < 0.0 ? StringUtil.makeLength(stringArray[n], n2) + StringUtil.makeLength("x" + commafy.format(dArray[n] * -1.0), n3, true) : (dArray[n] == 0.0 ? StringUtil.makeLength(stringArray[n], n2) + StringUtil.makeLength("N/A", n3, true) : StringUtil.makeLength(stringArray[n], n2) + StringUtil.makeLength(commafy.format(dArray[n]), n3, true));
            stringBuffer.append(string + "\n");
            n4 = string.length();
        }
        for (n = 0; n < n4; ++n) {
            stringBuffer.append("-");
        }
        stringBuffer.append("\n" + StringUtil.makeLength("Total Cost:", n2) + StringUtil.makeLength(commafy.format(d), n3, true));
    }

    protected double getActuatorCost() {
        return this.getArmActuatorCost() + this.getLegActuatorCost();
    }

    protected abstract double getArmActuatorCost();

    protected abstract double getLegActuatorCost();

    public Vector victoryReport() {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(7025);
        report.type = 0;
        report.addDesc(this);
        vector.addElement(report);
        report = new Report(7030);
        report.type = 0;
        report.newlines = 0;
        vector.addElement(report);
        vector.addAll(this.crew.getDescVector(false));
        report = new Report(7070, 0);
        report.add(this.getKillNumber());
        vector.addElement(report);
        if (this.isDestroyed()) {
            Entity entity = this.game.getEntity(this.killerId);
            if (entity == null) {
                entity = this.game.getOutOfGameEntity(this.killerId);
            }
            if (entity != null) {
                report = new Report(7072, 0);
                report.addDesc(entity);
            } else {
                report = new Report(7073, 0);
            }
            vector.addElement(report);
        }
        report.newlines = 2;
        return vector;
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        if (this.getBadCriticals(0, 4, 1) > 0) {
            if (this.getGyroType() == 3) {
                if (this.getBadCriticals(0, 4, 1) == 1) {
                    pilotingRollData.addModifier(2, "HD Gyro damaged once");
                } else {
                    pilotingRollData.addModifier(3, "HD Gyro damaged twice");
                }
            } else {
                pilotingRollData.addModifier(3, "Gyro damaged");
            }
        }
        if (this.hasActiveEiCockpit()) {
            pilotingRollData.addModifier(-1, "Enhanced Imaging");
        }
        if (this.getCockpitType() == 2) {
            pilotingRollData.addModifier(1, "Small Cockpit");
        } else if (this.getCockpitType() == 1) {
            pilotingRollData.addModifier(1, "Torso-Mounted Cockpit");
            int n = this.getBadCriticals(0, 1, 0);
            int n2 = this.getBadCriticals(0, 1, 1);
            if (n + n2 == 3) {
                pilotingRollData.addModifier(4, "Sensors Completely Destroyed for Torso-Mounted Cockpit");
            } else if (n == 2) {
                pilotingRollData.addModifier(4, "Head Sensors Destroyed for Torso-Mounted Cockpit");
            }
        }
        if (this.getArmorType() == 4) {
            pilotingRollData.addModifier(1, "Hardened Armor");
        }
        return pilotingRollData;
    }

    public int getMaxElevationChange() {
        return 2;
    }

    public boolean isStealthActive() {
        Iterator<Mounted> iterator = this.getMisc().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            MiscType miscType = (MiscType)mounted.getType();
            if (!(STEALTH.equals(miscType.getInternalName()) ? mounted.curMode().equals("On") && this.hasActiveECM() : NULLSIG.equals(miscType.getInternalName()) && mounted.curMode().equals("On") && mounted.isReady())) continue;
            return true;
        }
        return false;
    }

    public TargetRoll getStealthModifier(int n) {
        TargetRoll targetRoll = null;
        if (!this.isStealthActive()) {
            targetRoll = new TargetRoll(0, "stealth not active");
        } else {
            switch (n) {
                case 0: 
                case 1: {
                    targetRoll = new TargetRoll(0, "stealth");
                    break;
                }
                case 2: {
                    targetRoll = new TargetRoll(1, "stealth");
                    break;
                }
                case 3: 
                case 4: {
                    targetRoll = new TargetRoll(2, "stealth");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown range constant: " + n);
                }
            }
        }
        return targetRoll;
    }

    public boolean isRepairable() {
        int n = this.getInternal(1);
        return this.isSalvage() && n != -2 && n != -3;
    }

    public boolean canCharge() {
        return super.canCharge() && (!this.game.getOptions().booleanOption("no_clan_physical") || !this.isClan());
    }

    public boolean canDFA() {
        return super.canDFA() && (!this.game.getOptions().booleanOption("no_clan_physical") || !this.isClan());
    }

    public int getNumberOfSinks() {
        int n = 0;
        Iterator<Mounted> iterator = this.getMisc().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            if (mounted.isDestroyed() || mounted.isBreached()) continue;
            if (mounted.getType().hasFlag(1L)) {
                ++n;
                continue;
            }
            if (!mounted.getType().hasFlag(2L)) continue;
            ++n;
        }
        return n;
    }

    public boolean hasDoubleHeatSinks() {
        Iterator<Mounted> iterator = this.getMisc().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            if (mounted.getType().hasFlag(1L)) {
                return false;
            }
            if (!mounted.getType().hasFlag(2L)) continue;
            return true;
        }
        return false;
    }

    public boolean hasLaserHeatSinks() {
        if (this.hasLaserHeatSinks == 0) {
            Iterator<Mounted> iterator = this.getMisc().iterator();
            while (iterator.hasNext()) {
                Mounted mounted = iterator.next();
                if (mounted.getType().hasFlag(1L)) {
                    this.hasLaserHeatSinks = -1;
                    break;
                }
                if (!mounted.getType().hasFlag(64L)) continue;
                this.hasLaserHeatSinks = 1;
                break;
            }
            if (this.hasLaserHeatSinks == 0) {
                this.hasLaserHeatSinks = -1;
            }
        }
        return this.hasLaserHeatSinks == 1;
    }

    public void setActiveSinksNextRound(int n) {
        this.sinksOnNextRound = n;
    }

    public int getActiveSinks() {
        if (this.sinksOn < 0) {
            this.sinksOnNextRound = this.sinksOn = this.getNumberOfSinks();
        }
        return this.sinksOn;
    }

    public int getActiveSinksNextRound() {
        if (this.sinksOnNextRound < 0) {
            return this.getActiveSinks();
        }
        return this.sinksOnNextRound;
    }

    public boolean isAutoEject() {
        if (this.getCockpitType() == 1) {
            return false;
        }
        return this.autoEject;
    }

    public void setAutoEject(boolean bl) {
        this.autoEject = bl;
    }

    public boolean removePartialCoverHits(int n, int n2, int n3) {
        if (n3 == 0) {
            if ((n2 & 2) != 0 && n == 7) {
                return true;
            }
            if ((n2 & 1) != 0 && n == 6) {
                return true;
            }
            if ((n2 & 8) != 0 && (n == 5 || n == 3)) {
                return true;
            }
            if ((n2 & 4) != 0 && (n == 4 || n == 2)) {
                return true;
            }
        } else {
            if ((n2 & 1) != 0 && n == 7) {
                return true;
            }
            if ((n2 & 2) != 0 && n == 6) {
                return true;
            }
            if ((n2 & 4) != 0 && (n == 5 || n == 3)) {
                return true;
            }
            if ((n2 & 8) != 0 && (n == 4 || n == 2)) {
                return true;
            }
        }
        return false;
    }

    public boolean doomedInVacuum() {
        return false;
    }

    public boolean hasEiCockpit() {
        return this.isClan() || super.hasEiCockpit();
    }

    public boolean hasActiveEiCockpit() {
        if (this.cockpitStatus == 0) {
            return false;
        }
        if (this.getBadCriticals(0, 1, 0) > 0) {
            return false;
        }
        return super.hasActiveEiCockpit();
    }

    public int getCockpitStatus() {
        return this.cockpitStatus;
    }

    public int getCockpitStatusNextRound() {
        return this.cockpitStatusNextRound;
    }

    public void setCockpitStatus(int n) {
        this.cockpitStatusNextRound = n;
        if (n != 0 && this.cockpitStatus != 0) {
            this.cockpitStatus = n;
        }
    }

    public int getGyroType() {
        return this.gyroType;
    }

    public int getCockpitType() {
        return this.cockpitType;
    }

    public void setGyroType(int n) {
        this.gyroType = n;
    }

    public void setCockpitType(int n) {
        this.cockpitType = n;
    }

    public String getGyroTypeString() {
        return Mech.getGyroTypeString(this.getGyroType());
    }

    public String getCockpitTypeString() {
        return Mech.getCockpitTypeString(this.getCockpitType());
    }

    public static String getGyroTypeString(int n) {
        if (n < 0 || n >= GYRO_STRING.length) {
            return "Unknown";
        }
        return GYRO_STRING[n];
    }

    public static String getGyroTypeShortString(int n) {
        if (n < 0 || n >= GYRO_SHORT_STRING.length) {
            return "Unknown";
        }
        return GYRO_SHORT_STRING[n];
    }

    public static String getCockpitTypeString(int n) {
        if (n < 0 || n >= COCKPIT_STRING.length) {
            return "Unknown";
        }
        return COCKPIT_STRING[n];
    }

    public static int getGyroTypeForString(String string) {
        if (string == null || string.length() < 1) {
            return -1;
        }
        for (int i = 0; i < GYRO_STRING.length; ++i) {
            if (!string.equals(GYRO_STRING[i]) && !string.equals(GYRO_SHORT_STRING[i])) continue;
            return i;
        }
        return -1;
    }

    public static int getCockpitTypeForString(String string) {
        if (string == null || string.length() < 1) {
            return -1;
        }
        for (int i = 0; i < COCKPIT_STRING.length; ++i) {
            if (!string.equals(COCKPIT_STRING[i]) && !string.equals(COCKPIT_SHORT_STRING[i])) continue;
            return i;
        }
        return -1;
    }

    public String getSystemName(int n) {
        if (n == 4) {
            return Mech.getGyroDisplayString(this.gyroType);
        }
        if (n == 2) {
            return Mech.getCockpitDisplayString(this.cockpitType);
        }
        return systemNames[n];
    }

    public static String getGyroDisplayString(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "GYRO_XL";
                break;
            }
            case 2: {
                string = "GYRO_COMPACT";
                break;
            }
            case 3: {
                string = "GYRO_HEAVY_DUTY";
                break;
            }
            case 0: {
                string = "GYRO_STANDARD";
                break;
            }
            default: {
                string = "GYRO_UNKNOWN";
            }
        }
        String string2 = EquipmentMessages.getString("SystemType.Gyro." + string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public static String getCockpitDisplayString(int n) {
        String string = "";
        switch (n) {
            case 3: {
                string = "COCKPIT_COMMAND_CONSOLE";
                break;
            }
            case 2: {
                string = "COCKPIT_SMALL";
                break;
            }
            case 1: {
                string = "COCKPIT_TORSO_MOUNTED";
                break;
            }
            case 4: {
                string = "COCKPIT_DUAL";
                break;
            }
            case 0: {
                string = "COCKPIT_STANDARD";
                break;
            }
            default: {
                string = "GYRO_UNKNOWN";
            }
        }
        String string2 = EquipmentMessages.getString("SystemType.Cockpit." + string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public boolean canAssaultDrop() {
        return true;
    }

    public boolean isHexProhibited(IHex iHex) {
        if (iHex.containsTerrain(30)) {
            return true;
        }
        return iHex.terrainLevel(1) > 2 || iHex.terrainLevel(23) > 2;
    }

    public String getMtf() {
        int n;
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        String string = "\r\n";
        boolean bl2 = bl = this.getCockpitType() == 0 && this.getGyroType() == 0;
        if (bl) {
            stringBuffer.append("Version:1.0").append(string);
        } else {
            stringBuffer.append("Version:1.1").append(string);
        }
        stringBuffer.append(this.chassis).append(string);
        stringBuffer.append(this.model).append(string);
        stringBuffer.append(string);
        stringBuffer.append("Config:");
        if (this instanceof BipedMech) {
            stringBuffer.append("Biped");
        } else if (this instanceof QuadMech) {
            stringBuffer.append("Quad");
        }
        stringBuffer.append(string);
        stringBuffer.append("TechBase:").append(TechConstants.getTechName(this.techLevel));
        stringBuffer.append(string);
        stringBuffer.append("Era:").append(this.year).append(string);
        stringBuffer.append("Rules Level:").append(TechConstants.T_SIMPLE_LEVEL[this.techLevel]);
        stringBuffer.append(string);
        stringBuffer.append(string);
        Float f = new Float(this.weight);
        stringBuffer.append("Mass:").append(f.intValue()).append(string);
        stringBuffer.append("Engine:").append(this.getEngine().getEngineName()).append(" Engine");
        stringBuffer.append(string);
        stringBuffer.append("Structure:");
        stringBuffer.append(EquipmentType.getStructureTypeName(this.getStructureType()));
        stringBuffer.append(string);
        stringBuffer.append("Myomer:");
        if (this.hasTSM()) {
            stringBuffer.append("Triple-Strength");
        } else {
            stringBuffer.append("Standard");
        }
        stringBuffer.append(string);
        if (!bl) {
            stringBuffer.append("Cockpit:");
            stringBuffer.append(this.getCockpitTypeString());
            stringBuffer.append(string);
            stringBuffer.append("Gyro:");
            stringBuffer.append(this.getGyroTypeString());
            stringBuffer.append(string);
        }
        stringBuffer.append(string);
        stringBuffer.append("Heat Sinks:").append(this.heatSinks()).append(" ");
        if (this.hasDoubleHeatSinks()) {
            stringBuffer.append("Double");
        } else {
            stringBuffer.append("Single");
        }
        stringBuffer.append(string);
        stringBuffer.append("Walk MP:").append(this.walkMP).append(string);
        stringBuffer.append("Jump MP:").append(this.jumpMP).append(string);
        stringBuffer.append(string);
        stringBuffer.append("Armor:").append(EquipmentType.getArmorTypeName(this.getArmorType()));
        stringBuffer.append(string);
        for (n = 0; n < MtfFile.locationOrder.length; ++n) {
            stringBuffer.append(this.getLocationAbbr(MtfFile.locationOrder[n])).append(" Armor:");
            stringBuffer.append(this.getOArmor(MtfFile.locationOrder[n], false)).append(string);
        }
        for (n = 0; n < MtfFile.rearLocationOrder.length; ++n) {
            stringBuffer.append("RT").append(this.getLocationAbbr(MtfFile.rearLocationOrder[n]).charAt(0)).append(" Armor:");
            stringBuffer.append(this.getOArmor(MtfFile.rearLocationOrder[n], true)).append(string);
        }
        stringBuffer.append(string);
        stringBuffer.append("Weapons:").append(this.weaponList.size()).append(string);
        for (n = 0; n < this.weaponList.size(); ++n) {
            Mounted mounted = (Mounted)this.weaponList.get(n);
            stringBuffer.append(mounted.getName()).append(", ").append(this.getLocationName(mounted.getLocation())).append(string);
        }
        stringBuffer.append(string);
        for (n = 0; n < MtfFile.locationOrder.length; ++n) {
            int n2 = MtfFile.locationOrder[n];
            String string2 = this.getLocationName(n2);
            stringBuffer.append(string2 + ":");
            stringBuffer.append(string);
            for (int i = 0; i < 12; ++i) {
                if (i < this.getNumberOfCriticals(n2)) {
                    stringBuffer.append(this.decodeCritical(this.getCritical(n2, i))).append(string);
                    continue;
                }
                stringBuffer.append("-Empty-").append(string);
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String decodeCritical(CriticalSlot criticalSlot) {
        if (criticalSlot == null) {
            return "-Empty-";
        }
        int n = criticalSlot.getType();
        int n2 = criticalSlot.getIndex();
        if (n == 0) {
            if (systemNames[n2].indexOf("Upper") != -1 || systemNames[n2].indexOf("Lower") != -1 || systemNames[n2].indexOf("Hand") != -1 || systemNames[n2].indexOf("Foot") != -1) {
                return systemNames[n2] + " Actuator";
            }
            if (systemNames[n2].indexOf("Engine") != -1) {
                return "Fusion " + systemNames[n2];
            }
            return systemNames[n2];
        }
        if (n == 1) {
            Mounted mounted = this.getEquipment(criticalSlot.getIndex());
            return mounted.getType().getInternalName();
        }
        return "?" + n2;
    }

    public boolean addCockpit() {
        if (this.getEmptyCriticals(0) < 5) {
            return false;
        }
        this.addCritical(0, 0, new CriticalSlot(0, 0));
        this.addCritical(0, 1, new CriticalSlot(0, 1));
        this.addCritical(0, 2, new CriticalSlot(0, 2));
        this.addCritical(0, 4, new CriticalSlot(0, 1));
        this.addCritical(0, 5, new CriticalSlot(0, 0));
        this.setCockpitType(0);
        return true;
    }

    public boolean addSmallCockpit() {
        if (this.getEmptyCriticals(0) < 4) {
            return false;
        }
        this.addCritical(0, 0, new CriticalSlot(0, 0));
        this.addCritical(0, 1, new CriticalSlot(0, 1));
        this.addCritical(0, 2, new CriticalSlot(0, 2));
        this.addCritical(0, 4, new CriticalSlot(0, 1));
        this.setCockpitType(2);
        return true;
    }

    public boolean addCommandConsole() {
        this.addCritical(0, 0, new CriticalSlot(0, 0));
        this.addCritical(0, 1, new CriticalSlot(0, 1));
        this.addCritical(0, 2, new CriticalSlot(0, 2));
        this.addCritical(0, 2, new CriticalSlot(0, 2));
        this.addCritical(0, 4, new CriticalSlot(0, 1));
        this.setCockpitType(3);
        return true;
    }

    public boolean addDualCockpit() {
        this.addCritical(0, 0, new CriticalSlot(0, 0));
        this.addCritical(0, 1, new CriticalSlot(0, 1));
        this.addCritical(0, 2, new CriticalSlot(0, 2));
        this.addCritical(0, 2, new CriticalSlot(0, 2));
        this.addCritical(0, 4, new CriticalSlot(0, 1));
        this.setCockpitType(4);
        return true;
    }

    public boolean addTorsoMountedCockpit() {
        boolean bl = true;
        if (this.getEmptyCriticals(0) < 2) {
            bl = false;
        } else {
            this.addCritical(0, 1, new CriticalSlot(0, 1));
            this.addCritical(0, 4, new CriticalSlot(0, 1));
        }
        if (this.getEmptyCriticals(1) < 2 || !bl) {
            bl = false;
        } else {
            this.addCritical(1, 10, new CriticalSlot(0, 2));
            this.addCritical(1, 11, new CriticalSlot(0, 1));
        }
        if (this.getEmptyCriticals(3) < 1 || this.getEmptyCriticals(2) < 1 || !bl) {
            bl = false;
        } else {
            this.addCritical(3, 0, new CriticalSlot(0, 0));
            this.addCritical(2, 0, new CriticalSlot(0, 0));
        }
        if (bl) {
            this.setCockpitType(1);
        }
        return bl;
    }

    public boolean addGyro() {
        if (this.getEmptyCriticals(1) < 4) {
            return false;
        }
        this.addCompactGyro();
        this.addCritical(1, 5, new CriticalSlot(0, 4));
        this.addCritical(1, 6, new CriticalSlot(0, 4));
        this.setGyroType(0);
        return true;
    }

    public boolean addCompactGyro() {
        if (this.getEmptyCriticals(1) < 2) {
            return false;
        }
        this.addCritical(1, 3, new CriticalSlot(0, 4));
        this.addCritical(1, 4, new CriticalSlot(0, 4));
        this.setGyroType(2);
        return true;
    }

    public boolean addXLGyro() {
        if (this.getEmptyCriticals(1) < 6) {
            return false;
        }
        this.addGyro();
        this.addCritical(1, 10, new CriticalSlot(0, 4));
        this.addCritical(1, 11, new CriticalSlot(0, 4));
        this.setGyroType(1);
        return true;
    }

    public boolean addHeavyDutyGyro() {
        if (this.addGyro()) {
            this.setGyroType(3);
            return true;
        }
        return false;
    }

    public boolean addEngineCrits() {
        boolean bl = true;
        int[] nArray = this.getEngine().getCenterTorsoCriticalSlots();
        if (this.getEmptyCriticals(1) < nArray.length) {
            bl = false;
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                this.addCritical(1, nArray[i], new CriticalSlot(0, 3));
            }
        }
        int[] nArray2 = this.getEngine().getSideTorsoCriticalSlots();
        if (this.getEmptyCriticals(3) < nArray2.length || this.getEmptyCriticals(2) < nArray2.length || !bl) {
            bl = false;
        } else {
            for (int i = 0; i < nArray2.length; ++i) {
                this.addCritical(3, nArray2[i], new CriticalSlot(0, 3));
                this.addCritical(2, nArray2[i], new CriticalSlot(0, 3));
            }
        }
        return bl;
    }

    public void clearEngineCrits() {
        for (int i = 0; i < this.locations(); ++i) {
            this.removeCriticals(i, new CriticalSlot(0, 3));
        }
    }

    public void clearCockpitCrits() {
        for (int i = 0; i < this.locations(); ++i) {
            this.removeCriticals(i, new CriticalSlot(0, 0));
            this.removeCriticals(i, new CriticalSlot(0, 1));
            this.removeCriticals(i, new CriticalSlot(0, 2));
        }
    }

    public void clearGyroCrits() {
        for (int i = 0; i < this.locations(); ++i) {
            this.removeCriticals(i, new CriticalSlot(0, 4));
        }
    }

    public int shieldAbsorptionDamage(int n, int n2, boolean bl) {
        int n3 = n;
        if (this.hasActiveShield(n2, bl)) {
            switch (n2) {
                case 0: 
                case 1: {
                    if (this.hasActiveShield(4)) {
                        n3 = this.getAbsorptionRate(4, n3);
                    }
                    if (!this.hasActiveShield(5)) break;
                    n3 = this.getAbsorptionRate(5, n3);
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    if (!this.hasActiveShield(5)) break;
                    n3 = this.getAbsorptionRate(5, n3);
                    break;
                }
                default: {
                    if (!this.hasActiveShield(4)) break;
                    n3 = this.getAbsorptionRate(4, n3);
                }
            }
        }
        if (this.hasPassiveShield(n2, bl)) {
            switch (n2) {
                case 3: 
                case 5: {
                    if (!this.hasPassiveShield(5)) break;
                    n3 = this.getAbsorptionRate(5, n3);
                    break;
                }
                case 2: 
                case 4: {
                    if (!this.hasPassiveShield(4)) break;
                    n3 = this.getAbsorptionRate(4, n3);
                    break;
                }
            }
        }
        if (this.hasNoDefenseShield(n2)) {
            switch (n2) {
                case 5: {
                    if (!this.hasNoDefenseShield(5)) break;
                    n3 = this.getAbsorptionRate(5, n3);
                    break;
                }
                case 4: {
                    if (!this.hasNoDefenseShield(4)) break;
                    n3 = this.getAbsorptionRate(4, n3);
                    break;
                }
            }
        }
        return Math.max(0, n3);
    }

    private int getAbsorptionRate(int n, int n2) {
        int n3 = n2;
        if (n != 4 && n != 5) {
            return n3;
        }
        if (n2 <= 0) {
            return 0;
        }
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            EquipmentType equipmentType;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || criticalSlot.isDamaged() || !((equipmentType = (mounted = this.getEquipment(criticalSlot.getIndex())).getType()) instanceof MiscType) || !((MiscType)equipmentType).isShield()) continue;
            ++mounted.damageTaken;
            return Math.max(0, n3 -= mounted.getDamageAbsorption(this, mounted.getLocation()));
        }
        return n3;
    }

    public boolean hasHarJelIn(int n) {
        if (n == 0) {
            return false;
        }
        Iterator<Mounted> iterator = this.getMisc().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            if (mounted.getLocation() != n || !mounted.isReady() || !mounted.getType().hasFlag(0x80000000L)) continue;
            return true;
        }
        return false;
    }

    public void setGrappled(int n, boolean bl) {
        this.grappled_id = n;
        this.isGrappleAttacker = bl;
    }

    public boolean isGrappleAttacker() {
        return this.isGrappleAttacker;
    }

    public int getGrappled() {
        return this.grappled_id;
    }

    public boolean isEligibleForMovement() {
        if (this.grappled_id != -1) {
            return false;
        }
        return super.isEligibleForMovement();
    }

    public boolean isNuclearHardened() {
        return true;
    }
}

