/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.Enumeration;
import java.util.Vector;
import megamek.common.TurnOrdered;

public class TurnVectors
implements Enumeration {
    private final int numEven;
    private final int numNormal;
    private final Vector even_turns;
    private final Vector normal_turns;
    private Enumeration turnEnum = null;
    private Enumeration evenEnum = null;
    private final int min;

    private synchronized Enumeration getTurnEnum() {
        if (null == this.turnEnum) {
            this.turnEnum = this.normal_turns.elements();
        }
        return this.turnEnum;
    }

    private synchronized Enumeration getEvenEnum() {
        if (null == this.evenEnum) {
            this.evenEnum = this.even_turns.elements();
        }
        return this.evenEnum;
    }

    public TurnVectors(int n, int n2, int n3) {
        this.numEven = n2;
        this.numNormal = n;
        this.normal_turns = new Vector(n);
        this.even_turns = new Vector(n2);
        this.min = n3;
    }

    public int getEvenTurns() {
        return this.even_turns.size();
    }

    public int getNormalTurns() {
        return this.normal_turns.size();
    }

    public void addEven(TurnOrdered turnOrdered) {
        if (this.numEven == this.even_turns.size()) {
            throw new IllegalStateException("Have already added " + this.numEven + " even turns.");
        }
        this.even_turns.addElement(turnOrdered);
    }

    public void addNormal(TurnOrdered turnOrdered) {
        if (this.numNormal == this.normal_turns.size()) {
            throw new IllegalStateException("Have already added " + this.numNormal + " normal turns.");
        }
        this.normal_turns.addElement(turnOrdered);
    }

    public boolean hasMoreElements() {
        return this.getTurnEnum().hasMoreElements();
    }

    public Object nextElement() {
        return this.getTurnEnum().nextElement();
    }

    public boolean hasMoreEvenElements() {
        return this.getEvenEnum().hasMoreElements();
    }

    public Object nextEvenElement() {
        return this.getEvenEnum().nextElement();
    }

    public int getMin() {
        return this.min;
    }
}

