/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.Iterator;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.IHex;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MoveStep;
import megamek.common.PilotingRollData;
import megamek.common.Tank;
import megamek.common.WeaponType;

public class VTOL
extends Tank {
    public static final int LOC_ROTOR = 5;
    protected static String[] LOCATION_ABBRS = new String[]{"BD", "FR", "RS", "LS", "RR", "RO"};
    protected static String[] LOCATION_NAMES = new String[]{"Body", "Front", "Right", "Left", "Rear", "Rotor"};

    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public PilotingRollData checkSkid(int n, IHex iHex, int n2, MoveStep moveStep, int n3, int n4, Coords coords, Coords coords2, boolean bl, int n5) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        pilotingRollData.addModifier(-2147483647, "Check false: VTOLs can't skid");
        return pilotingRollData;
    }

    public PilotingRollData checkSideSlip(int n, IHex iHex, int n2, MoveStep moveStep, int n3, int n4, Coords coords, Coords coords2, int n5) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        if (!(n == 3 || iHex == null || n2 != 2 && n2 != 5 || n3 == n4 || coords.equals(coords2))) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "VTOL flanking and turning"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: VTOL is not apparently sideslipping");
        }
        return pilotingRollData;
    }

    public int calculateBattleValue(boolean bl) {
        Object object;
        Mounted mounted;
        double d = 0.0;
        double d2 = 0.0;
        d += (double)this.getTotalArmor();
        d += (double)this.getTotalInternal() / 2.0;
        double d3 = 0.0;
        Iterator<Mounted> iterator = this.getEquipment().iterator();
        while (iterator.hasNext()) {
            Mounted mounted2 = iterator.next();
            EquipmentType equipmentType = mounted2.getType();
            if (mounted2.isDestroyed() || !(equipmentType instanceof WeaponType && ((WeaponType)equipmentType).getAmmoType() == 14 || equipmentType instanceof AmmoType && ((AmmoType)equipmentType).getAmmoType() == 14) && !equipmentType.hasFlag(1024L)) continue;
            d3 += equipmentType.getBV(this);
        }
        d += d3;
        double d4 = 0.4;
        d *= d4;
        int n = Compute.getTargetMovementModifier(this.getOriginalRunMP(), true, false, true).getValue();
        if (n > 5) {
            n = 5;
        }
        double[] dArray = new double[]{1.0, 1.1, 1.2, 1.3, 1.4, 1.5};
        d *= dArray[n];
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        boolean bl2 = this.hasTargComp();
        Iterator<Mounted> iterator2 = this.getWeaponList().iterator();
        while (iterator2.hasNext()) {
            Mounted mounted3;
            mounted = iterator2.next();
            object = (WeaponType)mounted.getType();
            double d8 = ((EquipmentType)object).getBV(this);
            if (mounted.isDestroyed() || ((WeaponType)object).getAmmoType() == 14) continue;
            if (mounted.getLinkedBy() != null && (mounted3 = mounted.getLinkedBy()).getType() instanceof MiscType && mounted3.getType().hasFlag(512L)) {
                d8 *= 1.2;
            }
            if (((EquipmentType)object).hasFlag(1L) && bl2) {
                d8 *= 1.2;
            }
            if (mounted.getLocation() == 4) {
                d7 += d8;
                continue;
            }
            d6 += d8;
        }
        iterator2 = this.getEquipment().iterator();
        while (iterator2.hasNext()) {
            mounted = iterator2.next();
            if (mounted.isDestroyed()) continue;
            if (mounted.getName().equals("Beagle Active Probe")) {
                d6 += 10.0;
            }
            if (mounted.getName().equals("Active Probe")) {
                d6 += 12.0;
            }
            if (mounted.getName().equals("Clan Active Probe")) {
                d6 += 12.0;
            }
            if (!mounted.getName().equals("Light Active Probe")) continue;
            d6 += 7.0;
        }
        if (d6 > d7) {
            d5 += d6;
            d5 += d7 * 0.5;
        } else {
            d5 += d7;
            d5 += d6 * 0.5;
        }
        double d9 = 0.0;
        object = this.getAmmo().iterator();
        while (object.hasNext()) {
            Mounted mounted4 = (Mounted)object.next();
            AmmoType ammoType = (AmmoType)mounted4.getType();
            if (mounted4.getShotsLeft() == 0 || ammoType.getAmmoType() == 14) continue;
            d9 += ammoType.getBV(this);
        }
        d5 += d9;
        double d10 = 2 * this.getOriginalRunMP() - 5;
        d10 /= 10.0;
        d10 += 1.0;
        d10 = Math.pow(d10, 1.2);
        d10 = (double)Math.round(d10 * 100.0) / 100.0;
        d2 = d5 * d10;
        double d11 = 0.0;
        if (this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.C3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5 || bl) {
            d11 = Math.round(0.35 * d6 + 0.5 * d7);
        }
        if (this.getsTagBVPenalty()) {
            d += 200.0;
        }
        if (this.getsHomingBVPenalty()) {
            d += 200.0;
        }
        double d12 = this.crew.getBVSkillMultiplier();
        int n2 = (int)Math.round(d + d2 + d11);
        int n3 = (int)Math.round((double)n2 * d12);
        return n3;
    }

    public boolean canCharge() {
        return false;
    }

    public String getMovementString(int n) {
        switch (n) {
            case 4: {
                return "Cruised";
            }
            case 5: {
                return "Flanked";
            }
            case 0: {
                return "None";
            }
        }
        return "Unknown!";
    }

    public String getMovementAbbr(int n) {
        switch (n) {
            case 4: {
                return "C";
            }
            case 5: {
                return "F";
            }
            case 0: {
                return "N";
            }
        }
        return "?";
    }

    public int getMaxElevationChange() {
        return 999;
    }

    public boolean isHexProhibited(IHex iHex) {
        return iHex.containsTerrain(30);
    }

    public boolean isRepairable() {
        boolean bl = this.isSalvage();
        for (int i = 1; bl && i < 5; ++i) {
            int n = this.getInternal(i);
            bl = n != -2 && n != -3;
        }
        return bl;
    }

    public HitData rollHitLocation(int n, int n2) {
        int n3 = 1;
        boolean bl = false;
        if (n2 == 2) {
            n3 = 3;
            bl = true;
        } else if (n2 == 3) {
            n3 = 2;
            bl = true;
        } else if (n2 == 1) {
            n3 = 4;
        }
        switch (Compute.d6(2)) {
            case 2: {
                return new HitData(5, false, 1);
            }
            case 3: {
                return new HitData(5, false, 2);
            }
            case 4: 
            case 5: {
                return new HitData(5, false, 3);
            }
            case 6: 
            case 7: 
            case 8: {
                return new HitData(n3);
            }
            case 9: {
                if (bl) {
                    Mounted mounted = this.getMainWeapon();
                    if (mounted != null) {
                        mounted.setHit(true);
                    }
                    return new HitData(n3);
                }
                return new HitData(n3);
            }
            case 10: 
            case 11: {
                return new HitData(5, false, 3);
            }
            case 12: {
                if (this.getOriginalWalkMP() > 0) {
                    this.setOriginalWalkMP(this.getOriginalWalkMP() - 1);
                }
                return new HitData(5, false, 1);
            }
        }
        return null;
    }

    public boolean doomedInVacuum() {
        return true;
    }

    public void setOnFire(boolean bl) {
        super.setOnFire(bl);
        this.extinguishLocation(5);
    }
}

