/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import java.util.Enumeration;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractEntityAction;
import megamek.common.actions.AttackAction;
import megamek.common.actions.SearchlightAttackAction;
import megamek.common.actions.WeaponAttackAction;

public abstract class AbstractAttackAction
extends AbstractEntityAction
implements AttackAction {
    private int targetType;
    private int targetId;

    public AbstractAttackAction(int n, int n2) {
        super(n);
        this.targetType = 0;
        this.targetId = n2;
    }

    public AbstractAttackAction(int n, int n2, int n3) {
        super(n);
        this.targetType = n2;
        this.targetId = n3;
    }

    public int getTargetType() {
        return this.targetType;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public void setTargetType(int n) {
        this.targetType = n;
    }

    public void setTargetId(int n) {
        this.targetId = n;
    }

    public Targetable getTarget(IGame iGame) {
        return iGame.getTarget(this.getTargetType(), this.getTargetId());
    }

    public Entity getEntity(IGame iGame) {
        return iGame.getEntity(this.getEntityId());
    }

    public static ToHitData nightModifiers(IGame iGame, Targetable targetable, AmmoType ammoType, Entity entity) {
        ToHitData toHitData = null;
        if (iGame.getOptions().booleanOption("night_battle")) {
            SearchlightAttackAction searchlightAttackAction;
            Object object;
            int n;
            Entity entity2 = null;
            if (targetable.getTargetType() == 0) {
                entity2 = (Entity)targetable;
            }
            toHitData = new ToHitData();
            if (iGame.getOptions().booleanOption("dusk")) {
                n = 1;
                toHitData.addModifier(n, "Dusk");
            } else {
                n = 2;
                toHitData.addModifier(n, "Night");
            }
            boolean bl = false;
            if (entity2 != null && !(bl = entity2.isIlluminated())) {
                Enumeration enumeration = iGame.getActions();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (!(object instanceof SearchlightAttackAction) || !(searchlightAttackAction = (SearchlightAttackAction)object).willIlluminate(iGame, entity2)) continue;
                    bl = true;
                    break;
                }
            }
            if (entity2 != null && entity2.isUsingSpotlight()) {
                toHitData.addModifier(-n, "target using searchlight");
                n = 0;
            } else if (bl) {
                toHitData.addModifier(-n, "target illuminated by searchlight");
                n = 0;
            } else if (entity.hasActiveEiCockpit()) {
                toHitData.addModifier(-n, "EI system");
                n = 0;
            } else if (iGame.isPositionIlluminated(targetable.getPosition())) {
                toHitData.addModifier(-n, "target illuminated by flare");
                n = 0;
            } else if (!(ammoType == null || ammoType.getAmmoType() != 1 && ammoType.getAmmoType() != 35 || ammoType.getMunitionType() != 8L && ammoType.getMunitionType() != 0x400000000L)) {
                toHitData.addModifier(-1, "incendiary/tracer ammo");
                --n;
            }
            if (n > 0 && entity2 != null && entity2 instanceof Mech && ((Mech)entity2).hasLaserHeatSinks()) {
                boolean bl2 = false;
                if (entity2.heat > 0) {
                    toHitData.addModifier(-n, "target overheated with laser heatsinks");
                    n = 0;
                } else if (entity2.heatBuildup > 0 || entity2.isStealthActive()) {
                    bl2 = true;
                } else {
                    object = iGame.getActions();
                    while (object.hasMoreElements()) {
                        Mounted mounted;
                        WeaponType weaponType;
                        WeaponAttackAction weaponAttackAction;
                        searchlightAttackAction = object.nextElement();
                        if (!(searchlightAttackAction instanceof WeaponAttackAction) || (weaponAttackAction = (WeaponAttackAction)((Object)searchlightAttackAction)).getEntityId() != entity2.getId() || (weaponType = (WeaponType)(mounted = entity2.getEquipment(weaponAttackAction.getWeaponId())).getType()).getHeat() == 0 && !mounted.isRapidfire()) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (bl2) {
                    toHitData.addModifier(-1, "target uses laser heatsinks");
                }
            }
        }
        return toHitData;
    }
}

