/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Mech;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.PhysicalAttackAction;

public class BreakGrappleAttackAction
extends PhysicalAttackAction {
    public BreakGrappleAttackAction(int n, int n2) {
        super(n, n2);
    }

    public BreakGrappleAttackAction(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public ToHitData toHit(IGame iGame) {
        return BreakGrappleAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()));
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable) {
        int n2;
        Entity entity = iGame.getEntity(n);
        if (entity == null) {
            return new ToHitData(Integer.MAX_VALUE, "You can't attack from a null entity!");
        }
        if (!iGame.getOptions().booleanOption("maxtech_new_physicals")) {
            return new ToHitData(Integer.MAX_VALUE, "no MaxTech physicals");
        }
        String string = BreakGrappleAttackAction.toHitIsImpossible(iGame, entity, targetable);
        if (string != null && !string.equals("Locked in Grapple")) {
            return new ToHitData(Integer.MAX_VALUE, "impossible");
        }
        if (!(entity instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Only mechs should be grappled");
        }
        if (((Mech)entity).getGrappled() != targetable.getTargetId()) {
            return new ToHitData(Integer.MAX_VALUE, "Not grappled");
        }
        int n3 = 5;
        if (iGame.getOptions().booleanOption("maxtech_physical_BTH")) {
            n3 = entity.getCrew().getPiloting();
        }
        ToHitData toHitData = new ToHitData(n3, "base");
        if (((Mech)entity).isGrappleAttacker()) {
            toHitData.addModifier(Integer.MIN_VALUE, "original attacker");
            return toHitData;
        }
        BreakGrappleAttackAction.setCommonModifiers(toHitData, iGame, entity, targetable);
        if (!entity.hasWorkingSystem(7, 5)) {
            toHitData.addModifier(2, "Left shoulder actuator destroyed");
        }
        if (!entity.hasWorkingSystem(8, 5)) {
            toHitData.addModifier(2, "Left upper arm actuator destroyed");
        }
        if (!entity.hasWorkingSystem(9, 5)) {
            toHitData.addModifier(2, "Left lower arm actuator destroyed");
        }
        if (!entity.hasWorkingSystem(10, 5)) {
            toHitData.addModifier(1, "Left hand actuator destroyed");
        }
        if (!entity.hasWorkingSystem(7, 4)) {
            toHitData.addModifier(2, "Right shoulder actuator destroyed");
        }
        if (!entity.hasWorkingSystem(8, 4)) {
            toHitData.addModifier(2, "Right upper arm actuator destroyed");
        }
        if (!entity.hasWorkingSystem(9, 4)) {
            toHitData.addModifier(2, "Right lower arm actuator destroyed");
        }
        if (!entity.hasWorkingSystem(10, 4)) {
            toHitData.addModifier(1, "Right hand actuator destroyed");
        }
        if ((n2 = ((Entity)targetable).getWeightClass() - entity.getWeightClass()) != 0) {
            toHitData.addModifier(n2, "Weight class difference");
        }
        return toHitData;
    }
}

