/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import java.util.Iterator;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.PunchAttackAction;

public class BrushOffAttackAction
extends AbstractAttackAction {
    public static final int BOTH = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    private int arm;

    public BrushOffAttackAction(int n, int n2, int n3, int n4) {
        super(n, n2, n3);
        this.arm = n4;
    }

    public int getArm() {
        return this.arm;
    }

    public void setArm(int n) {
        this.arm = n;
    }

    public static int getDamageFor(Entity entity, int n) {
        return PunchAttackAction.getDamageFor(entity, n);
    }

    public ToHitData toHit(IGame iGame) {
        return BrushOffAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()), this.getArm());
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2) {
        int n3;
        Entity entity = iGame.getEntity(n);
        int n4 = -1;
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
            n4 = targetable.getTargetId();
        }
        int n5 = n3 = n2 == 2 ? 4 : 5;
        if (!(entity instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Only mechs can brush off swarming infantry or iNarc Pods");
        }
        if (n2 != 2 && n2 != 1) {
            throw new IllegalArgumentException("Arm must be LEFT or RIGHT");
        }
        if (entity == null || targetable == null) {
            throw new IllegalArgumentException("Attacker or target not valid");
        }
        if (!(n4 == entity.getSwarmAttackerId() && entity2 != null && entity2 instanceof Infantry || targetable.getTargetType() == 11)) {
            return new ToHitData(Integer.MAX_VALUE, "Can only brush off swarming infantry or iNarc Pods");
        }
        if (entity.entityIsQuad()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is a quad");
        }
        if (entity.getArmsFlipped()) {
            return new ToHitData(Integer.MAX_VALUE, "Arms are flipped to the rear. Can not punch.");
        }
        if (entity.isLocationBad(n3)) {
            return new ToHitData(Integer.MAX_VALUE, "Arm missing");
        }
        if (!entity.hasWorkingSystem(7, n3)) {
            return new ToHitData(Integer.MAX_VALUE, "Shoulder destroyed");
        }
        if (entity.weaponFiredFrom(n3)) {
            return new ToHitData(Integer.MAX_VALUE, "Weapons fired from arm this turn");
        }
        if (entity2 != null && entity2.isMakingDfa()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is making a DFA attack");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 4 || targetable.getTargetType() == 15 || targetable.getTargetType() == 16 || targetable.getTargetType() == 1 || targetable.getTargetType() == 2) {
            return new ToHitData(Integer.MAX_VALUE, "Invalid attack");
        }
        ToHitData toHitData = new ToHitData(entity.getCrew().getPiloting(), "base PSR");
        toHitData.addModifier(4, "brush off swarming infantry");
        if (!entity.hasWorkingSystem(8, n3)) {
            toHitData.addModifier(2, "Upper arm actuator destroyed");
        }
        if (!entity.hasWorkingSystem(9, n3)) {
            toHitData.addModifier(2, "Lower arm actuator missing or destroyed");
        }
        if (!entity.hasWorkingSystem(10, n3)) {
            toHitData.addModifier(1, "Hand actuator missing or destroyed");
        }
        if (((Mech)entity).getCockpitType() == 1) {
            int n6;
            int n7 = entity.getBadCriticals(0, 1, 0);
            if (n7 + (n6 = entity.getBadCriticals(0, 1, 1)) == 3) {
                return new ToHitData(Integer.MAX_VALUE, "Sensors Completely Destroyed for Torso-Mounted Cockpit");
            }
            if (n7 == 2) {
                toHitData.addModifier(4, "Head Sensors Destroyed for Torso-Mounted Cockpit");
            }
        }
        Compute.modifyPhysicalBTHForAdvantages(entity, entity2, toHitData, iGame);
        if (entity2 != null) {
            Iterator<Mounted> iterator = entity2.getMisc().iterator();
            while (iterator.hasNext()) {
                Mounted mounted = iterator.next();
                EquipmentType equipmentType = mounted.getType();
                if (!"BA-Assault Claws".equals(equipmentType.getInternalName())) continue;
                toHitData.addModifier(1, "defender has assault claws");
                break;
            }
        }
        return toHitData;
    }
}

