/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.BipedMech;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.actions.AbstractEntityAction;

public class FindClubAction
extends AbstractEntityAction {
    public FindClubAction(int n) {
        super(n);
    }

    public static boolean canMechFindClub(IGame iGame, int n) {
        Entity entity = iGame.getEntity(n);
        if (null == entity.getPosition()) {
            return false;
        }
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        if (!(entity instanceof BipedMech)) {
            return false;
        }
        if (entity.isShutDown() || !entity.getCrew().isActive()) {
            return false;
        }
        if (entity.isSpotting()) {
            return false;
        }
        if (iGame.getOptions().booleanOption("no_clan_physical") && entity.isClan()) {
            return false;
        }
        if (iHex.terrainLevel(1) < 1 && iHex.terrainLevel(23) < 1 && iHex.terrainLevel(3) < 2 && iHex.terrainLevel(18) < 1 && iHex.terrainLevel(19) < 1) {
            return false;
        }
        if (!entity.hasWorkingSystem(7, 4) || !entity.hasWorkingSystem(7, 5) || !entity.hasWorkingSystem(10, 4) && !((BipedMech)entity).hasClaw(4) || !entity.hasWorkingSystem(10, 5) && !((BipedMech)entity).hasClaw(5)) {
            return false;
        }
        return entity.getClubs().size() <= 0;
    }
}

