/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import java.util.Iterator;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.GunEmplacement;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Tank;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.PhysicalAttackAction;

public class KickAttackAction
extends PhysicalAttackAction {
    public static final int BOTH = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int LEFTMULE = 3;
    public static final int RIGHTMULE = 4;
    private int leg;

    public KickAttackAction(int n, int n2, int n3) {
        super(n, n2);
        this.leg = n3;
    }

    public KickAttackAction(int n, int n2, int n3, int n4) {
        super(n, n2, n3);
        this.leg = n4;
    }

    public int getLeg() {
        return this.leg;
    }

    public void setLeg(int n) {
        this.leg = n;
    }

    public static int getDamageFor(Entity entity, int n) {
        int[] nArray = new int[2];
        if (entity.entityIsQuad() && n != 3 && n != 4) {
            nArray[0] = 4;
            nArray[1] = 5;
        } else {
            nArray[0] = 6;
            nArray[1] = 7;
        }
        int n2 = n == 2 || n == 4 ? nArray[0] : nArray[1];
        int n3 = (int)Math.floor((double)entity.getWeight() / 5.0);
        float f = 1.0f;
        if (!entity.hasWorkingSystem(12, n2)) {
            f /= 2.0f;
        }
        if (!entity.hasWorkingSystem(13, n2)) {
            f /= 2.0f;
        }
        if (!entity.hasWorkingSystem(11, n2)) {
            n3 = 0;
        }
        if (entity.heat >= 9 && ((Mech)entity).hasTSM()) {
            f *= 2.0f;
        }
        int n4 = (int)Math.floor((float)n3 * f) + entity.getCrew().modifyPhysicalDamagaForMeleeSpecialist();
        if (entity.getLocationStatus(n2) == 2) {
            n4 = (int)Math.ceil((float)n4 * 0.5f);
        }
        return n4;
    }

    public ToHitData toHit(IGame iGame) {
        return KickAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()), this.getLeg());
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2) {
        int n3;
        Entity entity = iGame.getEntity(n);
        if (entity == null) {
            return new ToHitData(Integer.MAX_VALUE, "You can't attack from a null entity!");
        }
        String string = KickAttackAction.toHitIsImpossible(iGame, entity, targetable);
        if (string != null) {
            return new ToHitData(Integer.MAX_VALUE, "impossible");
        }
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        IHex iHex2 = iGame.getBoard().getHex(targetable.getPosition());
        int n4 = entity.getElevation() + iHex.getElevation();
        int n5 = targetable.getElevation() + iHex2.getElevation();
        int n6 = n5 + targetable.getHeight();
        int n7 = 0;
        boolean bl = iGame.getOptions().booleanOption("maxtech_mulekicks");
        int[] nArray = new int[2];
        if (entity.entityIsQuad()) {
            if (bl && (n2 == 3 || n2 == 4)) {
                nArray[0] = 6;
                nArray[1] = 7;
                n7 = 1;
            } else {
                nArray[0] = 4;
                nArray[1] = 5;
            }
        } else {
            nArray[0] = 6;
            nArray[1] = 7;
        }
        int n8 = n3 = n2 == 4 || n2 == 2 ? nArray[0] : nArray[1];
        if (n2 != 2 && n2 != 1) {
            if (!iGame.getOptions().booleanOption("maxtech_mulekicks")) {
                throw new IllegalArgumentException("Leg must be LEFT or RIGHT");
            }
            if (n2 != 4 && n2 != 3) {
                throw new IllegalArgumentException("Leg must be one of LEFT, RIGHT, LEFTMULE, or RIGHTMULE");
            }
        }
        if (!(entity instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Non-mechs can't kick");
        }
        if (entity.isLocationBad(nArray[0]) || entity.isLocationBad(nArray[1])) {
            return new ToHitData(Integer.MAX_VALUE, "Leg missing");
        }
        if (!entity.hasWorkingSystem(11, nArray[0]) || !entity.hasWorkingSystem(11, nArray[1])) {
            return new ToHitData(Integer.MAX_VALUE, "Hip destroyed");
        }
        Iterator<Mounted> iterator = entity.getWeaponList().iterator();
        while (iterator.hasNext()) {
            Mounted mounted = iterator.next();
            if (!mounted.isUsedThisRound() || mounted.getLocation() != n3) continue;
            return new ToHitData(Integer.MAX_VALUE, "Weapons fired from leg this turn");
        }
        int n9 = entity.getPosition().distance(targetable.getPosition());
        if (targetable instanceof Infantry && 1 == n9) {
            return new ToHitData(Integer.MAX_VALUE, "Can only stomp Infantry in same hex");
        }
        if (n4 < n5 || n4 > n6) {
            return new ToHitData(Integer.MAX_VALUE, "Target elevation not in range");
        }
        if (0 != n9 && n7 != 1 && !Compute.isInArc(entity.getPosition(), entity.getFacing(), targetable.getPosition(), 1)) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        if (!(0 == n9 || n7 != 1 || Compute.isInArc(entity.getPosition(), entity.getFacing(), targetable.getPosition(), 4) || Compute.isInArc(entity.getPosition(), entity.getFacing(), targetable.getPosition(), 5) || Compute.isInArc(entity.getPosition(), entity.getFacing(), targetable.getPosition(), 6))) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15 || targetable instanceof GunEmplacement) {
            return new ToHitData(Integer.MIN_VALUE, "Targeting adjacent building.");
        }
        int n10 = 3;
        if (iGame.getOptions().booleanOption("maxtech_physical_BTH")) {
            n10 = entity.getCrew().getPiloting() - 2;
        }
        ToHitData toHitData = new ToHitData(n10, "base");
        KickAttackAction.setCommonModifiers(toHitData, iGame, entity, targetable);
        if (targetable instanceof Infantry) {
            toHitData.addModifier(3, "Stomping Infantry");
        }
        if (bl && n7 != 0) {
            toHitData.addModifier(n7, "Quad Mek making a mule kick");
        }
        if (!entity.hasWorkingSystem(12, n3)) {
            toHitData.addModifier(2, "Upper leg actuator destroyed");
        }
        if (!entity.hasWorkingSystem(13, n3)) {
            toHitData.addModifier(2, "Lower leg actuator destroyed");
        }
        if (!entity.hasWorkingSystem(14, n3)) {
            toHitData.addModifier(1, "Foot actuator destroyed");
        }
        if (n4 < n6) {
            toHitData.setHitTable(2);
        } else if (targetable.getHeight() > 0) {
            toHitData.setHitTable(1);
        } else {
            toHitData.setHitTable(0);
        }
        toHitData.setSideTable(Compute.targetSideTable(entity, targetable));
        if (0 == n9 && targetable instanceof Tank) {
            toHitData.setSideTable(4);
        }
        return toHitData;
    }
}

