/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import megamek.common.BattleArmor;
import megamek.common.Entity;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKBattleArmorFile
extends BLKFile
implements IMechLoader {
    public BLKBattleArmorFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        BattleArmor battleArmor = new BattleArmor();
        if (!this.dataFile.exists("name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        battleArmor.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            battleArmor.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            battleArmor.setModel("");
        }
        if (!this.dataFile.exists("year")) {
            throw new EntityLoadingException("Could not find year block.");
        }
        battleArmor.setYear(this.dataFile.getDataAsInt("year")[0]);
        if (!this.dataFile.exists("type")) {
            throw new EntityLoadingException("Could not find type block.");
        }
        if (this.dataFile.getDataAsString("type")[0].equals("IS Level 1")) {
            battleArmor.setTechLevel(0);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 2")) {
            battleArmor.setTechLevel(1);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 3")) {
            battleArmor.setTechLevel(5);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan Level 3")) {
            battleArmor.setTechLevel(6);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS")) {
            if (battleArmor.getYear() == 3025) {
                battleArmor.setTechLevel(0);
            } else {
                battleArmor.setTechLevel(1);
            }
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan")) {
            battleArmor.setTechLevel(2);
        }
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        battleArmor.setWeight(this.dataFile.getDataAsFloat("tonnage")[0]);
        if (!this.dataFile.exists("BV")) {
            throw new EntityLoadingException("Could not find BV block.");
        }
        battleArmor.setBattleValue(this.dataFile.getDataAsInt("BV")[0]);
        if (!this.dataFile.exists("motion_type")) {
            throw new EntityLoadingException("Could not find movement block.");
        }
        String string = this.dataFile.getDataAsString("motion_type")[0];
        int n = -1;
        if (string.equalsIgnoreCase("leg")) {
            n = 10;
        } else if (string.equalsIgnoreCase("jump")) {
            n = 12;
        } else if (string.equalsIgnoreCase("vtol")) {
            n = 6;
        }
        if (n == -1) {
            throw new EntityLoadingException("Invalid movement type: " + string);
        }
        battleArmor.setMovementMode(n);
        if (!this.dataFile.exists("cruiseMP")) {
            throw new EntityLoadingException("Could not find cruiseMP block.");
        }
        battleArmor.setOriginalRunMP(this.dataFile.getDataAsInt("cruiseMP")[0]);
        if (this.dataFile.exists("jumpingMP")) {
            battleArmor.setOriginalJumpMP(this.dataFile.getDataAsInt("jumpingMP")[0]);
        }
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find armor block.");
        }
        int[] nArray = this.dataFile.getDataAsInt("armor");
        if (nArray.length != 1) {
            throw new EntityLoadingException("Incorrect armor array length");
        }
        battleArmor.refreshLocations();
        for (int i = 1; i < battleArmor.locations(); ++i) {
            battleArmor.initializeArmor(nArray[0], i);
        }
        battleArmor.autoSetInternal();
        this.loadEquipment(battleArmor, "Squad", 0);
        String[] stringArray = battleArmor.getLocationAbbrs();
        for (int i = 1; i < battleArmor.locations(); ++i) {
            this.loadEquipment(battleArmor, stringArray[i], i);
        }
        return battleArmor;
    }
}

