/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import megamek.common.Entity;
import megamek.common.GunEmplacement;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKGunEmplacementFile
extends BLKFile
implements IMechLoader {
    public BLKGunEmplacementFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        GunEmplacement gunEmplacement = new GunEmplacement();
        if (!this.dataFile.exists("Name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        gunEmplacement.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            gunEmplacement.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            gunEmplacement.setModel("");
        }
        if (!this.dataFile.exists("Year")) {
            throw new EntityLoadingException("Could not find year block.");
        }
        gunEmplacement.setYear(this.dataFile.getDataAsInt("Year")[0]);
        if (!this.dataFile.exists("Type")) {
            throw new EntityLoadingException("Could not find type block.");
        }
        if (this.dataFile.getDataAsString("Type")[0].equals("IS")) {
            if (gunEmplacement.getYear() == 3025) {
                gunEmplacement.setTechLevel(0);
            } else {
                gunEmplacement.setTechLevel(1);
            }
        } else if (this.dataFile.getDataAsString("Type")[0].equals("IS Level 1")) {
            gunEmplacement.setTechLevel(0);
        } else if (this.dataFile.getDataAsString("Type")[0].equals("IS Level 2")) {
            gunEmplacement.setTechLevel(1);
        } else if (this.dataFile.getDataAsString("Type")[0].equals("IS Level 3")) {
            gunEmplacement.setTechLevel(5);
        } else if (this.dataFile.getDataAsString("Type")[0].equals("Clan")) {
            gunEmplacement.setTechLevel(2);
        } else if (this.dataFile.getDataAsString("Type")[0].equals("Clan Level 3")) {
            gunEmplacement.setTechLevel(6);
        } else if (this.dataFile.getDataAsString("Type")[0].equals("Mixed (IS Chassis)")) {
            gunEmplacement.setTechLevel(5);
            gunEmplacement.setMixedTech(true);
        } else if (this.dataFile.getDataAsString("Type")[0].equals("Mixed (Clan Chassis)")) {
            gunEmplacement.setTechLevel(6);
            gunEmplacement.setMixedTech(true);
        } else {
            if (this.dataFile.getDataAsString("Type")[0].equals("Mixed")) {
                throw new EntityLoadingException("Unsupported tech base: \"Mixed\" is no longer allowed by itself.  You must specify \"Mixed (IS Chassis)\" or \"Mixed (Clan Chassis)\".");
            }
            throw new EntityLoadingException("Unsupported tech level: " + this.dataFile.getDataAsString("Type")[0]);
        }
        if (!this.dataFile.exists("ConstructionFactor")) {
            throw new EntityLoadingException("Could not find block.");
        }
        gunEmplacement.initConstructionFactor(this.dataFile.getDataAsInt("ConstructionFactor")[0]);
        if (this.dataFile.exists("Height")) {
            gunEmplacement.setHeight(this.dataFile.getDataAsInt("Height")[0]);
        }
        if (this.dataFile.exists("Turret")) {
            gunEmplacement.setTurret(true);
            gunEmplacement.initTurretArmor(this.dataFile.getDataAsInt("Turret")[0]);
        }
        this.loadEquipment(gunEmplacement, "North", 1);
        this.loadEquipment(gunEmplacement, "East", 2);
        this.loadEquipment(gunEmplacement, "West", 3);
        if (gunEmplacement.hasTurret()) {
            this.loadEquipment(gunEmplacement, "Turret", 4);
        }
        this.loadEquipment(gunEmplacement, "Building", 0);
        return gunEmplacement;
    }
}

