/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import java.util.Vector;
import megamek.common.BipedMech;
import megamek.common.CriticalSlot;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.LocationFullException;
import megamek.common.Mech;
import megamek.common.QuadMech;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKMechFile
extends BLKFile
implements IMechLoader {
    public static final int HD = 0;
    public static final int LA = 1;
    public static final int LF = 2;
    public static final int LB = 3;
    public static final int CF = 4;
    public static final int CB = 5;
    public static final int RF = 6;
    public static final int RB = 7;
    public static final int RA = 8;
    public static final int LL = 9;
    public static final int RL = 10;
    public static final int CT = 4;
    public static final int RT = 6;
    public static final int LT = 2;

    public BLKMechFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        int n = 0;
        n = !this.dataFile.exists("chassis_type") ? 0 : this.dataFile.getDataAsInt("chassis_type")[0];
        Mech mech = null;
        mech = n == 1 ? new QuadMech() : new BipedMech();
        if (!this.dataFile.exists("name")) {
            throw new EntityLoadingException("Could not find block.");
        }
        mech.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (!this.dataFile.exists("model")) {
            throw new EntityLoadingException("Could not find block.");
        }
        mech.setModel(this.dataFile.getDataAsString("Model")[0]);
        if (!this.dataFile.exists("year")) {
            throw new EntityLoadingException("Could not find block.");
        }
        mech.setYear(this.dataFile.getDataAsInt("year")[0]);
        if (!this.dataFile.exists("type")) {
            throw new EntityLoadingException("Could not find block.");
        }
        if (this.dataFile.getDataAsString("type")[0].equals("IS")) {
            if (mech.getYear() == 3025) {
                mech.setTechLevel(0);
            } else {
                mech.setTechLevel(1);
            }
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 1")) {
            mech.setTechLevel(0);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 2")) {
            mech.setTechLevel(1);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 3")) {
            mech.setTechLevel(5);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan")) {
            mech.setTechLevel(2);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan Level 3")) {
            mech.setTechLevel(6);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (IS Chassis)")) {
            mech.setTechLevel(5);
            mech.setMixedTech(true);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (Clan Chassis)")) {
            mech.setTechLevel(6);
            mech.setMixedTech(true);
        } else {
            if (this.dataFile.getDataAsString("type")[0].equals("Mixed")) {
                throw new EntityLoadingException("Unsupported tech base: \"Mixed\" is no longer allowed by itself.  You must specify \"Mixed (IS Chassis)\" or \"Mixed (Clan Chassis)\".");
            }
            throw new EntityLoadingException("Unsupported tech level: " + this.dataFile.getDataAsString("type")[0]);
        }
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find block.");
        }
        mech.setWeight(this.dataFile.getDataAsFloat("tonnage")[0]);
        int n2 = 0;
        if (this.dataFile.exists("engine_type")) {
            n2 = this.dataFile.getDataAsInt("engine_type")[0];
        }
        int n3 = 0;
        if (mech.isClan()) {
            n3 = 1;
        }
        if (!this.dataFile.exists("walkingMP")) {
            throw new EntityLoadingException("Could not find walkingMP block.");
        }
        int n4 = this.dataFile.getDataAsInt("walkingMP")[0] * (int)mech.getWeight();
        mech.setEngine(new Engine(n4, BLKFile.translateEngineCode(n2), n3));
        if (!this.dataFile.exists("jumpingMP")) {
            throw new EntityLoadingException("Could not find block.");
        }
        mech.setOriginalJumpMP(this.dataFile.getDataAsInt("jumpingMP")[0]);
        if (!this.dataFile.exists("heatsinks")) {
            throw new EntityLoadingException("Could not find block.");
        }
        mech.addEngineSinks(this.dataFile.getDataAsInt("heatsinks")[0], false);
        if (this.dataFile.exists("internal_type")) {
            mech.setStructureType(this.dataFile.getDataAsInt("internal_type")[0]);
        }
        if (this.dataFile.exists("armor_type")) {
            mech.setArmorType(this.dataFile.getDataAsInt("armor_type")[0]);
        }
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find block.");
        }
        int[] nArray = new int[11];
        if (this.dataFile.getDataAsInt("armor").length < 11) {
            System.err.println("BLKMechFile->Read armor array doesn't match my armor array...");
            throw new EntityLoadingException("Could not find block.");
        }
        nArray = this.dataFile.getDataAsInt("Armor");
        mech.initializeArmor(nArray[0], 0);
        mech.initializeArmor(nArray[1], 5);
        mech.initializeArmor(nArray[8], 4);
        mech.initializeArmor(nArray[9], 7);
        mech.initializeArmor(nArray[10], 6);
        mech.initializeArmor(nArray[4], 1);
        mech.initializeArmor(nArray[2], 3);
        mech.initializeArmor(nArray[6], 2);
        mech.initializeRearArmor(nArray[5], 1);
        mech.initializeRearArmor(nArray[3], 3);
        mech.initializeRearArmor(nArray[7], 2);
        if (!this.dataFile.exists("internal armor")) {
            mech.setInternal(3, (nArray[4] + nArray[5]) / 2, (nArray[2] + nArray[3]) / 2, nArray[1] / 2, nArray[9] / 2);
        } else {
            nArray = this.dataFile.getDataAsInt("internal armor");
            mech.setInternal(nArray[0], nArray[4], nArray[2], nArray[1], nArray[9]);
        }
        if (!this.dataFile.getDataAsString("ra criticals")[2].trim().equalsIgnoreCase("Lower Arm Actuator")) {
            mech.removeCriticals(4, new CriticalSlot(0, 9));
        }
        if (!this.dataFile.getDataAsString("ra criticals")[3].trim().equalsIgnoreCase("Hand Actuator")) {
            mech.removeCriticals(4, new CriticalSlot(0, 10));
        }
        if (!this.dataFile.getDataAsString("la criticals")[2].trim().equalsIgnoreCase("Lower Arm Actuator")) {
            mech.removeCriticals(5, new CriticalSlot(0, 9));
        }
        if (!this.dataFile.getDataAsString("la criticals")[3].trim().equalsIgnoreCase("Hand Actuator")) {
            mech.removeCriticals(5, new CriticalSlot(0, 10));
        }
        Vector[] vectorArray = new Vector[8];
        vectorArray[0] = this.dataFile.getDataAsVector("hd criticals");
        vectorArray[5] = this.dataFile.getDataAsVector("la criticals");
        vectorArray[4] = this.dataFile.getDataAsVector("ra criticals");
        vectorArray[7] = this.dataFile.getDataAsVector("ll criticals");
        vectorArray[6] = this.dataFile.getDataAsVector("rl criticals");
        vectorArray[3] = this.dataFile.getDataAsVector("lt criticals");
        vectorArray[2] = this.dataFile.getDataAsVector("rt criticals");
        vectorArray[1] = this.dataFile.getDataAsVector("ct criticals");
        String string = mech.getTechLevel() == 2 ? "Clan " : "IS ";
        for (int i = 0; i < vectorArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].size(); ++j) {
                String string2 = vectorArray[i].get(j).toString().trim();
                boolean bl = false;
                if (string2.startsWith("(R) ")) {
                    bl = true;
                    string2 = string2.substring(4);
                }
                if (string2.equalsIgnoreCase("Armored Cowl")) {
                    mech.setCowl(5);
                }
                if (string2.indexOf("Engine") != -1) {
                    mech.setCritical(i, j, new CriticalSlot(0, 3));
                    continue;
                }
                if (string2.equalsIgnoreCase("Life Support")) {
                    mech.setCritical(i, j, new CriticalSlot(0, 0));
                    continue;
                }
                if (string2.equalsIgnoreCase("Sensors")) {
                    mech.setCritical(i, j, new CriticalSlot(0, 1));
                    continue;
                }
                if (string2.equalsIgnoreCase("Cockpit")) {
                    mech.setCritical(i, j, new CriticalSlot(0, 2));
                    continue;
                }
                if (string2.equalsIgnoreCase("Gyro")) {
                    mech.setCritical(i, j, new CriticalSlot(0, 4));
                    continue;
                }
                EquipmentType equipmentType = EquipmentType.get(string2);
                if (equipmentType == null) {
                    equipmentType = EquipmentType.get(string + string2);
                }
                if (equipmentType == null) continue;
                try {
                    mech.addEquipment(equipmentType, i, bl);
                    continue;
                }
                catch (LocationFullException locationFullException) {
                    throw new EntityLoadingException(locationFullException.getMessage());
                }
            }
        }
        if (mech.isClan()) {
            mech.addClanCase();
        }
        return mech;
    }
}

