/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.BipedMech;
import megamek.common.CriticalSlot;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.LocationFullException;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.QuadMech;
import megamek.common.WeaponType;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;

public class MtfFile
implements IMechLoader {
    String version;
    String name;
    String model;
    String chassisConfig;
    String techBase;
    String techYear;
    String rulesLevel;
    String tonnage;
    String engine;
    String internalType;
    String myomerType;
    String gyroType;
    String cockpitType;
    String heatSinks;
    String walkMP;
    String jumpMP;
    String armorType;
    String[] armorValues = new String[11];
    String weaponCount;
    String[] weaponData;
    String[][] critData;
    Hashtable hSharedEquip = new Hashtable();
    Vector vSplitWeapons = new Vector();
    public static final int[] locationOrder = new int[]{5, 4, 3, 2, 1, 0, 7, 6};
    public static final int[] rearLocationOrder = new int[]{3, 2, 1};
    public static final String EMPTY = "-Empty-";

    public MtfFile(InputStream inputStream) throws EntityLoadingException {
        try {
            int n;
            int n2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.version = bufferedReader.readLine();
            if (!this.version.trim().equalsIgnoreCase("Version:1.0") && !this.version.trim().equalsIgnoreCase("Version:1.1")) {
                throw new EntityLoadingException("Wrong MTF file version.");
            }
            this.name = bufferedReader.readLine();
            this.model = bufferedReader.readLine();
            bufferedReader.readLine();
            this.chassisConfig = bufferedReader.readLine();
            this.techBase = bufferedReader.readLine();
            this.techYear = bufferedReader.readLine();
            this.rulesLevel = bufferedReader.readLine();
            bufferedReader.readLine();
            String string = bufferedReader.readLine();
            while (string != null && string.length() > 0) {
                if (string.startsWith("Cockpit:")) {
                    this.cockpitType = string;
                } else if (string.startsWith("Gyro:")) {
                    this.gyroType = string;
                } else if (string.startsWith("Mass:")) {
                    this.tonnage = string;
                } else if (string.startsWith("Engine:")) {
                    this.engine = string;
                } else if (string.startsWith("Structure:")) {
                    this.internalType = string;
                } else if (string.startsWith("Myomer:")) {
                    this.myomerType = string;
                }
                string = bufferedReader.readLine();
            }
            this.heatSinks = bufferedReader.readLine();
            this.walkMP = bufferedReader.readLine();
            this.jumpMP = bufferedReader.readLine();
            bufferedReader.readLine();
            this.armorType = bufferedReader.readLine();
            for (n2 = 0; n2 < this.armorValues.length; ++n2) {
                this.armorValues[n2] = bufferedReader.readLine();
            }
            bufferedReader.readLine();
            this.weaponCount = bufferedReader.readLine();
            n2 = Integer.parseInt(this.weaponCount.substring(8));
            this.weaponData = new String[n2];
            for (n = 0; n < n2; ++n) {
                this.weaponData[n] = bufferedReader.readLine();
            }
            this.critData = new String[8][12];
            for (n = 0; n < locationOrder.length; ++n) {
                this.readCrits(bufferedReader, locationOrder[n]);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new EntityLoadingException("I/O Error reading file");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            stringIndexOutOfBoundsException.printStackTrace();
            throw new EntityLoadingException("StringIndexOutOfBoundsException reading file (format error)");
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            throw new EntityLoadingException("NumberFormatException reading file (format error)");
        }
    }

    private void readCrits(BufferedReader bufferedReader, int n) throws IOException {
        bufferedReader.readLine();
        bufferedReader.readLine();
        for (int i = 0; i < 12; ++i) {
            this.critData[n][i] = bufferedReader.readLine();
        }
    }

    public Entity getEntity() throws EntityLoadingException {
        try {
            int n;
            Mech mech;
            block37: {
                block38: {
                    block36: {
                        int n2 = 0;
                        try {
                            n2 = Mech.getGyroTypeForString(this.gyroType.substring(5));
                            if (n2 == -1) {
                                n2 = 0;
                            }
                        }
                        catch (Exception exception) {
                            n2 = 0;
                        }
                        int n3 = 0;
                        try {
                            n3 = Mech.getCockpitTypeForString(this.cockpitType.substring(8));
                            if (n3 == -1) {
                                n3 = 0;
                            }
                        }
                        catch (Exception exception) {
                            n3 = 0;
                        }
                        mech = this.chassisConfig.indexOf("Quad") != -1 ? new QuadMech(n2, n3) : new BipedMech(n2, n3);
                        int n4 = this.name.indexOf("(");
                        if (n4 == -1) {
                            mech.setChassis(this.name.trim());
                        } else {
                            mech.setChassis(this.name.substring(0, n4 - 1).trim());
                        }
                        mech.setModel(this.model.trim());
                        mech.setYear(Integer.parseInt(this.techYear.substring(4).trim()));
                        if (this.chassisConfig.indexOf("Omni") != -1) {
                            mech.setOmni(true);
                        }
                        if (!this.techBase.substring(9).trim().equals("Inner Sphere")) break block36;
                        switch (Integer.parseInt(this.rulesLevel.substring(12).trim())) {
                            case 1: {
                                mech.setTechLevel(0);
                                break block37;
                            }
                            case 2: {
                                mech.setTechLevel(1);
                                break block37;
                            }
                            case 3: {
                                mech.setTechLevel(5);
                                break block37;
                            }
                            default: {
                                throw new EntityLoadingException("Unsupported tech level: " + this.rulesLevel.substring(12).trim());
                            }
                        }
                    }
                    if (!this.techBase.substring(9).trim().equals("Clan")) break block38;
                    switch (Integer.parseInt(this.rulesLevel.substring(12).trim())) {
                        case 2: {
                            mech.setTechLevel(2);
                            break block37;
                        }
                        case 3: {
                            mech.setTechLevel(6);
                            break block37;
                        }
                        default: {
                            throw new EntityLoadingException("Unsupported tech level: " + this.rulesLevel.substring(12).trim());
                        }
                    }
                }
                if (this.techBase.substring(9).trim().equals("Mixed (IS Chassis)")) {
                    mech.setTechLevel(5);
                    mech.setMixedTech(true);
                } else if (this.techBase.substring(9).trim().equals("Mixed (Clan Chassis)")) {
                    mech.setTechLevel(6);
                    mech.setMixedTech(true);
                } else {
                    if (this.techBase.substring(9).trim().equals("Mixed")) {
                        throw new EntityLoadingException("Unsupported tech base: \"Mixed\" is no longer allowed by itself.  You must specify \"Mixed (IS Chassis)\" or \"Mixed (Clan Chassis)\".");
                    }
                    throw new EntityLoadingException("Unsupported tech base: " + this.techBase.substring(9).trim());
                }
            }
            mech.setWeight(Integer.parseInt(this.tonnage.substring(5)));
            int n5 = 0;
            if (mech.isClan() && !mech.isMixedTech() || mech.isMixedTech() && mech.isClan() && !mech.itemOppositeTech(this.engine)) {
                n5 = 1;
            }
            int n6 = Integer.parseInt(this.engine.substring(this.engine.indexOf(":") + 1, this.engine.indexOf(" ")));
            mech.setEngine(new Engine(n6, Engine.getEngineTypeByString(this.engine), n5));
            mech.setOriginalJumpMP(Integer.parseInt(this.jumpMP.substring(8)));
            boolean bl = this.heatSinks.substring(14).equalsIgnoreCase("Double") || this.heatSinks.substring(14).equalsIgnoreCase("Laser");
            int n7 = Integer.parseInt(this.heatSinks.substring(11, 14).trim());
            String string = this.internalType.substring(this.internalType.indexOf(58) + 1);
            if (string.length() > 0) {
                mech.setStructureType(string);
            } else {
                mech.setStructureType(0);
            }
            mech.autoSetInternal();
            String string2 = this.armorType.substring(this.armorType.indexOf(58) + 1);
            if (string2.length() > 0) {
                mech.setArmorType(string2);
            } else {
                mech.setArmorType(0);
            }
            for (n = 0; n < locationOrder.length; ++n) {
                mech.initializeArmor(Integer.parseInt(this.armorValues[n].substring(9)), locationOrder[n]);
            }
            for (n = 0; n < rearLocationOrder.length; ++n) {
                mech.initializeRearArmor(Integer.parseInt(this.armorValues[n + locationOrder.length].substring(10)), rearLocationOrder[n]);
            }
            this.compactCriticals(mech);
            for (n = mech.locations() - 1; n >= 0; --n) {
                this.parseCrits(mech, n);
            }
            if (mech.isClan()) {
                mech.addClanCase();
            }
            mech.addEngineSinks(n7 - mech.heatSinks(), bl);
            return mech;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            throw new EntityLoadingException("NumberFormatException parsing file");
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw new EntityLoadingException("NullPointerException parsing file");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            stringIndexOutOfBoundsException.printStackTrace();
            throw new EntityLoadingException("StringIndexOutOfBoundsException parsing file");
        }
    }

    private void parseCrits(Mech mech, int n) throws EntityLoadingException {
        if (!(mech instanceof QuadMech || n != 5 && n != 4)) {
            if (!this.critData[n][3].equals("Hand Actuator")) {
                mech.setCritical(n, 3, null);
            }
            if (!this.critData[n][2].equals("Lower Arm Actuator")) {
                mech.setCritical(n, 2, null);
            }
        }
        for (int i = 0; i < mech.getNumberOfCriticals(n); ++i) {
            if (mech.getCritical(n, i) != null) continue;
            String string = this.critData[n][i];
            string.trim();
            boolean bl = false;
            boolean bl2 = false;
            if (string.equalsIgnoreCase("Fusion Engine") || string.equalsIgnoreCase("Engine")) {
                mech.setCritical(n, i, new CriticalSlot(0, 3));
                continue;
            }
            if (string.equalsIgnoreCase("Life Support")) {
                mech.setCritical(n, i, new CriticalSlot(0, 0));
                continue;
            }
            if (string.equalsIgnoreCase("Sensors")) {
                mech.setCritical(n, i, new CriticalSlot(0, 1));
                continue;
            }
            if (string.equalsIgnoreCase("Cockpit")) {
                mech.setCritical(n, i, new CriticalSlot(0, 2));
                continue;
            }
            if (string.equalsIgnoreCase("Gyro")) {
                mech.setCritical(n, i, new CriticalSlot(0, 4));
                continue;
            }
            if (string.endsWith("(R)")) {
                bl = true;
                string = string.substring(0, string.length() - 3).trim();
            }
            if (string.endsWith("(Split)")) {
                bl2 = true;
                string = string.substring(0, string.length() - 7).trim();
            }
            if (string.equalsIgnoreCase("Armored Cowl")) {
                mech.setCowl(5);
            }
            try {
                EquipmentType equipmentType = EquipmentType.get(string);
                if (equipmentType != null) {
                    Mounted mounted;
                    if (equipmentType.isSpreadable()) {
                        mounted = (Mounted)this.hSharedEquip.get(equipmentType);
                        if (mounted != null) {
                            mech.addCritical(n, new CriticalSlot(1, mech.getEquipmentNum(mounted), equipmentType.isHittable()));
                            continue;
                        }
                        mounted = mech.addEquipment(equipmentType, n, bl);
                        this.hSharedEquip.put(equipmentType, mounted);
                        continue;
                    }
                    if (equipmentType instanceof WeaponType && equipmentType.hasFlag(256L)) {
                        int n2;
                        mounted = null;
                        boolean bl3 = false;
                        int n3 = this.vSplitWeapons.size();
                        for (n2 = 0; n2 < n3; ++n2) {
                            mounted = (Mounted)this.vSplitWeapons.elementAt(n2);
                            int n4 = mounted.getLocation();
                            if (n4 != n && n != Mech.getInnerLocation(n4) || mounted.getType() != equipmentType) continue;
                            bl3 = true;
                            break;
                        }
                        if (bl3) {
                            mounted.setFoundCrits(mounted.getFoundCrits() + 1);
                            if (mounted.getFoundCrits() >= equipmentType.getCriticals(mech)) {
                                this.vSplitWeapons.removeElement(mounted);
                            }
                            if (n != mounted.getLocation()) {
                                mounted.setSplit(true);
                            }
                            n2 = mounted.getLocation();
                            mounted.setLocation(Mech.mostRestrictiveLoc(n, n2));
                            if (n != n2) {
                                mounted.setSecondLocation(Mech.leastRestrictiveLoc(n, n2));
                            }
                        } else {
                            mounted = new Mounted(mech, equipmentType);
                            mounted.setFoundCrits(1);
                            this.vSplitWeapons.addElement(mounted);
                        }
                        mech.addEquipment(mounted, n, bl);
                        continue;
                    }
                    mech.addEquipment(equipmentType, n, bl);
                    continue;
                }
                if (string.equals(EMPTY)) continue;
                mech.addFailedEquipment(string);
                this.critData[n][i] = EMPTY;
                this.compactCriticals(mech, n);
                --i;
                continue;
            }
            catch (LocationFullException locationFullException) {
                throw new EntityLoadingException(locationFullException.getMessage());
            }
        }
    }

    private void compactCriticals(Mech mech) {
        for (int i = 0; i < mech.locations(); ++i) {
            this.compactCriticals(mech, i);
        }
    }

    private void compactCriticals(Mech mech, int n) {
        if (n == 0) {
            return;
        }
        int n2 = -1;
        for (int i = 0; i < mech.getNumberOfCriticals(n); ++i) {
            if (this.critData[n][i].equals(EMPTY)) {
                n2 = i;
            }
            if (n2 == -1 || this.critData[n][i].equals(EMPTY)) continue;
            this.critData[n][n2] = this.critData[n][i];
            this.critData[n][i] = EMPTY;
            i = n2;
            n2 = -1;
        }
    }
}

