/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.preference;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Locale;
import megamek.common.preference.IClientPreferences;
import megamek.common.preference.IPreferenceStore;
import megamek.common.preference.PreferenceStoreProxy;
import megamek.common.util.LocaleParser;

class ClientPreferences
extends PreferenceStoreProxy
implements IClientPreferences {
    protected PrintWriter mekHitLocLog = null;
    protected Locale locale = null;

    ClientPreferences(IPreferenceStore iPreferenceStore) {
        this.store = iPreferenceStore;
        iPreferenceStore.setDefault("LastConnectAddr", "localhost");
        iPreferenceStore.setDefault("LastConnectPort", 2346);
        iPreferenceStore.setDefault("LastServerPort", 2346);
        iPreferenceStore.setDefault("MapTileset", "classic.tileset");
        iPreferenceStore.setDefault("MaxPathfinderTime", 2000);
        iPreferenceStore.setDefault("DataDirectory", "data");
        iPreferenceStore.setDefault("LogDirectory", "logs");
        iPreferenceStore.setDefault("MechDirectory", iPreferenceStore.getDefaultString("DataDirectory") + File.separator + "mechfiles");
        iPreferenceStore.setDefault("MetaServerName", "http://www.damour.info/cgi-bin/james/metaserver");
        iPreferenceStore.setDefault("GoalPlayers", 2);
        iPreferenceStore.setDefault("KeepGameLog", true);
        iPreferenceStore.setDefault("GameLogFilename", "gamelog.txt");
        iPreferenceStore.setDefault("StampFormat", "_yyyy-MM-dd_HH-mm-ss");
        iPreferenceStore.setDefault("UnitStartChar", 65);
        iPreferenceStore.setDefault("GUIName", "AWT");
        this.setLocale(iPreferenceStore.getString("Locale"));
        this.setMekHitLocLog();
    }

    public String[] getAdvancedProperties() {
        return this.store.getAdvancedProperties();
    }

    public boolean defaultAutoejectDisabled() {
        return this.store.getBoolean("DefaultAutoejectDisabled");
    }

    public String getLastConnectAddr() {
        return this.store.getString("LastConnectAddr");
    }

    public int getLastConnectPort() {
        return this.store.getInt("LastConnectPort");
    }

    public String getLastPlayerName() {
        return this.store.getString("LastPlayerName");
    }

    public String getLastServerPass() {
        return this.store.getString("LastServerPass");
    }

    public int getLastServerPort() {
        return this.store.getInt("LastServerPort");
    }

    public String getMapTileset() {
        return this.store.getString("MapTileset");
    }

    public int getMaxPathfinderTime() {
        return this.store.getInt("MaxPathfinderTime");
    }

    public String getDataDirectory() {
        return this.store.getString("DataDirectory");
    }

    public String getLogDirectory() {
        return this.store.getString("LogDirectory");
    }

    public String getMechDirectory() {
        return this.store.getString("MechDirectory");
    }

    public PrintWriter getMekHitLocLog() {
        return this.mekHitLocLog;
    }

    public String getMetaServerName() {
        return this.store.getString("MetaServerName");
    }

    public void setMetaServerName(String string) {
        this.store.setValue("MetaServerName", string);
    }

    public int getGoalPlayers() {
        return this.store.getInt("GoalPlayers");
    }

    public void setGoalPlayers(int n) {
        this.store.setValue("GoalPlayers", n);
    }

    public String getGameLogFilename() {
        return this.store.getString("GameLogFilename");
    }

    public boolean stampFilenames() {
        return this.store.getBoolean("StampFilenames");
    }

    public String getStampFormat() {
        return this.store.getString("StampFormat");
    }

    public boolean getShowUnitId() {
        return this.store.getBoolean("ShowUnitId");
    }

    public char getUnitStartChar() {
        return (char)this.store.getInt("UnitStartChar");
    }

    public boolean keepGameLog() {
        return this.store.getBoolean("KeepGameLog");
    }

    public boolean memoryDumpOn() {
        return this.store.getBoolean("MemoryDumpOn");
    }

    public void setDefaultAutoejectDisabled(boolean bl) {
        this.store.setValue("DefaultAutoejectDisabled", bl);
    }

    public void setKeepGameLog(boolean bl) {
        this.store.setValue("KeepGameLog", bl);
    }

    public void setLastConnectAddr(String string) {
        this.store.setValue("LastConnectAddr", string);
    }

    public void setLastConnectPort(int n) {
        this.store.setValue("LastConnectPort", n);
    }

    public void setLastPlayerCamoName(String string) {
        if (string != null) {
            this.store.setValue("LastPlayerCamoName", string);
        }
    }

    public void setLastPlayerCategory(String string) {
        this.store.setValue("LastPlayerCategory", string);
    }

    public void setLastPlayerColor(int n) {
        this.store.setValue("LastPlayerColor", n);
    }

    public void setLastPlayerName(String string) {
        this.store.setValue("LastPlayerName", string);
    }

    public void setLastServerPass(String string) {
        this.store.setValue("LastServerPass", string);
    }

    public void setLastServerPort(int n) {
        this.store.setValue("LastServerPort", n);
    }

    public void setMapTileset(String string) {
        this.store.setValue("MapTileset", string);
    }

    public void setMaxPathfinderTime(int n) {
        this.store.setValue("MaxPathfinderTime", n);
    }

    public void setGameLogFilename(String string) {
        this.store.setValue("GameLogFilename", string);
    }

    public void setStampFilenames(boolean bl) {
        this.store.setValue("StampFilenames", bl);
    }

    public void setStampFormat(String string) {
        this.store.setValue("StampFormat", string);
    }

    public void setShowUnitId(boolean bl) {
        this.store.setValue("ShowUnitId", bl);
    }

    public void setUnitStartChar(char c) {
        this.store.setValue("UnitStartChar", c);
    }

    public String getGUIName() {
        return this.store.getString("GUIName");
    }

    public void setGUIName(String string) {
        this.store.setValue("GUIName", string);
    }

    public void setLocale(String string) {
        LocaleParser localeParser = new LocaleParser();
        if (!localeParser.parse(string)) {
            this.locale = new Locale(localeParser.getLanguage(), localeParser.getCountry(), localeParser.getVariant());
            this.store.setValue("Locale", this.getLocaleString());
        }
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.US;
        }
        return this.locale;
    }

    public String getLocaleString() {
        if (this.locale == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.locale.getLanguage().length() != 0) {
            stringBuffer.append(this.locale.getLanguage());
            if (this.locale.getCountry().length() != 0) {
                stringBuffer.append("_" + this.locale.getCountry());
                if (this.locale.getVariant().length() != 0) {
                    stringBuffer.append("_" + this.locale.getVariant());
                }
            }
        }
        return stringBuffer.toString();
    }

    protected void setMekHitLocLog() {
        String string = this.store.getString("MekHitLocLog");
        if (string.length() != 0) {
            try {
                this.mekHitLocLog = new PrintWriter(new BufferedWriter(new FileWriter(string)));
                this.mekHitLocLog.println("Table\tSide\tRoll");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.mekHitLocLog = null;
            }
        }
    }
}

