/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.verifier;

import gd.xml.tiny.ParsedXML;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.common.verifier.TestEntityOption;

public class TestXMLOption
implements TestEntityOption {
    public static final String CEIL_WEIGHT = "ceilWeight";
    public static final String SHOW_OVERWEIGHTED = "showOverweighted";
    public static final String MAX_OVERWEIGHT = "maxOverweight";
    public static final String SHOW_UNDERWEIGHTED = "showUnderweighted";
    public static final String MIN_UNDERWEIGHT = "minUnderweight";
    public static final String IGNORE_FAILED_EQUIP = "ignoreFailedEquipment";
    public static final String TARGCOMP_CRITS = "targCompCrits";
    public static final String SKIP = "skip";
    public static final String SHOW_CORRECTARMOR = "showCorrectArmorPlacement";
    public static final String SHOW_CORRECTCRITICAL = "showCorrectCriticalAllocation";
    public static final String SHOW_FAILEDEQUIP = "showFailedEquip";
    public static final String ENGINE = "engine";
    public static final String STRUCTURE = "structure";
    public static final String ARMOR = "armor";
    public static final String CONTROLS = "controls";
    public static final String WEAPONS = "weapons";
    public static final String TARGCOMP = "tragcomp";
    public static final String TURRET = "turret";
    public static final String POWERAMP = "poweramp";
    public static final String GYRO = "gyro";
    public static final String PRINTSIZE = "printSize";
    private float ceilEngine = 4.0f;
    private float ceilStructure = 4.0f;
    private float ceilArmor = 4.0f;
    private float ceilControls = 4.0f;
    private float ceilWeapons = 1.0f;
    private float ceilTargComp = 1.0f;
    private float ceilTurret = 4.0f;
    private float ceilPowerAmp = 4.0f;
    private float ceilGyro = 1.0f;
    private float maxOverweight = 0.25f;
    private boolean showOverweighted = true;
    private float minUnderweight = 1.0f;
    private boolean showUnderweighted = false;
    private Vector ignoreFailedEquip = new Vector();
    private boolean skip = false;
    private boolean showCorrectArmor = true;
    private boolean showCorrectCritical = true;
    private boolean showFailedEquip = true;
    private int targCompCrits = 0;
    private int printSize = 70;

    private static String getContent(ParsedXML parsedXML) {
        if (parsedXML.elements().hasMoreElements()) {
            return ((ParsedXML)parsedXML.elements().nextElement()).getContent();
        }
        return "";
    }

    private static float getContentAsFloat(ParsedXML parsedXML) {
        if (parsedXML.elements().hasMoreElements()) {
            return Float.valueOf(((ParsedXML)parsedXML.elements().nextElement()).getContent().trim()).floatValue();
        }
        return 0.0f;
    }

    private static boolean getContentAsBoolean(ParsedXML parsedXML) {
        if (parsedXML.elements().hasMoreElements()) {
            return new Boolean(((ParsedXML)parsedXML.elements().nextElement()).getContent().trim());
        }
        return false;
    }

    private static int getContentAsInteger(ParsedXML parsedXML) {
        if (parsedXML.elements().hasMoreElements()) {
            return Integer.parseInt(((ParsedXML)parsedXML.elements().nextElement()).getContent().trim());
        }
        return 0;
    }

    public void readXMLOptions(ParsedXML parsedXML) {
        Enumeration enumeration = parsedXML.elements();
        while (enumeration.hasMoreElements()) {
            ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
            if (parsedXML2.getName().equals(CEIL_WEIGHT)) {
                this.readCeilWeight(parsedXML2);
                continue;
            }
            if (parsedXML2.getName().equals(MAX_OVERWEIGHT)) {
                this.maxOverweight = TestXMLOption.getContentAsFloat(parsedXML2);
                continue;
            }
            if (parsedXML2.getName().equals(SHOW_OVERWEIGHTED)) {
                this.showOverweighted = TestXMLOption.getContentAsBoolean(parsedXML2);
                continue;
            }
            if (parsedXML2.getName().equals(MIN_UNDERWEIGHT)) {
                this.minUnderweight = TestXMLOption.getContentAsFloat(parsedXML2);
                continue;
            }
            if (parsedXML2.getName().equals(SHOW_UNDERWEIGHTED)) {
                this.showUnderweighted = TestXMLOption.getContentAsBoolean(parsedXML2);
                continue;
            }
            if (parsedXML2.getName().equals(SHOW_CORRECTARMOR)) {
                this.showCorrectArmor = TestXMLOption.getContentAsBoolean(parsedXML2);
                continue;
            }
            if (parsedXML2.getName().equals(SHOW_CORRECTCRITICAL)) {
                this.showCorrectCritical = TestXMLOption.getContentAsBoolean(parsedXML2);
                continue;
            }
            if (parsedXML2.getName().equals(SHOW_FAILEDEQUIP)) {
                this.showFailedEquip = TestXMLOption.getContentAsBoolean(parsedXML2);
                continue;
            }
            if (parsedXML2.getName().equals(IGNORE_FAILED_EQUIP)) {
                StringTokenizer stringTokenizer = new StringTokenizer(TestXMLOption.getContent(parsedXML2), ",");
                while (stringTokenizer.hasMoreTokens()) {
                    this.ignoreFailedEquip.addElement(stringTokenizer.nextToken());
                }
                for (int i = 0; i < this.ignoreFailedEquip.size(); ++i) {
                    this.ignoreFailedEquip.setElementAt(((String)this.ignoreFailedEquip.elementAt(i)).trim(), i);
                }
                continue;
            }
            if (parsedXML2.getName().equals(SKIP)) {
                this.skip = TestXMLOption.getContentAsBoolean(parsedXML2);
                continue;
            }
            if (parsedXML2.getName().equals(TARGCOMP_CRITS)) {
                this.targCompCrits = TestXMLOption.getContentAsInteger(parsedXML2);
                continue;
            }
            if (!parsedXML2.getName().equals(PRINTSIZE)) continue;
            this.printSize = TestXMLOption.getContentAsInteger(parsedXML2);
        }
    }

    private void readCeilWeight(ParsedXML parsedXML) {
        Enumeration enumeration = parsedXML.elements();
        while (enumeration.hasMoreElements()) {
            ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
            String string = parsedXML2.getName();
            if (string.equals(ENGINE)) {
                this.ceilEngine = 1.0f / TestXMLOption.getContentAsFloat(parsedXML2);
                continue;
            }
            if (string.equals(STRUCTURE)) {
                this.ceilStructure = 1.0f / TestXMLOption.getContentAsFloat(parsedXML2);
                continue;
            }
            if (string.equals(ARMOR)) {
                this.ceilArmor = 1.0f / TestXMLOption.getContentAsFloat(parsedXML2);
                continue;
            }
            if (string.equals(CONTROLS)) {
                this.ceilControls = 1.0f / TestXMLOption.getContentAsFloat(parsedXML2);
                continue;
            }
            if (string.equals(WEAPONS)) {
                this.ceilWeapons = 1.0f / TestXMLOption.getContentAsFloat(parsedXML2);
                continue;
            }
            if (string.equals(TARGCOMP)) {
                this.ceilTargComp = 1.0f / TestXMLOption.getContentAsFloat(parsedXML2);
                continue;
            }
            if (string.equals(TURRET)) {
                this.ceilTurret = 1.0f / TestXMLOption.getContentAsFloat(parsedXML2);
                continue;
            }
            if (string.equals(POWERAMP)) {
                this.ceilPowerAmp = 1.0f / TestXMLOption.getContentAsFloat(parsedXML2);
                continue;
            }
            if (!string.equals(GYRO)) continue;
            this.ceilGyro = 1.0f / TestXMLOption.getContentAsFloat(parsedXML2);
        }
    }

    public float getWeightCeilingEngine() {
        return this.ceilEngine;
    }

    public float getWeightCeilingStructure() {
        return this.ceilStructure;
    }

    public float getWeightCeilingArmor() {
        return this.ceilArmor;
    }

    public float getWeightCeilingControls() {
        return this.ceilControls;
    }

    public float getWeightCeilingWeapons() {
        return this.ceilWeapons;
    }

    public float getWeightCeilingTargComp() {
        return this.ceilTargComp;
    }

    public float getWeightCeilingGyro() {
        return this.ceilGyro;
    }

    public float getWeightCeilingTurret() {
        return this.ceilTurret;
    }

    public float getWeightCeilingPowerAmp() {
        return this.ceilPowerAmp;
    }

    public float getMaxOverweight() {
        return this.maxOverweight;
    }

    public boolean showOverweightedEntity() {
        return this.showOverweighted;
    }

    public boolean showUnderweightedEntity() {
        return this.showUnderweighted;
    }

    public float getMinUnderweight() {
        return this.minUnderweight;
    }

    public boolean ignoreFailedEquip(String string) {
        for (int i = 0; i < this.ignoreFailedEquip.size(); ++i) {
            if (!this.ignoreFailedEquip.elementAt(i).equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean skip() {
        return this.skip;
    }

    public boolean showCorrectArmor() {
        return this.showCorrectArmor;
    }

    public boolean showCorrectCritical() {
        return this.showCorrectCritical;
    }

    public boolean showFailedEquip() {
        return this.showFailedEquip;
    }

    public int getTargCompCrits() {
        return this.targCompCrits;
    }

    public int getPrintSize() {
        return this.printSize;
    }

    public String printIgnoredFailedEquip() {
        System.out.println("--->printIgnoredFailedEquip");
        String string = "";
        for (int i = 0; i < this.ignoreFailedEquip.size(); ++i) {
            string = string + "  " + this.ignoreFailedEquip.elementAt(i) + "\n";
        }
        return string;
    }

    public String printOptions() {
        return "Skip: " + this.skip() + "\n" + "Show Overweighted Entity: " + this.showOverweightedEntity() + "\n" + "Max Overweight: " + Float.toString(this.getMaxOverweight()) + "\n" + "Show Underweighted Entity: " + this.showUnderweightedEntity() + "\n" + "Min Underweight: " + Float.toString(this.getMinUnderweight()) + "\n" + "Show bad Armor Placement: " + this.showCorrectArmor() + "\n" + "Show bad Critical Allocation: " + this.showCorrectCritical() + "\n" + "Show Failed to Load Equipment: " + this.showFailedEquip() + "\n" + "Weight Ceiling Engine: " + Float.toString(1.0f / this.getWeightCeilingEngine()) + "\n" + "Weight Ceiling Structure: " + Float.toString(1.0f / this.getWeightCeilingStructure()) + "\n" + "Weight Ceiling Armor: " + Float.toString(1.0f / this.getWeightCeilingArmor()) + "\n" + "Weight Ceiling Controls: " + Float.toString(1.0f / this.getWeightCeilingControls()) + "\n" + "Weight Ceiling Weapons: " + Float.toString(1.0f / this.getWeightCeilingWeapons()) + "\n" + "Weight Ceiling TargComp: " + Float.toString(1.0f / this.getWeightCeilingTargComp()) + "\n" + "Weight Ceiling Gyro: " + Float.toString(1.0f / this.getWeightCeilingGyro()) + "\n" + "Weight Ceiling Turret: " + Float.toString(1.0f / this.getWeightCeilingTurret()) + "\n" + "Weight Ceiling PowerAmp: " + Float.toString(1.0f / this.getWeightCeilingPowerAmp()) + "\n" + "Ignore Failed Equipment: \n" + this.printIgnoredFailedEquip();
    }
}

