/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.xml;

import com.Ostermiller.util.Base64;
import gd.xml.ParseException;
import gd.xml.tiny.ParsedXML;
import gd.xml.tiny.TinyParser;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import megamek.common.Board;
import megamek.common.IGame;
import megamek.common.net.Packet;
import megamek.common.xml.BoardEncoder;

public class PacketEncoder {
    private static final String START = "<dummy>";
    private static final String END = "</dummy>";
    private static final /* synthetic */ Class class$java$lang$Integer;
    private static final /* synthetic */ Class class$megamek$common$IBoard;

    private static void encodeData(Packet packet, Writer writer) throws IOException {
        Object[] objectArray = packet.getData();
        for (int i = 0; i < objectArray.length; ++i) {
            if (null == objectArray[i]) {
                writer.write("<null />");
                continue;
            }
            if (objectArray[i].getClass().equals(class$java$lang$Integer == null ? PacketEncoder.class$("java.lang.Integer") : class$java$lang$Integer)) {
                writer.write("<integer value=\"");
                writer.write(objectArray[i].toString());
                writer.write("\" />");
                continue;
            }
            if (!objectArray[i].getClass().equals(class$megamek$common$IBoard == null ? PacketEncoder.class$("megamek.common.IBoard") : class$megamek$common$IBoard)) continue;
            BoardEncoder.encode((Board)objectArray[i], writer);
        }
    }

    private static Object decodeData(ParsedXML parsedXML, IGame iGame) {
        Object object = null;
        if (parsedXML.getName().equals("null")) {
            object = null;
        } else if (parsedXML.getName().equals("integer")) {
            object = new Integer(parsedXML.getAttribute("value"));
        } else if (parsedXML.getName().equals("board")) {
            object = BoardEncoder.decode(parsedXML, iGame);
        }
        return object;
    }

    public static void encode(Packet packet, Writer writer) throws IOException {
        if (null == packet) {
            throw new IllegalArgumentException("The packet is null.");
        }
        if (null == writer) {
            throw new IllegalArgumentException("The writer is null.");
        }
        writer.write("<packet type=\"");
        writer.write(Integer.toString(packet.getCommand()));
        writer.write("\" >");
        boolean bl = false;
        Object[] objectArray = packet.getData();
        if (null != objectArray) {
            if (bl) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(byteArrayOutputStream)));
                PacketEncoder.encodeData(packet, bufferedWriter);
                ((Writer)bufferedWriter).close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream((4 * byArray.length + 2) / 3);
                Base64.encode(new ByteArrayInputStream(byArray), byteArrayOutputStream2, false);
                writer.write("<packetData count=\"");
                writer.write(Integer.toString(objectArray.length));
                writer.write("\" isGzipped=\"true\" >");
                writer.write(byteArrayOutputStream2.toString());
                writer.write("</packetData>");
            } else {
                writer.write("<packetData count=\"");
                writer.write(Integer.toString(objectArray.length));
                writer.write("\" isGzipped=\"false\" >");
                PacketEncoder.encodeData(packet, writer);
                writer.write("</packetData>");
            }
        }
        writer.write("</packet>");
    }

    public static Packet decode(ParsedXML parsedXML, IGame iGame) {
        Packet packet = null;
        int n = 0;
        Object[] objectArray = null;
        if (null == parsedXML) {
            throw new IllegalArgumentException("The passed node is null.");
        }
        if (!parsedXML.getName().equals("packet")) {
            throw new IllegalStateException("The passed node is not for a packet.");
        }
        String string = parsedXML.getAttribute("type");
        if (null == string) {
            throw new IllegalStateException("Could not determine the packet type.");
        }
        n = Integer.parseInt(string);
        Enumeration enumeration = parsedXML.elements();
        while (enumeration.hasMoreElements()) {
            ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
            if (!parsedXML2.getName().equals("packetData")) continue;
            int n2 = Integer.parseInt(parsedXML2.getAttribute("count"));
            objectArray = new Object[n2];
            Enumeration enumeration2 = null;
            if (parsedXML2.getAttribute("isGzipped").equals("true")) {
                Object object;
                Object object2;
                String string2 = parsedXML2.getContent();
                if (null == string2) {
                    object2 = parsedXML2.elements();
                    while (object2.hasMoreElements() && null == string2) {
                        object = (ParsedXML)object2.nextElement();
                        if (object.getTypeName().equals("text")) {
                            string2 = object.getContent();
                            continue;
                        }
                        if (!object.getTypeName().equals("cdata")) continue;
                        string2 = object.getContent();
                    }
                }
                if (null == string2) {
                    throw new IllegalStateException("Could not find CDATA for packetData.");
                }
                object2 = Base64.decodeToBytes(string2);
                try {
                    object = new GZIPInputStream(new ByteArrayInputStream((byte[])object2));
                }
                catch (IOException iOException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Could not unzip data elements: ").append(iOException.getMessage());
                    throw new IllegalStateException(stringBuffer.toString());
                }
                try {
                    ParsedXML parsedXML3 = TinyParser.parseXML((InputStream)object);
                    enumeration2 = parsedXML3.elements();
                }
                catch (ParseException parseException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Could not parse data elements: ").append(parseException.getMessage());
                    throw new IllegalStateException(stringBuffer.toString());
                }
            }
            enumeration2 = parsedXML2.elements();
            int n3 = 0;
            while (enumeration2.hasMoreElements()) {
                objectArray[n3] = PacketEncoder.decodeData((ParsedXML)enumeration2.nextElement(), iGame);
                ++n3;
            }
        }
        packet = null != objectArray ? new Packet(n, objectArray) : new Packet(n);
        return packet;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

