/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import java.util.ArrayList;
import java.util.Vector;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.IBoard;
import megamek.common.IHex;
import megamek.common.ITerrain;
import megamek.common.ITerrainFactory;
import megamek.common.Report;
import megamek.common.Terrains;
import megamek.server.DynamicTerrainProcessor;
import megamek.server.Server;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElevatorProcessor
extends DynamicTerrainProcessor {
    private ElevatorInfo[] elevators = null;

    public ElevatorProcessor(Server server) {
        super(server);
    }

    @Override
    void DoEndPhaseChanges(Vector<Report> vector) {
        int n;
        if (this.elevators == null || this.server.getGame().getRoundCount() == 1) {
            this.elevators = new ElevatorInfo[6];
            for (n = 0; n < 6; ++n) {
                this.elevators[n] = new ElevatorInfo();
            }
            this.findElevators();
        }
        n = Compute.d6() - 1;
        if (this.elevators[n].positions.size() == 0) {
            return;
        }
        Report report = new Report(5290);
        vector.add(report);
        ITerrainFactory iTerrainFactory = Terrains.getTerrainFactory();
        for (Coords coords : this.elevators[n].positions) {
            IHex iHex = this.server.getGame().getBoard().getHex(coords);
            ITerrain iTerrain = iHex.getTerrain(31);
            int n2 = iHex.getElevation();
            iHex.setElevation(iTerrain.getLevel());
            iHex.removeTerrain(31);
            iHex.addTerrain(iTerrainFactory.createTerrain(31, n2, true, iTerrain.getExits()));
            this.server.sendChangedHex(coords);
        }
    }

    private void findElevators() {
        IBoard iBoard = this.server.getGame().getBoard();
        int n = iBoard.getHeight();
        int n2 = iBoard.getWidth();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!iBoard.getHex(i, j).containsTerrain(31)) continue;
                n3 = iBoard.getHex(i, j).getTerrain(31).getExits();
                for (int k = 0; k < 6; ++k) {
                    if ((n3 & 1) == 1) {
                        this.elevators[k].positions.add(new Coords(i, j));
                    }
                    n3 >>= 1;
                }
            }
        }
    }

    private class ElevatorInfo {
        ArrayList<Coords> positions = new ArrayList();

        private ElevatorInfo() {
        }
    }
}

