/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.Collections;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import megamek.MegaMek;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.BipedMech;
import megamek.common.Board;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.EquipmentMode;
import megamek.common.EquipmentType;
import megamek.common.Flare;
import megamek.common.FuelTank;
import megamek.common.Game;
import megamek.common.GameTurn;
import megamek.common.GunEmplacement;
import megamek.common.HitData;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.INarcPod;
import megamek.common.Infantry;
import megamek.common.InfernoTracker;
import megamek.common.LocationFullException;
import megamek.common.LosEffects;
import megamek.common.MapSettings;
import megamek.common.Mech;
import megamek.common.MechWarrior;
import megamek.common.Minefield;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.MoveStep;
import megamek.common.PhysicalResult;
import megamek.common.Pilot;
import megamek.common.PilotingRollData;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Report;
import megamek.common.RoundUpdated;
import megamek.common.TagInfo;
import megamek.common.Tank;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.Team;
import megamek.common.Terrain;
import megamek.common.Terrains;
import megamek.common.ToHitData;
import megamek.common.TurnOrdered;
import megamek.common.TurnVectors;
import megamek.common.UnitLocation;
import megamek.common.VTOL;
import megamek.common.WeaponResult;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.AbstractEntityAction;
import megamek.common.actions.ArtilleryAttackAction;
import megamek.common.actions.AttackAction;
import megamek.common.actions.BreakGrappleAttackAction;
import megamek.common.actions.BrushOffAttackAction;
import megamek.common.actions.ChargeAttackAction;
import megamek.common.actions.ClearMinefieldAction;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.DfaAttackAction;
import megamek.common.actions.DisplacementAttackAction;
import megamek.common.actions.DodgeAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.FindClubAction;
import megamek.common.actions.FlipArmsAction;
import megamek.common.actions.GrappleAttackAction;
import megamek.common.actions.JumpJetAttackAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.LayExplosivesAttackAction;
import megamek.common.actions.LayMinefieldAction;
import megamek.common.actions.NukeAttackAction;
import megamek.common.actions.ProtomechPhysicalAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.PushAttackAction;
import megamek.common.actions.SearchlightAttackAction;
import megamek.common.actions.SpotAction;
import megamek.common.actions.ThrashAttackAction;
import megamek.common.actions.TorsoTwistAction;
import megamek.common.actions.TriggerAPPodAction;
import megamek.common.actions.TripAttackAction;
import megamek.common.actions.UnjamAction;
import megamek.common.actions.UnloadStrandedAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.net.Connection;
import megamek.common.net.ConnectionFactory;
import megamek.common.net.ConnectionListenerAdapter;
import megamek.common.net.DisconnectedEvent;
import megamek.common.net.Packet;
import megamek.common.net.PacketReceivedEvent;
import megamek.common.options.IBasicOption;
import megamek.common.options.IOption;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.BoardUtilities;
import megamek.common.util.StringUtil;
import megamek.common.verifier.EntityVerifier;
import megamek.common.verifier.TestEntity;
import megamek.common.verifier.TestMech;
import megamek.common.verifier.TestTank;
import megamek.server.DynamicTerrainProcessor;
import megamek.server.ElevatorProcessor;
import megamek.server.FireProcessor;
import megamek.server.GeyserProcessor;
import megamek.server.UnitStatusFormatter;
import megamek.server.commands.DefeatCommand;
import megamek.server.commands.FixElevationCommand;
import megamek.server.commands.HelpCommand;
import megamek.server.commands.KickCommand;
import megamek.server.commands.LocalSaveGameCommand;
import megamek.server.commands.NukeCommand;
import megamek.server.commands.ResetCommand;
import megamek.server.commands.RollCommand;
import megamek.server.commands.SaveGameCommand;
import megamek.server.commands.SeeAllCommand;
import megamek.server.commands.ServerCommand;
import megamek.server.commands.SkipCommand;
import megamek.server.commands.VictoryCommand;
import megamek.server.commands.WhoCommand;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements Runnable {
    public static final String DEFAULT_BOARD = "[SURPRISE]";
    private static final String VERIFIER_CONFIG_FILENAME = "data/mechfiles/UnitVerifierOptions.xml";
    private String password;
    private ServerSocket serverSocket;
    private String motd;
    private Vector connections = new Vector(4);
    private Vector connectionsPending = new Vector(4);
    private Hashtable connectionIds = new Hashtable();
    private int connectionCounter;
    private int entityCounter;
    private IGame game = new Game();
    private Vector vPhaseReport = new Vector();
    private MapSettings mapSettings = new MapSettings();
    private Hashtable commandsHash = new Hashtable();
    private Thread connector;
    private Hashtable affectedBldgs = new Hashtable();
    private Vector physicalResults = new Vector();
    private Vector<DynamicTerrainProcessor> terrainProcessors = new Vector();
    private Timer timer = new Timer();
    private static EntityVerifier entityVerifier;
    private ConnectionListenerAdapter connectionListener = new ConnectionListenerAdapter(){

        public void disconnected(DisconnectedEvent disconnectedEvent) {
            Connection connection = disconnectedEvent.getConnection();
            System.out.println("s: connection " + connection.getId() + " disconnected");
            Server.this.connections.removeElement(connection);
            Server.this.connectionsPending.removeElement(connection);
            Server.this.connectionIds.remove(new Integer(connection.getId()));
            Player player = Server.this.getPlayer(connection.getId());
            if (null != player) {
                Server.this.disconnected(player);
            }
        }

        public void packetReceived(PacketReceivedEvent packetReceivedEvent) {
            Server.this.handle(packetReceivedEvent.getConnection().getId(), packetReceivedEvent.getPacket());
        }
    };
    private static final String DUNE_CALL = "They tried and failed?";
    private static final String DUNE_RESPONSE = "They tried and died!";
    private static final String STAR_WARS_CALL = "I'd just as soon kiss a Wookiee.";
    private static final String STAR_WARS_RESPONSE = "I can arrange that!";

    public Server(String string, int n) throws IOException {
        this.password = string.length() > 0 ? string : null;
        this.serverSocket = new ServerSocket(n);
        this.motd = this.createMotd();
        this.game.getOptions().initialize();
        this.game.getOptions().loadOptions();
        this.changePhase(1);
        System.out.println("s: starting a new server...");
        try {
            String string2 = InetAddress.getLocalHost().getHostName();
            System.out.print("s: hostname = '");
            System.out.print(string2);
            System.out.print("' port = ");
            System.out.println(this.serverSocket.getLocalPort());
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string2);
            for (int i = 0; i < inetAddressArray.length; ++i) {
                System.out.println(new StringBuffer().append("s: hosting on address = ").append(inetAddressArray[i].getHostAddress()).toString());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        System.out.println(new StringBuffer().append("s: password = ").append(this.password).toString());
        this.registerCommand(new DefeatCommand(this));
        this.registerCommand(new HelpCommand(this));
        this.registerCommand(new KickCommand(this));
        this.registerCommand(new ResetCommand(this));
        this.registerCommand(new RollCommand(this));
        this.registerCommand(new SaveGameCommand(this));
        this.registerCommand(new SkipCommand(this));
        this.registerCommand(new VictoryCommand(this));
        this.registerCommand(new WhoCommand(this));
        this.registerCommand(new SeeAllCommand(this));
        this.registerCommand(new LocalSaveGameCommand(this));
        this.registerCommand(new FixElevationCommand(this));
        this.registerCommand(new NukeCommand(this));
        this.terrainProcessors.add(new FireProcessor(this));
        this.terrainProcessors.add(new GeyserProcessor(this));
        this.terrainProcessors.add(new ElevatorProcessor(this));
        this.connector = new Thread((Runnable)this, "Connection Listener");
        this.connector.start();
    }

    public void setGame(IGame iGame) {
        TurnOrdered turnOrdered;
        this.game = iGame;
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            turnOrdered = (Entity)enumeration.nextElement();
            ((Entity)turnOrdered).setGame(this.game);
        }
        this.game.setOutOfGameEntitiesVector(this.game.getOutOfGameEntitiesVector());
        enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            turnOrdered = (Player)enumeration.nextElement();
            ((Player)turnOrdered).setGame(this.game);
            ((Player)turnOrdered).setGhost(true);
        }
    }

    public IGame getGame() {
        return this.game;
    }

    private String createMotd() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Welcome to MegaMek.  Server is running version ");
        stringBuffer.append(MegaMek.VERSION);
        stringBuffer.append(", build date ");
        if (MegaMek.TIMESTAMP > 0L) {
            stringBuffer.append(new Date(MegaMek.TIMESTAMP).toString());
        } else {
            stringBuffer.append("unknown");
        }
        stringBuffer.append('.');
        return stringBuffer.toString();
    }

    public boolean isPassworded() {
        return this.password != null;
    }

    public boolean isPassword(Object object) {
        return this.password.equals(object);
    }

    private void registerCommand(ServerCommand serverCommand) {
        this.commandsHash.put(serverCommand.getName(), serverCommand);
    }

    public ServerCommand getCommand(String string) {
        return (ServerCommand)this.commandsHash.get(string);
    }

    public void die() {
        Connection connection;
        this.timer.cancel();
        this.connector = null;
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Enumeration enumeration = this.connectionsPending.elements();
        while (enumeration.hasMoreElements()) {
            connection = (Connection)enumeration.nextElement();
            connection.close();
        }
        this.connectionsPending.removeAllElements();
        enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            connection = (Connection)enumeration.nextElement();
            this.send(connection.getId(), new Packet(0));
        }
        enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            connection = (Connection)enumeration.nextElement();
            connection.close();
        }
        this.connections.removeAllElements();
        this.connectionIds.clear();
        System.out.flush();
    }

    public Enumeration getAllCommandNames() {
        return this.commandsHash.keys();
    }

    private void greeting(int n) {
        this.sendToPending(n, new Packet(10));
    }

    public int getFreeConnectionId() {
        while (this.getPendingConnection(this.connectionCounter) != null || this.getConnection(this.connectionCounter) != null || this.getPlayer(this.connectionCounter) != null) {
            ++this.connectionCounter;
        }
        return this.connectionCounter;
    }

    public int getFreeEntityId() {
        return this.game.getNextEntityId();
    }

    private void receivePlayerInfo(Packet packet, int n) {
        Player player = (Player)packet.getObject(0);
        Player player2 = this.game.getPlayer(n);
        if (null != player2) {
            player2.setColorIndex(player.getColorIndex());
            player2.setStartingPos(player.getStartingPos());
            player2.setTeam(player.getTeam());
            player2.setCamoCategory(player.getCamoCategory());
            player2.setCamoFileName(player.getCamoFileName());
            player2.setNbrMFConventional(player.getNbrMFConventional());
            player2.setNbrMFCommand(player.getNbrMFCommand());
            player2.setNbrMFVibra(player.getNbrMFVibra());
        }
    }

    private String correctDupeName(String string) {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (!player.getName().equals(string)) continue;
            String string2 = string;
            int n = 2;
            try {
                n = Integer.parseInt(string.substring(string.lastIndexOf(".") + 1));
                ++n;
                string2 = string.substring(0, string.lastIndexOf("."));
            }
            catch (Exception exception) {
                n = 2;
            }
            string2 = string2.concat(".").concat(Integer.toString(n));
            return this.correctDupeName(string2);
        }
        return string;
    }

    private void receivePlayerName(Packet packet, int n) {
        Object object;
        Connection connection = this.getPendingConnection(n);
        String string = (String)packet.getObject(0);
        boolean bl = false;
        if (connection == null) {
            System.out.println("server: got a client name from a non-pending connection");
            return;
        }
        Object object2 = this.game.getPlayers();
        while (object2.hasMoreElements()) {
            object = (InetAddress[])object2.nextElement();
            if (!((Player)object).getName().equals(string) || !((Player)object).isGhost()) continue;
            bl = true;
            ((Player)object).setGhost(false);
            n = ((Player)object).getId();
            connection.setId(n);
        }
        if (!bl) {
            string = this.correctDupeName(string);
            this.send(n, new Packet(480, string));
        }
        this.connectionsPending.removeElement(connection);
        this.connections.addElement(connection);
        this.connectionIds.put(new Integer(connection.getId()), connection);
        if (!bl) {
            this.game.addPlayer(n, new Player(n, string));
            this.validatePlayerInfo(n);
        }
        object2 = this.getPlayer(n);
        if (this.game.getPhase() != 1 && null != object2 && this.game.getEntitiesOwnedBy((Player)object2) < 1) {
            ((Player)object2).setObserver(true);
        }
        this.sendServerChat(n, this.motd);
        this.send(this.createPlayerConnectPacket(n));
        this.send(n, new Packet(30, new Integer(n)));
        this.sendCurrentInfo(n);
        try {
            object = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            for (int i = 0; i < ((InetAddress[])object).length; ++i) {
                this.sendServerChat(n, new StringBuffer().append("Machine IP is ").append(object[i].getHostAddress()).toString());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.sendServerChat(n, new StringBuffer().append("Listening on port ").append(this.serverSocket.getLocalPort()).toString());
        object2 = this.getPlayer(n);
        if (null != object2) {
            object = new StringBuffer();
            ((StringBuffer)object).append(((Player)object2).getName()).append(" connected from ").append(this.getClient(n).getInetAddress());
            String string2 = ((StringBuffer)object).toString();
            System.out.print("s: player #");
            System.out.print(n);
            System.out.print(", ");
            System.out.println(string2);
            this.sendServerChat(string2);
        }
    }

    private void sendCurrentInfo(int n) {
        this.transmitAllPlayerConnects(n);
        this.send(n, this.createGameSettingsPacket());
        Player player = this.game.getPlayer(n);
        if (null != player) {
            this.send(n, new Packet(420, player.getMinefields()));
            switch (this.game.getPhase()) {
                case 1: {
                    this.send(n, this.createMapSettingsPacket());
                    this.send(n, new Packet(240, new Integer(this.game.getPhase())));
                    if (this.doBlind()) {
                        this.send(n, this.createFilteredFullEntitiesPacket(player));
                        break;
                    }
                    this.send(n, this.createFullEntitiesPacket());
                    break;
                }
                default: {
                    this.send(n, new Packet(260, new Integer(this.game.getRoundCount())));
                    this.send(n, this.createAllReportsPacket(player));
                    if (this.doBlind()) {
                        this.send(n, this.createFilteredFullEntitiesPacket(player));
                    } else {
                        this.send(n, this.createFullEntitiesPacket());
                    }
                    player.setDone(this.game.getEntitiesOwnedBy(player) <= 0);
                    this.send(n, this.createBoardPacket());
                    this.send(n, new Packet(240, new Integer(this.game.getPhase())));
                }
            }
            if (this.game.getPhase() == 12 || this.game.getPhase() == 7 || this.game.getPhase() == 10 || this.game.getPhase() == 14) {
                this.send(n, this.createAttackPacket(this.game.getActionsVector(), 0));
                this.send(n, this.createAttackPacket(this.game.getChargesVector(), 1));
                this.send(n, this.createAttackPacket(this.game.getLayMinefieldActionsVector(), 2));
            }
            if (this.game.phaseHasTurns(this.game.getPhase())) {
                this.send(n, this.createTurnVectorPacket());
                this.send(n, this.createTurnIndexPacket());
            }
            this.send(n, this.createArtilleryPacket(player));
            this.send(n, this.createFlarePacket());
        }
    }

    public void sendEntities(int n) {
        if (this.doBlind()) {
            this.send(n, this.createFilteredEntitiesPacket(this.getPlayer(n)));
        } else {
            this.send(n, this.createEntitiesPacket());
        }
    }

    public void validatePlayerInfo(int n) {
        Player player = this.getPlayer(n);
        boolean[] blArray = new boolean[Player.colorNames.length];
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player2 = (Player)enumeration.nextElement();
            if (player2.getId() == n) continue;
            blArray[player2.getColorIndex()] = true;
        }
        if (null != player && blArray[player.getColorIndex()]) {
            for (int i = 0; i < blArray.length; ++i) {
                if (blArray[i]) continue;
                player.setColorIndex(i);
                break;
            }
        }
    }

    void disconnected(Player player) {
        int n = this.game.getPhase();
        if (n == 1) {
            this.removeAllEntitesOwnedBy(player);
        }
        if (this.game.getEntitiesOwnedBy(player) > 0 && n != 18) {
            player.setGhost(true);
            player.setDone(true);
            this.send(this.createPlayerUpdatePacket(player.getId()));
        } else {
            this.game.removePlayer(player.getId());
            this.send(new Packet(50, new Integer(player.getId())));
        }
        if (this.game.phaseHasTurns(this.game.getPhase()) && null != this.game.getTurn()) {
            if (this.game.getTurn().isValid(player.getId(), this.game)) {
                this.sendGhostSkipMessage(player);
            }
        } else {
            this.checkReady();
        }
        this.sendServerChat(new StringBuffer().append(player.getName()).append(" disconnected.").toString());
        System.out.println(new StringBuffer().append("s: removed player ").append(player.getName()).toString());
        if (0 == this.game.getNoOfPlayers()) {
            this.resetGame();
        }
    }

    public void checkForObservers() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player;
            player.setObserver(this.game.getEntitiesOwnedBy(player = (Player)enumeration.nextElement()) < 1 && this.game.getPhase() != 1);
        }
    }

    public void resetGame() {
        this.game.reset();
        this.send(this.createEntitiesPacket());
        this.send(new Packet(420, new Vector()));
        ArrayList<Player> arrayList = new ArrayList<Player>();
        Object object = this.game.getPlayers();
        while (object.hasMoreElements()) {
            Player player = (Player)object.nextElement();
            if (!player.isGhost()) continue;
            arrayList.add(player);
        }
        for (Player player : arrayList) {
            this.game.removePlayer(player.getId());
            this.send(new Packet(50, new Integer(player.getId())));
        }
        this.resetPlayersDone();
        this.transmitAllPlayerDones();
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        System.out.print(((DateFormat)object).format(new Date()));
        System.out.println(" END OF GAME");
        this.changePhase(1);
    }

    public void autoSave() {
        String string = "autosave";
        if (PreferenceManager.getClientPreferences().stampFilenames()) {
            string = StringUtil.addDateTimeStamp(string);
        }
        this.saveGame(string, this.game.getOptions().booleanOption("autosave_msg"));
    }

    public void sendSaveGame(int n, String string) {
        this.saveGame(string, false);
        String string2 = string;
        if (!string2.endsWith(".sav")) {
            string2 = new StringBuffer().append(string).append(".sav").toString();
        }
        String string3 = new StringBuffer().append("savegames").append(File.separator).append(string2).toString();
        File file = new File(string3);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.send(n, new Packet(490, new Object[]{string2, objectInputStream.readObject()}));
            this.sendChat(n, "***Server", "Savegame has been sent to you.");
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.err.println(new StringBuffer().append("Unable to load file: ").append(file).toString());
            exception.printStackTrace();
        }
    }

    public void saveGame(String string, boolean bl) {
        String string2 = string;
        if (!string2.endsWith(".sav")) {
            string2 = new StringBuffer().append(string).append(".sav").toString();
        }
        try {
            File file = new File("savegames");
            if (!file.exists()) {
                file.mkdir();
            }
            string2 = new StringBuffer().append(file).append(File.separator).append(string2).toString();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string2));
            objectOutputStream.writeObject(this.game);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println(new StringBuffer().append("Unable to save file: ").append(string2).toString());
            exception.printStackTrace();
        }
        if (bl) {
            this.sendChat("MegaMek", new StringBuffer().append("Game saved to ").append(string2).toString());
        }
    }

    public void saveGame(String string) {
        this.saveGame(string, true);
    }

    public boolean loadGame(File file) {
        System.out.println(new StringBuffer().append("s: loading saved game file '").append(file).append('\'').toString());
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.game = (IGame)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.err.println(new StringBuffer().append("Unable to load file: ").append(file).toString());
            exception.printStackTrace();
            return false;
        }
        this.setGame(this.game);
        return true;
    }

    public Player getPlayer(int n) {
        return this.game.getPlayer(n);
    }

    private void removeAllEntitesOwnedBy(Player player) {
        Entity entity;
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity = (Entity)enumeration.nextElement();
            if (!entity.getOwner().equals(player)) continue;
            vector.addElement(entity);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entity = (Entity)enumeration.nextElement();
            int n = entity.getId();
            this.game.removeEntity(n, 2048);
            this.send(this.createRemoveEntityPacket(n, 2048));
        }
    }

    private Connection getClient(int n) {
        return this.getConnection(n);
    }

    public Enumeration getConnections() {
        return this.connections.elements();
    }

    public Connection getConnection(int n) {
        return (Connection)this.connectionIds.get(new Integer(n));
    }

    private Connection getPendingConnection(int n) {
        Enumeration enumeration = this.connectionsPending.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            if (connection.getId() != n) continue;
            return connection;
        }
        return null;
    }

    private void resetEntityRound() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            entity.newRound(this.game.getRoundCount());
        }
    }

    private void resetEntityPhase(int n) {
        int n2;
        Entity entity;
        Vector<Entity> vector = new Vector<Entity>(0, 10);
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity = (Entity)enumeration.nextElement();
            if (entity.crew.isDoomed()) {
                entity.crew.setDead(true);
                entity.setDestroyed(true);
            }
            if (entity.isDoomed()) {
                entity.setDestroyed(true);
                n2 = entity.getSwarmTargetId();
                if (-1 != n2) {
                    Entity entity2 = this.game.getEntity(n2);
                    entity2.setSwarmAttackerId(-1);
                    entity.setSwarmTargetId(-1);
                    Report report = new Report(5165);
                    report.subject = n2;
                    report.addDesc(entity2);
                    this.addReport(report);
                    this.entityUpdate(n2);
                }
            }
            if (!entity.isDestroyed() && !entity.getCrew().isDead()) continue;
            vector.addElement(entity);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entity = (Entity)enumeration.nextElement();
            n2 = 512;
            if (!entity.isSalvage()) {
                n2 = 1024;
            }
            this.entityUpdate(entity.getId());
            this.game.removeEntity(entity.getId(), n2);
            this.send(this.createRemoveEntityPacket(entity.getId(), n2));
        }
        enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity = (Entity)enumeration.nextElement();
            entity.applyDamage();
            entity.reloadEmptyWeapons();
            entity.damageThisPhase = 0;
            entity.engineHitsThisRound = 0;
            entity.rolledForEngineExplosion = false;
            entity.dodging = false;
            if (n == 4) {
                entity.setDone(!entity.shouldDeploy(this.game.getRoundCount()));
            } else {
                entity.setDone(false);
            }
            entity.setIlluminated(false);
            entity.setUsedSearchlight(false);
        }
    }

    private void resetPlayersDone() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            player.setDone(false);
        }
    }

    private void resetActivePlayersDone() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player;
            player.setDone(this.game.getEntitiesOwnedBy(player = (Player)enumeration.nextElement()) <= 0);
        }
        this.transmitAllPlayerDones();
    }

    private void prepareVictoryReport() {
        Object object;
        Enumeration enumeration;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.addReport(new Report(7000, 0));
        Report report = new Report(1210);
        report.type = 0;
        if (this.game.getVictoryTeam() == 0) {
            object5 = this.getPlayer(this.game.getVictoryPlayerId());
            if (null == object5) {
                report.messageId = 7005;
            } else {
                report.messageId = 7010;
                report.add(((Player)object5).getName());
            }
        } else {
            report.messageId = 7015;
            report.add(this.game.getVictoryTeam());
        }
        this.addReport(report);
        object5 = this.game.getPlayers();
        while (object5.hasMoreElements()) {
            object4 = (Player)object5.nextElement();
            report = new Report();
            report.type = 0;
            report.messageId = 7016;
            report.add(((Player)object4).getName());
            report.add(((Player)object4).getBV());
            report.add(((Player)object4).getInitialBV());
            this.addReport(report);
        }
        object4 = this.game.getEntities();
        if (object4.hasMoreElements()) {
            this.addReport(new Report(7020, 0));
            while (object4.hasMoreElements()) {
                object3 = (Entity)object4.nextElement();
                if (!((Entity)object3).isDeployed()) continue;
                this.addReport(((Entity)object3).victoryReport());
            }
        }
        if ((object3 = this.game.getEntities()).hasMoreElements()) {
            boolean bl = false;
            while (object3.hasMoreElements()) {
                object2 = (Entity)object3.nextElement();
                if (((Entity)object2).isDeployed()) continue;
                if (!bl) {
                    this.addReport(new Report(7075, 0));
                    bl = true;
                }
                this.addReport(((Entity)object2).victoryReport());
            }
        }
        if ((enumeration = this.game.getRetreatedEntities()).hasMoreElements()) {
            this.addReport(new Report(7080, 0));
            while (enumeration.hasMoreElements()) {
                object2 = (Entity)enumeration.nextElement();
                this.addReport(((Entity)object2).victoryReport());
            }
        }
        if ((object2 = this.game.getGraveyardEntities()).hasMoreElements()) {
            this.addReport(new Report(7085, 0));
            while (object2.hasMoreElements()) {
                object = (Entity)object2.nextElement();
                this.addReport(((Entity)object).victoryReport());
            }
        }
        if ((object = this.game.getDevastatedEntities()).hasMoreElements()) {
            this.addReport(new Report(7090, 0));
            while (object.hasMoreElements()) {
                Entity entity = (Entity)object.nextElement();
                this.addReport(entity.victoryReport());
            }
        }
        this.addReport(new Report(7095, 0));
    }

    private String getDetailedVictoryReport() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = new Vector();
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.game.getRetreatedEntities();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.game.getGraveyardEntities();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Entity entity;
            Player player = (Player)enumeration.nextElement();
            stringBuffer.append("++++++++++ ").append(player.getName()).append(" ++++++++++");
            stringBuffer.append("\r\n");
            for (int i = 0; i < vector.size(); ++i) {
                entity = (Entity)vector.elementAt(i);
                if (entity.getOwner() != player) continue;
                stringBuffer.append(UnitStatusFormatter.format(entity));
            }
            Enumeration enumeration2 = this.game.getDevastatedEntities();
            if (!enumeration2.hasMoreElements()) continue;
            stringBuffer.append("=============================================================");
            stringBuffer.append("\r\n");
            stringBuffer.append("The following utterly destroyed units are not available for salvage:");
            stringBuffer.append("\r\n");
            while (enumeration2.hasMoreElements()) {
                entity = (Entity)enumeration2.nextElement();
                if (entity.getOwner() != player) continue;
                stringBuffer.append(entity.getShortName()).append(", Pilot: ").append(entity.getCrew().getName()).append(" (").append(entity.getCrew().getGunnery()).append('/').append(entity.getCrew().getPiloting()).append(')');
                stringBuffer.append("\r\n");
            }
            stringBuffer.append("=============================================================");
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    public void forceVictory(Player player) {
        this.game.setForceVictory(true);
        if (player.getTeam() == 0) {
            this.game.setVictoryPlayerId(player.getId());
            this.game.setVictoryTeam(0);
        } else {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(player.getTeam());
        }
        Vector vector = this.game.getPlayersVector();
        for (int i = 0; i < vector.size(); ++i) {
            Player player2 = (Player)vector.elementAt(i);
            player2.setAdmitsDefeat(false);
        }
    }

    public void cancelVictory() {
        this.game.setForceVictory(false);
        this.game.setVictoryPlayerId(-1);
        this.game.setVictoryTeam(0);
    }

    private void checkReady() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (player.isGhost() || player.isObserver() || player.isDone()) continue;
            return;
        }
        if (this.game.getNoOfInitiativeRerollRequests() > 0) {
            this.resetActivePlayersDone();
            this.game.rollInitAndResolveTies();
            this.determineTurnOrder(5);
            this.clearReports();
            this.writeInitiativeReport(true);
            this.sendReport(true);
            return;
        }
        if (!(this.game.phaseHasTurns(this.game.getPhase()) || this.game.getPhase() == 1 && this.game.getNoOfEntities() <= 0)) {
            this.endCurrentPhase();
        }
    }

    private void endCurrentTurn(Entity entity) {
        boolean bl;
        boolean bl2 = false;
        GameTurn gameTurn = this.game.getTurn();
        final int n = null == entity ? -1 : entity.getOwnerId();
        boolean bl3 = entity instanceof Infantry;
        boolean bl4 = this.game.getOptions().booleanOption("inf_move_multi") && (this.game.getPhase() == 8 || this.game.getPhase() == 5);
        boolean bl5 = entity instanceof Protomech;
        boolean bl6 = this.game.getOptions().booleanOption("protos_move_multi");
        int n2 = 0;
        if (bl4) {
            ++n2;
        }
        if (bl6) {
            n2 += 2;
        } else if (bl5 && this.game.getPhase() == 12) {
            n2 = 0;
        }
        boolean bl7 = bl = !(gameTurn instanceof GameTurn.SpecificEntityTurn) && !(gameTurn instanceof GameTurn.UnitNumberTurn) && !(gameTurn instanceof GameTurn.UnloadStrandedTurn) && (!(gameTurn instanceof GameTurn.EntityClassTurn) || gameTurn instanceof GameTurn.EntityClassTurn && ((GameTurn.EntityClassTurn)gameTurn).isValidClass(~n2));
        if (bl5 && !bl6 && bl && this.game.getPhase() == 12) {
            final char c = entity.getUnitNumber();
            final int n3 = entity.getId();
            int n4 = this.game.getSelectedEntityCount(new EntitySelector(){
                private final int ownerId;
                private final int entityId;
                private final char unitNum;
                {
                    this.ownerId = n;
                    this.entityId = n3;
                    this.unitNum = c;
                }

                public boolean accept(Entity entity) {
                    return entity instanceof Protomech && entity.isSelectableThisTurn() && this.ownerId == entity.getOwnerId() && this.entityId != entity.getId() && this.unitNum == entity.getUnitNumber();
                }
            });
            for (int i = 0; i < n4; ++i) {
                GameTurn.UnitNumberTurn unitNumberTurn = new GameTurn.UnitNumberTurn(n, c);
                this.game.insertNextTurn(unitNumberTurn);
                bl2 = true;
            }
        } else if ((bl3 && bl4 || bl5 && bl6) && bl) {
            int n5 = 0;
            if (bl4) {
                n5 += this.game.getInfantryLeft(n);
            }
            if (bl6) {
                n5 += this.game.getProtomechsLeft(n);
            }
            int n6 = Math.min(this.game.getOptions().intOption("inf_proto_move_multi") - 1, n5);
            for (int i = 0; i < n6; ++i) {
                GameTurn.EntityClassTurn entityClassTurn = new GameTurn.EntityClassTurn(n, n2);
                this.game.insertNextTurn(entityClassTurn);
                bl2 = true;
            }
        }
        if (bl2) {
            this.send(this.createTurnVectorPacket());
        }
        this.changeToNextTurn();
    }

    private void changePhase(int n) {
        this.game.setLastPhase(this.game.getPhase());
        this.game.setPhase(n);
        this.prepareForPhase(n);
        if (this.isPhasePlayable(n)) {
            this.send(new Packet(240, new Integer(n)));
            this.executePhase(n);
        } else {
            this.endCurrentPhase();
        }
    }

    private void prepareForPhase(int n) {
        switch (n) {
            case 1: {
                this.clearReports();
                this.mapSettings.setBoardsAvailableVector(this.scanForBoards(this.mapSettings.getBoardWidth(), this.mapSettings.getBoardHeight()));
                this.mapSettings.setNullBoards(DEFAULT_BOARD);
                this.send(this.createMapSettingsPacket());
                break;
            }
            case 5: {
                this.game.resetActions();
                this.game.resetTagInfo();
                this.clearReports();
                this.resetEntityRound();
                this.resetEntityPhase(n);
                this.checkForObservers();
                this.resetActivePlayersDone();
                this.rollInitiative();
                if (!this.game.shouldDeployThisRound()) {
                    this.incrementAndSendGameRound();
                }
                this.determineTurnOrder(n);
                this.writeInitiativeReport(false);
                System.out.println(new StringBuffer().append("Round ").append(this.game.getRoundCount()).append(" memory usage: ").append(MegaMek.getMemoryUsed()).toString());
                break;
            }
            case 20: {
                this.checkForObservers();
                this.resetActivePlayersDone();
                this.setIneligible(n);
                Enumeration enumeration = this.game.getPlayers();
                Vector<GameTurn> vector = new Vector<GameTurn>();
                while (enumeration.hasMoreElements()) {
                    Player player = (Player)enumeration.nextElement();
                    if (!player.hasMinefields()) continue;
                    GameTurn gameTurn = new GameTurn(player.getId());
                    vector.addElement(gameTurn);
                }
                this.game.setTurnVector(vector);
                this.game.resetTurnIndex();
                this.send(this.createTurnVectorPacket());
                break;
            }
            case 22: {
                Serializable serializable;
                Enumeration enumeration = this.game.getEntities();
                while (enumeration.hasMoreElements()) {
                    serializable = (Entity)enumeration.nextElement();
                    ((Entity)serializable).deployOffBoard();
                }
                this.checkForObservers();
                this.resetActivePlayersDone();
                this.setIneligible(n);
                enumeration = this.game.getPlayers();
                serializable = new Vector();
                while (enumeration.hasMoreElements()) {
                    final Player player = (Player)enumeration.nextElement();
                    EntitySelector entitySelector = new EntitySelector(){
                        private Player owner;
                        {
                            this.owner = player;
                        }

                        public boolean accept(Entity entity) {
                            return this.owner.equals(entity.getOwner()) && entity.isEligibleForTargetingPhase();
                        }
                    };
                    if (!this.game.getSelectedEntities(entitySelector).hasMoreElements()) continue;
                    GameTurn gameTurn = new GameTurn(player.getId());
                    ((Vector)serializable).addElement(gameTurn);
                }
                this.game.setTurnVector((Vector)serializable);
                this.game.resetTurnIndex();
                this.send(this.createTurnVectorPacket());
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                this.resetEntityPhase(n);
                this.checkForObservers();
                this.setIneligible(n);
                this.determineTurnOrder(n);
                this.resetActivePlayersDone();
                this.entityAllUpdate();
                this.clearReports();
                this.doTryUnstuck();
                break;
            }
            case 16: {
                this.resetEntityPhase(n);
                this.clearReports();
                this.resolveHeat();
                this.addReport(new Report(5005, 0));
                this.checkForSuffocation();
                if (this.game.getOptions().booleanOption("vacuum")) {
                    this.checkForVacuumDeath();
                }
                Enumeration<DynamicTerrainProcessor> enumeration = this.terrainProcessors.elements();
                while (enumeration.hasMoreElements()) {
                    DynamicTerrainProcessor dynamicTerrainProcessor = enumeration.nextElement();
                    dynamicTerrainProcessor.DoEndPhaseChanges(this.vPhaseReport);
                }
                this.addReport(this.game.ageFlares());
                this.send(this.createFlarePacket());
                this.resolveExtremeTempInfantryDeath();
                this.resolveAmmoDumps();
                this.resolveCrewDamage();
                this.resolveCrewWakeUp();
                this.resolveMechWarriorPickUp();
                this.resolveVeeINarcPodRemoval();
                this.resolveFortify();
                this.checkForObservers();
                this.entityAllUpdate();
                break;
            }
            case 6: {
                this.autoSave();
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                this.resetActivePlayersDone();
                this.sendReport();
                if (!this.game.getOptions().booleanOption("paranoid_autosave")) break;
                this.autoSave();
                break;
            }
            case 18: {
                this.resetPlayersDone();
                this.clearReports();
                this.prepareVictoryReport();
                this.game.addReports(this.vPhaseReport);
                this.send(this.createFullEntitiesPacket());
                this.send(this.createReportPacket(null));
                this.send(this.createEndOfGamePacket());
            }
        }
    }

    private boolean isPhasePlayable(int n) {
        switch (n) {
            case 5: 
            case 16: {
                return false;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 20: 
            case 22: {
                return this.game.hasMoreTurns();
            }
            case 10: {
                return this.isOffboardPlayable();
            }
        }
        return true;
    }

    private boolean isOffboardPlayable() {
        if (!this.game.hasMoreTurns()) {
            return false;
        }
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            for (Mounted mounted : entity.getAmmo()) {
                AmmoType ammoType = (AmmoType)mounted.getType();
                if (ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 16384L) {
                    return true;
                }
                if (ammoType.getAmmoType() != 15 && ammoType.getAmmoType() != 16 && ammoType.getAmmoType() != 17 || ammoType.getMunitionType() != 0x20000000L) continue;
                return true;
            }
        }
        return false;
    }

    private void executePhase(int n) {
        switch (n) {
            case 3: {
                this.resetPlayersDone();
                this.calculatePlayerBVs();
                this.game.setupTeams();
                this.applyBoardSettings();
                this.game.setupRoundDeployment();
                this.game.determineWind();
                if (this.game.checkForMagneticClamp()) {
                    this.entityAllUpdate();
                }
                this.send(this.createBoardPacket());
                break;
            }
            case 8: {
                this.addReport(new Report(2000, 0));
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 20: 
            case 22: {
                this.changeToNextTurn();
                if (!this.game.getOptions().booleanOption("paranoid_autosave")) break;
                this.autoSave();
            }
        }
    }

    public void calculatePlayerBVs() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            ((Player)enumeration.nextElement()).setInitialBV();
        }
    }

    private void endCurrentPhase() {
        switch (this.game.getPhase()) {
            case 1: {
                this.changePhase(3);
                break;
            }
            case 3: {
                this.changePhase(22);
                break;
            }
            case 21: {
                this.changePhase(22);
                break;
            }
            case 22: {
                Enumeration enumeration = this.game.getPlayers();
                boolean bl = false;
                while (enumeration.hasMoreElements()) {
                    Player player = (Player)enumeration.nextElement();
                    if (!player.hasMinefields()) continue;
                    bl = true;
                }
                if (bl) {
                    this.changePhase(20);
                    break;
                }
                this.changePhase(5);
                break;
            }
            case 20: {
                this.changePhase(5);
                break;
            }
            case 4: {
                this.game.clearDeploymentThisRound();
                this.game.checkForCompleteDeployment();
                Enumeration enumeration = this.game.getPlayers();
                while (enumeration.hasMoreElements()) {
                    Player player = (Player)enumeration.nextElement();
                    player.adjustStartingPosForReinforcements();
                }
                if (this.game.getRoundCount() < 1) {
                    this.changePhase(5);
                    break;
                }
                this.changePhase(7);
                break;
            }
            case 5: {
                this.game.addReports(this.vPhaseReport);
                this.changePhase(6);
                break;
            }
            case 6: {
                if (this.game.shouldDeployThisRound()) {
                    this.changePhase(4);
                    break;
                }
                this.changePhase(7);
                break;
            }
            case 8: {
                this.doAllAssaultDrops();
                this.addMovementHeat();
                this.applyBuildingDamage();
                this.checkFor20Damage();
                this.resolveCrewDamage();
                this.resolvePilotingRolls();
                this.resolveCrewDamage();
                this.checkForFlamingDeath();
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(9);
                    break;
                }
                this.addReport(new Report(1205, 0));
                this.game.addReports(this.vPhaseReport);
                this.sendReport();
                this.changePhase(10);
                break;
            }
            case 9: {
                this.changePhase(10);
                break;
            }
            case 12: {
                this.resolveAllButWeaponAttacks();
                this.assignAMS();
                this.resolveOnlyWeaponAttacks();
                this.applyBuildingDamage();
                this.checkFor20Damage();
                this.resolveCrewDamage();
                this.resolvePilotingRolls();
                this.resolveCrewDamage();
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(13);
                    break;
                }
                this.addReport(new Report(1205, 0));
                this.sendReport();
                this.game.addReports(this.vPhaseReport);
                this.changePhase(14);
                break;
            }
            case 13: {
                this.changePhase(14);
                break;
            }
            case 14: {
                this.resolvePhysicalAttacks();
                this.applyBuildingDamage();
                this.checkFor20Damage();
                this.resolveCrewDamage();
                this.resolvePilotingRolls();
                this.resolveCrewDamage();
                this.resolveSinkVees();
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(15);
                    break;
                }
                this.addReport(new Report(1205, 0));
                this.game.addReports(this.vPhaseReport);
                this.sendReport();
                this.changePhase(16);
                break;
            }
            case 15: {
                this.changePhase(16);
                break;
            }
            case 7: {
                this.enqueueIndirectArtilleryAttacks();
                this.changePhase(8);
                break;
            }
            case 10: {
                this.addReport(new Report(1100, 0));
                this.resolveAllButWeaponAttacks();
                this.resolveOnlyWeaponAttacks();
                this.resolveIndirectArtilleryAttacks();
                this.applyBuildingDamage();
                this.checkFor20Damage();
                this.resolveCrewDamage();
                this.resolvePilotingRolls();
                this.resolveCrewDamage();
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(11);
                    break;
                }
                this.addReport(new Report(1205, 0));
                this.game.addReports(this.vPhaseReport);
                this.sendReport();
                this.changePhase(12);
                break;
            }
            case 11: {
                this.changePhase(12);
                break;
            }
            case 16: {
                this.resetEntityPhase(16);
                boolean bl = this.victory();
                if (this.vPhaseReport.size() > 3 || ((Report)this.vPhaseReport.elementAt((int)1)).messageId != 1205) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(17);
                    break;
                }
                this.addReport(new Report(1205, 0));
                this.game.addReports(this.vPhaseReport);
                this.sendReport();
                if (bl) {
                    this.changePhase(18);
                    break;
                }
                this.changePhase(5);
                break;
            }
            case 17: {
                if (this.victory()) {
                    this.changePhase(18);
                    break;
                }
                this.changePhase(5);
                break;
            }
            case 18: {
                this.resetGame();
            }
        }
    }

    private void incrementAndSendGameRound() {
        this.game.incrementRoundCount();
        this.send(new Packet(260, new Integer(this.game.getRoundCount())));
    }

    private void changeToNextTurn() {
        if (!this.game.hasMoreTurns()) {
            this.endCurrentPhase();
            return;
        }
        GameTurn gameTurn = this.game.changeToNextTurn();
        this.send(this.createTurnIndexPacket());
        Player player = this.getPlayer(gameTurn.getPlayerNum());
        if (null != player && player.isGhost()) {
            this.sendGhostSkipMessage(player);
        } else if (null == this.game.getFirstEntity() && null != player && this.game.getPhase() != 20 && this.game.getPhase() != 22) {
            this.sendTurnErrorSkipMessage(player);
        }
    }

    private void sendGhostSkipMessage(Player player) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Player '").append(player.getName()).append("' is disconnected.  You may skip his/her current turn with the /skip command.");
        this.sendServerChat(stringBuffer.toString());
    }

    private void sendTurnErrorSkipMessage(Player player) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Player '").append(player.getName()).append("' has no units to move.  You should skip his/her/your current turn with the /skip command. You may want to report this error.  See the MegaMek homepage (http://megamek.sf.net/) for details.");
        this.sendServerChat(stringBuffer.toString());
    }

    public void skipCurrentTurn() {
        Entity entity = this.game.getFirstEntity();
        switch (this.game.getPhase()) {
            case 4: {
                this.endCurrentTurn(null);
                break;
            }
            case 8: {
                if (entity != null) {
                    this.processMovement(entity, new MovePath(this.game, entity));
                }
                this.endCurrentTurn(entity);
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: {
                if (entity != null) {
                    this.processAttack(entity, new Vector(0));
                }
                this.endCurrentTurn(entity);
                break;
            }
        }
    }

    public boolean isTurnSkippable() {
        GameTurn gameTurn = this.game.getTurn();
        if (null == gameTurn) {
            return false;
        }
        Player player = this.getPlayer(gameTurn.getPlayerNum());
        return null == player || player.isGhost() || this.game.getFirstEntity() == null;
    }

    public boolean victory() {
        Serializable serializable;
        Serializable serializable2;
        int n;
        int n2;
        int n3;
        if (this.game.isForceVictory()) {
            n3 = this.game.getVictoryPlayerId();
            int n4 = this.game.getVictoryTeam();
            Vector vector = this.game.getPlayersVector();
            n2 = 1;
            if (n3 != -1) {
                for (n = 0; n < vector.size(); ++n) {
                    serializable2 = (Player)vector.elementAt(n);
                    if (((Player)serializable2).getId() == n3 || ((Player)serializable2).isObserver() || ((Player)serializable2).admitsDefeat()) continue;
                    n2 = 0;
                    break;
                }
            }
            if (n4 != 0) {
                for (n = 0; n < vector.size(); ++n) {
                    serializable2 = (Player)vector.elementAt(n);
                    if (((Player)serializable2).getTeam() == n4 || ((Player)serializable2).isObserver() || ((Player)serializable2).admitsDefeat()) continue;
                    n2 = 0;
                    break;
                }
            }
            if (n2 != 0) {
                return true;
            }
            for (n = 0; n < vector.size(); ++n) {
                serializable2 = (Player)vector.elementAt(n);
                ((Player)serializable2).setAdmitsDefeat(false);
            }
            this.cancelVictory();
        }
        if (!this.game.gameTimerIsExpired() && !this.game.getOptions().booleanOption("check_victory")) {
            return false;
        }
        n3 = 0;
        Player player = null;
        boolean bl = false;
        n2 = 0;
        n = 0;
        serializable2 = this.game.getPlayers();
        while (serializable2.hasMoreElements()) {
            serializable = (Player)serializable2.nextElement();
            int n5 = ((Player)serializable).getTeam();
            if (this.game.getLiveDeployedEntitiesOwnedBy((Player)serializable) <= 0) continue;
            ++n3;
            player = serializable;
            if (n5 == 0) {
                n = 1;
                continue;
            }
            if (n2 == 0) {
                bl = true;
                n2 = n5;
                continue;
            }
            if (n5 == n2) continue;
            bl = false;
            n2 = n5;
        }
        if (n3 < 1) {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(0);
            return true;
        }
        if (n3 == 1 && player.getTeam() == 0) {
            this.game.setVictoryPlayerId(player.getId());
            this.game.setVictoryTeam(0);
            return true;
        }
        if (bl && n == 0) {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(n2);
            return true;
        }
        serializable2 = new Hashtable<Integer, Integer>();
        serializable = new Hashtable();
        if (this.game.getOptions().booleanOption("use_bv_destroyed") || this.game.getOptions().booleanOption("use_bv_ratio")) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            Enumeration enumeration = this.game.getPlayers();
            while (enumeration.hasMoreElements()) {
                Serializable serializable3;
                Player player2 = (Player)enumeration.nextElement();
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = player2.getTeam();
                if (n9 != 0) {
                    if (hashSet.contains(Autobox.valueOf((int)n9))) continue;
                    hashSet.add(Autobox.valueOf((int)n9));
                }
                Object object = this.game.getPlayers();
                while (object.hasMoreElements()) {
                    serializable3 = (Player)object.nextElement();
                    if (((Player)serializable3).isEnemyOf(player2)) {
                        n7 += ((Player)serializable3).getBV();
                        n8 += ((Player)serializable3).getInitialBV();
                        continue;
                    }
                    n6 += ((Player)serializable3).getBV();
                }
                if (this.game.getOptions().booleanOption("use_bv_ratio") && (n7 == 0 || 100 * n6 / n7 >= this.game.getOptions().intOption("bv_ratio_percent"))) {
                    object = new Report(7100);
                    if (n9 == 0) {
                        ((Report)object).add(player2.getName());
                        serializable3 = (Integer)serializable2.get(Autobox.valueOf((int)player2.getId()));
                        if (serializable3 == null) {
                            serializable3 = new Integer(0);
                        }
                        serializable2.put(Autobox.valueOf((int)player2.getId()), Autobox.valueOf((int)((Integer)serializable3 + 1)));
                    } else {
                        ((Report)object).add(new StringBuffer().append("Team ").append(n9).toString());
                        serializable3 = (Integer)((Hashtable)serializable).get(Autobox.valueOf((int)n9));
                        if (serializable3 == null) {
                            serializable3 = new Integer(0);
                        }
                        ((Hashtable)serializable).put(Autobox.valueOf((int)n9), Autobox.valueOf((int)((Integer)serializable3 + 1)));
                    }
                    ((Report)object).add(n7 == 0 ? 9999 : 100 * n6 / n7);
                    this.addReport((Report)object);
                }
                if (!this.game.getOptions().booleanOption("use_bv_destroyed") || n7 * 100 / n8 > 100 - this.game.getOptions().intOption("bv_destroyed_percent")) continue;
                object = new Report(7105);
                if (n9 == 0) {
                    ((Report)object).add(player2.getName());
                    serializable3 = (Integer)serializable2.get(Autobox.valueOf((int)player2.getId()));
                    if (serializable3 == null) {
                        serializable3 = new Integer(0);
                    }
                    serializable2.put(Autobox.valueOf((int)player2.getId()), Autobox.valueOf((int)((Integer)serializable3 + 1)));
                } else {
                    ((Report)object).add(new StringBuffer().append("Team ").append(n9).toString());
                    serializable3 = (Integer)((Hashtable)serializable).get(Autobox.valueOf((int)n9));
                    if (serializable3 == null) {
                        serializable3 = new Integer(0);
                    }
                    ((Hashtable)serializable).put(Autobox.valueOf((int)n9), Autobox.valueOf((int)((Integer)serializable3 + 1)));
                }
                ((Report)object).add(100 - n7 * 100 / n8);
                this.addReport((Report)object);
            }
        }
        int n10 = -1;
        int n11 = 0;
        boolean bl2 = false;
        for (Map.Entry entry : serializable2.entrySet()) {
            if ((Integer)entry.getValue() < this.game.getOptions().intOption("achieve_conditions")) continue;
            if (n10 != -1) {
                bl2 = true;
            }
            n10 = (Integer)entry.getKey();
            Report report = new Report(7200);
            report.add(this.game.getPlayer(n10).getName());
            this.addReport(report);
        }
        for (Map.Entry entry : ((Hashtable)serializable).entrySet()) {
            if ((Integer)entry.getValue() < this.game.getOptions().intOption("achieve_conditions")) continue;
            if (n11 != 0 || n10 != -1) {
                bl2 = true;
            }
            n11 = (Integer)entry.getKey();
            Report report = new Report(7200);
            report.add(new StringBuffer().append("Team ").append(n11).toString());
            this.addReport(report);
        }
        if (bl2) {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(0);
            return true;
        }
        if (n10 != -1) {
            this.game.setVictoryPlayerId((Integer)serializable2.keys().nextElement());
            this.game.setVictoryTeam(0);
            return true;
        }
        if (n11 != 0) {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(n11);
            return true;
        }
        if (this.game.gameTimerIsExpired()) {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(0);
            return true;
        }
        return false;
    }

    public void applyBoardSettings() {
        this.mapSettings.replaceBoardWithRandom("[RANDOM]");
        this.mapSettings.replaceBoardWithRandom(DEFAULT_BOARD);
        IBoard[] iBoardArray = new IBoard[this.mapSettings.getMapWidth() * this.mapSettings.getMapHeight()];
        for (int i = 0; i < this.mapSettings.getMapWidth() * this.mapSettings.getMapHeight(); ++i) {
            iBoardArray[i] = new Board();
            String string = (String)this.mapSettings.getBoardsSelectedVector().elementAt(i);
            boolean bl = false;
            if (string.startsWith("rotate:")) {
                bl = true;
                string = string.substring("rotate:".length());
            }
            if (string.startsWith("[GENERATED]")) {
                iBoardArray[i] = BoardUtilities.generateRandom(this.mapSettings);
                continue;
            }
            iBoardArray[i].load(new StringBuffer().append(string).append(".board").toString());
            BoardUtilities.flip(iBoardArray[i], bl, bl);
        }
        IBoard iBoard = BoardUtilities.combine(this.mapSettings.getBoardWidth(), this.mapSettings.getBoardHeight(), this.mapSettings.getMapWidth(), this.mapSettings.getMapHeight(), iBoardArray);
        this.game.setBoard(iBoard);
    }

    private void rollInitiative() {
        if (this.game.getOptions().booleanOption("individual_initiative")) {
            TurnOrdered.rollInitiative(this.game.getEntitiesVector());
        } else {
            TurnOrdered.rollInitiative(this.game.getTeamsVector());
        }
        this.transmitAllPlayerUpdates();
    }

    private void determineTurnOrderIUI(int n) {
        Vector<GameTurn> vector;
        Object object;
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            object = (Entity)enumeration.nextElement();
            ((TurnOrdered)object).resetOtherTurns();
            if (!((Entity)object).isSelectableThisTurn()) continue;
            ((TurnOrdered)object).incrementOtherTurns();
        }
        enumeration = TurnOrdered.generateTurnOrder(this.game.getEntitiesVector(), this.game);
        object = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                return Server.this.game.isEntityStranded(entity);
            }
        });
        if (object.hasMoreElements() && this.game.getPhase() == 8) {
            vector = new Vector(((TurnVectors)enumeration).getNormalTurns() + ((TurnVectors)enumeration).getEvenTurns() + 1);
            vector.addElement(new GameTurn.UnloadStrandedTurn((Enumeration)object));
        } else {
            vector = new Vector<GameTurn>(((TurnVectors)enumeration).getNormalTurns() + ((TurnVectors)enumeration).getEvenTurns());
        }
        while (((TurnVectors)enumeration).hasMoreElements()) {
            Entity entity = (Entity)((TurnVectors)enumeration).nextElement();
            if (!entity.isSelectableThisTurn()) continue;
            vector.addElement(new GameTurn.SpecificEntityTurn(entity.getOwnerId(), entity.getId()));
        }
        this.game.setTurnVector(vector);
        this.game.resetTurnIndex();
        this.send(this.createTurnVectorPacket());
    }

    private void determineTurnOrder(int n) {
        Object object;
        Object object2;
        int n2;
        Serializable serializable;
        if (this.game.getOptions().booleanOption("individual_initiative")) {
            this.determineTurnOrderIUI(n);
            return;
        }
        boolean bl = this.game.getOptions().booleanOption("inf_move_even") && (this.game.getPhase() == 5 || this.game.getPhase() == 8) || this.game.getOptions().booleanOption("inf_deploy_even") && this.game.getPhase() == 4;
        boolean bl2 = this.game.getOptions().booleanOption("inf_move_multi") && (this.game.getPhase() == 5 || this.game.getPhase() == 8);
        boolean bl3 = this.game.getOptions().booleanOption("protos_move_even") && (this.game.getPhase() == 5 || this.game.getPhase() == 8) || this.game.getOptions().booleanOption("protos_deploy_even") && this.game.getPhase() == 4;
        boolean bl4 = this.game.getOptions().booleanOption("protos_move_multi");
        boolean bl5 = !bl4 && this.game.getPhase() == 12;
        int n3 = 0;
        if (bl) {
            ++n3;
        }
        if (bl3) {
            n3 += 2;
        }
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            serializable = (Player)enumeration.nextElement();
            ((TurnOrdered)serializable).resetEvenTurns();
            ((TurnOrdered)serializable).resetMultiTurns();
            ((TurnOrdered)serializable).resetOtherTurns();
            if (!bl5) continue;
            int n4 = this.game.getSelectedEntityCount(new EntitySelector((Player)serializable){
                private final int ownerId;
                final /* synthetic */ Player val$player;
                {
                    this.val$player = player;
                    this.ownerId = this.val$player.getId();
                }

                public boolean accept(Entity entity) {
                    return entity instanceof Protomech && this.ownerId == entity.getOwnerId();
                }
            });
            n2 = (int)Math.ceil((double)n4 / 5.0);
            for (int i = 0; i < n2; ++i) {
                if (bl3) {
                    ((TurnOrdered)serializable).incrementEvenTurns();
                    continue;
                }
                ((TurnOrdered)serializable).incrementOtherTurns();
            }
        }
        enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            serializable = (Entity)enumeration.nextElement();
            if (!((Entity)serializable).isSelectableThisTurn()) continue;
            Player player = ((Entity)serializable).getOwner();
            if (serializable instanceof Infantry) {
                if (bl) {
                    player.incrementEvenTurns();
                    continue;
                }
                if (bl2) {
                    player.incrementMultiTurns();
                    continue;
                }
                player.incrementOtherTurns();
                continue;
            }
            if (serializable instanceof Protomech) {
                if (bl5) continue;
                if (bl3) {
                    player.incrementEvenTurns();
                    continue;
                }
                if (bl4) {
                    player.incrementMultiTurns();
                    continue;
                }
                player.incrementOtherTurns();
                continue;
            }
            player.incrementOtherTurns();
        }
        int n5 = this.game.getNoOfTeams();
        serializable = new Hashtable(n5);
        Hashtable<Object, int[]> hashtable = new Hashtable<Object, int[]>(n5);
        n2 = 0;
        Enumeration enumeration2 = this.game.getTeams();
        while (enumeration2.hasMoreElements()) {
            object2 = (Team)enumeration2.nextElement();
            ((Hashtable)serializable).put(object2, ((Team)object2).determineTeamOrder(this.game));
            object = new int[]{0, 0};
            hashtable.put(object2, (int[])object);
            if (((Team)object2).getNormalTurns(this.game) <= 0) continue;
            ++n2;
        }
        enumeration2 = TurnOrdered.generateTurnOrder(this.game.getTeamsVector(), this.game);
        object2 = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                return Server.this.game.isEntityStranded(entity);
            }
        });
        if (object2.hasMoreElements() && this.game.getPhase() == 8) {
            object = new Vector(((TurnVectors)enumeration2).getNormalTurns() + ((TurnVectors)enumeration2).getEvenTurns() + 1);
            object.addElement(new GameTurn.UnloadStrandedTurn((Enumeration)object2));
        } else {
            object = new Vector(((TurnVectors)enumeration2).getNormalTurns() + ((TurnVectors)enumeration2).getEvenTurns());
        }
        Team team = null;
        int n6 = ((TurnVectors)enumeration2).getMin();
        int n7 = 0;
        while (((TurnVectors)enumeration2).hasMoreElements()) {
            Player player;
            Team team2 = (Team)((TurnVectors)enumeration2).nextElement();
            TurnVectors turnVectors = (TurnVectors)((Hashtable)serializable).get(team2);
            int[] nArray = (int[])hashtable.get(team2);
            float f = team2.getEvenTurns();
            int n8 = 0;
            if (1 == n2) {
                n8 = (int)((float)n8 + f);
            } else if (team == null) {
                nArray[0] = nArray[0] + 1;
                n8 = (int)((float)n8 + f / (float)n6);
            } else if (!team2.equals(team)) {
                nArray[0] = nArray[0] + 1;
                n8 = (int)((double)n8 + (Math.ceil((double)((float)nArray[0] * (f % (float)n6) / (float)n6) - 0.5) - (double)nArray[1]));
                nArray[1] = nArray[1] + n8;
                n8 = (int)((float)n8 + f / (float)n6);
            }
            team = team2;
            if (turnVectors.hasMoreElements()) {
                player = (Player)turnVectors.nextElement();
                GameTurn gameTurn = null;
                gameTurn = n7 >= ((TurnVectors)enumeration2).getNormalTurns() ? new GameTurn.EntityClassTurn(player.getId(), n3) : (bl || bl3 ? new GameTurn.EntityClassTurn(player.getId(), ~n3) : new GameTurn(player.getId()));
                object.addElement(gameTurn);
            }
            while (n8 > 0 && turnVectors.hasMoreEvenElements()) {
                player = (Player)turnVectors.nextEvenElement();
                object.addElement(new GameTurn.EntityClassTurn(player.getId(), n3));
                --n8;
            }
            ++n7;
        }
        this.game.setTurnVector((Vector)object);
        this.game.resetTurnIndex();
        this.send(this.createTurnVectorPacket());
    }

    private void writeInitiativeReport(boolean bl) {
        Object object;
        Report report;
        boolean bl2 = false;
        if (!bl) {
            report = new Report(1210);
            report.type = 0;
            if (this.game.getLastPhase() == 4 || this.game.isDeploymentComplete() || !this.game.shouldDeployThisRound()) {
                report.messageId = 1000;
                report.add(this.game.getRoundCount());
            } else {
                bl2 = true;
                if (this.game.getRoundCount() == 0) {
                    report.messageId = 1005;
                } else {
                    report.messageId = 1010;
                    report.add(this.game.getRoundCount());
                }
            }
            this.addReport(report);
            this.addReport(new Report(1200, 0));
        } else {
            this.addReport(new Report(1210, 0));
        }
        if (this.game.getOptions().booleanOption("individual_initiative")) {
            report = new Report(1040, 0);
            this.addReport(report);
            object = this.game.getTurns();
            while (object.hasMoreElements()) {
                TurnOrdered turnOrdered;
                GameTurn gameTurn = (GameTurn)object.nextElement();
                if (gameTurn instanceof GameTurn.SpecificEntityTurn) {
                    turnOrdered = this.game.getEntity(((GameTurn.SpecificEntityTurn)gameTurn).getEntityNum());
                    report = new Report(1045);
                    report.subject = ((Entity)turnOrdered).getId();
                    report.addDesc((Entity)turnOrdered);
                    report.add(turnOrdered.getInitiative().toString());
                    this.addReport(report);
                    continue;
                }
                turnOrdered = this.getPlayer(gameTurn.getPlayerNum());
                if (null == turnOrdered) continue;
                report = new Report(1050, 0);
                report.add(((Player)turnOrdered).getName());
                this.addReport(report);
            }
        } else {
            Serializable serializable;
            Object object2;
            Enumeration enumeration = this.game.getTeams();
            while (enumeration.hasMoreElements()) {
                Team team = (Team)enumeration.nextElement();
                if (team.getSize() == 1) {
                    object2 = (Player)team.getPlayers().nextElement();
                    report = new Report(1015, 0);
                    report.add(((Player)object2).getName());
                    report.add(team.getInitiative().toString());
                    this.addReport(report);
                    continue;
                }
                report = new Report(1015, 0);
                report.add(Player.teamNames[team.getId()]);
                report.add(team.getInitiative().toString());
                this.addReport(report);
                object2 = team.getPlayers();
                while (object2.hasMoreElements()) {
                    serializable = (Player)object2.nextElement();
                    report = new Report(1015, 0);
                    report.indent();
                    report.add(((Player)serializable).getName());
                    report.add(((TurnOrdered)serializable).getInitiative().toString());
                    this.addReport(report);
                }
            }
            report = new Report(1020, 0);
            boolean bl3 = true;
            boolean bl4 = false;
            object2 = this.game.getTurns();
            while (object2.hasMoreElements()) {
                serializable = (GameTurn)object2.nextElement();
                Player player = this.getPlayer(((GameTurn)serializable).getPlayerNum());
                if (null == player) continue;
                report.add(player.getName());
                bl3 = false;
                if (player.getEvenTurns() <= 0) continue;
                bl4 = true;
            }
            report.newlines = 2;
            this.addReport(report);
            if (bl4) {
                report = new Report(1021, 0);
                if ((this.game.getOptions().booleanOption("inf_deploy_even") || this.game.getOptions().booleanOption("protos_deploy_even")) && this.game.getLastPhase() != 17) {
                    report.choose(true);
                } else {
                    report.choose(false);
                }
                report.indent();
                report.newlines = 2;
                this.addReport(report);
            }
        }
        if (!bl) {
            report = new Report(1025, 0);
            report.add(this.game.getStringWindDirection());
            if (this.game.getWindStrength() != -1) {
                object = new Report(1030, 0);
                ((Report)object).add(this.game.getStringWindStrength());
                report.newlines = 0;
                this.addReport(report);
                this.addReport((Report)object);
            } else {
                this.addReport(report);
            }
            if (bl2) {
                this.addNewLines();
            }
        }
    }

    private void setIneligible(int n) {
        Vector<Entity> vector = new Vector<Entity>();
        boolean bl = false;
        Entity entity = null;
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity = (Entity)enumeration.nextElement();
            if (!entity.isEligibleFor(n)) {
                vector.addElement(entity);
                continue;
            }
            bl = true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            entity = (Entity)vector.elementAt(i);
            if (bl && entity.canAssist(n)) continue;
            entity.setDone(true);
        }
    }

    private void loadUnit(Entity entity, Entity entity2) {
        if (!entity2.isDone()) {
            this.game.removeTurnFor(entity2);
            this.send(this.createTurnVectorPacket());
        }
        entity.load(entity2);
        entity2.setTransportId(entity.getId());
        entity2.setPosition(null);
        this.entityUpdate(entity2.getId());
    }

    private boolean unloadUnit(Entity entity, Targetable targetable, Coords coords, int n, int n2) {
        Entity entity2 = null;
        if (!(targetable instanceof Entity)) {
            return false;
        }
        entity2 = (Entity)targetable;
        if (!entity.unload(entity2)) {
            return false;
        }
        entity2.setTransportId(-1);
        entity2.setPosition(coords);
        if (coords != null) {
            entity2.setDeployed(true);
        }
        entity2.setFacing(n);
        entity2.setSecondaryFacing(n);
        IHex iHex = this.game.getBoard().getHex(coords);
        boolean bl = iHex.containsTerrain(5);
        if (entity.getMovementMode() == 6) {
            if (entity2.getMovementMode() == 6) {
                entity2.setElevation(n2);
            } else if (this.game.getBoard().getBuildingAt(coords) != null) {
                entity2.setElevation(iHex.terrainLevel(12));
            }
        } else if (this.game.getBoard().getBuildingAt(coords) != null) {
            entity2.setElevation(n2);
        } else if (iHex.terrainLevel(4) > 0) {
            if (entity2.getMovementMode() == 5 || entity2.getMovementMode() == 8 || entity2.getMovementMode() == 7 || entity2.getMovementMode() == 9 || iHex.containsTerrain(20) || bl) {
                entity2.setElevation(0);
            }
        } else {
            entity2.setElevation(iHex.floor() - iHex.surface());
        }
        this.doSetLocationsExposure(entity2, iHex, false, entity2.getElevation());
        this.entityUpdate(entity2.getId());
        return true;
    }

    private void addAffectedBldg(Building building, boolean bl) {
        if (bl) {
            System.err.print(new StringBuffer().append("Removing building from a list of ").append(this.affectedBldgs.size()).append('\n').toString());
            this.affectedBldgs.remove(building);
            System.err.print(new StringBuffer().append("... now list of ").append(this.affectedBldgs.size()).append('\n').toString());
        } else {
            this.affectedBldgs.put(building, Boolean.FALSE);
        }
    }

    private void applyAffectedBldgs() {
        Vector<Building> vector = new Vector<Building>();
        boolean bl = false;
        Enumeration enumeration = this.affectedBldgs.keys();
        while (enumeration.hasMoreElements()) {
            Building building = (Building)enumeration.nextElement();
            Enumeration enumeration2 = building.getCoords();
            while (enumeration2.hasMoreElements()) {
                Coords coords = (Coords)enumeration2.nextElement();
                Enumeration enumeration3 = this.game.getEntities(coords);
                while (enumeration3.hasMoreElements()) {
                    Entity entity = (Entity)enumeration3.nextElement();
                    if (!(entity instanceof Infantry)) continue;
                    if (entity.isDoomed() || entity.isDestroyed()) {
                        if (!entity.isDone()) {
                            this.game.removeTurnFor(entity);
                            bl = true;
                        }
                        entity.setDestroyed(true);
                        this.game.moveToGraveyard(entity.getId());
                        this.send(this.createRemoveEntityPacket(entity.getId()));
                        continue;
                    }
                    this.entityUpdate(entity.getId());
                }
            }
            vector.addElement(building);
        }
        if (bl) {
            this.send(this.createTurnVectorPacket());
        }
        if (!vector.isEmpty()) {
            this.sendChangedCFBuildings(vector);
            this.affectedBldgs.clear();
        }
    }

    private void receiveMovement(Packet packet, int n) {
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        MovePath movePath = (MovePath)packet.getObject(1);
        if (this.game.getPhase() != 8) {
            System.err.println("error: server got movement packet in wrong phase");
            return;
        }
        if (!this.game.getTurn().isValid(n, entity, this.game)) {
            System.err.println("error: server got invalid movement packet");
            return;
        }
        this.processMovement(entity, movePath);
        this.applyAffectedBldgs();
        if (this.doBlind()) {
            this.updateVisibilityIndicator();
        }
        this.endCurrentTurn(entity);
    }

    private void processMovement(Entity entity, MovePath movePath) {
        Report report;
        Object object;
        PilotingRollData pilotingRollData;
        Object object2;
        int n;
        Object object3;
        Vector<UnitLocation> vector;
        Serializable serializable;
        boolean bl = false;
        if (movePath.contains(10)) {
            Entity entity2;
            Serializable serializable2;
            Enumeration enumeration;
            Report report2 = new Report(2005, 0);
            report2.addDesc(entity);
            this.addReport(report2);
            Coords coords = entity.getPosition();
            int n2 = coords.x == 0 ? 3 : (coords.y == 0 ? 1 : (coords.x == this.game.getBoard().getWidth() ? 2 : 0));
            Vector vector2 = entity.getLoadedUnits();
            if (!vector2.isEmpty()) {
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    serializable2 = (Entity)enumeration.nextElement();
                    report2 = new Report(2010, 0);
                    report2.indent();
                    report2.addDesc((Entity)serializable2);
                    this.addReport(report2);
                    ((Entity)serializable2).setRetreatedDirection(n2);
                    this.game.removeEntity(((Entity)serializable2).getId(), 256);
                    this.send(this.createRemoveEntityPacket(((Entity)serializable2).getId(), 256));
                }
            }
            enumeration = entity.getPickedUpMechWarriors().elements();
            while (enumeration.hasMoreElements()) {
                serializable2 = (Integer)enumeration.nextElement();
                entity2 = this.game.getEntity((Integer)serializable2);
                int n3 = 256;
                report2 = new Report(2010);
                if (entity2.isCaptured()) {
                    report2 = new Report(2015);
                    n3 = 288;
                } else {
                    entity2.setRetreatedDirection(n2);
                }
                this.game.removeEntity(entity2.getId(), n3);
                this.send(this.createRemoveEntityPacket(entity2.getId(), n3));
                report2.addDesc(entity2);
                report2.indent();
                this.addReport(report2);
            }
            int n4 = entity.getSwarmAttackerId();
            if (-1 != n4) {
                entity2 = this.game.getEntity(n4);
                if (!entity2.isDone()) {
                    this.game.removeTurnFor(entity2);
                    this.send(this.createTurnVectorPacket());
                }
                entity2.setSwarmTargetId(-1);
                entity.setSwarmAttackerId(-1);
                report2 = new Report(2015, 0);
                report2.indent();
                report2.addDesc(entity2);
                this.addReport(report2);
                this.game.removeEntity(n4, 288);
                this.send(this.createRemoveEntityPacket(n4, 288));
            }
            entity.setRetreatedDirection(n2);
            this.game.removeEntity(entity.getId(), 256);
            this.send(this.createRemoveEntityPacket(entity.getId(), 256));
            return;
        }
        if (movePath.contains(18)) {
            if (entity instanceof Mech) {
                Report report3 = new Report(2020);
                report3.subject = entity.getId();
                report3.add(entity.getCrew().getName());
                report3.addDesc(entity);
                this.addReport(report3);
            } else if (entity instanceof Tank) {
                Report report4 = new Report(2025);
                report4.subject = entity.getId();
                report4.addDesc(entity);
                this.addReport(report4);
            }
            this.addReport(this.ejectEntity(entity, false));
            return;
        }
        Coords coords = entity.getPosition();
        Coords coords2 = entity.getPosition();
        int n5 = entity.getFacing();
        int n6 = entity.getElevation();
        int n7 = entity.delta_distance;
        int n8 = entity.mpUsed;
        int n9 = entity.moved;
        int n10 = entity.moved;
        int n11 = n5;
        Object object4 = null;
        boolean bl2 = entity instanceof Infantry;
        Object object5 = null;
        int n12 = 3 == n9 ? entity.getOriginalJumpMP() : entity.getRunMP(false);
        movePath.compile(this.game, entity);
        if (movePath.contains(19)) {
            serializable = new ClearMinefieldAction(entity.getId());
            entity.setClearingMinefield(true);
            this.game.addAction((EntityAction)((Object)serializable));
        }
        if (entity instanceof Mech && ((Mech)entity).checkForMASCFailure(movePath, vector = new Vector<UnitLocation>(), (Vector)(serializable = new Vector()))) {
            this.addReport(vector);
            object3 = null;
            n = -1;
            object2 = ((Vector)serializable).elements();
            while (object2.hasMoreElements()) {
                Object e = object2.nextElement();
                if (e instanceof Integer) {
                    n = (Integer)e;
                    continue;
                }
                if (!(e instanceof CriticalSlot)) continue;
                object3 = (CriticalSlot)e;
                this.applyCriticalHit(entity, n, (CriticalSlot)object3, true);
            }
            movePath.clear();
        }
        n10 = movePath.getLastStepMovementType();
        if (this.game.getBoard().getHex(entity.getPosition()).terrainLevel(24) == 2 && entity.getElevation() == 0) {
            this.doMagmaDamage(entity, false);
        }
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        serializable = null;
        vector = new Vector();
        object3 = movePath.getSteps();
        while (object3.hasMoreElements()) {
            Targetable targetable;
            int n13;
            MoveStep moveStep = (MoveStep)object3.nextElement();
            boolean bl7 = entity.isProne();
            boolean bl8 = moveStep.isPavementStep();
            boolean bl9 = false;
            if (moveStep.getMovementType() == -1 || entity.isDestroyed() || entity.isDoomed()) break;
            pilotingRollData = entity.checkGetUp(moveStep);
            if (pilotingRollData.getValue() != -2147483647) {
                ++entity.heatBuildup;
                entity.setProne(false);
                entity.setHullDown(false);
                bl7 = false;
                this.game.resetPSRs(entity);
                boolean bl6 = bl9 = !this.doSkillCheckInPlace(entity, pilotingRollData);
            }
            if (bl9) {
                n9 = moveStep.getMovementType();
                n5 = entity.getFacing();
                coords2 = entity.getPosition();
                n8 = moveStep.getMpUsed();
                bl4 = true;
                break;
            }
            if (moveStep.getType() == 15) {
                entity.setUnjammingRAC(true);
                this.game.addAction(new UnjamAction(entity.getId()));
                break;
            }
            if (moveStep.getType() == 23) {
                LayMinefieldAction layMinefieldAction = new LayMinefieldAction(entity.getId(), moveStep.getMineToLay());
                this.game.addLayMinefieldAction(layMinefieldAction);
                entity.setLayingMines(true);
                break;
            }
            if (moveStep.getType() == 22 && entity.hasSpotlight()) {
                boolean bl11 = !entity.isUsingSpotlight();
                entity.setSpotlightState(bl11);
                this.sendServerChat(new StringBuffer().append(entity.getDisplayName()).append(" switched searchlight ").append(bl11 ? "on" : "off").append('.').toString());
            }
            n9 = moveStep.getMovementType();
            n7 = moveStep.getDistance();
            n8 = moveStep.getMpUsed();
            if (moveStep.getType() == 8) {
                if (entity.canCharge()) {
                    this.checkExtremeGravityMovement(entity, moveStep, coords2, n12);
                    Targetable targetable2 = moveStep.getTarget(this.game);
                    object = new ChargeAttackAction(entity.getId(), targetable2.getTargetType(), targetable2.getTargetId(), targetable2.getPosition());
                    entity.setDisplacementAttack((DisplacementAttackAction)object);
                    this.game.addCharge((AttackAction)object);
                    object5 = object;
                    break;
                }
                this.sendServerChat(new StringBuffer().append("Illegal charge!! I don't think ").append(entity.getDisplayName()).append(" should be allowed to charge,").append(" but the client of ").append(entity.getOwner().getName()).append(" disagrees.").toString());
                this.sendServerChat(new StringBuffer().append("Please make sure ").append(entity.getOwner().getName()).append(" is running MegaMek ").append(MegaMek.VERSION).append(", or if that is already the case, submit a bug report at http://megamek.sf.net/").toString());
                return;
            }
            if (moveStep.getType() == 9) {
                if (entity.canDFA()) {
                    this.checkExtremeGravityMovement(entity, moveStep, coords2, n12);
                    Targetable targetable3 = moveStep.getTarget(this.game);
                    object = new DfaAttackAction(entity.getId(), targetable3.getTargetType(), targetable3.getTargetId(), targetable3.getPosition());
                    entity.setDisplacementAttack((DisplacementAttackAction)object);
                    this.game.addCharge((AttackAction)object);
                    object5 = object;
                    break;
                }
                this.sendServerChat(new StringBuffer().append("Illegal DFA!! I don't think ").append(entity.getDisplayName()).append(" should be allowed to DFA,").append(" but the client of ").append(entity.getOwner().getName()).append(" disagrees.").toString());
                this.sendServerChat(new StringBuffer().append("Please make sure ").append(entity.getOwner().getName()).append(" is running MegaMek ").append(MegaMek.VERSION).append(", or if that is already the case, submit a bug report at http://megamek.sf.net/").toString());
                return;
            }
            if (entity instanceof Infantry) {
                Infantry infantry = (Infantry)entity;
                if (moveStep.getType() == 28) {
                    infantry.setDugIn(1);
                    continue;
                }
                if (moveStep.getType() == 29) {
                    if (!entity.hasWorkingMisc(0x100000L, 1)) {
                        this.sendServerChat(new StringBuffer().append(entity.getDisplayName()).append(" failed to fortify because it is missing suitable equipment").toString());
                    }
                    infantry.setDugIn(3);
                    continue;
                }
                if (moveStep.getType() != 3 && moveStep.getType() != 4) {
                    infantry.setDugIn(0);
                }
            }
            coords2 = moveStep.getPosition();
            if (n9 != 3 || entity.getJumpType() != 3) {
                n5 = moveStep.getFacing();
            }
            int n14 = entity.checkMovementInBuilding(moveStep, (MoveStep)serializable, coords2, coords);
            n6 = moveStep.getElevation();
            entity.setElevation(moveStep.getElevation());
            object = this.game.getBoard().getHex(coords2);
            if (entity.canUnstickByJumping() && entity.isStuck() && n9 == 3) {
                entity.setStuck(false);
                entity.setCanUnstickByJumping(false);
            }
            if ((pilotingRollData = entity.checkSkid(n9, (IHex)object4, n10, (MoveStep)serializable, n11, n5, coords, coords2, bl2, n7)).getValue() != -2147483647) {
                n13 = 1;
                n13 = entity instanceof Mech ? this.doSkillCheckWhileMoving(entity, coords, coords, pilotingRollData, true) : this.doSkillCheckWhileMoving(entity, coords, coords, pilotingRollData, false);
                if (n13 == 0) {
                    int n2;
                    Coords coords3 = coords2 = coords;
                    IHex iHex = null;
                    int n16 = 0;
                    Object enumeration = null;
                    Entity entity2 = null;
                    int n3 = n11;
                    entity.delta_distance = n7 - 1;
                    n9 = -2;
                    if (moveStep.isThisStepBackwards()) {
                        n3 = (n3 + 3) % 6;
                    }
                    coords3 = coords2.translated(n3);
                    iHex = this.game.getBoard().getHex(coords3);
                    for (n16 = 0; n16 < (int)Math.ceil((double)entity.delta_distance / 2.0); ++n16) {
                        Object object6;
                        int n4;
                        if (!this.game.getBoard().contains(coords3)) {
                            if (this.game.getOptions().booleanOption("push_off_board")) {
                                this.game.removeEntity(entity.getId(), 272);
                                this.send(this.createRemoveEntityPacket(entity.getId(), 272));
                                report = new Report(2030, 0);
                                report.addDesc(entity);
                                this.addReport(report);
                                return;
                            }
                            report = new Report(2035);
                            report.subject = entity.getId();
                            report.indent();
                            this.addReport(report);
                            break;
                        }
                        if ((entity.isHexProhibited((IHex)object) || entity.isHexProhibited(iHex)) && !Compute.canMoveOnPavement(this.game, coords2, coords3)) {
                            report = new Report(2040);
                            report.subject = entity.getId();
                            report.indent();
                            report.add(coords3.getBoardNum(), true);
                            this.addReport(report);
                            break;
                        }
                        int n15 = entity.getElevation() + object.getElevation();
                        int n17 = iHex.floor();
                        if (iHex.containsTerrain(12)) {
                            n17 = Math.min(n15, iHex.getElevation() + iHex.terrainLevel(12));
                        }
                        if (iHex.containsTerrain(14)) {
                            int n18 = (n3 + 3) % 6;
                            n18 = 1 << n18;
                            if ((iHex.getTerrain(14).getExits() & n18) == n18) {
                                n17 = Math.min(n15, Math.max(n17, iHex.getElevation() + iHex.terrainLevel(16)));
                            }
                        }
                        if (n17 <= iHex.surface() && n15 >= object.surface()) {
                            if (entity instanceof Tank && entity.getMovementMode() == 5) {
                                if (iHex.containsTerrain(4)) {
                                    n17 = iHex.surface();
                                }
                            } else if (iHex.containsTerrain(20)) {
                                n17 = iHex.surface();
                            }
                        }
                        if (n15 < n17) {
                            report = new Report(2045);
                            report.subject = entity.getId();
                            report.indent();
                            report.add(coords3.getBoardNum(), true);
                            this.addReport(report);
                            break;
                        }
                        if (n15 > n17 + 1) {
                            this.doEntityFallsInto(entity, coords2, coords3, entity.getBasePilotingRoll());
                            this.doEntityDisplacementMinefieldCheck(entity, coords2, coords3);
                            break;
                        }
                        int n19 = n17 - iHex.surface();
                        Building building = null;
                        if (n19 < iHex.terrainLevel(12)) {
                            building = this.game.getBoard().getBuildingAt(coords3);
                        }
                        n2 = 0;
                        boolean bl10 = false;
                        Enumeration enumeration2 = this.game.getEntities(coords3);
                        if (enumeration2.hasMoreElements()) {
                            Serializable serializable2;
                            n4 = 0;
                            while (enumeration2.hasMoreElements()) {
                                entity2 = (Entity)enumeration2.nextElement();
                                if (entity2.getElevation() > n19 + entity.getHeight() || entity2.absHeight() < n19) continue;
                                if (entity2 instanceof Mech || entity2 instanceof Tank) {
                                    object6 = new ChargeAttackAction(entity.getId(), entity2.getTargetType(), entity2.getTargetId(), entity2.getPosition());
                                    serializable2 = ((ChargeAttackAction)object6).toHit(this.game, true);
                                    if (entity instanceof Tank && (entity.getMovementMode() == 5 || entity.getMovementMode() == 7 || entity.getMovementMode() == 8) && 0 < iHex.terrainLevel(4) && entity2.getElevation() == -1 && !entity2.isProne()) {
                                        ((ToHitData)serializable2).setHitTable(1);
                                    } else if (entity.getHeight() < entity2.getHeight()) {
                                        ((ToHitData)serializable2).setHitTable(2);
                                    } else {
                                        ((ToHitData)serializable2).setHitTable(0);
                                    }
                                    ((ToHitData)serializable2).setSideTable(Compute.targetSideTable(entity, (Targetable)entity2));
                                    int n20 = Compute.d6(2);
                                    report = new Report(2050);
                                    report.subject = entity.getId();
                                    report.indent();
                                    report.add(entity2.getShortName(), true);
                                    report.add(coords3.getBoardNum(), true);
                                    report.newlines = 0;
                                    this.addReport(report);
                                    if (((TargetRoll)serializable2).getValue() == Integer.MAX_VALUE) {
                                        n20 = -12;
                                        report = new Report(2055);
                                        report.subject = entity.getId();
                                        report.add(((TargetRoll)serializable2).getDesc());
                                        report.newlines = 0;
                                        this.addReport(report);
                                    } else if (((TargetRoll)serializable2).getValue() == Integer.MIN_VALUE) {
                                        report = new Report(2060);
                                        report.subject = entity.getId();
                                        report.add(((TargetRoll)serializable2).getDesc());
                                        report.newlines = 0;
                                        this.addReport(report);
                                        n20 = Integer.MAX_VALUE;
                                    } else {
                                        report = new Report(2065);
                                        report.subject = entity.getId();
                                        report.add(((TargetRoll)serializable2).getValue());
                                        report.add(n20);
                                        report.newlines = 0;
                                        this.addReport(report);
                                    }
                                    if (n20 < ((TargetRoll)serializable2).getValue()) {
                                        report = new Report(2070);
                                        report.subject = entity.getId();
                                        this.addReport(report);
                                    } else {
                                        this.resolveChargeDamage(entity, entity2, (ToHitData)serializable2, n3);
                                        if (enumeration2.hasMoreElements()) {
                                            entity.setPosition(coords2);
                                        }
                                        n2 = 1;
                                        n4 = 1;
                                    }
                                    if (!(entity2.isDoomed() || entity2.isDestroyed() || this.game.isOutOfGame(entity2))) {
                                        bl10 = true;
                                    }
                                    if (!entity2.isDone()) {
                                        this.resolvePilotingRolls(entity2);
                                        this.game.resetPSRs(entity2);
                                        entity2.applyDamage();
                                        this.addNewLines();
                                    }
                                } else if (entity2 instanceof Infantry && building != null) {
                                    report = new Report(2075);
                                    report.subject = entity.getId();
                                    report.indent();
                                    report.add(entity2.getShortName(), true);
                                    report.add(coords3.getBoardNum(), true);
                                    report.newlines = 0;
                                    this.addReport(report);
                                    object6 = entity2.rollHitLocation(0, Compute.targetSideTable(entity, (Targetable)entity2));
                                    this.addReport(this.damageEntity(entity2, (HitData)object6, Math.round(entity.getWeight() / 5.0f)));
                                    this.addNewLines();
                                }
                                if (entity2.isDoomed()) {
                                    if (!entity2.isDone()) {
                                        this.game.removeTurnFor(entity2);
                                        this.send(this.createTurnVectorPacket());
                                    }
                                    entity2.setDestroyed(true);
                                    this.game.moveToGraveyard(entity2.getId());
                                    this.send(this.createRemoveEntityPacket(entity2.getId()));
                                }
                                if (this.game.isOutOfGame(entity2)) continue;
                                this.entityUpdate(entity2.getId());
                            }
                            if (n4 == 0) {
                                object6 = entity.getPosition();
                                serializable2 = Compute.getMissedChargeDisplacement(this.game, entity.getId(), (Coords)object6, n3);
                                this.doEntityDisplacement(entity, (Coords)object6, (Coords)serializable2, null);
                            } else {
                                entity.setPosition(coords3);
                            }
                        }
                        if (building != null) {
                            report = new Report(2080);
                            report.subject = entity.getId();
                            report.indent();
                            report.add(building.getName());
                            report.add(coords3.getBoardNum(), true);
                            this.addReport(report);
                            n4 = ChargeAttackAction.getDamageFor(entity);
                            if (n2 == 0) {
                                object6 = this.damageBuilding(building, n4);
                                if (object6 != null) {
                                    ((Report)object6).indent(2);
                                    ((Report)object6).subject = entity.getId();
                                    this.addReport((Report)object6);
                                }
                                int n21 = ChargeAttackAction.getDamageTakenBy(entity, building);
                                HitData hitData = entity.rollHitLocation(0, entity.sideTable(coords3));
                                this.addReport(this.damageEntity(entity, hitData, n21));
                                this.addNewLines();
                                entity.setPosition(coords3);
                                this.doEntityDisplacementMinefieldCheck(entity, coords2, coords3);
                                coords2 = coords3;
                            }
                            this.damageInfantryIn(building, n4);
                            if (building.getCurrentCF() > 0) {
                                bl10 = true;
                                this.addAffectedBldg(building, false);
                            }
                        }
                        if (bl10) break;
                        entity.setPosition(coords3);
                        entity.setElevation(n19);
                        this.doEntityDisplacementMinefieldCheck(entity, coords2, coords3);
                        Building building2 = this.game.getBoard().getBuildingAt(coords3);
                        if (building2 != null && this.checkForCollapse(building2, this.game.getPositionMap())) break;
                        pilotingRollData = entity.checkRubbleMove(moveStep, iHex, coords2, coords3);
                        if (pilotingRollData.getValue() != -2147483647) {
                            this.doSkillCheckWhileMoving(entity, coords2, coords3, pilotingRollData, true);
                            if (entity.isProne()) break;
                        }
                        if (iHex.terrainLevel(24) == 1 && n19 == 0) {
                            int n22 = Compute.d6(1);
                            report = new Report(2395);
                            report.addDesc(entity);
                            report.add(n22);
                            report.subject = entity.getId();
                            this.addReport(report);
                            if (n22 == 6) {
                                iHex.removeTerrain(24);
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(24, 2));
                                this.sendChangedHex(coords2);
                                Enumeration enumeration3 = this.game.getEntities(coords2);
                                while (enumeration3.hasMoreElements()) {
                                    Entity entity3 = (Entity)enumeration3.nextElement();
                                    if (entity3 == entity) continue;
                                    this.doMagmaDamage(entity3, false);
                                }
                            }
                        }
                        if (iHex.terrainLevel(24) == 2 && n19 == 0) {
                            this.doMagmaDamage(entity, false);
                        }
                        if ((pilotingRollData = entity.checkSwampMove(moveStep, iHex, coords2, coords3, bl8)).getValue() != -2147483647 && !this.doSkillCheckWhileMoving(entity, coords2, coords3, pilotingRollData, false)) {
                            entity.setStuck(true);
                            report = new Report(2081);
                            report.subject = entity.getId();
                            report.add(entity.getDisplayName(), true);
                            break;
                        }
                        coords2 = coords3;
                        object = iHex;
                        report = new Report(2085);
                        report.subject = entity.getId();
                        report.indent();
                        report.add(coords2.getBoardNum(), true);
                        this.addReport(report);
                        coords3 = coords3.translated(n3);
                        iHex = this.game.getBoard().getHex(coords3);
                    }
                    coords2 = entity.getPosition();
                    entity2 = Compute.stackingViolation(this.game, entity.getId(), coords2);
                    while (entity2 != null) {
                        coords3 = Compute.getValidDisplacement(this.game, entity2.getId(), entity2.getPosition(), n3);
                        if (null == coords3) {
                            System.err.println(new StringBuffer().append("The skid of ").append(entity.getShortName()).append(" should displace ").append(entity2.getShortName()).append(" in hex ").append(coords2.getBoardNum()).append(" but there is nowhere to go.").toString());
                            break;
                        }
                        report = new Report(1210, 0);
                        report.indent();
                        report.newlines = 0;
                        this.addReport(report);
                        this.doEntityDisplacement(entity2, coords2, coords3, null);
                        this.doEntityDisplacementMinefieldCheck(entity, coords2, coords3);
                        entity2 = Compute.stackingViolation(this.game, entity.getId(), coords2);
                    }
                    if (entity instanceof Mech) {
                        int n23;
                        report = new Report(2090);
                        report.subject = entity.getId();
                        report.indent();
                        report.addDesc(entity);
                        report.add(n23);
                        this.addReport(report);
                        for (n23 = n16 * (int)Math.ceil((double)Math.round((double)entity.getWeight() / 10.0) / 2.0); n23 > 0; n23 -= n2) {
                            n2 = Math.min(5, n23);
                            HitData hitData = entity.rollHitLocation(0, 0);
                            this.addReport(this.damageEntity(entity, hitData, n2));
                        }
                        this.addNewLines();
                    }
                    if (entity.isDoomed()) {
                        entity.setDestroyed(true);
                        this.game.moveToGraveyard(entity.getId());
                        this.send(this.createRemoveEntityPacket(entity.getId()));
                        return;
                    }
                    report = new Report(2095);
                    report.subject = entity.getId();
                    report.indent();
                    this.addReport(report);
                    n5 = entity.getFacing();
                    coords2 = entity.getPosition();
                    entity.setSecondaryFacing(n5);
                    n8 = movePath.hasActiveMASC() ? entity.getRunMP() : entity.getRunMPwithoutMASC();
                    entity.moved = n9;
                    bl4 = true;
                    bl5 = true;
                    n7 = entity.delta_distance;
                    break;
                }
            }
            if (entity instanceof VTOL && (pilotingRollData = ((VTOL)entity).checkSideSlip(n9, (IHex)object4, n10, (MoveStep)serializable, n11, n5, coords, coords2, n7)).getValue() != -2147483647 && !this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, false)) {
                bl = true;
                report = new Report(2100);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
                Coords coords4 = coords.translated(n11);
                if (!this.game.getBoard().contains(coords4)) {
                    if (this.game.getOptions().booleanOption("push_off_board")) {
                        this.game.removeEntity(entity.getId(), 272);
                        this.send(this.createRemoveEntityPacket(entity.getId(), 272));
                        report = new Report(2030);
                        report.subject = entity.getId();
                        report.addDesc(entity);
                        this.addReport(report);
                        return;
                    }
                    report = new Report(2035);
                    report.subject = entity.getId();
                    this.addReport(report);
                    break;
                }
                IHex iHex = this.game.getBoard().getHex(coords4);
                int n27 = iHex.ceiling() - iHex.surface();
                int n28 = entity.calcElevation(this.game.getBoard().getHex(coords2), this.game.getBoard().getHex(coords4), n6, moveStep.climbMode());
                if (n28 <= n27) {
                    report = new Report(2105);
                    report.subject = entity.getId();
                    report.add(coords4.getBoardNum(), true);
                    this.addReport(report);
                    int n25 = n5 - n11 + 6;
                    n25 = n25 % 6;
                    int n26 = 0;
                    switch (n25) {
                        case 0: {
                            n26 = 0;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n26 = 2;
                            break;
                        }
                        case 3: {
                            n26 = 1;
                            break;
                        }
                        case 4: 
                        case 5: {
                            n26 = 3;
                        }
                    }
                    coords2 = coords4;
                    n6 = n28;
                    this.addReport(this.crashVTOL((VTOL)entity, true, n7, coords2, n6, n26));
                    bl5 = true;
                    if (iHex.containsTerrain(4) && !iHex.containsTerrain(20) || iHex.containsTerrain(1) || iHex.containsTerrain(23)) {
                        this.addReport(this.destroyEntity(entity, "could not land in crash site"));
                    } else if (n28 < iHex.terrainLevel(12)) {
                        this.addReport(this.destroyEntity(entity, "crashed into building"));
                    }
                } else {
                    report = new Report(2110);
                    report.subject = entity.getId();
                    report.add(coords4.getBoardNum(), true);
                    this.addReport(report);
                    entity.setElevation(entity.calcElevation(this.game.getBoard().getHex(coords2), this.game.getBoard().getHex(coords4), n6, moveStep.climbMode()));
                    coords2 = coords4;
                }
                if (entity.isDestroyed() || entity.isDoomed()) break;
                bl4 = true;
                break;
            }
            pilotingRollData = entity.checkRubbleMove(moveStep, (IHex)object, coords, coords2);
            if (pilotingRollData.getValue() != -2147483647) {
                this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, true);
            }
            if (object.terrainLevel(24) == 1 && moveStep.getElevation() == 0 && moveStep.getMovementType() != 3) {
                n13 = Compute.d6(1);
                report = new Report(2395);
                report.addDesc(entity);
                report.add(n13);
                report.subject = entity.getId();
                this.addReport(report);
                if (n13 == 6) {
                    object.removeTerrain(24);
                    object.addTerrain(Terrains.getTerrainFactory().createTerrain(24, 2));
                    this.sendChangedHex(coords2);
                    Enumeration enumeration = this.game.getEntities(coords2);
                    while (enumeration.hasMoreElements()) {
                        Entity entity5 = (Entity)enumeration.nextElement();
                        if (entity5 == entity) continue;
                        this.doMagmaDamage(entity5, false);
                    }
                }
            }
            if (object.terrainLevel(24) == 2 && moveStep.getElevation() == 0 && moveStep.getMovementType() != 3) {
                this.doMagmaDamage(entity, false);
            }
            if ((pilotingRollData = entity.checkSwampMove(moveStep, (IHex)object, coords, coords2, bl8)).getValue() != -2147483647 && !this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, false)) {
                entity.setStuck(true);
                entity.setCanUnstickByJumping(true);
                report = new Report(2081);
                report.add(entity.getDisplayName());
                report.subject = entity.getId();
                this.addReport(report);
                break;
            }
            IHex iHex = this.game.getBoard().getHex(coords);
            if (entity instanceof Mech && !coords.equals(coords2) && serializable != null && (iHex.containsTerrain(7) && ((MoveStep)serializable).getElevation() <= 1 || iHex.containsTerrain(24) && ((MoveStep)serializable).getElevation() == 0) && (moveStep.getMovementType() != 3 || 0 == moveStep.getMpUsed() - moveStep.getMp())) {
                int n30 = 0;
                if (iHex.containsTerrain(7)) {
                    n30 += 2;
                }
                if (iHex.terrainLevel(24) == 1) {
                    n30 += 2;
                } else if (iHex.terrainLevel(24) == 2) {
                    n30 += 5;
                }
                entity.heatBuildup += n30;
                report = new Report(2115);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n30);
                this.addReport(report);
            }
            if (!(entity instanceof Mech) && this.game.getBoard().getHex(coords2).containsTerrain(7) && !coords.equals(coords2) && moveStep.getMovementType() != 3 && moveStep.getElevation() <= 1) {
                if (this.game.getOptions().booleanOption("vehicle_fires") && entity instanceof Tank) {
                    this.checkForVehicleFire((Tank)entity, false);
                } else {
                    this.doFlamingDeath(entity);
                }
            }
            if (!object3.hasMoreElements() && !bl3) {
                this.checkExtremeGravityMovement(entity, moveStep, coords2, n12);
            }
            if (!coords.equals(coords2) && moveStep.getMovementType() != 3 || n10 == 3 && !object3.hasMoreElements()) {
                this.checkVibrabombs(entity, coords2, false, coords, coords2);
                if (this.game.containsMinefield(coords2)) {
                    Enumeration enumeration = this.game.getMinefields(coords2).elements();
                    while (enumeration.hasMoreElements()) {
                        Minefield minefield = (Minefield)enumeration.nextElement();
                        boolean bl13 = !object3.hasMoreElements();
                        bl13 |= moveStep.getMovementType() != 3;
                        boolean bl11 = moveStep.getElevation() == 0;
                        entity.setPosition(coords2);
                        if (bl13 &= bl11) {
                            this.enterMinefield(entity, minefield, coords2, coords2, true);
                        } else if (minefield.getType() == 5) {
                            this.enterMinefield(entity, minefield, coords2, coords2, true, 2);
                        }
                        entity.setPosition(coords);
                    }
                }
            }
            if (!coords.equals(coords2) && !object3.hasMoreElements() && bl2 && this.game.containsMinefield(coords2)) {
                Player player = entity.getOwner();
                Enumeration enumeration = this.game.getMinefields(coords2).elements();
                while (enumeration.hasMoreElements()) {
                    Minefield minefield = (Minefield)enumeration.nextElement();
                    if (player.containsMinefield(minefield)) continue;
                    report = new Report(2120);
                    report.subject = entity.getId();
                    report.add(entity.getShortName(), true);
                    this.addReport(report);
                    this.revealMinefield(player, minefield);
                }
            }
            if ((pilotingRollData = entity.checkWaterMove(moveStep, (IHex)object, coords, coords2, bl8)).getValue() != -2147483647) {
                int n31 = entity.getSwarmAttackerId();
                boolean bl15 = true;
                Entity entity6 = null;
                if (-1 != n31) {
                    entity6 = this.game.getEntity(n31);
                    bl15 = entity6.isDone();
                }
                this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, true);
                if (object.terrainLevel(4) > 1) {
                    this.drownSwarmer(entity, coords2);
                }
                if (!bl15 && (entity6.isDoomed() || entity6.isDestroyed())) {
                    entity6.setDone(false);
                    entity6.setUnloaded(false);
                    this.game.removeTurnFor(entity6);
                    this.send(this.createTurnVectorPacket());
                    entity6.setDone(true);
                    entity6.setUnloaded(true);
                }
                this.checkForWashedInfernos(entity, coords2);
            }
            this.doSetLocationsExposure(entity, (IHex)object, moveStep.getMovementType() == 3, moveStep.getElevation());
            if (object4 != null && serializable != null && ((MoveStep)serializable).getElevation() < 0 && moveStep.getElevation() == 0 && object4.containsTerrain(20) && object4.containsTerrain(4) && moveStep.getMovementType() != 3 && !coords.equals(coords2)) {
                report = new Report(2410);
                report.addDesc(entity);
                this.addReport(report);
                this.resolveIceBroken(coords);
            }
            if (object.containsTerrain(20) && object.containsTerrain(4) && moveStep.getMovementType() != 3 && !coords.equals(coords2)) {
                if (moveStep.getElevation() == 0) {
                    int n32 = Compute.d6(1);
                    report = new Report(2118);
                    report.addDesc(entity);
                    report.add(n32);
                    report.subject = entity.getId();
                    this.addReport(report);
                    if (n32 == 6) {
                        this.resolveIceBroken(coords2);
                        this.doEntityFallsInto(entity, coords, coords2, entity.getBasePilotingRoll(), false);
                    }
                } else if (moveStep.getElevation() + entity.height() == 0) {
                    report = new Report(2410);
                    report.addDesc(entity);
                    this.addReport(report);
                    this.resolveIceBroken(coords2);
                }
            }
            if (moveStep.getType() == 16) {
                Entity entity7 = null;
                Enumeration enumeration = this.game.getEntities(coords2);
                while (enumeration.hasMoreElements()) {
                    entity7 = (Entity)enumeration.nextElement();
                    if (!entity.isEnemyOf(entity7) && !entity.equals(entity7)) {
                        if (!entity.canLoad(entity7) || !entity7.isLoadableThisTurn()) {
                            System.err.println(new StringBuffer().append(entity.getShortName()).append(" can not load ").append(entity7.getShortName()).toString());
                            entity7 = null;
                            continue;
                        }
                        this.loadUnit(entity, entity7);
                        break;
                    }
                    entity7 = null;
                }
                if (entity7 == null) {
                    System.err.println(new StringBuffer().append("Could not find unit for ").append(entity.getShortName()).append(" to load in ").append(coords2).toString());
                }
            }
            if (moveStep.getType() == 17 && !this.unloadUnit(entity, targetable = moveStep.getTarget(this.game), coords2, n5, moveStep.getElevation())) {
                System.err.println(new StringBuffer().append("Error! Server was told to unload ").append(targetable.getDisplayName()).append(" from ").append(entity.getDisplayName()).append(" into ").append(coords2.getBoardNum()).toString());
            }
            if (n14 > 0) {
                Building building = null;
                if ((n14 & 1) == 1) {
                    building = this.game.getBoard().getBuildingAt(coords);
                }
                Building building3 = null;
                if ((n14 & 2) == 2) {
                    building3 = this.game.getBoard().getBuildingAt(coords2);
                }
                Building building4 = null;
                if ((n14 & 4) == 4) {
                    building4 = this.game.getBoard().getBuildingAt(coords2);
                }
                boolean bl6 = false;
                if (building3 != null || building != null) {
                    if (building == null) {
                        bl6 = this.passBuildingWall(entity, building3, coords, coords2, n7, "entering");
                        this.addAffectedBldg(building3, bl6);
                    } else if (building.equals(building3)) {
                        bl6 = this.passBuildingWall(entity, building3, coords, coords2, n7, "moving in");
                        this.addAffectedBldg(building3, bl6);
                    } else if (building != null && building3 != null) {
                        bl6 = this.passBuildingWall(entity, building, coords, coords2, n7, "exiting");
                        this.addAffectedBldg(building, bl6);
                        bl6 = this.passBuildingWall(entity, building3, coords, coords2, n7, "entering");
                        this.addAffectedBldg(building3, bl6);
                    } else if (building != null) {
                        bl6 = this.passBuildingWall(entity, building, coords, coords2, n7, "exiting");
                        this.addAffectedBldg(building, bl6);
                    }
                }
                if (building4 != null) {
                    bl6 = this.checkBuildingCollapseWhileMoving(building4, entity, coords2);
                    this.addAffectedBldg(building4, bl6);
                }
                if (entity.isDoomed()) {
                    entity.setDestroyed(true);
                    this.game.moveToGraveyard(entity.getId());
                    this.send(this.createRemoveEntityPacket(entity.getId()));
                    return;
                }
            }
            if (!bl7 && entity.isProne()) {
                n5 = entity.getFacing();
                coords2 = entity.getPosition();
                n8 = moveStep.getMpUsed();
                bl4 = true;
                break;
            }
            if (moveStep.getType() == 6) {
                n8 = moveStep.getMpUsed();
                pilotingRollData = entity.checkDislodgeSwarmers(moveStep);
                if (pilotingRollData.getValue() == -2147483647) {
                    entity.setProne(true);
                    this.checkForWashedInfernos(entity, coords2);
                    break;
                }
                entity.setPosition(coords2);
                if (this.doDislodgeSwarmerSkillCheck(entity, pilotingRollData, coords2)) {
                    n5 = entity.getFacing();
                    coords2 = entity.getPosition();
                    bl4 = true;
                    break;
                }
            }
            if (moveStep.getType() == 24) {
                n8 = moveStep.getMpUsed();
                entity.setHullDown(true);
            }
            vector.addElement(new UnitLocation(entity.getId(), coords2, n5));
            coords = new Coords(coords2);
            serializable = moveStep;
            if (!object.equals(object4)) {
                n11 = n5;
            }
            object4 = object;
            bl3 = false;
        }
        entity.setPosition(coords2);
        entity.setFacing(n5);
        entity.setSecondaryFacing(n5);
        entity.delta_distance = n7;
        entity.moved = n9;
        entity.mpUsed = n8;
        if (!bl && !bl4) {
            entity.setElevation(n6);
        }
        entity.setClimbMode(movePath.getFinalClimbMode());
        pilotingRollData = entity.checkRunningWithDamage(n10);
        if (pilotingRollData.getValue() != -2147483647) {
            this.doSkillCheckInPlace(entity, pilotingRollData);
        }
        if (n10 == 3 && !entity.isMakingDfa()) {
            int n33;
            object3 = this.game.getBoard().getHex(coords2);
            pilotingRollData = entity.checkLandingWithDamage();
            if (pilotingRollData.getValue() != -2147483647) {
                this.doSkillCheckInPlace(entity, pilotingRollData);
            }
            n = object3.terrainLevel(4);
            if (object3.containsTerrain(20) && n > 0) {
                n = 0;
                int n34 = Compute.d6(1);
                report = new Report(2122);
                report.add(entity.getDisplayName(), true);
                report.add(n34);
                report.subject = entity.getId();
                this.addReport(report);
                if (n34 >= 4) {
                    this.resolveIceBroken(coords2);
                    this.doEntityFallsInto(entity, coords, coords2, entity.getBasePilotingRoll(), false);
                }
            }
            if ((pilotingRollData = entity.checkWaterMove(n)).getValue() != -2147483647) {
                this.doSkillCheckInPlace(entity, pilotingRollData);
            }
            if (n > 1) {
                this.drownSwarmer(entity, coords2);
            }
            if ((object2 = this.game.getBoard().getBuildingAt(coords2)) != null) {
                this.checkForCollapse((Building)object2, this.game.getPositionMap());
            }
            if (object3.terrainLevel(24) == 1) {
                int n35 = Compute.d6(1);
                report = new Report(2395);
                report.addDesc(entity);
                report.add(n35);
                report.subject = entity.getId();
                this.addReport(report);
                if (n35 == 6) {
                    object3.removeTerrain(24);
                    object3.addTerrain(Terrains.getTerrainFactory().createTerrain(24, 2));
                    this.sendChangedHex(coords2);
                    Enumeration enumeration = this.game.getEntities(coords2);
                    while (enumeration.hasMoreElements()) {
                        object = (Entity)enumeration.nextElement();
                        if (object == entity) continue;
                        this.doMagmaDamage((Entity)object, false);
                    }
                }
            }
            if (object3.terrainLevel(24) == 2) {
                this.doMagmaDamage(entity, false);
            }
            if (object3.containsTerrain(9) || object3.containsTerrain(24) || object3.containsTerrain(28) || object3.containsTerrain(25) || object3.containsTerrain(29)) {
                if (entity instanceof Mech) {
                    entity.setStuck(true);
                    report = new Report(2121);
                    report.add(entity.getDisplayName(), true);
                    report.subject = entity.getId();
                    this.addReport(report);
                } else if (entity instanceof Infantry) {
                    PilotingRollData pilotingRollData2 = entity.getBasePilotingRoll();
                    pilotingRollData2.addModifier(5, "infantry jumping into swamp");
                    if (!this.doSkillCheckWhileMoving(entity, coords2, coords2, pilotingRollData2, false)) {
                        entity.setStuck(true);
                        report = new Report(2081);
                        report.add(entity.getDisplayName());
                        report.subject = entity.getId();
                        this.addReport(report);
                    }
                }
            }
            if (-1 != (n33 = entity.getSwarmAttackerId())) {
                Entity entity8 = this.game.getEntity(n33);
                object = entity.getBasePilotingRoll();
                entity.addPilotingModifierForTerrain((PilotingRollData)object);
                ((TargetRoll)object).addModifier(4, "dislodge swarming infantry");
                for (Mounted mounted : entity8.getMisc()) {
                    EquipmentType equipmentType = mounted.getType();
                    if (!"BA-Assault Claws".equals(equipmentType.getInternalName())) continue;
                    ((TargetRoll)object).addModifier(1, "swarmer has assault claws");
                    break;
                }
                report = new Report(2125);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
                int n36 = Compute.d6(2);
                report = new Report(2130);
                report.subject = entity.getId();
                report.add(((TargetRoll)object).getValueAsString());
                report.add(((TargetRoll)object).getDesc());
                report.add(n36);
                if (n36 < ((TargetRoll)object).getValue()) {
                    report.choose(false);
                    this.addReport(report);
                } else {
                    this.game.removeTurnFor(entity8);
                    this.send(this.createTurnVectorPacket());
                    report.choose(true);
                    this.addReport(report);
                    entity.setSwarmAttackerId(-1);
                    entity8.setSwarmTargetId(-1);
                    if (object3.terrainLevel(4) > 0) {
                        entity8.setPosition(coords2);
                        report = new Report(2135);
                        report.subject = entity.getId();
                        report.indent();
                        report.addDesc(entity8);
                        this.addReport(report);
                        this.addReport(this.destroyEntity(entity8, "a watery grave", false));
                    } else {
                        report = new Report(2140);
                        report.subject = entity.getId();
                        report.indent();
                        report.addDesc(entity8);
                        this.addReport(report);
                        this.addReport(this.damageEntity(entity8, entity8.rollHitLocation(0, 0), 11));
                        this.addNewLines();
                        entity8.setPosition(coords2);
                    }
                    this.entityUpdate(n33);
                }
            }
            this.checkForWashedInfernos(entity, coords2);
        }
        this.doSetLocationsExposure(entity, this.game.getBoard().getHex(coords2), false, entity.getElevation());
        if (!this.game.getOptions().booleanOption("falls_end_movement") && bl4 && !bl5 && entity.mpUsed < entity.getRunMP() && entity.isSelectableThisTurn() && !entity.isDoomed()) {
            entity.applyDamage();
            entity.setDone(false);
            object3 = new GameTurn.SpecificEntityTurn(entity.getOwner().getId(), entity.getId());
            this.game.insertNextTurn((GameTurn)object3);
            this.send(this.createTurnVectorPacket());
            this.send(entity.getOwner().getId(), this.createSpecialReportPacket());
        } else {
            entity.setDone(true);
        }
        int n37 = entity.getSwarmAttackerId();
        if (-1 != n37) {
            Entity entity9 = this.game.getEntity(n37);
            entity9.setPosition(coords2);
            if (!(entity9 instanceof BattleArmor) && this.game.getBoard().getHex(coords2).containsTerrain(7)) {
                entity9.setSwarmTargetId(-1);
                entity.setSwarmAttackerId(-1);
                report = new Report(2145);
                report.subject = entity.getId();
                report.indent();
                report.add(entity9.getShortName(), true);
                this.addReport(report);
            }
            this.entityUpdate(n37);
        }
        if (!this.game.isOutOfGame(entity)) {
            this.entityUpdate(entity.getId(), vector);
            if (entity.isDoomed()) {
                this.send(this.createRemoveEntityPacket(entity.getId(), entity.getRemovalCondition()));
            }
        }
        if (this.doBlind()) {
            this.send(entity.getOwner().getId(), this.createFilteredEntitiesPacket(entity.getOwner()));
        }
        if (object5 != null) {
            this.send(this.createAttackPacket((EntityAction)object5, 1));
        }
    }

    private void deliverThunderAugMinefield(Coords coords, int n, int n2) {
        Coords coords2 = null;
        for (int i = 0; i < 7; ++i) {
            switch (i) {
                case 6: {
                    coords2 = new Coords(coords);
                    break;
                }
                default: {
                    coords2 = coords.translated(i);
                }
            }
            if (!this.game.getBoard().contains(coords2)) continue;
            Minefield minefield = null;
            Enumeration enumeration = this.game.getMinefields(coords2).elements();
            while (enumeration.hasMoreElements()) {
                Minefield minefield2 = (Minefield)enumeration.nextElement();
                if (minefield2.getType() != 3) continue;
                minefield = minefield2;
                break;
            }
            if (minefield == null) {
                minefield = Minefield.createThunderMF(coords2, n, n2 / 2 + n2 % 2);
                this.game.addMinefield(minefield);
                this.revealMinefield(minefield);
                continue;
            }
            if (minefield.getDamage() >= 20) continue;
            this.removeMinefield(minefield);
            int n3 = n2 / 2 + n2 % 2;
            if ((n3 += minefield.getDamage()) > 20) {
                n3 = 20;
            }
            minefield.setDamage(n3);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverThunderMinefield(Coords coords, int n, int n2) {
        Minefield minefield = null;
        Enumeration enumeration = this.game.getMinefields(coords).elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = (Minefield)enumeration.nextElement();
            if (minefield2.getType() != 3) continue;
            minefield = minefield2;
            break;
        }
        if (minefield == null) {
            minefield = Minefield.createThunderMF(coords, n, n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        } else if (minefield.getDamage() < 20) {
            this.removeMinefield(minefield);
            int n3 = minefield.getDamage();
            n2 = (n2 += n3) > 20 ? 20 : n2;
            minefield.setDamage(n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverThunderInfernoMinefield(Coords coords, int n, int n2) {
        Minefield minefield = null;
        Enumeration enumeration = this.game.getMinefields(coords).elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = (Minefield)enumeration.nextElement();
            if (minefield2.getType() != 4) continue;
            minefield = minefield2;
            break;
        }
        if (minefield == null) {
            minefield = Minefield.createThunderInfernoMF(coords, n, n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        } else if (minefield.getDamage() < 20) {
            this.removeMinefield(minefield);
            int n3 = minefield.getDamage();
            n2 = (n2 += n3) > 20 ? 20 : n2;
            minefield.setDamage(n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverFASCAMMinefield(Coords coords, int n) {
        if (this.game.getBoard().contains(coords)) {
            Minefield minefield = null;
            Enumeration enumeration = this.game.getMinefields(coords).elements();
            while (enumeration.hasMoreElements()) {
                Minefield minefield2 = (Minefield)enumeration.nextElement();
                if (minefield2.getType() != 3) continue;
                minefield = minefield2;
                break;
            }
            if (minefield == null) {
                minefield = Minefield.createThunderMF(coords, n, 30);
            }
            this.removeMinefield(minefield);
            minefield.setDamage(30);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverThunderActiveMinefield(Coords coords, int n, int n2) {
        Minefield minefield = null;
        Enumeration enumeration = this.game.getMinefields(coords).elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = (Minefield)enumeration.nextElement();
            if (minefield2.getType() != 5) continue;
            minefield = minefield2;
            break;
        }
        if (minefield == null) {
            minefield = Minefield.createThunderActiveMF(coords, n, n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        } else if (minefield.getDamage() < 20) {
            this.removeMinefield(minefield);
            int n3 = minefield.getDamage();
            n2 = (n2 += n3) > 20 ? 20 : n2;
            minefield.setDamage(n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverThunderVibraMinefield(Coords coords, int n, int n2, int n3) {
        Minefield minefield = null;
        Enumeration enumeration = this.game.getMinefields(coords).elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = (Minefield)enumeration.nextElement();
            if (minefield2.getType() != 6) continue;
            minefield = minefield2;
            break;
        }
        if (minefield == null) {
            minefield = Minefield.createThunderVibrabombMF(coords, n, n2, n3);
            this.game.addVibrabomb(minefield);
            this.revealMinefield(minefield);
        } else if (minefield.getDamage() < 20) {
            this.removeMinefield(minefield);
            int n4 = minefield.getDamage();
            n2 = (n2 += n4) > 20 ? 20 : n2;
            minefield.setDamage(n2);
            this.game.addVibrabomb(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverFlare(Coords coords, int n) {
        Flare flare = new Flare(coords, Math.max(1, n / 5), 3, 0);
        this.game.addFlare(flare);
    }

    private void deliverArtilleryFlare(Coords coords, int n) {
        Flare flare = new Flare(coords, 12, n, Flare.F_DRIFTING);
        this.game.addFlare(flare);
    }

    private void deliverArtillerySmoke(Coords coords) {
        IHex iHex;
        if (this.game.getOptions().booleanOption("maxtech_fire") && (iHex = this.game.getBoard().getHex(coords)).terrainLevel(8) < 2) {
            Report report = new Report(5185, 0);
            report.indent(2);
            report.add(coords.getBoardNum());
            this.addReport(report);
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, 2));
            this.sendChangedHex(coords);
        }
    }

    private void deliverArtilleryInferno(Coords coords, int n) {
        Serializable serializable;
        Report report;
        IHex iHex = this.game.getBoard().getHex(coords);
        if (!iHex.containsTerrain(7)) {
            report = new Report(3005);
            report.subject = n;
            report.indent(2);
            report.add(coords.getBoardNum());
            this.addReport(report);
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
        }
        this.game.getBoard().addInfernoTo(coords, InfernoTracker.INFERNO_IV_ROUND, 1);
        this.sendChangedHex(coords);
        Enumeration enumeration = this.game.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            serializable = (Entity)enumeration.nextElement();
            ((Entity)serializable).infernos.add(InfernoTracker.INFERNO_IV_ROUND, 1);
            report = new Report(3205);
            report.indent(2);
            report.subject = ((Entity)serializable).getId();
            report.addDesc((Entity)serializable);
            report.add(((Entity)serializable).infernos.getTurnsLeftToBurn());
            this.addReport(report);
        }
        for (int i = 0; i <= 5; ++i) {
            serializable = coords.translated(i);
            if (!this.game.getBoard().contains((Coords)serializable) || coords.equals(serializable)) continue;
            iHex = this.game.getBoard().getHex((Coords)serializable);
            if (!iHex.containsTerrain(7)) {
                report = new Report(3005);
                report.subject = n;
                report.indent(2);
                report.add(((Coords)serializable).getBoardNum());
                this.addReport(report);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
            }
            this.game.getBoard().addInfernoTo((Coords)serializable, InfernoTracker.INFERNO_IV_ROUND, 1);
            this.sendChangedHex((Coords)serializable);
            Enumeration enumeration2 = this.game.getEntities((Coords)serializable);
            while (enumeration2.hasMoreElements()) {
                Entity entity = (Entity)enumeration2.nextElement();
                entity.infernos.add(InfernoTracker.INFERNO_IV_ROUND, 1);
                report = new Report(3205);
                report.indent(2);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(entity.infernos.getTurnsLeftToBurn());
                this.addReport(report);
            }
        }
    }

    private void enterMinefield(Entity entity, Minefield minefield, Coords coords, Coords coords2, boolean bl) {
        this.enterMinefield(entity, minefield, coords, coords2, bl, 0);
    }

    private void enterMinefield(Entity entity, Minefield minefield, Coords coords, Coords coords2, boolean bl, int n) {
        if (!this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(4) || this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(5) || this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(20)) {
            switch (minefield.getType()) {
                case 0: 
                case 3: 
                case 5: {
                    if (minefield.getTrigger() != 0 && Compute.d6(2) < minefield.getTrigger() + n) {
                        return;
                    }
                    Report report = new Report(2150);
                    report.subject = entity.getId();
                    report.add(entity.getShortName(), true);
                    report.add(minefield.getCoords().getBoardNum(), true);
                    this.addReport(report);
                    HitData hitData = entity.rollHitLocation(2, 0);
                    this.addReport(this.damageEntity(entity, hitData, minefield.getDamage()));
                    this.addNewLines();
                    if (bl) {
                        this.resolvePilotingRolls(entity, true, coords, coords2);
                    }
                    if (!minefield.isOneUse()) {
                        this.revealMinefield(minefield);
                        break;
                    }
                    this.removeMinefield(minefield);
                    break;
                }
                case 4: {
                    if (minefield.getTrigger() != 0 && Compute.d6(2) < minefield.getTrigger() + n) {
                        return;
                    }
                    entity.infernos.add(InfernoTracker.STANDARD_ROUND, minefield.getDamage());
                    Report report = new Report(2155);
                    report.subject = entity.getId();
                    report.add(entity.getShortName(), true);
                    report.add(minefield.getCoords().getBoardNum(), true);
                    report.addDesc(entity);
                    report.add(entity.infernos.getTurnsLeftToBurn());
                    this.addReport(report);
                    IHex iHex = this.game.getBoard().getHex(coords2);
                    if (!iHex.containsTerrain(7)) {
                        report = new Report(3005);
                        report.subject = entity.getId();
                        report.add(coords2.getBoardNum(), true);
                        this.addReport(report);
                        iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                    }
                    this.game.getBoard().addInfernoTo(coords2, InfernoTracker.STANDARD_ROUND, 1);
                    this.sendChangedHex(coords2);
                }
            }
        }
    }

    private void checkVibrabombs(Entity entity, Coords coords, boolean bl) {
        this.checkVibrabombs(entity, coords, bl, null, null);
    }

    private void checkVibrabombs(Entity entity, Coords coords, boolean bl, Coords coords2, Coords coords3) {
        if (!(entity instanceof Mech)) {
            return;
        }
        int n = (int)entity.getWeight();
        Enumeration enumeration = this.game.getVibrabombs().elements();
        while (enumeration.hasMoreElements()) {
            Report report;
            Minefield minefield = (Minefield)enumeration.nextElement();
            if (this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(4) && !this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(5) && !this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(20) || n <= minefield.getSetting() - 10) continue;
            int n2 = (n - minefield.getSetting()) / 10;
            int n3 = coords.distance(minefield.getCoords());
            if (n3 <= n2) {
                report = new Report(2156);
                report.subject = entity.getId();
                report.add(entity.getShortName(), true);
                report.add(minefield.getCoords().getBoardNum(), true);
                this.addReport(report);
                this.explodeVibrabomb(minefield);
            }
            if (bl || n3 != 0) continue;
            report = new Report(2160);
            report.subject = entity.getId();
            report.add(entity.getShortName(), true);
            this.addReport(report);
            HitData hitData = entity.rollHitLocation(2, 0);
            this.addReport(this.damageEntity(entity, hitData, minefield.getDamage()));
            this.addNewLines();
            this.resolvePilotingRolls(entity, true, coords2, coords3);
            entity.applyDamage();
        }
    }

    private void removeMinefieldsFrom(Coords coords) {
        Vector vector = this.game.getMinefields(coords);
        while (vector.elements().hasMoreElements()) {
            Minefield minefield = (Minefield)vector.elements().nextElement();
            this.removeMinefield(minefield);
        }
    }

    private void removeMinefield(Minefield minefield) {
        if (this.game.containsVibrabomb(minefield)) {
            this.game.removeVibrabomb(minefield);
        }
        this.game.removeMinefield(minefield);
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            this.removeMinefield(player, minefield);
        }
    }

    private void removeMinefield(Player player, Minefield minefield) {
        if (player.containsMinefield(minefield)) {
            player.removeMinefield(minefield);
            this.send(player.getId(), new Packet(410, minefield));
        }
    }

    private void revealMinefield(Minefield minefield) {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            this.revealMinefield(player, minefield);
        }
    }

    private void revealMinefield(Player player, Minefield minefield) {
        if (!player.containsMinefield(minefield)) {
            player.addMinefield(minefield);
            this.send(player.getId(), new Packet(400, minefield));
        }
    }

    private void explodeVibrabomb(Minefield minefield) {
        Enumeration enumeration = this.game.getEntities(minefield.getCoords());
        while (enumeration.hasMoreElements()) {
            Report report;
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.isDone() && this.game.getOptions().booleanOption("no_premove_vibra")) {
                report = new Report(2157);
                report.subject = entity.getId();
                report.add(entity.getShortName(), true);
                this.addReport(report);
                continue;
            }
            report = new Report(2160);
            report.subject = entity.getId();
            report.add(entity.getShortName(), true);
            this.addReport(report);
            if (minefield.getType() == 2) {
                HitData hitData = entity.rollHitLocation(2, 0);
                this.addReport(this.damageEntity(entity, hitData, minefield.getDamage()));
                this.addNewLines();
            } else if (minefield.getType() == 6) {
                int n = minefield.getDamage();
                HitData hitData = entity.rollHitLocation(2, 0);
                this.addReport(this.damageEntity(entity, hitData, n));
            }
            this.resolvePilotingRolls(entity, true, entity.getPosition(), entity.getPosition());
            this.game.resetPSRs(entity);
            entity.applyDamage();
            this.addNewLines();
            this.entityUpdate(entity.getId());
        }
        if (!minefield.isOneUse()) {
            this.revealMinefield(minefield);
        } else {
            this.removeMinefield(minefield);
        }
    }

    private void drownSwarmer(Entity entity, Coords coords) {
        Entity entity2;
        int n = entity.getSwarmAttackerId();
        if (-1 != n && !((entity2 = this.game.getEntity(n)) instanceof BattleArmor)) {
            entity2.setSwarmTargetId(-1);
            entity.setSwarmAttackerId(-1);
            entity2.setPosition(coords);
            Report report = new Report(2165);
            report.subject = entity.getId();
            report.indent();
            report.add(entity.getShortName(), true);
            this.addReport(report);
            this.addReport(this.destroyEntity(entity2, "a watery grave", false));
            this.entityUpdate(n);
        }
    }

    void checkForWashedInfernos(Entity entity, Coords coords) {
        IHex iHex = this.game.getBoard().getHex(coords);
        int n = iHex.terrainLevel(4);
        if (!(entity instanceof Mech) || !entity.infernos.isStillBurning()) {
            return;
        }
        if (n > 0 && entity.absHeight() < 0) {
            this.washInferno(entity, coords);
        }
    }

    void washInferno(Entity entity, Coords coords) {
        this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, 1);
        entity.infernos.clear();
        IHex iHex = this.game.getBoard().getHex(coords);
        Report report = new Report(2170);
        report.subject = entity.getId();
        report.addDesc(entity);
        if (!iHex.containsTerrain(7)) {
            report.messageId = 2175;
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
        }
        this.addReport(report);
        this.sendChangedHex(coords);
    }

    public void addMovementHeat() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.getMovementMode() == 13 || entity.getMovementMode() == 14) {
                return;
            }
            if (entity.moved == 0) {
                entity.heatBuildup += entity.getStandingHeat();
                continue;
            }
            if (entity.moved == 1 || entity.moved == 4) {
                entity.heatBuildup += entity.getWalkHeat();
                continue;
            }
            if (entity.moved == 2 || entity.moved == 5 || entity.moved == -2) {
                entity.heatBuildup += entity.getRunHeat();
                continue;
            }
            if (entity.moved != 3) continue;
            entity.heatBuildup += entity.getJumpHeat(entity.delta_distance);
        }
    }

    public void doSetLocationsExposure(Entity entity, IHex iHex, boolean bl, int n) {
        block7: {
            block5: {
                block6: {
                    if (iHex.terrainLevel(4) <= 0 || bl || n >= 0) break block5;
                    if (!(entity instanceof Mech) || entity.isProne() || iHex.terrainLevel(4) != 1) break block6;
                    for (int i = 0; i < entity.locations(); ++i) {
                        if (this.game.getOptions().booleanOption("vacuum")) {
                            entity.setLocationStatus(i, 1);
                            continue;
                        }
                        entity.setLocationStatus(i, 0);
                    }
                    entity.setLocationStatus(6, 2);
                    entity.setLocationStatus(7, 2);
                    this.addReport(this.breachCheck(entity, 6, iHex));
                    this.addReport(this.breachCheck(entity, 7, iHex));
                    if (!(entity instanceof QuadMech)) break block7;
                    entity.setLocationStatus(4, 2);
                    entity.setLocationStatus(5, 2);
                    this.addReport(this.breachCheck(entity, 4, iHex));
                    this.addReport(this.breachCheck(entity, 5, iHex));
                    break block7;
                }
                for (int i = 0; i < entity.locations(); ++i) {
                    entity.setLocationStatus(i, 2);
                    this.addReport(this.breachCheck(entity, i, iHex));
                }
                break block7;
            }
            for (int i = 0; i < entity.locations(); ++i) {
                if (this.game.getOptions().booleanOption("vacuum")) {
                    entity.setLocationStatus(i, 1);
                    continue;
                }
                entity.setLocationStatus(i, 0);
            }
        }
    }

    private boolean doSkillCheckInPlace(Entity entity, PilotingRollData pilotingRollData) {
        boolean bl;
        if (pilotingRollData.getValue() == Integer.MIN_VALUE) {
            return true;
        }
        if (!(entity instanceof Mech) || entity.isProne()) {
            return true;
        }
        Report report = new Report(2180);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(pilotingRollData.getLastPlainDesc(), true);
        this.addReport(report);
        int n = Compute.d6(2);
        report = new Report(2185);
        report.subject = entity.getId();
        report.add(pilotingRollData.getValueAsString());
        report.add(pilotingRollData.getDesc());
        report.add(n);
        if (n < pilotingRollData.getValue()) {
            report.choose(false);
            this.addReport(report);
            this.doEntityFall(entity, pilotingRollData);
            bl = false;
        } else {
            report.choose(true);
            this.addReport(report);
            bl = true;
        }
        return bl;
    }

    private boolean doDislodgeSwarmerSkillCheck(Entity entity, PilotingRollData pilotingRollData, Coords coords) {
        Report report = new Report(2180);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(pilotingRollData.getLastPlainDesc(), true);
        this.addReport(report);
        int n = Compute.d6(2);
        report = new Report(2190);
        report.subject = entity.getId();
        report.add(pilotingRollData.getValueAsString());
        report.add(pilotingRollData.getDesc());
        report.add(n);
        if (n < pilotingRollData.getValue()) {
            report.choose(false);
            this.addReport(report);
            return false;
        }
        int n2 = entity.getSwarmAttackerId();
        Entity entity2 = this.game.getEntity(n2);
        this.game.removeTurnFor(entity2);
        this.send(this.createTurnVectorPacket());
        report.choose(true);
        this.addReport(report);
        entity.setPosition(coords);
        this.doEntityFallsInto(entity, coords, coords, pilotingRollData, false);
        return true;
    }

    private boolean doSkillCheckWhileMoving(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData, boolean bl) {
        boolean bl2;
        boolean bl3 = true;
        Report report = new Report(1210);
        report.subject = entity.getId();
        report.addDesc(entity);
        if (coords.equals(coords2)) {
            bl2 = true;
            report.messageId = 2195;
            report.add(coords.getBoardNum(), true);
        } else {
            bl2 = false;
            report.messageId = 2200;
            report.add(coords.getBoardNum(), true);
            report.add(coords2.getBoardNum(), true);
        }
        report.add(pilotingRollData.getLastPlainDesc(), true);
        this.addReport(report);
        int n = Compute.d6(2);
        report = new Report(2185);
        report.subject = entity.getId();
        report.add(pilotingRollData.getValueAsString());
        report.add(pilotingRollData.getDesc());
        report.add(n);
        if (n < pilotingRollData.getValue()) {
            if (bl) {
                report.choose(false);
                this.addReport(report);
                this.doEntityFallsInto(entity, bl2 ? coords2 : coords, bl2 ? coords : coords2, pilotingRollData);
            } else {
                report.messageId = 2190;
                report.choose(false);
                this.addReport(report);
                entity.setPosition(bl2 ? coords : coords2);
            }
            bl3 = false;
        } else {
            report.choose(true);
            this.addReport(report);
        }
        return bl3;
    }

    private void doEntityFallsInto(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData) {
        this.doEntityFallsInto(entity, coords, coords2, pilotingRollData, true);
    }

    private void doEntityFallsInto(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData, boolean bl) {
        IHex iHex = this.game.getBoard().getHex(coords);
        IHex iHex2 = this.game.getBoard().getHex(coords2);
        int n = entity.getElevation() + iHex.depth();
        int n2 = Math.max(0, iHex.floor() + n - iHex2.floor());
        int n3 = coords.equals(coords2) ? Compute.d6() - 1 : coords.direction(coords2);
        Entity entity2 = this.game.getAffaTarget(coords2, entity);
        Report report = new Report(2205);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(n2);
        report.add(coords2.getBoardNum(), true);
        report.newlines = 0;
        this.addReport(report);
        if (entity2 == null) {
            this.doEntityFall(entity, coords2, n2, pilotingRollData);
            return;
        }
        if (n2 >= 2 && bl && entity2 != null) {
            report = new Report(2210);
            report.subject = entity.getId();
            report.addDesc(entity2);
            this.addReport(report);
            ToHitData toHitData = new ToHitData(7, "base");
            if (entity2 instanceof Tank) {
                toHitData = new ToHitData(Integer.MIN_VALUE, "Target is a Tank");
            } else {
                toHitData.append(Compute.getTargetMovementModifier(this.game, entity2.getId()));
                toHitData.append(Compute.getTargetTerrainModifier(this.game, entity2));
            }
            if (toHitData.getValue() != 0x7FFFFFFE) {
                int n4 = Compute.d6(2);
                if (toHitData.getValue() == Integer.MIN_VALUE) {
                    report = new Report(2212);
                    report.add(toHitData.getValue());
                    report.indent();
                } else {
                    report = new Report(2215);
                    report.subject = entity.getId();
                    report.add(toHitData.getValue());
                    report.add(n4);
                    report.newlines = 0;
                    report.indent();
                }
                this.addReport(report);
                if (n4 >= toHitData.getValue()) {
                    Object object;
                    int n5;
                    int n6;
                    report = new Report(2220);
                    report.subject = entity2.getId();
                    report.addDesc(entity2);
                    report.add(n6);
                    this.addReport(report);
                    for (n6 = Compute.getAffaDamageFor(entity); n6 > 0; n6 -= n5) {
                        n5 = Math.min(5, n6);
                        object = entity2.rollHitLocation(1, 0);
                        this.addReport(this.damageEntity(entity2, (HitData)object, n5));
                    }
                    this.addNewLines();
                    PilotingRollData pilotingRollData2 = entity.getBasePilotingRoll();
                    pilotingRollData2.append(pilotingRollData);
                    entity.addPilotingModifierForTerrain(pilotingRollData2, coords2);
                    this.doEntityFall(entity, coords2, n2, 3, pilotingRollData2);
                    this.doEntityDisplacementMinefieldCheck(entity, coords, coords2);
                    object = Compute.stackingViolation(this.game, entity.getId(), coords2);
                    if (object != null) {
                        Coords coords3 = Compute.getValidDisplacement(this.game, ((Entity)object).getId(), coords2, n3);
                        if (coords3 != null) {
                            this.doEntityDisplacement(entity2, coords2, coords3, new PilotingRollData(((Entity)object).getId(), 2, "fallen on"));
                            this.entityUpdate(entity2.getId());
                        } else {
                            this.addReport(this.destroyEntity(entity2, "impossible displacement", object instanceof Mech, object instanceof Mech));
                        }
                    }
                    return;
                }
            } else {
                report = new Report(2213);
                report.add(toHitData.getDesc());
                this.addReport(report);
            }
            Coords coords4 = Compute.getValidDisplacement(this.game, entity.getId(), coords2, n3);
            if (coords4 != null) {
                this.doEntityFallsInto(entity, coords, coords4, new PilotingRollData(entity.getId(), Integer.MAX_VALUE, "pushed off a cliff"), false);
                this.entityUpdate(entity.getId());
            } else {
                this.addReport(this.destroyEntity(entity, "impossible displacement", entity instanceof Mech, entity instanceof Mech));
            }
        } else {
            this.doEntityFall(entity, coords2, n2, pilotingRollData);
            Entity entity3 = Compute.stackingViolation(this.game, entity.getId(), coords2);
            if (entity3 != null) {
                Coords coords5 = Compute.getValidDisplacement(this.game, entity.getId(), coords2, n3);
                this.doEntityDisplacement(entity3, coords2, coords5, new PilotingRollData(entity3.getId(), 0, "domino effect"));
                this.entityUpdate(entity3.getId());
            }
        }
    }

    private void doEntityDisplacement(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData) {
        if (!this.game.getBoard().contains(coords2)) {
            entity.setPosition(coords2);
            if (!entity.isDoomed()) {
                this.game.removeEntity(entity.getId(), 272);
                this.send(this.createRemoveEntityPacket(entity.getId(), 272));
                Report report = new Report(2230);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
            }
            return;
        }
        IHex iHex = this.game.getBoard().getHex(coords);
        IHex iHex2 = this.game.getBoard().getHex(coords2);
        int n = coords.direction(coords2);
        if (iHex == null || iHex2 == null) {
            System.err.println(new StringBuffer().append("Can not displace ").append(entity.getShortName()).append(" from ").append(coords).append(" to ").append(coords2).append('.').toString());
            return;
        }
        int n2 = entity.elevationOccupied(iHex) - entity.elevationOccupied(iHex2);
        if (n2 > 1) {
            if (pilotingRollData == null) {
                pilotingRollData = entity.getBasePilotingRoll();
            }
            this.doEntityFallsInto(entity, coords, coords2, pilotingRollData);
            return;
        }
        entity.setPosition(coords2);
        entity.setElevation(entity.elevationOccupied(iHex2) - iHex2.surface());
        Entity entity2 = Compute.stackingViolation(this.game, entity.getId(), coords2);
        if (entity2 == null) {
            Report report = new Report(2235);
            report.indent();
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(coords2.getBoardNum(), true);
            this.addReport(report);
        } else {
            Report report = new Report(2240);
            report.indent();
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(coords2.getBoardNum(), true);
            report.addDesc(entity2);
            this.addReport(report);
        }
        this.doEntityDisplacementMinefieldCheck(entity, coords, coords2);
        this.doSetLocationsExposure(entity, iHex2, false, entity.getElevation());
        if (pilotingRollData != null) {
            this.game.addPSR(pilotingRollData);
        }
        this.entityUpdate(entity.getId());
        if (entity2 != null) {
            this.doEntityDisplacement(entity2, coords2, coords2.translated(n), new PilotingRollData(entity2.getId(), 0, "domino effect"));
            if (!this.game.isOutOfGame(entity2)) {
                this.entityUpdate(entity2.getId());
            }
        }
    }

    private void doEntityDisplacementMinefieldCheck(Entity entity, Coords coords, Coords coords2) {
        if (this.game.containsMinefield(coords2)) {
            Enumeration enumeration = this.game.getMinefields(coords2).elements();
            while (enumeration.hasMoreElements()) {
                Minefield minefield = (Minefield)enumeration.nextElement();
                this.enterMinefield(entity, minefield, coords, coords2, false);
            }
        }
        this.checkVibrabombs(entity, coords2, true);
    }

    private void receiveDeployment(Packet packet, int n) {
        int n2;
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        Coords coords = (Coords)packet.getObject(1);
        int n3 = packet.getIntValue(2);
        int n4 = packet.getIntValue(3);
        Vector<Entity> vector = new Vector<Entity>();
        for (n2 = 0; n2 < n4; ++n2) {
            int n5 = packet.getIntValue(5 + n2);
            vector.addElement(this.game.getEntity(n5));
        }
        if (this.game.getPhase() != 4) {
            System.err.println("error: server got deployment packet in wrong phase");
            return;
        }
        n2 = packet.getBooleanValue(4) ? 1 : 0;
        if (!(this.game.getTurn().isValid(n, entity, this.game) && (this.game.getBoard().isLegalDeployment(coords, entity.getOwner()) || n2 != 0 && this.game.getOptions().booleanOption("assault_drop") && entity.canAssaultDrop()))) {
            System.err.println("error: server got invalid deployment packet");
            return;
        }
        this.processDeployment(entity, coords, n3, vector, n2 != 0);
        if (this.doBlind()) {
            this.updateVisibilityIndicator();
        }
        this.endCurrentTurn(entity);
    }

    private void processDeployment(Entity entity, Coords coords, int n, Vector vector, boolean bl) {
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            Entity entity2 = (Entity)object.nextElement();
            if (entity2 == null || entity2.getPosition() != null || entity2.getTransportId() != -1) {
                System.err.println(new StringBuffer().append("error: ").append(entity).append(" can not load entity #").append(entity2).toString());
                break;
            }
            this.loadUnit(entity, entity2);
        }
        entity.setPosition(coords);
        entity.setFacing(n);
        entity.setSecondaryFacing(n);
        object = this.game.getBoard().getHex(coords);
        if (bl) {
            entity.setElevation(object.ceiling() - object.surface() + 100);
            entity.setAssaultDropInProgress(true);
        } else if (entity instanceof VTOL) {
            entity.setElevation(object.ceiling() - object.surface() + 1);
            while (Compute.stackingViolation(this.game, entity, coords, null) != null && entity.getElevation() <= 50) {
                entity.setElevation(entity.getElevation() + 1);
            }
            if (entity.getElevation() > 50) {
                throw new IllegalStateException(new StringBuffer().append("Entity #").append(entity.getId()).append(" appears to be in an infinite loop trying to get a legal elevation.").toString());
            }
        } else if (entity.getMovementMode() == 9) {
            entity.setElevation(0);
        } else if (entity.getMovementMode() == 5 || entity.getMovementMode() == 7 || entity.getMovementMode() == 8) {
            entity.setElevation(0);
        } else if (object.containsTerrain(20) || object.containsTerrain(14)) {
            entity.setElevation(0);
        } else {
            entity.setElevation(object.floor() - object.surface());
        }
        entity.setDone(true);
        entity.setDeployed(true);
        this.entityUpdate(entity.getId());
    }

    private void receiveArtyAutoHitHexes(Packet packet, int n) {
        Vector vector = (Vector)packet.getObject(0);
        Integer n2 = (Integer)vector.firstElement();
        vector.removeElementAt(0);
        if (this.game.getPhase() != 22) {
            System.err.println("error: server got set artyautohithexespacket in wrong phase");
            return;
        }
        this.game.getPlayer(n2).setArtyAutoHitHexes(vector);
        this.endCurrentTurn(null);
    }

    private void receiveDeployMinefields(Packet packet, int n) {
        Vector vector = (Vector)packet.getObject(0);
        if (this.game.getPhase() != 20) {
            System.err.println("error: server got deploy minefields packet in wrong phase");
            return;
        }
        this.processDeployMinefields(vector);
        this.endCurrentTurn(null);
    }

    private void processDeployMinefields(Vector vector) {
        int n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            Minefield minefield = (Minefield)vector.elementAt(i);
            n = minefield.getPlayerId();
            this.game.addMinefield(minefield);
            if (minefield.getType() != 2) continue;
            this.game.addVibrabomb(minefield);
        }
        Player player = this.game.getPlayer(n);
        if (null != player) {
            int n2 = player.getTeam();
            if (n2 != 0) {
                Enumeration enumeration = this.game.getTeams();
                while (enumeration.hasMoreElements()) {
                    Team team = (Team)enumeration.nextElement();
                    if (team.getId() != n2) continue;
                    Enumeration enumeration2 = team.getPlayers();
                    while (enumeration2.hasMoreElements()) {
                        Player player2 = (Player)enumeration2.nextElement();
                        if (player2.getId() != player.getId()) {
                            this.send(player2.getId(), new Packet(390, vector));
                        }
                        player2.addMinefields(vector);
                    }
                    break;
                }
            } else {
                player.addMinefields(vector);
            }
        }
    }

    private void receiveAttack(Packet packet, int n) {
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        Vector vector = (Vector)packet.getObject(1);
        if (this.game.getPhase() != 12 && this.game.getPhase() != 14 && this.game.getPhase() != 7 && this.game.getPhase() != 10) {
            System.err.println("error: server got attack packet in wrong phase");
            return;
        }
        if (!this.game.getTurn().isValid(n, entity, this.game)) {
            System.err.println("error: server got invalid attack packet");
            return;
        }
        this.processAttack(entity, vector);
        if (this.doBlind()) {
            this.updateVisibilityIndicator();
        }
        this.endCurrentTurn(entity);
    }

    private void processAttack(Entity entity, Vector vector) {
        boolean bl = !(this.game.getTurn() instanceof GameTurn.TriggerAPPodTurn);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity2;
            AbstractEntityAction abstractEntityAction;
            Object object;
            EntityAction entityAction = (EntityAction)enumeration.nextElement();
            if (entityAction.getEntityId() != entity.getId()) {
                System.err.println("error: attack packet has wrong attacker");
                continue;
            }
            if (entityAction instanceof WeaponAttackAction && ("SwarmMek".equals(object = entity.getEquipment(((WeaponAttackAction)(abstractEntityAction = (WeaponAttackAction)entityAction)).getWeaponId()).getType().getInternalName()) || "LegAttack".equals(object))) {
                entity2 = this.game.getEntity(((AbstractAttackAction)abstractEntityAction).getTargetId());
                for (Mounted mounted : entity2.getMisc()) {
                    if (!mounted.getType().hasFlag(0x2000000L) || !mounted.canFire()) continue;
                    this.game.insertNextTurn(new GameTurn.TriggerAPPodTurn(entity2.getOwnerId(), entity2.getId()));
                    this.send(this.createTurnVectorPacket());
                    break;
                }
            }
            if (entityAction instanceof BreakGrappleAttackAction && ((Mech)(object = (Mech)this.game.getEntity((abstractEntityAction = (BreakGrappleAttackAction)entityAction).getEntityId()))).isGrappleAttacker()) {
                entity2 = (Mech)this.game.getEntity(((AbstractAttackAction)abstractEntityAction).getTargetId());
                if (entity2.isDone()) {
                    this.game.removeActionsFor(entity2.getId());
                } else {
                    this.game.removeTurnFor(entity2);
                    entity2.setDone(true);
                }
                this.game.insertNextTurn(new GameTurn.CounterGrappleTurn(entity2.getOwnerId(), entity2.getId()));
                this.send(this.createTurnVectorPacket());
            }
            if (entityAction instanceof ClubAttackAction) {
                abstractEntityAction = (ClubAttackAction)entityAction;
                object = ((ClubAttackAction)abstractEntityAction).getClub();
                ((Mounted)object).restore();
            }
            if (entityAction instanceof PushAttackAction) {
                abstractEntityAction = (PushAttackAction)entityAction;
                entity.setDisplacementAttack((DisplacementAttackAction)abstractEntityAction);
                this.game.addCharge((AttackAction)((Object)abstractEntityAction));
            } else if (entityAction instanceof DodgeAction) {
                entity.dodging = true;
            } else if (entityAction instanceof SpotAction) {
                entity.setSpotting(true);
            } else {
                this.game.addAction(entityAction);
            }
            if (!(entityAction instanceof TriggerAPPodAction)) continue;
            abstractEntityAction = (TriggerAPPodAction)entityAction;
            object = entity.getEquipment(((TriggerAPPodAction)abstractEntityAction).getPodId());
            ((Mounted)object).setUsedThisRound(true);
        }
        if (bl) {
            entity.setDone(true);
        }
        this.entityUpdate(entity.getId());
        this.send(this.createAttackPacket(vector, 0));
    }

    private void assignAMS() {
        Serializable serializable;
        Object object;
        Hashtable<Entity, Vector<Serializable>> hashtable = new Hashtable<Entity, Vector<Serializable>>();
        Enumeration enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof WeaponAttackAction)) continue;
            serializable = (WeaponAttackAction)object;
            Mounted mounted = this.game.getEntity(((AbstractEntityAction)serializable).getEntityId()).getEquipment(((WeaponAttackAction)serializable).getWeaponId());
            if (0 != ((AbstractAttackAction)serializable).getTargetType() || ((WeaponType)mounted.getType()).getDamage() != -2) continue;
            Entity entity = this.game.getEntity(((AbstractAttackAction)serializable).getTargetId());
            Vector<Serializable> vector = (Vector<Serializable>)hashtable.get(entity);
            if (vector == null) {
                vector = new Vector<Serializable>();
                hashtable.put(entity, vector);
            }
            vector.addElement(serializable);
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (Entity)enumeration.nextElement();
            serializable = (Vector)hashtable.get(object);
            ((Entity)object).assignAMS((Vector)serializable);
        }
    }

    private void resolveAllButWeaponAttacks() {
        Serializable serializable;
        RoundUpdated roundUpdated;
        Object object;
        Object object2;
        Object object3;
        if (this.game.getPhase() == 12) {
            this.addReport(new Report(3000, 0));
            object3 = this.game.getLayMinefieldActions();
            while (object3.hasMoreElements()) {
                object2 = (LayMinefieldAction)object3.nextElement();
                object = this.game.getEntity(((AbstractEntityAction)object2).getEntityId());
                roundUpdated = ((Entity)object).getEquipment(((LayMinefieldAction)object2).getMineId());
                if (((Mounted)roundUpdated).isMissing()) continue;
                switch (((Mounted)roundUpdated).getMineType()) {
                    case 0: {
                        this.deliverThunderMinefield(((Entity)object).getPosition(), ((Entity)object).getOwnerId(), 10);
                        ((Mounted)roundUpdated).setMissing(true);
                        serializable = new Report(3500);
                        ((Report)serializable).subject = ((Entity)object).getId();
                        ((Report)serializable).addDesc((Entity)object);
                        ((Report)serializable).add(((Entity)object).getPosition().getBoardNum());
                        this.addReport((Report)serializable);
                        break;
                    }
                    case 1: {
                        this.deliverThunderVibraMinefield(((Entity)object).getPosition(), ((Entity)object).getOwnerId(), 10, ((Mounted)roundUpdated).getVibraSetting());
                        ((Mounted)roundUpdated).setMissing(true);
                        serializable = new Report(3505);
                        ((Report)serializable).subject = ((Entity)object).getId();
                        ((Report)serializable).addDesc((Entity)object);
                        ((Report)serializable).add(((Entity)object).getPosition().getBoardNum());
                        this.addReport((Report)serializable);
                    }
                }
            }
            this.game.resetLayMinefieldActions();
        }
        serializable = new Vector<RoundUpdated>();
        object3 = new Vector();
        object2 = this.game.getActions();
        while (object2.hasMoreElements()) {
            AbstractEntityAction abstractEntityAction;
            object = (EntityAction)object2.nextElement();
            roundUpdated = this.game.getEntity(object.getEntityId());
            if (object instanceof TorsoTwistAction) {
                abstractEntityAction = (TorsoTwistAction)object;
                if (!((Entity)roundUpdated).canChangeSecondaryFacing()) continue;
                ((Entity)roundUpdated).setSecondaryFacing(((TorsoTwistAction)abstractEntityAction).getFacing());
                continue;
            }
            if (object instanceof FlipArmsAction) {
                abstractEntityAction = (FlipArmsAction)object;
                ((Entity)roundUpdated).setArmsFlipped(((FlipArmsAction)abstractEntityAction).getIsFlipped());
                continue;
            }
            if (object instanceof FindClubAction) {
                this.resolveFindClub((Entity)roundUpdated);
                continue;
            }
            if (object instanceof UnjamAction) {
                this.resolveUnjam((Entity)roundUpdated);
                continue;
            }
            if (object instanceof ClearMinefieldAction) {
                ((Vector)serializable).addElement(roundUpdated);
                continue;
            }
            if (object instanceof TriggerAPPodAction) {
                abstractEntityAction = (TriggerAPPodAction)object;
                if (!((Vector)object3).contains(abstractEntityAction)) {
                    this.triggerAPPod((Entity)roundUpdated, ((TriggerAPPodAction)abstractEntityAction).getPodId());
                    ((Vector)object3).addElement(abstractEntityAction);
                    continue;
                }
                System.err.print("AP Pod #");
                System.err.print(((TriggerAPPodAction)abstractEntityAction).getPodId());
                System.err.print(" on ");
                System.err.print(((Entity)roundUpdated).getDisplayName());
                System.err.println(" was already triggered this round!!");
                continue;
            }
            if (!(object instanceof SearchlightAttackAction)) continue;
            abstractEntityAction = (SearchlightAttackAction)object;
            this.addReport(((SearchlightAttackAction)abstractEntityAction).resolveAction(this.game));
        }
        this.resolveClearMinefieldAttempts((Vector)serializable);
    }

    private void resolveClearMinefieldAttempts(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            int n;
            Serializable serializable;
            int n2;
            Vector<Entity> vector2 = new Vector<Entity>();
            Entity entity = (Entity)vector.elementAt(i);
            Coords coords = entity.getPosition();
            vector2.addElement(entity);
            for (n2 = i + 1; n2 < vector.size(); ++n2) {
                Entity entity2 = (Entity)vector.elementAt(n2);
                if (!entity2.getPosition().equals(coords)) continue;
                vector2.addElement(entity2);
                vector.removeElement(entity2);
            }
            n2 = 0;
            boolean bl = false;
            for (int j = 0; j < vector2.size(); ++j) {
                serializable = (Entity)vector2.elementAt(j);
                n = Compute.d6(2);
                int n3 = 10;
                int n4 = 5;
                for (Mounted mounted : ((Entity)serializable).getMisc()) {
                    if (!mounted.getType().hasFlag(0x100000L) || !mounted.getType().hasSubType(8)) continue;
                    int n5 = mounted.getType().getToHitModifier();
                    n3 = Minefield.CLEAR_NUMBER_SWEEPER[n5];
                    n4 = Minefield.CLEAR_NUMBER_SWEEPER_ACCIDENT[n5];
                    break;
                }
                object = new Report(2245);
                ((Report)object).subject = ((Entity)serializable).getId();
                ((Report)object).add(((Entity)serializable).getShortName(), true);
                ((Report)object).add(coords.getBoardNum(), true);
                ((Report)object).add(n3);
                ((Report)object).add(n);
                ((Report)object).newlines = 0;
                this.addReport((Report)object);
                if (n >= n3) {
                    object = new Report(2250);
                    ((Report)object).subject = ((Entity)serializable).getId();
                    this.addReport((Report)object);
                    bl = true;
                    continue;
                }
                if (n <= n4) {
                    object = new Report(2255);
                    ((Report)object).subject = ((Entity)serializable).getId();
                    this.addReport((Report)object);
                    n2 = 1;
                    continue;
                }
                object = new Report(2260);
                ((Report)object).subject = ((Entity)serializable).getId();
                this.addReport((Report)object);
            }
            if (n2 != 0) {
                Enumeration enumeration = this.game.getMinefields(coords).elements();
                block8: while (enumeration.hasMoreElements()) {
                    serializable = (Minefield)enumeration.nextElement();
                    switch (((Minefield)serializable).getType()) {
                        case 0: 
                        case 3: {
                            for (n = 0; n < vector2.size(); ++n) {
                                Entity entity3 = (Entity)vector2.elementAt(n);
                                Report report = new Report(2265);
                                report.subject = entity3.getId();
                                report.add(entity3.getShortName(), true);
                                this.addReport(report);
                                object = entity3.rollHitLocation(2, 0);
                                this.addReport(this.damageEntity(entity3, (HitData)object, ((Minefield)serializable).getDamage()));
                                this.addNewLines();
                            }
                            continue block8;
                        }
                        case 2: {
                            this.explodeVibrabomb((Minefield)serializable);
                        }
                    }
                }
            }
            if (!bl) continue;
            this.removeMinefieldsFrom(coords);
        }
    }

    private void resolveOnlyWeaponAttacks() {
        Serializable serializable;
        Object object;
        Vector<WeaponResult> vector = new Vector<WeaponResult>(this.game.actionsSize());
        Enumeration enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof WeaponAttackAction)) continue;
            serializable = (WeaponAttackAction)object;
            vector.addElement(this.preTreatWeaponAttack((WeaponAttackAction)serializable));
        }
        int n = -1;
        object = vector.elements();
        while (object.hasMoreElements()) {
            serializable = (WeaponResult)object.nextElement();
            this.resolveWeaponAttack((WeaponResult)serializable, n);
            n = ((WeaponResult)serializable).waa.getEntityId();
        }
        this.game.resetActions();
    }

    private void triggerAPPod(Entity entity, int n) {
        Mounted mounted = entity.getEquipment(n);
        if (null == mounted) {
            System.err.print("Expecting to find an AP Pod at ");
            System.err.print(n);
            System.err.print(" on the unit, ");
            System.err.print(entity.getDisplayName());
            System.err.println(" but found NO equipment at all!!!");
            return;
        }
        EquipmentType equipmentType = mounted.getType();
        if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x2000000L)) {
            System.err.print("Expecting to find an AP Pod at ");
            System.err.print(n);
            System.err.print(" on the unit, ");
            System.err.print(entity.getDisplayName());
            System.err.print(" but found ");
            System.err.print(equipmentType.getName());
            System.err.println(" instead!!!");
            return;
        }
        boolean bl = mounted.isUsedThisRound();
        mounted.setUsedThisRound(false);
        boolean bl2 = mounted.canFire();
        mounted.setUsedThisRound(bl);
        if (!bl2) {
            System.err.print("Can not trigger the AP Pod at ");
            System.err.print(n);
            System.err.print(" on the unit, ");
            System.err.print(entity.getDisplayName());
            System.err.println("!!!");
            return;
        }
        mounted.setFired(true);
        Report report = new Report(3010);
        report.newlines = 0;
        report.subject = entity.getId();
        report.addDesc(entity);
        this.addReport(report);
        Enumeration enumeration = this.game.getEntities(entity.getPosition());
        while (enumeration.hasMoreElements()) {
            Entity entity2 = (Entity)enumeration.nextElement();
            if (entity2 instanceof Infantry && !(entity2 instanceof BattleArmor)) {
                int n2 = Compute.d6() - 1;
                if (0 == n2) {
                    report = new Report(3015);
                    report.indent(2);
                    report.subject = entity2.getId();
                    report.addDesc(entity2);
                    this.addReport(report);
                    continue;
                }
                this.addReport(this.damageEntity(entity2, new HitData(0), n2));
                entity2.applyDamage();
                continue;
            }
            if (entity.equals(entity2)) continue;
            report = new Report(3020);
            report.indent(2);
            report.subject = entity2.getId();
            report.addDesc(entity2);
            this.addReport(report);
        }
    }

    private void resolveUnjam(Entity entity) {
        int n = entity.getCrew().getGunnery() + 3;
        Report report = new Report(3025);
        report.subject = entity.getId();
        report.addDesc(entity);
        this.addReport(report);
        for (Mounted mounted : entity.getWeaponList()) {
            WeaponType weaponType;
            if (!mounted.isJammed() || (weaponType = (WeaponType)mounted.getType()).getAmmoType() != 23) continue;
            int n2 = Compute.d6(2);
            report = new Report(3030);
            report.indent();
            report.subject = entity.getId();
            report.add(weaponType.getName());
            report.add(n);
            report.add(n2);
            if (n2 >= n) {
                report.choose(true);
                mounted.setJammed(false);
            } else {
                report.choose(false);
            }
            this.addReport(report);
        }
    }

    private void resolveFindClub(Entity entity) {
        Report report;
        EquipmentType equipmentType = null;
        entity.setFindingClub(true);
        Coords coords = entity.getPosition();
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex.terrainLevel(18) > 0) {
            equipmentType = EquipmentType.get("Limb Club");
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(18, iHex.terrainLevel(18) - 1));
            this.sendChangedHex(entity.getPosition());
            report = new Report(3035);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        } else if (iHex.terrainLevel(19) > 0) {
            equipmentType = EquipmentType.get("Limb Club");
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(19, iHex.terrainLevel(19) - 1));
            this.sendChangedHex(entity.getPosition());
            report = new Report(3040);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        } else if (1 < iHex.terrainLevel(3)) {
            boolean bl = false;
            int n = Compute.d6(2);
            switch (iHex.terrainLevel(3)) {
                case 2: {
                    if (n < 7) break;
                    bl = true;
                    break;
                }
                case 3: {
                    if (n < 6) break;
                    bl = true;
                    break;
                }
                case 4: {
                    if (n < 5) break;
                    bl = true;
                }
            }
            if (bl) {
                equipmentType = EquipmentType.get("Girder Club");
                report = new Report(3045);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
            } else {
                equipmentType = null;
                report = new Report(3050);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
            }
        } else if (iHex.containsTerrain(1) || iHex.containsTerrain(23)) {
            equipmentType = EquipmentType.get("Tree Club");
            report = new Report(3055);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        try {
            if (equipmentType != null) {
                entity.addEquipment(equipmentType, -1);
            }
        }
        catch (LocationFullException locationFullException) {
            report = new Report(3060);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
    }

    private WeaponResult preTreatWeaponAttack(WeaponAttackAction weaponAttackAction) {
        boolean bl;
        Entity entity = this.game.getEntity(weaponAttackAction.getEntityId());
        Mounted mounted = entity.getEquipment(weaponAttackAction.getWeaponId());
        WeaponType weaponType = (WeaponType)mounted.getType();
        boolean bl2 = weaponType.getAmmoType() != -1 && weaponType.getAmmoType() != -2 && weaponType.getAmmoType() != -3 && !weaponType.hasFlag(2048L);
        Mounted mounted2 = null;
        if (bl2) {
            if (weaponAttackAction.getAmmoId() > -1) {
                mounted2 = entity.getEquipment(weaponAttackAction.getAmmoId());
                mounted.setLinked(mounted2);
            } else {
                mounted2 = mounted.getLinked();
            }
        }
        WeaponResult weaponResult = new WeaponResult();
        weaponResult.waa = weaponAttackAction;
        if (!weaponAttackAction.isNemesisConfused() && !weaponAttackAction.isSwarmingMissiles()) {
            if (mounted.isUsedThisRound()) {
                weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "Weapon has already been used this round");
                return weaponResult;
            }
            if (mounted.isDestroyed()) {
                weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "Weapon was destroyed in a previous round");
                return weaponResult;
            }
            if (mounted.isJammed()) {
                weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "Weapon is jammed");
                return weaponResult;
            }
            if (bl2 && (mounted2 == null || mounted2.getShotsLeft() == 0 || mounted2.isDumping())) {
                entity.loadWeaponWithSameAmmo(mounted);
                mounted2 = mounted.getLinked();
            }
            weaponAttackAction.setAmmoId(entity.getEquipmentNum(mounted2));
        }
        weaponResult.toHit = weaponAttackAction.toHit(this.game);
        if (weaponAttackAction.isNemesisConfused()) {
            weaponResult.toHit.addModifier(1, "iNarc Nemesis pod");
        }
        weaponResult.roll = Compute.d6(2);
        boolean bl3 = bl = (weaponType.getAmmoType() == 11 || weaponType.getAmmoType() == 47 || weaponType.getAmmoType() == 32) && weaponResult.roll < weaponResult.toHit.getValue();
        if (!(weaponResult.toHit.getValue() == Integer.MAX_VALUE || bl && !Compute.isAffectedByAngelECM(entity, entity.getPosition(), weaponAttackAction.getTarget(this.game).getPosition()) || weaponAttackAction.isNemesisConfused() || weaponAttackAction.isSwarmingMissiles())) {
            weaponResult = this.addHeatUseAmmoFor(weaponAttackAction, weaponResult);
        }
        mounted.setUsedThisRound(true);
        if (!bl) {
            weaponResult = this.resolveAmsFor(weaponAttackAction, weaponResult);
        }
        return weaponResult;
    }

    private WeaponResult addHeatUseAmmoFor(WeaponAttackAction weaponAttackAction, WeaponResult weaponResult) {
        int n;
        if (weaponAttackAction.isSwarmingMissiles()) {
            return weaponResult;
        }
        Entity entity = this.game.getEntity(weaponAttackAction.getEntityId());
        Mounted mounted = entity.getEquipment(weaponAttackAction.getWeaponId());
        WeaponType weaponType = (WeaponType)mounted.getType();
        boolean bl = weaponType.getAmmoType() != -1 && weaponType.getAmmoType() != -2 && weaponType.getAmmoType() != -3 && !weaponType.hasFlag(2048L);
        Mounted mounted2 = mounted.getLinked();
        int n2 = mounted.howManyShots();
        if (bl && n2 > 1 && (n = entity.getTotalAmmoOfType(mounted2.getType())) < n2) {
            weaponResult.revertsToSingleShot = true;
            n2 = 1;
        }
        if (bl) {
            for (n = 0; n < n2; ++n) {
                if (mounted2.getShotsLeft() <= 0) {
                    entity.loadWeaponWithSameAmmo(mounted);
                    mounted2 = mounted.getLinked();
                }
                mounted2.setShotsLeft(mounted2.getShotsLeft() - 1);
            }
        }
        entity.heatBuildup += weaponType.getHeat() * n2;
        return weaponResult;
    }

    private WeaponResult resolveAmsFor(WeaponAttackAction weaponAttackAction, WeaponResult weaponResult) {
        Entity entity = this.game.getEntity(weaponAttackAction.getTargetId());
        ArrayList arrayList = weaponAttackAction.getCounterEquipment();
        if (null != arrayList) {
            weaponResult.amsShotDown = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                weaponResult.amsShotDown[i] = 0;
                Mounted mounted = (Mounted)arrayList.get(i);
                Mounted mounted2 = mounted.getLinked();
                Entity entity2 = weaponAttackAction.getEntity(this.game);
                if (!(mounted.getType() instanceof WeaponType) || !mounted.getType().hasFlag(0x1000000L) || !mounted.isReady() || mounted.isMissing() || entity2.hasShield() && entity2.hasActiveShield(mounted.getLocation(), false)) continue;
                int n = Compute.d6(((WeaponType)mounted.getType()).getDamage());
                entity.heatBuildup = mounted.getType().hasFlag(0x800000L) ? (entity.heatBuildup += Compute.d6(((WeaponType)mounted.getType()).getHeat())) : (entity.heatBuildup += ((WeaponType)mounted.getType()).getHeat());
                if (mounted2 != null) {
                    mounted2.setShotsLeft(Math.max(0, mounted2.getShotsLeft() - n));
                }
                mounted.setUsedThisRound(true);
                weaponResult.amsShotDown[i] = n;
                weaponResult.amsShotDownTotal += n;
            }
        }
        return weaponResult;
    }

    private boolean tryIgniteHex(Coords coords, int n, boolean bl, int n2, boolean bl2) {
        IHex iHex = this.game.getBoard().getHex(coords);
        boolean bl3 = false;
        if (iHex == null) {
            return false;
        }
        if (bl) {
            this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, 1);
            n2 = 0;
            bl3 = true;
        }
        if (iHex.containsTerrain(7)) {
            if (bl2) {
                Report report = new Report(3065);
                report.indent(3);
                report.subject = n;
                this.addReport(report);
            }
            return true;
        }
        if (this.ignite(iHex, n2, bl3, n)) {
            Report report = new Report(3070);
            report.indent(3);
            report.subject = n;
            this.addReport(report);
            this.sendChangedHex(coords);
            return true;
        }
        return false;
    }

    private boolean tryIgniteHex(Coords coords, int n, boolean bl, int n2) {
        return this.tryIgniteHex(coords, n, bl, n2, false);
    }

    private void tryClearHex(Coords coords, int n, int n2) {
        IHex iHex = this.game.getBoard().getHex(coords);
        int n3 = iHex.terrainLevel(1);
        int n4 = iHex.terrainLevel(23);
        boolean bl = iHex.containsTerrain(20);
        if (n3 == Integer.MIN_VALUE && n4 == Integer.MIN_VALUE && !bl) {
            Report report = new Report(3075);
            report.indent(3);
            report.subject = n2;
            this.addReport(report);
        } else {
            int n5 = Compute.d6(2);
            Report report = new Report(3080);
            report.indent(3);
            report.subject = n2;
            report.add(n);
            report.add(n5);
            report.newlines = 0;
            this.addReport(report);
            if (n5 >= n) {
                if (n3 > 2) {
                    iHex.removeTerrain(1);
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(1, n3 - 1));
                    report = new Report(3082);
                    report.subject = n2;
                    this.addReport(report);
                } else if (n3 == 2) {
                    iHex.removeTerrain(1);
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(1, n3 - 1));
                    report = new Report(3085);
                    report.subject = n2;
                    this.addReport(report);
                } else if (n3 == 1) {
                    iHex.removeTerrain(1);
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(2, 1));
                    report = new Report(3090);
                    report.subject = n2;
                    this.addReport(report);
                } else if (n4 > 2) {
                    iHex.removeTerrain(23);
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(23, n4 - 1));
                    report = new Report(3083);
                    report.subject = n2;
                    this.addReport(report);
                } else if (n4 == 2) {
                    iHex.removeTerrain(23);
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(23, n4 - 1));
                    report = new Report(3086);
                    report.subject = n2;
                    this.addReport(report);
                } else if (n4 == 1) {
                    iHex.removeTerrain(23);
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(2, 1));
                    report = new Report(3091);
                    report.subject = n2;
                    this.addReport(report);
                } else if (bl) {
                    iHex.removeTerrain(20);
                    report = new Report(3092);
                    report.subject = n2;
                    this.addReport(report);
                    this.resolveIceBroken(coords);
                }
                this.sendChangedHex(coords);
            } else {
                report = new Report(3095);
                report.subject = n2;
                this.addReport(report);
            }
        }
    }

    private void resolveWeaponAttack(WeaponResult weaponResult, int n) {
        this.resolveWeaponAttack(weaponResult, n, false);
    }

    private boolean resolveWeaponAttack(WeaponResult weaponResult, int n, boolean bl) {
        return this.resolveWeaponAttack(weaponResult, n, bl, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean resolveWeaponAttack(WeaponResult weaponResult, int n, boolean bl, int n2) {
        int n3;
        String string;
        boolean bl2;
        boolean bl3;
        int n4;
        int n5;
        boolean bl4;
        int n6;
        int n7;
        Report report;
        Building building;
        boolean bl5;
        int n8;
        int n9;
        boolean bl6;
        boolean bl7;
        boolean bl8;
        boolean bl9;
        boolean bl10;
        boolean bl11;
        boolean bl12;
        boolean bl13;
        boolean bl14;
        boolean bl15;
        ToHitData toHitData;
        AmmoType ammoType;
        boolean bl16;
        boolean bl17;
        WeaponType weaponType;
        Mounted mounted;
        Entity entity;
        int n10;
        boolean bl18;
        Targetable targetable;
        Entity entity2;
        block365: {
            int n11;
            boolean bl19;
            int n12;
            int n13;
            Infantry infantry;
            block370: {
                block373: {
                    int n14;
                    Mounted mounted2;
                    block381: {
                        int n15;
                        block382: {
                            block380: {
                                block379: {
                                    boolean bl20;
                                    int n16;
                                    block374: {
                                        block377: {
                                            block375: {
                                                block378: {
                                                    block376: {
                                                        block368: {
                                                            block371: {
                                                                block372: {
                                                                    block369: {
                                                                        boolean bl21;
                                                                        Mounted mounted3;
                                                                        block367: {
                                                                            block366: {
                                                                                boolean bl22;
                                                                                block364: {
                                                                                    int n17;
                                                                                    int n18;
                                                                                    int n19;
                                                                                    boolean bl23;
                                                                                    boolean bl24;
                                                                                    block361: {
                                                                                        block363: {
                                                                                            int n20;
                                                                                            block360: {
                                                                                                block362: {
                                                                                                    block355: {
                                                                                                        block357: {
                                                                                                            block358: {
                                                                                                                block359: {
                                                                                                                    block356: {
                                                                                                                        Serializable serializable;
                                                                                                                        entity2 = this.game.getEntity(weaponResult.waa.getEntityId());
                                                                                                                        if (entity2 == null) {
                                                                                                                            entity2 = this.game.getOutOfGameEntity(weaponResult.waa.getEntityId());
                                                                                                                        }
                                                                                                                        bl18 = (targetable = this.game.getTarget(weaponResult.waa.getTargetType(), weaponResult.waa.getTargetId())) instanceof Mech ? Compute.isThroughFrontHex(this.game, weaponResult.waa.getEntityId(), (Entity)targetable) : true;
                                                                                                                        n10 = -1;
                                                                                                                        entity = null;
                                                                                                                        if (targetable.getTargetType() == 0) {
                                                                                                                            entity = (Entity)targetable;
                                                                                                                            n10 = entity.getId();
                                                                                                                        } else {
                                                                                                                            n10 = entity2.getId();
                                                                                                                        }
                                                                                                                        mounted = entity2.getEquipment(weaponResult.waa.getWeaponId());
                                                                                                                        weaponType = (WeaponType)mounted.getType();
                                                                                                                        bl17 = weaponType.hasFlag(2048L);
                                                                                                                        bl16 = weaponType.getAmmoType() != -1 && weaponType.getAmmoType() != -2 && weaponType.getAmmoType() != -3 && !bl17;
                                                                                                                        mounted2 = bl16 ? entity2.getEquipment(weaponResult.waa.getAmmoId()) : null;
                                                                                                                        ammoType = mounted2 == null ? null : (AmmoType)mounted2.getType();
                                                                                                                        infantry = null;
                                                                                                                        bl22 = weaponType.hasFlag(4096L);
                                                                                                                        toHitData = weaponResult.toHit;
                                                                                                                        bl15 = bl16 && (ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 25) && ammoType.getMunitionType() == 0x400000L;
                                                                                                                        bl14 = bl16 && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 9) && ammoType.getMunitionType() == 128L;
                                                                                                                        bl13 = bl16 && ammoType.getAmmoType() == 9 && ammoType.getMunitionType() == 0x800000L;
                                                                                                                        bl12 = bl16 && (ammoType.getAmmoType() == 1 || ammoType.getAmmoType() == 35) && ammoType.getMunitionType() == 4L;
                                                                                                                        boolean bl25 = targetable.getTargetType() == 7;
                                                                                                                        bl24 = targetable.getTargetType() == 0 && weaponType.hasFlag(65536L) && bl16 && ammoType.getMunitionType() == 0L && entity.getMovementMode() == 6 && entity.getElevation() > 0;
                                                                                                                        bl11 = bl16 && (ammoType.getAmmoType() == 1 || ammoType.getAmmoType() == 35) && ammoType.getMunitionType() == 8L;
                                                                                                                        bl10 = bl16 && (ammoType.getAmmoType() == 1 || ammoType.getAmmoType() == 35) && ammoType.getMunitionType() == 0x400000000L;
                                                                                                                        bl9 = bl16 && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 9) && ammoType.getMunitionType() == 512L;
                                                                                                                        bl8 = bl16 && ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 32768L;
                                                                                                                        bl7 = bl16 && ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 65536L;
                                                                                                                        boolean bl26 = (weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 8) && mounted.curMode().equals("Indirect");
                                                                                                                        bl23 = Compute.isAffectedByAngelECM(entity2, entity2.getPosition(), targetable.getPosition());
                                                                                                                        bl6 = false;
                                                                                                                        n9 = 0;
                                                                                                                        n8 = 1;
                                                                                                                        n13 = 0;
                                                                                                                        n19 = 0;
                                                                                                                        if (!bl15) {
                                                                                                                            bl15 = bl17 && weaponType.hasFlag(1024L);
                                                                                                                        }
                                                                                                                        bl5 = Compute.isInBuilding(this.game, entity);
                                                                                                                        if ((bl25 || bl24) && this.game.getPhase() == 12) {
                                                                                                                            weaponResult.artyAttackerCoords = entity2.getPosition();
                                                                                                                        }
                                                                                                                        if ((bl8 || bl7) && entity != null) {
                                                                                                                            entity.addTargetedBySwarm(entity2.getId(), weaponResult.waa.getWeaponId());
                                                                                                                        }
                                                                                                                        building = this.game.getBoard().getBuildingAt(targetable.getPosition());
                                                                                                                        boolean bl27 = false;
                                                                                                                        mounted3 = mounted.getLinkedBy();
                                                                                                                        if (weaponType.getAmmoType() == 29 || mounted3 != null && mounted3.getType() instanceof MiscType && !mounted3.isDestroyed() && !mounted3.isMissing() && !mounted3.isBreached() && mounted3.getType().hasFlag(512L)) {
                                                                                                                            if (!(mounted.getType().hasModes() && mounted.curMode().equals("Indirect") || (ammoType.getAmmoType() != 29 || ammoType.getMunitionType() != 0L && ammoType.getMunitionType() != 32L && ammoType.getMunitionType() != 64L) && (ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 9 || ammoType.getMunitionType() != 2048L))) {
                                                                                                                                bl27 = true;
                                                                                                                            }
                                                                                                                        } else if ((weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 9) && bl16 && ammoType.getMunitionType() == 1024L) {
                                                                                                                            bl27 = true;
                                                                                                                        }
                                                                                                                        if (entity != null) {
                                                                                                                            entity2.setLastTarget(entity.getId());
                                                                                                                        }
                                                                                                                        if (n != entity2.getId()) {
                                                                                                                            report = new Report(3100);
                                                                                                                            report.subject = n10;
                                                                                                                            report.addDesc(entity2);
                                                                                                                            this.addReport(report);
                                                                                                                        }
                                                                                                                        if ("StopSwarm".equals(weaponType.getInternalName())) {
                                                                                                                            if (toHitData.getValue() == Integer.MAX_VALUE) {
                                                                                                                                report = new Report(3105);
                                                                                                                                report.subject = n10;
                                                                                                                                report.add(toHitData.getDesc());
                                                                                                                                this.addReport(report);
                                                                                                                                return true;
                                                                                                                            }
                                                                                                                            report = new Report(3110);
                                                                                                                            report.subject = n10;
                                                                                                                            this.addReport(report);
                                                                                                                            if (entity2.getSwarmTargetId() != targetable.getTargetId()) {
                                                                                                                                Entity entity3 = this.game.getEntity(entity2.getSwarmTargetId());
                                                                                                                                entity3.setSwarmAttackerId(-1);
                                                                                                                            } else {
                                                                                                                                entity.setSwarmAttackerId(-1);
                                                                                                                            }
                                                                                                                            entity2.setSwarmTargetId(-1);
                                                                                                                            return true;
                                                                                                                        }
                                                                                                                        report = new Report(3115);
                                                                                                                        report.indent();
                                                                                                                        report.newlines = 0;
                                                                                                                        report.subject = n10;
                                                                                                                        report.add(weaponType.getName());
                                                                                                                        if (entity != null) {
                                                                                                                            report.addDesc(entity);
                                                                                                                        } else {
                                                                                                                            report.messageId = 3120;
                                                                                                                            report.add(targetable.getDisplayName(), true);
                                                                                                                        }
                                                                                                                        this.addReport(report);
                                                                                                                        boolean bl28 = false;
                                                                                                                        if (bl27 && !bl) {
                                                                                                                            Enumeration enumeration = this.game.getNemesisTargets(entity2, targetable.getPosition());
                                                                                                                            while (enumeration.hasMoreElements()) {
                                                                                                                                serializable = (Entity)enumeration.nextElement();
                                                                                                                                report = new Report(3125);
                                                                                                                                report.subject = n10;
                                                                                                                                this.addReport(report);
                                                                                                                                mounted.setUsedThisRound(false);
                                                                                                                                WeaponAttackAction weaponAttackAction = new WeaponAttackAction(entity2.getId(), ((Entity)serializable).getTargetId(), weaponResult.waa.getWeaponId());
                                                                                                                                weaponAttackAction.setNemesisConfused(true);
                                                                                                                                weaponAttackAction.setAmmoId(weaponResult.waa.getAmmoId());
                                                                                                                                WeaponResult weaponResult2 = this.preTreatWeaponAttack(weaponAttackAction);
                                                                                                                                if (this.resolveWeaponAttack(weaponResult2, entity2.getId(), true)) {
                                                                                                                                    return true;
                                                                                                                                }
                                                                                                                                bl28 = true;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (bl28) {
                                                                                                                            report = new Report(3130);
                                                                                                                            report.subject = n10;
                                                                                                                            report.newlines = 0;
                                                                                                                            this.addReport(report);
                                                                                                                        }
                                                                                                                        if (toHitData.getValue() == Integer.MAX_VALUE) {
                                                                                                                            report = new Report(3135);
                                                                                                                            report.subject = n10;
                                                                                                                            report.add(toHitData.getDesc());
                                                                                                                            this.addReport(report);
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (toHitData.getValue() == 0x7FFFFFFE) {
                                                                                                                            report = new Report(3140);
                                                                                                                            report.newlines = 0;
                                                                                                                            report.subject = n10;
                                                                                                                            report.add(toHitData.getDesc());
                                                                                                                            this.addReport(report);
                                                                                                                        } else if (toHitData.getValue() == Integer.MIN_VALUE) {
                                                                                                                            report = new Report(3145);
                                                                                                                            report.newlines = 0;
                                                                                                                            report.subject = n10;
                                                                                                                            report.add(toHitData.getDesc());
                                                                                                                            this.addReport(report);
                                                                                                                        } else {
                                                                                                                            report = new Report(3150);
                                                                                                                            report.newlines = 0;
                                                                                                                            report.subject = n10;
                                                                                                                            report.add(toHitData.getValue());
                                                                                                                            this.addReport(report);
                                                                                                                        }
                                                                                                                        if (weaponType.getAmmoType() == 22 && entity2.mpUsed > 0) {
                                                                                                                            int n21;
                                                                                                                            switch (entity2.getWeightClass()) {
                                                                                                                                case 0: {
                                                                                                                                    n21 = 2;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 1: {
                                                                                                                                    n21 = 1;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 2: {
                                                                                                                                    n21 = 0;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                default: {
                                                                                                                                    n21 = -1;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            serializable = new PilotingRollData(entity2.getId(), n21, "fired HeavyGauss unbraced");
                                                                                                                            ((PilotingRollData)serializable).setCumulative(false);
                                                                                                                            this.game.addPSR((PilotingRollData)serializable);
                                                                                                                        }
                                                                                                                        report = new Report(3155);
                                                                                                                        report.newlines = 0;
                                                                                                                        report.subject = n10;
                                                                                                                        report.add(weaponResult.roll);
                                                                                                                        this.addReport(report);
                                                                                                                        n16 = mounted.howManyShots();
                                                                                                                        if (n16 <= 1 && (!weaponType.hasFlag(0x400000L) || weaponType.getAmmoType() == -1)) break block355;
                                                                                                                        int n22 = 0;
                                                                                                                        if ((weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34) && mounted.curMode().equals("Ultra") || weaponType.hasFlag(0x400000L)) {
                                                                                                                            n22 = 2;
                                                                                                                            if (mounted.getType().hasModes() && mounted.curMode().equals("Ultra") && weaponType.hasFlag(0x400000L)) {
                                                                                                                                n22 = 4;
                                                                                                                            }
                                                                                                                        } else if (weaponType.getAmmoType() == 1 || weaponType.getAmmoType() == 35) {
                                                                                                                            if (n16 == 2) {
                                                                                                                                n22 = 4;
                                                                                                                            }
                                                                                                                        } else if (weaponType.getAmmoType() == 23) {
                                                                                                                            if (n16 == 2) {
                                                                                                                                n22 = 2;
                                                                                                                            } else if (n16 == 4) {
                                                                                                                                n22 = 3;
                                                                                                                            } else if (n16 == 6) {
                                                                                                                                n22 = 4;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (n22 <= 0 || weaponResult.roll > n22) break block355;
                                                                                                                        report = new Report(1210);
                                                                                                                        if (weaponType.getAmmoType() != 20 && weaponType.getAmmoType() != 34) break block356;
                                                                                                                        report.messageId = 3160;
                                                                                                                        mounted.setJammed(true);
                                                                                                                        mounted.setHit(true);
                                                                                                                        break block357;
                                                                                                                    }
                                                                                                                    if (weaponType.getAmmoType() != 1 && weaponType.getAmmoType() != 35) break block358;
                                                                                                                    if (weaponResult.roll <= 2) break block359;
                                                                                                                    report.messageId = 3161;
                                                                                                                    mounted.setJammed(true);
                                                                                                                    mounted.setHit(true);
                                                                                                                    break block357;
                                                                                                                }
                                                                                                                report.messageId = 3162;
                                                                                                                mounted.setJammed(true);
                                                                                                                mounted.setHit(true);
                                                                                                                n20 = mounted.getLocation();
                                                                                                                mounted.setDestroyed(true);
                                                                                                                break block360;
                                                                                                            }
                                                                                                            if (weaponType.hasFlag(0x400000L)) {
                                                                                                                report.messageId = 3165;
                                                                                                                mounted.setJammed(true);
                                                                                                                mounted.setHit(true);
                                                                                                            } else {
                                                                                                                report.messageId = 3170;
                                                                                                                mounted.setJammed(true);
                                                                                                            }
                                                                                                        }
                                                                                                        report.subject = n10;
                                                                                                        this.addReport(report);
                                                                                                        return true;
                                                                                                    }
                                                                                                    if (!this.game.getOptions().booleanOption("maxtech_ppc_inhibitors") || !weaponType.hasModes() || !mounted.curMode().equals("Field Inhibitor OFF")) break block361;
                                                                                                    int n23 = 0;
                                                                                                    int n24 = Compute.d6(2);
                                                                                                    int n25 = Compute.effectiveDistance(this.game, entity2, targetable);
                                                                                                    if (n25 >= 3) {
                                                                                                        n23 = 3;
                                                                                                    } else if (n25 == 2) {
                                                                                                        n23 = 6;
                                                                                                    } else if (n25 == 1) {
                                                                                                        n23 = 10;
                                                                                                    }
                                                                                                    report = new Report(3175);
                                                                                                    report.subject = entity2.getId();
                                                                                                    report.indent();
                                                                                                    this.addReport(report);
                                                                                                    report = new Report(3180);
                                                                                                    report.subject = entity2.getId();
                                                                                                    report.indent();
                                                                                                    report.add(n23);
                                                                                                    report.add(n24);
                                                                                                    if (n24 >= n23) break block362;
                                                                                                    n18 = mounted.getLocation();
                                                                                                    n17 = entity2.getEquipmentNum(mounted);
                                                                                                    n7 = 0;
                                                                                                    mounted.setDestroyed(true);
                                                                                                    break block363;
                                                                                                }
                                                                                                report.choose(true);
                                                                                                this.addReport(report);
                                                                                                break block361;
                                                                                            }
                                                                                            for (int i = 0; i < entity2.getNumberOfCriticals(n20); ++i) {
                                                                                                Mounted mounted4;
                                                                                                CriticalSlot criticalSlot = entity2.getCritical(n20, i);
                                                                                                if (criticalSlot == null || criticalSlot.getType() != 0 || !(mounted4 = entity2.getEquipment(criticalSlot.getIndex())).equals(mounted)) continue;
                                                                                                entity2.hitAllCriticals(n20, i);
                                                                                                break;
                                                                                            }
                                                                                            report.choose(false);
                                                                                            this.addReport(report);
                                                                                            this.addReport(this.damageEntity(entity2, new HitData(n20), weaponType.getDamage(), false, 0, true));
                                                                                            return true;
                                                                                        }
                                                                                        for (n6 = 0; n6 < entity2.getNumberOfCriticals(n18); ++n6) {
                                                                                            Mounted mounted5;
                                                                                            CriticalSlot criticalSlot = entity2.getCritical(n18, n6);
                                                                                            if (criticalSlot == null || criticalSlot.getType() != 0 || !(mounted5 = entity2.getEquipment(criticalSlot.getIndex())).equals(mounted)) continue;
                                                                                            entity2.hitAllCriticals(n18, n6);
                                                                                        }
                                                                                        report.choose(false);
                                                                                        this.addReport(report);
                                                                                        this.addReport(this.damageEntity(entity2, new HitData(n18), 10, false, 0, true));
                                                                                        report = new Report(3185);
                                                                                        report.subject = entity2.getId();
                                                                                        this.addReport(report);
                                                                                    }
                                                                                    boolean bl29 = bl4 = weaponResult.roll < toHitData.getValue();
                                                                                    if (bl4 && targetable instanceof Mech && ((Mech)targetable).getGrappled() != -1) {
                                                                                        int n26 = ((Mech)targetable).getGrappled();
                                                                                        Entity entity4 = this.game.getEntity(n26);
                                                                                        toHitData.addModifier(-1, "friendly fire");
                                                                                        report = new Report(3555);
                                                                                        report.subject = n26;
                                                                                        report.addDesc(entity4);
                                                                                        report.newlines = 0;
                                                                                        this.addReport(report);
                                                                                        weaponResult.roll = Compute.d6(2);
                                                                                        report = new Report(3150);
                                                                                        report.subject = n26;
                                                                                        report.add(toHitData.getValueAsString());
                                                                                        report.newlines = 0;
                                                                                        this.addReport(report);
                                                                                        report = new Report(3155);
                                                                                        report.subject = n26;
                                                                                        report.add(weaponResult.roll);
                                                                                        report.newlines = 0;
                                                                                        this.addReport(report);
                                                                                        if (weaponResult.roll >= toHitData.getValue()) {
                                                                                            targetable = entity4;
                                                                                            entity = entity4;
                                                                                            n10 = n26;
                                                                                            bl4 = false;
                                                                                        }
                                                                                    }
                                                                                    if (this.game.getOptions().booleanOption("maxtech_glancing_blows")) {
                                                                                        if (weaponResult.roll == toHitData.getValue()) {
                                                                                            bl6 = true;
                                                                                            n13 = -4;
                                                                                            n19 = -2;
                                                                                            report = new Report(3186);
                                                                                            report.subject = entity2.getId();
                                                                                            report.newlines = 0;
                                                                                            this.addReport(report);
                                                                                        } else {
                                                                                            bl6 = false;
                                                                                            n13 = 0;
                                                                                            n19 = 0;
                                                                                        }
                                                                                    } else {
                                                                                        bl6 = false;
                                                                                        n13 = 0;
                                                                                        n19 = 0;
                                                                                    }
                                                                                    if (weaponType.hasFlag(0x8000000L)) {
                                                                                        if (entity == null) {
                                                                                            report = new Report(3187);
                                                                                            report.subject = entity2.getId();
                                                                                            this.addReport(report);
                                                                                        } else {
                                                                                            int n27 = 1;
                                                                                            EquipmentMode equipmentMode = mounted.curMode();
                                                                                            if (equipmentMode != null) {
                                                                                                if (equipmentMode.getName() == "1-shot") {
                                                                                                    n27 = 1;
                                                                                                } else if (equipmentMode.getName() == "2-shot") {
                                                                                                    n27 = 2;
                                                                                                } else if (equipmentMode.getName() == "3-shot") {
                                                                                                    n27 = 3;
                                                                                                } else if (equipmentMode.getName() == "4-shot") {
                                                                                                    n27 = 4;
                                                                                                }
                                                                                            }
                                                                                            if (n27 < 1) {
                                                                                                n27 = 1;
                                                                                            }
                                                                                            TagInfo tagInfo = new TagInfo(entity2.getId(), entity.getId(), n27, bl4);
                                                                                            this.game.addTagInfo(tagInfo);
                                                                                            if (!bl4) {
                                                                                                entity.setTaggedBy(entity2.getId());
                                                                                                report = new Report(3188);
                                                                                                report.subject = entity2.getId();
                                                                                                this.addReport(report);
                                                                                            } else {
                                                                                                report = new Report(3220);
                                                                                                report.subject = entity2.getId();
                                                                                                this.addReport(report);
                                                                                            }
                                                                                        }
                                                                                        if (bl4) return false;
                                                                                        return true;
                                                                                    }
                                                                                    if (bl24) {
                                                                                        Coords coords = targetable.getPosition();
                                                                                        int n28 = targetable.getElevation();
                                                                                        n18 = n28 + this.game.getBoard().getHex(coords).surface();
                                                                                        if (!bl4) {
                                                                                            report = new Report(3191);
                                                                                            report.subject = n10;
                                                                                            report.add(coords.getBoardNum());
                                                                                            this.addReport(report);
                                                                                        } else {
                                                                                            coords = Compute.scatter(coords, this.game.getOptions().booleanOption("margin_scatter_distance") ? toHitData.getValue() - weaponResult.roll : -1);
                                                                                            if (this.game.getBoard().contains(coords)) {
                                                                                                report = new Report(3192);
                                                                                                report.subject = n10;
                                                                                                report.add(coords.getBoardNum());
                                                                                                this.addReport(report);
                                                                                            } else {
                                                                                                report = new Report(3193);
                                                                                                report.subject = n10;
                                                                                                this.addReport(report);
                                                                                                if (bl4) return false;
                                                                                                return true;
                                                                                            }
                                                                                        }
                                                                                        this.artilleryDamageArea(coords, weaponResult.artyAttackerCoords, ammoType, n10, entity2, true, n18);
                                                                                        if (bl4) return false;
                                                                                        return true;
                                                                                    }
                                                                                    if (targetable.getTargetType() == 14) {
                                                                                        Coords coords = targetable.getPosition();
                                                                                        if (!bl4) {
                                                                                            report = new Report(3190);
                                                                                            report.subject = n10;
                                                                                            report.add(coords.getBoardNum());
                                                                                            this.addReport(report);
                                                                                        } else {
                                                                                            coords = Compute.scatter(coords, 1);
                                                                                            if (this.game.getBoard().contains(coords)) {
                                                                                                report = new Report(3195);
                                                                                                report.subject = n10;
                                                                                                report.add(coords.getBoardNum());
                                                                                                this.addReport(report);
                                                                                            } else {
                                                                                                report = new Report(3200);
                                                                                                report.subject = n10;
                                                                                                this.addReport(report);
                                                                                                if (bl4) return false;
                                                                                                return true;
                                                                                            }
                                                                                        }
                                                                                        int n29 = 5;
                                                                                        Infantry infantry2 = (Infantry)entity2;
                                                                                        n17 = infantry2.getShootingStrength();
                                                                                        this.artilleryDamageArea(coords, weaponResult.artyAttackerCoords, ammoType, n10, entity2, n17 * 2, n17, false, 0);
                                                                                        if (bl4) return false;
                                                                                        return true;
                                                                                    }
                                                                                    if (targetable.getTargetType() == 6 || targetable.getTargetType() == 13) {
                                                                                        Coords coords = targetable.getPosition();
                                                                                        if (!bl4) {
                                                                                            report = new Report(3190);
                                                                                            report.subject = n10;
                                                                                            report.add(coords.getBoardNum());
                                                                                            this.addReport(report);
                                                                                        } else {
                                                                                            coords = Compute.scatter(coords, this.game.getOptions().booleanOption("margin_scatter_distance") ? toHitData.getValue() - weaponResult.roll : -1);
                                                                                            if (this.game.getBoard().contains(coords)) {
                                                                                                report = new Report(3195);
                                                                                                report.subject = n10;
                                                                                                report.add(coords.getBoardNum());
                                                                                                this.addReport(report);
                                                                                            } else {
                                                                                                report = new Report(3200);
                                                                                                report.subject = n10;
                                                                                                this.addReport(report);
                                                                                                if (bl4) return false;
                                                                                                return true;
                                                                                            }
                                                                                        }
                                                                                        if (ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 262144L) {
                                                                                            this.deliverThunderAugMinefield(coords, entity2.getOwner().getId(), ammoType.getRackSize());
                                                                                        } else if (ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 131072L) {
                                                                                            this.deliverThunderMinefield(coords, entity2.getOwner().getId(), ammoType.getRackSize());
                                                                                        } else if (ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 524288L) {
                                                                                            this.deliverThunderInfernoMinefield(coords, entity2.getOwner().getId(), ammoType.getRackSize());
                                                                                        } else if (ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 0x100000L) {
                                                                                            this.deliverThunderVibraMinefield(coords, entity2.getOwner().getId(), ammoType.getRackSize(), weaponResult.waa.getOtherAttackInfo());
                                                                                        } else if (ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 0x200000L) {
                                                                                            this.deliverThunderActiveMinefield(coords, entity2.getOwner().getId(), ammoType.getRackSize());
                                                                                        } else if (ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 8192L) {
                                                                                            this.deliverFlare(coords, ammoType.getRackSize());
                                                                                        }
                                                                                        if (bl4) return false;
                                                                                        return true;
                                                                                    }
                                                                                    if (!(targetable.getTargetType() != 7 || bl16 && ammoType.getMunitionType() == 0x20000000L)) {
                                                                                        Coords coords = targetable.getPosition();
                                                                                        if (!bl4) {
                                                                                            report = new Report(3190);
                                                                                            report.subject = n10;
                                                                                            report.add(coords.getBoardNum());
                                                                                            this.addReport(report);
                                                                                        } else {
                                                                                            coords = Compute.scatter(coords, this.game.getOptions().booleanOption("margin_scatter_distance") ? toHitData.getValue() - weaponResult.roll : -1);
                                                                                            if (this.game.getBoard().contains(coords)) {
                                                                                                report = new Report(3195);
                                                                                                report.subject = n10;
                                                                                                report.add(coords.getBoardNum());
                                                                                                this.addReport(report);
                                                                                            } else {
                                                                                                report = new Report(3200);
                                                                                                report.subject = n10;
                                                                                                this.addReport(report);
                                                                                                if (bl4) return false;
                                                                                                return true;
                                                                                            }
                                                                                        }
                                                                                        if (bl16) {
                                                                                            if (ammoType.getMunitionType() == 8192L) {
                                                                                                int n30 = ammoType.getAmmoType() == 15 ? 4 : (ammoType.getAmmoType() == 16 ? 3 : Math.max(1, ammoType.getRackSize() / 5));
                                                                                                this.deliverArtilleryFlare(coords, n30);
                                                                                                if (bl4) return false;
                                                                                                return true;
                                                                                            }
                                                                                            if (ammoType.getMunitionType() == 0x80000000L) {
                                                                                                this.deliverArtilleryInferno(coords, n10);
                                                                                                if (bl4) return false;
                                                                                                return true;
                                                                                            }
                                                                                            if (ammoType.getMunitionType() == 0x40000000L) {
                                                                                                this.deliverFASCAMMinefield(coords, entity2.getOwner().getId());
                                                                                                if (bl4) return false;
                                                                                                return true;
                                                                                            }
                                                                                            if (ammoType.getMunitionType() == 0x100000000L) {
                                                                                                this.deliverThunderVibraMinefield(coords, entity2.getOwner().getId(), 20, weaponResult.waa.getOtherAttackInfo());
                                                                                                if (bl4) return false;
                                                                                                return true;
                                                                                            }
                                                                                            if (ammoType.getMunitionType() == 0x200000000L) {
                                                                                                this.deliverArtillerySmoke(coords);
                                                                                                if (bl4) return false;
                                                                                                return true;
                                                                                            }
                                                                                            if (ammoType.getMunitionType() == 0x800000000L) {
                                                                                                Vector vector = new Vector();
                                                                                                this.doNuclearExplosion(coords, 1, vector);
                                                                                                this.addReport(vector);
                                                                                                if (bl4) return false;
                                                                                                return true;
                                                                                            }
                                                                                        }
                                                                                        this.artilleryDamageArea(coords, weaponResult.artyAttackerCoords, ammoType, n10, entity2, false, 0);
                                                                                        if (bl4) return false;
                                                                                        return true;
                                                                                    }
                                                                                    if (bl4 && bl16 && ammoType.getMunitionType() == 0x20000000L) {
                                                                                        this.artilleryDamageHex(targetable.getPosition(), weaponResult.artyAttackerCoords, 5, ammoType, n10, entity2, null, false, 0);
                                                                                    }
                                                                                    n14 = 0;
                                                                                    n5 = weaponType.getDamage();
                                                                                    if (bl4) {
                                                                                        if (mounted.isRapidfire() && (!(targetable instanceof Infantry) || targetable instanceof BattleArmor)) {
                                                                                            n5 = Compute.d6();
                                                                                            n14 = 3 * n5;
                                                                                            if (entity2.getTotalAmmoOfType(mounted2.getType()) > 0) {
                                                                                                for (n18 = 0; n18 < n14; ++n18) {
                                                                                                    if (mounted2.getShotsLeft() <= 0) {
                                                                                                        entity2.loadWeapon(mounted);
                                                                                                        mounted2 = mounted.getLinked();
                                                                                                    }
                                                                                                    mounted2.setShotsLeft(mounted2.getShotsLeft() - 1);
                                                                                                }
                                                                                                if (entity2 instanceof Mech) {
                                                                                                    entity2.heatBuildup += n5;
                                                                                                }
                                                                                            } else {
                                                                                                n8 = 0;
                                                                                            }
                                                                                        }
                                                                                        if (!(weaponType.getAmmoType() != 11 && weaponType.getAmmoType() != 47 && weaponType.getAmmoType() != 32 || bl23)) {
                                                                                            report = new Report(3215);
                                                                                            report.subject = n10;
                                                                                            this.addReport(report);
                                                                                        } else {
                                                                                            report = new Report(3220);
                                                                                            report.subject = n10;
                                                                                            if (mounted.isRapidfire() && (!(targetable instanceof Infantry) || targetable instanceof BattleArmor)) {
                                                                                                report.messageId = 3225;
                                                                                                report.add(n14);
                                                                                            }
                                                                                            this.addReport(report);
                                                                                        }
                                                                                        for (n18 = 0; n18 < weaponResult.amsShotDown.length; ++n18) {
                                                                                            if (weaponResult.amsShotDown[n18] <= 0) continue;
                                                                                            report = new Report(3230);
                                                                                            report.indent();
                                                                                            report.subject = n10;
                                                                                            report.add(weaponResult.amsShotDown[n18]);
                                                                                            this.addReport(report);
                                                                                        }
                                                                                        n18 = 0;
                                                                                        if (bl16) {
                                                                                            n18 = weaponType.getRackSize();
                                                                                            if (weaponType.hasFlag(8192L)) {
                                                                                                n18 *= 2;
                                                                                            }
                                                                                            if (entity2 instanceof BattleArmor) {
                                                                                                infantry = (Infantry)entity2;
                                                                                                n18 *= infantry.getShootingStrength();
                                                                                            }
                                                                                        }
                                                                                        if (bl8 || bl7) {
                                                                                            n9 = n2 > 0 ? n2 : n18;
                                                                                            int n31 = n18 = n2 > 0 ? n2 : n18;
                                                                                        }
                                                                                        if (bl16 && weaponResult.amsShotDownTotal >= n18 || toHitData.getValue() == 0x7FFFFFFE || (weaponType.getAmmoType() == 11 || weaponType.getAmmoType() == 47 || weaponType.getAmmoType() == 32) && !bl23) {
                                                                                            if (bl4) return false;
                                                                                            return true;
                                                                                        }
                                                                                        if ((bl8 || bl7) && entity != null) {
                                                                                            n9 -= weaponResult.amsShotDownTotal;
                                                                                            Entity entity5 = Compute.getSwarmTarget(this.game, entity2.getId(), entity, weaponResult.waa.getWeaponId());
                                                                                            if (entity5 != null) {
                                                                                                report = new Report(3420);
                                                                                                report.subject = entity2.getId();
                                                                                                report.indent();
                                                                                                report.add(n9);
                                                                                                this.addReport(report);
                                                                                                mounted.setUsedThisRound(false);
                                                                                                WeaponAttackAction weaponAttackAction = new WeaponAttackAction(entity2.getId(), entity5.getTargetId(), weaponResult.waa.getWeaponId());
                                                                                                weaponAttackAction.setSwarmingMissiles(true);
                                                                                                weaponAttackAction.setOldTargetId(targetable.getTargetId());
                                                                                                weaponAttackAction.setAmmoId(weaponResult.waa.getAmmoId());
                                                                                                WeaponResult weaponResult3 = this.preTreatWeaponAttack(weaponAttackAction);
                                                                                                this.resolveWeaponAttack(weaponResult3, entity2.getId(), false, n9);
                                                                                            } else {
                                                                                                report = new Report(3425);
                                                                                                report.subject = entity2.getId();
                                                                                                report.indent();
                                                                                                this.addReport(report);
                                                                                            }
                                                                                        }
                                                                                        if (entity != null && (bl15 || building == null && weaponType.getFireTN() != Integer.MAX_VALUE)) {
                                                                                            this.tryIgniteHex(targetable.getPosition(), entity2.getId(), bl15, 11);
                                                                                        }
                                                                                        if (!bl5) {
                                                                                            if (bl4) return false;
                                                                                            return true;
                                                                                        }
                                                                                    }
                                                                                    if (!bl4 && weaponType.getAmmoType() == 13 && ammoType.getMunitionType() != 0x10000000L) {
                                                                                        if (weaponResult.amsShotDownTotal > 0) {
                                                                                            report = new Report(3235);
                                                                                            report.subject = n10;
                                                                                            this.addReport(report);
                                                                                            for (n18 = 0; n18 < weaponResult.amsShotDown.length; ++n18) {
                                                                                                report = new Report(3230);
                                                                                                report.indent(1);
                                                                                                report.subject = n10;
                                                                                                report.add(weaponResult.amsShotDown[n18]);
                                                                                                this.addReport(report);
                                                                                            }
                                                                                            report = new Report(3240);
                                                                                            report.subject = n10;
                                                                                            this.addReport(report);
                                                                                        } else if (entity == null) {
                                                                                            report = new Report(3245);
                                                                                            report.subject = n10;
                                                                                            this.addReport(report);
                                                                                        } else {
                                                                                            entity.setNarcedBy(entity2.getOwner().getTeam());
                                                                                            report = new Report(3250);
                                                                                            report.subject = n10;
                                                                                            this.addReport(report);
                                                                                        }
                                                                                        if (bl4) return false;
                                                                                        return true;
                                                                                    }
                                                                                    if (!bl4 && weaponType.getAmmoType() == 31 && ammoType.getMunitionType() != 0x1000000L) {
                                                                                        if (weaponResult.amsShotDownTotal > 0) {
                                                                                            report = new Report(3235);
                                                                                            report.subject = n10;
                                                                                            this.addReport(report);
                                                                                            for (n18 = 0; n18 < weaponResult.amsShotDown.length; ++n18) {
                                                                                                report = new Report(3230);
                                                                                                report.indent(1);
                                                                                                report.subject = n10;
                                                                                                report.add(weaponResult.amsShotDown[n18]);
                                                                                                this.addReport(report);
                                                                                            }
                                                                                            report = new Report(3240);
                                                                                            report.subject = n10;
                                                                                            this.addReport(report);
                                                                                        } else if (entity == null) {
                                                                                            report = new Report(3245);
                                                                                            report.subject = n10;
                                                                                            this.addReport(report);
                                                                                        } else {
                                                                                            INarcPod iNarcPod = null;
                                                                                            if (ammoType.getMunitionType() == 0x2000000L) {
                                                                                                iNarcPod = new INarcPod(entity2.getOwner().getTeam(), 2);
                                                                                                report = new Report(3251);
                                                                                                report.subject = n10;
                                                                                                this.addReport(report);
                                                                                            } else if (ammoType.getMunitionType() == 0x4000000L) {
                                                                                                iNarcPod = new INarcPod(entity2.getOwner().getTeam(), 4);
                                                                                                report = new Report(3252);
                                                                                                report.subject = n10;
                                                                                                this.addReport(report);
                                                                                            } else if (ammoType.getMunitionType() == 0x8000000L) {
                                                                                                iNarcPod = new INarcPod(entity2.getOwner().getTeam(), 8);
                                                                                                report = new Report(3253);
                                                                                                report.subject = n10;
                                                                                                this.addReport(report);
                                                                                            } else {
                                                                                                iNarcPod = new INarcPod(entity2.getOwner().getTeam(), 1);
                                                                                                report = new Report(3254);
                                                                                                report.subject = n10;
                                                                                                this.addReport(report);
                                                                                            }
                                                                                            entity.attachINarcPod(iNarcPod);
                                                                                        }
                                                                                        if (bl4) return false;
                                                                                        return true;
                                                                                    }
                                                                                    if (!bl4 && targetable.getTargetType() == 5) {
                                                                                        n18 = Compute.d6(2);
                                                                                        if (n18 >= 5) {
                                                                                            report = new Report(3255);
                                                                                            report.indent(1);
                                                                                            report.subject = n10;
                                                                                            this.addReport(report);
                                                                                            Coords coords = targetable.getPosition();
                                                                                            Enumeration enumeration = this.game.getMinefields(coords).elements();
                                                                                            while (enumeration.hasMoreElements()) {
                                                                                                Minefield minefield = (Minefield)enumeration.nextElement();
                                                                                                this.removeMinefield(minefield);
                                                                                            }
                                                                                        } else {
                                                                                            report = new Report(3260);
                                                                                            report.indent(1);
                                                                                            report.subject = n10;
                                                                                            this.addReport(report);
                                                                                        }
                                                                                        if (bl4) return false;
                                                                                        return true;
                                                                                    }
                                                                                    int n32 = n18 = weaponType.hasFlag(2L) && weaponType.hasModes() && mounted.curMode().equals("Cool") ? 1 : 0;
                                                                                    if (weaponType.hasFlag(0x40000000L) || n18 != 0) {
                                                                                        if (!bl4) {
                                                                                            report = new Report(2270);
                                                                                            report.subject = n10;
                                                                                            report.newlines = 0;
                                                                                            this.addReport(report);
                                                                                            if (8 == targetable.getTargetType()) {
                                                                                                report = new Report(3540);
                                                                                                report.subject = n10;
                                                                                                report.add(targetable.getPosition().getBoardNum());
                                                                                                report.indent(3);
                                                                                                this.addReport(report);
                                                                                                this.game.getBoard().getHex(targetable.getPosition()).removeTerrain(7);
                                                                                                this.sendChangedHex(targetable.getPosition());
                                                                                                this.game.getBoard().removeInfernoFrom(targetable.getPosition());
                                                                                            } else if (targetable instanceof Entity) {
                                                                                                if (entity.infernos.isStillBurning() || targetable instanceof Tank && ((Tank)targetable).isOnFire()) {
                                                                                                    report = new Report(3550);
                                                                                                    report.subject = n10;
                                                                                                    report.addDesc(entity);
                                                                                                    report.newlines = 0;
                                                                                                    report.indent(3);
                                                                                                    this.addReport(report);
                                                                                                }
                                                                                                entity.infernos.clear();
                                                                                                if (targetable instanceof Tank) {
                                                                                                    for (int i = 0; i < entity.locations(); ++i) {
                                                                                                        ((Tank)targetable).extinguishAll();
                                                                                                    }
                                                                                                }
                                                                                                if (targetable instanceof Mech && n18 != 0) {
                                                                                                    int n33 = n5 * n8;
                                                                                                    report = new Report(3400);
                                                                                                    report.subject = n10;
                                                                                                    report.indent(2);
                                                                                                    report.add(n33);
                                                                                                    report.choose(false);
                                                                                                    this.addReport(report);
                                                                                                    entity.heatBuildup -= n33;
                                                                                                    n8 = 0;
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                        if (bl4) return false;
                                                                                        return true;
                                                                                    }
                                                                                    n4 = 1;
                                                                                    n7 = 0;
                                                                                    n6 = 0;
                                                                                    bl21 = false;
                                                                                    bl3 = false;
                                                                                    bl2 = false;
                                                                                    string = " shot(s) ";
                                                                                    bl20 = false;
                                                                                    n15 = entity2.getPosition().distance(targetable.getPosition());
                                                                                    n12 = 0;
                                                                                    bl19 = this.game.getOptions().booleanOption("maxtech_mslhitpen");
                                                                                    if (bl19) {
                                                                                        n12 = n15 <= 1 ? 1 : (n15 <= weaponType.getShortRange() ? 0 : (n15 <= weaponType.getMediumRange() ? -1 : -2));
                                                                                    }
                                                                                    if ((weaponType.getAmmoType() == 11 || weaponType.getAmmoType() == 47 || weaponType.getAmmoType() == 32) && !bl23 || weaponType.getAmmoType() == 13 || entity2.getSwarmTargetId() == weaponResult.waa.getTargetId() || (targetable.getTargetType() == 4 || targetable.getTargetType() == 16 || targetable.getTargetType() == 15 || targetable.getTargetType() == 3) && entity2.getPosition().distance(targetable.getPosition()) <= 1) {
                                                                                        bl20 = true;
                                                                                    }
                                                                                    if (!bl4 && "SwarmMek".equals(weaponType.getInternalName())) {
                                                                                        if (-1 != entity.getSwarmAttackerId()) {
                                                                                            report = new Report(3265);
                                                                                            report.subject = n10;
                                                                                            this.addReport(report);
                                                                                        } else if (entity.isDoomed() || entity.isDestroyed() || entity.getCrew().isDead()) {
                                                                                            report = new Report(3270);
                                                                                            report.subject = n10;
                                                                                            this.addReport(report);
                                                                                        } else {
                                                                                            report = new Report(3275);
                                                                                            report.subject = n10;
                                                                                            this.addReport(report);
                                                                                            entity2.setSwarmTargetId(weaponResult.waa.getTargetId());
                                                                                            entity.setSwarmAttackerId(weaponResult.waa.getEntityId());
                                                                                        }
                                                                                        if (bl4) return false;
                                                                                        return true;
                                                                                    }
                                                                                    if (!weaponType.getInternalName().equals("BAMineLauncher")) break block364;
                                                                                    n8 = n16;
                                                                                    if (!bl20) {
                                                                                        n8 = Compute.getBattleArmorHits(n8);
                                                                                    }
                                                                                    n6 = 1;
                                                                                    string = " mine(s) ";
                                                                                    break block365;
                                                                                }
                                                                                if (!bl22) break block366;
                                                                                n6 = 1;
                                                                                infantry = (Infantry)entity2;
                                                                                n4 = 1;
                                                                                if (bl16) {
                                                                                    n5 = ammoType.getDamagePerShot();
                                                                                }
                                                                                n5 = weaponType.getRackSize();
                                                                                n8 = infantry.getShootingStrength();
                                                                                if (!bl20) {
                                                                                    n8 = Compute.getBattleArmorHits(n8);
                                                                                }
                                                                                if (bl15) {
                                                                                    n4 = n8;
                                                                                    n5 = 0;
                                                                                    string = " Inferno missle(s) ";
                                                                                    n6 = 0;
                                                                                }
                                                                                if (entity2.getSwarmTargetId() == weaponResult.waa.getTargetId()) {
                                                                                    n5 += ((BattleArmor)entity2).getVibroClawDamage();
                                                                                }
                                                                                break block365;
                                                                            }
                                                                            if (!bl17) break block367;
                                                                            n6 = 1;
                                                                            infantry = (Infantry)entity2;
                                                                            n4 = 5;
                                                                            n5 = 1;
                                                                            n8 = infantry.getDamage(infantry.getShootingStrength());
                                                                            string = " damage are inflicted by the shots that ";
                                                                            if (bl15) {
                                                                                n4 = n8;
                                                                                n5 = 0;
                                                                                string = " Inferno missile(s) ";
                                                                                n6 = 0;
                                                                            }
                                                                            break block365;
                                                                        }
                                                                        if (weaponType.getDamage() != -2 && !weaponType.hasFlag(16384L)) break block368;
                                                                        n6 = 1;
                                                                        if (weaponType.getAmmoType() == -2 || weaponType.getAmmoType() == -3) {
                                                                            n5 = Math.abs(weaponType.getAmmoType());
                                                                        } else {
                                                                            string = " missile(s) ";
                                                                            n5 = ammoType.getDamagePerShot();
                                                                            if ((weaponType.getAmmoType() == 39 || weaponType.getAmmoType() == 40 || weaponType.getAmmoType() == 41 || weaponType.getAmmoType() == 42) && n15 <= weaponType.getMinimumRange()) {
                                                                                n5 /= 2;
                                                                            }
                                                                        }
                                                                        if (weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 32 || weaponType.getAmmoType() == 8 || weaponType.getAmmoType() == 12 || weaponType.getAmmoType() == 47 || weaponType.getAmmoType() == 29 || weaponType.getAmmoType() == 38 || weaponType.getAmmoType() == 45 || weaponType.getAmmoType() == 30) {
                                                                            n4 = 5;
                                                                        }
                                                                        if (weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 9 || weaponType.getAmmoType() == 29) {
                                                                            mounted3 = mounted.getLinkedBy();
                                                                            if (weaponType.getAmmoType() == 29 || mounted3 != null && mounted3.getType() instanceof MiscType && !mounted3.isDestroyed() && !mounted3.isMissing() && !mounted3.isBreached() && mounted3.getType().hasFlag(512L) && ammoType.getMunitionType() == 2048L) {
                                                                                if (!bl21) {
                                                                                    if (entity2 instanceof Mech) {
                                                                                        bl2 = entity2.isStealthActive();
                                                                                    }
                                                                                    bl3 = Compute.isAffectedByECM(entity2, entity2.getPosition(), targetable.getPosition()) || Compute.isAffectedByAngelECM(entity2, entity2.getPosition(), targetable.getPosition()) ? true : targetable.getTargetType() == 0 && (Compute.isProtectedByECM((Entity)targetable, targetable.getPosition(), entity2.getPosition()) || Compute.isProtectedByAngelECM((Entity)targetable, targetable.getPosition(), entity2.getPosition()));
                                                                                    bl21 = true;
                                                                                }
                                                                                if (!(bl3 || bl2 || mounted.getType().hasModes() && mounted.curMode().equals("Indirect") || (ammoType.getAmmoType() != 29 || ammoType.getMunitionType() != 0L && ammoType.getMunitionType() != 32L && ammoType.getMunitionType() != 64L) && (ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 9 || ammoType.getMunitionType() != 2048L))) {
                                                                                    n7 += 2;
                                                                                }
                                                                            } else if (entity != null && (entity.isNarcedBy(entity2.getOwner().getTeam()) || entity.isINarcedBy(entity2.getOwner().getTeam()))) {
                                                                                if (!bl21) {
                                                                                    if (entity2 instanceof Mech) {
                                                                                        bl2 = entity2.isStealthActive();
                                                                                    }
                                                                                    bl3 = Compute.isAffectedByECM(entity2, entity2.getPosition(), targetable.getPosition()) || Compute.isAffectedByAngelECM(entity2, entity2.getPosition(), targetable.getPosition()) ? true : targetable.getTargetType() == 0 && (Compute.isProtectedByECM((Entity)targetable, targetable.getPosition(), entity2.getPosition()) || Compute.isProtectedByAngelECM((Entity)targetable, targetable.getPosition(), entity2.getPosition()));
                                                                                    bl21 = true;
                                                                                }
                                                                                if (!(bl3 || bl2 || ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 9 || ammoType.getMunitionType() != 1024L)) {
                                                                                    n7 += 2;
                                                                                }
                                                                            }
                                                                        }
                                                                        if (bl15) {
                                                                            n5 = 0;
                                                                            n7 = 0;
                                                                            string = " inferno missile(s) ";
                                                                            n6 = 0;
                                                                        }
                                                                        if (bl8) {
                                                                            string = " swarm missile(s) ";
                                                                        }
                                                                        if (bl7) {
                                                                            string = " swarm-I missile(s) ";
                                                                        }
                                                                        if (bl9) {
                                                                            string = " anti-TSM missile(s) ";
                                                                        }
                                                                        if (bl14) {
                                                                            string = " fragmentation missile(s) ";
                                                                        }
                                                                        if (bl13) {
                                                                            n5 = 1;
                                                                            n7 = -2;
                                                                            string = " acid-head missile(s) ";
                                                                        }
                                                                        if (entity2.isSufferingEMI()) {
                                                                            n7 -= 2;
                                                                        }
                                                                        if (weaponType.getRackSize() != 30 && weaponType.getRackSize() != 40) break block369;
                                                                        n8 = Compute.missilesHit(weaponType.getRackSize() / 2, n12 + n13 + (entity2.isSufferingEMI() ? -2 : 0), bl19 | bl6) + Compute.missilesHit(weaponType.getRackSize() / 2, n12 + n13 + (entity2.isSufferingEMI() ? -2 : 0), bl19 | bl6);
                                                                        break block370;
                                                                    }
                                                                    if (!(entity2 instanceof BattleArmor)) break block371;
                                                                    infantry = (Infantry)entity2;
                                                                    if (!bl20) break block372;
                                                                    n8 = n11;
                                                                    break block370;
                                                                }
                                                                n8 = 0;
                                                                break block373;
                                                            }
                                                            if (bl20) {
                                                                n8 = weaponType.getRackSize();
                                                                break block370;
                                                            } else {
                                                                n8 = Compute.missilesHit(weaponType.getRackSize(), n7 + n12 + n13, bl19 | bl6, mounted.isHotLoaded());
                                                                if ((bl8 || bl7) && n2 == 0) {
                                                                    n9 = weaponType.getRackSize() - n8;
                                                                }
                                                            }
                                                            break block370;
                                                        }
                                                        if (!bl16 || ammoType.getAmmoType() != 19 && ammoType.getAmmoType() != 33 && ammoType.getAmmoType() != 48 || ammoType.getMunitionType() != 1L) break block374;
                                                        n6 = 1;
                                                        n8 = weaponType.getRackSize();
                                                        if (weaponType.getAmmoType() != 48) break block375;
                                                        if (n15 != 1) break block376;
                                                        n8 = 15;
                                                        break block377;
                                                    }
                                                    if (n15 != 2) break block378;
                                                    n8 = 10;
                                                    break block377;
                                                }
                                                if (n15 == 3) {
                                                    n8 = 5;
                                                    break block377;
                                                } else if (n15 == 4) {
                                                    n8 = 2;
                                                }
                                                break block377;
                                            }
                                            n8 = weaponType.getRackSize();
                                        }
                                        int n34 = n11 = weaponType.hasFlag(0x400000L) ? 0 : -1;
                                        if (!bl20) {
                                            n8 = !bl6 ? Compute.missilesHit(n8, n11 + (entity2.isSufferingEMI() ? -2 : 0)) : Compute.missilesHit(n8, n11 + (entity2.isSufferingEMI() ? -2 : 0)) / 2;
                                        }
                                        n5 = 1;
                                        break block365;
                                    }
                                    if (n16 <= 1) break block379;
                                    n6 = 1;
                                    n8 = n16;
                                    if (!bl20) {
                                        n8 = Compute.missilesHit(n8, entity2.isSufferingEMI() ? -2 : 0);
                                    }
                                    break block365;
                                }
                                if (weaponType.getAmmoType() != 22) break block380;
                                n5 = n15 <= weaponType.getShortRange() ? 25 : (n15 <= weaponType.getMediumRange() ? 20 : 10);
                                break block365;
                            }
                            if (!weaponType.hasFlag(262144L)) break block381;
                            n5 = weaponType.getDamage();
                            if (!this.game.getOptions().booleanOption("maxtech_altdmg")) break block365;
                            if (n15 > 1) break block382;
                            ++n5;
                            break block365;
                        }
                        if (n15 <= weaponType.getMediumRange()) break block365;
                        if (n15 <= weaponType.getLongRange()) {
                            --n5;
                            break block365;
                        } else if (n15 <= weaponType.getExtremeRange()) {
                            n5 = (int)Math.floor((double)n5 / 2.0);
                        }
                        break block365;
                    }
                    if (!mounted.isRapidfire() || targetable instanceof Infantry && !(targetable instanceof BattleArmor)) break block365;
                    n5 = Compute.d6();
                    n14 = 3 * n5;
                    if (entity2.getTotalAmmoOfType(mounted2.getType()) > 0) {
                        for (n11 = 0; n11 < n14; ++n11) {
                            if (mounted2.getShotsLeft() <= 0) {
                                entity2.loadWeapon(mounted);
                                mounted2 = mounted.getLinked();
                            }
                            mounted2.setShotsLeft(mounted2.getShotsLeft() - 1);
                        }
                        if (entity2 instanceof Mech) {
                            entity2.heatBuildup += n5;
                        }
                        break block365;
                    } else {
                        n8 = 0;
                    }
                    break block365;
                }
                for (n11 = weaponType.getRackSize() * infantry.getShootingStrength(); n11 > 20; n8 += Compute.missilesHit(20, n12 + n13 + (entity2.isSufferingEMI() ? -2 : 0), bl19 | bl6), n11 -= 20) {
                }
                n8 += Compute.missilesHit(n11, n12 + n13 + (entity2.isSufferingEMI() ? -2 : 0), bl19 | bl6);
            }
            if (bl9) {
                n8 = (int)Math.ceil((double)n8 / 2.0);
            }
            if ((bl8 || bl7) && n2 > 0) {
                n11 = 5;
                if (n2 > 5 && n2 <= 10) {
                    n11 = 10;
                } else if (n2 > 10 && n2 <= 15) {
                    n11 = 15;
                } else if (n2 > 15 && n2 <= 20) {
                    n11 = 20;
                }
                n8 = Compute.missilesHit(n11, n7 + n12 + n13, bl19 | bl6);
                if (n8 > n2) {
                    n8 = n2;
                }
                n9 = n2 - n8;
            }
            if (bl16 && ammoType.getAmmoType() == 24) {
                n11 = weaponType.getRackSize() * infantry.getShootingStrength();
                if (n8 % 2 == 1 && n8 < n11) {
                    ++n8;
                }
            }
        }
        if (weaponType.hasFlag(4L) && weaponType.hasFlag(0x400000L)) {
            entity2.heatBuildup += Compute.d6();
        }
        if (bl10) {
            --n5;
        }
        if (bl6 && !weaponType.hasFlag(524288L) && !weaponType.hasFlag(16384L) && (!bl16 || ammoType.getAmmoType() != 19 && ammoType.getAmmoType() != 33 && ammoType.getAmmoType() != 48 || ammoType.getMunitionType() != 1L)) {
            n5 = (int)Math.floor((double)n5 / 2.0);
        }
        if (weaponType.hasFlag(8192L)) {
            n8 *= 2;
        }
        if (bl16 && ammoType.getMunitionType() == 0x20000000L) {
            n5 = weaponType.getRackSize();
            if (entity != null && entity.getTaggedBy() != -1) {
                if (weaponResult.artyAttackerCoords != null) {
                    toHitData.setSideTable(entity.sideTable(weaponResult.artyAttackerCoords));
                } else {
                    Entity entity6 = this.game.getEntity(entity.getTaggedBy());
                    if (entity6 != null) {
                        toHitData.setSideTable(Compute.targetSideTable(entity6, (Targetable)entity));
                    }
                }
            }
        }
        if (bl4) {
            if (bl5 && building != null && !bl8 && !bl7) {
                if (weaponResult.amsShotDownTotal > 0) {
                    for (int i = 0; i < weaponResult.amsShotDown.length; ++i) {
                        int n35 = Math.min(weaponResult.amsShotDown[i], n8);
                        report = new Report(3280);
                        report.indent(1);
                        report.subject = n10;
                        report.add(n35);
                        this.addReport(report);
                    }
                    n8 -= weaponResult.amsShotDownTotal;
                }
                if (bl15 && n8 > 0) {
                    Coords coords = targetable.getPosition();
                    IHex iHex = this.game.getBoard().getHex(coords);
                    if (iHex.containsTerrain(7)) {
                        report = new Report(3285);
                        report.indent(2);
                        report.subject = n10;
                        report.add(n8);
                        report.add(coords.getBoardNum());
                        this.addReport(report);
                    } else {
                        report = new Report(3290);
                        report.indent(2);
                        report.subject = n10;
                        report.add(n8);
                        report.add(coords.getBoardNum());
                        this.addReport(report);
                        iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                    }
                    this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, n8);
                    this.sendChangedHex(coords);
                } else {
                    Report report2;
                    int n36 = n8 * n5;
                    if (bl14) {
                        n36 = 0;
                    }
                    if (n36 > 0 && (report2 = this.damageBuilding(building, n36)) != null) {
                        report2.indent(2);
                        report2.newlines = 1;
                        report2.subject = n10;
                        this.addReport(report2);
                    }
                }
            }
            if (bl4) return false;
            return true;
        }
        int n37 = 0;
        if (bl5 && building != null) {
            n37 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
        }
        if (!bl17 && entity2.getSwarmTargetId() == weaponResult.waa.getTargetId()) {
            n4 = n8;
        }
        if (weaponType.getAmmoType() == -2 && targetable instanceof Infantry && !(targetable instanceof BattleArmor)) {
            if (n37 > 0) {
                int n38 = n5 * n8;
                report = new Report(3295);
                report.newlines = 0;
                report.subject = n10;
                report.add(n8);
                report.add(string);
                this.addReport(report);
                Report report3 = this.damageBuilding(building, Math.min(n38, n37), " absorbs the shots, taking ");
                if (report3 != null) {
                    report3.newlines = 1;
                    report3.subject = n10;
                    this.addReport(report3);
                }
                if (bl4) return false;
                return true;
            }
            n5 = Compute.d6(n8);
            report = new Report(3300);
            report.newlines = 0;
            report.subject = n10;
            report.add(n5);
            report.add(string);
            this.addReport(report);
            n8 = 1;
        } else if (bl16 && ammoType.hasFlag(1L) && !bl17 && targetable instanceof Infantry && !(targetable instanceof BattleArmor) && !mounted.isRapidfire()) {
            n3 = weaponType.getDamage();
            if (n5 <= n37) {
                int n39 = n5 * n8;
                int n40 = building.getCurrentCF();
                n40 = Math.min(n40, n39);
                building.setCurrentCF(n40);
                if (n6 != 0) {
                    report = new Report(3305);
                    report.subject = n10;
                    report.add(n8);
                    report.add(string);
                    this.addReport(report);
                } else {
                    report = new Report(3310);
                    report.subject = n10;
                    this.addReport(report);
                }
                report = new Report(3315);
                report.indent(2);
                report.subject = n10;
                this.addReport(report);
                Report report4 = this.damageBuilding(building, Math.min(n39, n37), " absorbs the shots, taking ");
                if (report4 != null) {
                    report4.newlines = 1;
                    report4.subject = n10;
                    this.addReport(report4);
                }
                if (bl4) return false;
                return true;
            }
            if (n37 > 0) {
                n3 -= n37;
            }
            n5 = Compute.d6(n3);
            report = new Report(3320);
            report.subject = n10;
            report.add(n5);
            report.add(string);
            this.addReport(report);
            n6 = 1;
            if (n37 > 0) {
                Report report5 = this.damageBuilding(building, n37);
                if (report5 != null) {
                    report5.indent(2);
                    report5.subject = n10;
                    this.addReport(report5);
                }
                n37 = 0;
            }
        } else if (n6 != 0 && !bl15) {
            report = new Report(3325);
            report.subject = n10;
            report.add(n8);
            report.add(string);
            report.add(toHitData.getTableDesc());
            report.newlines = 0;
            this.addReport(report);
            if (bl3) {
                report = new Report(3330);
                report.subject = n10;
                report.newlines = 0;
                this.addReport(report);
            } else if (bl2) {
                report = new Report(3335);
                report.subject = n10;
                report.newlines = 0;
                this.addReport(report);
            }
            if (n7 > 0) {
                report = new Report(3340);
                report.subject = n10;
                report.add(n7);
                report.newlines = 0;
                this.addReport(report);
            }
            report = new Report(3345);
            report.subject = n10;
            report.newlines = 0;
            this.addReport(report);
            if (weaponResult.amsShotDownTotal > 0) {
                for (n3 = 0; n3 < weaponResult.amsShotDown.length; ++n3) {
                    int n41 = Math.min(weaponResult.amsShotDown[n3], n8);
                    report = new Report(3350);
                    report.indent();
                    report.subject = n10;
                    report.add(weaponResult.amsShotDown[n3]);
                    report.add(n41);
                    report.newlines = 0;
                    this.addReport(report);
                }
                this.addNewLines();
                if ((n8 -= weaponResult.amsShotDownTotal) < 1) {
                    report = new Report(3355);
                    report.indent();
                    report.subject = n10;
                    report.newlines = 0;
                    this.addReport(report);
                } else {
                    report = new Report(3360);
                    report.indent();
                    report.subject = n10;
                    report.add(n8);
                    report.newlines = 0;
                    this.addReport(report);
                }
            }
        }
        if (weaponType.getAmmoType() == 29) {
            n8 = n5 * n8;
            n5 = 1;
        }
        if (n8 == 0) {
            report = new Report(3365);
            report.subject = n10;
            this.addReport(report);
        }
        while (n8 > 0) {
            if (bl15) {
                if (weaponResult.amsShotDownTotal > 0) {
                    for (int i = 0; i < weaponResult.amsShotDown.length; ++i) {
                        int n42 = Math.min(weaponResult.amsShotDown[i], n8);
                        report = new Report(3350);
                        report.indent();
                        report.subject = n10;
                        report.add(weaponResult.amsShotDown[i]);
                        report.add(n42);
                        report.newlines = 0;
                        this.addReport(report);
                    }
                    this.addNewLines();
                    if ((n8 -= weaponResult.amsShotDownTotal) < 1) {
                        report = new Report(3355);
                        report.indent();
                        report.subject = n10;
                        report.newlines = 0;
                        this.addReport(report);
                    } else {
                        report = new Report(3360);
                        report.indent();
                        report.subject = n10;
                        report.add(n8);
                        report.newlines = 0;
                        this.addReport(report);
                    }
                    if (n8 <= 0) continue;
                }
                if (targetable.getTargetType() == 2 || targetable.getTargetType() == 4) {
                    report = new Report(3370);
                    report.subject = n10;
                    report.add(n8);
                    this.addReport(report);
                    Coords coords = targetable.getPosition();
                    IHex iHex = this.game.getBoard().getHex(coords);
                    if (!iHex.containsTerrain(7)) {
                        report = new Report(3005);
                        report.subject = n10;
                        report.add(coords.getBoardNum());
                        this.addReport(report);
                        iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                    }
                    this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, n8);
                    this.sendChangedHex(coords);
                    if (bl4) return false;
                    return true;
                }
                if (entity != null) {
                    report = new Report(3375);
                    report.subject = n10;
                    report.add(n8);
                    this.addReport(report);
                    if (this.game.getOptions().booleanOption("vehicle_fires") && entity instanceof Tank) {
                        this.checkForVehicleFire((Tank)entity, true);
                    } else {
                        entity.infernos.add(InfernoTracker.STANDARD_ROUND, n8);
                        report = new Report(3205);
                        report.indent(2);
                        report.subject = n10;
                        report.addDesc(entity);
                        report.add(entity.infernos.getTurnsLeftToBurn());
                        this.addReport(report);
                    }
                    Coords coords = targetable.getPosition();
                    IHex iHex = this.game.getBoard().getHex(coords);
                    if (!iHex.containsTerrain(7)) {
                        report = new Report(3005);
                        report.subject = n10;
                        report.add(coords.getBoardNum());
                        this.addReport(report);
                        iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                    }
                    this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, 1);
                    this.sendChangedHex(coords);
                    if (bl4) return false;
                    return true;
                }
            }
            if (targetable.getTargetType() == 2 || targetable.getTargetType() == 4) {
                if (n6 == 0) {
                    report = new Report(2270);
                    report.subject = n10;
                    report.newlines = 0;
                    this.addReport(report);
                }
                int n43 = weaponType.getFireTN();
                if (bl11) {
                    n43 = 5;
                }
                if (n43 != Integer.MAX_VALUE) {
                    if (building != null) {
                        n43 += building.getType() - 1;
                    }
                    this.addNewLines();
                    this.tryIgniteHex(targetable.getPosition(), entity2.getId(), bl15, n43, true);
                }
                if (bl4) return false;
                return true;
            }
            if (targetable.getTargetType() == 1) {
                n3 = n5 * n8;
                if (n6 == 0) {
                    report = new Report(2270);
                    report.subject = n10;
                    report.newlines = 0;
                    this.addReport(report);
                }
                if (entity2 instanceof Infantry) {
                    report = new Report(3380);
                    report.indent();
                    report.subject = n10;
                    this.addReport(report);
                    if (bl4) return false;
                    return true;
                }
                report = new Report(3385);
                report.indent();
                report.subject = n10;
                report.add(n3);
                this.addReport(report);
                if (building == null) {
                    boolean bl30 = this.game.getBoard().getHex(targetable.getPosition()).containsTerrain(7);
                    boolean bl31 = this.tryIgniteHex(targetable.getPosition(), n10, bl15, 9);
                    if (!bl30 && bl31) {
                        if (bl4) return false;
                        return true;
                    }
                }
                int n44 = 14 - n3;
                this.tryClearHex(targetable.getPosition(), n44, entity2.getId());
                if (bl4) return false;
                return true;
            }
            if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
                if (bl15) {
                    Coords coords = targetable.getPosition();
                    IHex iHex = this.game.getBoard().getHex(coords);
                    if (iHex.containsTerrain(7)) {
                        report = new Report(3285);
                        report.subject = n10;
                        report.add(n8);
                        report.add(coords.getBoardNum());
                        this.addReport(report);
                    } else {
                        report = new Report(3290);
                        report.subject = n10;
                        report.add(n8);
                        report.add(coords.getBoardNum());
                        this.addReport(report);
                        iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                    }
                    this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, n8);
                    this.sendChangedHex(coords);
                } else {
                    Report report6;
                    n3 = n5 * n8;
                    if (n6 == 0) {
                        report = new Report(3390);
                        report.subject = n10;
                        this.addReport(report);
                    }
                    this.addNewLines();
                    if (bl14) {
                        n3 = 0;
                        this.addReport(new Report(3565));
                    }
                    if ((report6 = this.damageBuilding(building, n3)) != null) {
                        report6.indent(2);
                        report6.newlines = 1;
                        report6.subject = n10;
                        this.addReport(report6);
                    }
                    this.damageInfantryIn(building, n3);
                }
                if (bl4) return false;
                return true;
            }
            if (weaponType.hasFlag(2L) && targetable instanceof BattleArmor) {
                for (Mounted mounted6 : entity.getMisc()) {
                    int n45;
                    Report report7;
                    EquipmentType equipmentType = mounted6.getType();
                    if (!"BA-Fire Resistant Armor".equals(equipmentType.getInternalName())) continue;
                    if (n6 == 0) {
                        report = new Report(3390);
                        report.subject = n10;
                        this.addReport(report);
                    }
                    report = new Report(3395);
                    report.indent(2);
                    report.subject = n10;
                    report.addDesc(entity);
                    this.addReport(report);
                    if (n37 > 0 && (report7 = this.damageBuilding(building, n45 = n5 * Math.min(n37, n8))) != null) {
                        report7.indent(2);
                        report7.newlines = 1;
                        report7.subject = n10;
                        this.addReport(report7);
                    }
                    if (bl4) return false;
                    return true;
                }
            }
            if (entity != null && entity instanceof Mech && weaponType.hasFlag(2L) && this.game.getOptions().booleanOption("flamer_heat") && weaponType.hasModes() && mounted.curMode().equals("Heat")) {
                n3 = n5 * n8;
                if (n6 == 0) {
                    report = new Report(3390);
                    report.subject = n10;
                    this.addReport(report);
                }
                report = new Report(3400);
                report.subject = n10;
                report.indent(2);
                report.add(n3);
                report.choose(true);
                report.newlines = 0;
                this.addReport(report);
                entity.heatBuildup += n3;
                n8 = 0;
                continue;
            }
            if (entity != null) {
                HitData hitData = entity.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable(), weaponResult.waa.getAimedLocation(), weaponResult.waa.getAimingMode());
                if (weaponType.hasFlag(0x20000000L) && entity instanceof Mech) {
                    n3 = n5 * n8;
                    if (n6 == 0) {
                        report = new Report(3390);
                        report.subject = n10;
                        this.addReport(report);
                    }
                    report = new Report(3400);
                    report.subject = n10;
                    report.indent(2);
                    report.add(5);
                    report.choose(true);
                    report.newlines = 0;
                    this.addReport(report);
                    entity.heatBuildup += 5;
                }
                if (weaponType.getInternalName().equals("LegAttack") && entity.getInternal(hitData) <= 0) {
                    hitData = hitData.getLocation() == 6 ? new HitData(7) : new HitData(6);
                }
                if (weaponType.getInternalName().equals("BAMineLauncher")) {
                    hitData = targetable instanceof Mech ? new HitData(1) : new HitData(1);
                }
                if (n6 == 0) {
                    report = new Report(3405);
                    report.subject = n10;
                    report.add(toHitData.getTableDesc());
                    report.add(entity.getLocationAbbr(hitData));
                    report.newlines = 0;
                    this.addReport(report);
                    if (hitData.hitAimedLocation()) {
                        report = new Report(3410);
                        report.subject = n10;
                        report.newlines = 0;
                        this.addReport(report);
                    }
                }
                if (n5 == -4) {
                    Vector vector = this.criticalEntity(entity, hitData.getLocation());
                    if (((Report)vector.lastElement()).messageId == 6005) {
                        int n46 = 4;
                        if (entity2 instanceof BattleArmor) {
                            n46 += ((BattleArmor)entity2).getVibroClawDamage();
                        }
                        vector = this.damageEntity(entity, hitData, n46, false, 0, false, false, bl18);
                    } else {
                        try {
                            ++((Report)vector.elementAt((int)(vector.size() - 2))).newlines;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            System.err.println("ERROR: no previous report when trying to add newline");
                        }
                    }
                    this.addReport(vector);
                } else if (this.game.getOptions().booleanOption("maxtech_partial_cover") && toHitData.getHitTable() == 6 && entity.removePartialCoverHits(hitData.getLocation(), toHitData.getCover(), toHitData.getSideTable())) {
                    report = new Report(3460);
                    report.subject = entity.getId();
                    report.indent(2);
                    report.add(entity.getDisplayName());
                    report.add(entity.getLocationAbbr(hitData));
                    report.newlines = 0;
                    this.addReport(report);
                } else {
                    n3 = n5 * Math.min(n4, n8);
                    if (n37 > 0) {
                        int n47 = Math.min(n37, n3);
                        n3 -= n47;
                        this.addNewLines();
                        Report report8 = this.damageBuilding(building, n47);
                        if (report8 != null) {
                            report8.indent(2);
                            report8.subject = n10;
                            this.addReport(report8);
                        }
                    }
                    if (n3 == 0) {
                        report = new Report(3415);
                        report.subject = n10;
                        report.indent(2);
                        report.addDesc(entity);
                        report.newlines = 0;
                        this.addReport(report);
                    } else if (bl14) {
                        if (bl6) {
                            hitData.makeGlancingBlow();
                        }
                        this.addReport(this.damageEntity(entity, hitData, n3, false, 1, false, false, bl18));
                    } else if (bl12) {
                        if (bl6) {
                            hitData.makeGlancingBlow();
                        }
                        this.addReport(this.damageEntity(entity, hitData, n3, false, 2, false, false, bl18));
                    } else if (bl13) {
                        if (bl6) {
                            hitData.makeGlancingBlow();
                        }
                        this.addReport(this.damageEntity(entity, hitData, n3, false, 3, false, false, bl18));
                    } else if (bl11) {
                        if (bl6) {
                            hitData.makeGlancingBlow();
                        }
                        this.addReport(this.damageEntity(entity, hitData, n3, false, 4, false, false, bl18));
                    } else if (weaponType.hasFlag(0x200000L)) {
                        if (bl6) {
                            hitData.makeGlancingBlow();
                        }
                        this.addReport(this.damageEntity(entity, hitData, n3, false, 5, false, false, bl18));
                    } else if (weaponType.hasFlag(0x80000000L) && this.game.getOptions().booleanOption("maxtech_infantry_damage")) {
                        if (bl6) {
                            hitData.makeGlancingBlow();
                        }
                        this.addReport(this.damageEntity(entity, hitData, n3, false, 6, false, false, bl18));
                    } else {
                        if (bl16 && (ammoType.getAmmoType() == 1 || ammoType.getAmmoType() == 35) && ammoType.getMunitionType() == 2L && entity.getArmorType() != 4) {
                            hitData.makeArmorPiercing(ammoType);
                        }
                        if (bl6) {
                            hitData.makeGlancingBlow();
                        }
                        if (bl9) {
                            entity.hitThisRoundByAntiTSM = true;
                        }
                        this.addReport(this.damageEntity(entity, hitData, n3, false, 0, false, false, bl18));
                    }
                }
                n8 -= n4;
                continue;
            }
            System.err.println(new StringBuffer().append("Unable to resolve hit against ").append(targetable.getDisplayName()).toString());
            if (entity == null) {
                System.err.println("   entityTarget is null");
            }
            n8 = 0;
        }
        if (ammoType != null && ammoType.getMunitionType() == 0x20000000L) {
            this.artilleryDamageHex(targetable.getPosition(), weaponResult.artyAttackerCoords, 5, ammoType, n10, entity2, entity, false, 0);
        }
        this.addNewLines();
        if (weaponType.hasFlag(0x200000L)) {
            this.tryIgniteHex(entity.getPosition(), entity2.getId(), false, weaponType.getFireTN(), true);
        }
        if (n9 > 0 && entity != null) {
            Entity entity7 = Compute.getSwarmTarget(this.game, entity2.getId(), entity, weaponResult.waa.getWeaponId());
            if (entity7 != null) {
                report = new Report(3420);
                report.subject = entity7.getId();
                report.indent();
                report.add(n9);
                this.addReport(report);
                mounted.setUsedThisRound(false);
                WeaponAttackAction weaponAttackAction = new WeaponAttackAction(entity2.getId(), entity7.getTargetId(), weaponResult.waa.getWeaponId());
                weaponAttackAction.setSwarmingMissiles(true);
                weaponAttackAction.setOldTargetId(targetable.getTargetId());
                weaponAttackAction.setAmmoId(weaponResult.waa.getAmmoId());
                WeaponResult weaponResult4 = this.preTreatWeaponAttack(weaponAttackAction);
                this.resolveWeaponAttack(weaponResult4, entity2.getId(), false, n9);
            } else {
                report = new Report(3425);
                report.subject = entity2.getId();
                report.indent();
                this.addReport(report);
            }
        }
        this.creditKill(entity, entity2);
        if (bl4) return false;
        return true;
    }

    private void resolvePhysicalAttacks() {
        Object object;
        Object object2;
        this.addReport(new Report(4000, 0));
        Enumeration enumeration = this.game.getCharges();
        while (enumeration.hasMoreElements()) {
            this.game.addAction((EntityAction)enumeration.nextElement());
        }
        this.game.resetCharges();
        this.cleanupPhysicalAttacks();
        enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = (AttackAction)object2;
            if (!this.game.getEntity(object.getEntityId()).isActive() && !(object2 instanceof DfaAttackAction)) continue;
            AbstractAttackAction abstractAttackAction = (AbstractAttackAction)object2;
            if (abstractAttackAction instanceof SearchlightAttackAction) {
                SearchlightAttackAction searchlightAttackAction = (SearchlightAttackAction)abstractAttackAction;
                this.addReport(searchlightAttackAction.resolveAction(this.game));
                continue;
            }
            this.physicalResults.addElement(this.preTreatPhysicalAttack(abstractAttackAction));
        }
        int n = -1;
        object2 = this.physicalResults.elements();
        while (object2.hasMoreElements()) {
            object = (PhysicalResult)object2.nextElement();
            this.resolvePhysicalAttack((PhysicalResult)object, n);
            n = ((PhysicalResult)object).aaa.getEntityId();
        }
        this.physicalResults.removeAllElements();
    }

    private void cleanupPhysicalAttacks() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            this.removeDuplicateAttacks(entity.getId());
        }
        this.removeDeadAttacks();
    }

    private void removeDuplicateAttacks(int n) {
        boolean bl = false;
        Vector<EntityAction> vector = new Vector<EntityAction>();
        Enumeration enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            EntityAction entityAction = (EntityAction)enumeration.nextElement();
            if (entityAction.getEntityId() != n) {
                vector.addElement(entityAction);
                continue;
            }
            if (!bl) {
                vector.addElement(entityAction);
                if (entityAction instanceof SearchlightAttackAction) continue;
                bl = true;
                continue;
            }
            System.err.println(new StringBuffer().append("server: removing duplicate phys attack for id#").append(n).toString());
            System.err.println(new StringBuffer().append("        action was ").append(entityAction.toString()).toString());
        }
        this.game.resetActions();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.game.addAction((EntityAction)enumeration.nextElement());
        }
    }

    private void removeDeadAttacks() {
        Vector<EntityAction> vector = new Vector<EntityAction>(this.game.actionsSize());
        Enumeration enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            EntityAction entityAction = (EntityAction)enumeration.nextElement();
            Entity entity = this.game.getEntity(entityAction.getEntityId());
            if (entity == null || entity.isDestroyed() || !entity.isActive() && !(entityAction instanceof DfaAttackAction)) continue;
            vector.addElement(entityAction);
        }
        this.game.resetActions();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.game.addAction((EntityAction)enumeration.nextElement());
        }
    }

    private void resolvePunchAttack(PhysicalResult physicalResult, int n) {
        int n2;
        Report report;
        PunchAttackAction punchAttackAction = (PunchAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(punchAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(punchAttackAction.getTargetType(), punchAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, punchAttackAction.getEntityId(), entity2);
        }
        String string = punchAttackAction.getArm() == 1 ? "Left Arm" : "Right Arm";
        int n3 = punchAttackAction.getArm() == 1 ? physicalResult.damage : physicalResult.damageRight;
        ToHitData toHitData = punchAttackAction.getArm() == 1 ? physicalResult.toHit : physicalResult.toHitRight;
        int n4 = punchAttackAction.getArm() == 1 ? physicalResult.roll : physicalResult.rollRight;
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n4 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        if (n != punchAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4010);
        report.subject = entity.getId();
        report.indent();
        report.add(string);
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4015);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4020);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.addReport(report);
            n4 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n4);
            report.newlines = 0;
            this.addReport(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n4 < toHitData.getValue()) {
            Report report2;
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            if (bl2 && building != null && n3 > 0 && (report2 = this.damageBuilding(building, n3)) != null) {
                report2.indent();
                report2.subject = entity.getId();
                this.addReport(report2);
            }
            return;
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Report report3 = this.damageBuilding(building, n3);
            if (report3 != null) {
                report3.indent();
                report3.newlines = 1;
                report3.subject = entity.getId();
                this.addReport(report3);
            }
            this.damageInfantryIn(building, n3);
            return;
        }
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        report = new Report(4045);
        report.subject = entity.getId();
        report.add(toHitData.getTableDesc());
        report.add(entity2.getLocationAbbr(hitData));
        report.newlines = 0;
        this.addReport(report);
        if (bl2 && building != null) {
            n2 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
            int n5 = Math.min(n2, n3);
            n3 -= n5;
            this.addNewLines();
            Report report4 = this.damageBuilding(building, n5);
            if (report4 != null) {
                report4.indent();
                report4.subject = entity.getId();
                this.addReport(report4);
            }
        }
        if (n3 == 0) {
            report = new Report(4050);
            report.subject = entity.getId();
            report.add(entity2.getShortName());
            report.add(entity2.getOwner().getName());
            report.newlines = 0;
            this.addReport(report);
        } else {
            if (bl3) {
                n3 = (int)Math.floor((double)n3 / 2.0);
            }
            if (n3 >= 1 && entity2.hasWorkingMisc(0x400000000L, -1, hitData.getLocation())) {
                report = new Report(4330);
                report.indent(2);
                report.newlines = 0;
                report.subject = entity.getId();
                this.addReport(report);
                this.checkBreakSpikes(entity2, hitData.getLocation());
                n3 = Math.max(1, n3 - 4);
                HitData hitData2 = punchAttackAction.getArm() == 1 ? new HitData(5) : new HitData(4);
                this.addReport(this.damageEntity(entity, hitData2, 2, false, 0, false, false, false));
            }
            n2 = 0;
            if (this.game.getOptions().booleanOption("maxtech_infantry_damage")) {
                n2 = 6;
            }
            this.addReport(this.damageEntity(entity2, hitData, n3, false, n2, false, false, bl));
        }
        this.addNewLines();
    }

    private void resolveKickAttack(PhysicalResult physicalResult, int n) {
        int n2;
        Report report;
        String string;
        KickAttackAction kickAttackAction = (KickAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(kickAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(kickAttackAction.getTargetType(), kickAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, kickAttackAction.getEntityId(), entity2);
        }
        String string2 = string = kickAttackAction.getLeg() == 1 || kickAttackAction.getLeg() == 3 ? "Left " : "Right ";
        if (this.game.getOptions().booleanOption("maxtech_mulekicks")) {
            if (kickAttackAction.getLeg() == 3 || kickAttackAction.getLeg() == 4) {
                string.concat(" rear ");
            } else {
                string.concat(" front ");
            }
        }
        string.concat("leg");
        int n3 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n4 = physicalResult.roll;
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n4 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        if (n != entity.getId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4055);
        report.subject = entity.getId();
        report.indent();
        report.add(string);
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4060);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a kick"));
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4065);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.addReport(report);
            n4 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n4);
            report.newlines = 0;
            this.addReport(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n4 < toHitData.getValue()) {
            Report report2;
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a kick"));
            if (bl2 && building != null && n3 > 0 && (report2 = this.damageBuilding(building, n3)) != null) {
                report2.indent();
                report2.subject = entity.getId();
                this.addReport(report2);
            }
            return;
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Report report3 = this.damageBuilding(building, n3);
            if (report3 != null) {
                report3.indent();
                report3.subject = entity.getId();
                this.addReport(report3);
            }
            this.damageInfantryIn(building, n3);
            return;
        }
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        report = new Report(4045);
        report.subject = entity.getId();
        report.add(toHitData.getTableDesc());
        report.add(entity2.getLocationAbbr(hitData));
        report.newlines = 0;
        this.addReport(report);
        if (bl2 && building != null) {
            n2 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
            int n5 = Math.min(n2, n3);
            n3 -= n5;
            this.addNewLines();
            Report report4 = this.damageBuilding(building, n5);
            if (report4 != null) {
                report4.indent();
                report4.subject = entity.getId();
                this.addReport(report4);
            }
        }
        if (n3 == 0) {
            report = new Report(4050);
            report.subject = entity.getId();
            report.add(entity2.getShortName());
            report.add(entity2.getOwner().getName());
            report.newlines = 0;
            this.addReport(report);
        } else {
            if (bl3) {
                n3 = (int)Math.floor((double)n3 / 2.0);
            }
            if (n3 >= 1 && entity2.hasWorkingMisc(0x400000000L, -1, hitData.getLocation())) {
                HitData hitData2;
                report = new Report(4330);
                report.indent(2);
                report.newlines = 0;
                report.subject = entity.getId();
                this.addReport(report);
                this.checkBreakSpikes(entity2, hitData.getLocation());
                n3 = Math.max(1, n3 - 4);
                switch (kickAttackAction.getLeg()) {
                    case 1: {
                        if (entity instanceof QuadMech) {
                            hitData2 = new HitData(5);
                            break;
                        }
                        hitData2 = new HitData(7);
                        break;
                    }
                    case 2: {
                        if (entity instanceof QuadMech) {
                            hitData2 = new HitData(4);
                            break;
                        }
                        hitData2 = new HitData(6);
                        break;
                    }
                    case 3: {
                        hitData2 = new HitData(7);
                        break;
                    }
                    default: {
                        hitData2 = new HitData(6);
                    }
                }
                this.addReport(this.damageEntity(entity, hitData2, 2, false, 0, false, false, false));
            }
            n2 = 0;
            if (this.game.getOptions().booleanOption("maxtech_infantry_damage")) {
                n2 = 6;
            }
            this.addReport(this.damageEntity(entity2, hitData, n3, false, n2, false, false, bl));
        }
        if (entity2.getMovementMode() == 1 || entity2.getMovementMode() == 2) {
            PilotingRollData pilotingRollData = new PilotingRollData(entity2.getId(), this.getKickPushPSRMod(entity, entity2, 0), "was kicked");
            pilotingRollData.setCumulative(false);
            this.game.addPSR(pilotingRollData);
        }
        this.addNewLines();
    }

    private void resolveJumpJetAttack(PhysicalResult physicalResult, int n) {
        Report report;
        JumpJetAttackAction jumpJetAttackAction = (JumpJetAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(jumpJetAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(jumpJetAttackAction.getTargetType(), jumpJetAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, jumpJetAttackAction.getEntityId(), entity2);
        }
        String string = null;
        switch (jumpJetAttackAction.getLeg()) {
            case 1: {
                string = "Left leg";
                break;
            }
            case 2: {
                string = "Right leg";
                break;
            }
            default: {
                string = "Both legs";
            }
        }
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        if (n != entity.getId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4290);
        report.subject = entity.getId();
        report.indent();
        report.add(string);
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4075);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4080);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.addReport(report);
            n3 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            Report report2;
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            if (bl2 && building != null && (n2 += physicalResult.damageRight) > 0 && (report2 = this.damageBuilding(building, n2)) != null) {
                report2.indent();
                report2.subject = entity.getId();
                this.addReport(report2);
            }
            return;
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Report report3 = this.damageBuilding(building, n2 += physicalResult.damageRight);
            if (report3 != null) {
                report3.indent();
                report3.subject = entity.getId();
                this.addReport(report3);
            }
            this.damageInfantryIn(building, n2);
            return;
        }
        report = new Report(4040);
        report.subject = entity.getId();
        report.newlines = 0;
        this.addReport(report);
        for (int i = 0; i < 2 && (i != 1 || (n2 = physicalResult.damageRight) != 0); ++i) {
            HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            if (bl2 && building != null) {
                int n4 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
                int n5 = Math.min(n4, n2);
                n2 -= n5;
                this.addNewLines();
                Report report4 = this.damageBuilding(building, n5);
                if (report4 != null) {
                    report4.indent();
                    report4.subject = entity.getId();
                    this.addReport(report4);
                }
            }
            if (n2 == 0) {
                report = new Report(4050);
                report.subject = entity.getId();
                report.add(entity2.getShortName());
                report.add(entity2.getOwner().getName());
                report.newlines = 0;
                this.addReport(report);
                continue;
            }
            if (bl3) {
                n2 = (int)Math.floor((double)n2 / 2.0);
            }
            this.addReport(this.damageEntity(entity2, hitData, n2, false, 0, false, false, bl));
        }
        this.addNewLines();
    }

    private void resolveProtoAttack(PhysicalResult physicalResult, int n) {
        Report report;
        ProtomechPhysicalAttackAction protomechPhysicalAttackAction = (ProtomechPhysicalAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(protomechPhysicalAttackAction.getEntityId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        Targetable targetable = this.game.getTarget(protomechPhysicalAttackAction.getTargetType(), protomechPhysicalAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, protomechPhysicalAttackAction.getEntityId(), entity2);
        }
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        if (n != entity.getId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4070);
        report.subject = entity.getId();
        report.indent();
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4075);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4080);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.addReport(report);
            n3 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            Report report2;
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            if (bl2 && building != null && n2 > 0 && (report2 = this.damageBuilding(building, n2)) != null) {
                report2.indent();
                report2.subject = entity.getId();
                this.addReport(report2);
            }
            return;
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Report report3 = this.damageBuilding(building, n2);
            if (report3 != null) {
                report3.indent();
                report3.subject = entity.getId();
                this.addReport(report3);
            }
            this.damageInfantryIn(building, n2);
            return;
        }
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        report = new Report(4045);
        report.subject = entity.getId();
        report.add(toHitData.getTableDesc());
        report.add(entity2.getLocationAbbr(hitData));
        report.newlines = 0;
        this.addReport(report);
        if (bl2 && building != null) {
            int n4 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
            int n5 = Math.min(n4, n2);
            n2 -= n5;
            this.addNewLines();
            Report report4 = this.damageBuilding(building, n5);
            if (report4 != null) {
                report4.indent();
                report4.subject = entity.getId();
                this.addReport(report4);
            }
        }
        if (n2 == 0) {
            report = new Report(4050);
            report.subject = entity.getId();
            report.add(entity2.getShortName());
            report.add(entity2.getOwner().getName());
            report.newlines = 0;
            this.addReport(report);
        } else {
            if (bl3) {
                n2 = (int)Math.floor((double)n2 / 2.0);
            }
            this.addReport(this.damageEntity(entity2, hitData, n2, false, 0, false, false, bl));
        }
        this.addNewLines();
    }

    private void resolveBrushOffAttack(PhysicalResult physicalResult, int n) {
        Report report;
        int n2;
        String string;
        BrushOffAttackAction brushOffAttackAction = (BrushOffAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(brushOffAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(brushOffAttackAction.getTargetType(), brushOffAttackAction.getTargetId());
        Entity entity2 = null;
        String string2 = string = brushOffAttackAction.getArm() == 1 ? "Left Arm" : "Right Arm";
        if (targetable.getTargetType() == 0) {
            entity2 = this.game.getEntity(brushOffAttackAction.getTargetId());
        }
        int n3 = brushOffAttackAction.getArm() == 1 ? physicalResult.damage : physicalResult.damageRight;
        ToHitData toHitData = brushOffAttackAction.getArm() == 1 ? physicalResult.toHit : physicalResult.toHitRight;
        int n4 = n2 = brushOffAttackAction.getArm() == 1 ? physicalResult.roll : physicalResult.rollRight;
        if (n != brushOffAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4085);
        report.subject = entity.getId();
        report.indent();
        report.add(targetable.getDisplayName());
        report.add(string);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4090);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        report = new Report(4025);
        report.subject = entity.getId();
        report.add(toHitData.getValue());
        report.add(n2);
        report.newlines = 0;
        this.addReport(report);
        if (n2 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            toHitData.setHitTable(1);
            toHitData.setSideTable(0);
            HitData hitData = entity.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            report = new Report(4095);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.getLocationAbbr(hitData));
            report.newlines = 0;
            this.addReport(report);
            this.addReport(this.damageEntity(entity, hitData, n3));
            this.addNewLines();
            return;
        }
        switch (targetable.getTargetType()) {
            case 0: {
                HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
                report = new Report(4045);
                report.subject = entity.getId();
                report.add(toHitData.getTableDesc());
                report.add(entity2.getLocationAbbr(hitData));
                report.newlines = 0;
                this.addReport(report);
                this.addReport(this.damageEntity(entity2, hitData, n3));
                this.addNewLines();
                entity.setSwarmAttackerId(-1);
                entity2.setSwarmTargetId(-1);
                report = new Report(4100);
                report.subject = entity.getId();
                report.add(entity2.getDisplayName());
                this.addReport(report);
                break;
            }
            case 11: {
                entity.removeINarcPod((INarcPod)targetable);
                report = new Report(4105);
                report.subject = entity.getId();
                report.add(targetable.getDisplayName());
                this.addReport(report);
            }
        }
    }

    private void resolveThrashAttack(PhysicalResult physicalResult, int n) {
        Report report;
        ThrashAttackAction thrashAttackAction = (ThrashAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(thrashAttackAction.getEntityId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        boolean bl = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Entity entity2 = this.game.getEntity(thrashAttackAction.getTargetId());
        if (n != thrashAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4110);
        report.subject = entity.getId();
        report.indent();
        report.addDesc(entity2);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4115);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4120);
            report.subject = entity.getId();
            report.newlines = 0;
            this.addReport(report);
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (n3 < toHitData.getValue()) {
                report = new Report(4035);
                report.subject = entity.getId();
                this.addReport(report);
                return;
            }
            report = new Report(4125);
            report.subject = entity.getId();
            report.newlines = 0;
            this.addReport(report);
        }
        if (bl) {
            n2 = (int)Math.floor((double)n2 / 2.0);
        }
        report = new Report(4130);
        report.subject = entity.getId();
        report.add(n2);
        report.newlines = 0;
        this.addReport(report);
        if (bl) {
            report = new Report(4030);
            report.subject = entity.getId();
            report.newlines = 0;
            this.addReport(report);
        }
        while (n2 > 0) {
            int n4 = Math.min(5, n2);
            n2 -= n4;
            HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            report = new Report(4135);
            report.subject = entity.getId();
            report.add(entity2.getLocationAbbr(hitData));
            report.newlines = 0;
            this.addReport(report);
            this.addReport(this.damageEntity(entity2, hitData, n4));
        }
        this.addNewLines();
        PilotingRollData pilotingRollData = entity.getBasePilotingRoll();
        entity.addPilotingModifierForTerrain(pilotingRollData);
        pilotingRollData.addModifier(0, "thrashing at infantry");
        report = new Report(4140);
        report.subject = entity.getId();
        report.addDesc(entity);
        this.addReport(report);
        int n5 = Compute.d6(2);
        report = new Report(2190);
        report.subject = entity.getId();
        report.add(pilotingRollData.getValueAsString());
        report.add(pilotingRollData.getDesc());
        report.add(n5);
        if (n5 < pilotingRollData.getValue()) {
            report.choose(false);
            this.addReport(report);
            this.doEntityFall(entity, pilotingRollData);
        } else {
            report.choose(true);
            this.addReport(report);
        }
    }

    private void resolveClubAttack(PhysicalResult physicalResult, int n) {
        int n2;
        Report report;
        ClubAttackAction clubAttackAction = (ClubAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(clubAttackAction.getEntityId());
        int n3 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n4 = physicalResult.roll;
        Targetable targetable = this.game.getTarget(clubAttackAction.getTargetType(), clubAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, clubAttackAction.getEntityId(), entity2);
        }
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n4 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        clubAttackAction.getClub().restore();
        if (((MiscType)clubAttackAction.getClub().getType()).isShield()) {
            ((Mech)entity).shieldAbsorptionDamage(1, clubAttackAction.getClub().getLocation(), false);
        }
        if (n != clubAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4145);
        report.subject = entity.getId();
        report.indent();
        report.add(clubAttackAction.getClub().getName());
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if ((((MiscType)clubAttackAction.getClub().getType()).hasSubType(256) || ((MiscType)clubAttackAction.getClub().getType()).hasSubType(131072)) && n4 == 2) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            ToHitData toHitData2 = new ToHitData(Integer.MIN_VALUE, "hit with own flail/wrecking ball");
            physicalResult.damage /= 2;
            toHitData2.setHitTable(0);
            toHitData2.setSideTable(0);
            physicalResult.toHit = toHitData2;
            physicalResult.aaa.setTargetId(entity.getId());
            physicalResult.aaa.setTargetType(0);
            physicalResult.roll = Integer.MAX_VALUE;
            this.resolveClubAttack(physicalResult, entity.getId());
            this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a flail/wrecking ball attack"));
            return;
        }
        if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(0x400000)) {
            n3 = Compute.d6(2);
            entity.heatBuildup += 3;
            if (n4 == 2) {
                Mounted mounted = clubAttackAction.getClub();
                for (Mounted mounted2 : entity.getWeaponList()) {
                    if (mounted2.getLocation() != mounted.getLocation() || !(mounted2.getType() instanceof MiscType) || !((MiscType)mounted2.getType()).hasFlag(0x8000000L) || !((MiscType)mounted2.getType()).hasSubType(0x400000)) continue;
                    mounted2.setDestroyed(true);
                    break;
                }
                report = new Report(4037);
                report.subject = entity.getId();
                this.addReport(report);
                n3 = 0;
                return;
            }
        }
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4075);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(16)) {
                this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a mace attack"));
            }
            if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(64)) {
                this.game.addPSR(new PilotingRollData(entity.getId(), 2, "missed a mace attack"));
            }
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4080);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.addReport(report);
            n4 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n4);
            report.newlines = 0;
            this.addReport(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n4 < toHitData.getValue()) {
            Report report2;
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(16)) {
                this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a mace attack"));
            }
            if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(64)) {
                this.game.addPSR(new PilotingRollData(entity.getId(), 2, "missed a mace attack"));
            }
            if (bl2 && building != null && n3 > 0 && (report2 = this.damageBuilding(building, n3)) != null) {
                report2.indent();
                report2.subject = entity.getId();
                this.addReport(report2);
            }
            return;
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Report report3 = this.damageBuilding(building, n3);
            if (report3 != null) {
                report3.indent();
                report3.subject = entity.getId();
                this.addReport(report3);
            }
            this.damageInfantryIn(building, n3);
            return;
        }
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        report = new Report(4045);
        report.subject = entity.getId();
        report.add(toHitData.getTableDesc());
        report.add(entity2.getLocationAbbr(hitData));
        report.newlines = 0;
        this.addReport(report);
        if (bl2 && building != null) {
            n2 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
            int n5 = Math.min(n2, n3);
            n3 -= n5;
            this.addNewLines();
            Report report4 = this.damageBuilding(building, n5);
            if (report4 != null) {
                report4.indent();
                report4.subject = entity.getId();
                this.addReport(report4);
            }
        }
        if (n3 == 0) {
            report = new Report(4050);
            report.subject = entity.getId();
            report.add(entity2.getShortName());
            report.add(entity2.getOwner().getName());
            report.newlines = 0;
            this.addReport(report);
        } else {
            if (bl3) {
                n3 = (int)Math.floor((double)n3 / 2.0);
            }
            if (n3 >= 1 && entity2.hasWorkingMisc(0x400000000L, -1, hitData.getLocation())) {
                report = new Report(4330);
                report.indent(2);
                report.newlines = 0;
                report.subject = entity.getId();
                this.addReport(report);
                this.checkBreakSpikes(entity2, hitData.getLocation());
                n3 = Math.max(1, n3 - 4);
                n2 = clubAttackAction.getClub().getLocation();
                if (n2 == -1) {
                    this.addReport(this.damageEntity(entity, new HitData(5), 1, false, 0, false, false, false));
                    this.addReport(this.damageEntity(entity, new HitData(4), 1, false, 0, false, false, false));
                } else {
                    this.addReport(this.damageEntity(entity, new HitData(n2), 2, false, 0, false, false, false));
                }
            }
            n2 = 0;
            if (this.game.getOptions().booleanOption("maxtech_infantry_damage")) {
                n2 = 6;
            }
            this.addReport(this.damageEntity(entity2, hitData, n3, false, n2, false, false, bl));
        }
        if (entity2 != null && ((MiscType)clubAttackAction.getClub().getType()).hasSubType(8192) && entity2.getArmor(hitData) > 0 && entity2.getArmorType() != 4) {
            n4 = Compute.d6(2);
            report = new Report(4021);
            report.indent(2);
            report.subject = entity.getId();
            report.add(entity2.getLocationAbbr(hitData));
            report.add(n4);
            report.newlines = 1;
            this.addReport(report);
            if (n4 >= 10) {
                hitData.makeGlancingBlow();
                this.addReport(this.damageEntity(entity2, hitData, 1, false, 0, true, false, bl));
            }
        }
        this.addNewLines();
        if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(2)) {
            report = new Report(4150);
            report.subject = entity.getId();
            report.add(clubAttackAction.getClub().getName());
            this.addReport(report);
            entity.removeMisc(clubAttackAction.getClub().getName());
        }
    }

    private void resolvePushAttack(PhysicalResult physicalResult, int n) {
        Serializable serializable;
        Report report;
        PushAttackAction pushAttackAction = (PushAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(pushAttackAction.getEntityId());
        Entity entity2 = this.game.getEntity(pushAttackAction.getTargetId());
        int n2 = physicalResult.roll;
        ToHitData toHitData = physicalResult.toHit;
        if (physicalResult.pushBackResolved) {
            return;
        }
        physicalResult.pushBackResolved = true;
        if (n != pushAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4155);
        report.subject = entity.getId();
        report.indent();
        report.addDesc(entity2);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4160);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        report = new Report(4025);
        report.subject = entity.getId();
        report.add(toHitData.getValue());
        report.add(n2);
        report.newlines = 0;
        this.addReport(report);
        Serializable serializable2 = null;
        Object object = this.physicalResults.elements();
        while (object.hasMoreElements()) {
            serializable = (PhysicalResult)object.nextElement();
            if (((PhysicalResult)serializable).aaa.getEntityId() != entity2.getId() || !(((PhysicalResult)serializable).aaa instanceof PushAttackAction) || ((PhysicalResult)serializable).aaa.getTargetId() != entity.getId()) continue;
            serializable2 = serializable;
        }
        if (serializable2 != null && !((PhysicalResult)serializable2).pushBackResolved && n2 >= toHitData.getValue()) {
            ((PhysicalResult)serializable2).pushBackResolved = true;
            if (((PhysicalResult)serializable2).roll >= ((PhysicalResult)serializable2).toHit.getValue()) {
                report = new Report(4165);
                report.subject = entity.getId();
                report.addDesc(entity2);
                report.addDesc(entity2);
                report.addDesc(entity);
                report.add(((PhysicalResult)serializable2).toHit.getValue());
                report.add(((PhysicalResult)serializable2).roll);
                report.addDesc(entity);
                this.addReport(report);
                object = new PilotingRollData(entity2.getId(), this.getKickPushPSRMod(entity, entity2, 0), "was pushed");
                ((PilotingRollData)object).setCumulative(false);
                serializable = new PilotingRollData(entity.getId(), this.getKickPushPSRMod(entity, entity2, 0), "was pushed");
                ((PilotingRollData)serializable).setCumulative(false);
                this.game.addPSR((PilotingRollData)serializable);
                this.game.addPSR((PilotingRollData)object);
                return;
            }
            report = new Report(4166);
            report.subject = entity.getId();
            report.addDesc(entity2);
            report.addDesc(entity);
            report.add(((PhysicalResult)serializable2).toHit.getValue());
            report.add(((PhysicalResult)serializable2).roll);
            this.addReport(report);
        }
        if (n2 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            return;
        }
        int n3 = entity.getFacing();
        serializable = entity2.getPosition();
        Coords coords = ((Coords)serializable).translated(n3);
        PilotingRollData pilotingRollData = new PilotingRollData(entity2.getId(), this.getKickPushPSRMod(entity, entity2, 0), "was pushed");
        pilotingRollData.setCumulative(false);
        if (Compute.isValidDisplacement(this.game, entity2.getId(), entity2.getPosition(), n3)) {
            report = new Report(4170);
            report.subject = entity.getId();
            report.newlines = 0;
            this.addReport(report);
            if (this.game.getBoard().contains(coords)) {
                report = new Report(4175);
                report.subject = entity.getId();
                report.add(coords.getBoardNum(), true);
                this.addReport(report);
            } else {
                report = new Report(4180);
                report.subject = entity.getId();
                this.addReport(report);
            }
            this.doEntityDisplacement(entity2, (Coords)serializable, coords, pilotingRollData);
            if (!entity2.getPosition().equals(serializable)) {
                entity.setPosition((Coords)serializable);
            }
        } else {
            report = new Report(4185);
            report.subject = entity.getId();
            this.addReport(report);
            this.game.addPSR(pilotingRollData);
        }
        this.addNewLines();
    }

    private void resolveTripAttack(PhysicalResult physicalResult, int n) {
        Report report;
        TripAttackAction tripAttackAction = (TripAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(tripAttackAction.getEntityId());
        Entity entity2 = this.game.getEntity(tripAttackAction.getTargetId());
        int n2 = physicalResult.roll;
        ToHitData toHitData = physicalResult.toHit;
        if (n != tripAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4280);
        report.subject = entity.getId();
        report.indent();
        report.addDesc(entity2);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4285);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        report = new Report(4025);
        report.subject = entity.getId();
        report.add(toHitData.getValue());
        report.add(n2);
        report.newlines = 0;
        this.addReport(report);
        if (n2 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            return;
        }
        PilotingRollData pilotingRollData = new PilotingRollData(entity2.getId(), this.getKickPushPSRMod(entity, entity2, 0), "was tripped");
        pilotingRollData.setCumulative(false);
        this.game.addPSR(pilotingRollData);
        report = new Report(4040);
        report.subject = entity.getId();
        this.addReport(report);
        this.addNewLines();
    }

    private void resolveGrappleAttack(PhysicalResult physicalResult, int n) {
        Report report;
        GrappleAttackAction grappleAttackAction = (GrappleAttackAction)physicalResult.aaa;
        Mech mech = (Mech)this.game.getEntity(grappleAttackAction.getEntityId());
        Mech mech2 = (Mech)this.game.getEntity(grappleAttackAction.getTargetId());
        int n2 = physicalResult.roll;
        ToHitData toHitData = physicalResult.toHit;
        if (physicalResult.pushBackResolved) {
            return;
        }
        if (mech2.getGrappled() != -1 || mech.getGrappled() != -1) {
            toHitData.addModifier(Integer.MAX_VALUE, "Already Grappled");
        }
        if (n != grappleAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = mech.getId();
            report.addDesc(mech);
            this.addReport(report);
        }
        report = new Report(4295);
        report.subject = mech.getId();
        report.indent();
        report.addDesc(mech2);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4300);
            report.subject = mech.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        report = new Report(4025);
        report.subject = mech.getId();
        report.add(toHitData.getValue());
        report.add(n2);
        report.newlines = 0;
        this.addReport(report);
        if (n2 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = mech.getId();
            this.addReport(report);
            return;
        }
        mech.setGrappled(mech2.getId(), true);
        mech2.setGrappled(mech.getId(), false);
        Coords coords = mech2.getPosition();
        mech.setPosition(coords);
        mech.setElevation(mech2.getElevation());
        mech2.setFacing((mech.getFacing() + 3) % 6);
        this.doSetLocationsExposure(mech, this.game.getBoard().getHex(coords), false, mech.getElevation());
        report = new Report(4040);
        report.subject = mech.getId();
        this.addReport(report);
        this.addNewLines();
    }

    private void resolveBreakGrappleAttack(PhysicalResult physicalResult, int n) {
        Object object;
        Object object2;
        Report report;
        BreakGrappleAttackAction breakGrappleAttackAction = (BreakGrappleAttackAction)physicalResult.aaa;
        Mech mech = (Mech)this.game.getEntity(breakGrappleAttackAction.getEntityId());
        Mech mech2 = (Mech)this.game.getEntity(breakGrappleAttackAction.getTargetId());
        int n2 = physicalResult.roll;
        ToHitData toHitData = physicalResult.toHit;
        if (n != breakGrappleAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = mech.getId();
            report.addDesc(mech);
            this.addReport(report);
        }
        report = new Report(4305);
        report.subject = mech.getId();
        report.indent();
        report.addDesc(mech2);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4310);
            report.subject = mech.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4320);
            report.subject = mech.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else {
            report = new Report(4025);
            report.subject = mech.getId();
            report.add(toHitData.getValue());
            report.add(n2);
            report.newlines = 0;
            this.addReport(report);
            if (n2 < toHitData.getValue()) {
                report = new Report(4035);
                report.subject = mech.getId();
                this.addReport(report);
                return;
            }
            report = new Report(4040);
            report.subject = mech.getId();
            this.addReport(report);
        }
        Object object3 = null;
        Coords[] coordsArray = this.physicalResults.elements();
        while (coordsArray.hasMoreElements()) {
            object2 = (PhysicalResult)coordsArray.nextElement();
            if (((PhysicalResult)object2).aaa.getEntityId() != mech2.getId() || !(((PhysicalResult)object2).aaa instanceof GrappleAttackAction) || ((PhysicalResult)object2).aaa.getTargetId() != mech.getId()) continue;
            object3 = object2;
            break;
        }
        if (object3 != null) {
            ((PhysicalResult)object3).pushBackResolved = true;
            report = new Report(4315);
            report.subject = mech2.getId();
            report.newlines = 0;
            report.addDesc(mech2);
            this.addReport(report);
            report = new Report(4025);
            report.subject = mech2.getId();
            report.add(((PhysicalResult)object3).toHit.getValue());
            report.add(((PhysicalResult)object3).roll);
            report.newlines = 0;
            this.addReport(report);
            if (n2 < toHitData.getValue()) {
                report = new Report(4035);
                report.subject = mech.getId();
                this.addReport(report);
            } else {
                report = new Report(4040);
                report.subject = mech.getId();
                this.addReport(report);
                mech.setGrappled(mech2.getId(), false);
                mech2.setGrappled(mech.getId(), true);
                return;
            }
        }
        coordsArray = new Coords[6];
        object2 = new int[6];
        IHex iHex = this.game.getBoard().getHex(mech.getPosition());
        for (object = 0; object < 6; ++object) {
            coordsArray[object] = mech.getPosition().translated((int)object);
            object2[object] = false;
            IHex iHex2 = this.game.getBoard().getHex(coordsArray[object]);
            if (iHex2.containsTerrain(24)) {
                Object object4 = object2;
                Object object5 = object;
                object4[object5] = object4[object5] + 10;
            }
            if (iHex2.containsTerrain(4)) {
                Object object6 = object2;
                Object object7 = object;
                object6[object7] = object6[object7] + iHex2.terrainLevel(4);
            }
            if (iHex.surface() - iHex2.surface() < 2) continue;
            Object object8 = object2;
            Object object9 = object;
            object8[object9] = object8[object9] + 2 * (iHex.surface() - iHex2.surface());
        }
        object = 99999;
        int n3 = 0;
        Object object10 = -99999;
        int n4 = 0;
        for (int i = 0; i < 6; ++i) {
            if (object > object2[i]) {
                n3 = i;
                object = object2[i];
            }
            if (object10 >= object2[i]) continue;
            n4 = i;
            object10 = object2[i];
        }
        if (mech.isGrappleAttacker()) {
            PilotingRollData pilotingRollData = mech.getBasePilotingRoll();
            pilotingRollData.addModifier(Integer.MIN_VALUE, "break grapple");
            this.doEntityDisplacement(mech, mech.getPosition(), coordsArray[n3], pilotingRollData);
            mech.setFacing(coordsArray[n3].direction(mech2.getPosition()));
        } else {
            PilotingRollData pilotingRollData = mech2.getBasePilotingRoll();
            pilotingRollData.addModifier(Integer.MIN_VALUE, "break grapple");
            this.doEntityDisplacement(mech2, mech2.getPosition(), coordsArray[n4], pilotingRollData);
            mech2.setFacing(coordsArray[n4].direction(mech.getPosition()));
        }
        mech.setGrappled(-1, false);
        mech2.setGrappled(-1, false);
        this.addNewLines();
    }

    private void resolveChargeAttack(PhysicalResult physicalResult, int n) {
        Report report;
        ChargeAttackAction chargeAttackAction = (ChargeAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(chargeAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(chargeAttackAction.getTargetType(), chargeAttackAction.getTargetId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        Entity entity2 = null;
        if (targetable != null && targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, chargeAttackAction.getEntityId(), entity2);
        }
        boolean bl2 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(chargeAttackAction.getTargetPos());
        if (entity == null) {
            return;
        }
        int n4 = entity.getFacing();
        entity.setDisplacementAttack(null);
        if (n != chargeAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        if (targetable == null || targetable.getTargetType() == 0 && (entity2.isDestroyed() || entity2.isDoomed() || entity2.crew.isDead())) {
            report = new Report(4190);
            report.subject = entity.getId();
            report.indent();
            this.addReport(report);
            return;
        }
        if (entity.isProne()) {
            report = new Report(4195);
            report.subject = entity.getId();
            report.indent();
            this.addReport(report);
            return;
        }
        if (entity.isImmobile()) {
            report = new Report(4200);
            report.subject = entity.getId();
            report.indent();
            this.addReport(report);
            return;
        }
        if (entity2 != null && entity2.isProne() && entity instanceof Mech) {
            report = new Report(4205);
            report.subject = entity.getId();
            report.indent();
            this.addReport(report);
            return;
        }
        report = new Report(4210);
        report.subject = entity.getId();
        report.indent();
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (!targetable.getPosition().equals(chargeAttackAction.getTargetPos())) {
            report = new Report(4215);
            report.subject = entity.getId();
            this.addReport(report);
            this.doEntityDisplacement(entity, entity.getPosition(), chargeAttackAction.getTargetPos(), null);
            return;
        }
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            n3 = -12;
            report = new Report(4220);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else if (toHitData.getValue() == Integer.MIN_VALUE) {
            n3 = Integer.MAX_VALUE;
            report = new Report(4225);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (bl2) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            Coords coords = entity.getPosition();
            Coords coords2 = Compute.getMissedChargeDisplacement(this.game, entity.getId(), coords, n4);
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            this.doEntityDisplacement(entity, coords, coords2, null);
        } else if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Report report2 = this.damageBuilding(building, n2);
            if (report2 != null) {
                report2.indent();
                report2.subject = entity.getId();
                this.addReport(report2);
            }
            this.damageInfantryIn(building, n2);
            int n5 = ChargeAttackAction.getDamageTakenBy(entity, building);
            HitData hitData = entity.rollHitLocation(0, entity.sideTable(targetable.getPosition()));
            this.addReport(this.damageEntity(entity, hitData, n5, false, 0, false, false, bl));
            this.addNewLines();
            this.entityUpdate(entity.getId());
        } else {
            this.resolveChargeDamage(entity, entity2, toHitData, n4, bl2, bl);
        }
    }

    private void resolveChargeDamage(Entity entity, Entity entity2, ToHitData toHitData, int n) {
        this.resolveChargeDamage(entity, entity2, toHitData, n, false, true);
    }

    private void resolveChargeDamage(Entity entity, Entity entity2, ToHitData toHitData, int n, boolean bl, boolean bl2) {
        int n2 = ChargeAttackAction.getDamageFor(entity);
        int n3 = ChargeAttackAction.getDamageTakenBy(entity, entity2, this.game.getOptions().booleanOption("maxtech_charge_damage"));
        PilotingRollData pilotingRollData = null;
        if (bl) {
            n2 = (int)Math.floor((double)n2 / 2.0);
            n3 = (int)Math.floor((double)n3 / 2.0);
        }
        boolean bl3 = Compute.isInBuilding(this.game, entity2);
        Building building = this.game.getBoard().getBuildingAt(entity2.getPosition());
        int n4 = 0;
        if (bl3 && building != null) {
            n4 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
        }
        if (!entity.isProne()) {
            pilotingRollData = new PilotingRollData(entity.getId(), 2, "charging");
        }
        Report report = new Report(4240);
        report.subject = entity.getId();
        report.add(n3);
        report.newlines = 0;
        this.addReport(report);
        int[] nArray = new int[entity.locations()];
        for (int i = 0; i < entity.locations(); ++i) {
            nArray[i] = 0;
        }
        for (Mounted mounted : entity.getMisc()) {
            if (mounted.getLocation() == -1 || !mounted.getType().hasFlag(0x400000000L)) continue;
            nArray[mounted.getLocation()] = 1;
        }
        int n5 = 0;
        while (n3 > 0) {
            int n6 = Math.min(5, n3);
            HitData object = entity.rollHitLocation(toHitData.getHitTable(), entity.sideTable(entity2.getPosition()));
            if (nArray[object.getLocation()] == 1) {
                report = new Report(4335);
                report.indent(2);
                report.newlines = 0;
                report.subject = entity.getId();
                this.addReport(report);
                nArray[object.getLocation()] = 0;
                this.checkBreakSpikes(entity, object.getLocation());
                n5 += 2;
            }
            this.addReport(this.damageEntity(entity, object, n6, false, 0, false, false, bl2));
            n3 -= n6;
        }
        report = new Report(4230);
        report.subject = entity.getId();
        report.add(n2 += n5);
        report.add(toHitData.getTableDesc());
        report.newlines = 0;
        this.addReport(report);
        nArray = new int[entity2.locations()];
        for (int i = 0; i < entity2.locations(); ++i) {
            nArray[i] = 0;
        }
        for (Mounted hitData : entity2.getMisc()) {
            if (hitData.getLocation() == -1 || !hitData.getType().hasFlag(0x400000000L)) continue;
            nArray[hitData.getLocation()] = 1;
        }
        n5 = 0;
        while (n2 > 0) {
            int n7 = Math.min(5, n2);
            n2 -= n7;
            if (n4 > 0) {
                int coords2 = Math.min(n4, n7);
                n7 -= coords2;
                this.addNewLines();
                Report report2 = this.damageBuilding(building, coords2);
                if (report2 != null) {
                    report2.indent();
                    report2.subject = entity.getId();
                    this.addReport(report2);
                }
            }
            if (n7 == 0) {
                report = new Report(4235);
                report.subject = entity.getId();
                report.addDesc(entity2);
                report.newlines = 0;
                this.addReport(report);
                continue;
            }
            HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            if (nArray[hitData.getLocation()] == 1) {
                report = new Report(4330);
                report.indent(2);
                report.newlines = 0;
                report.subject = entity.getId();
                this.addReport(report);
                nArray[hitData.getLocation()] = 0;
                this.checkBreakSpikes(entity2, hitData.getLocation());
                n7 = 1;
                n5 += 2;
            }
            this.addReport(this.damageEntity(entity2, hitData, n7, false, 0, false, false, bl2));
        }
        if (entity instanceof Mech) {
            this.addReport(this.damageEntity(entity, new HitData(1), n5, false, 0, false, false, bl2));
        } else if (entity instanceof Tank) {
            this.addReport(this.damageEntity(entity, new HitData(1), n5, false, 0, false, false, bl2));
        }
        Coords coords = entity2.getPosition();
        Coords coords2 = coords.translated(n);
        if (Compute.isValidDisplacement(this.game, entity2.getId(), entity2.getPosition(), n)) {
            this.addNewLines();
            this.doEntityDisplacement(entity2, coords, coords2, new PilotingRollData(entity2.getId(), 2, "was charged"));
            this.doEntityDisplacement(entity, entity.getPosition(), coords, pilotingRollData);
        }
        this.addNewLines();
    }

    private void resolveLayExplosivesAttack(PhysicalResult physicalResult, int n) {
        LayExplosivesAttackAction layExplosivesAttackAction = (LayExplosivesAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(layExplosivesAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(layExplosivesAttackAction.getTargetType(), layExplosivesAttackAction.getTargetId());
        if (entity instanceof Infantry) {
            Infantry infantry = (Infantry)entity;
            if (infantry.turnsLayingExplosives < 0) {
                infantry.turnsLayingExplosives = 0;
                Report report = new Report(4270);
                report.subject = infantry.getId();
                report.addDesc(infantry);
                this.addReport(report);
            } else {
                Building building = this.game.getBoard().getBuildingAt(entity.getPosition());
                if (building != null) {
                    building.addDemolitionCharge(entity.getOwner().getId(), physicalResult.damage);
                    Report report = new Report(4275);
                    report.subject = infantry.getId();
                    report.addDesc(infantry);
                    report.add(physicalResult.damage);
                    this.addReport(report);
                }
                infantry.turnsLayingExplosives = -1;
            }
        }
    }

    private void resolveDfaAttack(PhysicalResult physicalResult, int n) {
        Object object;
        Report report;
        DfaAttackAction dfaAttackAction = (DfaAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(dfaAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(dfaAttackAction.getTargetType(), dfaAttackAction.getTargetId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        Entity entity2 = null;
        if (targetable != null && targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
            IHex iHex = this.game.getBoard().getHex(entity2.getPosition());
            if (iHex.containsTerrain(4) && entity2.absHeight() < iHex.getElevation()) {
                n2 = (int)Math.ceil((float)n2 * 0.5f);
            }
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, dfaAttackAction.getEntityId(), entity2);
        }
        boolean bl2 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(dfaAttackAction.getTargetPos());
        if (entity == null) {
            return;
        }
        int n4 = entity.getFacing();
        if (n != dfaAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        entity.setDisplacementAttack(null);
        if (targetable == null || targetable.getTargetType() == 0 && (entity2.isDestroyed() || entity2.isDoomed() || entity2.crew.isDead())) {
            report = new Report(4245);
            report.subject = entity.getId();
            report.indent();
            this.addReport(report);
            if (entity.isProne()) {
                this.doEntityFall(entity, dfaAttackAction.getTargetPos(), 2, 3, entity.getBasePilotingRoll());
            } else {
                this.doEntityDisplacement(entity, entity.getPosition(), dfaAttackAction.getTargetPos(), new PilotingRollData(entity.getId(), 4, "executed death from above"));
            }
            return;
        }
        report = new Report(4246);
        report.subject = entity.getId();
        report.indent();
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (!targetable.getPosition().equals(dfaAttackAction.getTargetPos())) {
            report = new Report(4215);
            report.subject = entity.getId();
            this.addReport(report);
            this.doEntityFallsInto(entity, entity.getPosition(), dfaAttackAction.getTargetPos(), entity.getBasePilotingRoll());
            return;
        }
        if (entity.isProne() || !entity.isActive()) {
            n3 = -12;
            report = new Report(4250);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else if (toHitData.getValue() == Integer.MAX_VALUE) {
            n3 = -12;
            report = new Report(4255);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4260);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            n3 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (bl2) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            Coords coords = entity2.getPosition();
            Coords coords2 = Compute.getPreferredDisplacement(this.game, entity2.getId(), coords, n4);
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            if (coords2 != null) {
                report = new Report(4265);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(coords.getBoardNum(), true);
                this.addReport(report);
                this.doEntityFall(entity, coords, 2, 3, entity.getBasePilotingRoll());
                this.doEntityDisplacement(entity2, coords, coords2, null);
            } else {
                this.addReport(this.destroyEntity(entity, "impossible displacement", entity instanceof Mech, entity instanceof Mech));
            }
            return;
        }
        int n5 = DfaAttackAction.getDamageTakenBy(entity);
        report = new Report(4040);
        report.subject = entity.getId();
        this.addReport(report);
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            object = this.damageBuilding(building, n2);
            if (object != null) {
                ((Report)object).indent();
                ((Report)object).subject = entity.getId();
                this.addReport((Report)object);
            }
            this.damageInfantryIn(building, n2);
        } else {
            if (bl2) {
                n2 = (int)Math.floor((double)n2 / 2.0);
            }
            report = new Report(4230);
            report.subject = entity.getId();
            report.add(n2);
            report.add(toHitData.getTableDesc());
            report.newlines = 0;
            this.addReport(report);
            object = new int[entity2.locations()];
            for (int i = 0; i < entity2.locations(); ++i) {
                object[i] = false;
            }
            for (Mounted mounted : entity2.getMisc()) {
                if (mounted.getLocation() == -1 || !mounted.getType().hasFlag(0x400000000L)) continue;
                object[mounted.getLocation()] = true;
            }
            int n6 = 0;
            while (n2 > 0) {
                int n7 = Math.min(5, n2);
                HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
                if (object[hitData.getLocation()] == true) {
                    report = new Report(4330);
                    report.indent(2);
                    report.newlines = 0;
                    report.subject = entity.getId();
                    this.addReport(report);
                    n7 = 1;
                    object[hitData.getLocation()] = false;
                    this.checkBreakSpikes(entity2, hitData.getLocation());
                    n6 += 2;
                }
                this.addReport(this.damageEntity(entity2, hitData, n7, false, 0, false, false, bl));
                n2 -= 5;
            }
            if (n6 > 0) {
                if (entity instanceof QuadMech) {
                    this.addReport(this.damageEntity(entity, new HitData(5), (n6 + 2) / 4, false, 0, false, false, false));
                    this.addReport(this.damageEntity(entity, new HitData(4), (n6 + 2) / 4, false, 0, false, false, false));
                    if (n6 > 2) {
                        this.addReport(this.damageEntity(entity, new HitData(7), n6 / 4, false, 0, false, false, false));
                        this.addReport(this.damageEntity(entity, new HitData(6), n6 / 4, false, 0, false, false, false));
                    }
                } else {
                    this.addReport(this.damageEntity(entity, new HitData(7), n6 / 2, false, 0, false, false, false));
                    this.addReport(this.damageEntity(entity, new HitData(6), n6 / 2, false, 0, false, false, false));
                }
            }
        }
        if (bl2) {
            n5 = (int)Math.floor((double)n5 / 2.0);
        }
        report = new Report(4240);
        report.subject = entity.getId();
        report.add(n5);
        report.newlines = 0;
        this.addReport(report);
        while (n5 > 0) {
            int n8 = Math.min(5, n5);
            HitData hitData = entity.rollHitLocation(2, 0);
            this.addReport(this.damageEntity(entity, hitData, n8));
            n5 -= n8;
        }
        this.addNewLines();
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            return;
        }
        Coords coords = entity2.getPosition();
        Coords coords3 = Compute.getValidDisplacement(this.game, entity2.getId(), coords, n4);
        if (coords3 != null) {
            this.doEntityDisplacement(entity2, coords, coords3, new PilotingRollData(entity2.getId(), 2, "hit by death from above"));
        } else {
            this.addReport(this.destroyEntity(entity2, "impossible displacement", entity2 instanceof Mech, entity2 instanceof Mech));
        }
        this.doEntityDisplacement(entity, coords, coords, new PilotingRollData(entity.getId(), 4, "executed death from above"));
    }

    private int getKickPushPSRMod(Entity entity, Entity entity2, int n) {
        int n2 = n;
        if (this.game.getOptions().booleanOption("maxtech_physical_psr")) {
            int n3 = 0;
            int n4 = 0;
            switch (entity.getWeightClass()) {
                case 0: {
                    n3 = 1;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
                case 2: {
                    n3 = 3;
                    break;
                }
                case 3: {
                    n3 = 4;
                }
            }
            switch (entity2.getWeightClass()) {
                case 0: {
                    n4 = 1;
                    break;
                }
                case 1: {
                    n4 = 2;
                    break;
                }
                case 2: {
                    n4 = 3;
                    break;
                }
                case 3: {
                    n4 = 4;
                }
            }
            n2 = n3 - n4;
        }
        return n2;
    }

    private void resolveHeat() {
        this.addReport(new Report(5000, 0));
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            int n;
            int n2;
            boolean bl;
            boolean bl2;
            int n3;
            Report report;
            int n4;
            Entity entity = (Entity)enumeration.nextElement();
            if (null == entity.getPosition()) continue;
            IHex iHex = this.game.getBoard().getHex(entity.getPosition());
            if (!(entity instanceof Mech)) {
                entity.heatBuildup = 0;
                if (this.game.getOptions().booleanOption("vehicle_fires") && entity instanceof Tank) {
                    this.resolveVehicleFire((Tank)entity, true);
                    continue;
                }
                if (!entity.infernos.isStillBurning()) continue;
                this.doFlamingDeath(entity);
                continue;
            }
            if (entity.infernos.isStillBurning()) {
                n4 = entity.infernos.getHeat();
                entity.heatBuildup += n4;
                report = new Report(5010);
                report.subject = entity.getId();
                report.add(n4);
                this.addReport(report);
            }
            if (entity.isDestroyed() || entity.isDoomed() || entity.crew.isDoomed() || entity.crew.isDead()) continue;
            entity.heatBuildup += entity.getEngineCritHeat();
            if (entity instanceof Mech && entity.isStealthActive()) {
                entity.heatBuildup += 10;
                report = new Report(5015);
                report.subject = entity.getId();
                this.addReport(report);
            }
            if (entity instanceof Mech && this.game.getTemperatureDifference() != 0 && !((Mech)entity).hasLaserHeatSinks()) {
                if (this.game.getOptions().intOption("temperature") > 50) {
                    entity.heatBuildup += this.game.getTemperatureDifference();
                    report = new Report(5020);
                    report.subject = entity.getId();
                    report.add(this.game.getTemperatureDifference());
                    this.addReport(report);
                } else {
                    entity.heatBuildup -= this.game.getTemperatureDifference();
                    report = new Report(5025);
                    report.subject = entity.getId();
                    report.add(this.game.getTemperatureDifference());
                    this.addReport(report);
                }
            }
            if (iHex != null) {
                if (iHex.terrainLevel(7) == 2 && entity.getElevation() <= 1) {
                    entity.heatBuildup += 5;
                    report = new Report(5030);
                    report.subject = entity.getId();
                    this.addReport(report);
                }
                if ((n4 = iHex.terrainLevel(24)) > 0 && entity.getElevation() == 0) {
                    entity.heatBuildup += 5 * n4;
                    report = new Report(5032);
                    report.subject = entity.getId();
                    report.add(5 * n4);
                    this.addReport(report);
                }
            }
            if (entity.hasVibroblades()) {
                n4 = 0;
                n4 = entity.getActiveVibrobladeHeat(4);
                if ((n4 += entity.getActiveVibrobladeHeat(5)) > 0) {
                    report = new Report(5017);
                    report.subject = entity.getId();
                    report.add(n4);
                    this.addReport(report);
                    entity.heatBuildup += n4;
                }
            }
            if (entity.heatBuildup < 0) {
                entity.heatBuildup = 0;
            }
            entity.heat += entity.heatBuildup;
            n4 = entity.getHeatCapacityWithWater();
            int n5 = entity.hasInfernoAmmo() ? 9 : 13;
            int n6 = ((Mech)entity).getNumberOfSinks();
            for (Mounted mounted : entity.getEquipment()) {
                AmmoType ammoType;
                if (!(mounted.getType() instanceof AmmoType) || (ammoType = (AmmoType)mounted.getType()).getAmmoType() != 37 || !mounted.isAmmoUsable()) continue;
                EquipmentMode equipmentMode = mounted.curMode();
                if (equipmentMode.equals("dump")) {
                    report = new Report(5260);
                    report.subject = entity.getId();
                    this.addReport(report);
                    mounted.setShotsLeft(0);
                    n4 += n6;
                    break;
                }
                if (equipmentMode.equals("safe") && entity.heat - n4 > n5) {
                    report = new Report(5265);
                    report.subject = entity.getId();
                    this.addReport(report);
                    mounted.setShotsLeft(0);
                    n4 += n6;
                    break;
                }
                if (!equipmentMode.equals("efficient") || entity.heat - n4 < n6) continue;
                report = new Report(5270);
                report.subject = entity.getId();
                this.addReport(report);
                mounted.setShotsLeft(0);
                n4 += n6;
                break;
            }
            n4 = Math.min(n4, entity.heat);
            entity.heat -= n4;
            report = new Report(5035);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.heatBuildup);
            report.add(n4);
            report.add(entity.heat);
            this.addReport(report);
            entity.heatBuildup = 0;
            if (entity.hasInfernoAmmo() && entity.heat >= 10) {
                int n7 = 4 + (entity.heat >= 14 ? 2 : 0) + (entity.heat >= 19 ? 2 : 0) + (entity.heat >= 23 ? 2 : 0) + (entity.heat >= 28 ? 2 : 0);
                int n8 = Compute.d6(2);
                report = new Report(5040);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n7);
                report.add(n8);
                if (n8 >= n7) {
                    report.choose(true);
                    this.addReport(report);
                } else {
                    report.choose(false);
                    this.addReport(report);
                    this.addReport(this.explodeInfernoAmmoFromHeat(entity));
                }
            }
            if (this.game.getOptions().booleanOption("maxtech_heat")) {
                n3 = 50;
                bl2 = true;
            } else {
                n3 = 30;
                bl2 = false;
            }
            if (entity.heat < n3 && entity.isShutDown()) {
                if (entity.heat < 14) {
                    entity.setShutDown(false);
                    report = new Report(5045);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    this.addReport(report);
                } else {
                    int n9 = 4 + (entity.heat - 14) / 4 * 2;
                    if (bl2) {
                        n9 = entity.crew.getPiloting() + n9 - 8;
                    }
                    int n10 = Compute.d6(2);
                    report = new Report(5050);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    report.add(n9);
                    report.add(n10);
                    if (n10 >= n9) {
                        entity.setShutDown(false);
                        report.choose(true);
                    } else {
                        report.choose(false);
                    }
                    this.addReport(report);
                }
            } else if (entity.heat >= 14 && !entity.isShutDown()) {
                if (entity.heat >= n3) {
                    report = new Report(5055);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    this.addReport(report);
                    this.game.addPSR(new PilotingRollData(entity.getId(), 3, "reactor shutdown"));
                    this.resolvePilotingRolls();
                    entity.setShutDown(true);
                } else if (entity.heat >= 14) {
                    int n11 = 4 + (entity.heat - 14) / 4 * 2;
                    if (bl2) {
                        n11 = entity.crew.getPiloting() + n11 - 8;
                    }
                    int n12 = Compute.d6(2);
                    report = new Report(5060);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    report.add(n11);
                    report.add(n12);
                    if (n12 >= n11) {
                        report.choose(true);
                        this.addReport(report);
                    } else {
                        report.choose(false);
                        this.addReport(report);
                        this.game.addPSR(new PilotingRollData(entity.getId(), 3, "reactor shutdown"));
                        this.resolvePilotingRolls();
                        entity.setShutDown(true);
                    }
                }
            }
            if (entity.heat >= 19) {
                int n13 = 4 + (entity.heat >= 23 ? 2 : 0) + (entity.heat >= 28 ? 2 : 0);
                if (bl2) {
                    n13 += (entity.heat >= 35 ? 2 : 0) + (entity.heat >= 40 ? 2 : 0) + (entity.heat >= 45 ? 2 : 0);
                }
                if (entity instanceof Mech && ((Mech)entity).hasLaserHeatSinks()) {
                    --n13;
                }
                int n14 = Compute.d6(2);
                report = new Report(5065);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n13);
                report.add(n14);
                if (n14 >= n13) {
                    report.choose(true);
                    this.addReport(report);
                } else {
                    report.choose(false);
                    this.addReport(report);
                    this.addReport(this.explodeAmmoFromHeat(entity));
                }
            }
            int n15 = 0;
            boolean bl3 = bl = ((Mech)entity).getCockpitType() == 1;
            if (entity instanceof Mech && bl) {
                n15 = entity.getHitCriticals(0, 0, 2);
                n15 += entity.getHitCriticals(0, 0, 3);
            } else {
                n15 = entity.getHitCriticals(0, 0, 0);
            }
            if (n15 > 0 && (entity.heat >= 15 || bl && entity.heat >= 0) && !entity.crew.isDead() && !entity.crew.isDoomed() && !entity.crew.isEjected()) {
                n2 = 1;
                n = 0;
                if (entity.heat >= 47 && bl2) {
                    n2 = 47;
                    n = 5;
                } else if (entity.heat >= 39 && bl2) {
                    n2 = 39;
                    n = 4;
                } else if (entity.heat >= 32 && bl2) {
                    n2 = 32;
                    n = 3;
                } else if (entity.heat >= 25) {
                    n2 = 25;
                    n = 2;
                } else if (entity.heat >= 15) {
                    n2 = 15;
                    n = 1;
                }
                if (entity.heat > 0 && entity instanceof Mech && ((Mech)entity).getCockpitType() == 1) {
                    ++n;
                }
                report = new Report(5070);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n2);
                report.add(n);
                this.addReport(report);
                this.damageCrew(entity, n);
            } else if (bl2 && entity.heat >= 32 && !entity.crew.isDead() && !entity.crew.isDoomed()) {
                n2 = Compute.d6(2);
                n = -1;
                if (entity.heat >= 47) {
                    n = 12;
                } else if (entity.heat >= 39) {
                    n = 10;
                } else if (entity.heat >= 32) {
                    n = 8;
                }
                report = new Report(5075);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n);
                report.add(n2);
                if (n2 >= n) {
                    report.choose(true);
                } else {
                    this.damageCrew(entity, 1);
                    report.choose(false);
                }
                this.addReport(report);
            }
            if ((entity.crew.isDead() || entity.crew.isDoomed()) && !entity.crew.isEjected()) {
                report = new Report(5080);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
                this.addReport(this.destroyEntity(entity, "crew death", true));
            }
            if (!bl2 || entity.heat < 36) continue;
            n2 = Compute.d6(2);
            n = -1;
            if (entity.heat >= 44) {
                n = 10;
            } else if (entity.heat >= 36) {
                n = 8;
            }
            report = new Report(5085);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(n);
            report.add(n2);
            report.newlines = 0;
            if (n2 >= n) {
                report.choose(true);
                this.addReport(report);
                continue;
            }
            report.choose(false);
            this.addReport(report);
            this.addReport(this.oneCriticalEntity(entity, Compute.randomInt(8)));
            report = new Report(1210);
            this.addReport(report);
        }
        if (this.vPhaseReport.size() == 1) {
            this.addReport(new Report(1205, 0));
        }
    }

    private void resolveExtremeTempInfantryDeath() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (null == entity.getPosition()) continue;
            IHex iHex = this.game.getBoard().getHex(entity.getPosition());
            if (!(entity instanceof Infantry) || entity instanceof BattleArmor || this.game.getTemperatureDifference() <= 0 || iHex.containsTerrain(10) || entity.getTransportId() != -1) continue;
            Report report = new Report(5090);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
            this.addReport(this.destroyEntity(entity, "heat/cold", false, false));
        }
    }

    private void doFlamingDeath(Entity entity) {
        int n = Compute.d6(2);
        if (-1 != entity.getSwarmTargetId()) {
            return;
        }
        if (entity.getMovementMode() == 6 && !entity.infernos.isStillBurning()) {
            Coords coords = entity.getPosition();
            IHex object = this.game.getBoard().getHex(coords.x, coords.y);
            if (entity.getElevation() > 1) {
                return;
            }
        }
        for (Mounted mounted : entity.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!"BA-Fire Resistant Armor".equals(equipmentType.getInternalName())) continue;
            Report report = new Report(5095);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
            return;
        }
        Report report = new Report(5100);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(n);
        if (n >= 8) {
            report.choose(true);
            this.addReport(report);
        } else {
            report.choose(false);
            this.addReport(report);
            this.addReport(this.destroyEntity(entity, "fire", false, false));
        }
    }

    private void checkFor20Damage() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!(entity instanceof Mech) || entity.damageThisPhase < 20) continue;
            if (this.game.getOptions().booleanOption("maxtech_round_damage")) {
                int n = entity.damageThisPhase / 20;
                int n2 = 0;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(entity.damageThisPhase).append(" damage +").append(n);
                switch (entity.getWeightClass()) {
                    case 0: {
                        n2 = 1;
                        break;
                    }
                    case 1: {
                        n2 = 0;
                        break;
                    }
                    case 2: {
                        n2 = -1;
                        break;
                    }
                    case 3: {
                        n2 = -2;
                    }
                }
                if (n2 > 0) {
                    stringBuffer.append(", weight class modifier +").append(n2);
                } else {
                    stringBuffer.append(", weight class modifier ").append(n2);
                }
                PilotingRollData pilotingRollData = new PilotingRollData(entity.getId(), n + n2, stringBuffer.toString());
                pilotingRollData.setCumulative(false);
                this.game.addPSR(pilotingRollData);
                continue;
            }
            this.game.addPSR(new PilotingRollData(entity.getId(), 1, "20+ damage"));
        }
    }

    public void checkForFlamingDeath() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            IHex iHex;
            Entity entity = (Entity)enumeration.nextElement();
            if (null == entity.getPosition() || entity instanceof Mech || entity.isDoomed() || entity.isDestroyed() || entity.isOffBoard() || !(iHex = this.game.getBoard().getHex(entity.getPosition())).containsTerrain(7) || entity.getElevation() > 1) continue;
            if (this.game.getOptions().booleanOption("vehicle_fires") && entity instanceof Tank) {
                this.checkForVehicleFire((Tank)entity, false);
                continue;
            }
            this.doFlamingDeath(entity);
        }
    }

    private void checkForVacuumDeath() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (null == entity.getPosition() || entity.isOffBoard() || !entity.doomedInVacuum()) continue;
            Report report = new Report(6015);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
            this.addReport(this.destroyEntity(entity, "being in a vacuum where it can't survive", true, true));
        }
    }

    private void checkForSuffocation() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (null == entity.getPosition() || entity.isOffBoard()) continue;
            IHex iHex = this.game.getBoard().getHex(entity.getPosition());
            if (entity.getElevation() >= 0 || iHex.terrainLevel(4) <= 1 && (iHex.terrainLevel(4) != 1 || !entity.isProne()) || entity.getHitCriticals(0, 0, 0) <= 0) continue;
            Report report = new Report(6020);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
            this.addReport(this.damageCrew(entity, 1));
        }
    }

    private void resolvePilotingRolls() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            this.resolvePilotingRolls((Entity)enumeration.nextElement());
        }
        this.game.resetPSRs();
    }

    void resolvePilotingRolls(Entity entity) {
        this.resolvePilotingRolls(entity, false, entity.getPosition(), entity.getPosition());
    }

    void resolvePilotingRolls(Entity entity, boolean bl, Coords coords, Coords coords2) {
        PilotingRollData pilotingRollData;
        int n;
        Report report;
        if (entity.isDoomed() || entity.isDestroyed() || entity.isOffBoard() || !entity.isDeployed()) {
            return;
        }
        TargetRoll targetRoll = null;
        Object object = this.game.getExtremeGravityPSRs();
        while (object.hasMoreElements()) {
            PilotingRollData pilotingRollData2 = (PilotingRollData)object.nextElement();
            if (pilotingRollData2.getEntityId() != entity.getId()) continue;
            targetRoll = pilotingRollData2;
            this.game.resetExtremeGravityPSRs(entity);
        }
        if (targetRoll != null && targetRoll.getValue() != -2147483647) {
            report = new Report(2180);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(targetRoll.getLastPlainDesc());
            this.addReport(report);
            int n2 = Compute.d6(2);
            report = new Report(2190);
            report.subject = entity.getId();
            report.add(targetRoll.getValueAsString());
            report.add(targetRoll.getDesc());
            report.add(n2);
            if (n2 < targetRoll.getValue()) {
                int n3;
                report.choose(false);
                this.addReport(report);
                if (entity.moved == 1 || entity.moved == 4 || entity.moved == 2 || entity.moved == 5) {
                    if (entity instanceof Mech) {
                        int n4 = entity.mpUsed;
                        n3 = 0;
                        while (n4 > entity.getRunMP(false)) {
                            --n4;
                            ++n3;
                        }
                        this.doExtremeGravityDamage(entity, n3);
                    } else if (entity instanceof Tank) {
                        int n5;
                        int n6 = n5 = entity.gotPavementBonus ? 1 : 0;
                        if (!entity.gotPavementBonus) {
                            n3 = entity.mpUsed;
                            int n7 = 0;
                            while (n3 > entity.getRunMP(false) + n5) {
                                --n3;
                                ++n7;
                            }
                            this.doExtremeGravityDamage(entity, n7);
                        }
                    }
                }
                if (entity.moved == 3 && entity instanceof Mech) {
                    if (this.game.getOptions().floatOption("gravity") < 1.0f) {
                        int n8 = entity.mpUsed;
                        n3 = 0;
                        while (n8 > entity.getOriginalJumpMP()) {
                            --n8;
                            ++n3;
                        }
                        this.doExtremeGravityDamage(entity, n3);
                    } else if (this.game.getOptions().floatOption("gravity") > 1.0f) {
                        int n9 = entity.getWalkMP(false) - entity.getWalkMP();
                        this.doExtremeGravityDamage(entity, n9);
                    }
                }
            } else {
                report.choose(true);
                this.addReport(report);
            }
        }
        if (!(entity instanceof Mech) || entity.isProne()) {
            return;
        }
        if (entity instanceof Mech && (n = (object = this.game.getBoard().getHex(coords2)).terrainLevel(4)) > 0 && entity.getElevation() != -object.depth() && (entity.getElevation() < 0 || entity.getElevation() == 0 && object.terrainLevel(16) != 0 && !object.containsTerrain(20))) {
            if (entity.hasUMU()) {
                return;
            }
            this.game.addPSR(new PilotingRollData(entity.getId(), 0x7FFFFFFE, "lost bouyancy"));
        }
        object = new Vector();
        StringBuffer stringBuffer = new StringBuffer();
        PilotingRollData pilotingRollData3 = entity.getBasePilotingRoll();
        entity.addPilotingModifierForTerrain(pilotingRollData3);
        Enumeration enumeration = this.game.getPSRs();
        while (enumeration.hasMoreElements()) {
            pilotingRollData = (PilotingRollData)enumeration.nextElement();
            if (pilotingRollData.getEntityId() != entity.getId()) continue;
            ((Vector)object).addElement(pilotingRollData);
            if (stringBuffer.length() > 0) {
                stringBuffer.append("; ");
            }
            stringBuffer.append(pilotingRollData.getPlainDesc());
            if (!pilotingRollData.isCumulative()) continue;
            pilotingRollData3.append(pilotingRollData);
        }
        if (((Vector)object).size() == 0) {
            return;
        }
        if (pilotingRollData3.getValue() == 0x7FFFFFFE || pilotingRollData3.getValue() == Integer.MAX_VALUE) {
            report = new Report(2275);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(((Vector)object).size());
            report.add(stringBuffer.toString());
            report.add(pilotingRollData3.getDesc());
            this.addReport(report);
            if (bl) {
                this.doEntityFallsInto(entity, coords, coords2, pilotingRollData3);
            } else {
                this.doEntityFall(entity, pilotingRollData3);
            }
            return;
        }
        report = new Report(2280);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(((Vector)object).size());
        report.add(stringBuffer.toString());
        this.addReport(report);
        report = new Report(2285);
        report.subject = entity.getId();
        report.add(pilotingRollData3.getValueAsString());
        report.add(pilotingRollData3.getDesc());
        this.addReport(report);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            pilotingRollData = (PilotingRollData)((Vector)object).elementAt(i);
            PilotingRollData pilotingRollData4 = pilotingRollData3;
            report = new Report(2290);
            report.subject = entity.getId();
            report.indent();
            report.newlines = 0;
            report.add(i + 1);
            report.add(pilotingRollData.getPlainDesc());
            this.addReport(report);
            if (!pilotingRollData.isCumulative()) {
                report = new Report(2295);
                report.subject = entity.getId();
                report.newlines = 0;
                report.add(pilotingRollData.getValueAsString());
                pilotingRollData4 = new PilotingRollData(entity.getId());
                pilotingRollData4.append(pilotingRollData3);
                pilotingRollData4.append(pilotingRollData);
            }
            int n10 = Compute.d6(2);
            report = new Report(2300);
            report.subject = entity.getId();
            report.add(pilotingRollData4.getValueAsString());
            report.add(n10);
            if (n10 < pilotingRollData4.getValue()) {
                report.choose(false);
                this.addReport(report);
                if (bl) {
                    this.doEntityFallsInto(entity, coords, coords2, pilotingRollData3);
                } else {
                    this.doEntityFall(entity, pilotingRollData3);
                }
                return;
            }
            report.choose(true);
            this.addReport(report);
        }
    }

    private Vector damageCrew(Entity entity, int n) {
        Vector<Report> vector = new Vector<Report>();
        Pilot pilot = entity.getCrew();
        if (!(pilot.isDead() || pilot.isEjected() || pilot.isDoomed())) {
            pilot.setHits(pilot.getHits() + n);
            Report report = new Report(6025);
            report.subject = entity.getId();
            report.indent(2);
            report.addDesc(entity);
            report.add(pilot.getName());
            report.add(n);
            report.newlines = 0;
            vector.addElement(report);
            if (6 > pilot.getHits()) {
                pilot.setRollsNeeded(pilot.getRollsNeeded() + n);
            } else if (!pilot.isDoomed()) {
                pilot.setDoomed(true);
                vector.addAll(this.destroyEntity(entity, "pilot death", true));
            }
        }
        return vector;
    }

    private void resolveCrewDamage() {
        boolean bl = false;
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!this.resolveCrewDamage(entity, bl)) continue;
            bl = true;
        }
        if (bl) {
            this.addNewLines();
        }
    }

    private boolean resolveCrewDamage(Entity entity, boolean bl) {
        int n = entity.getCrew().getHits();
        int n2 = entity.getCrew().getRollsNeeded();
        entity.crew.setRollsNeeded(0);
        if (!entity.isTargetable() || !entity.getCrew().isActive() || n2 == 0) {
            return false;
        }
        for (int i = n - n2 + 1; i <= n; ++i) {
            int n3 = Compute.getConsciousnessNumber(i);
            boolean bl2 = false;
            do {
                if (bl2) {
                    entity.crew.decreaseEdge();
                }
                int n4 = Compute.d6(2);
                if (entity.getCrew().getOptions().booleanOption("pain_resistance")) {
                    n4 = Math.min(12, n4 + 1);
                }
                Report report = new Report(6030);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(entity.getCrew().getName());
                report.add(n3);
                report.add(n4);
                if (n4 >= n3) {
                    entity.crew.setKoThisRound(false);
                    report.choose(true);
                } else {
                    entity.crew.setKoThisRound(true);
                    report.choose(false);
                    if (entity.crew.hasEdgeRemaining() && entity.crew.getOptions().booleanOption("edge_when_ko")) {
                        bl2 = true;
                        this.vPhaseReport.addElement(report);
                        report = new Report(6520);
                        report.subject = entity.getId();
                        report.addDesc(entity);
                        report.add(entity.getCrew().getName());
                        report.add(entity.crew.getOptions().intOption("edge"));
                    }
                }
                this.addReport(report);
            } while (entity.crew.hasEdgeRemaining() && entity.crew.isKoThisRound() && entity.crew.getOptions().booleanOption("edge_when_ko"));
            if (!entity.crew.isKoThisRound()) continue;
            entity.crew.setUnconscious(true);
            return true;
        }
        return true;
    }

    private void resolveCrewWakeUp() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.isTargetable() || !entity.crew.isUnconscious() || entity.crew.isKoThisRound() || !(entity instanceof Mech) && !(entity instanceof Protomech) && !(entity instanceof MechWarrior)) continue;
            int n = Compute.d6(2);
            if (entity.getCrew().getOptions().booleanOption("pain_resistance")) {
                n = Math.min(12, n + 1);
            }
            int n2 = Compute.getConsciousnessNumber(entity.crew.getHits());
            Report report = new Report(6029);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.getCrew().getName());
            report.add(n2);
            report.add(n);
            if (n >= n2) {
                report.choose(true);
                entity.crew.setUnconscious(false);
            } else {
                report.choose(false);
            }
            this.addReport(report);
        }
    }

    public Vector damageEntity(Entity entity, HitData hitData, int n, boolean bl) {
        return this.damageEntity(entity, hitData, n, bl, 0, false, false);
    }

    public Vector damageEntity(Entity entity, HitData hitData, int n) {
        return this.damageEntity(entity, hitData, n, false, 0, false, false);
    }

    public Vector damageEntity(Entity entity, HitData hitData, int n, boolean bl, int n2) {
        return this.damageEntity(entity, hitData, n, bl, n2, false, false);
    }

    public Vector damageEntity(Entity entity, HitData hitData, int n, boolean bl, int n2, boolean bl2) {
        return this.damageEntity(entity, hitData, n, bl, n2, bl2, false);
    }

    public Vector damageEntity(Entity entity, HitData hitData, int n, boolean bl, int n2, boolean bl2, boolean bl3) {
        return this.damageEntity(entity, hitData, n, bl, n2, bl2, bl3, true);
    }

    /*
     * WARNING - void declaration
     */
    private Vector damageEntity(Entity entity, HitData hitData, int n, boolean bl, int n2, boolean bl2, boolean bl3, boolean bl4) {
        int n3;
        boolean bl5;
        Mech mech;
        Report report;
        Vector<Report> vector = new Vector<Report>();
        int n4 = entity.getId();
        boolean bl6 = entity instanceof Mech && ((Mech)entity).getCockpitType() != 1 && hitData.getLocation() == 0;
        for (HitData hitData2 = hitData.getUndoneLocation(); hitData2 != null; hitData2 = hitData2.getUndoneLocation()) {
            report = new Report(6500);
            report.subject = n4;
            report.indent(2);
            report.newlines = 0;
            report.addDesc(entity);
            report.add(entity.getLocationAbbr(hitData2));
            vector.addElement(report);
        }
        if (hitData.getUndoneLocation() != null) {
            report = new Report(6510);
            report.subject = n4;
            report.indent(2);
            report.newlines = 0;
            report.addDesc(entity);
            report.add(entity.crew.getOptions().intOption("edge"));
            vector.addElement(report);
        }
        boolean bl7 = false;
        if (bl && entity instanceof Mech && (mech = (Mech)entity).isAutoEject()) {
            bl7 = true;
            vector.addAll(this.ejectEntity(entity, true));
        }
        boolean bl8 = !(bl5 = entity instanceof BattleArmor) && entity instanceof Infantry;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = bl2;
        IHex iHex = null;
        boolean bl12 = false;
        if (entity instanceof Mech && entity.getArmorType() == 4) {
            bl12 = true;
        }
        int n5 = hitData.getEffect() == 1 && !bl12 ? 1 : 0;
        int n6 = hitData.getEffect() == 1 && bl12 ? 1 : 0;
        HitData hitData3 = null;
        if (entity instanceof Protomech && hitData.getLocation() == 6) {
            report = new Report(6035);
            report.subject = n4;
            report.indent(2);
            report.newlines = 0;
            vector.addElement(report);
            return vector;
        }
        if (n5 > 0 && entity instanceof BattleArmor) {
            if (hitData.getLocation() >= entity.locations() || entity.getInternal(hitData.getLocation()) <= 0) {
                report = new Report(6037);
                report.add(hitData.getLocation());
                report.subject = n4;
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
                return vector;
            }
            report = new Report(6225);
            report.add(entity.getLocationAbbr(hitData));
            report.subject = n4;
            report.indent(2);
            report.newlines = 0;
            vector.addElement(report);
            n5 = 0;
            n = Math.max(entity.getInternal(hitData.getLocation()) + entity.getArmor(hitData.getLocation()), n);
        }
        if (entity != null && entity.getArmor(hitData) > 0 && (entity.getArmorType() == 1 || entity.getArmorType() == 5 || entity.getArmorType() == 6)) {
            bl9 = true;
        }
        if (!(!bl8 || entity.isDestroyed() || entity.isDoomed() || ((Infantry)entity).getDugIn() == 2 || (iHex = this.game.getBoard().getHex(entity.getPosition())) == null || n2 == 6 || iHex.containsTerrain(1) || iHex.containsTerrain(23) || iHex.containsTerrain(2) || iHex.containsTerrain(3) || iHex.containsTerrain(9) || iHex.containsTerrain(10) || iHex.containsTerrain(32) || iHex.containsTerrain(21) || bl)) {
            n *= 2;
            report = new Report(6040);
            report.subject = n4;
            report.indent(2);
            report.newlines = 0;
            vector.addElement(report);
        }
        if ((bl8 || bl5) && !entity.isDestroyed() && !entity.isDoomed() && this.game.getOptions().booleanOption("vacuum")) {
            n *= 2;
            report = new Report(6041);
            report.subject = n4;
            report.indent(2);
            report.newlines = 0;
            vector.addElement(report);
        }
        switch (n2) {
            case 1: {
                if (bl8) {
                    n *= 2;
                    report = new Report(6045);
                    report.subject = n4;
                    report.indent(2);
                    report.newlines = 0;
                    vector.addElement(report);
                    break;
                }
                if (entity == null) break;
                n = 0;
                report = new Report(6050);
                report.subject = n4;
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
                break;
            }
            case 2: {
                if (bl8) {
                    n *= 2;
                    report = new Report(6055);
                    report.subject = n4;
                    report.indent(2);
                    report.newlines = 0;
                    vector.addElement(report);
                    break;
                }
                if (entity == null || bl5) break;
                n /= 2;
                report = new Report(6060);
                report.subject = n4;
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
                break;
            }
            case 3: {
                if (bl9) {
                    n = entity.getArmor(hitData) >= 3 ? 3 : entity.getArmor(hitData);
                    report = new Report(6061);
                    report.subject = n4;
                    report.indent(2);
                    report.newlines = 0;
                    report.add(n);
                    vector.addElement(report);
                    break;
                }
                if (entity == null) break;
                report = new Report(6062);
                report.subject = n4;
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
                break;
            }
            case 4: {
                if (!bl8) break;
                n += 2;
                break;
            }
            case 5: {
                if (!bl8) {
                    n = 0;
                    report = new Report(6540);
                    report.subject = n4;
                    report.indent(2);
                    report.newlines = 0;
                    vector.addElement(report);
                }
            }
            case 6: {
                if (!bl8) break;
                n = n >= 10 ? 2 : 1;
                if (entity.getArmor(hitData) <= 0) break;
                n *= 2;
            }
        }
        boolean bl13 = entity.hasActiveEiCockpit();
        if (!(entity instanceof Mech) && !(entity instanceof Protomech) && bl13) {
            ++n;
        }
        while (n > 0) {
            int n7;
            Mech mech2;
            int n8;
            report = new Report(6065);
            report.subject = n4;
            report.indent(2);
            report.newlines = 0;
            report.addDesc(entity);
            report.add(n);
            if (bl2) {
                report.messageId = 6070;
            }
            report.add(entity.getLocationAbbr(hitData));
            vector.addElement(report);
            if (entity.getInternal(hitData) == -2) {
                n5 = 0;
            }
            if (!bl && !hitData.isFallDamage() && !bl2 && entity.hasShield() && (n8 = (mech2 = (Mech)entity).shieldAbsorptionDamage(n, hitData.getLocation(), hitData.isRear())) != n) {
                n7 = n - n8;
                n = n8;
                report = new Report(3530);
                report.subject = n4;
                report.indent(3);
                report.newlines = 0;
                report.add(n7);
                vector.addElement(report);
                if (n <= 0) {
                    n5 = 0;
                    n6 = 0;
                    bl6 = false;
                }
            }
            if (entity instanceof Mech && (mech2 = (Mech)entity).hasCowl() && hitData.getLocation() == 0 && !bl4) {
                n8 = mech2.damageCowl(n);
                n7 = n - n8;
                n = n8;
                report = new Report(3520);
                report.subject = n4;
                report.indent(3);
                report.newlines = 0;
                report.add(n7);
                vector.addElement(report);
            }
            n3 = 0;
            if (entity.hasSpotlight()) {
                n3 = 1;
                n8 = hitData.getLocation();
                if (entity instanceof Mech) {
                    if (n8 != 1 && n8 != 3 && n8 != 2) {
                        n3 = 0;
                    }
                } else if (entity instanceof Tank && n8 != 1 && n8 != 2 && n8 != 3) {
                    n3 = 0;
                }
                if (n3 != 0) {
                    n7 = Compute.d6(2);
                    report = new Report(6072);
                    report.indent(2);
                    report.subject = n4;
                    report.add(n7);
                    vector.addElement(report);
                    if (n7 >= 7) {
                        report = new Report(6071);
                        report.subject = n4;
                        report.indent(2);
                        vector.addElement(report);
                        entity.setSpotlightState(false);
                        entity.setSpotlight(false);
                    }
                }
            }
            if (!bl2) {
                boolean bl14;
                n8 = hitData.getLocation();
                Entity entity2 = entity.getExteriorUnitAt(n8, hitData.isRear());
                if (!bl && null != entity2 && !entity2.isDoomed() && n2 != 7) {
                    HitData hitData2;
                    report = new Report(6075);
                    report.subject = entity2.getId();
                    report.indent(3);
                    report.addDesc(entity2);
                    vector.addElement(report);
                    HitData hitData4 = entity2.getTrooperAtLocation(hitData, entity);
                    int n9 = 0;
                    HitData hitData5 = hitData4;
                    do {
                        void var31_59;
                        if (0 < entity2.getArmor((HitData)var31_59)) {
                            n9 += entity2.getArmor((HitData)var31_59);
                        }
                        if (0 < entity2.getInternal((HitData)var31_59)) {
                            n9 += entity2.getInternal((HitData)var31_59);
                        }
                        hitData2 = entity2.getTransferLocation((HitData)var31_59);
                    } while (n > n9 && hitData2.getLocation() >= 0);
                    vector.addAll(this.damageEntity(entity2, hitData4, n));
                    if (n > n9) {
                        report = new Report(6080);
                        report.subject = n4;
                        report.indent(1);
                        report.add(n -= n9);
                        report.addDesc(entity);
                        vector.addElement(report);
                    } else {
                        return vector;
                    }
                }
                boolean bl15 = bl14 = n8 == 1 || n8 == 2 || n8 == 3;
                if (entity instanceof Mech && hitData.isRear() && bl14) {
                    for (Mounted mounted : entity.getAmmo()) {
                        if (!mounted.isDumping() || mounted.isDestroyed() || mounted.isHit()) continue;
                        vector.addAll(this.explodeEquipment(entity, mounted.getLocation(), mounted));
                        mounted.setHit(true);
                    }
                }
            }
            if (!bl && entity.getArmor(hitData) > 0 && !bl2) {
                n8 = -1;
                if (bl12) {
                    n8 = n;
                    n /= 2;
                    n += n8 % 2;
                } else if (bl8) {
                    int n10 = entity.getArmor(hitData);
                    int n11 = entity.getInternal(hitData);
                    n8 = n % 2;
                    n /= 2;
                    n8 = n8 == 1 && n10 >= n11 ? n++ : (n8 += n);
                }
                if (entity.getArmor(hitData) > n) {
                    entity.setArmor(entity.getArmor(hitData) - n, hitData);
                    entity.damageThisPhase = n8 >= 0 ? (entity.damageThisPhase += n8) : (entity.damageThisPhase += n);
                    n = 0;
                    report = new Report(6085);
                    report.subject = n4;
                    report.newlines = 0;
                    if (n3 != 0) {
                        report.indent(3);
                    }
                    report.add(entity.getArmor(hitData));
                    vector.addElement(report);
                } else {
                    int n12 = Math.max(entity.getArmor(hitData), 0);
                    entity.setArmor(-3, hitData);
                    entity.damageThisPhase = n8 >= 0 ? (entity.damageThisPhase += 2 * n12) : (entity.damageThisPhase += n12);
                    n -= n12;
                    report = new Report(6090);
                    report.subject = n4;
                    report.newlines = 0;
                    if (n3 != 0) {
                        report.indent(3);
                    }
                    vector.addElement(report);
                    if (entity instanceof GunEmplacement) {
                        this.destroyLocation(entity, hitData.getLocation());
                        report = new Report(6115);
                        report.subject = n4;
                        report.newlines = 0;
                        vector.addElement(report);
                        if (entity.getTransferLocation(hitData).getLocation() == -2) {
                            vector.addAll(this.destroyEntity(entity, "damage", false));
                        }
                    }
                }
                if (n8 > 0) {
                    if (bl12) {
                        n *= 2;
                        n -= n8 % 2;
                    } else if (bl8) {
                        n = n8;
                    }
                }
            }
            if (n > 0) {
                bl11 = true;
                if (entity.getInternal(hitData) > 0) {
                    if (!bl8 && !bl5) {
                        ++n5;
                    }
                    n8 = -1;
                    if (entity instanceof Mech && ((Mech)entity).hasCompositeStructure()) {
                        n8 = n;
                        n *= 2;
                    }
                    if (entity instanceof Mech && ((Mech)entity).hasReinforcedStructure()) {
                        n8 = n;
                        n /= 2;
                        n += n8 % 2;
                    }
                    if (entity.getInternal(hitData) > n) {
                        entity.setInternal(entity.getInternal(hitData) - n, hitData);
                        entity.damageThisPhase += n;
                        n = 0;
                        report = new Report(1210);
                        report.subject = n4;
                        report.newlines = 0;
                        report.messageId = bl8 ? 6095 : 6100;
                        report.add(entity.getInternal(hitData));
                        vector.addElement(report);
                    } else {
                        Entity entity3;
                        int n13;
                        int n14 = Math.max(entity.getInternal(hitData), 0);
                        if (entity instanceof Protomech && (n13 = Protomech.POSSIBLE_PILOT_DAMAGE[hitData.getLocation()] - ((Protomech)entity).getPilotDamageTaken(hitData.getLocation())) > 0) {
                            vector.addAll(this.damageCrew(entity, n13));
                            ((Protomech)entity).setPilotDamageTaken(hitData.getLocation(), Protomech.POSSIBLE_PILOT_DAMAGE[hitData.getLocation()]);
                        }
                        report = new Report(1210);
                        report.subject = n4;
                        report.newlines = 0;
                        report.messageId = bl8 ? 6105 : (bl5 ? 6110 : 6115);
                        vector.addElement(report);
                        if (entity instanceof Mech && (hitData.getLocation() == 2 && entity.getInternal(4) > 0 || hitData.getLocation() == 3 && entity.getInternal(5) > 0)) {
                            int n15 = -1;
                            n15 = hitData.getLocation() == 2 ? 4 : 5;
                            report = new Report(6120);
                            report.subject = n4;
                            report.add(entity.getLocationName(n15));
                            report.newlines = 0;
                            vector.addElement(report);
                            IHex iHex2 = this.game.getBoard().getHex(entity.getPosition());
                            if (entity instanceof BipedMech) {
                                if (!iHex2.containsTerrain(18)) {
                                    iHex2.addTerrain(Terrains.getTerrainFactory().createTerrain(18, 1));
                                } else {
                                    iHex2.addTerrain(Terrains.getTerrainFactory().createTerrain(18, iHex2.terrainLevel(18) + 1));
                                }
                            } else if (!iHex2.containsTerrain(19)) {
                                iHex2.addTerrain(Terrains.getTerrainFactory().createTerrain(19, 1));
                            } else {
                                iHex2.addTerrain(Terrains.getTerrainFactory().createTerrain(19, iHex2.terrainLevel(19) + 1));
                            }
                            this.sendChangedHex(entity.getPosition());
                        }
                        if (this.game.getOptions().booleanOption("maxtech_mechanized_ba") && entity instanceof Mech && null != (entity3 = entity.getExteriorUnitAt(hitData.getLocation(), hitData.isRear())) && !entity3.isDoomed()) {
                            HitData hitData5 = entity3.getTrooperAtLocation(hitData, entity);
                            hitData5.setEffect(1);
                            if (entity3.getInternal(hitData5) > 0) {
                                vector.addAll(this.damageEntity(entity3, hitData5, n));
                            }
                            hitData5 = new HitData(hitData.getLocation(), !hitData.isRear());
                            hitData5 = entity3.getTrooperAtLocation(hitData5, entity);
                            hitData5.setEffect(1);
                            if (entity3.getInternal(hitData5) > 0) {
                                vector.addAll(this.damageEntity(entity3, hitData5, n));
                            }
                        }
                        this.destroyLocation(entity, hitData.getLocation());
                        entity.damageThisPhase += n14;
                        n -= n14;
                        if (n8 > 0) {
                            if (((Mech)entity).hasCompositeStructure()) {
                                n /= 2;
                            } else if (((Mech)entity).hasReinforcedStructure()) {
                                n *= 2;
                                n -= n8 % 2;
                            }
                        }
                        if (entity instanceof Mech && (hitData.getLocation() == 2 || hitData.getLocation() == 3)) {
                            boolean bl16 = false;
                            int n16 = 0;
                            n16 += entity.getHitCriticals(0, 3, 1);
                            n16 += entity.getHitCriticals(0, 3, 2);
                            bl16 = this.checkEngineExplosion(entity, vector, n16 += entity.getHitCriticals(0, 3, 3));
                            if (!bl16 && n16 > 2) {
                                vector.addAll(this.destroyEntity(entity, "engine destruction"));
                                if (this.game.getOptions().booleanOption("auto_abandon_unit")) {
                                    vector.addAll(this.abandonEntity(entity));
                                }
                            }
                        }
                        if (entity instanceof VTOL && hitData.getLocation() == 5) {
                            hitData.setEffect(2);
                        }
                    }
                }
                if (entity.getInternal(hitData) <= 0) {
                    hitData3 = entity.getTransferLocation(hitData);
                    if (hitData3.getLocation() == -2) {
                        if (entity instanceof Mech) {
                            entity.engineHitsThisRound += entity.getGoodCriticals(0, 3, hitData.getLocation());
                            entity.engineHitsThisRound -= entity.getHitCriticals(0, 3, hitData.getLocation());
                        }
                        n8 = 0;
                        n8 = this.checkEngineExplosion(entity, vector, entity.engineHitsThisRound) ? 1 : 0;
                        if (!(n8 != 0 || entity instanceof VTOL && hitData.getLocation() == 5)) {
                            vector.addAll(this.destroyEntity(entity, "damage", !bl, !bl && !bl3 || hitData.getLocation() != 1));
                            if (hitData.getLocation() == 0 || hitData.getLocation() == 1 && (bl && !bl7 || bl3)) {
                                entity.getCrew().setDoomed(true);
                            }
                            if (this.game.getOptions().booleanOption("auto_abandon_unit")) {
                                vector.addAll(this.abandonEntity(entity));
                            }
                        }
                        n = 0;
                    } else if (hitData3.getLocation() == -1) {
                        n = 0;
                    } else if (bl && entity.locationHasCase(hitData.getLocation())) {
                        report = new Report(6125);
                        report.subject = n4;
                        report.add(n);
                        report.indent(3);
                        report.newlines = 0;
                        vector.addElement(report);
                        entity.damageThisPhase += n;
                        n = 0;
                    } else if (n > 0) {
                        report = new Report(6130);
                        report.subject = n4;
                        report.indent(2);
                        report.newlines = 0;
                        report.add(n);
                        report.add(entity.getLocationAbbr(hitData3));
                        vector.addElement(report);
                        for (Mounted mounted : entity.getWeaponList()) {
                            if (!mounted.isSplit() || mounted.getLocation() != hitData.getLocation() && mounted.getLocation() != hitData3.getLocation()) continue;
                            entity.setWeaponDestroyed(mounted);
                        }
                    }
                }
            } else if (hitData.getSpecCritMod() < 0) {
                ++n6;
            }
            vector.addAll(this.breachCheck(entity, hitData.getLocation(), null));
            if (hitData.getEffect() == 3) {
                report = new Report(6135);
                report.subject = n4;
                report.indent(3);
                vector.addElement(report);
                int n17 = entity.getOriginalWalkMP();
                if (n17 > 0) {
                    entity.setOriginalWalkMP(n17 - 1);
                    if (entity.getOriginalWalkMP() == 0 && entity.getMovementMode() == 5 && this.game.getBoard().getHex(entity.getPosition()).terrainLevel(4) > 0 && !this.game.getBoard().getHex(entity.getPosition()).containsTerrain(20)) {
                        vector.addAll(this.destroyEntity(entity, "a watery grave", false));
                    }
                }
            } else if (hitData.getEffect() == 2) {
                report = new Report(6140);
                report.subject = n4;
                report.indent(3);
                vector.addElement(report);
                ((Tank)entity).immobilize();
                iHex = this.game.getBoard().getHex(entity.getPosition());
                if (entity.getMovementMode() == 5 && iHex.terrainLevel(4) > 0 && !iHex.containsTerrain(20)) {
                    vector.addAll(this.destroyEntity(entity, "a watery grave", false));
                }
                if (entity instanceof VTOL) {
                    Report.addNewline(vector);
                    vector.addAll(this.crashVTOL((VTOL)entity));
                }
            } else if (hitData.getEffect() == 4) {
                report = new Report(6145);
                report.subject = n4;
                report.indent(3);
                vector.addElement(report);
                ((Tank)entity).lockTurret();
            } else if (hitData.getEffect() == 5) {
                report = new Report(6146);
                report.subject = n4;
                report.indent(3);
                vector.addElement(report);
                for (Mounted mounted : entity.getWeaponList()) {
                    mounted.setDestroyed(true);
                }
            } else if (hitData.getEffect() == 6) {
                report = new Report(6145);
                report.subject = n4;
                report.indent(3);
                vector.addElement(report);
                ((GunEmplacement)entity).setTurretLocked(true);
            } else if (hitData.getEffect() == 7) {
                report = new Report(6148);
                report.subject = n4;
                report.indent(3);
                vector.addElement(report);
                ((GunEmplacement)entity).getCrew().setDoomed(true);
            }
            if (entity.getInternal(hitData) != -3) {
                int n18;
                for (n18 = 0; n18 < n5; ++n18) {
                    ++((Report)vector.elementAt((int)(vector.size() - 1))).newlines;
                    vector.addAll(this.criticalEntity(entity, hitData.getLocation(), hitData.glancingMod()));
                }
                n5 = 0;
                for (n18 = 0; n18 < n6; ++n18) {
                    ++((Report)vector.elementAt((int)(vector.size() - 1))).newlines;
                    vector.addAll(this.criticalEntity(entity, hitData.getLocation(), (bl12 ? -2 : hitData.getSpecCritMod()) + hitData.glancingMod()));
                }
                n6 = 0;
            }
            if (bl6) {
                Report.addNewline(vector);
                vector.addAll(this.damageCrew(entity, 1));
            }
            hitData = hitData3;
            if (!bl2) continue;
            bl10 = true;
            bl2 = false;
        }
        if (bl11 && (entity instanceof Mech || entity instanceof Protomech) && entity.hasActiveEiCockpit()) {
            Report.addNewline(vector);
            n3 = Compute.d6(2);
            report = new Report(5075);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(7);
            report.add(n3);
            report.choose(n3 >= 7);
            report.indent(2);
            vector.add(report);
            if (n3 < 7) {
                vector.addAll(this.damageCrew(entity, 1));
            }
        }
        if (bl8) {
            float f = 0.0f;
            for (Mounted mounted : entity.getWeaponList()) {
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (weaponType.hasFlag(2048L) || !((f += weaponType.getTonnage(entity)) > (float)entity.getInternal(0))) continue;
                mounted.setDestroyed(true);
            }
        }
        if (bl10) {
            Report.addNewline(vector);
        }
        return vector;
    }

    private boolean checkEngineExplosion(Entity entity, Vector vector, int n) {
        int n2;
        if (!(entity instanceof Mech || entity instanceof QuadMech || entity instanceof BipedMech)) {
            return false;
        }
        if (entity.isDestroyed()) {
            return false;
        }
        Mech mech = (Mech)entity;
        if (entity.rolledForEngineExplosion) {
            return false;
        }
        if (mech.getEngine().isFusion() && (!this.game.getOptions().booleanOption("engine_explosions") || entity.engineHitsThisRound < 2)) {
            return false;
        }
        int n3 = 12;
        if (!mech.getEngine().isFusion()) {
            switch (n) {
                case 0: {
                    return false;
                }
                case 1: {
                    n3 = 10;
                    break;
                }
                case 2: {
                    n3 = 7;
                    break;
                }
                default: {
                    n3 = 4;
                }
            }
        }
        boolean bl = (n2 = Compute.d6(2)) >= n3;
        Report report = new Report(6150);
        report.subject = entity.getId();
        report.indent(2);
        report.addDesc(entity);
        report.add(entity.engineHitsThisRound);
        vector.addElement(report);
        report = new Report(6155);
        report.subject = entity.getId();
        report.indent(2);
        report.add(n3);
        report.add(n2);
        vector.addElement(report);
        if (!bl) {
            if (mech.getEngine().isFusion()) {
                entity.rolledForEngineExplosion = true;
            }
            report = new Report(6160);
            report.subject = entity.getId();
            report.indent(2);
            vector.addElement(report);
        } else {
            IHex iHex;
            entity.rolledForEngineExplosion = true;
            report = new Report(6165, 0);
            report.subject = entity.getId();
            report.indent(2);
            vector.addElement(report);
            vector.addAll(this.destroyEntity(entity, "engine explosion", false, false));
            entity.getCrew().setDoomed(true);
            if (entity instanceof Mech) {
                this.destroyLocation(entity, 1);
            }
            if (null != (iHex = this.game.getBoard().getHex(entity.getPosition())) && !iHex.containsTerrain(7) && (iHex.containsTerrain(1) || iHex.containsTerrain(23))) {
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                report = new Report(6170, 0);
                report.subject = entity.getId();
                report.indent(2);
                report.add(entity.getPosition().getBoardNum());
                vector.addElement(report);
                this.sendChangedHex(entity.getPosition());
            }
            if (mech.getEngine().isFusion()) {
                int n4 = entity.getEngine().getRating();
                this.doFusionEngineExplosion(n4, entity.getPosition(), vector, null);
            }
        }
        return bl;
    }

    public void doFusionEngineExplosion(int n, Coords coords, Vector vector, Vector vector2) {
        int[] nArray = new int[]{n, n / 10, n / 20, n / 40};
        this.doExplosion(nArray, true, coords, false, vector, vector2);
    }

    private Coords getEntityActualPosition(Entity entity) {
        Entity entity2;
        Coords coords = entity.getPosition();
        if (coords == null && (entity2 = this.game.getEntity(entity.getTransportId())) != null) {
            coords = entity2.getPosition();
        }
        return coords;
    }

    public void doExplosion(int n, int n2, boolean bl, Coords coords, boolean bl2, Vector vector, Vector vector2) {
        int[] nArray = new int[n / n2];
        nArray[0] = n;
        for (int i = 1; i < nArray.length; ++i) {
            nArray[i] = nArray[i - 1] - n2;
        }
        this.doExplosion(nArray, bl, coords, bl2, vector, vector2);
    }

    public void doExplosion(int[] nArray, boolean bl, Coords coords, boolean bl2, Vector vector, Vector vector2) {
        int n;
        Report report;
        int n2;
        Serializable serializable;
        Entity entity;
        Serializable serializable2;
        Object object;
        Serializable serializable3;
        if (vector == null) {
            vector = new Vector<Serializable>();
        }
        if (vector2 == null) {
            vector2 = new Vector<Integer>();
        }
        HashSet<Entity> hashSet = new HashSet<Entity>();
        Enumeration enumeration = this.game.getBoard().getBuildings();
        while (enumeration.hasMoreElements()) {
            Coords coords2;
            serializable3 = (Building)enumeration.nextElement();
            object = ((Building)serializable3).getCoords();
            try {
                coords2 = (Coords)object.nextElement();
            }
            catch (Exception exception) {
                continue;
            }
            int n3 = coords.distance(coords2);
            while (object.hasMoreElements()) {
                serializable2 = (Coords)object.nextElement();
                if (coords.distance(coords2) >= n3) continue;
                n3 = coords.distance(coords2);
                coords2 = serializable2;
            }
            if (n3 >= nArray.length || (serializable2 = this.damageBuilding((Building)serializable3, nArray[n3])) == null) continue;
            ((Report)serializable2).type = 0;
            vector.addElement(serializable2);
        }
        this.applyBuildingDamage();
        serializable3 = this.game.getEntitiesVector();
        object = new ArrayList();
        for (int i = 0; i < ((Vector)serializable3).size(); ++i) {
            entity = (Entity)((Vector)serializable3).elementAt(i);
            if (hashSet.contains(entity) || entity.isDestroyed() || !entity.isDeployed()) continue;
            serializable2 = entity.getPosition();
            if (serializable2 == null) {
                serializable = this.game.getEntity(entity.getTransportId());
                if (serializable == null) continue;
                ((ArrayList)object).add(entity);
                continue;
            }
            int n4 = coords.distance((Coords)serializable2);
            if (n4 >= nArray.length) continue;
            if (n4 == 0 && bl) {
                vector.addAll(this.destroyEntity(entity, "explosion proximity", false, false));
                vector2.add(Autobox.valueOf((int)entity.getId()));
                entity.getCrew().setDoomed(true);
                hashSet.add(entity);
                continue;
            }
            n2 = nArray[n4];
            if (bl2 && this.canShelter((Coords)serializable2, coords, entity.absHeight())) {
                if (this.isSheltered()) {
                    report = new Report(6545);
                    report.addDesc(entity);
                    report.subject = entity.getId();
                    vector.addElement(report);
                    continue;
                }
                report = new Report(6546);
                report.subject = entity.getId();
                report.addDesc(entity);
                vector.addElement(report);
            }
            vector2.add(Autobox.valueOf((int)entity.getId()));
            report = new Report(6175);
            report.subject = entity.getId();
            report.indent(2);
            report.addDesc(entity);
            report.add(n2);
            report.newlines = 0;
            vector.addElement(report);
            while (n2 > 0) {
                n = Math.min(5, n2);
                HitData hitData = entity.rollHitLocation(0, Compute.targetSideTable(coords, (Targetable)entity));
                vector.addAll(this.damageEntity(entity, hitData, n, false, 7, false, true));
                n2 -= n;
            }
            Report.addNewline(vector);
        }
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            int n5;
            entity = (Entity)iterator.next();
            serializable2 = this.game.getEntity(entity.getTransportId());
            if (serializable2 != null && !((ArrayList)((Entity)serializable2).getExternalUnits()).contains(entity) || (n2 = coords.distance((Coords)(serializable = serializable2 == null ? entity.getPosition() : ((Entity)serializable2).getPosition()))) >= nArray.length) continue;
            n = nArray[n2];
            if (bl2) {
                int n6 = n5 = serializable2 == null ? entity.absHeight() : ((Entity)serializable2).absHeight();
                if (serializable != null && this.canShelter((Coords)serializable, coords, n5)) {
                    if (this.isSheltered()) {
                        report = new Report(6545);
                        report.addDesc(entity);
                        report.subject = entity.getId();
                        vector.addElement(report);
                        continue;
                    }
                    report = new Report(6546);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    vector.addElement(report);
                }
            }
            vector2.add(Autobox.valueOf((int)entity.getId()));
            report = new Report(6175);
            report.subject = entity.getId();
            report.indent(2);
            report.addDesc(entity);
            report.add(n);
            report.newlines = 0;
            vector.addElement(report);
            while (n > 0) {
                n5 = Math.min(5, n);
                HitData hitData = entity.rollHitLocation(0, 0);
                vector.addAll(this.damageEntity(entity, hitData, n5, false, 7, false, true));
                n -= n5;
            }
            Report.addNewline(vector);
        }
    }

    public boolean canShelter(Coords coords, Coords coords2, int n) {
        Coords coords3 = Coords.nextHex(coords, coords2);
        IHex iHex = this.game.getBoard().getHex(coords3);
        if (iHex == null) {
            return false;
        }
        int n2 = iHex.floor();
        if (iHex.containsTerrain(10)) {
            n2 = iHex.ceiling();
        }
        return (n += this.game.getBoard().getHex(coords).surface()) < n2;
    }

    private boolean isSheltered() {
        return Compute.d6(2) >= 9;
    }

    public void doNuclearExplosion(Coords coords, int n, Vector vector) {
        switch (n) {
            case 0: 
            case 1: {
                this.doNuclearExplosion(coords, 100, 5, 40, 0, vector);
                break;
            }
            case 2: {
                this.doNuclearExplosion(coords, 1000, 23, 86, 1, vector);
                break;
            }
            case 3: {
                this.doNuclearExplosion(coords, 10000, 109, 184, 3, vector);
                break;
            }
            case 4: {
                this.doNuclearExplosion(coords, 100000, 505, 396, 5, vector);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void doNuclearExplosion(Coords coords, int n, int n2, int n3, int n4, Vector vector) {
        Object object;
        Object object2;
        Cloneable cloneable;
        Serializable serializable;
        Enumeration enumeration;
        if (vector == null) {
            vector = new Vector<Report>();
        }
        Report report = new Report(1215, 0);
        report.indent();
        report.add(coords.getBoardNum(), true);
        this.addReport(report);
        int n5 = this.game.getBoard().getHex(coords).floor() - n4;
        int n6 = 0;
        while (n6 < 2 * n4) {
            enumeration = this.game.getBoard().getHexesAtDistance(coords, n6);
            while (enumeration.hasMoreElements()) {
                serializable = (Coords)enumeration.nextElement();
                cloneable = this.game.getBoard().getHex((Coords)serializable);
                cloneable.setElevation(cloneable.getElevation() - n4 + n6 / 2);
                if (cloneable.containsTerrain(4)) {
                    cloneable.setElevation(cloneable.floor());
                }
                cloneable.removeAllTerrains();
                cloneable.clearExits();
                this.sendChangedHex((Coords)serializable);
            }
            if (++n6 <= 0 || n6 % 2 != 0) continue;
            ++n5;
        }
        enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            serializable = (Entity)enumeration.nextElement();
            if (((Entity)serializable).getTransportId() != -1 || coords.distance(((Entity)serializable).getPosition()) >= n6 || ((Entity)serializable).isDestroyed()) continue;
            vector.addAll(this.destroyEntity((Entity)serializable, "nuclear explosion proximity", false, false));
            ((Entity)serializable).getCrew().setDoomed(true);
        }
        enumeration = null;
        serializable = new Vector();
        cloneable = new Vector();
        this.doExplosion(n, n2, false, coords, true, (Vector)serializable, (Vector)cloneable);
        Report.indentAll((Vector)serializable, 2);
        vector.addAll((Collection<Report>)((Object)serializable));
        Object object3 = ((Vector)cloneable).iterator();
        while (object3.hasNext()) {
            Entity entity;
            object2 = object3.next();
            Entity entity2 = this.game.getEntity((Integer)object2);
            if (entity2 instanceof Mech) {
                entity = (Mech)entity2;
                if (entity.isProne()) continue;
                this.game.addPSR(new PilotingRollData(entity.getId(), 6, "hit by nuclear blast"));
                continue;
            }
            if (entity2 instanceof VTOL) {
                entity = (VTOL)entity2;
                if (entity.getElevation() <= 0) continue;
                this.game.addPSR(new PilotingRollData(entity.getId(), 6, "hit by nuclear blast"));
                continue;
            }
            if (!(entity2 instanceof Tank)) continue;
        }
        serializable = null;
        object3 = this.game.getBoard().getBuildingAt(coords);
        if (object3 != null) {
            report = new Report(2415);
            report.add(((Building)object3).getName());
            this.addReport(report);
            this.collapseBuilding((Building)object3, this.game.getPositionMap());
        }
        if ((object2 = this.game.getBoard().getHex(coords)).containsTerrain(4)) {
            object2.setElevation(object2.floor());
        }
        object2.removeAllTerrains();
        boolean bl = true;
        int n7 = n - n2 * n6;
        if (n7 > 0) {
            int n8 = n6;
            while (bl) {
                object = this.game.getBoard().getHexesAtDistance(coords, n8);
                while (object.hasMoreElements()) {
                    int n9;
                    int n10;
                    Coords coords2 = (Coords)object.nextElement();
                    IHex iHex = this.game.getBoard().getHex(coords2);
                    if (n7 >= 3000 && iHex.containsTerrain(4)) {
                        n10 = n7 / 3000;
                        n9 = iHex.terrainLevel(4);
                        iHex.removeTerrain(4);
                        if (n9 > n10) {
                            iHex.addTerrain(new Terrain(4, n9 - n10));
                        }
                    }
                    if (n7 >= 200 && !iHex.containsTerrain(4)) {
                        iHex.removeAllTerrains();
                        iHex.clearExits();
                        iHex.addTerrain(new Terrain(2, 1));
                    } else if (n7 >= 20 && (iHex.containsTerrain(1) || iHex.containsTerrain(23))) {
                        n10 = n7 / 20;
                        n9 = iHex.containsTerrain(1) ? 1 : 23;
                        int n11 = iHex.terrainLevel(n9);
                        iHex.removeTerrain(n9);
                        if (n11 > n10) {
                            iHex.addTerrain(new Terrain(n9, n11 - n10));
                        }
                    }
                    this.sendChangedHex(coords2);
                }
                n7 = n - (n2 * n8 + 1);
                if (n7 < 20) {
                    bl = false;
                }
                ++n8;
            }
        }
        Enumeration enumeration2 = this.game.getEntities();
        while (enumeration2.hasMoreElements()) {
            object = (Entity)enumeration2.nextElement();
            if (coords.distance(((Entity)object).getPosition()) > n3 || ((Entity)object).isDoomed() || ((Entity)object).isDestroyed()) continue;
            this.applySecondaryNuclearEffects((Entity)object, coords, vector);
        }
        report = new Report(1216, 0);
        report.indent();
        report.newlines = 2;
        vector.add(report);
    }

    public void applySecondaryNuclearEffects(Entity entity, Coords coords, Vector vector) {
        if (entity.isDestroyed()) {
            return;
        }
        boolean bl = Compute.isInBuilding(this.game, entity) && this.game.getBoard().getHex(entity.getPosition()).terrainLevel(10) == 4;
        int n = Compute.d6(2);
        Report report = new Report(6555);
        report.subject = entity.getId();
        report.add(entity.getDisplayName());
        report.add(n);
        if (bl) {
            n += 2;
            report.add(" + 2 (unit is in hardened building)");
        } else {
            report.add("");
        }
        if (entity.isNuclearHardened()) {
            n += 2;
            report.add(" + 2 (unit is hardened against EMI)");
        } else {
            report.add("");
        }
        report.indent(2);
        vector.add(report);
        if (n <= 4) {
            vector.addAll(this.destroyEntity(entity, "nuclear explosion secondary effects", false, false));
            entity.getCrew().setDoomed(true);
        } else if (n <= 6) {
            if (entity instanceof BattleArmor) {
                BattleArmor battleArmor = (BattleArmor)entity;
                int n2 = (int)(Math.ceil(battleArmor.getNumberActiverTroopers()) / 2.0);
                for (int i = 0; i < n2; ++i) {
                    vector.addAll(this.applyCriticalHit(entity, 0, null, false));
                }
            } else if (entity instanceof Infantry) {
                if (this.game.getBoard().getHex(entity.getPosition()).containsTerrain(10)) {
                    int n3 = (int)Math.ceil((double)((Infantry)entity).getInternal(0) / 2.0);
                    HitData hitData = entity.rollHitLocation(0, Compute.targetSideTable(coords, (Targetable)entity));
                    vector.addAll(this.damageEntity(entity, new HitData(0), n3, true));
                } else {
                    vector.addAll(this.destroyEntity(entity, "nuclear explosion secondary effects", false, false));
                    entity.getCrew().setDoomed(true);
                }
            } else if (entity instanceof Tank) {
                HitData hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                vector.addAll(this.applyCriticalHit(entity, 0, new CriticalSlot(0, 4), false));
            } else if (entity instanceof Mech || entity instanceof Protomech) {
                HitData hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                vector.addAll(this.damageCrew(entity, 4));
            }
        } else if (n <= 10) {
            if (entity instanceof BattleArmor) {
                BattleArmor battleArmor = (BattleArmor)entity;
                int n4 = (int)Math.ceil((double)battleArmor.getNumberActiverTroopers() / 4.0);
                for (int i = 0; i < n4; ++i) {
                    vector.addAll(this.applyCriticalHit(entity, 0, null, false));
                }
            } else if (entity instanceof Infantry) {
                if (this.game.getBoard().getHex(entity.getPosition()).containsTerrain(10)) {
                    int n5 = (int)Math.ceil((double)((Infantry)entity).getInternal(0) / 4.0);
                    HitData hitData = entity.rollHitLocation(0, Compute.targetSideTable(coords, (Targetable)entity));
                    vector.addAll(this.damageEntity(entity, new HitData(0), n5, true));
                } else {
                    int n6 = (int)Math.ceil((double)((Infantry)entity).getInternal(0) / 2.0);
                    HitData hitData = entity.rollHitLocation(0, Compute.targetSideTable(coords, (Targetable)entity));
                    vector.addAll(this.damageEntity(entity, new HitData(0), n6, true));
                }
            } else if (entity instanceof Tank) {
                HitData hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                vector.addAll(this.applyCriticalHit(entity, 0, new CriticalSlot(0, 1), false));
            } else if (entity instanceof Mech || entity instanceof Protomech) {
                HitData hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                vector.addAll(this.damageCrew(entity, 2));
            }
        }
        entity.setEMI(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Vector applyCriticalHit(Entity entity, int n, CriticalSlot criticalSlot, boolean bl) {
        Report report;
        Vector<Report> vector;
        block58: {
            block60: {
                block61: {
                    int n2;
                    block59: {
                        block57: {
                            vector = new Vector<Report>();
                            if (!(entity instanceof Tank)) break block57;
                            Tank tank = (Tank)entity;
                            VTOL vTOL = null;
                            if (entity instanceof VTOL) {
                                vTOL = (VTOL)entity;
                            }
                            report = new Report(6180);
                            report.subject = entity.getId();
                            report.indent(3);
                            report.newlines = 0;
                            vector.addElement(report);
                            switch (criticalSlot.getIndex()) {
                                case 1: {
                                    if (vTOL == null) {
                                        report = new Report(6185);
                                        report.subject = entity.getId();
                                        report.newlines = 0;
                                        vector.addElement(report);
                                        tank.stunCrew();
                                        break;
                                    }
                                    report = new Report(6190);
                                    report.subject = entity.getId();
                                    report.newlines = 0;
                                    vector.addElement(report);
                                    vector.addAll(this.destroyEntity(vTOL, "crew death", true));
                                    entity.getCrew().setDoomed(true);
                                    vector.addAll(this.crashVTOL(vTOL));
                                    break;
                                }
                                case 2: {
                                    Mounted mounted = tank.getMainWeapon();
                                    if (mounted == null) {
                                        report = new Report(6195);
                                        report.subject = entity.getId();
                                        report.newlines = 0;
                                        vector.addElement(report);
                                        break;
                                    }
                                    report = new Report(6200);
                                    report.subject = entity.getId();
                                    report.add(mounted.getName());
                                    int n3 = tank.getJammedTurns() + 1;
                                    if (n3 > 1) {
                                        report.messageId = 6205;
                                        report.add(n3);
                                    }
                                    report.newlines = 0;
                                    vector.addElement(report);
                                    tank.setJammedTurns(n3);
                                    break;
                                }
                                case 3: {
                                    report = new Report(6210);
                                    report.subject = entity.getId();
                                    report.newlines = 0;
                                    vector.addElement(report);
                                    tank.immobilize();
                                    if (bl) {
                                        IHex iHex = this.game.getBoard().getHex(entity.getPosition());
                                        if (vTOL == null) {
                                            if (entity.getMovementMode() != 5 || iHex.terrainLevel(4) <= 0 || iHex.containsTerrain(20)) break;
                                            vector.addAll(this.destroyEntity(entity, "a watery grave", false));
                                            break;
                                        }
                                        Report.addNewline(vector);
                                        vector.addAll(this.crashVTOL(vTOL));
                                        break;
                                    }
                                    break block58;
                                }
                                case 4: {
                                    report = new Report(6190);
                                    report.subject = entity.getId();
                                    report.newlines = 0;
                                    vector.addElement(report);
                                    vector.addAll(this.destroyEntity(entity, "crew death", true));
                                    entity.getCrew().setDoomed(true);
                                    if (vTOL != null) {
                                        Report.addNewline(vector);
                                        vector.addAll(this.crashVTOL(vTOL));
                                        break;
                                    }
                                    break block58;
                                }
                                case 5: {
                                    report = new Report(6215);
                                    report.subject = entity.getId();
                                    report.newlines = 0;
                                    vector.addElement(report);
                                    if (vTOL == null) {
                                        vector.addAll(this.destroyEntity(entity, "fuel tank explosion", false, false));
                                    } else {
                                        Report.addNewline(vector);
                                        vector.addAll(this.explodeVTOL(vTOL));
                                    }
                                    entity.getCrew().setDoomed(true);
                                    break;
                                }
                                case 6: {
                                    report = new Report(6220);
                                    report.subject = entity.getId();
                                    report.newlines = 0;
                                    vector.addElement(report);
                                    boolean bl2 = entity.locationHasCase(0);
                                    if (vTOL == null) {
                                        vector.addAll(this.destroyEntity(entity, "power plant destruction", bl2, bl2));
                                    } else {
                                        Report.addNewline(vector);
                                        vector.addAll(this.explodeVTOL(vTOL));
                                    }
                                    entity.getCrew().setDoomed(!bl2);
                                    break;
                                }
                            }
                            break block58;
                        }
                        if (!(entity instanceof BattleArmor)) break block59;
                        BattleArmor battleArmor = (BattleArmor)entity;
                        report = new Report(6111);
                        int n4 = battleArmor.getRandomTrooper();
                        this.destroyLocation(battleArmor, n4);
                        report.add(n4);
                        report.newlines = 1;
                        vector.add(report);
                        break block58;
                    }
                    if (0 != criticalSlot.getType()) break block60;
                    criticalSlot.setHit(true);
                    if (!(entity instanceof Protomech)) break block61;
                    int n5 = ((Protomech)entity).getCritsHit(n);
                    if (criticalSlot.getIndex() != 4 && criticalSlot.getIndex() != 5) {
                        report = new Report(6225);
                        report.subject = entity.getId();
                        report.indent(3);
                        report.newlines = 0;
                        report.add(Protomech.systemNames[criticalSlot.getIndex()]);
                        vector.addElement(report);
                    }
                    block8 : switch (criticalSlot.getIndex()) {
                        case 2: {
                            if (2 != n5) break;
                            report = new Report(6230);
                            report.subject = entity.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                            this.destroyLocation(entity, n);
                            break;
                        }
                        case 0: {
                            if (2 != n5) break;
                            report = new Report(6235);
                            report.subject = entity.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                            this.destroyLocation(entity, n);
                            break;
                        }
                        case 1: {
                            if (3 != n5) break;
                            report = new Report(6240);
                            report.subject = entity.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                            this.destroyLocation(entity, n);
                            break;
                        }
                        case 3: {
                            if (3 == n5) {
                                vector.addAll(this.destroyEntity(entity, "torso destruction"));
                                break;
                            }
                            if (!bl) break;
                            int n6 = Compute.d6(1);
                            CriticalSlot criticalSlot2 = null;
                            switch (n6) {
                                case 1: 
                                case 2: {
                                    criticalSlot2 = new CriticalSlot(0, 4);
                                    vector.addAll(this.applyCriticalHit(entity, -1, criticalSlot2, bl));
                                    break block8;
                                }
                                case 3: 
                                case 4: {
                                    criticalSlot2 = new CriticalSlot(0, 5);
                                    vector.addAll(this.applyCriticalHit(entity, -1, criticalSlot2, bl));
                                    break block8;
                                }
                            }
                            break;
                        }
                        case 4: {
                            Mounted mounted = ((Protomech)entity).getTorsoWeapon(true);
                            if (null == mounted) break;
                            mounted.setHit(true);
                            report = new Report(6245);
                            report.subject = entity.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                            break;
                        }
                        case 5: {
                            Mounted mounted = ((Protomech)entity).getTorsoWeapon(false);
                            if (null == mounted) break;
                            mounted.setHit(true);
                            report = new Report(6250);
                            report.subject = entity.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                            break;
                        }
                    }
                    if (((Protomech)entity).shaded(n, n5) && Math.min(1, n2 = Protomech.POSSIBLE_PILOT_DAMAGE[n] - ((Protomech)entity).getPilotDamageTaken(n)) > 0) {
                        Report.addNewline(vector);
                        vector.addAll(this.damageCrew(entity, 1));
                        n2 = 1 + ((Protomech)entity).getPilotDamageTaken(n);
                        ((Protomech)entity).setPilotDamageTaken(n, n2);
                    }
                    break block58;
                }
                report = new Report(6225);
                report.subject = entity.getId();
                report.indent(3);
                report.add(((Mech)entity).getSystemName(criticalSlot.getIndex()));
                report.newlines = 0;
                vector.addElement(report);
                switch (criticalSlot.getIndex()) {
                    case 2: {
                        if (6 > entity.getCrew().getHits()) {
                            entity.getCrew().setDoomed(true);
                            Report.addNewline(vector);
                            vector.addAll(this.destroyEntity(entity, "pilot death", true));
                            break;
                        }
                        break block58;
                    }
                    case 3: {
                        ++entity.engineHitsThisRound;
                        boolean bl3 = false;
                        int n7 = 0;
                        n7 += entity.getHitCriticals(0, 3, 1);
                        n7 += entity.getHitCriticals(0, 3, 2);
                        bl3 = this.checkEngineExplosion(entity, vector, n7 += entity.getHitCriticals(0, 3, 3));
                        if (!bl3 && n7 > 2) {
                            vector.addAll(this.destroyEntity(entity, "engine destruction"));
                            if (this.game.getOptions().booleanOption("auto_abandon_unit")) {
                                vector.addAll(this.abandonEntity(entity));
                                break;
                            }
                        }
                        break block58;
                    }
                    case 4: {
                        if (entity.getGyroType() != 3) {
                            if (entity.getHitCriticals(0, 4, n) > 1) {
                                this.game.addPSR(new PilotingRollData(entity.getId(), 0x7FFFFFFE, 3, "gyro destroyed"));
                                break;
                            }
                            this.game.addPSR(new PilotingRollData(entity.getId(), 3, "gyro hit"));
                            break;
                        }
                        int n8 = entity.getHitCriticals(0, 4, n);
                        if (n8 > 2) {
                            this.game.addPSR(new PilotingRollData(entity.getId(), 0x7FFFFFFE, 3, "gyro destroyed"));
                            break;
                        }
                        if (n8 == 1) {
                            this.game.addPSR(new PilotingRollData(entity.getId(), 2, "gyro hit"));
                            break;
                        }
                        this.game.addPSR(new PilotingRollData(entity.getId(), 3, "gyro hit"));
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: {
                        this.game.addPSR(new PilotingRollData(entity.getId(), 1, "leg/foot actuator hit"));
                        break;
                    }
                    case 11: {
                        this.game.addPSR(new PilotingRollData(entity.getId(), 2, "hip actuator hit"));
                        break;
                    }
                }
                break block58;
            }
            if (1 == criticalSlot.getType()) {
                criticalSlot.setHit(true);
                Mounted mounted = entity.getEquipment(criticalSlot.getIndex());
                EquipmentType equipmentType = mounted.getType();
                boolean bl4 = mounted.isHit();
                report = new Report(6225);
                report.subject = entity.getId();
                report.indent(3);
                report.add(mounted.getDesc());
                report.newlines = 0;
                vector.addElement(report);
                if (equipmentType instanceof MiscType && ((MiscType)equipmentType).isShield()) {
                    mounted.setHit(false);
                } else {
                    mounted.setHit(true);
                }
                if (equipmentType instanceof MiscType && equipmentType.hasFlag(0x80000000L)) {
                    report = new Report(6254);
                    report.subject = entity.getId();
                    report.indent(2);
                    this.breachLocation(entity, n, null, true);
                }
                if (!bl4 && equipmentType instanceof MiscType && equipmentType.hasFlag(1024L) && mounted.getLinkedBy() != null) {
                    Mounted mounted2 = mounted.getLinkedBy();
                    report = new Report(6255);
                    report.subject = entity.getId();
                    report.indent(2);
                    report.add(mounted2.getType().getName());
                    report.newlines = 0;
                    vector.addElement(report);
                    mounted2.setMode("Off");
                }
                if ((bl && equipmentType.isExplosive() || mounted.isHotLoaded()) && !bl4) {
                    vector.addAll(this.explodeEquipment(entity, n, mounted));
                }
                if (mounted.getShotsLeft() > 0) {
                    mounted.setShotsLeft(0);
                }
            }
        }
        if (entity instanceof Mech && entity.hitThisRoundByAntiTSM) {
            Mech mech = (Mech)entity;
            if (mech.hasTSM()) {
                report = new Report(6430);
                report.subject = entity.getId();
                report.indent(2);
                report.addDesc(entity);
                report.newlines = 0;
                vector.addElement(report);
                vector.addAll(this.oneCriticalEntity(entity, Compute.d6(2)));
            }
            entity.hitThisRoundByAntiTSM = false;
        }
        return vector;
    }

    private Vector criticalEntity(Entity entity, int n) {
        return this.criticalEntity(entity, n, 0, true);
    }

    private Vector criticalEntity(Entity entity, int n, int n2) {
        return this.criticalEntity(entity, n, n2, true);
    }

    private Vector oneCriticalEntity(Entity entity, int n) {
        return this.criticalEntity(entity, n, 0, false);
    }

    private Vector crashVTOL(VTOL vTOL, Coords coords, int n) {
        return this.crashVTOL(vTOL, false, 0, coords, n, 0);
    }

    private Vector crashVTOL(VTOL vTOL) {
        return this.crashVTOL(vTOL, false, 0, vTOL.getPosition(), vTOL.getElevation(), 0);
    }

    private Vector crashVTOL(VTOL vTOL, boolean bl, int n, Coords coords, int n2, int n3) {
        Vector<Report> vector = new Vector<Report>();
        if (!bl) {
            Report report = new Report(6260);
            report.subject = vTOL.getId();
            report.newlines = 0;
            report.addDesc(vTOL);
            vector.addElement(report);
            int n4 = 0;
            IHex iHex = this.game.getBoard().getHex(coords);
            if (iHex.containsTerrain(12)) {
                n4 = iHex.terrainLevel(12);
            } else if (iHex.containsTerrain(16) && (n4 = iHex.terrainLevel(16)) > n2) {
                n4 = 0;
            }
            int n5 = n2 - n4;
            if (n5 == 0) {
                report = new Report(6265);
                report.subject = vTOL.getId();
                vector.addElement(report);
            } else {
                int n6;
                int n7;
                int n8;
                int n9;
                String string;
                vTOL.setElevation(n4);
                report = new Report(6270);
                report.subject = vTOL.getId();
                report.add(n5);
                vector.addElement(report);
                int n10 = Compute.d6();
                switch (n10) {
                    case 1: 
                    case 2: {
                        string = "right side";
                        n9 = 3;
                        break;
                    }
                    case 3: {
                        string = "rear";
                        n9 = 1;
                        break;
                    }
                    case 4: 
                    case 5: {
                        string = "left side";
                        n9 = 2;
                        break;
                    }
                    default: {
                        string = "front";
                        n9 = 0;
                    }
                }
                if (n4 <= 0) {
                    n8 = iHex.containsTerrain(4);
                    if (n8 != 0 && iHex.containsTerrain(20)) {
                        n7 = Compute.d6(1);
                        report = new Report(2118);
                        report.subject = vTOL.getId();
                        report.add(vTOL.getDisplayName(), true);
                        report.add(n7);
                        report.subject = vTOL.getId();
                        this.addReport(report);
                        if (n7 == 6) {
                            this.resolveIceBroken(coords);
                        } else {
                            n8 = 0;
                        }
                    }
                    if (n8 != 0) {
                        report = new Report(6275);
                        report.subject = vTOL.getId();
                        vector.addElement(report);
                        vTOL.destroy("Fell into water", false, false);
                    }
                }
                n8 = (int)Math.round((double)vTOL.getWeight() / 10.0) * (n5 + 1);
                report = new Report(6280);
                report.subject = vTOL.getId();
                report.indent();
                report.addDesc(vTOL);
                report.add(string);
                report.add(n8);
                report.newlines = 0;
                vector.addElement(report);
                vTOL.setFacing((vTOL.getFacing() + (n10 - 1)) % 6);
                n7 = 0;
                for (n8 = Math.round((float)n8 * this.game.getOptions().floatOption("gravity")); n8 > 0; n8 -= n6) {
                    n6 = Math.min(5, n8);
                    HitData hitData = vTOL.rollHitLocation(0, n9);
                    int[] nArray = new int[]{vTOL.getInternal(1), vTOL.getInternal(2), vTOL.getInternal(3), vTOL.getInternal(4)};
                    vector.addAll(this.damageEntity(vTOL, hitData, n6));
                    int[] nArray2 = new int[]{vTOL.getInternal(1), vTOL.getInternal(2), vTOL.getInternal(3), vTOL.getInternal(4)};
                    for (int i = 0; i <= 3; ++i) {
                        if (nArray[i] == nArray2[i]) continue;
                        n7 = 1;
                    }
                }
                if (n7 != 0) {
                    report = new Report(6285);
                    report.subject = vTOL.getId();
                    report.addDesc(vTOL);
                    vector.addElement(report);
                    vector.addAll(this.explodeVTOL(vTOL));
                }
                this.doSetLocationsExposure(vTOL, iHex, false, n4);
            }
        } else {
            int n11;
            vTOL.setElevation(0);
            Report report = new Report(6290);
            report.subject = vTOL.getId();
            report.addDesc(vTOL);
            vector.addElement(report);
            boolean bl2 = false;
            for (int i = (int)Math.round((double)vTOL.getWeight() / 10.0) * (n + 1); i > 0; i -= n11) {
                n11 = Math.min(5, i);
                HitData hitData = vTOL.rollHitLocation(0, n3);
                int[] nArray = new int[]{vTOL.getInternal(1), vTOL.getInternal(2), vTOL.getInternal(3), vTOL.getInternal(4)};
                vector.addAll(this.damageEntity(vTOL, hitData, n11));
                int[] nArray3 = new int[]{vTOL.getInternal(1), vTOL.getInternal(2), vTOL.getInternal(3), vTOL.getInternal(4)};
                for (int j = 0; j <= 3; ++j) {
                    if (nArray[j] == nArray3[j]) continue;
                    bl2 = true;
                }
            }
            if (bl2) {
                report = new Report(6295);
                report.subject = vTOL.getId();
                report.addDesc(vTOL);
                vector.addElement(report);
                vector.addAll(this.explodeVTOL(vTOL));
            }
        }
        return vector;
    }

    private Vector explodeVTOL(VTOL vTOL) {
        Vector<Report> vector = new Vector<Report>();
        if (vTOL.getEngine().isFusion()) {
            Report report = new Report(6300);
            report.subject = vTOL.getId();
            vector.addElement(report);
        } else {
            Coords coords = vTOL.getPosition();
            IHex iHex = this.game.getBoard().getHex(coords);
            if (iHex.containsTerrain(1) || iHex.containsTerrain(23)) {
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
            } else {
                this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, 1);
                ((InfernoTracker)this.game.getBoard().getInfernos().get(coords)).setTurnsLeftToBurn(this.game.getBoard().getInfernoBurnTurns(coords) - 2);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                this.sendChangedHex(coords);
            }
            this.destroyEntity(vTOL, "crashed and burned", false, false);
        }
        return vector;
    }

    private Vector criticalEntity(Entity entity, int n, int n2, boolean bl) {
        int n3;
        int n4;
        Report report;
        CriticalSlot criticalSlot = null;
        Vector<Report> vector = new Vector<Report>();
        Coords coords = entity.getPosition();
        IHex iHex = null;
        if (bl) {
            if (null != coords) {
                iHex = this.game.getBoard().getHex(coords);
            }
            report = new Report(6305);
            report.subject = entity.getId();
            report.indent(2);
            report.add(entity.getLocationAbbr(n));
            report.newlines = 0;
            vector.addElement(report);
            n4 = 0;
            n3 = Compute.d6(2);
            report = new Report(6310);
            report.subject = entity.getId();
            String string = "";
            if (n2 != 0) {
                string = new StringBuffer().append("(").append(n3).toString();
                if (n2 > 0) {
                    string = new StringBuffer().append(string).append("+").toString();
                }
                string = new StringBuffer().append(string).append(n2).append(") = ").toString();
                n3 += n2;
            }
            string = new StringBuffer().append(string).append(n3).toString();
            report.add(string);
            report.newlines = 0;
            vector.addElement(report);
            if (n3 <= 7) {
                report = new Report(6005);
                report.subject = entity.getId();
                report.newlines = 0;
                vector.addElement(report);
                return vector;
            }
            if (n3 >= 8 && n3 <= 9) {
                n4 = 1;
                report = new Report(6315);
                report.subject = entity.getId();
                report.newlines = 0;
                vector.addElement(report);
            } else if (n3 >= 10 && n3 <= 11) {
                n4 = 2;
                report = new Report(6320);
                report.subject = entity.getId();
                report.newlines = 0;
                vector.addElement(report);
            } else if (n3 == 12) {
                if (entity instanceof Tank || entity instanceof Protomech) {
                    n4 = 3;
                    report = new Report(6325);
                    report.subject = entity.getId();
                    report.newlines = 0;
                    vector.addElement(report);
                } else {
                    if (entity.locationIsLeg(n)) {
                        report = new Report(6120);
                        report.subject = entity.getId();
                        report.add(entity.getLocationName(n));
                        report.newlines = 0;
                        vector.addElement(report);
                        if (entity.getInternal(n) > 0) {
                            this.destroyLocation(entity, n);
                        }
                        if (null != iHex) {
                            if (!iHex.containsTerrain(19)) {
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(19, 1));
                            } else {
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(19, iHex.terrainLevel(19) + 1));
                            }
                        }
                        this.sendChangedHex(entity.getPosition());
                        return vector;
                    }
                    if (n == 4 || n == 5) {
                        report = new Report(6120);
                        report.subject = entity.getId();
                        report.add(entity.getLocationName(n));
                        report.newlines = 0;
                        vector.addElement(report);
                        this.destroyLocation(entity, n);
                        if (null != iHex) {
                            if (!iHex.containsTerrain(18)) {
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(18, 1));
                            } else {
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(18, iHex.terrainLevel(18) + 1));
                            }
                        }
                        this.sendChangedHex(entity.getPosition());
                        return vector;
                    }
                    if (n == 0) {
                        report = new Report(6330);
                        report.subject = entity.getId();
                        report.add(entity.getLocationName(n));
                        report.newlines = 0;
                        vector.addElement(report);
                        this.destroyLocation(entity, n);
                        if (6 > entity.getCrew().getHits()) {
                            entity.crew.setDoomed(true);
                            Report.addNewline(vector);
                            vector.addAll(this.destroyEntity(entity, "pilot death", true));
                        }
                        return vector;
                    }
                    n4 = 3;
                    report = new Report(6325);
                    report.subject = entity.getId();
                    report.newlines = 0;
                    vector.addElement(report);
                }
            }
        } else {
            n4 = 1;
        }
        if (entity instanceof Tank) {
            Tank tank = (Tank)entity;
            for (int i = 0; i < n4; ++i) {
                criticalSlot = new CriticalSlot(0, Compute.d6(1));
                vector.addAll(this.applyCriticalHit(entity, -1, criticalSlot, true));
            }
        } else {
            while (n4 > 0 && entity.canTransferCriticals(n) && entity.getTransferLocation(n) != -2 && entity.getTransferLocation(n) != -1) {
                n = entity.getTransferLocation(n);
                report = new Report(6335);
                report.subject = entity.getId();
                report.indent(3);
                report.add(entity.getLocationAbbr(n));
                report.newlines = 0;
                vector.addElement(report);
            }
            while (n4 > 0) {
                if (entity.getHittableCriticals(n) <= 0) {
                    report = new Report(6340);
                    report.subject = entity.getId();
                    report.indent(3);
                    report.newlines = 0;
                    vector.addElement(report);
                    break;
                }
                n3 = Compute.randomInt(entity.getNumberOfCriticals(n));
                criticalSlot = entity.getCritical(n, n3);
                if (criticalSlot == null || !criticalSlot.isHittable()) continue;
                if (entity instanceof Mech && entity.crew.hasEdgeRemaining() && entity.crew.getOptions().booleanOption("edge_when_explosion") && criticalSlot.getType() == 1 && entity.getEquipment(criticalSlot.getIndex()).getType().isExplosive()) {
                    entity.crew.decreaseEdge();
                    report = new Report(6530);
                    report.subject = entity.getId();
                    report.indent(3);
                    report.newlines = 0;
                    report.add(entity.crew.getOptions().intOption("edge"));
                    vector.addElement(report);
                    continue;
                }
                vector.addAll(this.applyCriticalHit(entity, n, criticalSlot, true));
                --n4;
            }
        }
        return vector;
    }

    private Vector breachCheck(Entity entity, int n, IHex iHex) {
        Vector<Report> vector = new Vector<Report>();
        if (entity instanceof Infantry) {
            return vector;
        }
        if (entity instanceof VTOL) {
            return vector;
        }
        if (entity.getLocationStatus(n) > 0) {
            Report report;
            int n2 = 0;
            if (!(entity.getArmor(n) <= 0 || entity instanceof Mech && entity.getArmor(n, true) <= 0 || null != iHex)) {
                if (entity instanceof Mech && ((Mech)entity).hasHarJelIn(n)) {
                    Report report2 = new Report(6342);
                    report2.subject = entity.getId();
                    report2.indent(3);
                    vector.addElement(report2);
                    return vector;
                }
                n2 = Compute.d6(2);
                report = new Report(6345);
                report.subject = entity.getId();
                report.indent(3);
                report.add(entity.getLocationAbbr(n));
                report.add(n2);
                report.newlines = 0;
                vector.addElement(report);
            }
            if (n2 >= 10 || entity.getArmor(n) <= 0 || entity instanceof Mech && entity.getArmor(n, true) <= 0) {
                if (entity instanceof Mech && ((Mech)entity).hasHarJelIn(n)) {
                    report = new Report(6342);
                    report.subject = entity.getId();
                    report.indent(3);
                    vector.addElement(report);
                    return vector;
                }
                vector.addAll(this.breachLocation(entity, n, iHex, false));
            }
        }
        return vector;
    }

    private Vector breachLocation(Entity entity, int n, IHex iHex, boolean bl) {
        Vector<Report> vector = new Vector<Report>();
        if (entity.getInternal(n) < 0 || entity.getLocationStatus(n) < 0) {
            return vector;
        }
        Report report = new Report(6350);
        if (bl) {
            report.messageId = 6351;
        }
        report.subject = entity.getId();
        report.add(entity.getShortName());
        report.add(entity.getLocationAbbr(n));
        report.newlines = 0;
        vector.addElement(report);
        if (entity instanceof Tank) {
            vector.addAll(this.destroyEntity(entity, "hull breach", true, true));
            return vector;
        }
        for (Mounted serializable : entity.getEquipment()) {
            if (serializable.getLocation() != n) continue;
            serializable.setBreached(true);
        }
        for (int i = 0; i < entity.getNumberOfCriticals(n); ++i) {
            CriticalSlot criticalSlot = entity.getCritical(n, i);
            if (criticalSlot == null) continue;
            if (entity.locationIsLeg(n) && criticalSlot.isHittable()) {
                switch (criticalSlot.getIndex()) {
                    case 12: 
                    case 13: 
                    case 14: {
                        this.game.addPSR(new PilotingRollData(entity.getId(), 1, "leg/foot actuator hit"));
                        break;
                    }
                    case 11: {
                        this.game.addPSR(new PilotingRollData(entity.getId(), 0, "hip actuator hit"));
                    }
                }
            }
            criticalSlot.setBreached(true);
        }
        if (n == 1) {
            vector.addAll(this.destroyEntity(entity, "hull breach"));
            if (this.game.getOptions().booleanOption("auto_abandon_unit")) {
                vector.addAll(this.abandonEntity(entity));
            }
        }
        if (n == 0) {
            entity.crew.setDoomed(true);
            vector.addAll(this.destroyEntity(entity, "hull breach"));
            if (entity.getLocationStatus(n) == 2) {
                report = new Report(6355);
                report.subject = entity.getId();
                report.addDesc(entity);
                vector.addElement(report);
            } else {
                report = new Report(6360);
                report.subject = entity.getId();
                report.addDesc(entity);
                vector.addElement(report);
            }
        }
        entity.setLocationStatus(n, -1);
        if (entity.getHitCriticals(0, 3, 3) + entity.getHitCriticals(0, 3, 1) + entity.getHitCriticals(0, 3, 2) >= 3) {
            vector.addAll(this.destroyEntity(entity, "engine destruction"));
            if (this.game.getOptions().booleanOption("auto_abandon_unit")) {
                vector.addAll(this.abandonEntity(entity));
            }
        }
        return vector;
    }

    void destroyLocation(Entity entity, int n) {
        if (entity.getInternal(n) < 0) {
            return;
        }
        entity.setArmor(-2, n, false);
        entity.setInternal(-2, n);
        if (entity.hasRearArmor(n)) {
            entity.setArmor(-2, n, true);
        }
        for (Mounted serializable : entity.getEquipment()) {
            if (serializable.getLocation() != n || !serializable.getType().isHittable()) continue;
            serializable.setMissing(true);
        }
        for (int i = 0; i < entity.getNumberOfCriticals(n); ++i) {
            CriticalSlot criticalSlot = entity.getCritical(n, i);
            if (criticalSlot == null) continue;
            if (criticalSlot.getType() == 0 && criticalSlot.getIndex() == 3 && !criticalSlot.isDamaged()) {
                ++entity.engineHitsThisRound;
            }
            criticalSlot.setMissing(true);
        }
        if (entity instanceof Mech && entity.locationIsLeg(n)) {
            this.game.addPSR(new PilotingRollData(entity.getId(), 0x7FFFFFFE, 5, "leg destroyed"));
        }
        if (entity.getDependentLocation(n) != -1) {
            this.destroyLocation(entity, entity.getDependentLocation(n));
        }
    }

    private Vector destroyEntity(Entity entity, String string) {
        return this.destroyEntity(entity, string, true);
    }

    private Vector destroyEntity(Entity entity, String string, boolean bl) {
        return this.destroyEntity(entity, string, bl, true);
    }

    private Vector destroyEntity(Entity entity, String string, boolean bl, boolean bl2) {
        Vector<Report> vector = new Vector<Report>();
        int n = 512;
        if (!bl2) {
            entity.setSalvage(bl2);
            n = 1024;
        }
        if (!entity.isDoomed() && !entity.isDestroyed()) {
            int n2;
            int n3;
            int n4;
            Object object;
            Serializable serializable;
            Serializable serializable2;
            Report report = new Report(6365);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(string);
            report.newlines = 0;
            vector.addElement(report);
            entity.setDoomed(true);
            Enumeration enumeration = entity.getPickedUpMechWarriors().elements();
            while (enumeration.hasMoreElements()) {
                serializable2 = (Integer)enumeration.nextElement();
                serializable = this.game.getEntity((Integer)serializable2);
                ((Entity)serializable).setDestroyed(true);
                this.game.removeEntity(((Entity)serializable).getId(), n);
                this.entityUpdate(((Entity)serializable).getId());
                this.send(this.createRemoveEntityPacket(((Entity)serializable).getId(), n));
                report = new Report(6370);
                report.subject = ((Entity)serializable).getId();
                report.addDesc((Entity)serializable);
                vector.addElement(report);
            }
            enumeration = entity.getLoadedUnits().elements();
            if (enumeration.hasMoreElements()) {
                serializable2 = null;
                serializable = entity.getPosition();
                object = this.game.getBoard().getHex((Coords)serializable);
                n4 = entity.getFacing();
                while (enumeration.hasMoreElements()) {
                    serializable2 = (Entity)enumeration.nextElement();
                    if (!bl) {
                        ((Entity)serializable2).setDestroyed(true);
                        this.game.moveToGraveyard(((Entity)serializable2).getId());
                        this.entityUpdate(((Entity)serializable2).getId());
                        this.send(this.createRemoveEntityPacket(((Entity)serializable2).getId(), n));
                        report = new Report(6370);
                        report.subject = ((Entity)serializable2).getId();
                        report.addDesc((Entity)serializable2);
                        vector.addElement(report);
                        continue;
                    }
                    if (null != Compute.stackingViolation(this.game, ((Entity)serializable2).getId(), (Coords)serializable) || ((Entity)serializable2).isHexProhibited((IHex)object)) {
                        ((Entity)serializable2).setDestroyed(true);
                        this.game.moveToGraveyard(((Entity)serializable2).getId());
                        this.entityUpdate(((Entity)serializable2).getId());
                        this.send(this.createRemoveEntityPacket(((Entity)serializable2).getId(), n));
                        report = new Report(6375);
                        report.subject = ((Entity)serializable2).getId();
                        report.addDesc((Entity)serializable2);
                        vector.addElement(report);
                        continue;
                    }
                    this.unloadUnit(entity, (Targetable)((Object)serializable2), (Coords)serializable, n4, entity.getElevation());
                }
            }
            if (-1 != entity.getTransportId()) {
                serializable2 = this.game.getEntity(entity.getTransportId());
                serializable = ((Entity)serializable2).getPosition();
                int n5 = ((Entity)serializable2).getFacing();
                this.unloadUnit((Entity)serializable2, entity, (Coords)serializable, n5, ((Entity)serializable2).getElevation());
                this.entityUpdate(((Entity)serializable2).getId());
            }
            if (-1 != (n3 = entity.getSwarmAttackerId())) {
                serializable = this.game.getEntity(n3);
                this.game.removeTurnFor((Entity)serializable);
                this.send(this.createTurnVectorPacket());
                ((Entity)serializable).setSwarmTargetId(-1);
                entity.setSwarmAttackerId(-1);
                report = new Report(6380);
                report.subject = n3;
                report.addDesc((Entity)serializable);
                vector.addElement(report);
                this.entityUpdate(n3);
            }
            if (-1 != (n2 = entity.getSwarmTargetId())) {
                object = this.game.getEntity(n2);
                ((Entity)object).setSwarmAttackerId(-1);
                entity.setSwarmTargetId(-1);
                report = new Report(6385);
                report.subject = ((Entity)object).getId();
                report.addDesc((Entity)object);
                vector.addElement(report);
                this.entityUpdate(n2);
            }
            if (entity instanceof Mech && (n4 = ((Mech)(object = (Mech)entity)).getGrappled()) != -1) {
                ((Mech)object).setGrappled(-1, false);
                Entity entity2 = this.game.getEntity(n4);
                if (entity2 != null && entity2 instanceof Mech) {
                    ((Mech)entity2).setGrappled(-1, false);
                }
                this.entityUpdate(n4);
            }
        }
        this.entityUpdate(entity.getId());
        return vector;
    }

    private Vector explodeEquipment(Entity entity, int n, int n2) {
        return this.explodeEquipment(entity, n, entity.getEquipment(entity.getCritical(n, n2).getIndex()));
    }

    private Vector explodeEquipment(Entity entity, int n, Mounted mounted) {
        int n2;
        int n3;
        Object object;
        Vector<Object> vector = new Vector<Object>();
        if (mounted.isDestroyed()) {
            System.err.println(new StringBuffer().append("server: explodeEquipment called on destroyed equipment (").append(mounted.getName()).append(')').toString());
            return vector;
        }
        if (mounted.getType() instanceof WeaponType && ((WeaponType)mounted.getType()).getAmmoType() == 23 && !mounted.isJammed()) {
            return vector;
        }
        if (mounted.getType() instanceof WeaponType && (((WeaponType)mounted.getType()).getAmmoType() == 1 || ((WeaponType)mounted.getType()).getAmmoType() == 35)) {
            if (!mounted.isUsedThisRound()) {
                return vector;
            }
            Mounted mounted2 = mounted.getLinked();
            if (mounted2 == null || !(mounted2.getType() instanceof AmmoType) || ((AmmoType)mounted2.getType()).getMunitionType() != 8L) {
                return vector;
            }
            object = (WeaponType)mounted.getType();
            if (((WeaponType)object).getAmmoType() == 7 || ((WeaponType)object).getAmmoType() == 32 || ((WeaponType)object).getAmmoType() == 8 || ((WeaponType)object).getAmmoType() == 27) {
                return vector;
            }
        }
        if (mounted.getType() instanceof AmmoType && (((AmmoType)mounted.getType()).getAmmoType() == 9 || ((AmmoType)mounted.getType()).getAmmoType() == 25) && ((AmmoType)mounted.getType()).getMunitionType() == 0x400000L && mounted.getShotsLeft() > 0) {
            entity.heatBuildup += 30;
        }
        if ((n3 = mounted.getExplosionDamage()) <= 0) {
            return vector;
        }
        object = new Report(6390);
        ((Report)object).subject = entity.getId();
        ((Report)object).add(mounted.getName());
        ((Report)object).add(n3);
        ((Report)object).indent(3);
        ((Report)object).newlines = 0;
        vector.addElement(object);
        if (mounted.getType() instanceof WeaponType && mounted.isHotLoaded()) {
            n2 = Compute.d6(2);
            int n4 = 0;
            object = new Report(6077);
            ((Report)object).subject = entity.getId();
            ((Report)object).add(n2);
            ((Report)object).indent(2);
            vector.addElement(object);
            if (n2 < 6) {
                for (Mounted mounted3 : entity.getAmmo()) {
                    if (mounted3.getLocation() != n || mounted3.getExplosionDamage() <= 0) continue;
                    ++n4;
                    vector.addAll(this.explodeEquipment(entity, n, mounted3));
                }
                if (n4 == 0) {
                    object = new Report(6078);
                    ((Report)object).subject = entity.getId();
                    ((Report)object).indent(2);
                    vector.addElement(object);
                }
            } else {
                object = new Report(6079);
                ((Report)object).subject = entity.getId();
                ((Report)object).indent(2);
                vector.addElement(object);
            }
        }
        mounted.setShotsLeft(0);
        vector.addAll(this.damageEntity(entity, new HitData(n), n3, true));
        Report.addNewline(vector);
        n2 = 2;
        if (entity.getCrew().getOptions().booleanOption("pain_resistance")) {
            n2 = 1;
        }
        if (entity.getCrew().getOptions().booleanOption("iron_man")) {
            n2 = 1;
        }
        vector.addAll(this.damageCrew(entity, n2));
        if (entity.crew.isDoomed() || entity.crew.isDead()) {
            vector.addAll(this.destroyEntity(entity, "crew death", true));
        } else {
            Report.addNewline(vector);
        }
        return vector;
    }

    private Vector explodeAmmoFromHeat(Entity entity) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        Vector vector = new Vector();
        for (int i = 0; i < entity.locations(); ++i) {
            for (int j = 0; j < entity.getNumberOfCriticals(i); ++j) {
                AmmoType ammoType;
                Mounted mounted;
                CriticalSlot criticalSlot = entity.getCritical(i, j);
                if (criticalSlot == null || criticalSlot.isDestroyed() || criticalSlot.isHit() || criticalSlot.getType() != 1 || !((mounted = entity.getEquipment(entity.getCritical(i, j).getIndex())).getType() instanceof AmmoType) || !(ammoType = (AmmoType)mounted.getType()).isExplosive() || mounted.getShotsLeft() == 0) continue;
                int n5 = ammoType.getDamagePerShot() * ammoType.getRackSize();
                int n6 = mounted.getExplosionDamage();
                if (mounted.isHit() || n2 >= n5 && (n2 != n5 || n >= n6)) continue;
                n2 = n5;
                n = n6;
                n3 = i;
                n4 = j;
            }
        }
        if (n3 != -1 && n4 != -1) {
            CriticalSlot criticalSlot = entity.getCritical(n3, n4);
            criticalSlot.setHit(true);
            entity.getEquipment(criticalSlot.getIndex()).setHit(true);
            vector = this.explodeEquipment(entity, n3, n4);
        } else {
            Report report = new Report(5105);
            report.subject = entity.getId();
            report.indent();
            vector.addElement(report);
        }
        return vector;
    }

    private void doEntityFall(Entity entity, Coords coords, int n, int n2, PilotingRollData pilotingRollData) {
        int n3;
        Report report;
        int n4;
        int n5;
        String string;
        IHex iHex = this.game.getBoard().getHex(coords);
        if (entity.isMakingDfa()) {
            Report report2 = new Report(2305);
            report2.subject = entity.getId();
            this.addReport(report2);
            entity.setProne(true);
            return;
        }
        switch (n2) {
            case 1: 
            case 2: {
                string = "right side";
                n5 = 3;
                break;
            }
            case 3: {
                string = "rear";
                n5 = 1;
                break;
            }
            case 4: 
            case 5: {
                string = "left side";
                n5 = 2;
                break;
            }
            default: {
                string = "front";
                n5 = 0;
            }
        }
        int n6 = iHex.terrainLevel(4);
        int n7 = iHex.terrainLevel(14) + iHex.depth();
        int n8 = n;
        if (n >= n7 && n7 >= 0) {
            n8 -= n7;
            n6 = 0;
            n4 = iHex.terrainLevel(14);
        } else if (iHex.containsTerrain(20) && n >= iHex.depth()) {
            n8 -= iHex.depth();
            n6 = 0;
            n4 = 0;
        } else if (n6 > 0) {
            n8 = n - n6;
            n4 = -n6;
        } else {
            n6 = 0;
            n4 = 0;
        }
        if (n6 > 0 && !(entity instanceof Mech) && !(entity instanceof Protomech) && entity.getRunMP() > 0 && entity.getMovementMode() != 5 && entity.getMovementMode() != 8 && entity.getMovementMode() != 7 && entity.getMovementMode() != 9) {
            this.addReport(this.destroyEntity(entity, "a watery grave", false));
            return;
        }
        int n9 = (int)Math.round((double)entity.getWeight() / 10.0) * (n8 + 1);
        int n10 = 0;
        if (n6 > 0) {
            n9 /= 2;
            n10 = (int)Math.round((double)entity.getWeight() / 10.0) * (n6 + 1) / 2;
        }
        if (n6 > n) {
            n9 = 0;
            n10 = (int)Math.round((double)entity.getWeight() / 10.0) * (n + 1) / 2;
        }
        n9 = Math.round((float)n9 * this.game.getOptions().floatOption("gravity"));
        if ((n10 = Math.round((float)n10 * this.game.getOptions().floatOption("gravity"))) == 0) {
            report = new Report(2310);
            report.subject = entity.getId();
            report.indent();
            report.newlines = 0;
            report.addDesc(entity);
            report.add(string);
            report.add(n9);
        } else if (n9 > 0) {
            report = new Report(2315);
            report.subject = entity.getId();
            report.indent();
            report.newlines = 0;
            report.addDesc(entity);
            report.add(string);
            report.add(n9);
            report.add(n10);
        } else {
            report = new Report(2310);
            report.subject = entity.getId();
            report.indent();
            report.newlines = 0;
            report.addDesc(entity);
            report.add(string);
            report.add(n10);
        }
        this.addReport(report);
        n9 += n10;
        int n11 = entity.getSwarmAttackerId();
        if (entity instanceof Mech) {
            entity.setProne(true);
        }
        entity.setPosition(coords);
        entity.setFacing((entity.getFacing() + (n2 - 1)) % 6);
        entity.setSecondaryFacing(entity.getFacing());
        entity.setElevation(n4);
        if (n6 > 0) {
            for (n3 = 0; n3 < entity.locations(); ++n3) {
                entity.setLocationStatus(n3, 2);
            }
        }
        while (n9 > 0) {
            n3 = Math.min(5, n9);
            HitData hitData = entity.rollHitLocation(0, n5);
            hitData.makeFallDamage(true);
            this.addReport(this.damageEntity(entity, hitData, n3));
            n9 -= n3;
        }
        this.doSetLocationsExposure(entity, iHex, false, -n6);
        pilotingRollData.removeAutos();
        if (n > 0) {
            pilotingRollData.addModifier(n, "height of fall");
        }
        entity.addPilotingModifierForTerrain(pilotingRollData, coords);
        if (pilotingRollData.getValue() == Integer.MAX_VALUE) {
            report = new Report(2320);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.crew.getName());
            report.indent();
            this.addReport(report);
            this.addReport(this.damageCrew(entity, 1));
            ++((Report)this.vPhaseReport.elementAt((int)(this.vPhaseReport.size() - 1))).newlines;
        } else {
            n3 = Compute.d6(2);
            report = new Report(2325);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.crew.getName());
            report.add(pilotingRollData.getValueAsString());
            report.add(n3);
            if (n3 >= pilotingRollData.getValue()) {
                report.choose(true);
                this.addReport(report);
            } else {
                report.choose(false);
                this.addReport(report);
                this.addReport(this.damageCrew(entity, 1));
                ++((Report)this.vPhaseReport.elementAt((int)(this.vPhaseReport.size() - 1))).newlines;
            }
        }
        if (-1 != n11) {
            Entity entity2 = this.game.getEntity(n11);
            entity.setSwarmAttackerId(-1);
            entity2.setSwarmTargetId(-1);
            if (n6 > 0) {
                entity2.setPosition(coords);
                report = new Report(2330);
                report.newlines = 0;
                report.subject = entity2.getId();
                report.addDesc(entity2);
                this.addReport(report);
                this.addReport(this.destroyEntity(entity2, "a watery grave", false));
            } else {
                report = new Report(2335);
                report.newlines = 0;
                report.subject = entity2.getId();
                report.addDesc(entity2);
                this.addReport(report);
                this.addReport(this.damageEntity(entity2, entity2.rollHitLocation(0, 0), 11));
                ++((Report)this.vPhaseReport.elementAt((int)(this.vPhaseReport.size() - 1))).newlines;
            }
            entity2.setPosition(coords);
            this.entityUpdate(n11);
        }
        this.game.resetPSRs(entity);
    }

    private void doEntityFall(Entity entity, Coords coords, int n, PilotingRollData pilotingRollData) {
        this.doEntityFall(entity, coords, n, Compute.d6(1), pilotingRollData);
    }

    private void doEntityFall(Entity entity, PilotingRollData pilotingRollData) {
        this.doEntityFall(entity, entity.getPosition(), entity.getElevation() + this.game.getBoard().getHex(entity.getPosition()).depth(), pilotingRollData);
    }

    private void resolveAmmoDumps() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            for (Mounted mounted : entity.getAmmo()) {
                Report report;
                if (mounted.isPendingDump()) {
                    report = new Report(5110);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    report.add(mounted.getName());
                    this.addReport(report);
                    mounted.setPendingDump(false);
                    mounted.setDumping(true);
                    continue;
                }
                if (!mounted.isDumping()) continue;
                report = new Report(5115);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(mounted.getName());
                this.addReport(report);
                mounted.setDumping(false);
                mounted.setShotsLeft(0);
            }
            entity.reloadEmptyWeapons();
        }
    }

    public boolean ignite(IHex iHex, int n, boolean bl, int n2) {
        if (!this.game.getOptions().booleanOption("fire") || null == iHex) {
            return false;
        }
        if (iHex.containsTerrain(7)) {
            return true;
        }
        if (!(bl || iHex.containsTerrain(1) || iHex.containsTerrain(23) || iHex.containsTerrain(32) || iHex.containsTerrain(10))) {
            return false;
        }
        int n3 = Compute.d6(2);
        if (n2 != -1) {
            Report report = new Report(3430);
            report.indent(3);
            report.subject = n2;
            report.add(n);
            report.add(n3);
            this.addReport(report);
        }
        if (n3 >= n) {
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
            return true;
        }
        return false;
    }

    public boolean ignite(IHex iHex, int n, boolean bl) {
        return this.ignite(iHex, n, bl, -1);
    }

    public boolean ignite(IHex iHex, int n) {
        return this.ignite(iHex, n, false, -1);
    }

    public void removeFire(int n, int n2, IHex iHex) {
        Coords coords = new Coords(n, n2);
        iHex.removeTerrain(7);
        this.sendChangedHex(coords);
        if (!this.game.getOptions().booleanOption("maxtech_fire")) {
            int n3 = this.game.getWindDirection();
            this.removeSmoke(n, n2, n3);
            this.removeSmoke(n, n2, (n3 + 1) % 6);
            this.removeSmoke(n, n2, (n3 + 5) % 6);
        }
        Report report = new Report(5170, 0);
        report.add(coords.getBoardNum());
        this.addReport(report);
    }

    public void addSmoke(int n, int n2, int n3) {
        Coords coords = new Coords(Coords.xInDir(n, n2, n3), Coords.yInDir(n, n2, n3));
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex != null && !iHex.containsTerrain(8)) {
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, 1));
            this.sendChangedHex(coords);
            Report report = new Report(5175, 0);
            report.add(coords.getBoardNum());
            this.addReport(report);
        }
    }

    public void addL3Smoke(int n, int n2) {
        IBoard iBoard = this.game.getBoard();
        Coords coords = new Coords(n, n2);
        IHex iHex = this.game.getBoard().getHex(coords);
        boolean bl = iBoard.isInfernoBurning(coords);
        if (iHex == null) {
            return;
        }
        if (bl || 2 < iHex.terrainLevel(32) || 2 < iHex.terrainLevel(10)) {
            if (iHex.terrainLevel(8) == 2) {
                Report report = new Report(5180, 0);
                report.add(coords.getBoardNum());
                this.addReport(report);
            } else {
                if (iHex.terrainLevel(8) == 1) {
                    iHex.removeTerrain(8);
                }
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, 2));
                this.sendChangedHex(coords);
                Report report = new Report(5185, 0);
                report.add(coords.getBoardNum());
                this.addReport(report);
            }
        } else if (iHex.terrainLevel(8) == 2) {
            Report report = new Report(5190, 0);
            report.add(coords.getBoardNum());
            this.addReport(report);
        } else if (iHex.terrainLevel(8) == 1) {
            Report report = new Report(5195, 0);
            report.add(coords.getBoardNum());
            this.addReport(report);
        } else {
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, 1));
            this.sendChangedHex(coords);
            Report report = new Report(5200, 0);
            report.add(coords.getBoardNum());
            this.addReport(report);
        }
    }

    public void removeSmoke(int n, int n2, int n3) {
        Coords coords = new Coords(Coords.xInDir(n, n2, n3), Coords.yInDir(n, n2, n3));
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex != null && iHex.containsTerrain(8)) {
            iHex.removeTerrain(8);
            this.sendChangedHex(coords);
            Report report = new Report(5205, 0);
            report.add(coords.getBoardNum());
            this.addReport(report);
        }
    }

    private Vector scanForBoardsInDir(File file, String string, int n, int n2) {
        String[] stringArray = file.list();
        Vector<String> vector = new Vector<String>();
        Comparator comparator = StringUtil.stringComparator();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(".board") == -1 || !Board.boardIsSize(string.concat("/").concat(stringArray[i]), n, n2)) continue;
            vector.addElement(string.concat("/").concat(stringArray[i].substring(0, stringArray[i].lastIndexOf(".board"))));
        }
        return vector;
    }

    private Vector scanForBoards(int n, int n2) {
        return this.scanForBoards(n, n2, this.game.getOptions().booleanOption("maps_include_subdir"));
    }

    private Vector scanForBoards(int n, int n2, boolean bl) {
        int n3;
        Vector<String> vector = new Vector<String>();
        File file = new File("data/boards");
        vector.addElement("[GENERATED]");
        if (!file.isDirectory()) {
            return vector;
        }
        String[] stringArray = file.list();
        Vector<String> vector2 = new Vector<String>();
        Comparator comparator = StringUtil.stringComparator();
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            File file2 = new File("data/boards/".concat(stringArray[n3]));
            if (file2.isDirectory() && bl) {
                vector2.addAll(this.scanForBoardsInDir(file2, stringArray[n3], n, n2));
                continue;
            }
            if (stringArray[n3].indexOf(".board") == -1 || !Board.boardIsSize(stringArray[n3], n, n2)) continue;
            vector2.addElement(stringArray[n3].substring(0, stringArray[n3].lastIndexOf(".board")));
        }
        if (vector2.size() > 0) {
            vector.addElement("[RANDOM]");
            vector.addElement(DEFAULT_BOARD);
            Collections.sort(vector2, (Comparator)comparator);
            for (n3 = 0; n3 < vector2.size(); ++n3) {
                vector.addElement((String)vector2.elementAt(n3));
            }
        }
        return vector;
    }

    private boolean doBlind() {
        return this.game.getOptions().booleanOption("double_blind") && this.game.getPhase() >= 4;
    }

    private void entityUpdate(int n) {
        this.entityUpdate(n, new Vector());
    }

    private void entityUpdate(int n, Vector vector) {
        Entity entity = this.game.getEntity(n);
        if (entity == null) {
            if (this.game.getOutOfGameEntity(n) != null) {
                System.err.print("S: attempted to send entity update for out of game entity, id was ");
                System.err.println(n);
            } else {
                System.err.print("S: attempted to send entity update for null entity, id was ");
                System.err.println(n);
            }
            return;
        }
        if (this.doBlind()) {
            Player player;
            int n2;
            Vector vector2 = this.game.getPlayersVector();
            Vector vector3 = this.whoCanSee(entity);
            Packet packet = this.createEntityPacket(n, vector);
            for (n2 = 0; n2 < vector3.size(); ++n2) {
                player = (Player)vector3.elementAt(n2);
                this.send(player.getId(), packet);
            }
            packet = this.createRemoveEntityPacket(n, entity.getRemovalCondition());
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                if (vector3.contains(vector2.elementAt(n2))) continue;
                player = (Player)vector2.elementAt(n2);
                this.send(player.getId(), packet);
            }
        } else {
            this.send(this.createEntityPacket(n, vector));
        }
    }

    private Vector whoCanSee(Entity entity) {
        TurnOrdered turnOrdered;
        if (entity == null) {
            return new Vector();
        }
        boolean bl = this.game.getOptions().booleanOption("team_vision");
        Vector vector = this.game.getEntitiesVector();
        Vector<Player> vector2 = new Vector<Player>();
        vector2.addElement(entity.getOwner());
        if (bl) {
            this.addTeammates(vector2, entity.getOwner());
        }
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            turnOrdered = (Player)enumeration.nextElement();
            if (!((Player)turnOrdered).canSeeAll() || vector2.contains(enumeration)) continue;
            vector2.addElement((Player)turnOrdered);
        }
        if (!entity.isHidden()) {
            for (int i = 0; i < vector.size(); ++i) {
                turnOrdered = (Entity)vector.elementAt(i);
                if (vector2.contains(((Entity)turnOrdered).getOwner()) || !((Entity)turnOrdered).isActive() || ((Entity)turnOrdered).isOffBoard() || !Compute.canSee(this.game, (Entity)turnOrdered, entity)) continue;
                vector2.addElement(((Entity)turnOrdered).getOwner());
                if (bl) {
                    this.addTeammates(vector2, ((Entity)turnOrdered).getOwner());
                }
                this.addObservers(vector2);
            }
        }
        return vector2;
    }

    private boolean canSee(Player player, Entity entity) {
        if (entity.getOwner().getId() == player.getId()) {
            return true;
        }
        Vector vector = this.whoCanSee(entity);
        for (int i = 0; i < vector.size(); ++i) {
            Player player2 = (Player)vector.elementAt(i);
            if (!player2.equals(player)) continue;
            return true;
        }
        return false;
    }

    private void addTeammates(Vector vector, Player player) {
        Vector vector2 = this.game.getPlayersVector();
        for (int i = 0; i < vector2.size(); ++i) {
            Player player2 = (Player)vector2.elementAt(i);
            if (player.isEnemyOf(player2) || vector.contains(player2)) continue;
            vector.addElement(player2);
        }
    }

    private void addObservers(Vector vector) {
        Vector vector2 = this.game.getPlayersVector();
        for (int i = 0; i < vector2.size(); ++i) {
            Player player = (Player)vector2.elementAt(i);
            if (!player.isObserver() || vector.contains(player)) continue;
            vector.addElement(player);
        }
    }

    private void entityAllUpdate() {
        if (this.doBlind()) {
            Vector vector = this.game.getPlayersVector();
            for (int i = 0; i < vector.size(); ++i) {
                Player player = (Player)vector.elementAt(i);
                this.send(player.getId(), this.createFilteredEntitiesPacket(player));
            }
            return;
        }
        this.send(this.createEntitiesPacket());
    }

    private Vector filterEntities(Player player, Vector vector) {
        Entity entity;
        int n;
        Vector<Entity> vector2 = new Vector<Entity>();
        Vector<Entity> vector3 = new Vector<Entity>();
        Vector vector4 = this.game.getEntitiesVector();
        boolean bl = this.game.getOptions().booleanOption("team_vision");
        if (player.canSeeAll()) {
            return vector;
        }
        if (player.isObserver()) {
            vector3.addAll(vector4);
            block0: for (Entity entity2 : vector3) {
                for (Entity entity3 : vector3) {
                    if (!entity2.isEnemyOf(entity3) || !Compute.canSee(this.game, entity3, entity2)) continue;
                    vector2.add(entity2);
                    continue block0;
                }
            }
            return vector2;
        }
        for (n = 0; n < vector4.size(); ++n) {
            entity = (Entity)vector4.elementAt(n);
            if (entity.getOwner() != player && (!bl || entity.getOwner().isEnemyOf(player))) continue;
            vector3.addElement(entity);
        }
        block3: for (n = 0; n < vector.size(); ++n) {
            entity = (Entity)vector.elementAt(n);
            if (vector3.contains(entity)) {
                vector2.addElement(entity);
                continue;
            }
            if (entity.isHidden()) continue;
            for (int i = 0; i < vector3.size(); ++i) {
                Entity entity4 = (Entity)vector3.elementAt(i);
                if (entity4.isOffBoard() || !Compute.canSee(this.game, entity4, entity)) continue;
                vector2.addElement(entity);
                continue block3;
            }
        }
        return vector2;
    }

    private Vector filterReportVector(Vector vector, Player player) {
        if (!this.doBlind()) {
            return (Vector)vector.clone();
        }
        Vector<Report> vector2 = new Vector<Report>();
        for (int i = 0; i < vector.size(); ++i) {
            Report report = (Report)vector.elementAt(i);
            vector2.addElement(this.filterReport(report, player, false));
        }
        return vector2;
    }

    private Report filterReport(Report report, Player player, boolean bl) {
        if (report.subject == -1 && report.type != 0) {
            System.err.println(new StringBuffer().append("Error: Attempting to filter a Report object that is not public yet has no subject.\n\t\tmessageId: ").append(report.messageId).toString());
            return report;
        }
        if (report.type == 0 || player == null && !bl) {
            return report;
        }
        Entity entity = this.game.getEntity(report.subject);
        Player player2 = null;
        if (entity != null) {
            player2 = entity.getOwner();
            if (entity.isOffBoard()) {
                return report;
            }
        }
        if (!(bl || entity != null && player2 != null)) {
            System.err.println(new StringBuffer().append("Error: Attempting to filter a Report object that is not public but has a subject (").append(entity).append(") with owner (").append(player2).append(").\n\tmessageId: ").append(report.messageId).toString());
            return report;
        }
        Report report2 = new Report(report);
        for (int i = 0; i < report2.dataCount(); ++i) {
            if (!bl && this.canSee(player, entity) || !report.isValueObscured(i)) continue;
            report2.hideData(i);
            if (player == null) continue;
            report.addObscuredRecipient(player.getName());
        }
        return report2;
    }

    private Vector filterPastReports(Vector vector, Player player) {
        System.err.println("filterPastReports() begin");
        System.err.println(new StringBuffer().append("  player is ").append(player.getName()).toString());
        if (this.doBlind()) {
            Vector<Object> vector2 = new Vector<Object>();
            Vector<Report> vector3 = new Vector<Report>();
            Vector vector4 = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                vector4 = (Vector)vector.elementAt(i);
                for (int j = 0; j < vector4.size(); ++j) {
                    Report report = (Report)vector4.elementAt(j);
                    if (report.isObscuredRecipient(player.getName())) {
                        vector3.addElement(this.filterReport(report, null, true));
                        continue;
                    }
                    vector3.addElement(report);
                }
                vector2.addElement(vector3.clone());
                vector3.removeAllElements();
            }
            System.err.println("filterPastReports() end");
            return vector2;
        }
        System.err.println("filterPastReports() end");
        return vector;
    }

    private void updateVisibilityIndicator() {
        Vector vector = this.game.getEntitiesVector();
        for (int i = 0; i < vector.size(); ++i) {
            Entity entity = (Entity)vector.elementAt(i);
            boolean bl = entity.isVisibleToEnemy();
            boolean bl2 = entity.isSeenByEnemy();
            entity.setVisibleToEnemy(false);
            Vector vector2 = this.whoCanSee(entity);
            for (int j = 0; j < vector2.size(); ++j) {
                Player player = (Player)vector2.elementAt(j);
                if (!entity.getOwner().isEnemyOf(player) || player.isObserver()) continue;
                entity.setVisibleToEnemy(true);
                entity.setSeenByEnemy(true);
            }
            if (bl == entity.isVisibleToEnemy() && bl2 == entity.isSeenByEnemy()) continue;
            this.sendVisibilityIndicator(entity);
        }
    }

    private void receiveEntityAdd(Packet packet, int n) {
        final Entity entity = (Entity)packet.getObject(0);
        if (entityVerifier == null) {
            entityVerifier = new EntityVerifier(new File(VERIFIER_CONFIG_FILENAME));
        }
        if (entity instanceof Mech || entity instanceof Tank) {
            StringBuffer stringBuffer;
            TestEntity testEntity = null;
            entity.restore();
            if (entity instanceof Mech) {
                testEntity = new TestMech((Mech)entity, Server.entityVerifier.mechOption, null);
            }
            if (entity instanceof VTOL) {
                testEntity = new TestTank((Tank)entity, Server.entityVerifier.tankOption, null);
            }
            if (entity instanceof Tank) {
                testEntity = new TestTank((Tank)entity, Server.entityVerifier.tankOption, null);
            }
            if (((TestEntity)testEntity).correctEntity(stringBuffer = new StringBuffer(), !this.game.getOptions().booleanOption("is_eq_limits"))) {
                entity.setDesignValid(true);
            } else if (this.game.getOptions().booleanOption("allow_illegal_units")) {
                entity.setDesignValid(false);
            } else {
                Player player = this.game.getPlayer(n);
                this.sendServerChat(new StringBuffer().append("Player ").append(player.getName()).append(" attempted to add an illegal unit design (").append(entity.getShortNameRaw()).append("), the unit was rejected.").toString());
                System.err.println(stringBuffer);
                return;
            }
        }
        if (entity instanceof Protomech) {
            int n2 = this.game.getSelectedEntityCount(new EntitySelector(){
                private final int ownerId;
                {
                    this.ownerId = entity.getOwnerId();
                }

                public boolean accept(Entity entity2) {
                    return entity2 instanceof Protomech && this.ownerId == entity2.getOwnerId();
                }
            });
            entity.setUnitNumber((char)(n2 / 5));
        }
        if (-1 == entity.getId()) {
            entity.setId(this.getFreeEntityId());
        }
        this.game.addEntity(entity.getId(), entity);
        this.send(this.createAddEntityPacket(entity.getId()));
    }

    private void receiveEntityUpdate(Packet packet, int n) {
        Entity entity = (Entity)packet.getObject(0);
        Entity entity2 = this.game.getEntity(entity.getId());
        if (entity2 != null && entity2.getOwner() == this.getPlayer(n)) {
            this.game.setEntity(entity.getId(), entity);
            this.entityUpdate(entity.getId());
            if (this.game.getPhase() == 1) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Unit ");
                if (this.game.getOptions().booleanOption("blind_drop") || this.game.getOptions().booleanOption("real_blind_drop")) {
                    if (-1 != entity.getExternalId()) {
                        stringBuffer.append('[').append(entity.getExternalId()).append("] ");
                    }
                    stringBuffer.append(entity.getId()).append('(').append(entity.getOwner().getName()).append(')');
                } else {
                    stringBuffer.append(entity.getDisplayName());
                }
                stringBuffer.append(" has been customized.");
                this.sendServerChat(stringBuffer.toString());
            }
        }
    }

    private void receiveEntityModeChange(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        int n3 = packet.getIntValue(1);
        int n4 = packet.getIntValue(2);
        Entity entity = this.game.getEntity(n2);
        if (entity.getOwner() != this.getPlayer(n)) {
            return;
        }
        Mounted mounted = entity.getEquipment(n3);
        if (mounted.getType() instanceof AmmoType && !mounted.getType().hasInstantModeSwitch() && n4 <= 0) {
            mounted.setPendingDump(n4 == -1);
        } else {
            mounted.setMode(n4);
        }
    }

    private void receiveEntitySystemModeChange(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        int n3 = packet.getIntValue(1);
        int n4 = packet.getIntValue(2);
        Entity entity = this.game.getEntity(n2);
        if (entity.getOwner() != this.getPlayer(n)) {
            return;
        }
        if (entity instanceof Mech && n3 == 2) {
            ((Mech)entity).setCockpitStatus(n4);
        }
    }

    private void receiveEntityAmmoChange(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        int n3 = packet.getIntValue(1);
        int n4 = packet.getIntValue(2);
        Entity entity = this.game.getEntity(n2);
        if (null == entity) {
            System.err.print("Server.receiveEntityAmmoChange: could not find entity #");
            System.err.println(n2);
            return;
        }
        Player player = this.getPlayer(n);
        if (null != player && entity.getOwner() != player) {
            System.err.print("Server.receiveEntityAmmoChange: player ");
            System.err.print(player.getName());
            System.err.print(" does not own the entity ");
            System.err.println(entity.getDisplayName());
            return;
        }
        Mounted mounted = entity.getEquipment(n3);
        Mounted mounted2 = entity.getEquipment(n4);
        if (null == mounted2) {
            System.err.print("Server.receiveEntityAmmoChange: entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" does not have ammo #");
            System.err.println(n4);
            return;
        }
        if (!(mounted2.getType() instanceof AmmoType)) {
            System.err.print("Server.receiveEntityAmmoChange: item # ");
            System.err.print(n4);
            System.err.print(" of entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" is a ");
            System.err.print(mounted2.getName());
            System.err.println(" and not ammo.");
            return;
        }
        if (null == mounted) {
            System.err.print("Server.receiveEntityAmmoChange: entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" does not have weapon #");
            System.err.println(n3);
            return;
        }
        if (!(mounted.getType() instanceof WeaponType)) {
            System.err.print("Server.receiveEntityAmmoChange: item # ");
            System.err.print(n3);
            System.err.print(" of entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" is a ");
            System.err.print(mounted.getName());
            System.err.println(" and not a weapon.");
            return;
        }
        if (((WeaponType)mounted.getType()).getAmmoType() == -1) {
            System.err.print("Server.receiveEntityAmmoChange: item # ");
            System.err.print(n3);
            System.err.print(" of entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" is a ");
            System.err.print(mounted.getName());
            System.err.println(" and does not use ammo.");
            return;
        }
        if (((WeaponType)mounted.getType()).hasFlag(32768L)) {
            System.err.print("Server.receiveEntityAmmoChange: item # ");
            System.err.print(n3);
            System.err.print(" of entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" is a ");
            System.err.print(mounted.getName());
            System.err.println(" and cannot use external ammo.");
            return;
        }
        entity.loadWeapon(mounted, mounted2);
    }

    private void receiveEntityDelete(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        final Entity entity = this.game.getEntity(n2);
        if (entity != null && entity.getOwner() == this.getPlayer(n)) {
            if (entity instanceof Protomech) {
                int n3 = this.game.getSelectedEntityCount(new EntitySelector(){
                    private final int ownerId;
                    {
                        this.ownerId = entity.getOwnerId();
                    }

                    public boolean accept(Entity entity2) {
                        return entity2 instanceof Protomech && this.ownerId == entity2.getOwnerId();
                    }
                });
                final char c = (char)(Math.ceil((double)n3 / 5.0) - 1.0);
                char c2 = (char)(Math.ceil((double)(n3 - 1) / 5.0) - 1.0);
                char c3 = entity.getUnitNumber();
                if (c != c3 && c != c2) {
                    Enumeration enumeration = this.game.getSelectedEntities(new EntitySelector(){
                        private final int ownerId;
                        private final char lastUnitNum;
                        {
                            this.ownerId = entity.getOwnerId();
                            this.lastUnitNum = c;
                        }

                        public boolean accept(Entity entity2) {
                            return entity2 instanceof Protomech && this.ownerId == entity2.getOwnerId() && this.lastUnitNum == entity2.getUnitNumber();
                        }
                    });
                    Entity entity2 = (Entity)enumeration.nextElement();
                    entity2.setUnitNumber(c3);
                    this.entityUpdate(entity2.getId());
                }
            }
            this.game.removeEntity(n2, 2048);
            this.send(this.createRemoveEntityPacket(n2, 2048));
        }
    }

    private void receivePlayerDone(Packet packet, int n) {
        boolean bl = packet.getBooleanValue(0);
        Player player = this.getPlayer(n);
        if (null != player) {
            player.setDone(bl);
        }
    }

    private void receiveInitiativeRerollRequest(Packet packet, int n) {
        Player player = this.getPlayer(n);
        if (6 != this.game.getPhase()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (null == player) {
                stringBuffer.append("Player #").append(n);
            } else {
                stringBuffer.append(player.getName());
            }
            stringBuffer.append(" is not allowed to ask for a reroll at this time.");
            System.err.println(stringBuffer.toString());
            this.sendServerChat(stringBuffer.toString());
            return;
        }
        if (this.game.hasTacticalGenius(player)) {
            this.game.addInitiativeRerollRequest(this.game.getTeamForPlayer(player));
        }
        if (null != player) {
            player.setDone(true);
        }
        this.checkReady();
    }

    private boolean receiveGameOptions(Packet packet, int n) {
        Player player = this.game.getPlayer(n);
        if (null == player) {
            System.err.print("Server does not recognize player at connection ");
            System.err.println(n);
            return false;
        }
        if (this.password != null && this.password.length() > 0 && !this.password.equals(packet.getObject(0))) {
            this.sendServerChat(n, "The password you specified to change game options is incorrect.");
            return false;
        }
        int n2 = 0;
        Enumeration enumeration = ((Vector)packet.getObject(1)).elements();
        while (enumeration.hasMoreElements()) {
            IBasicOption iBasicOption = (IBasicOption)enumeration.nextElement();
            IOption iOption = this.game.getOptions().getOption(iBasicOption.getName());
            if (iOption == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Player ").append(player.getName()).append(" changed option \"").append(iOption.getDisplayableName()).append("\" to ").append(iBasicOption.getValue().toString()).append('.');
            this.sendServerChat(stringBuffer.toString());
            iOption.setValue(iBasicOption.getValue());
            ++n2;
        }
        Compute.setRNG(this.game.getOptions().intOption("rng_type"));
        return n2 > 0;
    }

    private void receiveGameOptionsAux(Packet packet, int n) {
        Enumeration enumeration = ((Vector)packet.getObject(1)).elements();
        while (enumeration.hasMoreElements()) {
            IBasicOption iBasicOption = (IBasicOption)enumeration.nextElement();
            IOption iOption = this.game.getOptions().getOption(iBasicOption.getName());
            if (iOption == null || !"maps_include_subdir".equals(iOption.getName())) continue;
            this.mapSettings.setBoardsAvailableVector(this.scanForBoards(this.mapSettings.getBoardWidth(), this.mapSettings.getBoardHeight()));
            this.mapSettings.removeUnavailable();
            this.mapSettings.setNullBoards(DEFAULT_BOARD);
            this.send(this.createMapSettingsPacket());
        }
    }

    private void transmitAllPlayerConnects(int n) {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            this.send(n, this.createPlayerConnectPacket(player.getId()));
        }
    }

    private Packet createPlayerConnectPacket(int n) {
        Object[] objectArray = new Object[]{new Integer(n), this.getPlayer(n)};
        return new Packet(40, objectArray);
    }

    private Packet createPlayerUpdatePacket(int n) {
        Object[] objectArray = new Object[]{new Integer(n), this.getPlayer(n)};
        return new Packet(60, objectArray);
    }

    private void transmitAllPlayerUpdates() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (null == player) continue;
            this.send(this.createPlayerUpdatePacket(player.getId()));
        }
    }

    private void transmitAllPlayerDones() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            this.send(this.createPlayerDonePacket(player.getId()));
        }
    }

    private Packet createPlayerDonePacket(int n) {
        Object[] objectArray = new Object[]{new Integer(n), Autobox.valueOf((boolean)this.getPlayer(n).isDone())};
        return new Packet(70, objectArray);
    }

    private Packet createTurnVectorPacket() {
        return new Packet(300, this.game.getTurnVector());
    }

    private Packet createTurnIndexPacket() {
        return new Packet(250, new Integer(this.game.getTurnIndex()));
    }

    private Packet createMapSettingsPacket() {
        return new Packet(360, this.mapSettings);
    }

    private Packet createMapQueryPacket(MapSettings mapSettings) {
        return new Packet(370, mapSettings);
    }

    private Packet createGameSettingsPacket() {
        return new Packet(350, this.game.getOptions());
    }

    private Packet createBoardPacket() {
        return new Packet(270, this.game.getBoard());
    }

    private Packet createEntityPacket(int n) {
        return this.createEntityPacket(n, new Vector());
    }

    private Packet createEntityPacket(int n, Vector vector) {
        Entity entity = this.game.getEntity(n);
        Object[] objectArray = new Object[]{new Integer(n), entity, vector};
        return new Packet(140, objectArray);
    }

    private Packet createReportPacket(Player player) {
        if (player == null || !this.doBlind()) {
            return new Packet(310, this.filterReportVector(this.vPhaseReport, player));
        }
        return new Packet(310, player.getTurnReport());
    }

    private Packet createSpecialReportPacket() {
        return new Packet(320, this.vPhaseReport.clone());
    }

    private Packet createTacticalGeniusReportPacket() {
        return new Packet(330, this.vPhaseReport.clone());
    }

    private Packet createAllReportsPacket(Player player) {
        return new Packet(340, this.filterPastReports(this.game.getAllReports(), player));
    }

    private Packet createEntitiesPacket() {
        return new Packet(280, this.game.getEntitiesVector());
    }

    private Packet createFullEntitiesPacket() {
        Object[] objectArray = new Object[]{this.game.getEntitiesVector(), this.game.getOutOfGameEntitiesVector()};
        return new Packet(280, objectArray);
    }

    private Packet createFilteredEntitiesPacket(Player player) {
        return new Packet(280, this.filterEntities(player, this.game.getEntitiesVector()));
    }

    private Packet createFilteredFullEntitiesPacket(Player player) {
        Object[] objectArray = new Object[]{this.filterEntities(player, this.game.getEntitiesVector()), this.game.getOutOfGameEntitiesVector()};
        return new Packet(280, objectArray);
    }

    private Packet createAddEntityPacket(int n) {
        Entity entity = this.game.getEntity(n);
        Object[] objectArray = new Object[]{new Integer(n), entity};
        return new Packet(90, objectArray);
    }

    private Packet createRemoveEntityPacket(int n) {
        return this.createRemoveEntityPacket(n, 512);
    }

    private Packet createRemoveEntityPacket(int n, int n2) {
        if (n2 != 0 && n2 != 256 && n2 != 272 && n2 != 512 && n2 != 528 && n2 != 288 && n2 != 1024 && n2 != 2048) {
            throw new IllegalArgumentException(new StringBuffer().append("Unknown unit condition: ").append(n2).toString());
        }
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        return new Packet(100, objectArray);
    }

    private Packet createEndOfGamePacket() {
        Object[] objectArray = new Object[]{this.getDetailedVictoryReport(), new Integer(this.game.getVictoryPlayerId()), new Integer(this.game.getVictoryTeam())};
        return new Packet(380, objectArray);
    }

    private void sendChat(int n, String string, String string2) {
        this.send(n, new Packet(80, new StringBuffer().append(string).append(": ").append(string2).toString()));
    }

    private void sendChat(String string, String string2) {
        String string3 = new StringBuffer().append(string).append(": ").append(string2).toString();
        this.send(new Packet(80, string3));
    }

    public void sendServerChat(int n, String string) {
        this.sendChat(n, "***Server", string);
    }

    public void sendServerChat(String string) {
        this.sendChat("***Server", string);
    }

    private Packet createHexChangePacket(Coords coords, IHex iHex) {
        Object[] objectArray = new Object[]{coords, iHex};
        return new Packet(190, objectArray);
    }

    public void sendChangedHex(Coords coords) {
        this.send(this.createHexChangePacket(coords, this.game.getBoard().getHex(coords)));
    }

    public void sendVisibilityIndicator(Entity entity) {
        Object[] objectArray = new Object[]{new Integer(entity.getId()), Autobox.valueOf((boolean)entity.isSeenByEnemy()), Autobox.valueOf((boolean)entity.isVisibleToEnemy())};
        this.send(new Packet(180, objectArray));
    }

    private Packet createAttackPacket(Vector vector, int n) {
        Object[] objectArray = new Object[]{vector, new Integer(n)};
        return new Packet(130, objectArray);
    }

    private Packet createAttackPacket(EntityAction entityAction, int n) {
        Vector<EntityAction> vector = new Vector<EntityAction>(1);
        vector.addElement(entityAction);
        Object[] objectArray = new Object[]{vector, new Integer(n)};
        return new Packet(130, objectArray);
    }

    private Packet createArtilleryPacket(Player player) {
        if (player.getSeeAll()) {
            return new Packet(460, this.game.getArtilleryVector());
        }
        Vector<ArtilleryAttackAction> vector = new Vector<ArtilleryAttackAction>();
        int n = player.getTeam();
        Enumeration enumeration = this.game.getArtilleryAttacks();
        while (enumeration.hasMoreElements()) {
            ArtilleryAttackAction artilleryAttackAction = (ArtilleryAttackAction)enumeration.nextElement();
            if (artilleryAttackAction.getPlayerId() != player.getId() && (n == 0 || n != this.game.getPlayer(artilleryAttackAction.getPlayerId()).getTeam())) continue;
            vector.addElement(artilleryAttackAction);
        }
        return new Packet(460, vector);
    }

    private Packet createFlarePacket() {
        return new Packet(470, this.game.getFlares());
    }

    private void send(Packet packet) {
        if (this.connections == null) {
            return;
        }
        Enumeration enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            connection.send(packet);
        }
    }

    private void sendReport() {
        this.sendReport(false);
    }

    private void sendReport(boolean bl) {
        if (this.connections == null) {
            return;
        }
        Enumeration enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            Player player = this.game.getPlayer(connection.getId());
            Packet packet = bl ? this.createTacticalGeniusReportPacket() : this.createReportPacket(player);
            connection.send(packet);
        }
    }

    private void send(int n, Packet packet) {
        if (this.getClient(n) != null) {
            this.getClient(n).send(packet);
        }
    }

    private void sendToPending(int n, Packet packet) {
        if (this.getPendingConnection(n) != null) {
            this.getPendingConnection(n).send(packet);
        }
    }

    private void processCommand(int n, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        String string2 = stringArray[0].substring(1);
        ServerCommand serverCommand = this.getCommand(string2);
        if (serverCommand != null) {
            serverCommand.run(n, stringArray);
        } else {
            this.sendServerChat(n, "Command not recognized.  Type /help for a list of commands.");
        }
    }

    protected synchronized void handle(int n, Packet packet) {
        Player player = this.game.getPlayer(n);
        if (null == player && null == this.getPendingConnection(n)) {
            System.err.print("Server does not recognize player at connection ");
            System.err.println(n);
            return;
        }
        if (packet == null) {
            System.out.println("server.connection.handle: got null packet");
            return;
        }
        switch (packet.getCommand()) {
            case 0: {
                Connection connection = this.getConnection(n);
                if (connection == null) break;
                connection.close();
                break;
            }
            case 20: {
                this.receivePlayerName(packet, n);
                break;
            }
            case 60: {
                this.receivePlayerInfo(packet, n);
                this.validatePlayerInfo(n);
                this.send(this.createPlayerUpdatePacket(n));
                break;
            }
            case 70: {
                this.receivePlayerDone(packet, n);
                this.send(this.createPlayerDonePacket(n));
                this.checkReady();
                break;
            }
            case 430: {
                this.receiveInitiativeRerollRequest(packet, n);
                this.send(this.createPlayerDonePacket(n));
                break;
            }
            case 80: {
                String string = (String)packet.getObject(0);
                if (string.startsWith("/")) {
                    this.processCommand(n, string);
                } else {
                    this.sendChat(player.getName(), string);
                }
                if (DUNE_CALL.equals(string)) {
                    this.sendServerChat(DUNE_RESPONSE);
                    break;
                }
                if (!STAR_WARS_CALL.equals(string)) break;
                this.sendServerChat(STAR_WARS_RESPONSE);
                break;
            }
            case 110: {
                this.receiveMovement(packet, n);
                break;
            }
            case 120: {
                this.receiveDeployment(packet, n);
                break;
            }
            case 390: {
                this.receiveDeployMinefields(packet, n);
                break;
            }
            case 130: {
                this.receiveAttack(packet, n);
                break;
            }
            case 90: {
                this.receiveEntityAdd(packet, n);
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                break;
            }
            case 140: {
                this.receiveEntityUpdate(packet, n);
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                break;
            }
            case 150: {
                this.receiveEntityModeChange(packet, n);
                break;
            }
            case 170: {
                this.receiveEntitySystemModeChange(packet, n);
                break;
            }
            case 160: {
                this.receiveEntityAmmoChange(packet, n);
                break;
            }
            case 100: {
                this.receiveEntityDelete(packet, n);
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                break;
            }
            case 350: {
                if (!this.receiveGameOptions(packet, n)) break;
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                this.send(this.createGameSettingsPacket());
                this.receiveGameOptionsAux(packet, n);
                break;
            }
            case 360: {
                MapSettings mapSettings = (MapSettings)packet.getObject(0);
                if (!this.mapSettings.equalMapGenParameters(mapSettings)) {
                    this.sendServerChat(new StringBuffer().append("Player ").append(player.getName()).append(" changed mapsettings").toString());
                }
                this.mapSettings = mapSettings;
                mapSettings = null;
                this.mapSettings.replaceBoardWithRandom("[RANDOM]");
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                this.send(this.createMapSettingsPacket());
                break;
            }
            case 370: {
                MapSettings mapSettings = (MapSettings)packet.getObject(0);
                mapSettings.setBoardsAvailableVector(this.scanForBoards(mapSettings.getBoardWidth(), mapSettings.getBoardHeight()));
                mapSettings.removeUnavailable();
                mapSettings.setNullBoards(DEFAULT_BOARD);
                mapSettings.replaceBoardWithRandom("[RANDOM]");
                mapSettings.removeUnavailable();
                this.send(n, this.createMapQueryPacket(mapSettings));
                break;
            }
            case 440: {
                this.receiveUnloadStranded(packet, n);
                break;
            }
            case 450: {
                this.receiveArtyAutoHitHexes(packet, n);
            }
        }
    }

    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        System.out.println("s: listening for clients...");
        while (this.connector == thread) {
            try {
                Socket socket = this.serverSocket.accept();
                int n = this.getFreeConnectionId();
                System.out.println(new StringBuffer().append("s: accepting player connection #").append(n).append(" ...").toString());
                Connection connection = ConnectionFactory.getInstance().createServerConnection(socket, n);
                connection.addConnectionListener(this.connectionListener);
                connection.open();
                this.connectionsPending.addElement(connection);
                this.greeting(n);
                ConnectionWatchdog connectionWatchdog = new ConnectionWatchdog(this, n);
                this.timer.schedule((TimerTask)connectionWatchdog, 1000L, 500L);
            }
            catch (IOException iOException) {}
        }
    }

    private Vector explodeInfernoAmmoFromHeat(Entity entity) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        Vector<Report> vector = new Vector<Report>();
        for (int i = 0; i < entity.locations(); ++i) {
            for (int j = 0; j < entity.getNumberOfCriticals(i); ++j) {
                AmmoType ammoType;
                Mounted mounted;
                CriticalSlot criticalSlot = entity.getCritical(i, j);
                if (criticalSlot == null || criticalSlot.isDestroyed() || criticalSlot.isHit() || criticalSlot.getType() != 1 || !((mounted = entity.getEquipment(entity.getCritical(i, j).getIndex())).getType() instanceof AmmoType) || !(ammoType = (AmmoType)mounted.getType()).isExplosive() || ammoType.getMunitionType() != 0x400000L) continue;
                int n5 = ammoType.getDamagePerShot() * ammoType.getRackSize();
                int n6 = mounted.getExplosionDamage();
                if (mounted.isHit() || n2 >= n5 && (n2 != n5 || n >= n6)) continue;
                n2 = n5;
                n = n6;
                n3 = i;
                n4 = j;
            }
        }
        if (n3 != -1 && n4 != -1) {
            CriticalSlot criticalSlot = entity.getCritical(n3, n4);
            criticalSlot.setHit(true);
            entity.getEquipment(criticalSlot.getIndex()).setHit(true);
            vector.addAll(this.explodeEquipment(entity, n3, n4));
            entity.heat += 30;
            Report report = new Report(5155);
            report.indent();
            report.subject = entity.getId();
            report.add(entity.heat);
            vector.addElement(report);
            entity.heatBuildup = 0;
        } else {
            Report report = new Report(5160);
            report.indent();
            report.subject = entity.getId();
            vector.addElement(report);
        }
        return vector;
    }

    private boolean passBuildingWall(Entity entity, Building building, Coords coords, Coords coords2, int n, String string) {
        int n2;
        PilotingRollData pilotingRollData = entity.rollMovementInBuilding(building, n, string);
        if (!this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, false)) {
            n2 = (int)Math.ceil((double)building.getCurrentCF() / 10.0);
            if (n2 == 0) {
                Report report = new Report(6440);
                report.add(entity.getDisplayName());
                report.subject = entity.getId();
                report.indent(2);
                this.addReport(report);
            } else {
                HitData hitData = entity.rollHitLocation(0, 0);
                this.addReport(this.damageEntity(entity, hitData, n2));
            }
        }
        n2 = (int)Math.ceil((double)entity.getWeight() / 10.0);
        int n3 = building.getCurrentCF();
        n3 -= Math.min(n3, n2);
        building.setCurrentCF(n3);
        this.damageInfantryIn(building, n2);
        return this.checkBuildingCollapseWhileMoving(building, entity, coords2);
    }

    private boolean checkBuildingCollapseWhileMoving(Building building, Entity entity, Coords coords) {
        Coords coords2 = entity.getPosition();
        entity.setPosition(coords);
        Hashtable hashtable = this.game.getPositionMap();
        boolean bl = this.checkForCollapse(building, hashtable);
        if (coords.equals(entity.getPosition()) && !entity.isProne()) {
            entity.setPosition(coords2);
        }
        return bl;
    }

    private void damageInfantryIn(Building building, int n) {
        float f = 0.0f;
        switch (building.getType()) {
            case 1: {
                f = 0.75f;
                break;
            }
            case 2: {
                f = 0.5f;
                break;
            }
            case 3: {
                f = 0.25f;
            }
        }
        int n2 = Math.round((float)n * f);
        boolean bl = false;
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Report report;
            Entity entity = (Entity)enumeration.nextElement();
            Coords coords = entity.getPosition();
            if (!(entity instanceof Infantry) || !building.isIn(coords) || !Compute.isInBuilding(this.game, entity, coords)) continue;
            if (n2 == 0) {
                report = new Report(6445);
                this.addReport(report);
                continue;
            }
            report = new Report(6450);
            report.indent(2);
            report.subject = entity.getId();
            report.add(entity.getDisplayName());
            report.add(n2);
            this.addReport(report);
            int n3 = n2;
            int n4 = n2;
            if (entity instanceof BattleArmor) {
                n4 = 5;
            }
            while (n3 > 0) {
                int n5 = Math.min(n4, n3);
                HitData hitData = entity.rollHitLocation(0, 0);
                this.addReport(this.damageEntity(entity, hitData, n5));
                n3 -= n5;
            }
            this.addReport(new Report(1210));
        }
        if (bl) {
            this.addReport(new Report(1210));
        }
    }

    public boolean checkForCollapse(Building building, Hashtable hashtable) {
        Serializable serializable;
        if (building == null || hashtable == null || hashtable.isEmpty()) {
            return false;
        }
        int n = building.getCurrentCF();
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = building.getCoords();
        boolean bl = false;
        while (!bl && enumeration.hasMoreElements()) {
            serializable = (Coords)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(serializable);
            if (vector == null) continue;
            IHex iHex = this.game.getBoard().getHex((Coords)serializable);
            int n2 = iHex.surface();
            int n3 = Math.max(0, iHex.terrainLevel(12));
            int n4 = iHex.terrainLevel(16);
            int n5 = n3;
            if (n4 != Integer.MIN_VALUE) {
                ++n5;
            }
            if (n5 < 1) {
                System.err.println(new StringBuffer().append("Check for collapse: hex ").append(((Coords)serializable).toString()).append(" has no bridge or building").toString());
                continue;
            }
            int[] nArray = new int[n5];
            Vector<Entity> vector2 = new Vector<Entity>();
            for (int i = 0; i < n5; ++i) {
                nArray[i] = 0;
            }
            Enumeration enumeration2 = vector.elements();
            while (!bl && enumeration2.hasMoreElements()) {
                Entity entity = (Entity)enumeration2.nextElement();
                int n6 = entity.getElevation();
                if (n6 != n4 && n6 > n3 || entity.getMovementMode() == 8 || entity.getMovementMode() == 7 || entity.getMovementMode() == 9 || !(entity instanceof Mech) && !(entity instanceof Tank)) continue;
                int n7 = (int)entity.getWeight();
                int n8 = n6;
                if (n8 == n4) {
                    n8 = n5;
                }
                if (n3 > 0 && n8 == 0 && n7 > n) {
                    vector2.addElement(entity);
                    continue;
                }
                if (n8 <= 0) continue;
                int n9 = --n8;
                nArray[n9] = nArray[n9] + n7;
                if (nArray[n8] <= n) continue;
                bl = true;
            }
            if (vector2.isEmpty()) continue;
            hashtable2.put(serializable, vector2);
        }
        if (bl) {
            serializable = new Report(2375);
            ((Report)serializable).add(building.getName());
            this.addReport((Report)serializable);
            this.collapseBuilding(building, hashtable);
        } else if (!hashtable2.isEmpty()) {
            // empty if block
        }
        return bl;
    }

    public void collapseBuilding(Building building, Hashtable hashtable) {
        int n = building.getPhaseCF();
        Enumeration enumeration = building.getCoords();
        while (enumeration.hasMoreElements()) {
            Coords coords = (Coords)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(coords);
            if (vector == null) continue;
            IHex iHex = this.game.getBoard().getHex(coords);
            int n2 = iHex.surface();
            int n3 = iHex.terrainLevel(16);
            int n4 = Math.max(n3, iHex.terrainLevel(12));
            Collections.sort((List)vector, (Comparator)new Comparator<Entity>(){

                @Override
                public int compare(Entity entity, Entity entity2) {
                    if (entity.getElevation() > entity2.getElevation()) {
                        return -1;
                    }
                    if (entity.getElevation() > entity2.getElevation()) {
                        return 1;
                    }
                    return 0;
                }

                @Override
                public int compare(Object object, Object object2) {
                    return this.compare((Entity)object, (Entity)object2);
                }
            });
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Entity entity = (Entity)enumeration2.nextElement();
                int n5 = entity.getElevation();
                if (n5 > n4) continue;
                if (n5 == n4) {
                    --n5;
                }
                int n6 = (int)Math.ceil((double)(n * (n4 - n5)) / 10.0);
                if (entity instanceof Infantry) {
                    n6 *= 3;
                }
                Report report = new Report(6455);
                report.indent();
                report.subject = entity.getId();
                report.add(entity.getDisplayName());
                report.add(n6);
                this.addReport(report);
                int n7 = n6;
                int n8 = n6;
                if (entity instanceof BattleArmor || entity instanceof Mech || entity instanceof Tank) {
                    n8 = 5;
                }
                while (n7 > 0) {
                    int n9 = Math.min(n8, n7);
                    HitData hitData = entity.rollHitLocation(0, 0);
                    this.addReport(this.damageEntity(entity, hitData, n9));
                    n7 -= n9;
                }
                this.addReport(new Report(1210));
                n5 = entity.getElevation();
                if (n5 > 0 || n5 == n3) {
                    PilotingRollData pilotingRollData = entity.getBasePilotingRoll();
                    entity.addPilotingModifierForTerrain(pilotingRollData, coords);
                    if (n6 >= 20) {
                        pilotingRollData.addModifier(1, "20+ damage");
                    }
                    this.doEntityFallsInto(entity, coords, coords, pilotingRollData);
                }
                this.entityUpdate(entity.getId());
            }
        }
        building.setCurrentCF(0);
        building.setPhaseCF(0);
        this.send(this.createCollapseBuildingPacket(building));
        this.game.getBoard().collapseBuilding(building);
    }

    private Packet createCollapseBuildingPacket(Building building) {
        Vector<Building> vector = new Vector<Building>();
        vector.addElement(building);
        return this.createCollapseBuildingPacket(vector);
    }

    private Packet createCollapseBuildingPacket(Vector vector) {
        return new Packet(230, vector);
    }

    private Packet createUpdateBuildingCFPacket(Vector vector) {
        return new Packet(220, vector);
    }

    private void applyBuildingDamage() {
        Serializable serializable;
        Object object;
        Serializable serializable2;
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<Building> vector2 = new Vector<Building>();
        Enumeration enumeration = this.game.getBoard().getBuildings();
        while (enumeration.hasMoreElements()) {
            serializable2 = (Building)enumeration.nextElement();
            if (((Building)serializable2).getCurrentCF() == 0) {
                vector.addElement(serializable2);
                continue;
            }
            if (((Building)serializable2).getPhaseCF() == ((Building)serializable2).getCurrentCF()) continue;
            ((Building)serializable2).setPhaseCF(((Building)serializable2).getCurrentCF());
            vector2.addElement((Building)serializable2);
        }
        if (!vector.isEmpty()) {
            serializable2 = this.game.getPositionMap();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (Building)enumeration.nextElement();
                serializable = new Report(6460, 0);
                ((Report)serializable).add(((Building)object).getName());
                this.addReport((Report)serializable);
                this.collapseBuilding((Building)object, (Hashtable)serializable2);
            }
        }
        if (!vector2.isEmpty()) {
            serializable2 = this.game.getPositionMap();
            object = vector2.iterator();
            while (object.hasNext()) {
                serializable = (Building)object.next();
                if (!this.checkForCollapse((Building)serializable, (Hashtable)serializable2)) continue;
                object.remove();
            }
        }
        if (!vector2.isEmpty()) {
            this.sendChangedCFBuildings(vector2);
        }
    }

    private Report damageBuilding(Building building, int n) {
        return this.damageBuilding(building, n, " absorbs ");
    }

    private Report damageBuilding(Building building, int n, String string) {
        Report report = new Report(1210);
        report.newlines = 0;
        if (building != null && n > 0) {
            int n2;
            int n3 = n2 = building.getCurrentCF();
            n2 -= Math.min(n2, n);
            building.setCurrentCF(n2);
            report.messageId = 3435;
            report.add(building.getName());
            report.add(string);
            report.add(n);
            report.newlines = 1;
            if (n2 == 0 && n3 != 0) {
                if (building instanceof FuelTank) {
                    report.messageId = 3441;
                    report.type = 0;
                    this.addReport(report);
                    report = new Report(3560);
                    report.type = 0;
                    report.newlines = 1;
                    this.addReport(report);
                    Vector vector = new Vector();
                    this.doExplosion(((FuelTank)building).getMagnitude(), 10, false, (Coords)building.getCoords().nextElement(), true, vector, null);
                    Report.indentAll(vector, 2);
                    this.addReport(vector);
                    return null;
                }
                report.messageId = 3440;
            }
        }
        return report;
    }

    public void sendChangedCFBuildings(Vector<Building> vector) {
        this.send(this.createUpdateBuildingCFPacket(vector));
    }

    private void receiveUnloadStranded(Packet packet, int n) {
        int n2;
        GameTurn.UnloadStrandedTurn unloadStrandedTurn = null;
        Player player = this.game.getPlayer(n);
        int[] nArray = (int[])packet.getObject(0);
        Vector<Player> vector = null;
        Player player2 = null;
        Enumeration enumeration = null;
        UnloadStrandedAction unloadStrandedAction = null;
        Entity entity = null;
        if (this.game.getPhase() != 8) {
            System.err.println("error: server got unload stranded packet in wrong phase");
            return;
        }
        if (!(this.game.getTurn() instanceof GameTurn.UnloadStrandedTurn)) {
            System.err.println("error: server got unload stranded packet out of sequence");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(player.getName()).append(" should not be sending 'unload stranded entity' packets at this time.");
            this.sendServerChat(stringBuffer.toString());
            return;
        }
        unloadStrandedTurn = (GameTurn.UnloadStrandedTurn)this.game.getTurn();
        if (!unloadStrandedTurn.isValid(n, this.game)) {
            System.err.println("error: server got unload stranded packet from invalid player");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(player.getName()).append(" should not be sending 'unload stranded entity' packets.");
            this.sendServerChat(stringBuffer.toString());
            return;
        }
        vector = new Vector<Player>();
        enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            unloadStrandedAction = (UnloadStrandedAction)enumeration.nextElement();
            if (unloadStrandedAction.getPlayerId() == n) {
                System.err.println("error: server got multiple unload stranded packets from player");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(player.getName()).append(" should not send multiple 'unload stranded entity' packets.");
                this.sendServerChat(stringBuffer.toString());
                return;
            }
            player2 = this.game.getPlayer(unloadStrandedAction.getPlayerId());
            if (vector.contains(player2)) continue;
            vector.addElement(player2);
        }
        boolean bl = false;
        for (n2 = 0; null != nArray && n2 < nArray.length; ++n2) {
            entity = this.game.getEntity(nArray[n2]);
            if (!this.game.getTurn().isValid(n, entity, this.game)) {
                System.err.println("error: server got unload stranded packet for invalid entity");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(player.getName()).append(" can not unload stranded entity ");
                if (null == entity) {
                    stringBuffer.append('#').append(nArray[n2]);
                } else {
                    stringBuffer.append(entity.getDisplayName());
                }
                stringBuffer.append(" at this time.");
                this.sendServerChat(stringBuffer.toString());
                continue;
            }
            bl = true;
            this.game.addAction(new UnloadStrandedAction(n, nArray[n2]));
        }
        if (!bl) {
            this.game.addAction(new UnloadStrandedAction(n, -1));
        }
        vector.addElement(player);
        nArray = unloadStrandedTurn.getEntityIds();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            entity = this.game.getEntity(nArray[n2]);
            player2 = entity.getOwner();
            if (vector.contains(player2)) continue;
            return;
        }
        enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            unloadStrandedAction = (UnloadStrandedAction)enumeration.nextElement();
            if (-1 == unloadStrandedAction.getEntityId()) continue;
            entity = this.game.getEntity(unloadStrandedAction.getEntityId());
            if (null == entity) {
                System.err.print("error: server could not find stranded entity #");
                System.err.print(unloadStrandedAction.getEntityId());
                System.err.println(" to unload!!!");
                continue;
            }
            Entity entity2 = this.game.getEntity(entity.getTransportId());
            this.unloadUnit(entity2, entity, entity2.getPosition(), entity2.getFacing(), entity2.getElevation());
        }
        this.game.resetActions();
        this.changeToNextTurn();
    }

    private void clearArtillerySpotters(int n, int n2) {
        Enumeration enumeration = this.game.getArtilleryAttacks();
        while (enumeration.hasMoreElements()) {
            ArtilleryAttackAction artilleryAttackAction = (ArtilleryAttackAction)enumeration.nextElement();
            if (artilleryAttackAction.getWR().waa.getEntityId() != n || artilleryAttackAction.getWR().waa.getWeaponId() != n2) continue;
            artilleryAttackAction.setSpotterIds(null);
        }
    }

    private WeaponResult convertHomingShotToEntityTarget(ArtilleryAttackAction artilleryAttackAction, Entity entity) {
        WeaponResult weaponResult = artilleryAttackAction.getWR();
        Targetable targetable = weaponResult.waa.getTarget(this.game);
        Coords coords = targetable.getPosition();
        Entity entity2 = null;
        TagInfo tagInfo = null;
        Entity entity3 = null;
        for (int i = 0; i < 2; ++i) {
            int n = Integer.MAX_VALUE;
            int n2 = -1;
            Vector vector = this.game.getTagInfo();
            for (int j = 0; j < vector.size(); ++j) {
                tagInfo = (TagInfo)vector.elementAt(j);
                entity3 = this.game.getEntity(tagInfo.attackerId);
                if (tagInfo.shots >= tagInfo.priority || entity.isEnemyOf(entity3)) continue;
                System.err.println(new StringBuffer().append("Checking TAG ").append(j).append(" with priority ").append(tagInfo.priority).toString());
                entity2 = this.game.getEntity(tagInfo.targetId);
                if (entity2 == null || !entity2.isOnSameSheet(coords) || coords.distance(entity2.getPosition()) >= n) continue;
                n2 = j;
                n = coords.distance(entity2.getPosition());
                if (!this.game.getOptions().booleanOption("a4homing_target_area")) break;
            }
            if (n2 != -1) {
                tagInfo = (TagInfo)vector.elementAt(n2);
                entity2 = this.game.getEntity(tagInfo.targetId);
                entity3 = this.game.getEntity(tagInfo.attackerId);
                System.err.println(new StringBuffer().append("attacker: ").append(entity.getDisplayName()).toString());
                System.err.println(new StringBuffer().append("   ").append(entity3.getDisplayName()).append(" selected to TAG").toString());
                System.err.println(new StringBuffer().append("   ").append(entity2.getDisplayName()).append(" selected as target").toString());
                ++tagInfo.shots;
                this.game.updateTagInfo(tagInfo, n2);
                break;
            }
            entity2 = null;
            System.err.println("nothing on 1st pass");
            this.game.clearTagInfoShots(entity, coords);
        }
        if (entity2 == null || tagInfo == null) {
            weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "no targets tagged on map sheet");
        } else if (tagInfo.missed) {
            weaponResult.waa.setTargetId(entity2.getId());
            weaponResult.waa.setTargetType(0);
            weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "tag missed the target");
        } else {
            weaponResult.artyAttackerCoords = entity3.getPosition();
            weaponResult.waa.setTargetId(entity2.getId());
            weaponResult.waa.setTargetType(0);
        }
        return weaponResult;
    }

    private void resolveIndirectArtilleryAttacks() {
        Serializable serializable;
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>(this.game.getArtillerySize());
        Vector<Object> vector2 = new Vector<Object>(this.game.getArtillerySize());
        Vector<Object> vector3 = new Vector<Object>(this.game.getArtillerySize());
        Object object3 = this.game.getArtilleryAttacks();
        while (object3.hasMoreElements()) {
            object2 = (ArtilleryAttackAction)object3.nextElement();
            if (object2 instanceof NukeAttackAction && ((ArtilleryAttackAction)object2).turnsTilHit <= 0) {
                vector3.addElement(object2);
            } else if (((ArtilleryAttackAction)object2).turnsTilHit <= 0) {
                Mounted mounted;
                AmmoType ammoType;
                object = ((ArtilleryAttackAction)object2).getWR();
                ((WeaponResult)object).artyAttackerCoords = ((ArtilleryAttackAction)object2).getCoords();
                serializable = ((ArtilleryAttackAction)object2).getSpotterIds();
                final Targetable targetable = ((WeaponResult)object).waa.getTarget(this.game);
                Coords coords = targetable.getPosition();
                final int n = ((ArtilleryAttackAction)object2).getPlayerId();
                RoundUpdated roundUpdated = null;
                Entity entity = this.game.getEntity(((WeaponResult)object).waa.getEntityId());
                if (entity == null) {
                    entity = this.game.getOutOfGameEntity(((WeaponResult)object).waa.getEntityId());
                }
                AmmoType ammoType2 = ammoType = (mounted = entity.getEquipment(((WeaponResult)object).waa.getAmmoId())) == null ? null : (AmmoType)mounted.getType();
                if (ammoType != null && ammoType.getMunitionType() == 0x20000000L) {
                    object = this.convertHomingShotToEntityTarget((ArtilleryAttackAction)object2, entity);
                } else {
                    RoundUpdated roundUpdated2;
                    Object object4;
                    if (null != serializable) {
                        object4 = this.game.getSelectedEntities(new EntitySelector((Vector)serializable){
                            public int player;
                            public Targetable targ;
                            final /* synthetic */ Vector val$spottersBefore;
                            {
                                this.val$spottersBefore = vector;
                                this.player = n;
                                this.targ = targetable;
                            }

                            public boolean accept(Entity entity) {
                                Integer n2 = new Integer(entity.getId());
                                return this.player == entity.getOwnerId() && this.val$spottersBefore.contains(n2) && !LosEffects.calculateLos(Server.this.game, entity.getId(), this.targ).isBlocked() && entity.isActive() && !entity.isINarcedWith(4L);
                            }
                        });
                        while (object4.hasMoreElements()) {
                            roundUpdated2 = (Entity)object4.nextElement();
                            if (roundUpdated != null && roundUpdated2.crew.getGunnery() >= roundUpdated.crew.getGunnery()) continue;
                            roundUpdated = roundUpdated2;
                        }
                    }
                    if (null != roundUpdated) {
                        int n2 = (roundUpdated.crew.getGunnery() - 4) / 2;
                        ((WeaponResult)object).toHit.addModifier(n2, "Spotting modifier");
                    }
                    if (null != (object4 = ((WeaponResult)object).waa.getEntity(this.game))) {
                        int n3;
                        roundUpdated2 = ((Entity)object4).getEquipment(((WeaponResult)object).waa.getWeaponId());
                        if (((WeaponResult)object).roll >= ((WeaponResult)object).toHit.getValue()) {
                            ((Entity)object4).aTracker.setModifier((Mounted)roundUpdated2, Integer.MIN_VALUE, coords);
                        } else if (null != roundUpdated && (n3 = ((Entity)object4).aTracker.getModifier((Mounted)roundUpdated2, coords)) != Integer.MIN_VALUE) {
                            ((Entity)object4).aTracker.setModifier((Mounted)roundUpdated2, n3 - 1, coords);
                        }
                    }
                }
                vector.addElement(object);
                vector2.addElement(object2);
            }
            --((ArtilleryAttackAction)object2).turnsTilHit;
        }
        object3 = new Vector();
        object2 = vector3.elements();
        while (object2.hasMoreElements()) {
            object = (NukeAttackAction)object2.nextElement();
            if (((NukeAttackAction)object).attackType == NukeAttackAction.TYPE_GENERIC) {
                this.doNuclearExplosion(((NukeAttackAction)object).target, ((NukeAttackAction)object).damage, ((NukeAttackAction)object).degeneration, ((NukeAttackAction)object).secondaryRadius, ((NukeAttackAction)object).craterDepth, (Vector)object3);
            } else {
                this.doNuclearExplosion(((NukeAttackAction)object).target, ((NukeAttackAction)object).nukeClass, (Vector)object3);
            }
            this.game.removeArtilleryAttack((ArtilleryAttackAction)object);
        }
        this.addReport((Vector)object3);
        int n = -1;
        object = vector.elements();
        while (object.hasMoreElements()) {
            serializable = (WeaponResult)object.nextElement();
            this.resolveWeaponAttack((WeaponResult)serializable, n);
            n = ((WeaponResult)serializable).waa.getEntityId();
        }
        object = vector2.elements();
        while (object.hasMoreElements()) {
            this.game.removeArtilleryAttack((ArtilleryAttackAction)object.nextElement());
        }
        object = this.game.getPlayers();
        while (object.hasMoreElements()) {
            serializable = (Player)object.nextElement();
            int n4 = ((Player)serializable).getId();
            this.send(n4, this.createArtilleryPacket((Player)serializable));
        }
    }

    private void enqueueIndirectArtilleryAttacks() {
        Object object;
        this.resolveAllButWeaponAttacks();
        Enumeration enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            object = (EntityAction)enumeration.nextElement();
            final Entity entity = this.game.getEntity(object.getEntityId());
            if (!(object instanceof WeaponAttackAction)) continue;
            final WeaponAttackAction weaponAttackAction = (WeaponAttackAction)object;
            WeaponResult weaponResult = this.preTreatWeaponAttack(weaponAttackAction);
            boolean bl = false;
            Enumeration enumeration2 = this.game.getArtilleryAttacks();
            while (!bl && enumeration2.hasMoreElements()) {
                serializable = (ArtilleryAttackAction)enumeration2.nextElement();
                if (((ArtilleryAttackAction)serializable).getWR().waa.getEntityId() != weaponResult.waa.getEntityId() || ((ArtilleryAttackAction)serializable).getWR().waa.getTarget(this.game).getPosition().equals(weaponResult.waa.getTarget(this.game).getPosition())) continue;
                bl = true;
            }
            if (bl) {
                this.clearArtillerySpotters(entity.getId(), weaponAttackAction.getWeaponId());
            }
            enumeration2 = this.game.getSelectedEntities(new EntitySelector(){
                public int player;
                public Targetable target;
                {
                    this.player = entity.getOwnerId();
                    this.target = weaponAttackAction.getTarget(Server.this.game);
                }

                public boolean accept(Entity entity2) {
                    return this.player == entity2.getOwnerId() && !LosEffects.calculateLos(Server.this.game, entity2.getId(), this.target).isBlocked() && entity2.isActive();
                }
            });
            serializable = new Vector();
            while (enumeration2.hasMoreElements()) {
                Integer n = new Integer(((Entity)enumeration2.nextElement()).getId());
                ((Vector)serializable).addElement(n);
            }
            ArtilleryAttackAction artilleryAttackAction = new ArtilleryAttackAction(weaponResult, this.game, entity.getOwnerId(), (Vector)serializable, entity.getPosition());
            this.game.addArtilleryAttack(artilleryAttackAction);
        }
        this.game.resetActions();
        enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            object = (Player)enumeration.nextElement();
            int n = ((Player)object).getId();
            this.send(n, this.createArtilleryPacket((Player)object));
        }
    }

    private void creditKill(Entity entity, Entity entity2) {
        if (entity.isDoomed() && !entity.getGaveKillCredit()) {
            entity2.addKill(entity);
        }
    }

    private PhysicalResult preTreatPhysicalAttack(AbstractAttackAction abstractAttackAction) {
        Entity entity = this.game.getEntity(abstractAttackAction.getEntityId());
        int n = 0;
        PhysicalResult physicalResult = new PhysicalResult();
        ToHitData toHitData = new ToHitData();
        physicalResult.roll = Compute.d6(2);
        physicalResult.aaa = abstractAttackAction;
        if (abstractAttackAction instanceof BrushOffAttackAction) {
            BrushOffAttackAction brushOffAttackAction = (BrushOffAttackAction)abstractAttackAction;
            int n2 = brushOffAttackAction.getArm();
            brushOffAttackAction.setArm(1);
            toHitData = BrushOffAttackAction.toHit(this.game, abstractAttackAction.getEntityId(), abstractAttackAction.getTarget(this.game), 1);
            brushOffAttackAction.setArm(2);
            physicalResult.toHitRight = BrushOffAttackAction.toHit(this.game, abstractAttackAction.getEntityId(), abstractAttackAction.getTarget(this.game), 2);
            n = BrushOffAttackAction.getDamageFor(entity, 1);
            physicalResult.damageRight = BrushOffAttackAction.getDamageFor(entity, 2);
            brushOffAttackAction.setArm(n2);
            physicalResult.rollRight = Compute.d6(2);
        } else if (abstractAttackAction instanceof ChargeAttackAction) {
            ChargeAttackAction chargeAttackAction = (ChargeAttackAction)abstractAttackAction;
            toHitData = chargeAttackAction.toHit(this.game);
            n = ChargeAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof ClubAttackAction) {
            ClubAttackAction clubAttackAction = (ClubAttackAction)abstractAttackAction;
            toHitData = clubAttackAction.toHit(this.game);
            n = ClubAttackAction.getDamageFor(entity, clubAttackAction.getClub());
        } else if (abstractAttackAction instanceof DfaAttackAction) {
            DfaAttackAction dfaAttackAction = (DfaAttackAction)abstractAttackAction;
            toHitData = dfaAttackAction.toHit(this.game);
            n = DfaAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof KickAttackAction) {
            KickAttackAction kickAttackAction = (KickAttackAction)abstractAttackAction;
            toHitData = kickAttackAction.toHit(this.game);
            n = KickAttackAction.getDamageFor(entity, kickAttackAction.getLeg());
        } else if (abstractAttackAction instanceof ProtomechPhysicalAttackAction) {
            ProtomechPhysicalAttackAction protomechPhysicalAttackAction = (ProtomechPhysicalAttackAction)abstractAttackAction;
            toHitData = protomechPhysicalAttackAction.toHit(this.game);
            n = ProtomechPhysicalAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof PunchAttackAction) {
            PunchAttackAction punchAttackAction = (PunchAttackAction)abstractAttackAction;
            int n3 = punchAttackAction.getArm();
            int n4 = 0;
            punchAttackAction.setArm(1);
            toHitData = punchAttackAction.toHit(this.game);
            punchAttackAction.setArm(2);
            ToHitData toHitData2 = punchAttackAction.toHit(this.game);
            n = PunchAttackAction.getDamageFor(entity, 1);
            n4 = PunchAttackAction.getDamageFor(entity, 2);
            punchAttackAction.setArm(n3);
            if (entity.isProne()) {
                double d;
                double d2 = Compute.oddsAbove(toHitData.getValue());
                if (d2 * (double)n > (d = Compute.oddsAbove(toHitData2.getValue())) * (double)n4) {
                    punchAttackAction.setArm(1);
                } else {
                    punchAttackAction.setArm(2);
                }
            }
            physicalResult.damageRight = n4;
            physicalResult.toHitRight = toHitData2;
            physicalResult.rollRight = Compute.d6(2);
        } else if (abstractAttackAction instanceof PushAttackAction) {
            PushAttackAction pushAttackAction = (PushAttackAction)abstractAttackAction;
            toHitData = pushAttackAction.toHit(this.game);
        } else if (abstractAttackAction instanceof TripAttackAction) {
            TripAttackAction tripAttackAction = (TripAttackAction)abstractAttackAction;
            toHitData = tripAttackAction.toHit(this.game);
        } else if (abstractAttackAction instanceof LayExplosivesAttackAction) {
            LayExplosivesAttackAction layExplosivesAttackAction = (LayExplosivesAttackAction)abstractAttackAction;
            toHitData = layExplosivesAttackAction.toHit(this.game);
            n = LayExplosivesAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof ThrashAttackAction) {
            ThrashAttackAction thrashAttackAction = (ThrashAttackAction)abstractAttackAction;
            toHitData = thrashAttackAction.toHit(this.game);
            n = ThrashAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof JumpJetAttackAction) {
            JumpJetAttackAction jumpJetAttackAction = (JumpJetAttackAction)abstractAttackAction;
            toHitData = jumpJetAttackAction.toHit(this.game);
            if (jumpJetAttackAction.getLeg() == 0) {
                n = JumpJetAttackAction.getDamageFor(entity, 1);
                physicalResult.damageRight = JumpJetAttackAction.getDamageFor(entity, 1);
            } else {
                n = JumpJetAttackAction.getDamageFor(entity, jumpJetAttackAction.getLeg());
                physicalResult.damageRight = 0;
            }
            entity.heatBuildup += (n + physicalResult.damageRight) / 3;
        } else if (abstractAttackAction instanceof GrappleAttackAction) {
            GrappleAttackAction grappleAttackAction = (GrappleAttackAction)abstractAttackAction;
            toHitData = grappleAttackAction.toHit(this.game);
        } else if (abstractAttackAction instanceof BreakGrappleAttackAction) {
            BreakGrappleAttackAction breakGrappleAttackAction = (BreakGrappleAttackAction)abstractAttackAction;
            toHitData = breakGrappleAttackAction.toHit(this.game);
        }
        physicalResult.toHit = toHitData;
        physicalResult.damage = n;
        return physicalResult;
    }

    private void resolvePhysicalAttack(PhysicalResult physicalResult, int n) {
        Object object;
        AbstractAttackAction abstractAttackAction = physicalResult.aaa;
        if (abstractAttackAction instanceof PunchAttackAction) {
            object = (PunchAttackAction)abstractAttackAction;
            if (((PunchAttackAction)object).getArm() == 0) {
                ((PunchAttackAction)object).setArm(1);
                physicalResult.aaa = object;
                this.resolvePunchAttack(physicalResult, n);
                n = ((AbstractEntityAction)object).getEntityId();
                ((PunchAttackAction)object).setArm(2);
                physicalResult.aaa = object;
                this.resolvePunchAttack(physicalResult, n);
            } else {
                this.resolvePunchAttack(physicalResult, n);
                n = ((AbstractEntityAction)object).getEntityId();
            }
        } else if (abstractAttackAction instanceof KickAttackAction) {
            this.resolveKickAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof BrushOffAttackAction) {
            object = (BrushOffAttackAction)abstractAttackAction;
            if (((BrushOffAttackAction)object).getArm() == 0) {
                ((BrushOffAttackAction)object).setArm(1);
                physicalResult.aaa = object;
                this.resolveBrushOffAttack(physicalResult, n);
                n = ((AbstractEntityAction)object).getEntityId();
                ((BrushOffAttackAction)object).setArm(2);
                physicalResult.aaa = object;
                this.resolveBrushOffAttack(physicalResult, n);
            } else {
                this.resolveBrushOffAttack(physicalResult, n);
                n = ((AbstractEntityAction)object).getEntityId();
            }
        } else if (abstractAttackAction instanceof ThrashAttackAction) {
            this.resolveThrashAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof ProtomechPhysicalAttackAction) {
            this.resolveProtoAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof ClubAttackAction) {
            this.resolveClubAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof PushAttackAction) {
            this.resolvePushAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof ChargeAttackAction) {
            this.resolveChargeAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof DfaAttackAction) {
            this.resolveDfaAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof LayExplosivesAttackAction) {
            this.resolveLayExplosivesAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof TripAttackAction) {
            this.resolveTripAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof JumpJetAttackAction) {
            this.resolveJumpJetAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof GrappleAttackAction) {
            this.resolveGrappleAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof BreakGrappleAttackAction) {
            this.resolveBreakGrappleAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        }
        object = this.game.getTarget(abstractAttackAction.getTargetType(), abstractAttackAction.getTargetId());
        if (object instanceof Entity) {
            this.creditKill((Entity)object, this.game.getEntity(n));
        }
    }

    private void checkExtremeGravityMovement(Entity entity, MoveStep moveStep, Coords coords, int n) {
        if (this.game.getOptions().floatOption("gravity") != 1.0f) {
            if (entity instanceof Mech) {
                if (moveStep.getMovementType() == 1 || moveStep.getMovementType() == 4 || moveStep.getMovementType() == 2 || moveStep.getMovementType() == 5) {
                    if (moveStep.getMpUsed() > n) {
                        this.game.addExtremeGravityPSR(entity.checkMovedTooFast(moveStep));
                    }
                } else if (moveStep.getMovementType() == 3) {
                    if (moveStep.getMpUsed() > n) {
                        this.game.addExtremeGravityPSR(entity.checkMovedTooFast(moveStep));
                    } else if (this.game.getOptions().floatOption("gravity") > 1.0f) {
                        PilotingRollData pilotingRollData = entity.getBasePilotingRoll();
                        entity.addPilotingModifierForTerrain(pilotingRollData, moveStep);
                        pilotingRollData.append(new PilotingRollData(entity.getId(), 0, "jumped in high gravity"));
                        this.game.addExtremeGravityPSR(pilotingRollData);
                    }
                }
            } else if (entity instanceof Tank && (moveStep.getMovementType() == 1 || moveStep.getMovementType() == 4 || moveStep.getMovementType() == 2 || moveStep.getMovementType() == 5)) {
                if (moveStep.getMpUsed() > n && !moveStep.isOnlyPavement()) {
                    this.game.addExtremeGravityPSR(entity.checkMovedTooFast(moveStep));
                } else if (moveStep.getMpUsed() > n + 1) {
                    this.game.addExtremeGravityPSR(entity.checkMovedTooFast(moveStep));
                }
            }
        }
    }

    private void doExtremeGravityDamage(Entity entity, int n) {
        HitData hitData;
        int n2;
        if (entity instanceof BipedMech) {
            for (n2 = 6; n2 <= 7; ++n2) {
                hitData = new HitData(n2);
                this.addReport(this.damageEntity(entity, hitData, n, false, 0, true));
            }
        }
        if (entity instanceof QuadMech) {
            for (n2 = 4; n2 <= 7; ++n2) {
                hitData = new HitData(n2);
                this.addReport(this.damageEntity(entity, hitData, n, false, 0, true));
            }
        } else if (entity instanceof Tank) {
            hitData = new HitData(1);
            this.addReport(this.damageEntity(entity, hitData, n, false, 0, true));
        }
    }

    public Vector ejectEntity(Entity entity, boolean bl) {
        Vector<Report> vector = new Vector<Report>();
        if (entity.getCrew().isEjected()) {
            return vector;
        }
        if (entity.getCrew().isDead() || entity.getCrew().isDoomed()) {
            return vector;
        }
        if (entity instanceof Mech) {
            Report report;
            PilotingRollData pilotingRollData = new PilotingRollData(entity.getId(), entity.getCrew().getPiloting(), "ejecting");
            if (entity.isProne()) {
                pilotingRollData.addModifier(5, "Mech is prone");
            }
            if (entity.getCrew().isUnconscious()) {
                pilotingRollData.addModifier(3, "pilot unconscious");
            }
            if (bl) {
                pilotingRollData.addModifier(1, "automatic ejection");
            }
            if (entity.getInternal(0) < 3) {
                pilotingRollData.addModifier(Math.min(3 - entity.getInternal(0), 2), "Head Internal Structure Damage");
            }
            int n = entity.getFacing();
            Coords coords = entity.getPosition().translated((n + 3) % 6);
            IHex iHex = this.game.getBoard().getHex(coords);
            if (iHex != null) {
                if (iHex.terrainLevel(4) > 0 && !iHex.containsTerrain(20)) {
                    pilotingRollData.addModifier(-1, "landing in water");
                } else if (iHex.containsTerrain(2)) {
                    pilotingRollData.addModifier(0, "landing in rough");
                } else if (iHex.containsTerrain(3)) {
                    pilotingRollData.addModifier(0, "landing in rubble");
                } else if (iHex.terrainLevel(1) == 1) {
                    pilotingRollData.addModifier(2, "landing in light woods");
                } else if (iHex.terrainLevel(1) == 2) {
                    pilotingRollData.addModifier(3, "landing in heavy woods");
                } else if (iHex.terrainLevel(1) == 3) {
                    pilotingRollData.addModifier(4, "landing in ultra heavy woods");
                } else if (iHex.terrainLevel(23) == 1) {
                    pilotingRollData.addModifier(3, "landing in light jungle");
                } else if (iHex.terrainLevel(23) == 2) {
                    pilotingRollData.addModifier(5, "landing in heavy jungle");
                } else if (iHex.terrainLevel(23) == 3) {
                    pilotingRollData.addModifier(7, "landing in ultra heavy jungle");
                } else if (iHex.terrainLevel(12) > 0) {
                    pilotingRollData.addModifier(iHex.terrainLevel(12), "landing in a building");
                } else {
                    pilotingRollData.addModifier(-2, "landing in clear terrain");
                }
            } else {
                pilotingRollData.addModifier(-2, "landing off the board");
            }
            if (bl) {
                report = new Report(6395);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
            }
            report = new Report(2180);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(pilotingRollData.getLastPlainDesc(), true);
            report.indent(3);
            vector.addElement(report);
            int n2 = Compute.d6(2);
            report = new Report(2190);
            report.subject = entity.getId();
            report.add(pilotingRollData.getValueAsString());
            report.add(pilotingRollData.getDesc());
            report.add(n2);
            report.indent(4);
            report.newlines = 0;
            MechWarrior mechWarrior = new MechWarrior(entity);
            mechWarrior.setDeployed(true);
            mechWarrior.setId(this.getFreeEntityId());
            this.game.addEntity(mechWarrior.getId(), mechWarrior);
            this.send(this.createAddEntityPacket(mechWarrior.getId()));
            mechWarrior.setDone(true);
            if (n2 < pilotingRollData.getValue()) {
                report.choose(false);
                vector.addElement(report);
                Report.addNewline(vector);
                Vector vector2 = this.damageCrew(mechWarrior, 1);
                if (vector2.size() > 0) {
                    report = (Report)vector2.firstElement();
                    report.indent(3);
                    vector.addElement(report);
                }
            } else {
                report.choose(true);
                vector.addElement(report);
            }
            if (entity.getCrew().isDoomed()) {
                vector.addAll(this.destroyEntity(mechWarrior, "deadly ejection", false, false));
            } else {
                if (this.game.getBoard().contains(coords)) {
                    mechWarrior.setPosition(coords);
                    report = new Report(6400);
                    report.subject = entity.getId();
                    report.indent(5);
                    vector.addElement(report);
                    if (this.game.getOptions().booleanOption("vacuum")) {
                        report = new Report(6405);
                        report.subject = entity.getId();
                        report.indent(3);
                        vector.addElement(report);
                        vector.addAll(this.destroyEntity(mechWarrior, "explosive decompression", false, false));
                    }
                    this.entityUpdate(mechWarrior.getId());
                    this.doEntityDisplacementMinefieldCheck(mechWarrior, entity.getPosition(), coords);
                } else {
                    report = new Report(6410);
                    report.subject = entity.getId();
                    report.indent(3);
                    vector.addElement(report);
                    if (this.game.getOptions().booleanOption("vacuum")) {
                        report = new Report(6405);
                        report.subject = entity.getId();
                        report.indent(3);
                        vector.addElement(report);
                        vector.addAll(this.destroyEntity(mechWarrior, "explosive decompression", false, false));
                    } else {
                        this.game.removeEntity(mechWarrior.getId(), 256);
                        this.send(this.createRemoveEntityPacket(mechWarrior.getId(), 256));
                    }
                }
                if (this.game.getOptions().booleanOption("ejected_pilots_flee")) {
                    this.game.removeEntity(mechWarrior.getId(), 256);
                    this.send(this.createRemoveEntityPacket(mechWarrior.getId(), 256));
                }
            }
        }
        entity.getCrew().setEjected(true);
        if (entity instanceof VTOL) {
            vector.addAll(this.crashVTOL((VTOL)entity));
        }
        vector.addAll(this.destroyEntity(entity, "ejection", true, true));
        if (!bl) {
            this.game.removeEntity(entity.getId(), 528);
            this.send(this.createRemoveEntityPacket(entity.getId(), 528));
        }
        return vector;
    }

    public Vector abandonEntity(Entity entity) {
        Vector<Report> vector = new Vector<Report>();
        if (entity.getCrew().isEjected()) {
            return vector;
        }
        if (entity.getCrew().isDoomed()) {
            return vector;
        }
        if (this.game.getOptions().booleanOption("vacuum")) {
            return vector;
        }
        Coords coords = entity.getPosition();
        if (entity instanceof Mech) {
            Report report = new Report(2027);
            report.subject = entity.getId();
            report.add(entity.getCrew().getName());
            report.addDesc(entity);
            report.indent(3);
            vector.addElement(report);
            MechWarrior mechWarrior = new MechWarrior(entity);
            mechWarrior.getCrew().setUnconscious(entity.getCrew().isUnconscious());
            mechWarrior.setDeployed(true);
            mechWarrior.setId(this.getFreeEntityId());
            this.game.addEntity(mechWarrior.getId(), mechWarrior);
            this.send(this.createAddEntityPacket(mechWarrior.getId()));
            mechWarrior.setDone(true);
            if (this.game.getBoard().contains(coords)) {
                mechWarrior.setPosition(coords);
            }
            this.entityUpdate(mechWarrior.getId());
            this.doEntityDisplacementMinefieldCheck(mechWarrior, entity.getPosition(), coords);
            if (this.game.getOptions().booleanOption("ejected_pilots_flee")) {
                this.game.removeEntity(mechWarrior.getId(), 256);
                this.send(this.createRemoveEntityPacket(mechWarrior.getId(), 256));
            }
        }
        entity.getCrew().setEjected(true);
        return vector;
    }

    private void resolveMechWarriorPickUp() {
        Enumeration enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                MechWarrior mechWarrior;
                return entity instanceof MechWarrior && (mechWarrior = (MechWarrior)entity).getPickedUpById() == -1 && !mechWarrior.isDoomed() && mechWarrior.getTransportId() == -1;
            }
        });
        while (enumeration.hasMoreElements()) {
            Report report;
            Object object;
            boolean bl = false;
            MechWarrior mechWarrior = (MechWarrior)enumeration.nextElement();
            Enumeration enumeration2 = this.game.getEntities(mechWarrior.getPosition());
            while (enumeration2.hasMoreElements()) {
                object = (Entity)enumeration2.nextElement();
                if (((Entity)object).isDoomed() || ((Entity)object).isShutDown() || ((Entity)object).getCrew().isUnconscious() || bl || ((Entity)object).getOwnerId() != mechWarrior.getOwnerId() || ((Entity)object).getId() == mechWarrior.getId()) continue;
                if (object instanceof MechWarrior) {
                    report = new Report(6415, 0);
                    report.add(((Entity)object).getDisplayName());
                    this.addReport(report);
                    continue;
                }
                ((Entity)object).pickUp(mechWarrior);
                mechWarrior.setPickedUpById(((Entity)object).getId());
                mechWarrior.setPickedUpByExternalId(((Entity)object).getExternalId());
                bl = true;
                report = new Report(6420, 0);
                report.add(mechWarrior.getDisplayName());
                report.addDesc((Entity)object);
                this.addReport(report);
            }
            if (!bl) {
                object = this.game.getEnemyEntities(mechWarrior.getPosition(), mechWarrior);
                while (object.hasMoreElements()) {
                    Entity entity = (Entity)object.nextElement();
                    if (entity.isDoomed() || entity.isShutDown() || entity.getCrew().isUnconscious()) continue;
                    if (entity instanceof MechWarrior) {
                        report = new Report(6415, 0);
                        report.add(entity.getDisplayName());
                        this.addReport(report);
                        continue;
                    }
                    entity.pickUp(mechWarrior);
                    mechWarrior.setCaptured(true);
                    mechWarrior.setPickedUpById(entity.getId());
                    mechWarrior.setPickedUpByExternalId(entity.getExternalId());
                    bl = true;
                    report = new Report(6420, 0);
                    report.add(mechWarrior.getDisplayName());
                    report.addDesc(entity);
                    this.addReport(report);
                }
            }
            if (!bl) continue;
            mechWarrior.setPosition(null);
            this.entityUpdate(mechWarrior.getId());
        }
    }

    private void resolveSinkVees() {
        Enumeration enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                if (entity.isOffBoard()) {
                    return false;
                }
                return entity instanceof Tank && entity.getPosition() != null && (entity.getMovementMode() == 3 || entity.getMovementMode() == 4) && Server.this.game.getBoard().getHex(entity.getPosition()).terrainLevel(4) > 0 && entity.getElevation() < 0;
            }
        });
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            this.addReport(this.destroyEntity(entity, "a watery grave", false));
        }
    }

    private void doTryUnstuck() {
        if (this.game.getPhase() != 8) {
            return;
        }
        Enumeration enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                return entity.isStuck();
            }
        });
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            PilotingRollData pilotingRollData = entity.getBasePilotingRoll();
            entity.addPilotingModifierForTerrain(pilotingRollData);
            IHex iHex = this.game.getBoard().getHex(entity.getPosition());
            if (!iHex.containsTerrain(9) && iHex.terrainLevel(24) != 2) {
                pilotingRollData.addModifier(-1, "bogged down");
            }
            Report report = new Report(2340);
            report.addDesc(entity);
            this.addReport(report);
            int n = Compute.d6(2);
            report = new Report(2190);
            report.add(pilotingRollData.getValueAsString());
            report.add(pilotingRollData.getDesc());
            report.add(n);
            if (n < pilotingRollData.getValue()) {
                report.choose(false);
            } else {
                report.choose(true);
                entity.setStuck(false);
                entity.setCanUnstickByJumping(false);
                this.entityUpdate(entity.getId());
            }
            this.addReport(report);
        }
    }

    private void resolveVeeINarcPodRemoval() {
        Enumeration enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                return entity instanceof Tank && entity.mpUsed == 0;
            }
        });
        while (enumeration.hasMoreElements()) {
            boolean bl = true;
            Entity entity = (Entity)enumeration.nextElement();
            for (int i = 0; i <= 5; ++i) {
                if (!entity.weaponFiredFrom(i)) continue;
                bl = false;
            }
            if (!bl || !entity.hasINarcPodsAttached() || !entity.getCrew().isActive()) continue;
            entity.removeAllINarcPods();
            Report report = new Report(2345);
            report.addDesc(entity);
            this.addReport(report);
        }
    }

    private void deadEntitiesCleanup() {
    }

    private void resolveIceBroken(Coords coords) {
        this.game.getBoard().getHex(coords).removeTerrain(20);
        this.sendChangedHex(coords);
        Enumeration enumeration = this.game.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.getElevation() != 0) continue;
            this.doEntityFall(entity, new PilotingRollData(0x7FFFFFFE));
        }
    }

    private void checkForVehicleFire(Tank tank, boolean bl) {
        int n = Compute.d6(2);
        int n2 = 0;
        switch (tank.getMovementMode()) {
            case 5: {
                n2 = 4;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
            }
        }
        if (bl) {
            n = 12;
        }
        Report report = new Report(5250);
        report.subject = tank.getId();
        report.addDesc(tank);
        report.add(8 - n2);
        report.add(n);
        if (n + n2 < 8) {
            report.choose(true);
            this.addReport(report);
        } else {
            if (!bl) {
                report.choose(false);
                this.addReport(report);
            }
            if (n + n2 < 10) {
                this.vehicleMotiveDamage(tank, n2 - 1);
            } else {
                this.resolveVehicleFire(tank, false);
                if (n + n2 >= 12) {
                    report = new Report(5255);
                    report.subject = tank.getId();
                    report.indent(3);
                    this.addReport(report);
                    tank.setOnFire(bl);
                }
            }
        }
    }

    private void resolveVehicleFire(Tank tank, boolean bl) {
        if (bl && !tank.isOnFire()) {
            return;
        }
        for (int i = 0; i < tank.locations(); ++i) {
            if (i == 0 || tank instanceof VTOL && i == 5 || bl && !tank.isLocationBurning(i)) continue;
            HitData hitData = new HitData(i);
            int n = Compute.d6(1);
            this.addReport(this.damageEntity(tank, hitData, n));
            if (n != 1 || !bl) continue;
            tank.extinguishLocation(i);
        }
        this.addNewLines();
    }

    private void vehicleMotiveDamage(Tank tank, int n) {
        Vector<Report> vector = new Vector<Report>();
        int n2 = Compute.d6(2) + n;
        Report report = new Report(6305);
        report.subject = tank.getId();
        report.add("movement system");
        report.newlines = 0;
        report.indent(3);
        vector.addElement(report);
        report = new Report(6310);
        report.subject = tank.getId();
        report.add(n2);
        report.newlines = 0;
        vector.addElement(report);
        if (n2 <= 7) {
            report = new Report(6005);
            report.subject = tank.getId();
            report.add(n2);
            vector.addElement(report);
        } else if (n2 <= 9) {
            report = new Report(6470);
            report.subject = tank.getId();
            report.add(n2);
            vector.addElement(report);
            tank.addMovementDamage(1);
        } else if (n2 < 12) {
            report = new Report(6135);
            report.subject = tank.getId();
            vector.addElement(report);
            tank.addMovementDamage(2);
            int n3 = tank.getOriginalWalkMP();
            if (n3 > 0) {
                tank.setOriginalWalkMP(n3 - 1);
                if (tank.getOriginalWalkMP() == 0 && tank.getMovementMode() == 5 && this.game.getBoard().getHex(tank.getPosition()).terrainLevel(4) > 0 && !this.game.getBoard().getHex(tank.getPosition()).containsTerrain(20)) {
                    vector.addAll(this.destroyEntity(tank, "a watery grave", false));
                }
            }
        } else {
            report = new Report(6140);
            report.subject = tank.getId();
            vector.addElement(report);
            tank.immobilize();
            IHex iHex = this.game.getBoard().getHex(tank.getPosition());
            if (tank.getMovementMode() == 5 && iHex.terrainLevel(4) > 0 && !iHex.containsTerrain(20)) {
                vector.addAll(this.destroyEntity(tank, "a watery grave", false));
            }
            if (tank instanceof VTOL) {
                Report.addNewline(vector);
                vector.addAll(this.crashVTOL((VTOL)tank));
            }
        }
        this.addReport(vector);
    }

    private void addReport(Vector vector) {
        if (this.doBlind()) {
            Enumeration enumeration = this.connections.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                Player player = this.game.getPlayer(connection.getId());
                player.getTurnReport().addAll(this.filterReportVector(vector, player));
            }
        }
        this.vPhaseReport.addAll(vector);
    }

    private void addReport(Report report) {
        if (this.doBlind()) {
            Enumeration enumeration = this.connections.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                Player player = this.game.getPlayer(connection.getId());
                player.getTurnReport().addElement(this.filterReport(report, player, false));
            }
        }
        this.vPhaseReport.addElement(report);
    }

    private void clearReports() {
        if (this.doBlind()) {
            Enumeration enumeration = this.connections.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                Player player = this.game.getPlayer(connection.getId());
                player.getTurnReport().removeAllElements();
            }
        }
        this.vPhaseReport.removeAllElements();
    }

    private void addNewLines() {
        if (this.doBlind()) {
            Enumeration enumeration = this.connections.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                Player player = this.game.getPlayer(connection.getId());
                Report.addNewline(player.getTurnReport());
            }
        }
        Report.addNewline(this.vPhaseReport);
    }

    public void doAssaultDrop(Entity entity) {
        PilotingRollData pilotingRollData = entity instanceof Mech ? entity.getBasePilotingRoll() : new PilotingRollData(entity.getId(), 4, "landing assault drop");
        int n = Compute.d6(2);
        Report report = new Report(2380);
        report.subject = entity.getId();
        report.add(entity.getDisplayName(), true);
        report.add(pilotingRollData.getValueAsString());
        report.add(n);
        report.choose(n >= pilotingRollData.getValue());
        this.addReport(report);
        if (n < pilotingRollData.getValue()) {
            int n2 = pilotingRollData.getValue() - n;
            int n3 = Compute.d6(n2);
            Coords coords = Compute.scatter(entity.getPosition(), n3);
            report = new Report(2385);
            report.subject = entity.getId();
            report.add(n3);
            report.indent(3);
            report.newlines = 0;
            this.addReport(report);
            if (n2 >= 5 || !this.game.getBoard().contains(coords)) {
                report = new Report(2386);
                this.addReport(report);
                this.game.removeEntity(entity.getId(), 2048);
                return;
            }
            entity.setPosition(coords);
            if (entity instanceof Mech || entity instanceof Protomech) {
                entity.setElevation(n2);
                this.doEntityFallsInto(entity, coords, coords, pilotingRollData, true);
            } else if (entity instanceof BattleArmor) {
                for (int i = 1; i < entity.locations(); ++i) {
                    HitData hitData = new HitData(i);
                    this.addReport(this.damageEntity(entity, hitData, Compute.d6(n2)));
                    this.addNewLines();
                }
            } else if (entity instanceof Infantry) {
                HitData hitData = new HitData(0);
                this.addReport(this.damageEntity(entity, hitData, 1));
                this.addNewLines();
            }
        }
        IHex iHex = this.game.getBoard().getHex(entity.getPosition());
        entity.setElevation(entity.elevationOccupied(iHex) - iHex.floor());
        Entity entity2 = Compute.stackingViolation(this.game, entity, entity.getPosition(), null);
        if (entity2 != null) {
            entity.setElevation(entity2.getElevation() + 2);
            report = new Report(2390);
            report.subject = entity.getId();
            report.add(entity.getDisplayName(), true);
            report.add(entity2.getDisplayName(), true);
            this.addReport(report);
            this.doEntityFallsInto(entity, entity.getPosition(), entity.getPosition(), pilotingRollData);
        }
    }

    void doAllAssaultDrops() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.isAssaultDropInProgress()) continue;
            this.doAssaultDrop(entity);
            entity.setLandedAssaultDrop();
        }
    }

    void doMagmaDamage(Entity entity, boolean bl) {
        if ((entity.getMovementMode() == 6 || entity.getMovementMode() == 5 && entity.getOriginalWalkMP() > 0 && !bl) && !entity.isImmobile()) {
            return;
        }
        boolean bl2 = entity instanceof Mech;
        Report report = bl2 ? new Report(2405) : new Report(2400);
        report.addDesc(entity);
        report.subject = entity.getId();
        this.addReport(report);
        if (bl2) {
            for (int i = 0; i < entity.locations(); ++i) {
                if (!bl && !entity.locationIsLeg(i) && !entity.isProne()) continue;
                HitData hitData = new HitData(i);
                this.addReport(this.damageEntity(entity, hitData, Compute.d6(2)));
            }
        } else {
            this.addReport(this.destroyEntity(entity, "fell into magma", false, false));
        }
        this.addNewLines();
    }

    void artilleryDamageHex(Coords coords, Coords coords2, int n, AmmoType ammoType, int n2, Entity entity, Entity entity2, boolean bl, int n3) {
        Report report;
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex == null) {
            return;
        }
        int n4 = n3 - iHex.surface();
        Building building = this.game.getBoard().getBuildingAt(coords);
        int n5 = 0;
        if (!(building == null || bl && n4 > iHex.terrainLevel(12))) {
            n5 = building.getPhaseCF() / 10;
            if (ammoType == null || ammoType.getMunitionType() != 4L) {
                report = this.damageBuilding(building, n);
                if (report != null) {
                    report.subject = n2;
                    this.addReport(report);
                }
                this.addNewLines();
            }
        }
        if (bl && (n4 <= 0 || n4 <= iHex.terrainLevel(12) || n4 == iHex.terrainLevel(16))) {
            return;
        }
        Enumeration enumeration = this.game.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            Entity entity3 = (Entity)enumeration.nextElement();
            int n6 = n;
            ToHitData toHitData = new ToHitData();
            int n7 = 5;
            if (entity3 == entity2) continue;
            if (building != null && n5 > 0 && entity3.getElevation() < iHex.terrainLevel(12)) {
                n7 -= n5;
                if (entity3 instanceof Infantry) continue;
                if (n7 <= 0) {
                    report = new Report(6426);
                    report.subject = n2;
                    report.addDesc(entity3);
                    this.addReport(report);
                    continue;
                }
                report = new Report(6425);
                report.subject = n2;
                report.add(n5);
                this.addReport(report);
            }
            if (!bl ? (entity3 instanceof VTOL || entity3.getMovementMode() == 6) && entity3.getElevation() != 0 && entity3.getElevation() != iHex.terrainLevel(12) && entity3.getElevation() != iHex.terrainLevel(16) : !(entity3 instanceof VTOL) && entity3.getMovementMode() != 6 || entity3.getElevation() != n4) continue;
            if (coords2 != null) {
                toHitData.setSideTable(entity3.sideTable(coords2));
                if (ammoType != null && entity3 instanceof Mech && ammoType.getMunitionType() == 1L && coords2.equals(coords)) {
                    toHitData.setHitTable(4);
                }
            }
            if (ammoType != null) {
                if (ammoType.getMunitionType() == 1L) {
                    if (iHex.containsTerrain(21) && entity3 instanceof Infantry && !(entity3 instanceof BattleArmor)) {
                        n6 *= 2;
                    }
                    if (iHex.containsTerrain(1) || iHex.containsTerrain(23)) {
                        n6 = (n6 + 1) / 2;
                    }
                } else if (ammoType.getMunitionType() == 4L) {
                    if (entity3 instanceof Tank && (entity3.getMovementMode() == 4 || entity3.getMovementMode() == 5)) {
                        report = new Report(6480);
                        report.subject = entity3.getId();
                        report.addDesc(entity3);
                        report.add(toHitData.getTableDesc());
                        report.add(0);
                        this.addReport(report);
                        this.vehicleMotiveDamage((Tank)entity3, 0);
                        continue;
                    }
                    if (entity3 instanceof BattleArmor || !(entity3 instanceof Infantry)) continue;
                    if (iHex.containsTerrain(1) || iHex.containsTerrain(23)) {
                        n6 = (n6 + 1) / 2;
                    }
                }
            }
            this.addNewLines();
            report = new Report(6480);
            report.subject = entity3.getId();
            report.addDesc(entity3);
            report.add(toHitData.getTableDesc());
            report.add(n6);
            this.addReport(report);
            while (n6 > 0) {
                HitData hitData = entity3.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
                this.addReport(this.damageEntity(entity3, hitData, Math.min(n7, n6), false, 0, false, true, false));
                n6 -= Math.min(5, n6);
            }
            if (entity != null) {
                this.creditKill(entity3, entity);
            }
            this.addNewLines();
        }
    }

    void artilleryDamageArea(Coords coords, Coords coords2, AmmoType ammoType, int n, Entity entity, boolean bl, int n2) {
        int n3;
        int n4 = 5;
        if (ammoType.getMunitionType() == 4L) {
            n3 = ammoType.getRackSize() + 10;
        } else if (ammoType.getMunitionType() == 1L) {
            n3 = ammoType.getAmmoType() == 17 ? 15 : ammoType.getRackSize();
            coords2 = coords;
        } else if (this.game.getOptions().booleanOption("maxtech_artillery")) {
            n3 = ammoType.getAmmoType() == 16 ? 25 : ammoType.getRackSize() + 10;
            n4 = 10;
        } else {
            n3 = ammoType.getRackSize();
            n4 = (n3 + 1) / 2;
        }
        this.artilleryDamageArea(coords, coords2, ammoType, n, entity, n3, n4, bl, n2);
    }

    void artilleryDamageArea(Coords coords, Coords coords2, AmmoType ammoType, int n, Entity entity, int n2, int n3, boolean bl, int n4) {
        int n5 = 0;
        while (n2 > 0) {
            ArrayList<Coords> arrayList = Compute.coordsAtRange(coords, n5);
            for (Coords coords3 : arrayList) {
                this.artilleryDamageHex(coords3, coords2, n2, ammoType, n, entity, null, bl, n4);
            }
            coords2 = coords;
            ++n5;
            n2 -= n3;
        }
    }

    void resolveFortify() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Report report;
            Entity entity = (Entity)enumeration.nextElement();
            if (!(entity instanceof Infantry)) continue;
            Infantry infantry = (Infantry)entity;
            int n = infantry.getDugIn();
            if (n == 1) {
                report = new Report(5300);
                report.addDesc(infantry);
                report.subject = infantry.getId();
                this.addReport(report);
                continue;
            }
            if (n != 4) continue;
            Coords coords = infantry.getPosition();
            report = new Report(5305);
            report.addDesc(infantry);
            report.add(coords.getBoardNum());
            report.subject = infantry.getId();
            this.addReport(report);
            IHex iHex = this.game.getBoard().getHex(coords);
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(21, 1));
            this.sendChangedHex(coords);
            Enumeration enumeration2 = this.game.getEntities(coords);
            while (enumeration2.hasMoreElements()) {
                Entity entity2 = (Entity)enumeration2.nextElement();
                if (!(entity2 instanceof Infantry)) continue;
                Infantry infantry2 = (Infantry)entity;
                infantry2.setDugIn(0);
            }
        }
    }

    private void checkBreakSpikes(Entity entity, int n) {
        int n2 = Compute.d6(2);
        if (n2 < 9) {
            Report report = new Report(4445);
            report.newlines = 0;
            report.add(n2);
            report.subject = entity.getId();
            this.addReport(report);
            return;
        }
        Report report = new Report(4440);
        report.newlines = 0;
        report.add(n2);
        report.subject = entity.getId();
        this.addReport(report);
        for (Mounted mounted : entity.getMisc()) {
            if (!mounted.getType().hasFlag(0x400000000L) || mounted.getLocation() != n) continue;
            mounted.setHit(true);
        }
    }

    class ConnectionWatchdog
    extends TimerTask {
        private Server server;
        private int id;
        private int failCount;

        public ConnectionWatchdog(Server server2, int n) {
            this.server = server2;
            this.id = n;
            this.failCount = 0;
        }

        public void run() {
            if (this.server.getPlayer(this.id) != null) {
                this.cancel();
                return;
            }
            if (this.server.getPendingConnection(this.id) == null) {
                this.cancel();
                return;
            }
            System.err.println("Bark Bark");
            if (this.failCount > 10) {
                this.server.getPendingConnection(this.id).close();
                this.cancel();
                System.err.println("Growl");
                return;
            }
            this.server.greeting(this.id);
            ++this.failCount;
        }
    }
}

