/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.commands;

import java.util.Enumeration;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.commands.ClientCommand;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.Mounted;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractEntityAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.SearchlightAttackAction;
import megamek.common.actions.TorsoTwistAction;
import megamek.common.actions.WeaponAttackAction;

public class FireCommand
extends ClientCommand {
    private int cen = -1;
    private Vector<AbstractEntityAction> attacks = new Vector();

    public FireCommand(Client client) {
        super(client, "fire", "used to shoot. See #fire HELP for more details.");
    }

    public String run(String[] stringArray) {
        if (stringArray.length > 1) {
            if (stringArray[1].equalsIgnoreCase("ABORT")) {
                this.clearAttacks();
                return "Move aborted, all movement data cleared.";
            }
            if (stringArray[1].equalsIgnoreCase("SELECT")) {
                try {
                    this.clearAttacks();
                    this.cen = Integer.parseInt(stringArray[2]);
                    return "Entity " + this.ce().toString() + " selected for firing.";
                }
                catch (Exception exception) {
                    return "Not an entity ID or valid number." + exception.toString();
                }
            }
            if (stringArray[1].equalsIgnoreCase("HELP")) {
                return "Available commands:\n#fire ABORT = aborts planed fireing and deselect unit.\n#fire SELECT unitID = Selects the unit named unit ID for fireing. This is a prerequisite for all commands listed after this.\n#fire COMMIT = executs the current fireing plan.\n#fire LIST unitID = List targeting information for all weapons at the specified target. This is currently the only way to get weapon IDs.\n#fire TWIST heading = used for torso twisitng, the heading being to which direction (N, NE, SE, etc) to try and turn.\n#fire TARGET unitID weaponID1 weaponID2 ... = fires all specified weapons at the specified target. Any number of weapons may be specified.\n#fire TARGET unitID ALL = fires all remaining weapons at the specified target.\n";
            }
            if (this.ce() != null) {
                if (stringArray[1].equalsIgnoreCase("COMMIT")) {
                    this.commit();
                    return "Attacks send to the server";
                }
                if (stringArray.length > 2) {
                    if (stringArray[1].equalsIgnoreCase("TARGET")) {
                        String string = "";
                        try {
                            Entity entity = this.client.getEntity(Integer.parseInt(stringArray[2]));
                            if (stringArray.length == 4 && stringArray[3].equalsIgnoreCase("ALL")) {
                                for (Mounted mounted : this.ce().getWeaponList()) {
                                    if (!mounted.canFire() || mounted.isFired()) continue;
                                    this.fire(this.ce().getEquipmentNum(mounted), entity);
                                }
                                return "Fireing all remaining weapons at " + ((Object)entity).toString() + ".";
                            }
                            for (int i = 3; i < stringArray.length; ++i) {
                                this.fire(Integer.parseInt(stringArray[i]), entity);
                                string = string + "Firing weapon " + stringArray[i] + " at " + ((Object)entity).toString() + "\n";
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        return string + " Invalid arguments.";
                    }
                    if (stringArray[1].equalsIgnoreCase("LIST")) {
                        try {
                            Entity entity = this.client.getEntity(Integer.parseInt(stringArray[2]));
                            if (entity != null) {
                                String string = " Weapons for " + this.ce() + " at " + ((Object)entity).toString() + ":\n";
                                for (Mounted mounted : this.ce().getWeaponList()) {
                                    string = string + "(" + this.ce().getEquipmentNum(mounted) + ") " + mounted.getName() + " = " + this.calculateToHit(this.ce().getEquipmentNum(mounted), entity) + "\n";
                                }
                                return string;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        return "Invalid Target ID.";
                    }
                    if (stringArray[1].equalsIgnoreCase("TWIST") && stringArray.length > 2) {
                        this.torsoTwist(FireCommand.getDirection(stringArray[2]));
                        return "Torso-twisted (or rotated turret). All attacks planned until now have been clearned.";
                    }
                }
            } else {
                return "No entity selected, first select an entity to shoot from.";
            }
        }
        this.clearAttacks();
        return "No arguments given, or there was an error parsing the arguments. All attack data cleared.";
    }

    private void clearAttacks() {
        if (this.ce() == null) {
            return;
        }
        Enumeration<AbstractEntityAction> enumeration = this.attacks.elements();
        while (enumeration.hasMoreElements()) {
            AbstractEntityAction abstractEntityAction = enumeration.nextElement();
            if (!(abstractEntityAction instanceof WeaponAttackAction)) continue;
            WeaponAttackAction weaponAttackAction = (WeaponAttackAction)abstractEntityAction;
            this.ce().getEquipment(weaponAttackAction.getWeaponId()).setUsedThisRound(false);
        }
        this.attacks.removeAllElements();
        this.client.game.removeActionsFor(this.cen);
        this.ce().setSecondaryFacing(this.ce().getFacing());
        this.ce().setArmsFlipped(false);
        this.cen = -1;
    }

    private void torsoTwist(int n) {
        Enumeration<AbstractEntityAction> enumeration = this.attacks.elements();
        while (enumeration.hasMoreElements()) {
            AbstractEntityAction abstractEntityAction = enumeration.nextElement();
            if (!(abstractEntityAction instanceof WeaponAttackAction)) continue;
            WeaponAttackAction weaponAttackAction = (WeaponAttackAction)abstractEntityAction;
            this.ce().getEquipment(weaponAttackAction.getWeaponId()).setUsedThisRound(false);
        }
        this.attacks.removeAllElements();
        this.client.game.removeActionsFor(this.cen);
        this.ce().setSecondaryFacing(this.ce().getFacing());
        this.ce().setArmsFlipped(false);
        int n2 = this.ce().clipSecondaryFacing(n);
        this.attacks.addElement(new TorsoTwistAction(this.cen, n2));
        this.ce().setSecondaryFacing(n2);
    }

    private void fire(int n, Targetable targetable) {
        Mounted mounted = this.ce().getEquipment(n);
        if (this.ce() == null || targetable == null || mounted == null || !(mounted.getType() instanceof WeaponType)) {
            throw new IllegalArgumentException("current fire parameters are invalid");
        }
        if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
            this.doSearchlight(targetable);
        }
        WeaponAttackAction weaponAttackAction = new WeaponAttackAction(this.cen, targetable.getTargetType(), targetable.getTargetId(), n);
        if (mounted.getLinked() != null && ((WeaponType)mounted.getType()).getAmmoType() != -1) {
            Mounted mounted2 = mounted.getLinked();
            AmmoType ammoType = (AmmoType)mounted2.getType();
            weaponAttackAction.setAmmoId(this.ce().getEquipmentNum(mounted2));
            if (ammoType.getMunitionType() == 0x1000000L && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 45) || ammoType.getMunitionType() == 0x8000000000L) {
                weaponAttackAction.setOtherAttackInfo(50);
            }
        }
        weaponAttackAction.setAimedLocation(-1);
        weaponAttackAction.setAimingMode(0);
        this.attacks.addElement(weaponAttackAction);
        this.client.game.addAction(weaponAttackAction);
        mounted.setUsedThisRound(true);
    }

    private void doSearchlight(Targetable targetable) {
        if (this.ce() == null || targetable == null) {
            throw new IllegalArgumentException("current searchlight parameters are invalid");
        }
        if (!SearchlightAttackAction.isPossible(this.client.game, this.cen, targetable, null)) {
            return;
        }
        SearchlightAttackAction searchlightAttackAction = new SearchlightAttackAction(this.cen, targetable.getTargetType(), targetable.getTargetId());
        this.attacks.addElement(searchlightAttackAction);
        this.client.game.addAction(searchlightAttackAction);
    }

    private String calculateToHit(int n, Targetable targetable) {
        String string = "No Data";
        if (targetable != null && n != -1 && this.ce() != null) {
            string = "";
            ToHitData toHitData = WeaponAttackAction.toHit(this.client.game, this.cen, targetable, n, -1, 0);
            string = string + " Range: " + this.ce().getPosition().distance(targetable.getPosition());
            Mounted mounted = this.ce().getEquipment(n);
            string = mounted.isUsedThisRound() ? string + " Can't shoot: " + Messages.getString("FiringDisplay.alreadyFired") : (mounted.getType().hasFlag(16L) ? string + " Can't shoot: " + Messages.getString("FiringDisplay.autoFiringWeapon") : (toHitData.getValue() == Integer.MAX_VALUE ? string + " Can't shoot: " + toHitData.getValueAsString() : (toHitData.getValue() == 0x7FFFFFFE ? string + " Automatic Failure: " + toHitData.getValueAsString() : string + " To hit: " + toHitData.getValueAsString() + " (" + Compute.oddsAbove(toHitData.getValue()) + "%)")));
            string = string + " To Hit modifiers: " + toHitData.getDesc();
        }
        return string;
    }

    private void commit() {
        WeaponAttackAction weaponAttackAction;
        boolean bl;
        Targetable targetable;
        Entity entity;
        WeaponAttackAction weaponAttackAction2;
        AbstractEntityAction abstractEntityAction;
        Vector<EntityAction> vector = new Vector<EntityAction>();
        Enumeration<AbstractEntityAction> enumeration = this.attacks.elements();
        while (enumeration.hasMoreElements()) {
            abstractEntityAction = enumeration.nextElement();
            if (abstractEntityAction instanceof WeaponAttackAction) {
                weaponAttackAction2 = (WeaponAttackAction)abstractEntityAction;
                entity = weaponAttackAction2.getEntity(this.client.game);
                targetable = weaponAttackAction2.getTarget(this.client.game);
                bl = Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), targetable.getPosition(), 1);
                if (!bl) continue;
                weaponAttackAction = new WeaponAttackAction(weaponAttackAction2.getEntityId(), weaponAttackAction2.getTargetType(), weaponAttackAction2.getTargetId(), weaponAttackAction2.getWeaponId());
                weaponAttackAction.setAimedLocation(weaponAttackAction2.getAimedLocation());
                weaponAttackAction.setAimingMode(weaponAttackAction2.getAimingMode());
                weaponAttackAction.setOtherAttackInfo(weaponAttackAction2.getOtherAttackInfo());
                vector.addElement(weaponAttackAction);
                continue;
            }
            vector.addElement(abstractEntityAction);
        }
        enumeration = this.attacks.elements();
        while (enumeration.hasMoreElements()) {
            abstractEntityAction = enumeration.nextElement();
            if (!(abstractEntityAction instanceof WeaponAttackAction)) continue;
            weaponAttackAction2 = (WeaponAttackAction)abstractEntityAction;
            entity = weaponAttackAction2.getEntity(this.client.game);
            targetable = weaponAttackAction2.getTarget(this.client.game);
            bl = Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), targetable.getPosition(), 1);
            if (bl) continue;
            weaponAttackAction = new WeaponAttackAction(weaponAttackAction2.getEntityId(), weaponAttackAction2.getTargetType(), weaponAttackAction2.getTargetId(), weaponAttackAction2.getWeaponId());
            weaponAttackAction.setAimedLocation(weaponAttackAction2.getAimedLocation());
            weaponAttackAction.setAimingMode(weaponAttackAction2.getAimingMode());
            weaponAttackAction.setOtherAttackInfo(weaponAttackAction2.getOtherAttackInfo());
            vector.addElement(weaponAttackAction);
        }
        this.client.sendAttackData(this.cen, vector);
        this.attacks.removeAllElements();
    }

    public Entity ce() {
        return this.client.game.getEntity(this.cen);
    }
}

