/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.commands;

import megamek.client.Client;
import megamek.client.commands.ClientCommand;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.MovePath;

public class MoveCommand
extends ClientCommand {
    public static final int GEAR_LAND = 0;
    public static final int GEAR_BACKUP = 1;
    public static final int GEAR_JUMP = 2;
    public static final int GEAR_CHARGE = 3;
    public static final int GEAR_DFA = 4;
    public static final int GEAR_TURN = 5;
    public static final int GEAR_SWIM = 6;
    private MovePath cmd;
    private int cen = -1;
    int gear;

    public MoveCommand(Client client) {
        super(client, "move", "Move your units. Use #move HELP for more information.");
    }

    public String run(String[] stringArray) {
        if (stringArray.length > 1) {
            Coords coords = null;
            if (stringArray[1].equalsIgnoreCase("ABORT")) {
                this.clearAllMoves();
                this.cen = -1;
                return "Move aborted, all movement data cleared.";
            }
            if (stringArray[1].equalsIgnoreCase("HELP")) {
                return "Available commands:\n#move ABORT = aborts planed move and deselect unit.\n#move SELECT unitID = Selects thhe unit named unit ID for movement. This is a prerequisite for all commands listed after this.\n#move COMMIT = comits the planed movement.\n#move JUMP = clears all movement and starts jump movement. Eiether the entire move is a jump or the entire move is a walk. switching gears will cancel all planned movement (but leave the unit selected).\n#move BACK [x y] = Start walking backwards, can be followed by a coordiate.\n#move WALK [x y] = Start walking/running forwards, this is the default. Can be followed by a coordiate.\n#move TURN [x y] = Starts turning towards target coordinate. Can be followed by a coordiate.\n#move CLIP = Clips to path to what is actually possible, and reports on what will happen if commited.\n#move GETUP = Attempt to stand up. Will require a piloting roll.\n#move x y = move towards coordinate in the current gear. It will do pathfinding for least cost path. Note that the entity will try to move to each coordinate supplied in order.\n";
            }
            if (stringArray[1].equalsIgnoreCase("SELECT")) {
                try {
                    this.clearAllMoves();
                    this.cen = Integer.parseInt(stringArray[2]);
                    if (this.ce() == null) {
                        this.cen = -1;
                        return "Not an entity ID or valid number.";
                    }
                    this.cmd = new MovePath(this.client.game, this.ce());
                    return "Entity " + this.ce().toString() + " selected for movement.";
                }
                catch (Exception exception) {
                    return "Not an entity ID or valid number." + exception.toString();
                }
            }
            if (this.ce() != null) {
                if (stringArray[1].equalsIgnoreCase("JUMP")) {
                    this.clearAllMoves();
                    if (!this.cmd.isJumping()) {
                        this.cmd.addStep(7);
                    }
                    this.gear = 2;
                    return "Entity " + this.ce().toString() + " is going to jump.";
                }
                if (stringArray[1].equalsIgnoreCase("COMMIT")) {
                    this.moveTo(this.cmd);
                    return "Move sent.";
                }
                if (stringArray[1].equalsIgnoreCase("BACK")) {
                    if (this.gear == 2) {
                        this.clearAllMoves();
                    }
                    this.gear = 1;
                } else if (stringArray[1].equalsIgnoreCase("WALK")) {
                    if (this.gear == 2) {
                        this.clearAllMoves();
                    }
                    this.gear = 0;
                } else if (stringArray[1].equalsIgnoreCase("TURN")) {
                    this.gear = 5;
                } else {
                    if (stringArray[1].equalsIgnoreCase("CLIP")) {
                        this.cmd.clipToPossible();
                        return "Path cliped to whats actually possible. " + this.ce().toString() + " is now in gear " + this.gearName(this.gear) + " heading towards " + this.cmd.getFinalCoords().toFriendlyString() + " with a final facing of " + MoveCommand.getDirection(this.cmd.getFinalFacing()) + ". Total mp used: " + this.cmd.getMpUsed() + " for a movement of: " + this.cmd.getHexesMoved();
                    }
                    if (stringArray[1].equalsIgnoreCase("GETUP")) {
                        if (this.cmd.getFinalProne() || this.cmd.getFinalHullDown()) {
                            this.cmd.addStep(5);
                            return "Mech will try to stand up. this requieres a piloting roll.";
                        }
                        return "Trying to get up but the mech is not prone.";
                    }
                    coords = new Coords(Integer.parseInt(stringArray[1]) - 1, Integer.parseInt(stringArray[2]) - 1);
                }
                if (coords == null && stringArray.length > 3) {
                    coords = new Coords(Integer.parseInt(stringArray[2]) - 1, Integer.parseInt(stringArray[3]) - 1);
                }
                this.currentMove(coords);
                return "Commands accepted " + this.ce().toString() + " is now in gear " + this.gearName(this.gear) + " heading towards " + this.cmd.getFinalCoords().toFriendlyString() + ". Total mp used: " + this.cmd.getMpUsed() + " for a movement of: " + this.cmd.getHexesMoved();
            }
        }
        this.clearAllMoves();
        return "No arguments given, or there was an error parsing the arguments. All movement data cleared.";
    }

    private void currentMove(Coords coords) {
        if (coords != null) {
            if (this.gear == 5) {
                this.cmd.rotatePathfinder(this.cmd.getFinalCoords().direction(coords));
            } else if (this.gear == 0 || this.gear == 2) {
                this.cmd.findPathTo(coords, 1);
            } else if (this.gear == 1) {
                this.cmd.findPathTo(coords, 2);
            } else if (this.gear == 3) {
                this.cmd.findPathTo(coords, 8);
            } else if (this.gear == 4) {
                this.cmd.findPathTo(coords, 9);
            } else if (this.gear == 6) {
                this.cmd.findPathTo(coords, 27);
            }
        }
    }

    private String gearName(int n) {
        if (n == 5) {
            return "turning";
        }
        if (n == 0) {
            return "walking";
        }
        if (n == 1) {
            return "backup";
        }
        if (n == 3) {
            return "charging";
        }
        if (n == 4) {
            return "death from aboveing";
        }
        if (n == 6) {
            return "swiming";
        }
        if (n == 2) {
            return "jumping";
        }
        return "Unknown";
    }

    private void clearAllMoves() {
        if (this.ce() != null) {
            if (this.ce().getMovementMode() == 13) {
                this.ce().setMovementMode(1);
            } else if (this.ce().getMovementMode() == 14) {
                this.ce().setMovementMode(2);
            }
            this.cmd = new MovePath(this.client.game, this.ce());
        } else {
            this.cmd = null;
        }
        this.gear = 0;
    }

    private synchronized void moveTo(MovePath movePath) {
        movePath.clipToPossible();
        if (this.ce().hasUMU()) {
            this.client.sendUpdateEntity(this.ce());
        }
        this.client.moveEntity(this.cen, movePath);
    }

    public Entity ce() {
        return this.client.game.getEntity(this.cen);
    }
}

