/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.ui.AWT.AlertDialog;
import megamek.client.ui.AWT.ClientDialog;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.DialogOptionComponent;
import megamek.client.ui.AWT.DialogOptionListener;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.Slider;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Dropship;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.EquipmentType;
import megamek.common.FighterSquadron;
import megamek.common.GunEmplacement;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Jumpship;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.SmallCraft;
import megamek.common.Tank;
import megamek.common.TechConstants;
import megamek.common.WeaponType;
import megamek.common.options.IOption;
import megamek.common.options.IOptionGroup;
import megamek.common.options.PilotOptions;
import megamek.common.preference.PreferenceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomMechDialog
extends ClientDialog
implements ActionListener,
DialogOptionListener {
    private static final long serialVersionUID = -4426594323169113467L;
    private Label labName = new Label(Messages.getString("CustomMechDialog.labName"), 2);
    private TextField fldName = new TextField(20);
    private Label labGunnery = new Label(Messages.getString("CustomMechDialog.labGunnery"), 2);
    private TextField fldGunnery = new TextField(3);
    private Label labGunneryL = new Label(Messages.getString("CustomMechDialog.labGunneryL"), 2);
    private TextField fldGunneryL = new TextField(3);
    private Label labGunneryM = new Label(Messages.getString("CustomMechDialog.labGunneryM"), 2);
    private TextField fldGunneryM = new TextField(3);
    private Label labGunneryB = new Label(Messages.getString("CustomMechDialog.labGunneryB"), 2);
    private TextField fldGunneryB = new TextField(3);
    private Label labPiloting = new Label(Messages.getString("CustomMechDialog.labPiloting"), 2);
    private TextField fldPiloting = new TextField(3);
    private Label labC3 = new Label(Messages.getString("CustomMechDialog.labC3"), 2);
    private Choice choC3 = new Choice();
    private int[] entityCorrespondance;
    private Label labCallsign = new Label(Messages.getString("CustomMechDialog.labCallsign"), 1);
    private Label labUnitNum = new Label(Messages.getString("CustomMechDialog.labUnitNum"), 1);
    private Choice choUnitNum = new Choice();
    private Vector<Entity> entityUnitNum = new Vector();
    private Label labDeployment = new Label(Messages.getString("CustomMechDialog.labDeployment"), 2);
    private Choice choDeployment = new Choice();
    private Label labAutoEject = new Label(Messages.getString("CustomMechDialog.labAutoEject"), 2);
    private Checkbox chAutoEject = new Checkbox();
    private Label labSearchlight = new Label(Messages.getString("CustomMechDialog.labSearchlight"), 2);
    private Checkbox chSearchlight = new Checkbox();
    private Label labCommander = new Label(Messages.getString("CustomMechDialog.labCommander"), 2);
    private Checkbox chCommander = new Checkbox();
    private Label labOffBoard = new Label(Messages.getString("CustomMechDialog.labOffBoard"), 2);
    private Checkbox chOffBoard = new Checkbox();
    private Label labOffBoardDirection = new Label(Messages.getString("CustomMechDialog.labOffBoardDirection"), 2);
    private Choice choOffBoardDirection = new Choice();
    private Label labOffBoardDistance = new Label(Messages.getString("CustomMechDialog.labOffBoardDistance"), 2);
    private TextField fldOffBoardDistance = new TextField(4);
    private Button butOffBoardDistance = new Button("0");
    private Label labTargSys = new Label(Messages.getString("CustomMechDialog.labTargSys"), 2);
    private Choice choTargSys = new Choice();
    private Label labStartVelocity = new Label(Messages.getString("CustomMechDialog.labStartVelocity"), 2);
    private TextField fldStartVelocity = new TextField(3);
    private Label labStartElevation = new Label(Messages.getString("CustomMechDialog.labStartElevation"), 2);
    private TextField fldStartElevation = new TextField(3);
    private Panel panButtons = new Panel();
    private Button butOkay = new Button(Messages.getString("Okay"));
    private Button butCancel = new Button(Messages.getString("Cancel"));
    private Button butNext = new Button(Messages.getString("Next"));
    private Button butPrev = new Button(Messages.getString("Previous"));
    private Vector<MunitionChoicePanel> m_vMunitions = new Vector();
    private Panel panMunitions = new Panel();
    private Vector<RapidfireMGPanel> m_vMGs = new Vector();
    private Panel panRapidfireMGs = new Panel();
    private Vector<MineChoicePanel> m_vMines = new Vector();
    private Panel panMines = new Panel();
    private Vector<SantaAnnaChoicePanel> m_vSantaAnna = new Vector();
    private Panel panSantaAnna = new Panel();
    private BombChoicePanel m_bombs;
    private Panel panBombs = new Panel();
    private Entity entity;
    private boolean okay = false;
    private ClientGUI clientgui;
    private Client client;
    private PilotOptions options;
    private Vector<DialogOptionComponent> optionComps = new Vector();
    private Panel panOptions = new Panel();
    private ScrollPane scrOptions = new ScrollPane();
    private ScrollPane scrAll = new ScrollPane();
    private TextArea texDesc = new TextArea(Messages.getString("CustomMechDialog.texDesc"), 3, 35, 1);
    private boolean editable;
    private int direction = -1;
    private int distance = 17;

    public CustomMechDialog(ClientGUI clientGUI, Client client, Entity entity, boolean bl) {
        super(clientGUI.frame, Messages.getString("CustomMechDialog.title"), true);
        Object object;
        Mech mech;
        Panel panel = new Panel();
        this.entity = entity;
        this.clientgui = clientGUI;
        this.client = client;
        this.options = entity.getCrew().getOptions();
        this.editable = bl;
        this.texDesc.setEditable(false);
        if (entity instanceof Tank) {
            this.labPiloting.setText(Messages.getString("CustomMechDialog.labDriving"));
        } else if (entity instanceof Infantry) {
            this.labPiloting.setText(Messages.getString("CustomMechDialog.labAntiMech"));
        } else {
            this.labPiloting.setText(Messages.getString("CustomMechDialog.labPiloting"));
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labName, gridBagConstraints);
        panel.add(this.labName);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fldName, gridBagConstraints);
        panel.add(this.fldName);
        if (client.game.getOptions().booleanOption("rpg_gunnery")) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labGunneryL, gridBagConstraints);
            panel.add(this.labGunneryL);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.fldGunneryL, gridBagConstraints);
            panel.add(this.fldGunneryL);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labGunneryM, gridBagConstraints);
            panel.add(this.labGunneryM);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.fldGunneryM, gridBagConstraints);
            panel.add(this.fldGunneryM);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labGunneryB, gridBagConstraints);
            panel.add(this.labGunneryB);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.fldGunneryB, gridBagConstraints);
            panel.add(this.fldGunneryB);
        } else {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labGunnery, gridBagConstraints);
            panel.add(this.labGunnery);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.fldGunnery, gridBagConstraints);
            panel.add(this.fldGunnery);
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labPiloting, gridBagConstraints);
        panel.add(this.labPiloting);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fldPiloting, gridBagConstraints);
        panel.add(this.fldPiloting);
        if (entity instanceof Aero) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labStartVelocity, gridBagConstraints);
            panel.add(this.labStartVelocity);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.fldStartVelocity, gridBagConstraints);
            panel.add(this.fldStartVelocity);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labStartElevation, gridBagConstraints);
            panel.add(this.labStartElevation);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.fldStartElevation, gridBagConstraints);
            panel.add(this.fldStartElevation);
        }
        if (entity instanceof Mech && (mech = (Mech)entity).getCockpitType() != 1) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labAutoEject, gridBagConstraints);
            panel.add(this.labAutoEject);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.chAutoEject, gridBagConstraints);
            panel.add(this.chAutoEject);
            this.chAutoEject.setState(!mech.isAutoEject());
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labDeployment, gridBagConstraints);
        panel.add(this.labDeployment);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.choDeployment, gridBagConstraints);
        panel.add(this.choDeployment);
        this.refreshDeployment();
        if (clientGUI.getClient().game.getOptions().booleanOption("pilot_advantages") || clientGUI.getClient().game.getOptions().booleanOption("manei_domini")) {
            this.scrOptions.add(this.panOptions);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.scrOptions, gridBagConstraints);
            panel.add(this.scrOptions);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.texDesc, gridBagConstraints);
            panel.add(this.texDesc);
        }
        if (entity.hasC3() || entity.hasC3i()) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labC3, gridBagConstraints);
            panel.add(this.labC3);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.choC3, gridBagConstraints);
            panel.add(this.choC3);
            this.refreshC3();
        }
        boolean bl2 = false;
        for (Mounted object2 : entity.getWeaponList()) {
            WeaponType weaponType = (WeaponType)object2.getType();
            if (!weaponType.hasFlag(32768L)) continue;
            bl2 = true;
        }
        if (bl2) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labOffBoard, gridBagConstraints);
            panel.add(this.labOffBoard);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.chOffBoard, gridBagConstraints);
            panel.add(this.chOffBoard);
            this.chOffBoard.setState(entity.isOffBoard());
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labOffBoardDirection, gridBagConstraints);
            panel.add(this.labOffBoardDirection);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.choOffBoardDirection, gridBagConstraints);
            this.choOffBoardDirection.add(Messages.getString("CustomMechDialog.North"));
            this.choOffBoardDirection.add(Messages.getString("CustomMechDialog.South"));
            this.choOffBoardDirection.add(Messages.getString("CustomMechDialog.East"));
            this.choOffBoardDirection.add(Messages.getString("CustomMechDialog.West"));
            this.direction = entity.getOffBoardDirection();
            if (-1 == this.direction) {
                this.direction = 0;
            }
            this.choOffBoardDirection.select(this.direction);
            panel.add(this.choOffBoardDirection);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labOffBoardDistance, gridBagConstraints);
            panel.add(this.labOffBoardDistance);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            this.butOffBoardDistance.addActionListener(this);
            gridBagLayout.setConstraints(this.butOffBoardDistance, gridBagConstraints);
            this.butOffBoardDistance.setLabel(Integer.toString(this.distance));
            panel.add(this.butOffBoardDistance);
        }
        if (!entity.hasTargComp() && clientGUI.getClient().game.getOptions().booleanOption("allow_level_3_targsys") && (entity instanceof Mech || clientGUI.getClient().game.getOptions().booleanOption("tank_level_3_targsys") && entity instanceof Tank) && !entity.hasC3() && !entity.hasC3i()) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labTargSys, gridBagConstraints);
            panel.add(this.labTargSys);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            this.choTargSys.add(MiscType.getTargetSysName(0));
            this.choTargSys.add(MiscType.getTargetSysName(2));
            this.choTargSys.add(MiscType.getTargetSysName(3));
            this.choTargSys.add(MiscType.getTargetSysName(5));
            gridBagLayout.setConstraints(this.choTargSys, gridBagConstraints);
            panel.add(this.choTargSys);
            this.choTargSys.select(MiscType.getTargetSysName(entity.getTargSysType()));
        }
        if (entity instanceof Protomech) {
            object = new StringBuffer(Messages.getString("CustomMechDialog.Callsign"));
            ((StringBuffer)object).append(": ");
            ((StringBuffer)object).append((char)(this.entity.getUnitNumber() + PreferenceManager.getClientPreferences().getUnitStartChar())).append('-').append(this.entity.getId());
            this.labCallsign.setText(((StringBuffer)object).toString());
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.labCallsign, gridBagConstraints);
            panel.add(this.labCallsign);
            Enumeration<Entity> n2 = client.game.getSelectedEntities(new EntitySelector(){
                private final int ownerId;
                private final char unitNumber;
                {
                    this.ownerId = CustomMechDialog.this.entity.getOwnerId();
                    this.unitNumber = CustomMechDialog.this.entity.getUnitNumber();
                }

                public boolean accept(Entity entity) {
                    return entity instanceof Protomech && this.ownerId == entity.getOwnerId() && this.unitNumber != entity.getUnitNumber();
                }
            });
            if (n2.hasMoreElements()) {
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 13;
                gridBagLayout.setConstraints(this.labUnitNum, gridBagConstraints);
                panel.add(this.labUnitNum);
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(this.choUnitNum, gridBagConstraints);
                panel.add(this.choUnitNum);
                this.refreshUnitNum(n2);
            }
        }
        if (!(entity instanceof Infantry) || entity instanceof BattleArmor) {
            this.setupMunitions();
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.panMunitions, gridBagConstraints);
            panel.add(this.panMunitions);
        }
        if ((entity instanceof Dropship || entity instanceof Jumpship) && clientGUI.getClient().game.getOptions().booleanOption("at2_nukes")) {
            this.setupSantaAnna();
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.panSantaAnna, gridBagConstraints);
            panel.add(this.panSantaAnna);
        }
        if (entity instanceof Aero && !(entity instanceof FighterSquadron) && !(entity instanceof SmallCraft) && !(entity instanceof Jumpship)) {
            this.setupBombs();
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.panBombs, gridBagConstraints);
            panel.add(this.panBombs);
        }
        if (clientGUI.getClient().game.getOptions().booleanOption("maxtech_burst")) {
            gridBagConstraints.gridwidth = 1;
            this.setupRapidfireMGs();
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.panRapidfireMGs, gridBagConstraints);
            panel.add(this.panRapidfireMGs);
        }
        if (clientGUI.getClient().game.getOptions().booleanOption("night_battle")) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labSearchlight, gridBagConstraints);
            panel.add(this.labSearchlight);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.chSearchlight, gridBagConstraints);
            panel.add(this.chSearchlight);
            this.chSearchlight.setState(entity.hasSpotlight());
        }
        if (clientGUI.getClient().game.getOptions().booleanOption("commander_killed")) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labCommander, gridBagConstraints);
            panel.add(this.labCommander);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.chCommander, gridBagConstraints);
            panel.add(this.chCommander);
            this.chCommander.setState(entity.isCommander());
        }
        this.setupMines();
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.panMines, gridBagConstraints);
        panel.add(this.panMines);
        this.setupButtons();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.panButtons, gridBagConstraints);
        panel.add(this.panButtons);
        this.fldName.setText(entity.getCrew().getName());
        this.fldName.addActionListener(this);
        this.fldGunnery.setText(new Integer(entity.getCrew().getGunnery()).toString());
        this.fldGunnery.addActionListener(this);
        this.fldGunneryL.setText(new Integer(entity.getCrew().getGunneryL()).toString());
        this.fldGunneryL.addActionListener(this);
        this.fldGunneryM.setText(new Integer(entity.getCrew().getGunneryM()).toString());
        this.fldGunneryM.addActionListener(this);
        this.fldGunneryB.setText(new Integer(entity.getCrew().getGunneryB()).toString());
        this.fldGunneryB.addActionListener(this);
        this.fldPiloting.setText(new Integer(entity.getCrew().getPiloting()).toString());
        this.fldPiloting.addActionListener(this);
        if (entity instanceof Aero) {
            object = (Aero)entity;
            this.fldStartVelocity.setText(new Integer(((Aero)object).getCurrentVelocity()).toString());
            this.fldStartVelocity.addActionListener(this);
            this.fldStartElevation.setText(new Integer(((Entity)object).getElevation()).toString());
            this.fldStartElevation.addActionListener(this);
        }
        if (!bl) {
            this.fldName.setEnabled(false);
            this.fldGunnery.setEnabled(false);
            this.fldGunneryL.setEnabled(false);
            this.fldGunneryM.setEnabled(false);
            this.fldGunneryB.setEnabled(false);
            this.fldPiloting.setEnabled(false);
            this.choC3.setEnabled(false);
            this.choDeployment.setEnabled(false);
            this.chAutoEject.setEnabled(false);
            this.chSearchlight.setEnabled(false);
            this.chCommander.setEnabled(false);
            this.choTargSys.setEnabled(false);
            this.disableMunitionEditing();
            this.disableMGSetting();
            this.disableMineSetting();
            this.chOffBoard.setEnabled(false);
            this.choOffBoardDirection.setEnabled(false);
            this.fldOffBoardDistance.setEnabled(false);
            this.fldStartVelocity.setEnabled(false);
            this.fldStartElevation.setEnabled(false);
        }
        this.scrAll.add(panel);
        this.add(this.scrAll);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CustomMechDialog.this.setVisible(false);
            }
        });
        this.pack();
        int n = panel.getPreferredSize().width + this.scrAll.getInsets().right;
        int n2 = panel.getPreferredSize().height + this.panButtons.getPreferredSize().height + this.scrAll.getInsets().bottom;
        this.setLocationAndSize(n, n2);
    }

    private void setupButtons() {
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        this.butNext.addActionListener(this);
        this.butPrev.addActionListener(this);
        this.panButtons.setLayout(new GridLayout(1, 4, 10, 0));
        this.panButtons.add(this.butPrev);
        this.panButtons.add(this.butOkay);
        this.panButtons.add(this.butCancel);
        this.panButtons.add(this.butNext);
        this.butNext.setEnabled(this.getNextEntity(true) != null);
        this.butPrev.setEnabled(this.getNextEntity(false) != null);
    }

    private void setupRapidfireMGs() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panRapidfireMGs.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        for (Mounted mounted : this.entity.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (!weaponType.hasFlag(512L)) continue;
            gridBagConstraints.gridy = n++;
            RapidfireMGPanel rapidfireMGPanel = new RapidfireMGPanel(mounted);
            gridBagLayout.setConstraints(rapidfireMGPanel, gridBagConstraints);
            this.panRapidfireMGs.add(rapidfireMGPanel);
            this.m_vMGs.addElement(rapidfireMGPanel);
        }
    }

    private void setupMines() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panMines.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        for (Mounted mounted : this.entity.getMisc()) {
            if (!mounted.getType().hasFlag(524288L)) continue;
            gridBagConstraints.gridy = n++;
            MineChoicePanel mineChoicePanel = new MineChoicePanel(mounted);
            gridBagLayout.setConstraints(mineChoicePanel, gridBagConstraints);
            this.panMines.add(mineChoicePanel);
            this.m_vMines.addElement(mineChoicePanel);
        }
    }

    private void setupBombs() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panBombs.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Aero aero = (Aero)this.entity;
        this.m_bombs = new BombChoicePanel(aero.getBombChoices(), aero.getMaxBombPoints());
        gridBagLayout.setConstraints(this.m_bombs, gridBagConstraints);
        this.panBombs.add(this.m_bombs);
    }

    private void setupSantaAnna() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panSantaAnna.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        for (Mounted mounted : this.entity.getAmmo()) {
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (!this.clientgui.getClient().game.getOptions().booleanOption("at2_nukes") || ammoType.getAmmoType() != 57 && (ammoType.getAmmoType() != 61 || !ammoType.hasFlag(128L))) continue;
            gridBagConstraints.gridy = n++;
            SantaAnnaChoicePanel santaAnnaChoicePanel = new SantaAnnaChoicePanel(mounted);
            gridBagLayout.setConstraints(santaAnnaChoicePanel, gridBagConstraints);
            this.panSantaAnna.add(santaAnnaChoicePanel);
            this.m_vSantaAnna.addElement(santaAnnaChoicePanel);
        }
    }

    private void setupMunitions() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panMunitions.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        for (Mounted mounted : this.entity.getAmmo()) {
            AmmoType ammoType = (AmmoType)mounted.getType();
            Vector<AmmoType> vector = new Vector<AmmoType>();
            Vector<Object> vector2 = new Vector();
            vector2 = AmmoType.getMunitionsFor(ammoType.getAmmoType());
            if (vector2 == null) continue;
            int n2 = vector2.size();
            for (int i = 0; i < n2; ++i) {
                AmmoType ammoType2 = (AmmoType)vector2.elementAt(i);
                boolean bl = TechConstants.isLegal(this.entity.getTechLevel(), ammoType2.getTechLevel());
                if (!bl && this.entity.getTechLevel() == 1 && ammoType2.getTechLevel() == 0) {
                    bl = true;
                }
                if (!this.clientgui.getClient().game.getOptions().booleanOption("is_eq_limits") && this.entity.getTechLevel() == 0 && ammoType2.getTechLevel() == 1) {
                    bl = true;
                }
                if (this.clientgui.getClient().game.getOptions().booleanOption("allow_level_3_ammo")) {
                    if (!this.clientgui.getClient().game.getOptions().booleanOption("is_eq_limits")) {
                        if (this.entity.getTechLevel() == 2 && ammoType2.getTechLevel() == 6) {
                            bl = true;
                        }
                        if ((this.entity.getTechLevel() == 0 || this.entity.getTechLevel() == 1) && ammoType2.getTechLevel() == 5) {
                            bl = true;
                        }
                    }
                } else if (ammoType2.getTechLevel() == 5 || ammoType2.getTechLevel() == 6) {
                    bl = false;
                }
                if (this.entity.isMixedTech()) {
                    bl = true;
                }
                long l = ammoType2.getMunitionType();
                if (!this.clientgui.getClient().game.getOptions().booleanOption("clan_ignore_eq_limits") && this.entity.isClan() && ((l &= 0xFFFFFFFFFFFEFFFFL) == 262144L || l == 0x100000L || l == 131072L || l == 256L || l == 0x400000L || l == 0x800000L || l == 0x1000000L || l == 0x2000000L || l == 0x4000000000L || l == 0x8000000000L || l == 512L || l == 1024L)) {
                    bl = false;
                }
                if (!this.clientgui.getClient().game.getOptions().booleanOption("minefields") && AmmoType.canDeliverMinefield(ammoType2) || ammoType2.hasFlag(4L) && !(this.entity instanceof Protomech) || this.entity instanceof Protomech && ammoType2.hasFlag(1L) && !ammoType2.hasFlag(4L) || !bl || ammoType2.getRackSize() != ammoType.getRackSize() || ammoType2.hasFlag(2L) != ammoType.hasFlag(2L) || ammoType2.hasFlag(16L) != ammoType.hasFlag(16L) || ammoType2.getTonnage(this.entity) != ammoType.getTonnage(this.entity)) continue;
                vector.addElement(ammoType2);
            }
            if (vector.size() < 2 && !this.client.game.getOptions().booleanOption("lobby_ammo_dump") && !this.client.game.getOptions().booleanOption("maxtech_hotload")) continue;
            gridBagConstraints.gridy = n++;
            MunitionChoicePanel munitionChoicePanel = this.entity instanceof Protomech ? new ProtomechMunitionChoicePanel(mounted, vector) : new MunitionChoicePanel(mounted, vector);
            gridBagLayout.setConstraints(munitionChoicePanel, gridBagConstraints);
            this.panMunitions.add(munitionChoicePanel);
            this.m_vMunitions.addElement(munitionChoicePanel);
        }
    }

    public void disableMunitionEditing() {
        for (int i = 0; i < this.m_vMunitions.size(); ++i) {
            this.m_vMunitions.elementAt(i).setEnabled(false);
        }
    }

    public void disableMGSetting() {
        for (int i = 0; i < this.m_vMGs.size(); ++i) {
            this.m_vMGs.elementAt(i).setEnabled(false);
        }
    }

    public void disableMineSetting() {
        for (int i = 0; i < this.m_vMines.size(); ++i) {
            this.m_vMines.elementAt(i).setEnabled(false);
        }
    }

    public void setOptions() {
        Enumeration<DialogOptionComponent> enumeration = this.optionComps.elements();
        while (enumeration.hasMoreElements()) {
            DialogOptionComponent dialogOptionComponent = enumeration.nextElement();
            IOption iOption = dialogOptionComponent.getOption();
            if (dialogOptionComponent.getValue() == Messages.getString("CustomMechDialog.None")) {
                this.entity.getCrew().getOptions().getOption(iOption.getName()).setValue("None");
                continue;
            }
            this.entity.getCrew().getOptions().getOption(iOption.getName()).setValue(dialogOptionComponent.getValue());
        }
    }

    public void resetOptions() {
        Enumeration<DialogOptionComponent> enumeration = this.optionComps.elements();
        while (enumeration.hasMoreElements()) {
            DialogOptionComponent dialogOptionComponent = enumeration.nextElement();
            IOption iOption = dialogOptionComponent.getOption();
            iOption.setValue(false);
            this.entity.getCrew().getOptions().getOption(iOption.getName()).setValue(dialogOptionComponent.getValue());
        }
    }

    public void refreshOptions() {
        this.panOptions.removeAll();
        this.optionComps = new Vector();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panOptions.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        Enumeration<IOptionGroup> enumeration = this.options.getGroups();
        while (enumeration.hasMoreElements()) {
            IOptionGroup iOptionGroup = enumeration.nextElement();
            if (iOptionGroup.getKey().equalsIgnoreCase("lvl3Advantages") && !this.clientgui.getClient().game.getOptions().booleanOption("pilot_advantages") || iOptionGroup.getKey().equalsIgnoreCase("MDAdvantages") && !this.clientgui.getClient().game.getOptions().booleanOption("manei_domini")) continue;
            this.addGroup(iOptionGroup, gridBagLayout, gridBagConstraints);
            Enumeration<IOption> enumeration2 = iOptionGroup.getOptions();
            while (enumeration2.hasMoreElements()) {
                IOption iOption = enumeration2.nextElement();
                if (!(!(this.entity instanceof Infantry) && !(this.entity instanceof BattleArmor) && !(this.entity instanceof GunEmplacement) || !iOption.getName().equals("vdni") && !iOption.getName().equals("bvdni"))) continue;
                this.addOption(iOption, gridBagLayout, gridBagConstraints, this.editable);
            }
        }
        this.validate();
    }

    private void addGroup(IOptionGroup iOptionGroup, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        Label label = new Label(iOptionGroup.getDisplayableName());
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.panOptions.add(label);
    }

    private void addOption(IOption iOption, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, boolean bl) {
        DialogOptionComponent dialogOptionComponent = new DialogOptionComponent(this, iOption, bl);
        if (iOption.getName().equals("weapon_specialist")) {
            dialogOptionComponent.addValue(Messages.getString("CustomMechDialog.None"));
            TreeSet<String> treeSet = new TreeSet<String>();
            for (int i = 0; i < this.entity.getWeaponList().size(); ++i) {
                Mounted object = this.entity.getWeaponList().get(i);
                treeSet.add(object.getName());
            }
            for (String string : treeSet) {
                dialogOptionComponent.addValue(string);
            }
            dialogOptionComponent.setSelected(iOption.stringValue());
        }
        gridBagLayout.setConstraints(dialogOptionComponent, gridBagConstraints);
        this.panOptions.add(dialogOptionComponent);
        this.optionComps.addElement(dialogOptionComponent);
    }

    @Override
    public void showDescFor(IOption iOption) {
        this.texDesc.setText(iOption.getDescription());
    }

    @Override
    public void optionClicked(DialogOptionComponent dialogOptionComponent, IOption iOption, boolean bl) {
    }

    public boolean isOkay() {
        return this.okay;
    }

    private void refreshDeployment() {
        this.choDeployment.removeAll();
        this.choDeployment.add(Messages.getString("CustomMechDialog.StartOfGame"));
        if (this.entity.getDeployRound() < 1) {
            this.choDeployment.select(0);
        }
        for (int i = 1; i <= 15; ++i) {
            this.choDeployment.add(Messages.getString("CustomMechDialog.AfterRound") + i);
            if (this.entity.getDeployRound() != i) continue;
            this.choDeployment.select(i);
        }
    }

    private void refreshC3() {
        int n;
        this.choC3.removeAll();
        int n2 = 0;
        this.entityCorrespondance = new int[this.client.game.getNoOfEntities() + 2];
        if (this.entity.hasC3i()) {
            this.choC3.add(Messages.getString("CustomMechDialog.CreateNewNetwork"));
            if (this.entity.getC3Master() == null) {
                this.choC3.select(n2);
            }
            this.entityCorrespondance[n2++] = this.entity.getId();
        } else if (this.entity.hasC3MM()) {
            n = this.entity.calculateFreeC3MNodes();
            int n3 = this.entity.calculateFreeC3Nodes();
            this.choC3.add(Messages.getString("CustomMechDialog.setCompanyMaster", new Object[]{new Integer(n), new Integer(n3)}));
            if (this.entity.C3MasterIs(this.entity)) {
                this.choC3.select(n2);
            }
            this.entityCorrespondance[n2++] = this.entity.getId();
            this.choC3.add(Messages.getString("CustomMechDialog.setIndependentMaster", new Object[]{new Integer(n3)}));
            if (this.entity.getC3Master() == null) {
                this.choC3.select(n2);
            }
            this.entityCorrespondance[n2++] = -1;
        } else if (this.entity.hasC3M()) {
            n = this.entity.calculateFreeC3Nodes();
            this.choC3.add(Messages.getString("CustomMechDialog.setCompanyMaster1", new Object[]{new Integer(n)}));
            if (this.entity.C3MasterIs(this.entity)) {
                this.choC3.select(n2);
            }
            this.entityCorrespondance[n2++] = this.entity.getId();
            this.choC3.add(Messages.getString("CustomMechDialog.setIndependentMaster", new Object[]{new Integer(n)}));
            if (this.entity.getC3Master() == null) {
                this.choC3.select(n2);
            }
            this.entityCorrespondance[n2++] = -1;
        }
        Enumeration<Entity> enumeration = this.client.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity;
            Entity entity2 = enumeration.nextElement();
            if (this.entity.isEnemyOf(entity2) || this.entity.equals(entity2) || this.entity.hasC3i() != entity2.hasC3i() || (entity = entity2.getC3Master()) != null && entity.getC3Master() != entity) continue;
            int n4 = entity2.calculateFreeC3Nodes();
            if (entity2.hasC3MM() && this.entity.hasC3M() && entity2.C3MasterIs(entity2)) {
                n4 = entity2.calculateFreeC3MNodes();
            }
            if (this.entity.C3MasterIs(entity2) && !this.entity.equals(entity2)) {
                ++n4;
            }
            if (this.entity.hasC3i() && (this.entity.onSameC3NetworkAs(entity2) || this.entity.equals(entity2))) {
                ++n4;
            }
            if (n4 == 0) continue;
            if (entity2.hasC3i()) {
                if (this.entity.onSameC3NetworkAs(entity2)) {
                    this.choC3.add(Messages.getString("CustomMechDialog.join1", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4 - 1)}));
                    this.choC3.select(n2);
                } else {
                    this.choC3.add(Messages.getString("CustomMechDialog.join2", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4)}));
                }
                this.entityCorrespondance[n2++] = entity2.getId();
                continue;
            }
            if (entity2.C3MasterIs(entity2) && entity2.hasC3MM()) {
                this.choC3.add(Messages.getString("CustomMechDialog.connect2", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4)}));
                this.entityCorrespondance[n2] = entity2.getId();
                if (this.entity.C3MasterIs(entity2)) {
                    this.choC3.select(n2);
                }
                ++n2;
                continue;
            }
            if (entity2.C3MasterIs(entity2) && !this.entity.hasC3M()) continue;
            if (this.entity.C3MasterIs(entity2)) {
                this.choC3.add(Messages.getString("CustomMechDialog.connect1", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4 - 1)}));
                this.choC3.select(n2);
                this.entityCorrespondance[n2++] = entity2.getId();
                continue;
            }
            this.choC3.add(Messages.getString("CustomMechDialog.connect2", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4)}));
            this.entityCorrespondance[n2++] = entity2.getId();
        }
    }

    private void refreshUnitNum(Enumeration<Entity> enumeration) {
        this.choUnitNum.removeAll();
        this.entityUnitNum.removeAllElements();
        this.choUnitNum.add(Messages.getString("CustomMechDialog.doNotSwapUnits"));
        this.entityUnitNum.addElement(this.entity);
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            this.entityUnitNum.addElement(entity);
            StringBuffer stringBuffer = new StringBuffer(entity.getDisplayName());
            stringBuffer.append(" (").append((char)(entity.getUnitNumber() + PreferenceManager.getClientPreferences().getUnitStartChar())).append('-').append(entity.getId()).append(')');
            this.choUnitNum.add(stringBuffer.toString());
        }
        this.choUnitNum.select(0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (actionEvent.getSource() == this.butOffBoardDistance) {
            int n = 323;
            for (Mounted mounted : this.entity.getWeaponList()) {
                int n2;
                EquipmentType equipmentType = mounted.getType();
                WeaponType weaponType = (WeaponType)equipmentType;
                if (!weaponType.hasFlag(32768L) || (n2 = (weaponType.getLongRange() - 1) * 17) >= n) continue;
                n = n2;
            }
            Slider slider = new Slider(this.clientgui.frame, Messages.getString("CustomMechDialog.offboardDistanceTitle"), Messages.getString("CustomMechDialog.offboardDistanceQuestion"), this.entity.getOffBoardDistance(), 17, n);
            if (!slider.showDialog()) {
                return;
            }
            this.distance = slider.getValue();
            this.butOffBoardDistance.setLabel(Integer.toString(this.distance));
            return;
        }
        if (actionEvent.getSource() != this.butCancel) {
            int n;
            Entity entity;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            object = this.fldName.getText();
            int n8 = 0;
            int n9 = 0;
            boolean bl = this.chAutoEject.getState();
            try {
                n7 = Integer.parseInt(this.fldGunnery.getText());
                n6 = Integer.parseInt(this.fldGunneryL.getText());
                n5 = Integer.parseInt(this.fldGunneryM.getText());
                n4 = Integer.parseInt(this.fldGunneryB.getText());
                n3 = Integer.parseInt(this.fldPiloting.getText());
                if (this.entity instanceof Aero) {
                    n8 = Integer.parseInt(this.fldStartVelocity.getText());
                    n9 = Integer.parseInt(this.fldStartElevation.getText());
                }
            }
            catch (NumberFormatException numberFormatException) {
                new AlertDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.NumberFormatError"), Messages.getString("CustomMechDialog.EnterValidSkills")).setVisible(true);
                return;
            }
            if (n7 < 0 || n7 > 8 || n3 < 0 || n3 > 8 || n6 < 0 || n6 > 8 || n5 < 0 || n5 > 8 || n4 < 0 || n4 > 8) {
                new AlertDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.NumberFormatError"), Messages.getString("CustomMechDialog.EnterSkillsBetween0_8")).setVisible(true);
                return;
            }
            if (this.chOffBoard.getState()) {
                int n10;
                try {
                    n10 = this.distance;
                }
                catch (NumberFormatException numberFormatException) {
                    new AlertDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.NumberFormatError"), Messages.getString("CustomMechDialog.EnterValidSkills")).setVisible(true);
                    return;
                }
                if (n10 < 17) {
                    new AlertDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.NumberFormatError"), Messages.getString("CustomMechDialog.OffboardDistance")).setVisible(true);
                    return;
                }
                this.entity.setOffBoard(n10, this.choOffBoardDirection.getSelectedIndex());
            } else {
                this.entity.setOffBoard(0, -1);
            }
            if (this.client.game.getOptions().booleanOption("rpg_gunnery")) {
                this.entity.setCrew(new Pilot((String)object, n6, n5, n4, n3));
            } else {
                this.entity.setCrew(new Pilot((String)object, n7, n3));
            }
            if (this.entity instanceof Mech) {
                entity = (Mech)this.entity;
                ((Mech)entity).setAutoEject(!bl);
            }
            if (this.entity instanceof Aero) {
                entity = (Aero)this.entity;
                ((Aero)entity).setCurrentVelocity(n8);
                ((Aero)entity).setNextVelocity(n8);
                entity.setElevation(n9);
            }
            if (this.entity.hasC3() && this.choC3.getSelectedIndex() > -1) {
                int n11;
                entity = this.client.getEntity(this.entityCorrespondance[this.choC3.getSelectedIndex()]);
                n = this.client.game.getC3SubNetworkMembers(this.entity).size();
                if (n + (n11 = this.client.game.getC3NetworkMembers(entity).size()) <= 12) {
                    this.entity.setC3Master(entity);
                } else {
                    String string = Messages.getString("CustomMechDialog.NetworkTooBig.message", new Object[]{this.entity.getShortName(), entity.getShortName(), new Integer(n), new Integer(n11), new Integer(12)});
                    this.clientgui.doAlertDialog(Messages.getString("CustomMechDialog.NetworkTooBig.title"), string);
                    this.refreshC3();
                }
            } else if (this.entity.hasC3i() && this.choC3.getSelectedIndex() > -1) {
                this.entity.setC3NetId(this.client.getEntity(this.entityCorrespondance[this.choC3.getSelectedIndex()]));
            }
            if (!this.entity.hasTargComp() && this.clientgui.getClient().game.getOptions().booleanOption("allow_level_3_targsys")) {
                int n12 = 0;
                if (this.choTargSys.getSelectedItem() != null) {
                    n12 = MiscType.getTargetSysType(this.choTargSys.getSelectedItem());
                }
                if (n12 >= 0) {
                    this.entity.setTargSysType(n12);
                } else {
                    System.err.println("Illegal targeting system index: " + n12);
                    this.entity.setTargSysType(0);
                }
            }
            if (!this.entityUnitNum.isEmpty() && this.choUnitNum.getSelectedIndex() > 0) {
                Entity entity2 = this.entityUnitNum.elementAt(this.choUnitNum.getSelectedIndex());
                n = this.entity.getUnitNumber();
                this.entity.setUnitNumber(entity2.getUnitNumber());
                entity2.setUnitNumber((char)n);
                this.client.sendUpdateEntity(entity2);
            }
            this.entity.setDeployRound(this.choDeployment.getSelectedIndex());
            Enumeration<Panel> enumeration = this.m_vMunitions.elements();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().applyChoice();
            }
            enumeration = this.m_vMGs.elements();
            while (enumeration.hasMoreElements()) {
                ((RapidfireMGPanel)enumeration.nextElement()).applyChoice();
            }
            enumeration = this.m_vMines.elements();
            while (enumeration.hasMoreElements()) {
                ((MineChoicePanel)enumeration.nextElement()).applyChoice();
            }
            enumeration = this.m_vSantaAnna.elements();
            while (enumeration.hasMoreElements()) {
                ((SantaAnnaChoicePanel)enumeration.nextElement()).applyChoice();
            }
            if (null != this.m_bombs) {
                this.m_bombs.applyChoice();
            }
            this.entity.setSpotlight(this.chSearchlight.getState());
            this.entity.setSpotlightState(this.chSearchlight.getState());
            this.entity.setCommander(this.chCommander.getState());
            this.setOptions();
            this.okay = true;
            this.clientgui.chatlounge.refreshEntities();
        }
        this.setVisible(false);
        object = null;
        if (actionEvent.getSource() == this.butPrev) {
            object = this.getNextEntity(false);
        } else if (actionEvent.getSource() == this.butNext) {
            object = this.getNextEntity(true);
        }
        if (object != null) {
            this.clientgui.chatlounge.customizeMech((Entity)object);
        }
    }

    private Entity getNextEntity(boolean bl) {
        IGame iGame = this.client.game;
        boolean bl2 = iGame.getOptions().booleanOption("blind_drop");
        boolean bl3 = iGame.getOptions().booleanOption("real_blind_drop");
        Player player = this.client.getLocalPlayer();
        Entity entity = null;
        entity = bl ? iGame.getNextEntityFromList(this.entity) : iGame.getPreviousEntityFromList(this.entity);
        while (entity != this.entity && entity != null) {
            if (entity.getOwner().equals(player) || !bl2 && !bl3) {
                return entity;
            }
            if (bl) {
                entity = iGame.getNextEntityFromList(entity);
                continue;
            }
            entity = iGame.getPreviousEntityFromList(entity);
        }
        return null;
    }

    class RapidfireMGPanel
    extends Panel {
        private static final long serialVersionUID = -5884253129817172942L;
        private Mounted m_mounted;
        protected Checkbox chRapid = new Checkbox();

        public RapidfireMGPanel(Mounted mounted) {
            this.m_mounted = mounted;
            int n = mounted.getLocation();
            String string = Messages.getString("CustomMechDialog.switchToRapidFire", new Object[]{CustomMechDialog.this.entity.getLocationAbbr(n)});
            Label label = new Label(string);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.add(label);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.chRapid, gridBagConstraints);
            this.chRapid.setState(mounted.isRapidfire());
            this.add(this.chRapid);
        }

        public void applyChoice() {
            boolean bl = this.chRapid.getState();
            this.m_mounted.setRapidfire(bl);
        }

        public void setEnabled(boolean bl) {
            this.chRapid.setEnabled(bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProtomechMunitionChoicePanel
    extends MunitionChoicePanel {
        private static final long serialVersionUID = 4915594909134005147L;
        private final float m_origShotsLeft;
        private final AmmoType m_origAmmo;

        public ProtomechMunitionChoicePanel(Mounted mounted, Vector<AmmoType> vector) {
            super(mounted, vector);
            this.m_origAmmo = (AmmoType)mounted.getType();
            this.m_origShotsLeft = mounted.getShotsLeft();
        }

        @Override
        public void applyChoice() {
            super.applyChoice();
            this.setShotsLeft(Math.round((float)this.getShotsLeft() * this.m_origShotsLeft / (float)this.m_origAmmo.getShots()));
            if (this.chDump.getState()) {
                this.setShotsLeft(0);
            }
        }
    }

    class BombChoicePanel
    extends Panel
    implements ItemListener {
        private Choice b_choice_he;
        private Choice b_choice_cl;
        private Choice b_choice_lg;
        private Choice b_choice_inf;
        private Choice b_choice_mine;
        private Choice b_choice_tag;
        private Choice b_choice_arrow;
        private Choice b_choice_rl;
        private Choice b_choice_alamo;
        private int maxPoints = 0;

        public BombChoicePanel(int[] nArray, int n) {
            int n2;
            int n3;
            this.maxPoints = n;
            this.b_choice_he = new Choice();
            this.b_choice_cl = new Choice();
            this.b_choice_lg = new Choice();
            this.b_choice_inf = new Choice();
            this.b_choice_mine = new Choice();
            this.b_choice_tag = new Choice();
            this.b_choice_arrow = new Choice();
            this.b_choice_rl = new Choice();
            this.b_choice_alamo = new Choice();
            this.b_choice_he.addItemListener(this);
            this.b_choice_cl.addItemListener(this);
            this.b_choice_lg.addItemListener(this);
            this.b_choice_inf.addItemListener(this);
            this.b_choice_mine.addItemListener(this);
            this.b_choice_tag.addItemListener(this);
            this.b_choice_arrow.addItemListener(this);
            this.b_choice_rl.addItemListener(this);
            this.b_choice_alamo.addItemListener(this);
            int n4 = 0;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n4 += nArray[n3] * Aero.bombCosts[n3];
            }
            n3 = n - n4;
            for (n2 = 0; n2 <= Math.max(n3, nArray[0]); ++n2) {
                this.b_choice_he.add(Integer.toString(n2));
            }
            for (n2 = 0; n2 <= Math.max(n3, nArray[1]); ++n2) {
                this.b_choice_cl.add(Integer.toString(n2));
            }
            for (n2 = 0; n2 <= Math.max(n3, nArray[2]); ++n2) {
                this.b_choice_lg.add(Integer.toString(n2));
            }
            for (n2 = 0; n2 <= Math.max(n3, nArray[3]); ++n2) {
                this.b_choice_inf.add(Integer.toString(n2));
            }
            for (n2 = 0; n2 <= Math.max(n3, nArray[4]); ++n2) {
                this.b_choice_mine.add(Integer.toString(n2));
            }
            for (n2 = 0; n2 <= Math.max(n3, nArray[5]); ++n2) {
                this.b_choice_tag.add(Integer.toString(n2));
            }
            for (n2 = 0; n2 <= Math.max(n3, nArray[7]); ++n2) {
                this.b_choice_rl.add(Integer.toString(n2));
            }
            for (n2 = 0; n2 <= Math.max(Math.round(n3 / 5), nArray[6]); ++n2) {
                this.b_choice_arrow.add(Integer.toString(n2));
            }
            for (n2 = 0; n2 <= Math.max(Math.round(n3 / 10), nArray[8]); ++n2) {
                this.b_choice_alamo.add(Integer.toString(n2));
            }
            this.b_choice_he.select(nArray[0]);
            this.b_choice_cl.select(nArray[1]);
            this.b_choice_lg.select(nArray[2]);
            this.b_choice_inf.select(nArray[3]);
            this.b_choice_mine.select(nArray[4]);
            this.b_choice_tag.select(nArray[5]);
            this.b_choice_arrow.select(nArray[6]);
            this.b_choice_rl.select(nArray[7]);
            this.b_choice_alamo.select(nArray[8]);
            String string = Messages.getString("CustomMechDialog.labBombHE");
            Label label = new Label(string);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.add(label);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.b_choice_he, gridBagConstraints);
            this.add(this.b_choice_he);
            String string2 = Messages.getString("CustomMechDialog.labBombCL");
            Label label2 = new Label(string2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(label2, gridBagConstraints);
            this.add(label2);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.b_choice_cl, gridBagConstraints);
            this.add(this.b_choice_cl);
            String string3 = Messages.getString("CustomMechDialog.labBombLG");
            Label label3 = new Label(string3);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(label3, gridBagConstraints);
            this.add(label3);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.b_choice_lg, gridBagConstraints);
            this.add(this.b_choice_lg);
            String string4 = Messages.getString("CustomMechDialog.labBombInf");
            Label label4 = new Label(string4);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(label4, gridBagConstraints);
            this.add(label4);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.b_choice_inf, gridBagConstraints);
            this.add(this.b_choice_inf);
            String string5 = Messages.getString("CustomMechDialog.labBombMine");
            Label label5 = new Label(string5);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(label5, gridBagConstraints);
            this.add(label5);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.b_choice_mine, gridBagConstraints);
            this.add(this.b_choice_mine);
            String string6 = Messages.getString("CustomMechDialog.labBombTAG");
            Label label6 = new Label(string6);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(label6, gridBagConstraints);
            this.add(label6);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.b_choice_tag, gridBagConstraints);
            this.add(this.b_choice_tag);
            String string7 = Messages.getString("CustomMechDialog.labBombArrow");
            Label label7 = new Label(string7);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(label7, gridBagConstraints);
            this.add(label7);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.b_choice_arrow, gridBagConstraints);
            this.add(this.b_choice_arrow);
            String string8 = Messages.getString("CustomMechDialog.labBombRL");
            Label label8 = new Label(string8);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(label8, gridBagConstraints);
            this.add(label8);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.b_choice_rl, gridBagConstraints);
            this.add(this.b_choice_rl);
            if (((CustomMechDialog)CustomMechDialog.this).clientgui.getClient().game.getOptions().booleanOption("at2_nukes")) {
                String string9 = Messages.getString("CustomMechDialog.labBombAlamo");
                Label label9 = new Label(string9);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.anchor = 13;
                gridBagLayout.setConstraints(label9, gridBagConstraints);
                this.add(label9);
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(this.b_choice_alamo, gridBagConstraints);
                this.add(this.b_choice_alamo);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n;
            int n2 = this.b_choice_he.getSelectedIndex();
            int n3 = this.b_choice_cl.getSelectedIndex();
            int n4 = this.b_choice_lg.getSelectedIndex();
            int n5 = this.b_choice_inf.getSelectedIndex();
            int n6 = this.b_choice_mine.getSelectedIndex();
            int n7 = this.b_choice_tag.getSelectedIndex();
            int n8 = this.b_choice_arrow.getSelectedIndex();
            int n9 = this.b_choice_rl.getSelectedIndex();
            int n10 = this.b_choice_alamo.getSelectedIndex();
            int n11 = n2 + n3 + n4 + n5 + n6 + n7 + 5 * n8 + n9 + 10 * n10;
            int n12 = this.maxPoints - n11;
            this.b_choice_he.removeAll();
            this.b_choice_cl.removeAll();
            this.b_choice_lg.removeAll();
            this.b_choice_inf.removeAll();
            this.b_choice_mine.removeAll();
            this.b_choice_tag.removeAll();
            this.b_choice_arrow.removeAll();
            this.b_choice_rl.removeAll();
            this.b_choice_alamo.removeAll();
            for (n = 0; n <= Math.max(n12, n2); ++n) {
                this.b_choice_he.add(Integer.toString(n));
            }
            for (n = 0; n <= Math.max(n12, n3); ++n) {
                this.b_choice_cl.add(Integer.toString(n));
            }
            for (n = 0; n <= Math.max(n12, n4); ++n) {
                this.b_choice_lg.add(Integer.toString(n));
            }
            for (n = 0; n <= Math.max(n12, n5); ++n) {
                this.b_choice_inf.add(Integer.toString(n));
            }
            for (n = 0; n <= Math.max(n12, n6); ++n) {
                this.b_choice_mine.add(Integer.toString(n));
            }
            for (n = 0; n <= Math.max(n12, n7); ++n) {
                this.b_choice_tag.add(Integer.toString(n));
            }
            for (n = 0; n <= Math.max(n12, n9); ++n) {
                this.b_choice_rl.add(Integer.toString(n));
            }
            for (n = 0; n <= Math.max(Math.round(n12 / 5), n8); ++n) {
                this.b_choice_arrow.add(Integer.toString(n));
            }
            for (n = 0; n <= Math.max(Math.round(n12 / 10), n10); ++n) {
                this.b_choice_alamo.add(Integer.toString(n));
            }
            this.b_choice_he.select(n2);
            this.b_choice_cl.select(n3);
            this.b_choice_lg.select(n4);
            this.b_choice_inf.select(n5);
            this.b_choice_mine.select(n6);
            this.b_choice_tag.select(n7);
            this.b_choice_arrow.select(n8);
            this.b_choice_rl.select(n9);
            this.b_choice_alamo.select(n10);
        }

        public void applyChoice() {
            int[] nArray = new int[]{this.b_choice_he.getSelectedIndex(), this.b_choice_cl.getSelectedIndex(), this.b_choice_lg.getSelectedIndex(), this.b_choice_inf.getSelectedIndex(), this.b_choice_mine.getSelectedIndex(), this.b_choice_tag.getSelectedIndex(), this.b_choice_arrow.getSelectedIndex(), this.b_choice_rl.getSelectedIndex(), this.b_choice_alamo.getSelectedIndex()};
            ((Aero)CustomMechDialog.this.entity).setBombChoices(nArray);
        }

        public void setEnabled(boolean bl) {
            this.b_choice_he.setEnabled(bl);
            this.b_choice_cl.setEnabled(bl);
            this.b_choice_lg.setEnabled(bl);
            this.b_choice_inf.setEnabled(bl);
            this.b_choice_mine.setEnabled(bl);
            this.b_choice_tag.setEnabled(bl);
            this.b_choice_arrow.setEnabled(bl);
            this.b_choice_rl.setEnabled(bl);
            this.b_choice_alamo.setEnabled(bl);
        }
    }

    class SantaAnnaChoicePanel
    extends Panel {
        private Choice m_choice;
        private Mounted m_mounted;

        public SantaAnnaChoicePanel(Mounted mounted) {
            int n;
            this.m_mounted = mounted;
            this.m_choice = new Choice();
            for (n = 0; n <= this.m_mounted.getShotsLeft(); ++n) {
                this.m_choice.add(Integer.toString(n));
            }
            n = mounted.getLocation();
            String string = "Nuclear warheads for " + this.m_mounted.getName() + " (" + CustomMechDialog.this.entity.getLocationAbbr(n) + "):";
            Label label = new Label(string);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.add(label);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.m_choice, gridBagConstraints);
            this.m_choice.select(0);
            this.add(this.m_choice);
        }

        public void applyChoice() {
        }

        public void setEnabled(boolean bl) {
            this.m_choice.setEnabled(bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MunitionChoicePanel
    extends Panel {
        private static final long serialVersionUID = 5264839073432470450L;
        private Vector<AmmoType> m_vTypes;
        private Choice m_choice;
        private Mounted m_mounted;
        protected Label labDump = new Label(Messages.getString("CustomMechDialog.labDump"));
        protected Checkbox chDump = new Checkbox();
        protected Label labHotLoad = new Label(Messages.getString("CustomMechDialog.switchToHotLoading"));
        protected Checkbox chHotLoad = new Checkbox();

        public MunitionChoicePanel(Mounted mounted, Vector<AmmoType> vector) {
            Object object;
            this.m_vTypes = vector;
            this.m_mounted = mounted;
            AmmoType ammoType = (AmmoType)mounted.getType();
            this.m_choice = new Choice();
            Enumeration<AmmoType> enumeration = this.m_vTypes.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                this.m_choice.add(((EquipmentType)object).getName());
                if (((EquipmentType)object).getInternalName() == ammoType.getInternalName()) {
                    this.m_choice.select(n);
                }
                ++n;
            }
            if (mounted.getLocation() == -1) {
                object = mounted.getLinkedBy();
                n = ((Mounted)object).getLocation();
            } else {
                n = mounted.getLocation();
            }
            object = "(" + CustomMechDialog.this.entity.getLocationAbbr(n) + ")";
            Label label = new Label((String)object);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.add(label);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.m_choice, gridBagConstraints);
            this.add(this.m_choice);
            if (((CustomMechDialog)CustomMechDialog.this).clientgui.getClient().game.getOptions().booleanOption("lobby_ammo_dump")) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 13;
                gridBagLayout.setConstraints(this.labDump, gridBagConstraints);
                this.add(this.labDump);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(this.chDump, gridBagConstraints);
                this.add(this.chDump);
                if (((CustomMechDialog)CustomMechDialog.this).clientgui.getClient().game.getOptions().booleanOption("maxtech_hotload") && ammoType.hasFlag(8L)) {
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = 2;
                    gridBagConstraints.anchor = 13;
                    gridBagLayout.setConstraints(this.labHotLoad, gridBagConstraints);
                    this.add(this.labHotLoad);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.gridy = 2;
                    gridBagConstraints.anchor = 17;
                    gridBagLayout.setConstraints(this.chHotLoad, gridBagConstraints);
                    this.add(this.chHotLoad);
                }
            } else if (((CustomMechDialog)CustomMechDialog.this).clientgui.getClient().game.getOptions().booleanOption("maxtech_hotload") && ammoType.hasFlag(8L)) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 13;
                gridBagLayout.setConstraints(this.labHotLoad, gridBagConstraints);
                this.add(this.labHotLoad);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(this.chHotLoad, gridBagConstraints);
                this.add(this.chHotLoad);
            }
        }

        public void applyChoice() {
            int n = this.m_choice.getSelectedIndex();
            AmmoType ammoType = this.m_vTypes.elementAt(n);
            this.m_mounted.changeAmmoType(ammoType);
            if (this.chDump.getState()) {
                this.m_mounted.setShotsLeft(0);
            }
            if (((CustomMechDialog)CustomMechDialog.this).clientgui.getClient().game.getOptions().booleanOption("maxtech_hotload") && this.chHotLoad.getState() != this.m_mounted.isHotLoaded()) {
                this.m_mounted.setHotLoad(this.chHotLoad.getState());
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            this.m_choice.setEnabled(bl);
        }

        int getShotsLeft() {
            return this.m_mounted.getShotsLeft();
        }

        void setShotsLeft(int n) {
            this.m_mounted.setShotsLeft(n);
        }
    }

    class MineChoicePanel
    extends Panel {
        private static final long serialVersionUID = 7164680650764583622L;
        private Choice m_choice;
        private Mounted m_mounted;

        public MineChoicePanel(Mounted mounted) {
            this.m_mounted = mounted;
            this.m_choice = new Choice();
            this.m_choice.add(Messages.getString("CustomMechDialog.Conventional"));
            this.m_choice.add(Messages.getString("CustomMechDialog.Vibrabomb"));
            int n = mounted.getLocation();
            String string = "(" + CustomMechDialog.this.entity.getLocationAbbr(n) + ")";
            Label label = new Label(string);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.add(label);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.m_choice, gridBagConstraints);
            this.m_choice.select(mounted.getMineType());
            this.add(this.m_choice);
        }

        public void applyChoice() {
            this.m_mounted.setMineType(this.m_choice.getSelectedIndex());
        }

        public void setEnabled(boolean bl) {
            this.m_choice.setEnabled(bl);
        }
    }
}

