/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.List;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import megamek.client.Client;
import megamek.client.ui.AWT.ChatLounge;
import megamek.client.ui.AWT.MechView;
import megamek.client.ui.AWT.Messages;
import megamek.common.Entity;

public class MechGroupView
extends Dialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 85778571937208805L;
    List entities = new List(20);
    Button closeButton = new Button(Messages.getString("Close"));
    TextArea ta = new TextArea();
    Client client;
    int[] entityArray;

    MechGroupView(Frame frame, Client client, int[] nArray) {
        super(frame, Messages.getString("MechGroupView.title"));
        this.client = client;
        this.entityArray = nArray;
        boolean bl = this.client.game.getOptions().booleanOption("rpg_gunnery");
        for (int i = 0; i < this.entityArray.length; ++i) {
            Entity entity = this.client.game.getEntity(this.entityArray[i]);
            if (entity == null) continue;
            if (!entity.getOwner().equals(this.client.getLocalPlayer()) && this.client.game.getOptions().booleanOption("blind_drop") && !this.client.game.getOptions().booleanOption("real_blind_drop")) {
                this.entities.add(ChatLounge.formatUnit(entity, true, bl));
                continue;
            }
            if (!entity.getOwner().equals(this.client.getLocalPlayer()) && (this.client.game.getOptions().booleanOption("blind_drop") || this.client.game.getOptions().booleanOption("real_blind_drop"))) continue;
            this.entities.add(ChatLounge.formatUnit(entity, false, bl));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.entities, "West");
        this.add((Component)this.closeButton, "South");
        this.ta.setEditable(false);
        this.ta.setFont(new Font("Monospaced", 0, 12));
        this.add((Component)this.ta, "Center");
        this.entities.addItemListener(this);
        this.closeButton.addActionListener(this);
        this.setSize(550, 600);
        this.setLocation(frame.getLocation().x + frame.getSize().width / 2 - this.getSize().width / 2, frame.getLocation().y + frame.getSize().height / 10);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().setVisible(false);
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.closeButton) {
            this.setVisible(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.entities) {
            int n = this.entities.getSelectedIndex();
            if (n == -1) {
                this.ta.setText("");
                return;
            }
            if (!this.client.game.getEntity(this.entityArray[n]).getOwner().equals(this.client.getLocalPlayer())) {
                this.ta.setText("(enemy unit)");
            } else {
                Entity entity = this.client.game.getEntity(this.entityArray[n]);
                MechView mechView = new MechView(entity, this.client.game.getOptions().booleanOption("show_bay_detail"));
                this.ta.setText(mechView.getMechReadout());
            }
        }
    }
}

