/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import megamek.client.Client;
import megamek.client.bot.TestBot;
import megamek.client.event.BoardViewListener;
import megamek.client.ui.swing.BoardSelectionDialog;
import megamek.client.ui.swing.BoardView1;
import megamek.client.ui.swing.ChatLounge;
import megamek.client.ui.swing.ChatterBox;
import megamek.client.ui.swing.ChoiceDialog;
import megamek.client.ui.swing.CommonAboutDialog;
import megamek.client.ui.swing.CommonHelpDialog;
import megamek.client.ui.swing.CommonMenuBar;
import megamek.client.ui.swing.CommonSettingsDialog;
import megamek.client.ui.swing.ConfirmDialog;
import megamek.client.ui.swing.CustomBattleArmorDialog;
import megamek.client.ui.swing.CustomFighterSquadronDialog;
import megamek.client.ui.swing.CustomInitiativeDialog;
import megamek.client.ui.swing.DeployMinefieldDisplay;
import megamek.client.ui.swing.DeploymentDisplay;
import megamek.client.ui.swing.DoneButtoned;
import megamek.client.ui.swing.FiringDisplay;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.GameOptionsDialog;
import megamek.client.ui.swing.IBoardView;
import megamek.client.ui.swing.LOSDialog;
import megamek.client.ui.swing.MechDisplay;
import megamek.client.ui.swing.MechSelectorDialog;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.MiniMap;
import megamek.client.ui.swing.MiniReportDisplay;
import megamek.client.ui.swing.MovementDisplay;
import megamek.client.ui.swing.PhysicalDisplay;
import megamek.client.ui.swing.PlayerListDialog;
import megamek.client.ui.swing.RandomArmyDialog;
import megamek.client.ui.swing.RandomSkillDialog;
import megamek.client.ui.swing.ReportDisplay;
import megamek.client.ui.swing.Ruler;
import megamek.client.ui.swing.SelectArtyAutoHitHexDisplay;
import megamek.client.ui.swing.StartingPositionDialog;
import megamek.client.ui.swing.TargetingPhaseDisplay;
import megamek.client.ui.swing.UnitLoadingDialog;
import megamek.client.ui.swing.UnitOverview;
import megamek.client.ui.swing.util.PlayerColors;
import megamek.common.BuildingTarget;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EntityListFile;
import megamek.common.HexTarget;
import megamek.common.IGame;
import megamek.common.MechSummaryCache;
import megamek.common.MinefieldTarget;
import megamek.common.Player;
import megamek.common.Targetable;
import megamek.common.event.GameEndEvent;
import megamek.common.event.GameListener;
import megamek.common.event.GameListenerAdapter;
import megamek.common.event.GameMapQueryEvent;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GamePlayerChatEvent;
import megamek.common.event.GamePlayerConnectedEvent;
import megamek.common.event.GamePlayerDisconnectedEvent;
import megamek.common.event.GameReportEvent;
import megamek.common.event.GameSettingsChangeEvent;
import megamek.common.util.Distractable;
import megamek.common.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientGUI
extends JPanel
implements MouseListener,
WindowListener,
ActionListener,
KeyListener {
    private static final long serialVersionUID = 3913466735610109147L;
    public static final String VIEW_MEK_DISPLAY = "viewMekDisplay";
    public static final String VIEW_MINI_MAP = "viewMiniMap";
    public static final String VIEW_LOS_SETTING = "viewLOSSetting";
    public static final String VIEW_UNIT_OVERVIEW = "viewUnitOverview";
    public static final String VIEW_ZOOM_IN = "viewZoomIn";
    public static final String VIEW_ZOOM_OUT = "viewZoomOut";
    public JFrame frame;
    protected CommonMenuBar menuBar;
    private CommonAboutDialog about;
    private CommonHelpDialog help;
    private CommonSettingsDialog setdlg;
    private String helpFileName = "readme.txt";
    ChatterBox cb;
    public BoardView1 bv;
    private JScrollPane scroller;
    public JDialog mechW;
    public MechDisplay mechD;
    public JDialog minimapW;
    public MiniMap minimap;
    private PopupMenu popup = new PopupMenu(Messages.getString("ClientGUI.BoardPopup"));
    private UnitOverview uo;
    private Ruler ruler;
    protected JComponent curPanel;
    public ChatLounge chatlounge;
    BoardSelectionDialog boardSelectionDialog;
    GameOptionsDialog gameOptionsDialog;
    private MechSelectorDialog mechSelectorDialog;
    private CustomBattleArmorDialog customBADialog;
    private CustomFighterSquadronDialog customFSDialog;
    private StartingPositionDialog startingPositionDialog;
    private PlayerListDialog playerListDialog;
    private RandomArmyDialog randomArmyDialog;
    private RandomSkillDialog randomSkillDialog;
    private CustomInitiativeDialog initDialog;
    private JFileChooser dlgLoadList;
    private JFileChooser dlgSaveList;
    Client client;
    private AudioClip bingClip;
    private HashMap<String, String> mainNames = new HashMap();
    private JPanel panMain = new JPanel();
    private CardLayout cardsMain = new CardLayout();
    private HashMap<String, String> secondaryNames = new HashMap();
    private JPanel panSecondary = new JPanel();
    private CardLayout cardsSecondary = new CardLayout();
    HashMap<String, JComponent> phaseComponents = new HashMap();
    private Map<String, Client> bots = new TreeMap<String, Client>(StringUtil.stringComparator());
    private int selectedEntityNum = -1;
    private GameListener gameListener = new GameListenerAdapter(){

        public void gamePlayerDisconnected(GamePlayerDisconnectedEvent gamePlayerDisconnectedEvent) {
            JOptionPane.showMessageDialog(ClientGUI.this.frame, Messages.getString("ClientGUI.Disconnected.message"), Messages.getString("ClientGUI.Disconnected.title"), 0);
            ClientGUI.this.frame.setVisible(false);
            ClientGUI.this.die();
        }

        public void gamePlayerChat(GamePlayerChatEvent gamePlayerChatEvent) {
            ClientGUI.this.bing();
        }

        public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
            if (ClientGUI.this.bv.getLocalPlayer() == null) {
                ClientGUI.this.bv.setLocalPlayer(ClientGUI.this.client.getLocalPlayer());
            }
            ClientGUI.this.switchPanel(ClientGUI.this.client.game.getPhase());
            switch (gamePhaseChangeEvent.getNewPhase()) {
                case PHASE_LOUNGE: {
                    ReportDisplay reportDisplay = (ReportDisplay)ClientGUI.this.phaseComponents.get(String.valueOf((Object)IGame.Phase.PHASE_INITIATIVE_REPORT));
                    if (reportDisplay == null) break;
                    reportDisplay.resetTabs();
                    break;
                }
                case PHASE_DEPLOY_MINEFIELDS: 
                case PHASE_DEPLOYMENT: 
                case PHASE_TARGETING: 
                case PHASE_MOVEMENT: 
                case PHASE_OFFBOARD: 
                case PHASE_FIRING: 
                case PHASE_PHYSICAL: {
                    if (!GUIPreferences.getInstance().getMinimapEnabled() || ClientGUI.this.minimapW.isVisible()) break;
                    ClientGUI.this.setMapVisible(true);
                    break;
                }
                case PHASE_INITIATIVE_REPORT: 
                case PHASE_TARGETING_REPORT: 
                case PHASE_MOVEMENT_REPORT: 
                case PHASE_OFFBOARD_REPORT: 
                case PHASE_FIRING_REPORT: 
                case PHASE_VICTORY: 
                case PHASE_END: {
                    ClientGUI.this.setMapVisible(false);
                    ClientGUI.this.mechW.setVisible(false);
                }
            }
            ClientGUI.this.menuBar.setPhase(ClientGUI.this.client.game.getPhase());
            ClientGUI.this.cb.getComponent().setVisible(true);
            ClientGUI.this.validate();
            ClientGUI.this.doLayout();
            ClientGUI.this.cb.moveToEnd();
        }

        public void gamePlayerConnected(GamePlayerConnectedEvent gamePlayerConnectedEvent) {
            System.err.println("gamePlayerConnected");
            System.err.flush();
            if (ClientGUI.this.curPanel instanceof ReportDisplay) {
                ((ReportDisplay)ClientGUI.this.curPanel).resetReadyButton();
                System.err.println("resetReadyButton");
                System.err.flush();
            }
        }

        public void gameReport(GameReportEvent gameReportEvent) {
            if (gameReportEvent.getReport() == null && ClientGUI.this.curPanel instanceof ReportDisplay) {
                ((ReportDisplay)ClientGUI.this.curPanel).appendReportTab(ClientGUI.this.client.phaseReport);
                ((ReportDisplay)ClientGUI.this.curPanel).resetReadyButton();
                if (ClientGUI.this.client.game.hasTacticalGenius(ClientGUI.this.client.getLocalPlayer()) && !((ReportDisplay)ClientGUI.this.curPanel).hasRerolled()) {
                    ((ReportDisplay)ClientGUI.this.curPanel).resetRerollButton();
                }
            } else if (!(ClientGUI.this.client instanceof TestBot)) {
                ClientGUI.this.doAlertDialog("Movement Report", gameReportEvent.getReport());
            }
        }

        public void gameEnd(GameEndEvent gameEndEvent) {
            ClientGUI.this.bv.clearMovementData();
            Object object = ClientGUI.this.getBots().values().iterator();
            while (object.hasNext()) {
                object.next().die();
            }
            ClientGUI.this.getBots().clear();
            object = ClientGUI.this.client.game.getPlayerEntities(ClientGUI.this.client.getLocalPlayer());
            Enumeration<Entity> enumeration = ClientGUI.this.client.game.getRetreatedEntities();
            while (enumeration.hasMoreElements()) {
                ((ArrayList)object).add(enumeration.nextElement());
            }
            if (!((ArrayList)object).isEmpty() && ClientGUI.this.doYesNoDialog(Messages.getString("ClientGUI.SaveUnitsDialog.title"), Messages.getString("ClientGUI.SaveUnitsDialog.message"))) {
                ClientGUI.this.saveListFile((ArrayList<Entity>)object);
            }
        }

        public void gameSettingsChange(GameSettingsChangeEvent gameSettingsChangeEvent) {
            if (ClientGUI.this.boardSelectionDialog != null && ClientGUI.this.boardSelectionDialog.isVisible()) {
                ClientGUI.this.boardSelectionDialog.update(ClientGUI.this.client.getMapSettings(), true);
            }
            if (ClientGUI.this.gameOptionsDialog != null && ClientGUI.this.gameOptionsDialog.isVisible()) {
                ClientGUI.this.gameOptionsDialog.update(ClientGUI.this.client.game.getOptions());
            }
            if (ClientGUI.this.curPanel instanceof ChatLounge) {
                ChatLounge chatLounge = (ChatLounge)ClientGUI.this.curPanel;
                boolean bl = ClientGUI.this.client.game.getOptions().booleanOption("minefields");
                chatLounge.enableMinefields(bl);
                if (!bl) {
                    ClientGUI.this.client.getLocalPlayer().setNbrMFConventional(0);
                    ClientGUI.this.client.getLocalPlayer().setNbrMFCommand(0);
                    ClientGUI.this.client.getLocalPlayer().setNbrMFVibra(0);
                    ClientGUI.this.client.sendPlayerInfo();
                }
            }
        }

        public void gameMapQuery(GameMapQueryEvent gameMapQueryEvent) {
            if (ClientGUI.this.boardSelectionDialog != null && ClientGUI.this.boardSelectionDialog.isVisible()) {
                ClientGUI.this.boardSelectionDialog.update(gameMapQueryEvent.getSettings(), false);
            }
        }
    };

    public ClientGUI(Client client) {
        super(new BorderLayout());
        this.client = client;
        this.loadSoundClip();
        this.panMain.setLayout(this.cardsMain);
        this.panSecondary.setLayout(this.cardsSecondary);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.panMain, "Center");
        jPanel.add((Component)this.panSecondary, "South");
        this.add((Component)jPanel, "Center");
    }

    public IBoardView getBoardView() {
        return this.bv;
    }

    private void loadSoundClip() {
        if (GUIPreferences.getInstance().getSoundBingFilename() == null) {
            return;
        }
        try {
            File file = new File(GUIPreferences.getInstance().getSoundBingFilename());
            if (!file.exists()) {
                System.err.println("Failed to load audio file: " + GUIPreferences.getInstance().getSoundBingFilename());
                return;
            }
            this.bingClip = Applet.newAudioClip(file.toURI().toURL());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public void systemMessage(String string) {
        this.cb.systemMessage(string);
    }

    private void initializeFrame() {
        int n;
        int n2;
        this.frame = new JFrame(Messages.getString("ClientGUI.title"));
        this.menuBar.setGame(this.client.game);
        this.frame.setJMenuBar(this.menuBar);
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (n2 = 0; n2 < graphicsDeviceArray.length; ++n2) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[n2];
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
            for (n = 0; n < graphicsConfigurationArray.length; ++n) {
                rectangle = rectangle.union(graphicsConfigurationArray[n].getBounds());
            }
        }
        if (GUIPreferences.getInstance().getWindowSizeHeight() != 0) {
            n2 = GUIPreferences.getInstance().getWindowPosX();
            int n3 = GUIPreferences.getInstance().getWindowPosY();
            int n4 = GUIPreferences.getInstance().getWindowSizeWidth();
            n = GUIPreferences.getInstance().getWindowSizeHeight();
            if ((double)n2 < rectangle.getMinX() || (double)(n2 + n4) > rectangle.getMaxX()) {
                n2 = 0;
            }
            if ((double)n3 < rectangle.getMinY() || (double)(n3 + n) > rectangle.getMaxY()) {
                n3 = 0;
            }
            if ((double)n4 > rectangle.getWidth()) {
                n4 = (int)rectangle.getWidth();
            }
            if ((double)n > rectangle.getHeight()) {
                n = (int)rectangle.getHeight();
            }
            this.frame.setLocation(n2, n3);
            this.frame.setSize(n4, n);
        } else {
            this.frame.setSize(800, 600);
        }
        this.frame.setBackground(SystemColor.menu);
        this.frame.setForeground(SystemColor.menuText);
        this.frame.setIconImage(this.frame.getToolkit().getImage("data/images/misc/megamek-icon.gif"));
    }

    private void layoutFrame() {
        this.frame.setTitle(this.client.getName() + Messages.getString("ClientGUI.clientTitleSuffix"));
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this, "Center");
        this.frame.validate();
    }

    public void initialize() {
        this.menuBar = new CommonMenuBar(this.getClient());
        this.initializeFrame();
        try {
            this.client.game.addGameListener(this.gameListener);
            this.bv = new BoardView1(this.client.game);
            this.scroller = new JScrollPane(this.bv);
            this.bv.setScrollPane(this.scroller);
        }
        catch (IOException iOException) {
            this.doAlertDialog(Messages.getString("ClientGUI.FatalError.title"), Messages.getString("ClientGUI.FatalError.message") + iOException);
            this.die();
        }
        this.layoutFrame();
        this.frame.setVisible(true);
        this.menuBar.addActionListener(this);
        this.frame.addKeyListener(this);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ClientGUI.this.frame.setVisible(false);
                ClientGUI.this.saveSettings();
                ClientGUI.this.die();
            }
        });
        UnitLoadingDialog unitLoadingDialog = new UnitLoadingDialog(this.frame);
        if (!MechSummaryCache.getInstance().isInitialized()) {
            unitLoadingDialog.setVisible(true);
        }
        this.uo = new UnitOverview(this);
        this.bv.addDisplayable(this.uo);
        this.bv.addMouseListener(this);
        this.bv.addKeyListener(this);
        this.bv.add(this.popup);
        Dimension dimension = this.frame.getToolkit().getScreenSize();
        this.mechW = new JDialog(this.frame, Messages.getString("ClientGUI.MechDisplay"), false);
        int n = GUIPreferences.getInstance().getDisplayPosX();
        int n2 = GUIPreferences.getInstance().getDisplayPosY();
        int n3 = GUIPreferences.getInstance().getDisplaySizeHeight();
        int n4 = GUIPreferences.getInstance().getDisplaySizeWidth();
        if (n + n4 > dimension.width) {
            n = 0;
            n4 = Math.min(n4, dimension.width);
        }
        if (n2 + n3 > dimension.height) {
            n2 = 0;
            n3 = Math.min(n3, dimension.height);
        }
        this.mechW.setLocation(n, n2);
        this.mechW.setSize(n4, n3);
        this.mechW.setResizable(true);
        this.mechW.addWindowListener(this);
        this.mechW.addKeyListener(this);
        this.mechD = new MechDisplay(this);
        this.mechD.addMechDisplayListener(this.bv);
        this.mechW.add(this.mechD);
        Ruler.color1 = GUIPreferences.getInstance().getRulerColor1();
        Ruler.color2 = GUIPreferences.getInstance().getRulerColor2();
        this.ruler = new Ruler(this.frame, this.client, this.bv);
        n = GUIPreferences.getInstance().getRulerPosX();
        n2 = GUIPreferences.getInstance().getRulerPosY();
        n3 = GUIPreferences.getInstance().getRulerSizeHeight();
        n4 = GUIPreferences.getInstance().getRulerSizeWidth();
        if (n + n4 > dimension.width) {
            n = 0;
            n4 = Math.min(n4, dimension.width);
        }
        if (n2 + n3 > dimension.height) {
            n2 = 0;
            n3 = Math.min(n3, dimension.height);
        }
        this.ruler.setLocation(n, n2);
        this.ruler.setSize(n4, n3);
        this.minimapW = new JDialog(this.frame, Messages.getString("ClientGUI.MiniMap"), false);
        n = GUIPreferences.getInstance().getMinimapPosX();
        n2 = GUIPreferences.getInstance().getMinimapPosY();
        try {
            this.minimap = new MiniMap(this.minimapW, this, this.bv);
        }
        catch (IOException iOException) {
            this.doAlertDialog(Messages.getString("ClientGUI.FatalError.title"), Messages.getString("ClientGUI.FatalError.message1") + iOException);
            this.die();
        }
        this.minimap.addKeyListener(this);
        n3 = this.minimap.getSize().height;
        n4 = this.minimap.getSize().width;
        if (n + 10 >= dimension.width || n + n4 < 10) {
            n = dimension.width - n4;
        }
        if (n2 + 10 > dimension.height || n2 + n3 < 10) {
            n2 = dimension.height - n3;
        }
        this.minimapW.setLocation(n, n2);
        this.minimapW.addWindowListener(this);
        this.minimapW.addKeyListener(this);
        this.minimapW.add(this.minimap);
        this.cb = new ChatterBox(this);
        this.add((Component)this.cb.getComponent(), "South");
        this.client.changePhase(IGame.Phase.PHASE_UNKNOWN);
        this.mechSelectorDialog = new MechSelectorDialog(this, unitLoadingDialog);
        this.customBADialog = new CustomBattleArmorDialog(this);
        this.customFSDialog = new CustomFighterSquadronDialog(this, unitLoadingDialog);
        this.randomArmyDialog = new RandomArmyDialog(this);
        this.randomSkillDialog = new RandomSkillDialog(this);
        new Thread((Runnable)this.mechSelectorDialog, "Mech Selector Dialog").start();
        new Thread((Runnable)this.customBADialog, "Custom Battle Armor Dialog").start();
    }

    public CommonMenuBar getMenuBar() {
        return this.menuBar;
    }

    private void showAbout() {
        if (this.about == null) {
            this.about = new CommonAboutDialog(this.frame);
        }
        this.about.setVisible(true);
    }

    private void showHelp() {
        if (this.help == null) {
            this.help = new CommonHelpDialog(this.frame, new File(this.helpFileName));
        }
        this.help.setVisible(true);
    }

    private void showSettings() {
        if (this.setdlg == null) {
            this.setdlg = new CommonSettingsDialog(this.frame);
        }
        this.setdlg.setVisible(true);
    }

    private void showOptions() {
        if (this.client.game.getPhase() == IGame.Phase.PHASE_LOUNGE) {
            this.getGameOptionsDialog().setEditable(true);
        } else {
            this.getGameOptionsDialog().setEditable(false);
        }
        this.getGameOptionsDialog().update(this.client.game.getOptions());
        this.getGameOptionsDialog().setVisible(true);
    }

    private void showPlayerList() {
        if (this.playerListDialog == null) {
            this.playerListDialog = new PlayerListDialog(this.frame, this.client);
        }
        this.playerListDialog.setVisible(true);
    }

    private void showRoundReport() {
        new MiniReportDisplay(this.frame, this.client.roundReport).setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("fileGameSave".equalsIgnoreCase(actionEvent.getActionCommand())) {
            JFileChooser jFileChooser = new JFileChooser(".");
            jFileChooser.setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
            jFileChooser.setDialogTitle(Messages.getString("ClientGUI.FileSaveDialog.title"));
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName() != null && file.getName().endsWith(".sav");
                }

                public String getDescription() {
                    return ".sav";
                }
            });
            int n = jFileChooser.showOpenDialog(this.frame);
            if (n != 0 || jFileChooser.getSelectedFile() == null) {
                return;
            }
            if (jFileChooser.getSelectedFile() != null) {
                this.client.sendChat("/save " + jFileChooser.getSelectedFile());
            }
        }
        if ("helpAbout".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.showAbout();
        }
        if ("helpContents".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.showHelp();
        }
        if ("viewClientSettings".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.showSettings();
        }
        if ("viewGameOptions".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.showOptions();
        }
        if ("viewPlayerList".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.showPlayerList();
        }
        if ("viewRoundReport".equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.showRoundReport();
        }
        if (actionEvent.getActionCommand().equals(VIEW_MEK_DISPLAY)) {
            this.toggleDisplay();
        } else if (actionEvent.getActionCommand().equals(VIEW_MINI_MAP)) {
            this.toggleMap();
        } else if (actionEvent.getActionCommand().equals(VIEW_UNIT_OVERVIEW)) {
            this.toggleUnitOverview();
        } else if (actionEvent.getActionCommand().equals(VIEW_LOS_SETTING)) {
            this.showLOSSettingDialog();
        }
    }

    void saveSettings() {
        GUIPreferences.getInstance().setWindowPosX(this.frame.getLocation().x);
        GUIPreferences.getInstance().setWindowPosY(this.frame.getLocation().y);
        GUIPreferences.getInstance().setWindowSizeWidth(this.frame.getSize().width);
        GUIPreferences.getInstance().setWindowSizeHeight(this.frame.getSize().height);
        if (this.minimapW != null && this.minimapW.getSize().width * this.minimapW.getSize().height > 0) {
            GUIPreferences.getInstance().setMinimapPosX(this.minimapW.getLocation().x);
            GUIPreferences.getInstance().setMinimapPosY(this.minimapW.getLocation().y);
            GUIPreferences.getInstance().setMinimapZoom(this.minimap.getZoom());
        }
        if (this.mechW != null && this.mechW.getSize().width * this.mechW.getSize().height > 0) {
            GUIPreferences.getInstance().setDisplayPosX(this.mechW.getLocation().x);
            GUIPreferences.getInstance().setDisplayPosY(this.mechW.getLocation().y);
            GUIPreferences.getInstance().setDisplaySizeWidth(this.mechW.getSize().width);
            GUIPreferences.getInstance().setDisplaySizeHeight(this.mechW.getSize().height);
        }
        if (this.ruler != null && this.ruler.getSize().width != 0 && this.ruler.getSize().height != 0) {
            GUIPreferences.getInstance().setRulerPosX(this.ruler.getLocation().x);
            GUIPreferences.getInstance().setRulerPosY(this.ruler.getLocation().y);
            GUIPreferences.getInstance().setRulerSizeWidth(this.ruler.getSize().width);
            GUIPreferences.getInstance().setRulerSizeHeight(this.ruler.getSize().height);
        }
    }

    void die() {
        boolean bl = false;
        Iterator<String> iterator = this.phaseComponents.keySet().iterator();
        while (iterator.hasNext()) {
            JComponent jComponent = this.phaseComponents.get(iterator.next());
            if (jComponent instanceof ReportDisplay) {
                if (bl) continue;
                bl = true;
            }
            if (!(jComponent instanceof Distractable)) continue;
            ((Distractable)((Object)jComponent)).removeAllListeners();
        }
        this.frame.removeAll();
        this.frame.setVisible(false);
        try {
            this.frame.dispose();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.client.die();
        if (this.chatlounge != null) {
            this.chatlounge.die();
        }
    }

    public BoardSelectionDialog getBoardSelectionDialog() {
        if (this.boardSelectionDialog == null) {
            this.boardSelectionDialog = new BoardSelectionDialog(this);
        }
        return this.boardSelectionDialog;
    }

    public GameOptionsDialog getGameOptionsDialog() {
        if (this.gameOptionsDialog == null) {
            this.gameOptionsDialog = new GameOptionsDialog(this);
        }
        return this.gameOptionsDialog;
    }

    public MechSelectorDialog getMechSelectorDialog() {
        return this.mechSelectorDialog;
    }

    public CustomBattleArmorDialog getCustomBADialog() {
        return this.customBADialog;
    }

    public CustomFighterSquadronDialog getCustomFSDialog() {
        return this.customFSDialog;
    }

    public StartingPositionDialog getStartingPositionDialog() {
        if (this.startingPositionDialog == null) {
            this.startingPositionDialog = new StartingPositionDialog(this);
        }
        return this.startingPositionDialog;
    }

    public CustomInitiativeDialog getCustomInitiativeDialog() {
        if (this.initDialog == null) {
            this.initDialog = new CustomInitiativeDialog(this);
        }
        return this.initDialog;
    }

    void switchPanel(IGame.Phase phase) {
        if (this.curPanel instanceof BoardViewListener) {
            this.bv.removeBoardViewListener((BoardViewListener)((Object)this.curPanel));
        }
        if (this.curPanel instanceof ActionListener) {
            this.menuBar.removeActionListener((ActionListener)((Object)this.curPanel));
        }
        if (this.curPanel instanceof Distractable) {
            ((Distractable)((Object)this.curPanel)).setIgnoringEvents(true);
        }
        String string = String.valueOf((Object)phase);
        this.curPanel = this.phaseComponents.get(string);
        if (this.curPanel == null) {
            this.curPanel = this.initializePanel(phase);
        }
        this.cardsMain.show(this.panMain, this.mainNames.get(string).toString());
        this.cardsSecondary.show(this.panSecondary, this.secondaryNames.get(string).toString());
        if (this.curPanel instanceof BoardViewListener) {
            this.bv.addBoardViewListener((BoardViewListener)((Object)this.curPanel));
        }
        if (this.curPanel instanceof ActionListener) {
            this.menuBar.addActionListener((ActionListener)((Object)this.curPanel));
        }
        if (this.curPanel instanceof Distractable) {
            ((Distractable)((Object)this.curPanel)).setIgnoringEvents(false);
        }
        if (this.curPanel instanceof DoneButtoned) {
            JButton jButton = ((DoneButtoned)((Object)this.curPanel)).getDoneButton();
            this.cb.setDoneButton(jButton);
            jButton.setVisible(true);
        }
        if (GUIPreferences.getInstance().getFocus() && !(this.client instanceof TestBot)) {
            this.curPanel.requestFocus();
        }
    }

    private JComponent initializePanel(IGame.Phase phase) {
        String string;
        String string2;
        JComponent jComponent;
        String string3 = String.valueOf((Object)phase);
        switch (phase) {
            case PHASE_LOUNGE: {
                jComponent = new ChatLounge(this);
                this.chatlounge = jComponent;
                string = string2 = "ChatLounge";
                this.panMain.add(string2, jComponent);
                this.panSecondary.add(string, ((ChatLounge)jComponent).getSecondaryDisplay());
                break;
            }
            case PHASE_STARTING_SCENARIO: {
                jComponent = new JLabel(Messages.getString("ClientGUI.StartingScenario"));
                string = string2 = "JLabel-StartingScenario";
                this.panMain.add(string2, jComponent);
                this.panSecondary.add(string, new JLabel(""));
                break;
            }
            case PHASE_EXCHANGE: {
                jComponent = new JLabel(Messages.getString("ClientGUI.TransmittingData"));
                string = string2 = "JLabel-Exchange";
                this.panMain.add(string2, jComponent);
                this.panSecondary.add(string, new JLabel(""));
                break;
            }
            case PHASE_SET_ARTYAUTOHITHEXES: {
                jComponent = new SelectArtyAutoHitHexDisplay(this);
                string2 = "BoardView";
                string = "SelectArtyAutoHitHexDisplay";
                if (!this.mainNames.containsValue(string2)) {
                    this.panMain.add(string2, this.scroller);
                }
                this.panSecondary.add(string, jComponent);
                break;
            }
            case PHASE_DEPLOY_MINEFIELDS: {
                jComponent = new DeployMinefieldDisplay(this);
                string2 = "BoardView";
                string = "DeployMinefieldDisplay";
                if (!this.mainNames.containsValue(string2)) {
                    this.panMain.add(string2, this.scroller);
                }
                this.panSecondary.add(string, jComponent);
                break;
            }
            case PHASE_DEPLOYMENT: {
                jComponent = new DeploymentDisplay(this);
                string2 = "BoardView";
                string = "DeploymentDisplay";
                if (!this.mainNames.containsValue(string2)) {
                    this.panMain.add(string2, this.scroller);
                }
                this.panSecondary.add(string, jComponent);
                break;
            }
            case PHASE_TARGETING: {
                jComponent = new TargetingPhaseDisplay(this, false);
                ((TargetingPhaseDisplay)jComponent).initializeListeners();
                string2 = "BoardView";
                string = "TargetingPhaseDisplay";
                if (!this.mainNames.containsValue(string2)) {
                    this.panMain.add(string2, this.scroller);
                }
                this.panSecondary.add(string, jComponent);
                break;
            }
            case PHASE_MOVEMENT: {
                jComponent = new MovementDisplay(this);
                string2 = "BoardView";
                string = "MovementDisplay";
                if (!this.mainNames.containsValue(string2)) {
                    this.panMain.add(string2, this.scroller);
                }
                this.panSecondary.add(string, jComponent);
                break;
            }
            case PHASE_OFFBOARD: {
                jComponent = new TargetingPhaseDisplay(this, true);
                ((TargetingPhaseDisplay)jComponent).initializeListeners();
                string2 = "BoardView";
                string = "OffboardDisplay";
                if (!this.mainNames.containsValue(string2)) {
                    this.panMain.add(string2, this.scroller);
                }
                this.panSecondary.add(string, jComponent);
                break;
            }
            case PHASE_FIRING: {
                jComponent = new FiringDisplay(this);
                string2 = "BoardView";
                string = "FiringDisplay";
                if (!this.mainNames.containsValue(string2)) {
                    this.panMain.add(string2, this.scroller);
                }
                this.panSecondary.add(string, jComponent);
                break;
            }
            case PHASE_PHYSICAL: {
                jComponent = new PhysicalDisplay(this);
                string2 = "BoardView";
                string = "PhysicalDisplay";
                if (!this.mainNames.containsValue(string2)) {
                    this.panMain.add(string2, this.scroller);
                }
                this.panSecondary.add(string, jComponent);
                break;
            }
            case PHASE_INITIATIVE_REPORT: {
                jComponent = new ReportDisplay(this.client);
                string = string2 = "ReportDisplay";
                this.panMain.add(string2, jComponent);
                this.panSecondary.add(string, ((ReportDisplay)jComponent).getSecondaryDisplay());
                break;
            }
            case PHASE_TARGETING_REPORT: 
            case PHASE_MOVEMENT_REPORT: 
            case PHASE_OFFBOARD_REPORT: 
            case PHASE_FIRING_REPORT: 
            case PHASE_PHYSICAL_REPORT: 
            case PHASE_END_REPORT: 
            case PHASE_VICTORY: {
                jComponent = this.phaseComponents.get(String.valueOf((Object)IGame.Phase.PHASE_INITIATIVE_REPORT));
                if (jComponent == null) {
                    jComponent = this.initializePanel(IGame.Phase.PHASE_INITIATIVE_REPORT);
                }
                string = string2 = "ReportDisplay";
                break;
            }
            default: {
                jComponent = new JLabel(Messages.getString("ClientGUI.waitingOnTheServer"));
                string = string2 = "JLabel-Default";
                this.panMain.add(string2, jComponent);
                this.panSecondary.add(string, new JLabel(""));
            }
        }
        this.phaseComponents.put(string3, jComponent);
        this.mainNames.put(string3, string2);
        this.secondaryNames.put(string3, string);
        return jComponent;
    }

    protected void addBag(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
    }

    private void showBoardPopup(Point point) {
        this.fillPopup(this.bv.getCoordsAt(point));
        if (this.popup.getItemCount() > 0) {
            this.popup.show(this.bv, point.x, point.y);
        }
    }

    private boolean canTargetEntities() {
        return this.client.isMyTurn() && (this.curPanel instanceof FiringDisplay || this.curPanel instanceof PhysicalDisplay || this.curPanel instanceof TargetingPhaseDisplay);
    }

    private boolean canSelectEntities() {
        return this.client.isMyTurn() && (this.curPanel instanceof FiringDisplay || this.curPanel instanceof PhysicalDisplay || this.curPanel instanceof MovementDisplay || this.curPanel instanceof TargetingPhaseDisplay);
    }

    private void toggleDisplay() {
        this.mechW.setVisible(!this.mechW.isVisible());
        if (this.mechW.isVisible()) {
            this.frame.requestFocus();
        }
    }

    public void setDisplayVisible(boolean bl) {
        this.mechW.setVisible(bl);
        if (bl) {
            this.frame.requestFocus();
        }
    }

    private void toggleUnitOverview() {
        this.uo.setVisible(!this.uo.isVisible());
        this.bv.repaint();
    }

    private void toggleMap() {
        if (this.minimapW.isVisible()) {
            GUIPreferences.getInstance().setMinimapEnabled(false);
        } else {
            GUIPreferences.getInstance().setMinimapEnabled(true);
        }
        this.minimapW.setVisible(!this.minimapW.isVisible());
        if (this.minimapW.isVisible()) {
            this.frame.requestFocus();
        }
    }

    void setMapVisible(boolean bl) {
        this.minimapW.setVisible(bl);
        if (bl) {
            this.frame.requestFocus();
        }
    }

    private void fillPopup(Coords coords) {
        Entity entity;
        Object object;
        this.popup.removeAll();
        if (this.canSelectEntities()) {
            object = this.client.game.getEntities(coords);
            while (object.hasMoreElements()) {
                entity = object.nextElement();
                if (!this.client.game.getTurn().isValidEntity(entity, this.client.game)) continue;
                this.popup.add(new SelectMenuItem(entity));
            }
        }
        if (this.popup.getItemCount() > 0) {
            this.popup.addSeparator();
        }
        object = this.client.game.getEntities(coords);
        while (object.hasMoreElements()) {
            entity = object.nextElement();
            this.popup.add(new ViewMenuItem(entity));
        }
        if (this.canTargetEntities()) {
            if (this.popup.getItemCount() > 0) {
                this.popup.addSeparator();
            }
            object = this.client.game.getEntities(coords);
            while (object.hasMoreElements()) {
                entity = object.nextElement();
                this.popup.add(new TargetMenuItem(entity));
            }
            if (this.curPanel instanceof FiringDisplay || this.curPanel instanceof PhysicalDisplay || this.curPanel instanceof TargetingPhaseDisplay) {
                object = this.client.game.getBoard().getHex(coords);
                if (object != null && this.curPanel instanceof FiringDisplay) {
                    this.popup.add(new TargetMenuItem(new HexTarget(coords, this.client.game.getBoard(), 1)));
                    if (this.client.game.getOptions().booleanOption("fire")) {
                        this.popup.add(new TargetMenuItem(new HexTarget(coords, this.client.game.getBoard(), 2)));
                    }
                } else if (object != null && object.containsTerrain(33)) {
                    this.popup.add(new TargetMenuItem(new BuildingTarget(coords, this.client.game.getBoard(), false)));
                    if (this.client.game.getOptions().booleanOption("fire")) {
                        this.popup.add(new TargetMenuItem(new BuildingTarget(coords, this.client.game.getBoard(), true)));
                    }
                } else if (object != null && object.containsTerrain(10)) {
                    this.popup.add(new TargetMenuItem(new BuildingTarget(coords, this.client.game.getBoard(), false)));
                    if (this.client.game.getOptions().booleanOption("fire")) {
                        this.popup.add(new TargetMenuItem(new BuildingTarget(coords, this.client.game.getBoard(), true)));
                    }
                }
                if (object != null && this.client.game.containsMinefield(coords) && this.curPanel instanceof FiringDisplay) {
                    this.popup.add(new TargetMenuItem(new MinefieldTarget(coords, this.client.game.getBoard())));
                }
                if (object != null && this.curPanel instanceof FiringDisplay) {
                    this.popup.add(new TargetMenuItem(new HexTarget(coords, this.client.game.getBoard(), 6)));
                    this.popup.add(new TargetMenuItem(new HexTarget(coords, this.client.game.getBoard(), 13)));
                    this.popup.add(new TargetMenuItem(new HexTarget(coords, this.client.game.getBoard(), 14)));
                    this.popup.add(new TargetMenuItem(new HexTarget(coords, this.client.game.getBoard(), 7)));
                }
                if (object != null && this.client.game.getOptions().booleanOption("fire") && object.containsTerrain(7)) {
                    this.popup.add(new TargetMenuItem(new HexTarget(coords, this.client.game.getBoard(), 8)));
                }
                if (object != null && this.curPanel instanceof TargetingPhaseDisplay) {
                    this.popup.add(new TargetMenuItem(new HexTarget(coords, this.client.game.getBoard(), 7)));
                }
            }
        }
    }

    public int[] doChoiceDialog(String string, String string2, String[] stringArray) {
        ChoiceDialog choiceDialog = new ChoiceDialog(this.frame, string, string2, stringArray);
        choiceDialog.setVisible(true);
        return choiceDialog.getChoices();
    }

    public void doAlertDialog(String string, String string2) {
        JOptionPane.showMessageDialog(this.frame, string2, string, 0);
    }

    public boolean doYesNoDialog(String string, String string2) {
        ConfirmDialog confirmDialog = new ConfirmDialog(this.frame, string, string2);
        confirmDialog.setVisible(true);
        return confirmDialog.getAnswer();
    }

    public ConfirmDialog doYesNoBotherDialog(String string, String string2) {
        ConfirmDialog confirmDialog = new ConfirmDialog(this.frame, string, string2, true);
        confirmDialog.setVisible(true);
        return confirmDialog;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showBoardPopup(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showBoardPopup(mouseEvent.getPoint());
        }
    }

    protected void loadListFile() {
        if (this.dlgLoadList == null) {
            this.dlgLoadList = new JFileChooser(".");
            this.dlgLoadList.setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
            this.dlgLoadList.setDialogTitle(Messages.getString("ClientGUI.openUnitListFileDialog.title"));
            this.dlgLoadList.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName() != null && file.getName().endsWith(".mul");
                }

                public String getDescription() {
                    return ".mul";
                }
            });
        }
        this.dlgLoadList.setSelectedFile(new File(this.client.getLocalPlayer().getName() + ".mul"));
        int n = this.dlgLoadList.showOpenDialog(this.frame);
        if (n != 0 || this.dlgSaveList.getSelectedFile() == null) {
            return;
        }
        File file = this.dlgLoadList.getSelectedFile();
        if (file != null) {
            try {
                Vector<Entity> vector = EntityListFile.loadFrom(file);
                Enumeration<Entity> enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Entity entity = enumeration.nextElement();
                    entity.setOwner(this.client.getLocalPlayer());
                    this.client.sendAddEntity(entity);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                this.doAlertDialog(Messages.getString("ClientGUI.errorLoadingFile"), iOException.getMessage());
            }
        }
    }

    protected void saveListFile(ArrayList<Entity> arrayList) {
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        if (this.dlgSaveList == null) {
            this.dlgSaveList = new JFileChooser(".");
            this.dlgSaveList.setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
            this.dlgSaveList.setDialogTitle(Messages.getString("ClientGUI.saveUnitListFileDialog.title"));
            this.dlgSaveList.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName() != null && file.getName().endsWith(".mul");
                }

                public String getDescription() {
                    return ".mul";
                }
            });
        }
        this.dlgSaveList.setSelectedFile(new File(this.client.getLocalPlayer().getName() + ".mul"));
        int n = this.dlgSaveList.showSaveDialog(this.frame);
        if (n != 0 || this.dlgSaveList.getSelectedFile() == null) {
            return;
        }
        File file = this.dlgSaveList.getSelectedFile();
        if (file != null) {
            if (!file.getName().toLowerCase().endsWith(".mul") && !file.getName().toLowerCase().endsWith(".xml")) {
                try {
                    file = new File(file.getCanonicalPath() + ".mul");
                }
                catch (IOException iOException) {
                    return;
                }
            }
            try {
                EntityListFile.saveTo(file, arrayList);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                this.doAlertDialog(Messages.getString("ClientGUI.errorSavingFile"), iOException.getMessage());
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getWindow().equals(this.minimapW)) {
            this.setMapVisible(false);
        } else if (windowEvent.getWindow().equals(this.mechW)) {
            this.setDisplayVisible(false);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    public JFrame getFrame() {
        return this.frame;
    }

    private void showLOSSettingDialog() {
        GUIPreferences gUIPreferences = GUIPreferences.getInstance();
        LOSDialog lOSDialog = new LOSDialog(this.frame, gUIPreferences.getMechInFirst(), gUIPreferences.getMechInSecond());
        lOSDialog.setVisible(true);
        gUIPreferences.setMechInFirst(lOSDialog.getMechInFirst());
        gUIPreferences.setMechInSecond(lOSDialog.getMechInSecond());
    }

    public void loadPreviewImage(JLabel jLabel, Entity entity) {
        Player player = this.client.game.getPlayer(entity.getOwnerId());
        this.loadPreviewImage(jLabel, entity, player);
    }

    public void loadPreviewImage(JLabel jLabel, Entity entity, Player player) {
        Image image = this.bv.getTilesetManager().getPlayerCamo(player);
        int n = PlayerColors.getColorRGB(player.getColorIndex());
        this.bv.getTilesetManager().loadPreviewImage(entity, image, n, jLabel);
    }

    void bing() {
        if (!GUIPreferences.getInstance().getSoundMute() && this.bingClip != null) {
            this.bingClip.play();
        }
    }

    public Client getClient() {
        return this.client;
    }

    public Map<String, Client> getBots() {
        return this.bots;
    }

    public int getSelectedEntityNum() {
        return this.selectedEntityNum;
    }

    public void setSelectedEntityNum(int n) {
        this.selectedEntityNum = n;
    }

    public RandomArmyDialog getRandomArmyDialog() {
        return this.randomArmyDialog;
    }

    public RandomSkillDialog getRandomSkillDialog() {
        return this.randomSkillDialog;
    }

    private class TargetMenuItem
    extends MenuItem
    implements ActionListener {
        private static final long serialVersionUID = -787739862752367595L;
        Targetable target;

        public TargetMenuItem(Targetable targetable) {
            super(Messages.getString("ClientGUI.targetMenuItem") + targetable.getDisplayName());
            this.target = targetable;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ClientGUI.this.curPanel instanceof FiringDisplay) {
                ((FiringDisplay)ClientGUI.this.curPanel).target(this.target);
            } else if (ClientGUI.this.curPanel instanceof PhysicalDisplay) {
                ((PhysicalDisplay)ClientGUI.this.curPanel).target(this.target);
            } else if (ClientGUI.this.curPanel instanceof TargetingPhaseDisplay) {
                ((TargetingPhaseDisplay)ClientGUI.this.curPanel).target(this.target);
            }
        }
    }

    private class SelectMenuItem
    extends MenuItem
    implements ActionListener {
        private static final long serialVersionUID = 2297987555798437914L;
        Entity entity;

        public SelectMenuItem(Entity entity) {
            super(Messages.getString("ClientGUI.selectMenuItem") + entity.getDisplayName());
            this.entity = entity;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ClientGUI.this.curPanel instanceof MovementDisplay) {
                ((MovementDisplay)ClientGUI.this.curPanel).selectEntity(this.entity.getId());
            } else if (ClientGUI.this.curPanel instanceof FiringDisplay) {
                ((FiringDisplay)ClientGUI.this.curPanel).selectEntity(this.entity.getId());
            } else if (ClientGUI.this.curPanel instanceof PhysicalDisplay) {
                ((PhysicalDisplay)ClientGUI.this.curPanel).selectEntity(this.entity.getId());
            }
        }
    }

    private class ViewMenuItem
    extends MenuItem
    implements ActionListener {
        private static final long serialVersionUID = -666611691422273047L;
        Entity entity;

        public ViewMenuItem(Entity entity) {
            super(Messages.getString("ClientGUI.viewMenuItem") + entity.getDisplayName() + (entity.isDone() ? " (" + Messages.getString("ClientGUI.doneMenuItem").trim() + ')' : ""));
            this.entity = entity;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ClientGUI.this.setDisplayVisible(true);
            ClientGUI.this.mechD.displayEntity(this.entity);
        }
    }
}

