/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;

public class ConfirmDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -8491332593940944224L;
    private GridBagLayout gridbag = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private boolean useCheckbox;
    private JCheckBox botherCheckbox;
    private JPanel panButtons = new JPanel();
    private JButton butYes = new JButton(Messages.getString("Yes"));
    private JButton butNo = new JButton(Messages.getString("No"));
    JButton defaultButton = this.butYes;
    private boolean confirmation;
    JComponent firstFocusable;

    public ConfirmDialog(JFrame jFrame, String string, String string2) {
        this(jFrame, string, string2, false);
    }

    public ConfirmDialog(JFrame jFrame, String string, String string2, boolean bl) {
        this(jFrame, string, string2, bl, 'y');
    }

    private ConfirmDialog(JFrame jFrame, String string, String string2, boolean bl, char c) {
        super(jFrame, string, true);
        if (c == 'n') {
            this.defaultButton = this.butNo;
        }
        super.setResizable(false);
        this.useCheckbox = bl;
        this.setLayout(this.gridbag);
        this.addQuestion(string2);
        this.addInputs();
        this.finishSetup(jFrame);
    }

    private void addQuestion(String string) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        this.c.gridheight = 2;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.gridbag.setConstraints(jTextArea, this.c);
        this.getContentPane().add(jTextArea);
    }

    private void addInputs() {
        int n = 2;
        this.c.gridheight = 1;
        if (this.useCheckbox) {
            this.botherCheckbox = new JCheckBox(Messages.getString("ConfirmDialog.dontBother"));
            this.c.gridy = n++;
            this.gridbag.setConstraints(this.botherCheckbox, this.c);
            this.getContentPane().add(this.botherCheckbox);
        }
        this.butYes.addActionListener(this);
        this.butNo.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagLayout.setConstraints(this.butYes, gridBagConstraints);
        this.panButtons.add(this.butYes);
        gridBagLayout.setConstraints(this.butNo, gridBagConstraints);
        this.panButtons.add(this.butNo);
        this.c.gridy = n;
        this.gridbag.setConstraints(this.panButtons, this.c);
        this.getContentPane().add(this.panButtons);
    }

    private void finishSetup(JFrame jFrame) {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConfirmDialog.this.setVisible(false);
            }
        });
        this.pack();
        Dimension dimension = this.getSize();
        boolean bl = false;
        if (dimension.width < GUIPreferences.getInstance().getMinimumSizeWidth()) {
            dimension.width = GUIPreferences.getInstance().getMinimumSizeWidth();
            bl = true;
        }
        if (dimension.height < GUIPreferences.getInstance().getMinimumSizeHeight()) {
            dimension.height = GUIPreferences.getInstance().getMinimumSizeHeight();
            bl = true;
        }
        if (bl) {
            this.setSize(dimension);
            dimension = this.getSize();
        }
        this.setLocation(jFrame.getLocation().x + jFrame.getSize().width / 2 - dimension.width / 2, jFrame.getLocation().y + jFrame.getSize().height / 2 - dimension.height / 2);
        this.firstFocusable = this.useCheckbox ? this.botherCheckbox : this.butYes;
        if (!this.firstFocusable.equals(this.defaultButton)) {
            this.firstFocusable.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    ConfirmDialog.this.defaultButton.requestFocus();
                }

                public void focusLost(FocusEvent focusEvent) {
                    ConfirmDialog.this.firstFocusable.removeFocusListener(this);
                }
            });
        }
    }

    public boolean getAnswer() {
        return this.confirmation;
    }

    public boolean getShowAgain() {
        if (this.botherCheckbox == null) {
            return true;
        }
        return !this.botherCheckbox.isSelected();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.butYes)) {
            this.confirmation = true;
        } else if (actionEvent.getSource().equals(this.butNo)) {
            this.confirmation = false;
        }
        this.setVisible(false);
    }
}

