/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import megamek.client.Client;
import megamek.client.ui.swing.ChatLounge;
import megamek.client.ui.swing.MechView;
import megamek.client.ui.swing.Messages;
import megamek.common.Entity;

public class MechGroupView
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = -6128402142715924422L;
    private JList entities = new JList();
    private JButton closeButton = new JButton(Messages.getString("Close"));
    private JTextArea ta = new JTextArea();
    private Client client;
    private int[] entityArray;

    MechGroupView(JFrame jFrame, Client client, int[] nArray) {
        super((Frame)jFrame, Messages.getString("MechGroupView.title"));
        this.client = client;
        this.entityArray = nArray;
        String[] stringArray = new String[this.entityArray.length];
        int n = 0;
        boolean bl = this.client.game.getOptions().booleanOption("rpg_gunnery");
        for (int n2 : this.entityArray) {
            Entity entity = this.client.game.getEntity(n2);
            if (entity == null) continue;
            if (!entity.getOwner().equals(this.client.getLocalPlayer()) && this.client.game.getOptions().booleanOption("blind_drop") && !this.client.game.getOptions().booleanOption("real_blind_drop")) {
                stringArray[n++] = ChatLounge.formatUnit(entity, true, bl);
                continue;
            }
            if (!entity.getOwner().equals(this.client.getLocalPlayer()) && (this.client.game.getOptions().booleanOption("blind_drop") || this.client.game.getOptions().booleanOption("real_blind_drop"))) continue;
            stringArray[n++] = ChatLounge.formatUnit(entity, false, bl);
        }
        this.entities = new JList<String>(stringArray);
        this.entities.setSelectionMode(0);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.entities, "West");
        this.getContentPane().add((Component)this.closeButton, "South");
        this.ta.setEditable(false);
        this.ta.setOpaque(false);
        this.ta.setFont(new Font("Monospaced", 0, 12));
        this.getContentPane().add((Component)this.ta, "Center");
        this.entities.addListSelectionListener(this);
        this.closeButton.addActionListener(this);
        this.setSize(550, 600);
        this.setLocation(jFrame.getLocation().x + jFrame.getSize().width / 2 - this.getSize().width / 2, jFrame.getLocation().y + jFrame.getSize().height / 10);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().setVisible(false);
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.closeButton)) {
            this.setVisible(false);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.entities)) {
            int n = this.entities.getSelectedIndex();
            if (n == -1) {
                this.ta.setText("");
                return;
            }
            if (!this.client.game.getEntity(this.entityArray[n]).getOwner().equals(this.client.getLocalPlayer())) {
                this.ta.setText("(enemy unit)");
            } else {
                Entity entity = this.client.game.getEntity(this.entityArray[n]);
                MechView mechView = new MechView(entity, this.client.game.getOptions().booleanOption("show_bay_detail"));
                this.ta.setText(mechView.getMechReadout());
            }
        }
    }
}

