/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import megamek.client.Client;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.Messages;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.IStartingPositions;
import megamek.common.Player;

public class StartingPositionDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 7255701351824139329L;
    private Client client;
    private ClientGUI clientgui;
    private JPanel panButtons = new JPanel();
    private JButton butOkay = new JButton(Messages.getString("Okay"));
    private JButton butCancel = new JButton(Messages.getString("Cancel"));
    private JPanel panStartButtons = new JPanel();
    private JButton[] butStartPos = new JButton[11];
    private JList lisStartList = new JList(new DefaultListModel());

    public StartingPositionDialog(ClientGUI clientGUI) {
        super(clientGUI.frame, Messages.getString("StartingPositionDialog.title"), true);
        this.client = clientGUI.getClient();
        this.clientgui = clientGUI;
        this.lisStartList.setEnabled(false);
        this.setupStartGrid();
        this.setupButtons();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.panStartButtons, gridBagConstraints);
        this.getContentPane().add(this.panStartButtons);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        JScrollPane jScrollPane = new JScrollPane(this.lisStartList);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.getContentPane().add(jScrollPane);
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.panButtons, gridBagConstraints);
        this.getContentPane().add(this.panButtons);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StartingPositionDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setResizable(false);
        this.setLocation(clientGUI.frame.getLocation().x + clientGUI.frame.getSize().width / 2 - this.getSize().width / 2, clientGUI.frame.getLocation().y + clientGUI.frame.getSize().height / 2 - this.getSize().height / 2);
    }

    private void setupStartGrid() {
        for (int i = 0; i < 11; ++i) {
            this.butStartPos[i] = new JButton(IStartingPositions.START_LOCATION_NAMES[i]);
            this.butStartPos[i].addActionListener(this);
        }
        this.panStartButtons.setLayout(new GridLayout(4, 3));
        this.panStartButtons.add(this.butStartPos[1]);
        this.panStartButtons.add(this.butStartPos[2]);
        this.panStartButtons.add(this.butStartPos[3]);
        this.panStartButtons.add(this.butStartPos[8]);
        this.panStartButtons.add(this.butStartPos[10]);
        this.panStartButtons.add(this.butStartPos[4]);
        this.panStartButtons.add(this.butStartPos[7]);
        this.panStartButtons.add(this.butStartPos[6]);
        this.panStartButtons.add(this.butStartPos[5]);
        this.panStartButtons.add(this.butStartPos[0]);
        this.panStartButtons.add(this.butStartPos[9]);
    }

    private void setupButtons() {
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.butOkay, gridBagConstraints);
        this.panButtons.add(this.butOkay);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.butCancel, gridBagConstraints);
        this.panButtons.add(this.butCancel);
    }

    public void update() {
        ((DefaultListModel)this.lisStartList.getModel()).removeAllElements();
        Enumeration<Player> enumeration = this.client.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            if (player == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(player.getName()).append(" : ");
            stringBuffer.append(IStartingPositions.START_LOCATION_NAMES[player.getStartingPos()]);
            ((DefaultListModel)this.lisStartList.getModel()).addElement(stringBuffer.toString());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < 11; ++i) {
            Object object;
            if (!actionEvent.getSource().equals(this.butStartPos[i])) continue;
            if (this.client.game.getOptions().booleanOption("double_blind") && this.client.game.getOptions().booleanOption("exclusive_db_deployment")) {
                if (i == 0) {
                    this.clientgui.doAlertDialog("Starting Position not allowed", "In Double Blind play, you cannot choose 'Any' as starting position.");
                    return;
                }
                Enumeration<Player> enumeration = this.client.game.getPlayers();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (((Player)object).getStartingPos() == 0 || ((Player)object).getStartingPos() != i && ((Player)object).getStartingPos() + 1 != i && ((Player)object).getStartingPos() - 1 != i || ((Player)object).getId() == this.client.getLocalPlayer().getId()) continue;
                    this.clientgui.doAlertDialog("Must choose exclusive deployment zone", "When using double blind, each player needs to have an exclusive deployment zone.");
                    return;
                }
            }
            if (this.client.game.getOptions().booleanOption("deep_deployment") && i > 0 && i <= 9) {
                i += 10;
            }
            this.client.getLocalPlayer().setStartingPos(i);
            this.client.sendPlayerInfo();
            if (!this.client.game.getOptions().booleanOption("set_arty_player_homeedge")) continue;
            int n = -1;
            switch (i) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n = 0;
                    break;
                }
                case 4: {
                    n = 2;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    n = 1;
                    break;
                }
                case 8: {
                    n = 3;
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    n = 0;
                    break;
                }
                case 14: {
                    n = 2;
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    n = 1;
                    break;
                }
                case 18: {
                    n = 3;
                    break;
                }
            }
            object = this.client.game.getSelectedEntities(new EntitySelector(){

                public boolean accept(Entity entity) {
                    return entity.getOwnerId() == StartingPositionDialog.this.client.getLocalPlayer().getId();
                }
            });
            while (object.hasMoreElements()) {
                Entity entity = (Entity)object.nextElement();
                if (entity.getOffBoardDirection() == -1 || n <= -1) continue;
                entity.setOffBoard(entity.getOffBoardDistance(), n);
            }
        }
        this.setVisible(false);
    }

    public void setClient(Client client) {
        this.client = client;
    }
}

