/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing.widget;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import javax.swing.JComponent;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.widget.BackGroundDrawer;
import megamek.client.ui.swing.widget.DisplayMapSet;
import megamek.client.ui.swing.widget.PMAreasGroup;
import megamek.client.ui.swing.widget.PMPicArea;
import megamek.client.ui.swing.widget.PMSimpleLabel;
import megamek.client.ui.swing.widget.PMUtil;
import megamek.client.ui.swing.widget.PMValueLabel;
import megamek.client.ui.swing.widget.WidgetUtils;
import megamek.common.Entity;
import megamek.common.FighterSquadron;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SquadronMapSet
implements DisplayMapSet {
    private static final String IMAGE_DIR = "data/images/widgets";
    private Image battleArmorImage;
    private Image armorImage;
    private JComponent comp;
    private PMPicArea[] unitAreas = new PMPicArea[FighterSquadron.MAX_SIZE];
    private PMSimpleLabel[] deadUnit = new PMSimpleLabel[FighterSquadron.MAX_SIZE];
    private PMPicArea armorAreas;
    private PMValueLabel armorLabels;
    private PMValueLabel armorNameLabel;
    private PMSimpleLabel[] labels = new PMSimpleLabel[4];
    private PMValueLabel[] vLabels = new PMValueLabel[4];
    private PMAreasGroup content = new PMAreasGroup();
    private Vector<BackGroundDrawer> bgDrawers = new Vector();
    private int stepY = 40;
    private int stepX = 40;
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorLargeFontSize"));
    private static final Font BIG_FONT_VALUE = new Font("SansSerif", 0, 24);

    public SquadronMapSet(JComponent jComponent) {
        this.comp = jComponent;
        this.setAreas();
        this.setBackGround();
    }

    private void setAreas() {
        FontMetrics fontMetrics = this.comp.getFontMetrics(FONT_VALUE);
        FontMetrics fontMetrics2 = this.comp.getFontMetrics(BIG_FONT_VALUE);
        this.battleArmorImage = this.comp.getToolkit().getImage("data/images/widgets/fighter.gif");
        PMUtil.setImage(this.battleArmorImage, this.comp);
        this.armorImage = this.comp.createImage(120, 12);
        this.armorAreas = new PMPicArea(this.armorImage);
        this.armorAreas.translate(30, 0);
        this.content.addArea(this.armorAreas);
        this.armorLabels = new PMValueLabel(fontMetrics, Color.red.brighter());
        this.armorLabels.moveTo(160, 12);
        this.content.addArea(this.armorLabels);
        this.armorNameLabel = new PMValueLabel(fontMetrics, Color.white);
        this.armorNameLabel.moveTo(0, 12);
        this.content.addArea(this.armorNameLabel);
        for (int i = 0; i < FighterSquadron.MAX_SIZE; ++i) {
            int n = i % 3 * this.stepX;
            int n2 = i / 3 * this.stepY + 110;
            this.unitAreas[i] = new PMPicArea(this.battleArmorImage);
            this.unitAreas[i].translate(n, n2);
            this.content.addArea(this.unitAreas[i]);
            int n3 = n + this.stepX / 2;
            int n4 = n2 + this.stepY / 2;
            this.deadUnit[i] = WidgetUtils.createLabel("X", fontMetrics2, Color.red.brighter(), n3 + 10, n4);
            this.content.addArea(this.deadUnit[i]);
        }
        this.labels[0] = WidgetUtils.createLabel("Avionics:", fontMetrics, Color.white, 10, 30);
        this.labels[1] = WidgetUtils.createLabel("Engine:", fontMetrics, Color.white, 10, 45);
        this.labels[2] = WidgetUtils.createLabel("FCS:", fontMetrics, Color.white, 10, 60);
        this.labels[3] = WidgetUtils.createLabel("Sensors:", fontMetrics, Color.white, 10, 75);
        this.vLabels[0] = WidgetUtils.createValueLabel(40, 30, "", fontMetrics);
        this.vLabels[1] = WidgetUtils.createValueLabel(40, 45, "", fontMetrics);
        this.vLabels[2] = WidgetUtils.createValueLabel(40, 60, "", fontMetrics);
        this.vLabels[3] = WidgetUtils.createValueLabel(40, 75, "", fontMetrics);
        this.content.addArea(this.labels[0]);
        this.content.addArea(this.vLabels[0]);
        this.content.addArea(this.labels[1]);
        this.content.addArea(this.vLabels[1]);
        this.content.addArea(this.labels[2]);
        this.content.addArea(this.vLabels[2]);
        this.content.addArea(this.labels[3]);
        this.content.addArea(this.vLabels[3]);
    }

    @Override
    public PMAreasGroup getContentGroup() {
        return this.content;
    }

    @Override
    public Vector<BackGroundDrawer> getBackgroundDrawers() {
        return this.bgDrawers;
    }

    @Override
    public void setEntity(Entity entity) {
        int n;
        FighterSquadron fighterSquadron = (FighterSquadron)entity;
        int n2 = 0;
        int n3 = 1;
        int n4 = fighterSquadron.getN0Fighters();
        int n5 = fighterSquadron.getNFighters();
        this.armorAreas.setVisible(true);
        this.armorLabels.setVisible(true);
        this.armorNameLabel.setVisible(true);
        for (n = 0; n < n4; ++n) {
            this.unitAreas[n].setVisible(true);
            this.deadUnit[n].setVisible(false);
        }
        for (n = n4; n < FighterSquadron.MAX_SIZE; ++n) {
            this.unitAreas[n].setVisible(false);
            this.deadUnit[n].setVisible(false);
        }
        n2 = fighterSquadron.getArmor() < 0 ? 0 : fighterSquadron.getArmor();
        n3 = fighterSquadron.getTotalOArmor();
        this.armorLabels.setValue(Integer.toString(n2));
        this.armorNameLabel.setValue("Armor:");
        this.vLabels[0].setValue(this.getCriticalHitTally(fighterSquadron.getAvionicsHits(), 3));
        this.vLabels[1].setValue(this.getCriticalHitTally(fighterSquadron.getEngineHits(), fighterSquadron.getMaxEngineHits()));
        this.vLabels[2].setValue(this.getCriticalHitTally(fighterSquadron.getFCSHits(), 3));
        this.vLabels[3].setValue(this.getCriticalHitTally(fighterSquadron.getSensorHits(), 3));
        this.drawArmorImage(this.armorImage, n2, n3);
        for (n = 0; n < n4; ++n) {
            if (n < n5) continue;
            this.deadUnit[n].setVisible(true);
        }
    }

    private void setBackGround() {
        Image image = this.comp.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this.comp);
        int n = 8;
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 20;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 68;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 258;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 273;
        image = this.comp.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 321;
        image = this.comp.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.comp.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.comp.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
    }

    private void drawArmorImage(Image image, int n, int n2) {
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, n3, n4);
        int n5 = (int)Math.ceil(120.0 * (double)n / (double)n2);
        graphics.setColor(Color.green.darker());
        graphics.fillRect(0, 0, n5, 12);
    }

    private String getCriticalHitTally(int n, int n2) {
        String string = "";
        if (n < 1) {
            return string;
        }
        if (n >= n2) {
            string = "Out";
            return string;
        }
        while (n > 0) {
            string = string + "X";
            --n;
        }
        return string;
    }
}

