/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.Vector;
import megamek.common.Aero;
import megamek.common.Bay;
import megamek.common.Entity;
import megamek.common.FighterSquadron;
import megamek.common.Jumpship;
import megamek.common.SmallCraft;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ASFBay
extends Bay {
    Vector<Integer> recoverySlots = new Vector();

    protected ASFBay() {
        this.totalSpace = 0;
        this.currentSpace = 0;
    }

    public ASFBay(int n, int n2) {
        this.totalSpace = n;
        this.currentSpace = n;
        this.doors = n2;
        this.doorsNext = n2;
        this.recoverySlots = this.initializeRecoverySlots();
    }

    @Override
    public boolean canLoad(Entity entity) {
        boolean bl = false;
        if (entity instanceof Aero && !(entity instanceof FighterSquadron) && !(entity instanceof SmallCraft) && !(entity instanceof Jumpship)) {
            bl = true;
        }
        if (this.currentSpace < 1) {
            bl = false;
        }
        if (this.getRecoverySlots() < 1) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void load(Entity entity) throws IllegalArgumentException {
        if (!this.canLoad(entity)) {
            throw new IllegalArgumentException("Can not load " + entity.getShortName() + " into this bay. " + this.currentSpace);
        }
        --this.currentSpace;
        this.troops.addElement(entity);
    }

    public void recover(Entity entity) throws IllegalArgumentException {
        if (!this.canLoad(entity)) {
            throw new IllegalArgumentException("Can not recover " + entity.getShortName() + " into this bay. " + this.currentSpace);
        }
        --this.currentSpace;
        this.closeSlot();
        this.troops.addElement(entity);
    }

    @Override
    public String getUnusedString() {
        return "Aerospace Fighter - " + this.currentSpace + " units (" + this.getRecoverySlots() + " recovery open)";
    }

    @Override
    public String getType() {
        return "Fighter";
    }

    public void updateSlots() {
        if (this.recoverySlots.size() < 1) {
            return;
        }
        for (int i = this.recoverySlots.size() - 1; i >= 0; --i) {
            if (this.recoverySlots.elementAt(i) <= 0) continue;
            int n = this.recoverySlots.elementAt(i) - 1;
            this.recoverySlots.remove(i);
            this.recoverySlots.add(n);
        }
    }

    public Vector<Integer> initializeRecoverySlots() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.doors; ++i) {
            vector.add(0);
            vector.add(0);
        }
        return vector;
    }

    public int getRecoverySlots() {
        int n = 0;
        if (null == this.recoverySlots) {
            return n;
        }
        for (int i = 0; i < this.recoverySlots.size(); ++i) {
            if (this.recoverySlots.elementAt(i) != 0) continue;
            ++n;
        }
        return n;
    }

    public void closeSlot() {
        for (int i = 0; i < this.recoverySlots.size(); ++i) {
            if (this.recoverySlots.elementAt(i) != 0) continue;
            this.recoverySlots.remove(i);
            this.recoverySlots.add(5);
            break;
        }
    }

    @Override
    public void destroyDoorNext() {
        this.setDoorsNext(this.getDoorsNext() - 1);
        if (this.recoverySlots.size() > 0) {
            this.recoverySlots.remove(0);
        }
        if (this.recoverySlots.size() > 0) {
            this.recoverySlots.remove(0);
        }
    }

    @Override
    public void destroyDoor() {
        --this.doors;
        if (this.recoverySlots.size() > 0) {
            this.recoverySlots.remove(0);
        }
        if (this.recoverySlots.size() > 0) {
            this.recoverySlots.remove(0);
        }
    }

    @Override
    public int getDoors() {
        return (int)Math.floor((double)this.getRecoverySlots() / 2.0);
    }
}

