/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import megamek.common.Entity;
import megamek.common.Transporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bay
implements Transporter {
    int doors = 1;
    int doorsNext = 1;
    Vector<Integer> recoverySlots = new Vector();
    Vector<Entity> troops = new Vector();
    int totalSpace;
    int currentSpace;

    protected Bay() {
        this.totalSpace = 0;
        this.currentSpace = 0;
    }

    public Bay(int n, int n2) {
        this.totalSpace = n;
        this.currentSpace = n;
        this.doors = n2;
        this.doorsNext = n2;
    }

    public int getDoors() {
        return this.doors;
    }

    public void setDoors(int n) {
        this.doors = n;
        this.doorsNext = n;
    }

    public void setDoorsNext(int n) {
        this.doorsNext = n;
    }

    public int getDoorsNext() {
        return this.doorsNext;
    }

    public void resetDoors() {
        this.doors = this.doorsNext;
    }

    @Override
    public boolean canLoad(Entity entity) {
        boolean bl = true;
        if (this.currentSpace < 1) {
            bl = false;
        }
        if (this.doors < 1) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void load(Entity entity) throws IllegalArgumentException {
        if (!this.canLoad(entity)) {
            throw new IllegalArgumentException("Can not load " + entity.getShortName() + " into this bay. " + this.currentSpace);
        }
        --this.currentSpace;
        this.troops.addElement(entity);
    }

    @Override
    public Vector<Entity> getLoadedUnits() {
        return (Vector)this.troops.clone();
    }

    public Vector<Entity> getLaunchableUnits() {
        Vector<Entity> vector = new Vector<Entity>();
        for (int i = 0; i < this.troops.size(); ++i) {
            Entity entity = this.troops.elementAt(i);
            if (entity.getRecoveryTurn() != 0) continue;
            vector.add(entity);
        }
        return vector;
    }

    @Override
    public boolean unload(Entity entity) {
        if (this.doors < 1) {
            return false;
        }
        boolean bl = this.troops.removeElement(entity);
        if (bl) {
            ++this.currentSpace;
        }
        return bl;
    }

    @Override
    public String getUnusedString() {
        return " - " + this.currentSpace + " units";
    }

    @Override
    public boolean isWeaponBlockedAt(int n, boolean bl) {
        return false;
    }

    @Override
    public Entity getExteriorUnitAt(int n, boolean bl) {
        return null;
    }

    @Override
    public final List<Entity> getExternalUnits() {
        ArrayList<Entity> arrayList = new ArrayList<Entity>(1);
        return arrayList;
    }

    @Override
    public int getCargoMpReduction() {
        return 0;
    }

    public String getType() {
        return "Unknown";
    }

    public void destroyDoorNext() {
        this.setDoorsNext(this.getDoorsNext() - 1);
    }

    public void destroyDoor() {
        this.setDoors(this.getDoors() - 1);
    }
}

