/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.Coords;
import megamek.common.IBoard;
import megamek.common.IHex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Building
implements Serializable {
    private static final long serialVersionUID = -8236017592012683793L;
    private int id = -1;
    private Vector<Coords> coordinates = new Vector();
    private int type = -1;
    private int currentCF = -1;
    private int phaseCF = -1;
    private String name = null;
    private boolean burning = false;
    private ArrayList<DemolitionCharge> demolitionCharges = new ArrayList();
    protected static final int UNKNOWN = -1;
    public static final int LIGHT = 1;
    public static final int MEDIUM = 2;
    public static final int HEAVY = 3;
    public static final int HARDENED = 4;
    public static final int WALL = 5;

    protected void include(Coords coords, IBoard iBoard, int n) {
        int n2;
        if (this.isIn(coords)) {
            return;
        }
        IHex iHex = iBoard.getHex(coords);
        if (null == iHex || !iHex.containsTerrain(n)) {
            return;
        }
        if (n == 10) {
            if (this.type != iHex.terrainLevel(10)) {
                throw new IllegalArgumentException("The coordinates, " + coords.getBoardNum() + ", should contain the same type of building as " + this.coordinates.elementAt(0).getBoardNum());
            }
            n2 = iHex.containsTerrain(11) ? 1 : 0;
            if (n2 != 0 && this.currentCF != iHex.terrainLevel(11) || n2 == 0 && this.currentCF != Building.getDefaultCF(this.type)) {
                throw new IllegalArgumentException("The coordinates, " + coords.getBoardNum() + ", should contain a building with the same CF as " + this.coordinates.elementAt(0).getBoardNum());
            }
        }
        this.coordinates.addElement(coords);
        for (n2 = 0; n2 < 6; ++n2) {
            if (!iHex.containsTerrainExit(n, n2)) continue;
            this.include(coords.translated(n2), iBoard, n);
        }
    }

    public Building(Coords coords, IBoard iBoard, int n) {
        this.id = coords.hashCode();
        this.coordinates.addElement(coords);
        IHex iHex = iBoard.getHex(coords);
        if (!iHex.containsTerrain(n)) {
            throw new IllegalArgumentException("The coordinates, " + coords.getBoardNum() + ", do not contain a building.");
        }
        this.type = iHex.terrainLevel(n);
        this.currentCF = Building.getDefaultCF(this.type);
        if (this.currentCF == -1) {
            throw new IllegalArgumentException("Unknown construction type: " + this.type + ".  The board is invalid.");
        }
        if (n == 10 && iHex.containsTerrain(11)) {
            this.currentCF = iHex.terrainLevel(11);
        }
        if (n == 14 && iHex.containsTerrain(15)) {
            this.currentCF = iHex.terrainLevel(15);
        }
        this.phaseCF = this.currentCF;
        for (int i = 0; i < 6; ++i) {
            if (!iHex.containsTerrainExit(n, i)) continue;
            this.include(coords.translated(i), iBoard, n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 33) {
            stringBuffer.append("Fuel Tank #");
        } else if (this.getType() == 5) {
            stringBuffer.append("Wall #");
        } else if (n == 10) {
            stringBuffer.append("Building #");
        } else if (n == 14) {
            stringBuffer.append("Bridge #");
        } else {
            stringBuffer.append("Structure #");
        }
        stringBuffer.append(this.id);
        this.name = stringBuffer.toString();
    }

    public Building(int n, int n2, String string, Vector<Coords> vector) {
        this.type = n;
        this.id = n2;
        this.name = string;
        this.coordinates = vector;
        this.phaseCF = this.currentCF = Building.getDefaultCF(this.type);
        if (this.currentCF == -1) {
            throw new IllegalArgumentException("Invalid construction type: " + this.type + ".");
        }
    }

    public int getId() {
        return this.id;
    }

    public boolean isIn(Coords coords) {
        return this.coordinates.contains(coords);
    }

    public Enumeration<Coords> getCoords() {
        return this.coordinates.elements();
    }

    public int getType() {
        return this.type;
    }

    public int getCurrentCF() {
        return this.currentCF;
    }

    public int getPhaseCF() {
        return this.phaseCF;
    }

    public void setCurrentCF(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid value for Construction Factor: " + n);
        }
        this.currentCF = n;
    }

    public void setPhaseCF(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid value for Construction Factor: " + n);
        }
        this.phaseCF = n;
    }

    public String getName() {
        return this.name;
    }

    public static int getDefaultCF(int n) {
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = 15;
                break;
            }
            case 2: {
                n2 = 40;
                break;
            }
            case 3: {
                n2 = 90;
                break;
            }
            case 4: 
            case 5: {
                n2 = 120;
            }
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Building)) {
            return false;
        }
        Building building = (Building)object;
        return this.id == building.id;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.getType()) {
            case 1: {
                stringBuffer.append("Light ");
                break;
            }
            case 2: {
                stringBuffer.append("Medium ");
                break;
            }
            case 3: {
                stringBuffer.append("Heavy ");
                break;
            }
            case 4: {
                stringBuffer.append("Hardened ");
                break;
            }
            case 5: {
                stringBuffer.append("");
            }
        }
        stringBuffer.append(this.name);
        return stringBuffer.toString();
    }

    public boolean isBurning() {
        return this.burning;
    }

    public void setBurning(boolean bl) {
        this.burning = bl;
    }

    public void addDemolitionCharge(int n, int n2) {
        DemolitionCharge demolitionCharge = new DemolitionCharge(n, n2);
        this.demolitionCharges.add(demolitionCharge);
    }

    public class DemolitionCharge
    implements Serializable {
        private static final long serialVersionUID = -6655782801564155668L;
        public int damage;
        public int playerId;

        public DemolitionCharge(int n, int n2) {
            this.damage = n2;
            this.playerId = n;
        }
    }
}

