/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import megamek.common.Entity;
import megamek.common.Transporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockingCollar
implements Transporter {
    Vector<Entity> troops = new Vector();
    private boolean damaged = false;
    int totalSpace;
    int currentSpace;

    protected DockingCollar() {
        this.totalSpace = 0;
        this.currentSpace = 0;
    }

    public DockingCollar(int n) {
        this.totalSpace = 1;
        this.currentSpace = 1;
    }

    @Override
    public boolean canLoad(Entity entity) {
        boolean bl = false;
        return bl;
    }

    @Override
    public void load(Entity entity) throws IllegalArgumentException {
        if (!this.canLoad(entity)) {
            throw new IllegalArgumentException("Can not load " + entity.getShortName() + " into this bay.");
        }
        --this.currentSpace;
        this.troops.addElement(entity);
    }

    @Override
    public Vector<Entity> getLoadedUnits() {
        return (Vector)this.troops.clone();
    }

    @Override
    public boolean unload(Entity entity) {
        if (this.isDamaged()) {
            return false;
        }
        boolean bl = this.troops.removeElement(entity);
        if (bl) {
            ++this.currentSpace;
        }
        return bl;
    }

    @Override
    public String getUnusedString() {
        return "Dropship - " + this.currentSpace + " units";
    }

    @Override
    public boolean isWeaponBlockedAt(int n, boolean bl) {
        return false;
    }

    @Override
    public Entity getExteriorUnitAt(int n, boolean bl) {
        return null;
    }

    @Override
    public final List<Entity> getExternalUnits() {
        ArrayList<Entity> arrayList = new ArrayList<Entity>(1);
        return arrayList;
    }

    @Override
    public int getCargoMpReduction() {
        return 0;
    }

    public boolean isDamaged() {
        return this.damaged;
    }

    public void setDamaged(boolean bl) {
        this.damaged = bl;
    }
}

