/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.LocationFullException;
import megamek.common.Mounted;
import megamek.common.MoveStep;
import megamek.common.PilotingRollData;
import megamek.common.Report;
import megamek.common.WeaponType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Infantry
extends Entity
implements Serializable {
    private static final long serialVersionUID = -8706716079307721282L;
    private int menStarting = 0;
    private int menShooting = 0;
    private int men = 0;
    private static final int[] NUM_OF_SLOTS = new int[]{0};
    private static final String[] LOCATION_ABBRS = new String[]{"Men"};
    private static final String[] LOCATION_NAMES = new String[]{"Men"};
    private boolean antiMek = false;
    protected int runMP = 1;
    public int turnsLayingExplosives = -1;
    public static final int DUG_IN_NONE = 0;
    public static final int DUG_IN_WORKING = 1;
    public static final int DUG_IN_COMPLETE = 2;
    public static final int DUG_IN_FORTIFYING1 = 3;
    public static final int DUG_IN_FORTIFYING2 = 4;
    private int dugIn = 0;
    public static final int INF_PLT_MAX_MEN = 30;
    public static final int INF_PLT_FOOT_MAX_MEN = 21;
    public static final int INF_PLT_JUMP_MAX_MEN = 21;
    public static final int INF_PLT_CLAN_MAX_MEN = 25;
    public static final int LOC_INFANTRY = 0;
    public static final String LEG_ATTACK = "LegAttack";
    public static final String SWARM_MEK = "SwarmMek";
    public static final String STOP_SWARM = "StopSwarm";

    @Override
    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    @Override
    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    @Override
    public int locations() {
        return 1;
    }

    public Infantry() {
        this.setMovementMode(10);
        this.setOriginalWalkMP(1);
    }

    @Override
    public boolean canChangeSecondaryFacing() {
        return this.dugIn == 0;
    }

    @Override
    public boolean isValidSecondaryFacing(int n) {
        return true;
    }

    @Override
    public int clipSecondaryFacing(int n) {
        return n;
    }

    @Override
    public int getRunMP(boolean bl, boolean bl2) {
        if (bl) {
            return this.applyGravityEffectsOnMP(this.getOriginalRunMP());
        }
        return this.getOriginalRunMP();
    }

    @Override
    public int getRunMPwithoutMASC(boolean bl, boolean bl2) {
        return this.getRunMP(bl, bl2);
    }

    @Override
    protected int getOriginalRunMP() {
        return this.runMP;
    }

    @Override
    public boolean isHexProhibited(IHex iHex) {
        if (iHex.containsTerrain(31)) {
            return true;
        }
        if (iHex.containsTerrain(24)) {
            return true;
        }
        if (iHex.containsTerrain(30) && this.doomedInSpace()) {
            return true;
        }
        if (iHex.terrainLevel(1) > 0) {
            if (iHex.terrainLevel(1) > 1 && this.getMovementMode() == 3) {
                return true;
            }
            if (this.getMovementMode() == 5 || this.getMovementMode() == 4) {
                return true;
            }
        }
        if (iHex.terrainLevel(4) > 0 && !iHex.containsTerrain(20)) {
            return this.getMovementMode() != 5 && this.getMovementMode() != 18 && this.getMovementMode() != 6;
        }
        return false;
    }

    @Override
    public String getMovementString(int n) {
        switch (n) {
            case 0: {
                return "None";
            }
            case 1: 
            case 2: {
                switch (this.getMovementMode()) {
                    case 10: {
                        return "Walked";
                    }
                    case 11: {
                        return "Biked";
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        return "Drove";
                    }
                }
                return "Unknown!";
            }
            case 4: 
            case 5: {
                return "Flew";
            }
            case 3: {
                return "Jumped";
            }
        }
        return "Unknown!";
    }

    @Override
    public String getMovementAbbr(int n) {
        switch (n) {
            case 0: {
                return "N";
            }
            case 1: {
                return "W";
            }
            case 2: {
                switch (this.getMovementMode()) {
                    case 10: {
                        return "R";
                    }
                    case 11: {
                        return "B";
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        return "D";
                    }
                }
                return "?";
            }
            case 3: {
                return "J";
            }
        }
        return "?";
    }

    @Override
    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        return this.rollHitLocation(n, n2);
    }

    @Override
    public HitData rollHitLocation(int n, int n2) {
        return new HitData(0);
    }

    @Override
    public HitData getTransferLocation(HitData hitData) {
        return new HitData(-2);
    }

    @Override
    public int getDependentLocation(int n) {
        return -1;
    }

    @Override
    public boolean hasRearArmor(int n) {
        return false;
    }

    protected boolean isPlatoon() {
        return true;
    }

    @Override
    public int getInternal(int n) {
        if (!this.isPlatoon()) {
            return super.getInternal(n);
        }
        return this.men > 0 ? this.men : -3;
    }

    @Override
    public int getOInternal(int n) {
        if (!this.isPlatoon()) {
            return super.getOInternal(n);
        }
        return this.menStarting;
    }

    @Override
    public void setInternal(int n, int n2) {
        super.setInternal(n, n2);
        this.men = n;
    }

    @Override
    public double getInternalRemainingPercent() {
        if (!this.isPlatoon()) {
            return super.getInternalRemainingPercent();
        }
        int n = this.men > 0 ? this.men : 0;
        return (double)n / (double)this.menStarting;
    }

    @Override
    public void initializeInternal(int n, int n2) {
        this.menStarting = n;
        this.menShooting = n;
        super.initializeInternal(n, n2);
    }

    @Override
    public void autoSetInternal() {
        if (this.isClan()) {
            this.initializeInternal(25, 0);
            return;
        }
        switch (this.getMovementMode()) {
            case 10: 
            case 11: {
                this.initializeInternal(21, 0);
                break;
            }
            case 12: {
                this.initializeInternal(21, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
            }
        }
        if (this.hasWorkingMisc(0x100000L, 16)) {
            this.initializeArmor(this.getOInternal(0), 0);
        }
    }

    @Override
    protected void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        EquipmentType equipmentType = mounted.getType();
        if (SWARM_MEK.equals(equipmentType.getInternalName())) {
            this.antiMek = true;
        } else if (LEG_ATTACK.equals(equipmentType.getInternalName()) || STOP_SWARM.equals(equipmentType.getInternalName())) {
            // empty if block
        }
        super.addEquipment(mounted, n, bl);
    }

    @Override
    public int getWeaponArc(int n) {
        if (this instanceof BattleArmor && this.dugIn == 0) {
            return 0;
        }
        Mounted mounted = this.getEquipment(n);
        WeaponType weaponType = (WeaponType)mounted.getType();
        if ((weaponType.hasFlag(2048L) || weaponType.hasFlag(0x20000000L) || weaponType.getInternalName() == LEG_ATTACK || weaponType.getInternalName() == SWARM_MEK || weaponType.getInternalName() == STOP_SWARM) && this.dugIn == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isSecondaryArcWeapon(int n) {
        if (this instanceof BattleArmor) {
            return false;
        }
        Mounted mounted = this.getEquipment(n);
        WeaponType weaponType = (WeaponType)mounted.getType();
        return !weaponType.hasFlag(2048L);
    }

    @Override
    public int getHeatCapacity() {
        return 999;
    }

    @Override
    public int getHeatCapacityWithWater() {
        return this.getHeatCapacity();
    }

    @Override
    public int getEngineCritHeat() {
        return 0;
    }

    @Override
    protected int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    public boolean hasHittableCriticals(int n) {
        return false;
    }

    @Override
    public int calculateBattleValue() {
        double d = (double)this.getInternal(-1) * 1.5;
        int n = Compute.getTargetMovementModifier(this.getRunMP(false, true), false, false).getValue();
        int n2 = Compute.getTargetMovementModifier(this.getJumpMP(false), true, false).getValue();
        double d2 = Math.max(n, n2);
        double d3 = 1.0 + d2 / 10.0;
        d *= d3;
        double d4 = (long)this.getRunMP(false, true) + Math.round((double)this.getJumpMP(false) / 2.0);
        double d5 = d4 > 25.0 ? Math.pow(1.0 + ((double)this.runMP + (double)Math.round((double)this.getJumpMP(false) / 2.0) - 5.0) / 10.0, 1.2) : Math.pow(1.0 + (d4 - 5.0) / 10.0, 1.2);
        d5 = (double)Math.round(d5 * 100.0) / 100.0;
        ArrayList<Mounted> arrayList = this.getWeaponList();
        double d6 = 0.0;
        for (Mounted mounted : arrayList) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (SWARM_MEK.equals(weaponType.getInternalName())) continue;
            if (mounted.getType().hasFlag(2048L)) {
                d6 += weaponType.getBV(this) * (double)this.getInternal(-1) * (double)(this.antiMek ? 2 : 0);
                continue;
            }
            d6 += weaponType.getBV(this);
        }
        double d7 = d6 * d5;
        int n3 = (int)Math.round(d7 + d);
        double d8 = this.crew.getBVSkillMultiplier();
        return (int)Math.round((double)n3 * d8);
    }

    @Override
    public Vector<Report> victoryReport() {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(7025);
        report.type = 0;
        report.addDesc(this);
        vector.addElement(report);
        report = new Report(7040);
        report.type = 0;
        report.newlines = 0;
        vector.addElement(report);
        vector.addAll(this.crew.getDescVector(true));
        report = new Report(7070, 0);
        report.add(this.getKillNumber());
        vector.addElement(report);
        if (this.isDestroyed()) {
            Entity entity = this.game.getEntity(this.killerId);
            if (entity == null) {
                entity = this.game.getOutOfGameEntity(this.killerId);
            }
            if (entity != null) {
                report = new Report(7072, 0);
                report.addDesc(entity);
            } else {
                report = new Report(7073, 0);
            }
            vector.addElement(report);
        }
        report.newlines = 2;
        return vector;
    }

    @Override
    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        return pilotingRollData;
    }

    @Override
    public int getMaxElevationChange() {
        return 1;
    }

    @Override
    public void applyDamage() {
        super.applyDamage();
        this.menShooting = this.men;
    }

    public int getShootingStrength() {
        return this.menShooting;
    }

    @Override
    public boolean canCharge() {
        return false;
    }

    @Override
    public boolean canDFA() {
        return false;
    }

    @Override
    public PilotingRollData checkSwampMove(MoveStep moveStep, IHex iHex, Coords coords, Coords coords2, boolean bl) {
        PilotingRollData pilotingRollData = new PilotingRollData(this.getId(), 5, "entering boggy terrain");
        if (!coords.equals(coords2) && moveStep.getMovementType() != 3 && this.getMovementMode() != 5 && this.getMovementMode() != 6 && moveStep.getElevation() == 0 && !bl) {
            if (iHex.containsTerrain(9)) {
                pilotingRollData.append(new PilotingRollData(this.getId(), 0, "entering Swamp"));
            } else if (iHex.containsTerrain(24) || iHex.containsTerrain(25) || iHex.containsTerrain(28) || iHex.containsTerrain(29)) {
                pilotingRollData.append(new PilotingRollData(this.getId(), -1, "avoid bogging down"));
            } else {
                pilotingRollData.addModifier(-2147483647, "Check false: no swamp-like terrain present");
            }
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Not entering swamp, or jumping/hovering over the swamp");
        }
        return pilotingRollData;
    }

    public void setOriginalRunMP(int n) {
        this.runMP = n;
    }

    @Override
    public double getCost() {
        double d = 0.0;
        double d2 = 0.0;
        int n = this.getMovementMode();
        if (4 == n || 3 == n || 5 == n) {
            n = 11;
        }
        d2 = this.antiMek ? 5.0 : 1.0;
        if (18 == n) {
            n = 10;
            d2 *= 2.0;
        }
        return d * d2;
    }

    @Override
    public boolean doomedInVacuum() {
        return false;
    }

    @Override
    public boolean doomedOnGround() {
        return false;
    }

    @Override
    public boolean doomedInAtmosphere() {
        return true;
    }

    @Override
    public boolean doomedInSpace() {
        return true;
    }

    @Override
    public boolean canAssaultDrop() {
        return this.game.getOptions().booleanOption("paratroopers");
    }

    @Override
    public boolean isEligibleFor(IGame.Phase phase) {
        if (this.turnsLayingExplosives > 0 && phase != IGame.Phase.PHASE_PHYSICAL) {
            return false;
        }
        if (this.dugIn != 2 && this.dugIn != 0) {
            return false;
        }
        return super.isEligibleFor(phase);
    }

    @Override
    public void newRound(int n) {
        if (this.turnsLayingExplosives >= 0) {
            ++this.turnsLayingExplosives;
            if (!Compute.isInBuilding(this.game, this)) {
                this.turnsLayingExplosives = -1;
            }
        }
        if (this.dugIn != 2 && this.dugIn != 0) {
            ++this.dugIn;
            if (this.dugIn > 4) {
                this.dugIn = 0;
            }
        }
        super.newRound(n);
    }

    @Override
    public boolean loadWeapon(Mounted mounted, Mounted mounted2) {
        if (!(this instanceof BattleArmor || mounted.getLinked() == null && mounted2.getLinkedBy() == null)) {
            return false;
        }
        return super.loadWeapon(mounted, mounted2);
    }

    @Override
    public boolean loadWeaponWithSameAmmo(Mounted mounted, Mounted mounted2) {
        if (!(this instanceof BattleArmor || mounted.getLinked() == null && mounted2.getLinkedBy() == null)) {
            return false;
        }
        return super.loadWeaponWithSameAmmo(mounted, mounted2);
    }

    public void setDugIn(int n) {
        this.dugIn = n;
    }

    public int getDugIn() {
        return this.dugIn;
    }

    @Override
    public boolean isNuclearHardened() {
        return false;
    }

    public void setTransportID(int n) {
        super.setTransportId(n);
        this.setDugIn(0);
    }

    public boolean isAntiMek() {
        return this.antiMek;
    }

    public boolean isMechanized() {
        return this.getMovementMode() == 4 || this.getMovementMode() == 5 || this.getMovementMode() == 3;
    }
}

